//
// This plugin was created by PeterT for use with MiniMod v. 0.7
// or later. The concept is original but much of the code herein
// is not. This plugin also relies on two other MiniMod plugins,
// or their equivalent code in whichever mod you are adapting:
//	Tricon's Springboard, and
//	Z-Tek's Phaselok Turret
//
// The mod creates four additional packs, that will appear in the
// inventory list under the heading "Converter Packs". Each pack
// will, when activated, convert the wearer's grenades, beacons and
// mines into other items. When turned off, normal grenades, beacons
// and mines are available.
//
// This plugin is NOT compatible with Renegades, Shifter, hvTactical,
// Ideal or any other mod which already has multiple grenade, beacon
// or mine types. It is compatible with Orion 2.4 (on which I
// developed it) and presumably with Base.
//
// Here are the details of the packs.
//
// Sensor Pack - Useable by light and medium armours, including
//		 the Engineer if present. Useful for laying down
//		 a decent sensor array, either in the field or
//		 in and around your base.
//
//	Grenade: Pulse Sensor
//	Beacon: Camera
//	Mine: Motion Sensor
//
// Assault Pack - Useable by medium and heavy armours. Useful for
//		  base-storming, especially when the bases are off
//		  the ground.
//
//	Grenade: EMP Grenade
//	Beacon: Emergency Shield
//	Mine: Springboard
//
// Saboteur Pack - Useable by light and medium armours, but not
//		   the Engineer if present. Useful for wreaking
//		   havoc inside an enemy base. A good pack for
//		   those who enjoy indirect damage.
//
//	Grenade: Plastique (15 second timer)
//	Beacon: Satchel Charge
//	Mine: Replicating Mine
//
// Defence Pack - Useable by the Light armour and the Engineer, if
//		  present. Useful for quickly laying down defences
//		  around a remote inventory station or sniper roost,
//		  or within your base.
//
//	Grenade: Hologram Mine
//	Beacon: Phaselok Turret
//	Mine: Sensor Jammer
//
// Of all the above devices, the code for the following has been
// ripped from the mods indicated and included in this plugin. Bear
// in mind that these mods may in turn have been borrowed their code
// from elsewhere, so tracing an idea back to its originator is
// not as easy as it looks.
//
//	Pulse Sensor - Shifter
//	EMP Grenade - hvTactical
//	Emergency Shield - Shifter
//	Plastique - Shifter
//	Satchel Charge - Shifter
//	Replicating Mine - Ideal
//	Hologram Mine: Renegades
//
function Client::takeControl(%clientId, %objectId)
{
   // remote control
   if(%objectId == -1)
   {
      //echo("objectId = " @ %objectId);
      return;
   }

	%pl = Client::getOwnedObject(%clientId);
	// If mounted to a vehicle then can't mount any other objects
	if(%pl.driver != "" || %pl.vehicleSlot != "")
		return;

   if(GameBase::getTeam(%objectId) != Client::getTeam(%clientId))
   {
      //echo(GameBase::getTeam(%objectId) @ " " @ Client::getTeam(%clientId));
      return;
   }
   if(GameBase::getControlClient(%objectId) != -1)
   {
      echo("Ctrl Client = " @ GameBase::getControlClient(%objectId));
      return;
   }
	%name = GameBase::getDataName(%objectId);
//	if(%name != CameraTurret && %name != DeployableTurret && %name != DeployableSatchel && %name != DeployableChaingun && %name != DeployableSeeker && %name != DeployableFlak && %name != DeployableConTurret && %name != FlameTurret && %name != DeployablePhaseLok && %name != DeployableMiniPlasma && %name != DeployableAntiMatterTurret)
	if(%name != CameraTurret && %name != FlameTurret && (String::findSubStr(%name, "Deployable") < 0))
   {
	   if(!GameBase::isPowered(%objectId)) 
		{
	      // echo("Turret " @ %objectId @ " not powered.");
	      return;
		}
   }
%player = Client::getOwnedObject(%clientId);
if(Player::getMountedItem(%player,$BackpackSlot) != Laptop)
{
   if(!(Client::getOwnedObject(%clientId)).CommandTag && GameBase::getDataName(%objectId) != CameraTurret  && GameBase::getDataName(%objectId) != DeployableSatchel &&
      !$TestCheats) {
		Client::SendMessage(%clientId,0,"Must be at a Command Station or Laptop to control turrets");
   		return;
   }
}
   if(GameBase::getDamageState(%objectId) == "Enabled") {
   	Client::setControlObject(%clientId, %objectId);
   	Client::setGuiMode(%clientId, $GuiModePlay);
	}
}

function Player::onDamage(%this,%type,%value,%pos,%vec,%mom,%vertPos,%quadrant,%object)
{
	if (Player::isExposed(%this)) {
      %damagedClient = Player::getClient(%this);
      %shooterClient = %object;

		Player::applyImpulse(%this,%mom);
		if($teamplay && %damagedClient != %shooterClient && Client::getTeam(%damagedClient) == Client::getTeam(%shooterClient) ) {
			if (%shooterClient != -1) {
				%curTime = getSimTime();
			   if ((%curTime - %this.DamageTime > 3.5 || %this.LastHarm != %shooterClient) && %damagedClient != %shooterClient && $Server::TeamDamageScale > 0) {
					if(%type != $MineDamageType) {
						Client::sendMessage(%shooterClient,0,"You just harmed Teammate " @ Client::getName(%damagedClient) @ "!");
						Client::sendMessage(%damagedClient,0,"You took Friendly Fire from " @ Client::getName(%shooterClient) @ "!");
					}
					else {
						Client::sendMessage(%shooterClient,0,"You just harmed Teammate " @ Client::getName(%damagedClient) @ " with your mine!");
						Client::sendMessage(%damagedClient,0,"You just stepped on Teamate " @ Client::getName(%shooterClient) @ "'s mine!");
					}
					%this.LastHarm = %shooterClient;
					%this.DamageStamp = %curTime;
				}
			}
			%friendFire = $Server::TeamDamageScale;
		}
		else if(%type == $ImpactDamageType && Client::getTeam(%object.clLastMount) == Client::getTeam(%damagedClient)) 
			%friendFire = $Server::TeamDamageScale;
		else  
			%friendFire = 1.0;	

		if (!Player::isDead(%this)) {
			%armor = Player::getArmor(%this);
			//More damage applyed to head shots
			if(%vertPos == "head" && (%type == $LaserDamageType || %type == $SniperDamageType)) {
				if(%armor == "harmor") { 
					if(%quadrant == "middle_back" || %quadrant == "middle_front" || %quadrant == "middle_middle") {
						%value += (%value * 0.3);
					}
				}
				else {
					%value += (%value * 0.3);
				}
			}
			//If Shield Pack is on
			if (%type != -1 && %this.shieldStrength) {
				%energy = GameBase::getEnergy(%this);
				%strength = %this.shieldStrength;
				if (%type == $ShrapnelDamageType || %type == $MortarDamageType)
					%strength *= 0.75;
				%absorb = %energy * %strength;
				if (%value < %absorb) {
					GameBase::setEnergy(%this,%energy - ((%value / %strength)*%friendFire));
					%thisPos = getBoxCenter(%this);
					%offsetZ =((getWord(%pos,2))-(getWord(%thisPos,2)));
					GameBase::activateShield(%this,%vec,%offsetZ);
					%value = 0;
				}
				else {
					GameBase::setEnergy(%this,0);
					%value = %value - %absorb;
				}
			}
//============================================================================= Flash Damage Does EMP Effect

 if (%type == $EMPDamageType) Insomniax_startEMP(%damagedClient, %this, %shooterClient); 

//============================================================================= End of EMP Section
  			if (%value) {
				%value = $DamageScale[%armor, %type] * %value * %friendFire;
            %dlevel = GameBase::getDamageLevel(%this) + %value;
            %spillOver = %dlevel - %armor.maxDamage;
				GameBase::setDamageLevel(%this,%dlevel);
				%flash = Player::getDamageFlash(%this) + %value * 2;
				if (%flash > 0.75) 
					%flash = 0.75;
				Player::setDamageFlash(%this,%flash);
				//If player not dead then play a random hurt sound
				if(!Player::isDead(%this)) { 
					if(%damagedClient.lastDamage < getSimTime()) {
						%sound = radnomItems(3,injure1,injure2,injure3);
						playVoice(%damagedClient,%sound);
						%damagedClient.lastdamage = getSimTime() + 1.5;
					}
				}
				else {
               if(%spillOver > 0.5 && (%type== $ExplosionDamageType || %type == $ShrapnelDamageType || %type== $MortarDamageType|| %type == $MissileDamageType)) {
		 				Player::trigger(%this, $WeaponSlot, false);
						%weaponType = Player::getMountedItem(%this,$WeaponSlot);
						if(%weaponType != -1)
							Player::dropItem(%this,%weaponType);
                	Player::blowUp(%this);
					}
					else
					{
						if ((%value > 0.40 && (%type== $ExplosionDamageType || %type == $ShrapnelDamageType || %type== $MortarDamageType || %type == $MissileDamageType )) || (Player::getLastContactCount(%this) > 6) ) {
					  		if(%quadrant == "front_left" || %quadrant == "front_right") 
								%curDie = $PlayerAnim::DieBlownBack;
							else
								%curDie = $PlayerAnim::DieForward;
						}
						else if( Player::isCrouching(%this) ) 
							%curDie = $PlayerAnim::Crouching;							
						else if(%vertPos=="head") {
							if(%quadrant == "front_left" ||	%quadrant == "front_right"	) 
								%curDie = radnomItems(2, $PlayerAnim::DieHead, $PlayerAnim::DieBack);
						  	else 
								%curDie = radnomItems(2, $PlayerAnim::DieHead, $PlayerAnim::DieForward);
						}
						else if (%vertPos == "torso") {
							if(%quadrant == "front_left" ) 
								%curDie = radnomItems(3, $PlayerAnim::DieLeftSide, $PlayerAnim::DieChest, $PlayerAnim::DieForwardKneel);
							else if(%quadrant == "front_right") 
								%curDie = radnomItems(3, $PlayerAnim::DieChest, $PlayerAnim::DieRightSide, $PlayerAnim::DieSpin);
							else if(%quadrant == "back_left" ) 
								%curDie = radnomItems(4, $PlayerAnim::DieLeftSide, $PlayerAnim::DieGrabBack, $PlayerAnim::DieForward, $PlayerAnim::DieForwardKneel);
							else if(%quadrant == "back_right") 
								%curDie = radnomItems(4, $PlayerAnim::DieGrabBack, $PlayerAnim::DieRightSide, $PlayerAnim::DieForward, $PlayerAnim::DieForwardKneel);
						}
						else if (%vertPos == "legs") {
							if(%quadrant == "front_left" ||	%quadrant == "back_left") 
								%curDie = $PlayerAnim::DieLegLeft;
							if(%quadrant == "front_right" ||	%quadrant == "back_right") 
								%curDie = $PlayerAnim::DieLegRight;
						}
						Player::setAnimation(%this, %curDie);
					}
					if(%type == $ImpactDamageType && %object.clLastMount != "")  
						%shooterClient = %object.clLastMount;
					Client::onKilled(%damagedClient,%shooterClient, %type);
				}
			}
		}
	}
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function Insomniax_startEMP(%clientId, %player, %shooter) 
{
	if(%clientId != %shooter) Client::sendMessage(%clientId,1,Client::getName(%shooter) @ " hit you with an EMP!");
	else Client::sendMessage(%clientId,1,"You hit yourself with an EMP!");
	if($empTime[%clientId] == 0)
	{
		GameBase::setEnergy(%player,0); 
		GameBase::setRechargeRate(%player,0);
		$empTime[%clientId] = 16; //10;
		checkPlayerEMP(%clientId, %player);
	}
	else $empTime[%clientId] = 10;
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function checkPlayerEMP(%clientId, %player)
{
	if($empTime[%clientId] > 0)
	{
		 Player::setDamageFlash(%player,1.75); //++++++++++++
		 $empTime[%clientId] -= 2;
		 checkPlayerBlind(%clientId, %player); //+++++++++++++
		 schedule("checkPlayerEMP(" @ %clientId @ ", " @ %player @ ");",2,%player);
	}
	else
	{
		 Client::sendMessage(%clientId,1,"EMP Effects have dissapated.");
		 GameBase::setRechargeRate(%player,8);
	}
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function checkPlayerBlind(%clientId, %player)
{
	if($empTime[%clientId] > 0) //+++++++
	{
		$empTime[%clientId] -= 1; //-= 2;++++++++++++
		%drrate = GameBase::getDamageLevel(%player) + 0.01; // 0.05++++++ 
		if (!Player::isDead(%player))
		{
			GameBase::setDamageLevel(%player, %drrate);
			Player::setDamageFlash(%player,0.75);
			if (Player::isDead(%player))
			{
//				messageall(0, Client::getName(%clientId) @ " died from EMP radiation.");
				%clientId.scoreDeaths++;
				%clientId.score--;
				Game::refreshClientScore(%clientId);
				$empTime[%clientId] = 0;
			}
		}
		else
		{
			$empTime[%clientId] = 0;
		}
		schedule("checkPlayerBlind(" @ %clientId @ ", " @ %player @ ");",5,%player);
	}
	else
	{ 
		//Client::sendMessage(%clientId,1,"The effects of the poison wear off.");//+++++++++++++
		//return; //+++++++
	}
}
