//
// This plugin was created by PeterT for use with MiniMod v. 0.7
// or later. The concept is original but much of the code herein
// is not. This plugin also relies on two other MiniMod plugins,
// or their equivalent code in whichever mod you are adapting:
//	Tricon's Springboard, and
//	Z-Tek's Phaselok Turret
//
// The mod creates four additional packs, that will appear in the
// inventory list under the heading "Converter Packs". Each pack
// will, when activated, convert the wearer's grenades, beacons and
// mines into other items. When turned off, normal grenades, beacons
// and mines are available.
//
// This plugin is NOT compatible with Renegades, Shifter, hvTactical,
// Ideal or any other mod which already has multiple grenade, beacon
// or mine types. It is compatible with Orion 2.4 (on which I
// developed it) and presumably with Base.
//
// Here are the details of the packs.
//
// Sensor Pack - Useable by light and medium armours, including
//		 the Engineer if present. Useful for laying down
//		 a decent sensor array, either in the field or
//		 in and around your base.
//
//	Grenade: Pulse Sensor
//	Beacon: Camera
//	Mine: Motion Sensor
//
// Assault Pack - Useable by medium and heavy armours. Useful for
//		  base-storming, especially when the bases are off
//		  the ground.
//
//	Grenade: EMP Grenade
//	Beacon: Emergency Shield
//	Mine: Springboard
//
// Saboteur Pack - Useable by light and medium armours, but not
//		   the Engineer if present. Useful for wreaking
//		   havoc inside an enemy base. A good pack for
//		   those who enjoy indirect damage.
//
//	Grenade: Plastique (15 second timer)
//	Beacon: Satchel Charge
//	Mine: Replicating Mine
//
// Defence Pack - Useable by the Light armour and the Engineer, if
//		  present. Useful for quickly laying down defences
//		  around a remote inventory station or sniper roost,
//		  or within your base.
//
//	Grenade: Hologram Mine
//	Beacon: Phaselok Turret
//	Mine: Sensor Jammer
//
// Of all the above devices, the code for the following has been
// ripped from the mods indicated and included in this plugin. Bear
// in mind that these mods may in turn have been borrowed their code
// from elsewhere, so tracing an idea back to its originator is
// not as easy as it looks.
//
//	Pulse Sensor - Shifter
//	EMP Grenade - hvTactical
//	Emergency Shield - Shifter
//	Plastique - Shifter
//	Satchel Charge - Shifter
//	Replicating Mine - Ideal
//	Hologram Mine: Renegades
//
ItemImageData SensorPackImage
{
	shapeFile = "sensorjampack";
	mountPoint = 2;
	weaponType = 2;  // Sustained
	maxEnergy = 5;  // Energy used/sec for sustained weapons
	sfxFire = SoundJammerOn;
  	mountOffset = { 0, -0.05, 0 };
  	mountRotation = { 0, 0, 0 };
	firstPerson = false;
};

ItemData SensorPack
{
	description = "Sensor Pack";
	shapeFile = "sensorjampack";
	className = "Backpack";
        heading = "gConverter Packs";
	imageType = SensorPackImage;
	shadowDetailMask = 4;
	mass = 0.5;
	elasticity = 0.1;
	price = 50;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function SensorPackImage::onActivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"Converter On - G: PulseSen, B: Camera, M: MotionSen");
	%player.convpack = "Sensor";
}

function SensorPackImage::onDeactivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"Converter Off - Grenades, Beacons, Mines normal");
	%player.convpack = "";
}

ItemImageData AssaultPackImage
{
	shapeFile = "sensorjampack";
	mountPoint = 2;
	weaponType = 2;  // Sustained
	maxEnergy = 5;  // Energy used/sec for sustained weapons
	sfxFire = SoundJammerOn;
  	mountOffset = { 0, -0.05, 0 };
  	mountRotation = { 0, 0, 0 };
	firstPerson = false;
};

ItemData AssaultPack
{
	description = "Assault Pack";
	shapeFile = "sensorjampack";
	className = "Backpack";
        heading = "gConverter Packs";
	imageType = AssaultPackImage;
	shadowDetailMask = 4;
	mass = 0.5;
	elasticity = 0.1;
	price = 150;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function AssaultPackImage::onActivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"Converter On - G: EMP, B: Shield, M: Springboard");
	%player.convpack = "Assault";
}

function AssaultPackImage::onDeactivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"Converter Off - Grenades, Beacons, Mines normal");
	%player.convpack = "";
}

ItemImageData SaboteurPackImage
{
	shapeFile = "sensorjampack";
	mountPoint = 2;
	weaponType = 2;  // Sustained
	maxEnergy = 5;  // Energy used/sec for sustained weapons
	sfxFire = SoundJammerOn;
  	mountOffset = { 0, -0.05, 0 };
  	mountRotation = { 0, 0, 0 };
	firstPerson = false;
};

ItemData SaboteurPack
{
	description = "Saboteur Pack";
	shapeFile = "sensorjampack";
	className = "Backpack";
        heading = "gConverter Packs";
	imageType = SaboteurPackImage;
	shadowDetailMask = 4;
	mass = 0.5;
	elasticity = 0.1;
	price = 250;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function SaboteurPackImage::onActivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"Converter On - G: Plastq, B: Satchel, M: ReplMine");
	%player.convpack = "Saboteur";
}

function SaboteurPackImage::onDeactivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"Converter Off - Grenades, Beacons, Mines normal");
	%player.convpack = "";
}

ItemImageData DefencePackImage
{
	shapeFile = "sensorjampack";
	mountPoint = 2;
	weaponType = 2;  // Sustained
	maxEnergy = 5;  // Energy used/sec for sustained weapons
	sfxFire = SoundJammerOn;
  	mountOffset = { 0, -0.05, 0 };
  	mountRotation = { 0, 0, 0 };
	firstPerson = false;
};

ItemData DefencePack
{
	description = "Defence Pack";
	shapeFile = "sensorjampack";
	className = "Backpack";
        heading = "gConverter Packs";
	imageType = DefencePackImage;
	shadowDetailMask = 4;
	mass = 0.5;
	elasticity = 0.1;
	price = 150;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function DefencePackImage::onActivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"Converter On - G: Holomine, B: PhaseLok, M: SensJam");
	%player.convpack = "Defence";
}

function DefencePackImage::onDeactivate(%player,%imageSlot)
{
	Client::sendMessage(Player::getClient(%player),0,"Converter Off - Grenades, Beacons, Mines normal");
	%player.convpack = "";
}


$TeamItemMax[SatchelPack] = 25;

for(%i = 0; %i < 8; %i++)
{
	$TeamItemCount[%i @ SatchelPack] = 0;
}


ItemData MineAmmo
{
	description = "Mine";
	shapeFile = "mineammo";
	heading = "eMiscellany";
	shadowDetailMask = 4;
	price = 10;
	className = "HandAmmo";
};

function MineAmmo::onUse(%player,%item)
{
	if($matchStarted) {
		if(%player.throwTime < getSimTime() ) {

			// backpack determines grenade type
			%backpack = %player.convpack;
			%playerClient = Player::getClient(%player);

		     	if (%backpack == "Sensor")
			{
				EngSensor(%clientId, %player, %item);
			}
			else if (%backpack == "Assault")
			{
				LaunchMine(%clientId, %player, %item);
			} 					
			else if (%backpack == "Defence")
                    	{
				SniperJammer(%clientId, %player, %item);							//=== Sniper Jammer
			}
			else if (%backpack == "Saboteur")
                    	{
				%obj = newObject("","Mine","ReplicatorMine");
				Player::decItemCount(%player,%item);					
			}
			else
                    	{
				%obj = newObject("","Mine","antipersonelMine"); 
				Player::decItemCount(%player,%item);					
			}
					
//==== Finish Mine Deploy

		 	addToSet("MissionCleanup", %obj);
			%client = Player::getClient(%player);
			GameBase::throw(%obj,%player,15 * %client.throwStrength,false);
			%player.throwTime = getSimTime() + 0.5;

			GameBase::setTeam (%obj,GameBase::getTeam (%client));

		}
	}
}

//****************************************************

function EngSensor(%clientId, %player, %item)
{
	if (MotionSensorPack::deployShape(%player,%item)) {
	Player::decItemCount(%player,%item);
	$TeamItemCount[GameBase::getTeam(%player) @ "MotionSensorPack"]++;
	}
}

//*********************************************

function LaunchMine(%clientId, %player, %item)
{
 	if (SpringPack::deployShape(%player,%item)) {
	Player::decItemCount(%player,%item);
	}
}

//*************************************************

function PhaseMine(%clientId, %player, %item)
{
	if($Debug::ZTek) echo($DebugHeading::ZTek @ "PhaseLokPack::onDeploy: (%player)=" @ %player @ " (%item)=" @ %item @ " (%pos)=" @ %pos);
	if (PhaseLokPack::deployShape(%player,%item)) {
	Player::decItemCount(%player,%item);
	}
}

//*************************************************

function ScoutSensor(%clientId, %player, %bec)
{
	%item = "PulseSensorPack";
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item])
	{
		if (GameBase::getLOSInfo(%player,3))
		{
			// GetLOSInfo sets the following globals:
			// 	los::position
			// 	los::normal
			// 	los::object
			%obj = getObjectType($los::object);
			if (%obj == "SimTerrain" || %obj == "InteriorShape" || %obj == "DeployablePlatform")
			{
				// Try to stick it straight up or down, otherwise
				// just use the surface normal
				%prot = GameBase::getRotation(%player);
				%zRot = getWord(%prot,2);
				if (Vector::dot($los::normal,"0 0 1") > 0.6)
				{
					%rot = "0 0 " @ %zRot;
				}
				else
				{
					if (Vector::dot($los::normal,"0 0 -1") > 0.6)
					{
						%rot = "3.14159 0 " @ %zRot;
					}
					else
					{
						%rot = Vector::getRotation($los::normal);
					}
				}
				if(checkDeployArea(%client,$los::position))
				{
					%camera = newObject("radar_small","Sensor",DeployablePulseSensor,true);
			   		addToSet("MissionCleanup", %camera);
					GameBase::setTeam(%camera,GameBase::getTeam(%player));
					GameBase::setRotation(%camera,%rot);
					GameBase::setPosition(%camera,$los::position);
					Gamebase::setMapName(%camera,"Pulse Sensor");
					Client::sendMessage(%client,0,"Pulse Sensor deployed");
					playSound(SoundPickupBackpack,$los::position);
					$TeamItemCount[GameBase::getTeam(%camera) @ "PulseSensorPack"]++;
					echo("MSG: ",%client," deployed a Pulse Sensor");
					Player::decItemCount(%player,%bec);
					return true;
				}
			}
			else
			{
				Client::sendMessage(%client,0,"Can only deploy on terrain or buildings");
			}
		}
		else
		{
			Client::sendMessage(%client,0,"Deploy position out of range");		
		}
	}
	else																						  
	 	Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");
	
	return false;
}

//=====================================================================

ItemData Beacon
{
	description = "Beacon";
	shapeFile = "sensor_small";
	heading = "eMiscellany";
	shadowDetailMask = 4;
	price = 5;
	className = "HandAmmo";
};

function Beacon::onUse(%player,%item)
{
	// backpack determines grenade type
	%backpack = %player.convpack;
	%clientId = Player::getClient(%player);
		     		
     	if (%backpack == "Sensor")
	{
		EngCamera(%clientId, %player, %item);								//=== Eng. Camera
	}
	else if (%backpack == "Assault")
	{
		Renegades_startShield(%clientId, %player); 
		Player::decItemCount(%player,%item);
	}
	else if (%backpack == "Defence")
        {
		PhaseMine(%clientId, %player, %item);
	}
	else if (%backpack == "Saboteur")
	{
		DeploySatchel(%clientId, %player, %item);
	}
	else
	{
		if (Beacon::deployShape(%player,%item))
		{
			Player::decItemCount(%player,%item);
		}
	}
}

//**************************************

function EngCamera(%clientId, %player, %item)
{
	if (CameraPack::deployShape(%player,%item)) {
		Player::decItemCount(%player,%item);
	}
}

//**************************************

function SniperJammer(%clientId, %player, %item)
{
	if (Item::deployShape(%player,"Sensor Jammer",DeployableSensorJammer,%item)) {
		Player::decItemCount(%player,%item);
		$TeamItemCount[GameBase::getTeam(%player) @ "DeployableSensorJammerPack"]++;
	}
}

//**************************************

function DeploySatchel(	%clientId, %player, %bec)
{
	%item = "SatchelPack";
	%client = Player::getClient(%player);

	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item])
	{
		if (GameBase::getLOSInfo(%player,3)) 
		{
			%obj = getObjectType($los::object);
			%prot = GameBase::getRotation(%player);
			%zRot = getWord(%prot,2);
			if (Vector::dot($los::normal,"0 0 1") > 0.6) 
			{
				%rot = "0 0 " @ %zRot;
			}
			else 
			{
				if (Vector::dot($los::normal,"0 0 -1") > 0.6) 
				{
					%rot = "3.14159 0 " @ %zRot;
				}
				else
				{
					%rot = Vector::getRotation($los::normal);
				}
			}
			if(checkDeployArea(%client,$los::position))
			{
				%camera = newObject("Camera","Turret",DeployableSatchel,true);
	   	   		addToSet("MissionCleanup", %camera);
				GameBase::setTeam(%camera,GameBase::getTeam(%player));
				GameBase::setRotation(%camera,%rot);
				GameBase::setPosition(%camera,$los::position);
				Gamebase::setMapName(%camera,"Satchel Charge#"@ $totalNumCameras++ @ " " @ Client::getName(%client));
				Client::sendMessage(%client,0,"Satchel Charge#"@ $totalNumCameras @ " deployed. Set it off from within the Commander Screen.");
				playSound(SoundPickupBackpack,$los::position);
				$TeamItemCount[GameBase::getTeam(%camera) @ "SatchelPack"]++;
				echo("MSG: ",%client," deployed a Satchel Charge.");
				Player::decItemCount(%player,%bec);
				return true;
			}
		}
		else 
		{
			Client::sendMessage(%client,0,"Deploy position out of range");		
		}
	}
	else
	 	Client::sendMessage(%client,0,"Deployable Item limit reached for Satchel Charges");
	
	return false;
}

//**************************************

function Renegades_startShield(%clientId, %player)
{
	Client::sendMessage(%clientId,0,"Emergency Force Shields Activated");
	GameBase::playSound(%player,ForceFieldOpen,0);
	%armor = Player::getArmor(%player);

	if (%armor == "uharmor")
		%player.shieldStrength = 0.016;
	else if (%armor == "harmor")
		%player.shieldStrength = 0.010;
	else
		%player.shieldStrength = 0.006;

	if($shieldTime[%clientId] == 0)
	{
		$shieldTime[%clientId] = 20;
		checkPlayerShield(%clientId, %player);
	}
	else
		$shieldTime[%clientId] = 20;
}


function checkPlayerShield(%clientId, %player)
{
	%armor = Player::getArmor(%player);
	if($shieldTime[%clientId] > 0)
	{
		$shieldTime[%clientId] -= 2;  
		if  ((!Player::isDead(%player)) && (%armor == "marmor" || %armor == "mfemale" || %armor == "harmor" || %armor == "uharmor"))
		{
			if  (Player::isDead(%player))
			{
			}
		}
		else
		{
		$shieldTime[%clientId] = 0;
		}
		schedule("checkPlayerShield(" @ %clientId @ ", " @ %player @ ");",2,%player);
	}
	else
	{
		Client::sendMessage(%clientId,0,"Emergency Force Shields Exausted");
		%player.shieldStrength = 0;
		GameBase::playSound(%player,ForceFieldOpen,0);	
	}			
}

function Grenade::Plastic_Detonate(%this)
{
	%data = GameBase::getDataName(%this);
	GameBase::setDamageLevel(%this, %data.maxDamage);
}

