
// Repair Buoy - an idea discussed by myself and Dewy, code copied from Arbitor Box

$TeamItemMax[RepairBuoyPack] = 3;

ItemImageData RepairBuoyPackImage
{
	shapeFile = "sensor_small";
	mountPoint = 2;
	mountOffset = { 0, 0, 0.1 };
	mountRotation = { 1.57, 0, 0 };
	firstPerson = false;
};

ItemData RepairBuoyPack
{
	description = "Repair Buoy";
	shapeFile = "sensor_small";
	className = "Backpack";
	heading = "dDeployables";
	shadowDetailMask = 4;
	imageType = RepairBuoyPackImage;
	mass = 2.0;
	elasticity = 0.2;
	price = 500;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};


function RepairBuoyPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item)
	{
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else
	{
		Player::deployItem(%player,%item);
	}
}

function RepairBuoyPack::onDeploy(%player,%item,%pos)
{
	if (RepairBuoyPack::deployShape(%player,%item))
	{
		Player::decItemCount(%player,%item);
	}
}

function RepairBuoyPack::deployShape(%player,%item)
{
	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ "RepairBuoyPack"] < $TeamItemMax[RepairBuoyPack])
	{
		if (GameBase::getLOSInfo(%player,3))
		{
			%obj = getObjectType($los::object);
    			%set = newObject("set",SimSet);
			%num = containerBoxFillSet(%set,$StaticObjectType,$los::position,25,25,25,0);
			%num = CountObjects(%set,"RepairBuoy",%num);
			deleteObject(%set);
			if(0 == %num) 
			{
				%prot = GameBase::getRotation(%player);
				%zRot = getWord(%prot,2);
				if (Vector::dot($los::normal,"0 0 1") > 0.6) 
				{
					%rot = "0 0 " @ %zRot;
				}
				else 	
				{
					if (Vector::dot($los::normal,"0 0 -1") > 0.6) 
					{
						%rot = "3.14159 0 " @ %zRot;
					}
					else 
					{
						%rot = Vector::getRotation($los::normal);
					}
				}
				if(checkDeployArea(%client,$los::position)) 
				{
					%turret = newObject("Repair Buoy","Turret",RepairBuoy,true);
					addToSet("MissionCleanup", %turret);
					GameBase::setTeam(%turret,GameBase::getTeam(%player));
					GameBase::setPosition(%turret,$los::position);
					GameBase::setRotation(%turret,%rot);
					Gamebase::setMapName(%turret,"Repair Buoy#" @ $totalNumTurrets++ @ " " @ Client::getName(%client));
					Client::sendMessage(%client,0,"Repair Buoy deployed");
					playSound(SoundPickupBackpack,$los::position);
					$TeamItemCount[GameBase::getTeam(%player) @ "RepairBuoyPack"]++;
					echo("MSG: ",%client," deployed a Repair Buoy");
					return true;
				}
			}	 
			else
				Client::sendMessage(%client,0,"Frequency Overload - Too close to another Repair Buoy");
		}
		else 
			Client::sendMessage(%client,0,"Deploy position out of range");
	}
	else																						  
	 	Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "es");
	return false;
}

	$TeamItemCount[0 @ "RepairBuoyPack"] = 0;
	$TeamItemCount[1 @ "RepairBuoyPack"] = 0;
	$TeamItemCount[2 @ "RepairBuoyPack"] = 0;
	$TeamItemCount[3 @ "RepairBuoyPack"] = 0;
	$TeamItemCount[4 @ "RepairBuoyPack"] = 0;
	$TeamItemCount[5 @ "RepairBuoyPack"] = 0;
	$TeamItemCount[6 @ "RepairBuoyPack"] = 0;
	$TeamItemCount[7 @ "RepairBuoyPack"] = 0;
