// This is a MiniMod Plugin
// Created by Jaredik

TurretData BarrageTurret
{
className = "Turret";
shapeFile = "missileturret";
projectileType = BarrageBolt;
maxDamage = 0.7;
maxEnergy = 3000;
minGunEnergy = 20;
maxGunEnergy = 100;
sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
reloadDelay = 0.1;
speed = 2;
speedModifier = 2.0;
range = 300;
visibleToSensor = true;
shadowDetailMask = 4;
dopplerVelocity = 1.5;
castLOS = true;
supression = false;
mapFilter = 2;
mapIcon = "M_turret";
debrisId = flashDebrisMedium;
shieldShapeName = "shield_medium";
fireSound = SoundMissileTurretFire;
activationSound = SoundMissileTurretOn;
deactivateSound = SoundMissileTurretOff;
whirSound = SoundMissileTurretTurn;
explosionId = flashExpMedium;
description = "Anti-Aircraft Battery";
};

function BarrageTurret::onAdd(%this)
{
	schedule("BarrageTurret::deploy(" @ %this @ ");",now,%this);
	GameBase::setRechargeRate(%this,20);
	%this.shieldStrength = 0.001;
	if (GameBase::getMapName(%this) == "") {
		GameBase::setMapName (%this, "Anti-Aircraft Battery");
	}
}

function BarrageTurret::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

function BarrageTurret::onEndSequence(%this,%thread)
{
	GameBase::setActive(%this,true);
}

function BarrageTurret::onDestroyed(%this)
{
	Turret::onDestroyed(%this);
  	$TeamItemCount[GameBase::getTeam(%this) @ "BarragePack"]--;
}

// Override base class just in case.
function BarrageTurret::onPower(%this,%power,%generator)
{
}

function BarrageTurret::onEnabled(%this) 
{
	GameBase::setRechargeRate(%this,20);
	GameBase::setActive(%this,true);
}	

function BarrageTurret::verifyTarget(%this,%target) // Don't shoot if they're not in a vehicle. :) Dewy.
{
   if (GameBase::virtual(%target, "getMountObject") >= 1)
      return "True";
   else
      return "False";
}



