// Repair Buoy - an idea discussed by myself and Dewy, code copied from Arbitor Box

TurretData RepairBuoy
{
	className = "Turret";
	shapeFile = "sensor_small";
	maxDamage = 12;
	maxEnergy = 200;
	visibleToSensor = true;
	shadowDetailMask = 4;
	supression = false;
	pinger = false;
	dopplerVelocity = 0;
	castLOS = true;
	mapFilter = 2;
	mapIcon = "M_turret";
	debrisId = flashDebrisSmall;
	shieldShapeName = "shield";
	explosionId = flashExpSmall;
	description = "Repair Buoy";
	damageSkinData = "objectDamageSkins";
};

function RepairBuoy::onAdd(%this)
{
	schedule("RepairBuoy::deploy(" @ %this @ ");",1,%this);
	GameBase::setRechargeRate(%this,5);
	if (GameBase::getMapName(%this) == "")
	{
		GameBase::setMapName (%this, "Repair Buoy");
	}
}

function RepairBuoy::deploy(%this)
{
	GameBase::setActive(%this,true);
}

function RepairBuoy::onDisabled(%this)
{
	Turret::onDisabled(%this);

	%num = Group::objectCount(%this.set);
	for(%i=%num-1; %i >= 0; %i--)
	{
		%obj = Group::getObject(%this.set, %i);
		if (getObjectType(%obj) == "Player")
			%rate = GameBase::getAutoRepairRate(%obj) - 0.03;
		else
			%rate = GameBase::getAutoRepairRate(%obj) - 0.01;
		if(%rate < 0)
			%rate = 0;
		GameBase::setAutoRepairRate(%obj,%rate);
		%obj.autorepair = 0;
	}
	deleteObject(%this.set);
}
function RepairBuoy::onDestroyed(%this)
{
	Turret::onDestroyed(%this);
  	$TeamItemCount[GameBase::getTeam(%this) @ "RepairBuoyPack"]--;
	if(%this.set)
	{
		%num = Group::objectCount(%this.set);
		for(%i=%num-1; %i >= 0; %i--)
		{
			%obj = Group::getObject(%this.set, %i);
			if (getObjectType(%obj) == "Player")
				%rate = GameBase::getAutoRepairRate(%obj) - 0.03;
			else
				%rate = GameBase::getAutoRepairRate(%obj) - 0.01;
			if(%rate < 0)
				%rate = 0;
			GameBase::setAutoRepairRate(%obj,%rate);
			%obj.autorepair = 0;
		}
	deleteObject(%this.set);
	}
}

// Override base class just in case.
function RepairBuoy::onPower(%this,%power,%generator)
{
}

function RepairBuoy::onEnabled(%this) 
{
	GameBase::setRechargeRate(%this,5);
	GameBase::setActive(%this,true);

	%Set = newObject("set",SimSet); 
	%Pos = GameBase::getPosition(%this); 
	%Mask = $SimPlayerObjectType|$StaticObjectType|$VehicleObjectType|$MineObjectType|$SimInteriorObjectType; //repairs people, things, vehicles, mines, and the base itself
	containerBoxFillSet(%Set, %Mask, %Pos, 10, 10, 10,0);
	%num = Group::objectCount(%Set);
	for(%i; %i < %num; %i++)
	{
		%obj = Group::getObject(%Set, %i);
		if(GameBase::getTeam(%obj) != GameBase::getTeam(%this) || %obj == %this)
		{
			//don't repair enemies or the buoy itself
		}
		else
		{
			if (getObjectType(%obj) == "Player")
				%rate = GameBase::getAutoRepairRate(%obj) + 0.03;
			else
				%rate = GameBase::getAutoRepairRate(%obj) + 0.01;
			GameBase::setAutoRepairRate(%obj,%rate);
			%obj.autorepair = 1;
		}
	}

	%this.set = %Set;

	schedule("RepairBuoy::checkRepairBuoy(" @ %this @ ");", 0.1, %this);

}	

function RepairBuoy::checkRepairBuoy(%this)
{

	if(GameBase::getDamageState(%this) != "Enabled")
		return;

	%this.evenodd = !%this.evenodd; //switches from 1 to 0... tells every other check... used to check if in both new & old sets

	%Set = newObject("set",SimSet); 
	%Pos = GameBase::getPosition(%this); 
	%Mask = $SimPlayerObjectType|$StaticObjectType|$VehicleObjectType|$MineObjectType|$SimInteriorObjectType; //repairs people, thiings, vehicles, mines, and the base itself
	containerBoxFillSet(%Set, %Mask, %Pos, 10, 10, 10,0);
	%num = Group::objectCount(%Set);
	for(%i; %i < %num; %i++)
	{
		%obj = Group::getObject(%Set, %i);
		if(GameBase::getTeam(%obj) != GameBase::getTeam(%this) || %obj == %this)
		{
			//don't repair enemies or the buoy itself
		}
		else
		{
			if(%obj.autorepair == 0)
			{
				if (getObjectType(%obj) == "Player")
					%rate = GameBase::getAutoRepairRate(%obj) + 0.03;
				else
					%rate = GameBase::getAutoRepairRate(%obj) + 0.01;
				GameBase::setAutoRepairRate(%obj,%rate);
			}
			%obj.autorepair = 1 + %this.evenodd; //1 half the time & 2 other half... used to check if in this set while searching the old set
		}
	}


	%num = Group::objectCount(%this.set);

	for(%j; %j < %num; %j++)
	{
		%obj = Group::getObject(%this.set, %j);
		if(%obj == %this || GameBase::getTeam(%obj) != GameBase::getTeam(%this))
		{
			//don't bother checking the other team or the buoy itself; they're not affected
		}
		else if(%obj.autorepair != (%this.evenodd + 1)) //if different then new set
		{
			if (getObjectType(%obj) == "Player")
				%rate = GameBase::getAutoRepairRate(%obj) - 0.03;
			else
				%rate = GameBase::getAutoRepairRate(%obj) - 0.01;
			if(%rate < 0)
				%rate = 0;
			GameBase::setAutoRepairRate(%obj,%rate);
			%obj.autorepair = 0;
		}
	}

	deleteObject(%this.set); //delete the old set
	%this.set = %Set; //and replace with new set

	schedule("RepairBuoy::checkRepairBuoy(" @ %this @ ");", 2.0, %this); //then recheck in 2 seconds
}
