//
// This plugin was created by PeterT for use with MiniMod v. 0.7
// or later. The concept is original but much of the code herein
// is not. This plugin also relies on two other MiniMod plugins,
// or their equivalent code in whichever mod you are adapting:
//	Tricon's Springboard, and
//	Z-Tek's Phaselok Turret
//
// The mod creates four additional packs, that will appear in the
// inventory list under the heading "Converter Packs". Each pack
// will, when activated, convert the wearer's grenades, beacons and
// mines into other items. When turned off, normal grenades, beacons
// and mines are available.
//
// This plugin is NOT compatible with Renegades, Shifter, hvTactical,
// Ideal or any other mod which already has multiple grenade, beacon
// or mine types. It is compatible with Orion 2.4 (on which I
// developed it) and presumably with Base.
//
// Here are the details of the packs.
//
// Sensor Pack - Useable by light and medium armours, including
//		 the Engineer if present. Useful for laying down
//		 a decent sensor array, either in the field or
//		 in and around your base.
//
//	Grenade: Pulse Sensor
//	Beacon: Camera
//	Mine: Motion Sensor
//
// Assault Pack - Useable by medium and heavy armours. Useful for
//		  base-storming, especially when the bases are off
//		  the ground.
//
//	Grenade: EMP Grenade
//	Beacon: Emergency Shield
//	Mine: Springboard
//
// Saboteur Pack - Useable by light and medium armours, but not
//		   the Engineer if present. Useful for wreaking
//		   havoc inside an enemy base. A good pack for
//		   those who enjoy indirect damage.
//
//	Grenade: Plastique (15 second timer)
//	Beacon: Satchel Charge
//	Mine: Replicating Mine
//
// Defence Pack - Useable by the Light armour and the Engineer, if
//		  present. Useful for quickly laying down defences
//		  around a remote inventory station or sniper roost,
//		  or within your base.
//
//	Grenade: Hologram Mine
//	Beacon: Phaselok Turret
//	Mine: Sensor Jammer
//
// Of all the above devices, the code for the following has been
// ripped from the mods indicated and included in this plugin. Bear
// in mind that these mods may in turn have been borrowed their code
// from elsewhere, so tracing an idea back to its originator is
// not as easy as it looks.
//
//	Pulse Sensor - Shifter
//	EMP Grenade - hvTactical
//	Emergency Shield - Shifter
//	Plastique - Shifter
//	Satchel Charge - Shifter
//	Replicating Mine - Ideal
//	Hologram Mine: Renegades
//
TurretData DeployableSatchel
{
	className = "Turret";
	shapeFile = "camera";
	projectileType = SatchelShell;
	maxDamage = 0.4;
	maxEnergy = 75;
	minGunEnergy = 10;
	maxGunEnergy = 60;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
	reloadDelay = 10.0;
	speed = 4.0;
	speedModifier = 1.5;
	range = 0;
	visibleToSensor = true;
	shadowDetailMask = 4;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	debrisId = flashDebrisMedium;
	shieldShapeName = "shield";
	fireSound = SoundFireLaser;
	activationSound = SoundRemoteTurretOn;
	deactivateSound = SoundRemoteTurretOff;
	explosionId = rocketExp;
	description = "Satchel Charge";
	damageSkinData = "objectDamageSkins";
};

function DeployableSatchel::onAdd(%this)
{
	schedule("DeployableSatchel::deploy(" @ %this @ ");",1,%this);
	GameBase::setRechargeRate(%this,5);
	%this.shieldStrength = 0;
	if (GameBase::getMapName(%this) == "") {
		GameBase::setMapName (%this, "Satchel Charge");
	}
}

function DeployableSatchel::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

function DeployableSatchel::onEndSequence(%this,%thread)
{
	GameBase::setActive(%this,true);
}

function DeployableSatchel::onDestroyed(%this)
{
	StaticShape::objectiveDestroyed(%this);
	%this.shieldStrength = 0;
	GameBase::setRechargeRate(%this,0);
	Turret::onDeactivate(%this);
	Turret::objectiveDestroyed(%this);
	//calcRadiusDamage(%this, $DebrisDamageType, 20.0, 1.5, 25, 9, 3, 0.40,0.1, 200, 100); 
	CalcRadiusDamage(%this,$DebrisDamageType,30,0.2,25,20,20,1.5,0.5,200,100);

  	$TeamItemCount[GameBase::getTeam(%this) @ "SatchelPack"]--;
}

// Override base class just in case.
function DeployableSatchel::onPower(%this,%power,%generator) {}
function DeployableSatchel::onEnabled(%this) 
{
	GameBase::setRechargeRate(%this,5);
	GameBase::setActive(%this,true);
}	

function Turret::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
	if(%this.objectiveLine)
		%this.lastDamageTeam = GameBase::getTeam(%object);
		%TDS= 1;
	if(GameBase::getTeam(%this) == GameBase::getTeam(%object))
	{
		%name = GameBase::getDataName(%this);
		if(%name != CameraTurret && %name != FlameTurret && (String::findSubStr(%name, "Deployable") < 0))	
			%TDS = $Server::TeamDamageScale;
	}
	StaticShape::shieldDamage(%this,%type,%value * %TDS,%pos,%vec,%mom,%object);
	if(%type == $EMPDamageType) GameBase::setEnergy(%this,0);
}

