function StaticShape::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
	MM::Attacked(%this, %object);
	%damageLevel = GameBase::getDamageLevel(%this);
	%dValue = %damageLevel + %value;
	%this.lastDamageObject = %object;
	%this.lastDamageTeam = GameBase::getTeam(%object);
//	echo(Client::getName(%object));
	if(GameBase::getTeam(%this) == GameBase::getTeam(%object)) {
		%name = GameBase::getDataName(%this);
		if(%name.className == Generator || %name.className == Station) { 
			%TDS = $Server::TeamDamageScale;
			%dValue = %damageLevel + %value * %TDS;
			%disable = GameBase::getDisabledDamage(%this);
			if(!$Server::TourneyMode && %dValue > %disable - 0.05) {
            if(%damageLevel > %disable - 0.05)
               return;
            else
               %dValue = %disable - 0.05;
			}
		}
	}
	GameBase::setDamageLevel(%this,%dValue);
}

function MM::Idle(%this)
{
	%this.beingAttacked = "";
	%this.isFiring = "";
}

function MM::isOffLine(%this)
{
	if(%this.beenDestroyed != "True")
	{
		if(%this.isOffLine != "True")
		{
 			%numPlayers = getNumClients();
			for(%loop = 0; %loop < %numPlayers; %loop++) 
			{ 
				%pl = getClientByIndex(%loop);
				%plteam = Client::Getteam(%pl);
				if(%plteam == GameBase::getTeam(%this)) 
				{
					%thing = GameBase::getMapName(%this);
					if(%thing != "False")
					{
					 	client::sendmessage(%pl,1,%thing@" has been disabled.");
						%this.isOffLine = "True";
						%this.isOnLine = "False";
						%this.beenDestroyed = "False";
						%this.beingAttacked = "True";
					}
				}
			}
		}
	}
}

function MM::isOnLine(%this)
{
	if(%this.isOnLine != "True" || "")
	{
 		%numPlayers = getNumClients();
		for(%loop = 0; %loop < %numPlayers; %loop++) 
		{ 
			%pl = getClientByIndex(%loop);
			%plteam = Client::Getteam(%pl);
			if(%plteam == GameBase::getTeam(%this)) 
			{
				%thing = GameBase::getMapName(%this);
				if(%thing != "False")
				{
				 	client::sendmessage(%pl,3,%thing@" is online.");
					%this.isOnLine = "True";
					schedule("MM::Idle("@%this@");",3);
					%this.beenDestroyed = "False";
					%this.isOffLine = "False";
					%this.beingAttacked = "False";
				}
			}
		}
	}
	if(%this.isOnLine == "")
	{
		%this.isOnLine = "True";
	}
}

function MM::Attacked(%this, %object)
{
	if(%this.beingAttacked == "")
	{
		if(%this.beenDestroyed != "True")
		{
			if(%this.isOffLine != "True")
			{
 				%numPlayers = getNumClients();
				for(%loop = 0; %loop < %numPlayers; %loop++) 
				{ 
					%pl = getClientByIndex(%loop);
					%plteam = Client::Getteam(%pl);
					if(%plteam == GameBase::getTeam(%this)) 
					{
						%shooter = Client::getName(%object);
						%thing = GameBase::getMapName(%this);
						if(%thing != "False" || ""){if(%object != "False" || "")
						{
				 			client::sendmessage(%pl,1,%shooter@" is attacking the "@%thing@"!~wLostTower.wav");
							%this.beingAttacked = "True";
							schedule("MM::Idle("@%this@");",3);
						}}
						if(%thing != "False" || ""){if(%shooter == "False" || "")
						{
				 			client::sendmessage(%pl,1,%thing@" is under attack!~wLostTower.wav");
							%this.beingAttacked = "True";
							schedule("MM::Idle("@%this@");",3);
						}}
					}
				}
			}
		}
	}
}

function Turret::onActivate(%this)
{
	GameBase::playSequence(%this,0,power);
	MM::isFiring(%this);
}

function MM::isFiring(%this, %message)
{
	if(%this.isFiring != "True")
	{
		if(%this.beenDestroyed != "True")
		{
			if(%this.isOffLine != "True")
			{
 				%numPlayers = getNumClients();
				for(%loop = 0; %loop < %numPlayers; %loop++) 
				{ 
					%pl = getClientByIndex(%loop);
					%plteam = Client::Getteam(%pl);
					if(%plteam == GameBase::getTeam(%this)) 
					{
						%thing = GameBase::getMapName(%this);
						if(%thing != "False")
						{
				 			client::sendmessage(%pl,1,%thing@" "@%message@"");
							%this.isFiring = "True";
							schedule("MM::Idle("@%this@");",15);
						}
					}
				}
			}
		}
	}
}

function MM::Destroyed(%this)
{
	%numPlayers = getNumClients();
	for(%loop = 0; %loop < %numPlayers; %loop++) 
	{ 
		%pl = getClientByIndex(%loop);
		%plteam = Client::Getteam(%pl);
		if(%plteam == GameBase::getTeam(%this)) 
		{
			%thing = GameBase::getMapName(%this);
			if(%thing != "False")
			{
			 	client::sendmessage(%pl,1,%thing@" has been DESTROYED!!!!~wLostTower.wav");
				%this.beenDestroyed = "True";
				%this.beingAttacked = "True";
				%this.isOnLine = "False";
				%this.isOffLine = "True";
			}
		}
	}
}

function Generator::onDestroyed(%this)
{
	MM::Destroyed(%this);
	Generator::onDisabled(%this);
	StaticShape::objectiveDestroyed(%this);
	calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 13, 3, 0.55, 
		0.30, 250, 170); 
}

function Generator::onEnabled(%this)
{
	GameBase::setActive(%this,true);
	MM::isOnLine(%this);
}

function Generator::onDisabled(%this)
{
	GameBase::stopSequence(%this,0);
 	GameBase::generatePower(%this, false);
	MM::isOffLine(%this, %object);
}

function Generator::onActivate(%this)
{
	GameBase::playSequence(%this,0,"power");
	GameBase::generatePower(%this, true);
	MM::isOnLine(%this);
}

function Generator::onDeactivate(%this)
{
	GameBase::stopSequence(%this,0);
 	GameBase::generatePower(%this, false);
	MM::isOffLine(%this);
}

function StaticShape::onPower(%this,%power,%generator)
{
	if (%power) 
	{
		GameBase::playSequence(%this,0,"power");
		MM::isOnLine(%this);
	}
	else 
		GameBase::stopSequence(%this,0);
}

function StaticShape::onEnabled(%this)
{
	if (GameBase::isPowered(%this)) 
		MM::isOnLine(%this);
		GameBase::playSequence(%this,0,"power");
}

function StaticShape::onDisabled(%this)
{
	GameBase::stopSequence(%this,0);
	MM::isOffLine(%this);
}

function StaticShape::onDestroyed(%this)
{
	MM::Destroyed(%this);
	GameBase::stopSequence(%this,0);
   StaticShape::objectiveDestroyed(%this);
	calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 13, 2, 0.40, 
		0.1, 250, 100); 
}

function StaticShape::shieldDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
	MM::Attacked(%this, %object);
	%damageLevel = GameBase::getDamageLevel(%this);
   %this.lastDamageObject = %object;
   %this.lastDamageTeam = GameBase::getTeam(%object);
	if (%this.shieldStrength) {
		%energy = GameBase::getEnergy(%this);
		%strength = %this.shieldStrength;
		if (%type == $ShrapnelDamageType)
			%strength *= 0.5;
		else
			if (%type == $MortarDamageType)
				%strength *= 0.25;
			else
				if (%type == $BlasterDamageType)
					%strength *= 2.0;
		%absorb = %energy * %strength;
		if (%value < %absorb) {
			GameBase::setEnergy(%this,%energy - (%value / %strength));
			%centerPos = getBoxCenter(%this);
			%sphereVec = findPointOnSphere(getBoxCenter(%object),%centerPos,%vec,%this);
			%centerPosX = getWord(%centerPos,0);
			%centerPosY = getWord(%centerPos,1);
			%centerPosZ = getWord(%centerPos,2);

			%pointX = getWord(%pos,0);
			%pointY = getWord(%pos,1);
			%pointZ = getWord(%pos,2);

			%newVecX = %centerPosX - %pointX;
			%newVecY = %centerPosY - %pointY;
			%newVecZ = %centerPosZ - %pointZ;
			%norm = Vector::normalize(%newVecX @ " " @ %newVecY @ " " @ %newVecZ);
			%zOffset = 0;
			if(GameBase::getDataName(%this) == PulseSensor)
				%zOffset = (%pointZ-%centerPosZ) * 0.5;
			GameBase::activateShield(%this,%sphereVec,%zOffset);
		}
		else {
			GameBase::setEnergy(%this,0);
			StaticShape::onDamage(%this,%type,%value - %absorb,%pos,%vec,%mom,%object);
		}
	}
	else {
		StaticShape::onDamage(%this,%type,%value,%pos,%vec,%mom,%object);
	}
}

function Station::onPower(%this,%power,%generator)
{
	if (%power) {
		MM::isOnLine(%this);
		GameBase::playSequence(%this,0,"power");
		GameBase::playSequence(%this,1);
	}
	else {
		GameBase::stopSequence(%this,0);
		GameBase::pauseSequence(%this,1);
		GameBase::pauseSequence(%this,2);
		Station::checkTarget(%this);
	}
}

function Station::onEnabled(%this)
{
	if (GameBase::isPowered(%this)) {		
		MM::isOnLine(%this);
		GameBase::playSequence(%this,0,"power");
		GameBase::playSequence(%this,1);
	}
}

function Station::onDisabled(%this)
{
	MM::isOffLine(%this);
	Station::weaponCheck(%this);
	GameBase::stopSequence(%this,0);
	GameBase::setSequenceDirection(%this,1,0);
	GameBase::pauseSequence(%this,1);
	GameBase::stopSequence(%this,2);
	Station::checkTarget(%this);
}

function Station::onDestroyed(%this)
{
	MM::Destroyed(%this);
	Station::weaponCheck(%this);
	StaticShape::objectiveDestroyed(%this);
	GameBase::stopSequence(%this,0);
	GameBase::stopSequence(%this,1);
	GameBase::stopSequence(%this,2);
	Station::checkTarget(%this);
	calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 13, 2, 0.40, 
		0.1, 250, 100); 
}

function Turret::onEnabled(%this)
{
	if (GameBase::isPowered(%this)) {
		MM::isOnLine(%this);
		%this.shieldStrength = 0.03;
		GameBase::setRechargeRate(%this,10);
		GameBase::setActive(%this,true);
	}
}

function Turret::onPower(%this,%power,%generator)
{
	if (%power) {
		MM::isOnLine(%this);
		%this.shieldStrength = 0.03;
		GameBase::setRechargeRate(%this,10);
	}
	else {
		MM::isOffLine(%this);
		%this.shieldStrength = 0;
		GameBase::setRechargeRate(%this,0);
		Turret::checkOperator(%this);
	}
	GameBase::setActive(%this,%power);
}

function Turret::onDestroyed(%this)
{
	MM::Destroyed(%this);
	StaticShape::objectiveDestroyed(%this);
	%this.shieldStrength = 0;
	GameBase::setRechargeRate(%this,0);
	Turret::onDeactivate(%this);
	Turret::objectiveDestroyed(%this);
	calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 9, 3, 0.40, 
		0.1, 200, 100); 
}

function Turret::onDisabled(%this)
{
	MM::isOffLine(%this);
	%this.shieldStrength = 0;
	GameBase::setRechargeRate(%this,0);
	Turret::onDeactivate(%this);
}

function Turret::damageTarget(%target)
{
	%this = Client::getTeam(%target);
	MM::isFiring(%this);
}

function Player::onDamage(%this,%type,%value,%pos,%vec,%mom,%vertPos,%quadrant,%object)
{
	if (Player::isExposed(%this)) {
      %damagedClient = Player::getClient(%this);
      %shooterClient = %object;
if(GameBase::getMapName(%object) != ""){MM::isFiring(%object);}
		Player::applyImpulse(%this,%mom);
		if($teamplay && %damagedClient != %shooterClient && Client::getTeam(%damagedClient) == Client::getTeam(%shooterClient) ) {
			if (%shooterClient != -1) {
				%curTime = getSimTime();
			   if ((%curTime - %this.DamageTime > 3.5 || %this.LastHarm != %shooterClient) && %damagedClient != %shooterClient && $Server::TeamDamageScale > 0) {
					if(%type != $MineDamageType) {
						Client::sendMessage(%shooterClient,0,"You just harmed Teammate " @ Client::getName(%damagedClient) @ "!");
						Client::sendMessage(%damagedClient,0,"You took Friendly Fire from " @ Client::getName(%shooterClient) @ "!");
					}
					else {
						Client::sendMessage(%shooterClient,0,"You just harmed Teammate " @ Client::getName(%damagedClient) @ " with your mine!");
						Client::sendMessage(%damagedClient,0,"You just stepped on Teamate " @ Client::getName(%shooterClient) @ "'s mine!");
					}
					%this.LastHarm = %shooterClient;
					%this.DamageStamp = %curTime;
				}
			}
			%friendFire = $Server::TeamDamageScale;
		}
		else if(%type == $ImpactDamageType && Client::getTeam(%object.clLastMount) == Client::getTeam(%damagedClient)) 
			%friendFire = $Server::TeamDamageScale;
		else  
			%friendFire = 1.0;	

		if (!Player::isDead(%this)) {
			%armor = Player::getArmor(%this);
			//More damage applyed to head shots
			if(%vertPos == "head" && %type == $LaserDamageType) {
				if(%armor == "harmor") { 
					if(%quadrant == "middle_back" || %quadrant == "middle_front" || %quadrant == "middle_middle") {
						%value += (%value * 0.3);
					}
				}
				else {
					%value += (%value * 0.3);
				}
			}
			//If Shield Pack is on
			if (%type != -1 && %this.shieldStrength) {
				%energy = GameBase::getEnergy(%this);
				%strength = %this.shieldStrength;
				if (%type == $ShrapnelDamageType || %type == $MortarDamageType)
					%strength *= 0.75;
				%absorb = %energy * %strength;
				if (%value < %absorb) {
					GameBase::setEnergy(%this,%energy - ((%value / %strength)*%friendFire));
					%thisPos = getBoxCenter(%this);
					%offsetZ =((getWord(%pos,2))-(getWord(%thisPos,2)));
					GameBase::activateShield(%this,%vec,%offsetZ);
					%value = 0;
				}
				else {
					GameBase::setEnergy(%this,0);
					%value = %value - %absorb;
				}
			}
  			if (%value) {
				%value = $DamageScale[%armor, %type] * %value * %friendFire;
            %dlevel = GameBase::getDamageLevel(%this) + %value;
            %spillOver = %dlevel - %armor.maxDamage;
				GameBase::setDamageLevel(%this,%dlevel);
				%flash = Player::getDamageFlash(%this) + %value * 2;
				if (%flash > 0.75) 
					%flash = 0.75;
				Player::setDamageFlash(%this,%flash);
				//If player not dead then play a random hurt sound
				if(!Player::isDead(%this)) { 
					if(%damagedClient.lastDamage < getSimTime()) {
						%sound = radnomItems(3,injure1,injure2,injure3);
						playVoice(%damagedClient,%sound);
						%damagedClient.lastdamage = getSimTime() + 1.5;
					}
				}
				else {
               if(%spillOver > 0.5 && (%type== $ExplosionDamageType || %type == $ShrapnelDamageType || %type== $MortarDamageType|| %type == $MissileDamageType)) {
		 				Player::trigger(%this, $WeaponSlot, false);
						%weaponType = Player::getMountedItem(%this,$WeaponSlot);
						if(%weaponType != -1)
							Player::dropItem(%this,%weaponType);
                	Player::blowUp(%this);
					}
					else
					{
						if ((%value > 0.40 && (%type== $ExplosionDamageType || %type == $ShrapnelDamageType || %type== $MortarDamageType || %type == $MissileDamageType )) || (Player::getLastContactCount(%this) > 6) ) {
					  		if(%quadrant == "front_left" || %quadrant == "front_right") 
								%curDie = $PlayerAnim::DieBlownBack;
							else
								%curDie = $PlayerAnim::DieForward;
						}
						else if( Player::isCrouching(%this) ) 
							%curDie = $PlayerAnim::Crouching;							
						else if(%vertPos=="head") {
							if(%quadrant == "front_left" ||	%quadrant == "front_right"	) 
								%curDie = radnomItems(2, $PlayerAnim::DieHead, $PlayerAnim::DieBack);
						  	else 
								%curDie = radnomItems(2, $PlayerAnim::DieHead, $PlayerAnim::DieForward);
						}
						else if (%vertPos == "torso") {
							if(%quadrant == "front_left" ) 
								%curDie = radnomItems(3, $PlayerAnim::DieLeftSide, $PlayerAnim::DieChest, $PlayerAnim::DieForwardKneel);
							else if(%quadrant == "front_right") 
								%curDie = radnomItems(3, $PlayerAnim::DieChest, $PlayerAnim::DieRightSide, $PlayerAnim::DieSpin);
							else if(%quadrant == "back_left" ) 
								%curDie = radnomItems(4, $PlayerAnim::DieLeftSide, $PlayerAnim::DieGrabBack, $PlayerAnim::DieForward, $PlayerAnim::DieForwardKneel);
							else if(%quadrant == "back_right") 
								%curDie = radnomItems(4, $PlayerAnim::DieGrabBack, $PlayerAnim::DieRightSide, $PlayerAnim::DieForward, $PlayerAnim::DieForwardKneel);
						}
						else if (%vertPos == "legs") {
							if(%quadrant == "front_left" ||	%quadrant == "back_left") 
								%curDie = $PlayerAnim::DieLegLeft;
							if(%quadrant == "front_right" ||	%quadrant == "back_right") 
								%curDie = $PlayerAnim::DieLegRight;
						}
						Player::setAnimation(%this, %curDie);
					}
					if(%type == $ImpactDamageType && %object.clLastMount != "")  
						%shooterClient = %object.clLastMount;
					Client::onKilled(%damagedClient,%shooterClient, %type);
				}
			}
		}
	}
}
