//
// This plugin was created by PeterT for use with MiniMod v. 0.7
// or later. The concept is original but much of the code herein
// is not. This plugin also relies on two other MiniMod plugins,
// or their equivalent code in whichever mod you are adapting:
//	Tricon's Springboard, and
//	Z-Tek's Phaselok Turret
//
// The mod creates four additional packs, that will appear in the
// inventory list under the heading "Converter Packs". Each pack
// will, when activated, convert the wearer's grenades, beacons and
// mines into other items. When turned off, normal grenades, beacons
// and mines are available.
//
// This plugin is NOT compatible with Renegades, Shifter, hvTactical,
// Ideal or any other mod which already has multiple grenade, beacon
// or mine types. It is compatible with Orion 2.4 (on which I
// developed it) and presumably with Base.
//
// Here are the details of the packs.
//
// Sensor Pack - Useable by light and medium armours, including
//		 the Engineer if present. Useful for laying down
//		 a decent sensor array, either in the field or
//		 in and around your base.
//
//	Grenade: Pulse Sensor
//	Beacon: Camera
//	Mine: Motion Sensor
//
// Assault Pack - Useable by medium and heavy armours. Useful for
//		  base-storming, especially when the bases are off
//		  the ground.
//
//	Grenade: EMP Grenade
//	Beacon: Emergency Shield
//	Mine: Springboard
//
// Saboteur Pack - Useable by light and medium armours, but not
//		   the Engineer if present. Useful for wreaking
//		   havoc inside an enemy base. A good pack for
//		   those who enjoy indirect damage.
//
//	Grenade: Plastique (15 second timer)
//	Beacon: Satchel Charge
//	Mine: Replicating Mine
//
// Defence Pack - Useable by the Light armour and the Engineer, if
//		  present. Useful for quickly laying down defences
//		  around a remote inventory station or sniper roost,
//		  or within your base.
//
//	Grenade: Hologram Mine
//	Beacon: Phaselok Turret
//	Mine: Sensor Jammer
//
// Of all the above devices, the code for the following has been
// ripped from the mods indicated and included in this plugin. Bear
// in mind that these mods may in turn have been borrowed their code
// from elsewhere, so tracing an idea back to its originator is
// not as easy as it looks.
//
//	Pulse Sensor - Shifter
//	EMP Grenade - hvTactical
//	Emergency Shield - Shifter
//	Plastique - Shifter
//	Satchel Charge - Shifter
//	Replicating Mine - Ideal
//	Hologram Mine: Renegades
//
$EMPDamageType         = 20;

GrenadeData SatchelShell
{
   bulletShapeName    = "grenade.dts";
   explosionTag       = rocketExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.2;
   mass               = 1.0;
   elasticity         = 0.45;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 1.6;
   damageType         = $DebrisDamageType;

   explosionRadius    = 25;
   kickBackStrength   = 250.0;
   maxLevelFlightDist = 1;
   totalTime          = 30.0;    // special meaning for grenades...
   liveTime           = 0.01;
   projSpecialTime    = 0.01;

   inheritedVelocityScale = 0.5;

   smokeName              = "smoke.dts";
};

GrenadeData EMPShell 
{ 
	bulletShapeName = "mortar.dts"; 
	explosionTag = EMPPulseExp; 
	collideWithOwner = True; 
	ownerGraceMS = 250; 
	collisionRadius = 0.3; 
	mass = 1.0; 
	elasticity = 0.45; 
	damageClass = 1; 
	damageValue = 0.05; 
	damageType = $EMPDamageType; 
	explosionRadius = 40; 
	kickBackStrength = 10.0; //-50.0 
	maxLevelFlightDist = 275; 
	totalTime = 30.0; 
	liveTime = 0.25; 
	projSpecialTime = 0.05; 
	inheritedVelocityScale = 0.5; 
	smokeName = "fusionbolt.dts"; 
	soundId = SoundELFFire; 
};

