// -- DropHUD -- v1.2 --------------------------------------------------------------------------------------
// Written by |HH|Crunchy (Jonathan Slark)
// Web page: http://www.planetstarsiege.com/crunchy/
// Email: crunchy@planetstarsiege.com
// Original concept by |HH|Rico.
// Icons designed by |HH|Crunchy and |HH|Rico.  Do NOT use the icons without permission.
//

//
// -- Group definitions --
//
// DropHUD::NewGroup(%group, %label, %bmp, %display);
//	Create a new group called %group, display if %display is equal to true and
//	represent the group using picture %bmp.  The %display is only the default,
//	this can be changed by the user in the options menu.  The label is defined by
//	%label, this is used for the pull down menu in the options screen.
//
// DropHUD::AddItem(%group, %item, %count);
//	Add an item to the group %group.  The item %item can be "DropAllAmmo" or an item
//	from Writer's inventory_table.cs.  You must put the item in quotes, eg "$Inv::Mine".
//	This is so that the variable isn't referenced straight away, the inventory table is
//	only created when we join a server.  You can add as many items to the group as you
//	want.
//
//	The optional %count says how many of this item type to drop.  If you don't use
//	this variable then all items of this type will be dropped.
//
// DropHUD::AddText(%group, %text);
//	Add a short text description, %text, for this group, %group.  This is used in
//	the options screen.
//

//
// -- Drop All --
//

DropHUD::NewGroup(drop_all, "Drop All", "DropHUD_drop_all", false);
DropHUD::AddText(drop_all, "Drop every item you have.");
// Items
DropHUD::AddItem(drop_all, "$Inv::Repair_Kit");
DropHUD::AddItem(drop_all, "$Inv::Grenade");
DropHUD::AddItem(drop_all, "$Inv::Mine");
DropHUD::AddItem(drop_all, "$Inv::Beacon");
// Packs
DropHUD::AddItem(drop_all, "$Inv::Energy_Pack", 1);
DropHUD::AddItem(drop_all, "$Inv::Sensor_Jammer_Pack", 1);
DropHUD::AddItem(drop_all, "$Inv::Repair_Pack", 1);
DropHUD::AddItem(drop_all, "$Inv::Shield_Pack", 1);
DropHUD::AddItem(drop_all, "$Inv::Ammo_Pack", 1);
DropHUD::AddItem(drop_all, "$Inv::Inventory_Station", 1);
DropHUD::AddItem(drop_all, "$Inv::Ammo_Station", 1);
DropHUD::AddItem(drop_all, "$Inv::Motion_Sensor", 1);
DropHUD::AddItem(drop_all, "$Inv::Pulse_Sensor", 1);
DropHUD::AddItem(drop_all, "$Inv::Sensor_Jammer", 1);
DropHUD::AddItem(drop_all, "$Inv::Camera", 1);
DropHUD::AddItem(drop_all, "$Inv::Turret", 1);
// Weapons
DropHUD::AddItem(drop_all, "$Inv::Blaster", 1);
DropHUD::AddItem(drop_all, "$Inv::Chaingun", 1);
DropHUD::AddItem(drop_all, "$Inv::Disc_Launcher", 1);
DropHUD::AddItem(drop_all, "$Inv::ELF_gun", 1);
DropHUD::AddItem(drop_all, "$Inv::Grenade_Launcher", 1);
DropHUD::AddItem(drop_all, "$Inv::Laser_Rifle", 1);
DropHUD::AddItem(drop_all, "$Inv::Mortar", 1);
DropHUD::AddItem(drop_all, "$Inv::Plasma_Gun", 1);
DropHUD::AddItem(drop_all, "$Inv::Targeting_Laser", 1);
// Ammo
DropHUD::AddItem(drop_all, "DropAllAmmo"); // Special item

//
// -- Drop Rig --
//

DropHUD::NewGroup(drop_rig, "Drop Rig", "DropHUD_drop_rig", true);
DropHUD::AddText(drop_rig, "Drop everything apart from the items you normally start with.");
// Items
DropHUD::AddItem(drop_rig, "$Inv::Grenade");
DropHUD::AddItem(drop_rig, "$Inv::Mine");
DropHUD::AddItem(drop_rig, "$Inv::Beacon");
// Packs
DropHUD::AddItem(drop_rig, "$Inv::Energy_Pack", 1);
DropHUD::AddItem(drop_rig, "$Inv::Sensor_Jammer_Pack", 1);
DropHUD::AddItem(drop_rig, "$Inv::Repair_Pack", 1);
DropHUD::AddItem(drop_rig, "$Inv::Shield_Pack", 1);
DropHUD::AddItem(drop_rig, "$Inv::Ammo_Pack", 1);
DropHUD::AddItem(drop_rig, "$Inv::Inventory_Station", 1);
DropHUD::AddItem(drop_rig, "$Inv::Ammo_Station", 1);
DropHUD::AddItem(drop_rig, "$Inv::Motion_Sensor", 1);
DropHUD::AddItem(drop_rig, "$Inv::Pulse_Sensor", 1);
DropHUD::AddItem(drop_rig, "$Inv::Sensor_Jammer", 1);
DropHUD::AddItem(drop_rig, "$Inv::Camera", 1);
DropHUD::AddItem(drop_rig, "$Inv::Turret", 1);
// Weapons
DropHUD::AddItem(drop_rig, "$Inv::ELF_gun", 1);
DropHUD::AddItem(drop_rig, "$Inv::Grenade_Launcher", 1);
DropHUD::AddItem(drop_rig, "$Inv::Laser_Rifle", 1);
DropHUD::AddItem(drop_rig, "$Inv::Mortar", 1);
DropHUD::AddItem(drop_rig, "$Inv::Plasma_Gun", 1);
DropHUD::AddItem(drop_rig, "$Inv::Targeting_Laser", 1);
// Ammo
DropHUD::AddItem(drop_rig, "$Inv::Grenade_Ammo");
DropHUD::AddItem(drop_rig, "$Inv::Mortar_Ammo");
DropHUD::AddItem(drop_rig, "$Inv::Plasma_Bolt");

//
// -- Other groups --
//

DropHUD::NewGroup(heavy_ammo, "Heavy Ammo", "DropHUD_heavy_ammo", false);
DropHUD::AddText(heavy_ammo, "Drop grenade and mortar ammo.");
DropHUD::AddItem(heavy_ammo, "$Inv::Grenade_Ammo", 1);
DropHUD::AddItem(heavy_ammo, "$Inv::Mortar_Ammo");

DropHUD::NewGroup(heavy_ammo2, "Heavy Ammo+", "DropHUD_heavy_ammo_plus", true);
DropHUD::AddText(heavy_ammo2, "Drop grenade and mortar ammo, plus repair kit, mines, grens and beacons.");
DropHUD::AddItem(heavy_ammo2, "$Inv::Grenade_Ammo");
DropHUD::AddItem(heavy_ammo2, "$Inv::Mortar_Ammo");
DropHUD::AddItem(heavy_ammo2, "$Inv::Repair_Kit");
DropHUD::AddItem(heavy_ammo2, "$Inv::Grenade");
DropHUD::AddItem(heavy_ammo2, "$Inv::Mine");
DropHUD::AddItem(heavy_ammo2, "$Inv::Beacon");

DropHUD::NewGroup(light_rig, "Light Rig", "DropHUD_light_rig", true);
DropHUD::AddText(light_rig, "Drop energy pack, some disc ammo, plus repair kit, mines, grens and beacons.");
DropHUD::AddItem(light_rig, "$Inv::Energy_Pack", 1);
DropHUD::AddItem(light_rig, "$Inv::Repair_Kit");
DropHUD::AddItem(light_rig, "$Inv::Grenade");
DropHUD::AddItem(light_rig, "$Inv::Mine");
DropHUD::AddItem(light_rig, "$Inv::Beacon");
DropHUD::AddItem(light_rig, "$Inv::Disc", 1);

DropHUD::NewGroup(pack_deployable, "Deployables", "DropHUD_pack_deployable", false);
DropHUD::AddText(pack_deployable, "Drop a deployable, including turret and camera etc.");
DropHUD::AddItem(pack_deployable, "$Inv::Inventory_Station", 1);
DropHUD::AddItem(pack_deployable, "$Inv::Ammo_Station", 1);
DropHUD::AddItem(pack_deployable, "$Inv::Motion_Sensor", 1);
DropHUD::AddItem(pack_deployable, "$Inv::Pulse_Sensor", 1);
DropHUD::AddItem(pack_deployable, "$Inv::Sensor_Jammer", 1);
DropHUD::AddItem(pack_deployable, "$Inv::Camera", 1);
DropHUD::AddItem(pack_deployable, "$Inv::Turret", 1);

//
// -- Single item groups --
//

DropHUD::NewGroup(repair_kit, "Repair Kit", "DropHUD_repair_kit", true);
DropHUD::AddText(repair_kit, "Drop repair kit.");
DropHUD::AddItem(repair_kit, "$Inv::Repair_Kit");

DropHUD::NewGroup(mines, "Mines", "DropHUD_mines", true);
DropHUD::AddText(mines, "Drop mines.");
DropHUD::AddItem(mines, "$Inv::Mine");

DropHUD::NewGroup(grenades, "Grenades", "DropHUD_grenades", false);
DropHUD::AddText(grenades, "Drop grenades.");
DropHUD::AddItem(grenades, "$Inv::Grenade");

DropHUD::NewGroup(beacons, "Beacons", "DropHUD_beacons", false);
DropHUD::AddText(beacons, "Drop beacons.");
DropHUD::AddItem(beacons, "$Inv::Beacon");

DropHUD::NewGroup(bullets, "Bullets", "DropHUD_bullets", false);
DropHUD::AddText(bullets, "Drop chaingun ammo.");
DropHUD::AddItem(bullets, "$Inv::Bullet");

DropHUD::NewGroup(grenade_ammo, "Grenade Ammo", "DropHUD_grenade_ammo", false);
DropHUD::AddText(grenade_ammo, "Drop grenade launcher ammo.");
DropHUD::AddItem(grenade_ammo, "$Inv::Grenade_Ammo");

DropHUD::NewGroup(mortar_ammo, "Mortar Ammo", "DropHUD_mortar_ammo", true);
DropHUD::AddText(mortar_ammo, "Drop mortar ammo.");
DropHUD::AddItem(mortar_ammo, "$Inv::Mortar_Ammo");

DropHUD::NewGroup(plasma_ammo, "Plasma Ammo", "DropHUD_plasma_ammo", false);
DropHUD::AddText(plasma_ammo, "Drop plasma gun ammo.");
DropHUD::AddItem(plasma_ammo, "$Inv::Plasma_Bolt");

DropHUD::NewGroup(disc_ammo, "Disc Ammo", "DropHUD_disc_ammo", false);
DropHUD::AddText(disc_ammo, "Drop disc launcher ammo.");
DropHUD::AddItem(disc_ammo, "$Inv::Disc");

DropHUD::NewGroup(pack_ammo, "Ammo Pack", "DropHUD_pack_ammo", false);
DropHUD::AddText(pack_ammo, "Drop ammo pack.");
DropHUD::AddItem(pack_ammo, "$Inv::Ammo_Pack", 1);

DropHUD::NewGroup(pack_energy, "Energy Pack", "DropHUD_pack_energy", false);
DropHUD::AddText(pack_energy, "Drop energy pack.");
DropHUD::AddItem(pack_energy, "$Inv::Energy_Pack", 1);

DropHUD::NewGroup(pack_jammer, "Sensor Jammer Pack", "DropHUD_pack_jammer", false);
DropHUD::AddText(pack_jammer, "Drop sensor jammer pack.");
DropHUD::AddItem(pack_jammer, "$Inv::Sensor_Jammer_Pack", 1);

DropHUD::NewGroup(pack_repair, "Repair Pack", "DropHUD_pack_repair", false);
DropHUD::AddText(pack_repair, "Drop repair pack.");
DropHUD::AddItem(pack_repair, "$Inv::Repair_Pack", 1);

DropHUD::NewGroup(pack_shield, "Shield Pack", "DropHUD_pack_shield", false);
DropHUD::AddText(pack_shield, "Drop shield pack.");
DropHUD::AddItem(pack_shield, "$Inv::Shield_Pack", 1);
