// !!!!!!!!!!! mHUD 3.0e -> 'Smart' Reticle / Rangefinder <- 5/6/99 !!!!!!!!!!!
// 
// By:
//    Cowboy
//    cowboy@planetstarsiege.com
//    http://www.planetstarsiege.com/cowboy/
//    ICQ# 31184463
// 
//    Lots of help, code, and reticles from GrymReaper - Kick ass!
//
// Features:
//
// * Supports resize-on-the-fly! (uses Presto's functions)
// * Different reticles for each base weapon, including a 'default' for mod
//   weapons.
// * All reticle sizes are now 63 pixels wide! It turns out that larger sizes
//   would overlap CmdHUD commander and inventory panels! That's no good!
// * Supports different Mortar & Grenade Launcher rangefinders for each major
//   resolution (I did 800x600 and Presto did 640x480 - but if you want to make
//   one for the resolution YOU use, email it to me and I'll include it!)
//
// Requires PrestoHUD 0.93+ and fully compatible with CmdHUD 1.0+
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// 
// Installation notes:
// 
// Unzip mHUD.gui into the tribes\gui directory. If this directory doesn't
// exist, create it! Unzip h_reticle.bmp into the tribes\base directory, and
// unzip all other files into \config\cowboy directory and add line: 
// Include("cowboy\\mHUD.cs"); to your autoexec.cs file somewhere AFTER the
// exec("presto\\install.cs"); line.
// 
// NOTE: This replaces the built-in crosshairs, and will overwrite your
//       crosshairs, so make a backup!
//
// This now supports resizing, although there are only correct rangefinder
// bitmaps for 640x480 and 800x600! If you want to create an _accurate_ one
// for a different resolution, do it up and mail it to me! If i use it here,
// you'll get the credit!
//
// Same goes for reticles! I have only got a few done.. If you can come up
// with better ones, send 'em over!
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// 
// (c) 1999 Cowboy, whatever... I hope you enjoy this, and all that I ask is 
// that you give me and GymReaper props for it.. enjoy!
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

Include("presto\\Event.cs");
Include("presto\\Inventory.cs");

//
// User settings:
//
// $mHUD::UpdateTime: how often we check for switching weapon status 
// $mHUD::InitInvTime: how long to wait before inventory station first loads
//
// you probably won't need to change these.. but if you do, here they are!

$mHUD::UpdateTime = 0.3;
$mHUD::InitInvTime = 0.5;

//
// If you want all the happenings of this script echoed to the console, set to
// true (shows lots of stuff!)
//
$mHUD::DebugMode = false;

//
// For Presto Pack 0.93+, this displays script info in a box on the main
// menu screen, kind of an 'Advertisement/Info Box' for installed scripts.
//

if ($Presto::version >= 0.93) {
	Presto::AddScriptBanner(mHUD,
		"<jc><f2>mHUD 3.0e <f1>by <f2>Cowboy\n" @
		"<f1>'Smart' Reticle / Rangefinder\n" @
		"\n" @
		"<f0>Supports Resize-On-The-Fly!\n" @
		"<f0>Thanks to <f1>GrymReaper<f0> for his\n"@
		"code and reticles! <f1>Awesome!\n" @
		"\n" @
		"<f1>Released 5/5/99 by Cowboy\n" @
		"cowboy@planetstarsiege.com");
	}

//
// define bitmaps used
//
$mHUD::Reticle[Default]		= "cowboy\\mHUD_reticle_Default.bmp";
$mHUD::Reticle[Blaster]		= "cowboy\\mHUD_reticle_Blaster.bmp"; 
$mHUD::Reticle[Plasma]		= "cowboy\\mHUD_reticle_Plasma.bmp"; 
$mHUD::Reticle[Chaingun]	= "cowboy\\mHUD_reticle_Chaingun.bmp"; 
$mHUD::Reticle[Disc]		= "cowboy\\mHUD_reticle_Disc.bmp"; 
$mHUD::Reticle[Grenade]		= "cowboy\\mHUD_reticle_Grenade.bmp";
$mHUD::Reticle[Laser]		= "cowboy\\mHUD_reticle_Laser.bmp"; 
$mHUD::Reticle[Elf]		= "cowboy\\mHUD_reticle_Elf.bmp"; 
$mHUD::Reticle[Mortar]		= "cowboy\\mHUD_reticle_Mortar.bmp"; 
$mHUD::Reticle[Target]		= "cowboy\\mHUD_reticle_Target.bmp"; 

//
// add tags, hopefully these id #'s will never be used!
//
IDBMP_MHUD_RANGE_MORTAR 	= 00160950, "cowboy\\mHUD_rangefinder_Mortar_800.bmp";
IDBMP_MHUD_RANGE_GRENADE 	= 00160951, "cowboy\\mHUD_rangefinder_Grenade_800.bmp";
IDBMP_MHUD_RETICLE_DEFAULT 	= 00160952, "cowboy\\mHUD_reticle_Default.bmp";
IDBMP_MHUD_RETICLE_BLASTER 	= 00160953, "cowboy\\mHUD_reticle_Blaster.bmp"; 
IDBMP_MHUD_RETICLE_PLASMA 	= 00160954, "cowboy\\mHUD_reticle_Plasma.bmp"; 
IDBMP_MHUD_RETICLE_CHAINGUN	= 00160955, "cowboy\\mHUD_reticle_Chaingun.bmp"; 
IDBMP_MHUD_RETICLE_DISC 	= 00160956, "cowboy\\mHUD_reticle_Disc.bmp"; 
IDBMP_MHUD_RETICLE_GRENADE 	= 00160957, "cowboy\\mHUD_reticle_Grenade.bmp";
IDBMP_MHUD_RETICLE_LASER 	= 00160958, "cowboy\\mHUD_reticle_Laser.bmp"; 
IDBMP_MHUD_RETICLE_ELF 		= 00160959, "cowboy\\mHUD_reticle_Elf.bmp"; 
IDBMP_MHUD_RETICLE_MORTAR 	= 00160960, "cowboy\\mHUD_reticle_Mortar.bmp"; 
IDBMP_MHUD_RETICLE_TARGET 	= 00160961, "cowboy\\mHUD_reticle_Target.bmp"; 
IDBMP_MHUD_RESERVED1 		= 00160962, "cowboy\\mHUD_rangefinder_Mortar_640.bmp";
IDBMP_MHUD_RESERVED2 		= 00160963, "cowboy\\mHUD_rangefinder_Grenade_640.bmp";
IDBMP_MHUD_RESERVED3 		= 00160964, "cowboy\\mHUD_rangefinder_Mortar_unknown.bmp";
IDBMP_MHUD_RESERVED4 		= 00160965, "cowboy\\mHUD_rangefinder_Grenade_unknown.bmp";
IDBMP_MHUD_RESERVED5 		= 00160966, "";
IDBMP_MHUD_RESERVED6 		= 00160967, "";
IDBMP_MHUD_RESERVED7 		= 00160968, "";
IDBMP_MHUD_RESERVED8 		= 00160969, "";

//
// This constantly runs and checks to see if the which weapon is loaded
//
// 'Safe' scheduling code from Presto! thanks!
//
function scheduled_mHUD::Timer(%id) {
   if (%id != $mHUD_scheduled_id)
      return;
   mHUD::Timer();
   schedule("scheduled_MHUD::Timer("@$mHUD_scheduled_id@");", $mHUD::UpdateTime);
   }
 
function schedule_mHUD::Timer() {
   $mHUD_scheduled_id++;
   schedule("scheduled_mHUD::Timer("@$mHUD_scheduled_id@");", $mHUD::UpdateTime);
   }
 
Event::Attach(eventConnected, schedule_MHUD::Timer);
 
function mHUD::Timer() {
	if (!$mHUD::Initialized && getMountedItem(0) != -1) {
		$mHUD::Initialized = true;
		mHUD::Init();
		}
	if ($mHUD::LastResolution != Presto::ScreenSize())
		mHUD::UpdateResolution();
		
	if ($Inv::Name[getMountedItem(0)] != $mHUD::LastWeapon)
		mHUD::UpdateReticle();
		
	if (included("cowboy\\CmdHUD.cs") && $CmdHUD::guiMode == 2) {
		if ($CmdHUD::MapState && !$mHUD::CmdHUD::ReticleState) {
			$mHUD::CmdHUD::ReticleState = true;
			mHUD::SetVisible(RangeFinder, $mHUD::CmdHUD::ReticleState);
			mHUD::SetVisible(Reticle, $mHUD::CmdHUD::ReticleState);
			}
		else if (!$CmdHUD::MapState && $mHUD::CmdHUD::ReticleState) {
			$mHUD::CmdHUD::ReticleState = false;
			mHUD::SetVisible(RangeFinder, $mHUD::CmdHUD::ReticleState);
			mHUD::SetVisible(Reticle, $mHUD::CmdHUD::ReticleState);
			}
		}
	}

function mHUD::UpdateResolution() {
	$mHUD::LastResolution = Presto::ScreenSize();
	$mHUD::X = getWord($mHUD::LastResolution, 0);
	$mHUD::Y = getWord($mHUD::LastResolution, 1);

	if ($mHUD::DebugMode) echo($mHUD::X @ ", " @ $mHUD::Y);
	
	if ($mHUD::X == 640) {
		$mHUD::Rangefinder[Mortar]	= "cowboy\\mHUD_rangefinder_Mortar_640.bmp";
		$mHUD::Rangefinder[Grenade]	= "cowboy\\mHUD_rangefinder_Grenade_640.bmp";
		}
	else if ($mHUD::X == 800) {
		$mHUD::Rangefinder[Mortar]	= "cowboy\\mHUD_rangefinder_Mortar_800.bmp";
		$mHUD::Rangefinder[Grenade]	= "cowboy\\mHUD_rangefinder_Grenade_800.bmp";
		}
	else {
		$mHUD::Rangefinder[Mortar]	= "cowboy\\mHUD_rangefinder_Mortar_unknown.bmp";
		$mHUD::Rangefinder[Grenade]	= "cowboy\\mHUD_rangefinder_Grenade_unknown.bmp";
		}
	}
	


function mHUD::UpdateReticle() {
	if (getMountedItem(0) == -1) {
		$mHUD::RangeFinderVisible = false;
		$mHUD::ReticleVisible = false;
		}
	else if ($Inv::Name[getMountedItem(0)] == "Blaster") {
		$mHUD::CurrentReticle = Blaster;
		$mHUD::RangeFinderVisible = false;
		$mHUD::ReticleVisible = true;
		}
	else if ($Inv::Name[getMountedItem(0)] == "Plasma Gun") {
		$mHUD::CurrentReticle = Plasma;
		$mHUD::RangeFinderVisible = false;
		$mHUD::ReticleVisible = true;
		}
	else if ($Inv::Name[getMountedItem(0)] == "Chaingun") {
		$mHUD::CurrentReticle = Chaingun;
		$mHUD::RangeFinderVisible = false;
		$mHUD::ReticleVisible = true;
		}
	else if ($Inv::Name[getMountedItem(0)] == "Disc Launcher") {
		$mHUD::CurrentReticle = Disc;
		$mHUD::RangeFinderVisible = false;
		$mHUD::ReticleVisible = true;
		}
	else if ($Inv::Name[getMountedItem(0)] == "Grenade Launcher") {
		$mHUD::CurrentRangeFinder = Grenade;
		$mHUD::CurrentReticle = Grenade;
		$mHUD::RangeFinderVisible = true;
		$mHUD::ReticleVisible = true;
		}
	else if ($Inv::Name[getMountedItem(0)] == "Laser Rifle") {
		$mHUD::CurrentReticle = Laser;
		$mHUD::RangeFinderVisible = false;
		$mHUD::ReticleVisible = true;
		}
	else if ($Inv::Name[getMountedItem(0)] == "ELF gun") {
		$mHUD::CurrentReticle = ELF;
		$mHUD::RangeFinderVisible = false;
		$mHUD::ReticleVisible = true;
		}
	else if ($Inv::Name[getMountedItem(0)] == "Mortar") {
		$mHUD::CurrentRangeFinder = Mortar;
		$mHUD::CurrentReticle = Mortar;
		$mHUD::RangeFinderVisible = true;
		$mHUD::ReticleVisible = true;
		}
	else if ($Inv::Name[getMountedItem(0)] == "Targeting Laser") {
		$mHUD::CurrentReticle = Target;
		$mHUD::RangeFinderVisible = false;
		$mHUD::ReticleVisible = true;
		}
	else {
		$mHUD::CurrentReticle = Default;
		$mHUD::RangeFinderVisible = false;
		$mHUD::ReticleVisible = true;
		}
	$mHUD::LastWeapon = $Inv::Name[getMountedItem(0)];
	
	mHUD::LoadBitmaps();
	}

function mHUD::LoadBitmaps() {
	$mHUD::CmdHUD::ReticleState = true;
	mHUD::SetVisible(RangeFinder, $mHUD::RangeFinderVisible);
	mHUD::SetVisible(Reticle, $mHUD::ReticleVisible);
	
	mHUD::SetValue(RangeFinder, $mHUD::RangeFinder[$mHUD::CurrentRangeFinder]);
	mHUD::SetValue(Reticle, $mHUD::Reticle[$mHUD::CurrentReticle]);
	}


function mHUD::SetVisible(%object, %state) {
	Control::SetVisible("mHUD::Frame::" @ %object @ "::" @ $mHUD::Counter, %state);
	if ($mHUD::DebugMode) echo("SetVisible: mHUD::Frame::" @ %object @ "::" @ $mHUD::Counter @ ", "@ %state);
	}

function mHUD::SetValue(%object, %value) {
	Control::SetValue("mHUD::Frame::" @ %object @ "::" @ $mHUD::Counter, "<B" @ %value @ ">");
	if ($mHUD::DebugMode) echo("SetValue: mHUD::Frame::" @ %object @ "::" @ $mHUD::Counter @ ", <B" @ %value @ ">");
	}

function mHUD::CreateRangeFinder(%gui) {
	%var = newobject("mHUD::Frame::RangeFinder::" @ $mHUD::Counter, FearGuiFormattedText, $mHUD::X / 2 - 35, $mHUD::Y / 2 + 35, 63, 255);
	addToSet(%gui, %var);
	if ($mHUD::DebugMode) echo("mHUD::Frame::RangeFinder::" @ $mHUD::Counter @ " Created in " @ %gui);
	return %var;
	}

function mHUD::CreateReticle(%gui) {
	%var = newobject("mHUD::Frame::Reticle::" @ $mHUD::Counter, FearGuiFormattedText, $mHUD::X / 2 - 35, $mHUD::Y / 2 - 31, 63, 63);
	addToSet(%gui, %var);
	if ($mHUD::DebugMode) echo("mHUD::Frame::Reticle::" @ $mHUD::Counter @ " Created in " @ %gui);
	return %var;
	}

function mHUD::DeleteRangeFinder(%gui, %var) {
	removeFromSet(%gui, %var);
	if ($mHUD::DebugMode) echo("mHUD::Frame::RangeFinder::" @ $mHUD::Counter @ " Deleted from " @ %gui);
	return %var;
	}

function mHUD::DeleteReticle(%gui, %var) {
	removeFromSet(%gui, %var);
	if ($mHUD::DebugMode) echo("mHUD::Frame::Reticle::" @ $mHUD::Counter @ " Deleted from " @ %gui);
	return %var;
	}
	
//
// Initialize the objects: load the gui, get the IDs, move stuff around
//
function mHUD::Init() {
	guiPushDialog(MainWindow, "gui\\mhud.gui");
	guiPopDialog(MainWindow, "gui\\mhud.gui");

	Event::Attach(eventConnected, mHUD::Reset);
	Event::Attach(eventChangeMission, mHUD::Reset);
	if ($mHUD::DebugMode) echo("mHUD Initialized");

	if (!included("cowboy\\CmdHUD.cs")) {
		$mHUD::Counter++;
		$mHUD::RangeFinderFrame = mHUD::CreateRangeFinder(playGui);
		$mHUD::ReticleFrame = mHUD::CreateReticle(playGui);
		mHUD::LoadBitmaps();
		}
	}

//
// Detect what gui you are in, if you use CmdHUD
//
function mHUD::GuiOpen(%gui) {
	if ($mHUD::DebugMode) echo("GuiOpen: " @ %gui);
	if (included("cowboy\\CmdHUD.cs")) {
 		if (%gui == "playGui" || %gui == "CommandGui" || %gui == "CmdInventoryGui") {
			$mHUD::Counter++;
			$mHUD::RangeFinderFrame = mHUD::CreateRangeFinder(%gui);
			$mHUD::ReticleFrame = mHUD::CreateReticle(%gui);
			mHUD::LoadBitmaps();
			}
		}
	}

//
// Detect what gui you just left, if you use CmdHUD
//
function mHUD::GuiClose(%gui) {
	if ($mHUD::DebugMode) echo("GuiClose: " @ %gui);
	if (included("cowboy\\CmdHUD.cs")) {
		mHUD::DeleteRangeFinder(%gui, $mHUD::RangeFinderFrame);
		mHUD::DeleteReticle(%gui, $mHUD::ReticleFrame);
		}
	}

//
// Reset all objects and variables
//
function mHUD::Reset() {
	$mHUD::LastWeapon = "";
	if ($mHUD::DebugMode) echo("mHUD Reset");
	}

$mHUD::Counter = 0;
$mHUD::Initialized = false;
$mHUD::InventoryInitialized = false;

Event::Attach(eventConnected, mHUD::Timer);

Event::Attach(eventGuiOpen, mHUD::GuiOpen);
Event::Attach(eventGuiClose, mHUD::GuiClose);
