; RULE*.INI
; *** Tiberian Sun Rules ***
; If placed in game directory, it will override built in values. Values to be used as multipliers
; or percentages can be specified as either a simple floating point number (embed ".") or as a
; conventional percentage number (append "%"). Values used as distances or time delays
; are specified as simple floating point number. Distance values are expressed in cells. Time
; values are expressed in minutes.
; If multiple rules files are present, the Name field is used to identify between them.

[General]
Name=Tiberian Sun -- Official Rules of Engagement

; veteran factors
VeteranRatio=10.0       ; must destroy this multiple of self-value to become a veteran [per level]
VeteranCombat=.25       ; combat BONUS factor when unit is a veteran
VeteranSpeed=.30        ; speed BONUS factor when unit is a veteran
VeteranSight=0.0        ; sight range BONUS when unit is a veteran
VeteranArmor=.25        ; armor BONUS when unit is a veteran
VeteranROF=.20          ; rate of fire BONUS when unit is a veteran
VeteranCap=2            ; maximum veteran level that can be obtained
InitialVeteran=no       ; Do initial forces start as veterans?

; repair and refit
RefundPercent=50%       ; percent of original cost to refund when building/unit is sold
ReloadRate=.5           ; minutes to reload each ammo point for aircraft or helicopters
RepairPercent=20%       ; percent cost to fully repair as ratio of full cost
RepairRate=.016         ; minutes between applying repair step
RepairStep=8            ; hit points to heal per repair 'tick'
URepairRate=.016        ; [units only] minutes between applying repair step
IRepairRate=.001        ; [infantry only] minutes between applying repair step
IRepairStep=1           ; [infantry only] hit points to heal per repair 'tick' for infantry
TiberiumHeal=.010       ; minutes between applying Tiberium healing [for those units that heal in Tiberium]

; income and production
;BailCount=28            ; number of 'bails' carried by a harvester
BuildSpeed=.8           ; general build speed [time (in minutes) to produce a 1000 credit cost item]
BuildupTime=.06         ; average minutes that building build-up animation runs
GrowthRate=5            ; minutes between ore (Tiberium) growth
TiberiumGrows=yes       ; Does ore grow denser over time?
TiberiumSpreads=yes     ; Does ore spread into adjacent areas?
SeparateAircraft=yes    ; Is first helicopter to be purchased separately from helipad?
SurvivorRate=.4         ; fraction of building cost to be converted to survivors when sold
SurvivorDivisor=100     ; the divisor into the survivor rate value to determine the number of survivors
PlacementDelay=.05      ; delay before retrying produced object deploy if temporary blockage detected
WeedCapacity=56         ; Amount of weed that needs to be harvested by a house in order to build the chem missile

; computer and movement controls
CurleyShuffle=yes       ; Should helicopter shuffle position between shots [as in C&C]?
BaseBias=2              ; multiplier to threat target value when enemy is close to friendly base
BaseDefenseDelay=.25    ; minutes delay between sending response teams to deal with base threat
CloseEnough=2.25        ; If distance to destination less than this, then abort movement if otherwise blocked.
DamageDelay=1           ; minutes between applying trivial structure damage when low on power
GameSpeedBias=1         ; multiplier to overall game object movement speed
Stray=2.0               ; radius distance (cells) that team members may stray without causing regroup action
CloakDelay=.02          ; forced delay that subs will remain on surface before allowing to submerge
SuspendDelay=2          ; minutes that suspended teams will remain suspended
SuspendPriority=1       ; teams with less than this priority will suspend during base defense ops
FlightLevel=600         ; typical flight level for aircraft [above ground level]
MissileSpeedVar=.25     ; speed flucuation percentage that guided missiles have
MissileROTVar=.25       ; rate of turn fluctuation percentage that guided missiles have

TeamDelays=2250,2700,3600              ; interval between checking for and creating teams, by difficulty level
AIHateDelays=5400,4500,4050             ; delay in frames before the computer chooses an enemy, by difficulty level
AIAlternateProductionCreditCutoff=3000 ; when the AI house has less credits than this it will begin
                                        ; to spend money more conservatively
NodAIBuildsWalls=no
AIBuildsWalls=no
MultiplayerAICM=250,200,100
HealScanRadius=10       ; how far should medic-type units scan for targets?  Used to override the range
                        ; of these units, because they need to have very short ranges
FillEarliestTeamProbability=100,80,60 ; (by difficulty level, from hardest to easiest)
MinimumAIDefensiveTeams=4,3,2    ; (by difficulty level, from hardest to easiest)
MaximumAIDefensiveTeams=6,5,4	 ; "                                            "
TotalAITeamCap=14,12,10   ; (by difficulty level, from hardest to easiest)
UseMinDefenseRule=yes
DissolveUnfilledTeamDelay=9000	; how long to wait before dissolving an ai trigger team that has no members (multiplay only)
LargeVisceroid=VISC_LRG  ; when two small visceroids combine they turn into this
SmallVisceroid=VISC_SML  ; when infantry transmorgifies into a visceroid

; controls how the computer AI scores potential ion cannon targets
; the first value is for hard computer opponents, next for normal, and finally for easy
; right now, normal and hard are the same, because on hard, the computer will actually wait for
; production on an object to finish if that object is the best target; in this way all three
; difficulty levels are different.
AIIonCannonConYardValue=100,100,100
AIIonCannonWarFactoryValue=50,50,50
AIIonCannonPowerValue=10,10,40
AIIonCannonEngineerValue=30,30,5
AIIonCannonThiefValue=20,20,5
AIIonCannonHarvesterValue=1,1,1
AIIonCannonMCVValue=150,150,20
AIIonCannonAPCValue=15,15,15
AIIonCannonBaseDefenseValue=35,35,35
AIIonCannonPlugValue=40,40,40
AIIonCannonHelipadValue=20,20,20
AIIonCannonTempleValue=40,40,40

; Ion storm control
IonLightningFrequency=10  ; Percent chance that lightning will strike this frame
IonLightningRandomness=90 ; Percent chance that the lightning will strike a random cell instead of an object.
IonLightningDamage=500    ; Damage done by lightning strike.
IonStormDuration=120      ; Default ion storm duration in deconds. This is overriden by the trigger control.
IonStormWarning=31        ; Warning time in seconds before an Ion Storm hits.
IonStorms=no              ; Are random ion storms going to appear?
IonStormWarhead=IonWH	  ; Warhead used by ion storm strike.

; misc
FogOfWar=no             ; Is fog of war enabled?
Visceroids=no           ; Are randomly appearing visceroids going to occur?
Meteorites=no           ; Are tiberium meteorites going to occur?
CrewEscape=50%          ; percent chance that crew will escape from destroyed vehicle
CameraRange=9           ; distance around spy camera to reveal map
FineDiffControl=no      ; Allow 5 difficulty settings instead of only 3 settings?
Pilot=E1                ; pilot type that parachutes out of aircraft
Crew=E1                 ; soldier that emerges from destroyed unit or building
Technician=CTECH        ; civilian infantry type to serve as technician survivor [should be armed variety]
Engineer=ENGINEER       ; special (limited supply) infantry survivor from construction yards [probably engineer type]
Disguise=E1             ; infantry type to appear as when disguised and viewed by the enemy
Paratrooper=E1          ; infantry that is dropped as a paratrooper

; droppod flight characteristics
DropPodWeapon=Vulcan2   ; weapon mounted on drop pod
DropPodHeight=2000      ; height above ground that drop pods appear at
DropPodSpeed=75         ; speed of drop pod's descent
DropPodAngle=0.79       ; angle of descent for drop pod [radians; .40=flat,1.18=steep]

; hover vehicle characteristics
HoverHeight=120         ; height of hovering vehicles
HoverDampen=40%         ; dampening effect on hover vehicle bounciness
HoverBob=.04            ; time between hover 'bobs'
HoverBoost=150%         ; hover speed when traveling on straight away
HoverAcceleration=.02   ; time to accelerate to full speed
HoverBrake=.03          ; time to decelerate to full stop

; subterrainean vehicle characteristics
TunnelSpeed=1

; production & power effects
MultipleFactory=0       ; factory bonus for multiples [1=full bonus, 0=no bonus] (def=1)
MinProductionSpeed=.5   ; minimum production speed as result of low power (def=.5)

; hack section
GDIGateOne=GAGATE_A      ; these buildings affect nearby walls, so I need to know what they are
GDIGateTwo=GAGATE_B
WallTower=GACTWR
NodGateOne=NAGATE_A
NodGateTwo=NAGATE_B
NodRegularPower=NAPOWR
NodAdvancedPower=NAAPWR
GDIPowerPlant=GAPOWR
GDIPowerTurbine=GAPOWRUP
GDIHunterSeeker=GHUNTER
NodHunterSeeker=NHUNTER
GDIFirestormGenerator=GAFIRE

RepairBay=GADEPT        ; building to go to when in need of repairs
BaseUnit=MCV            ; unit to consider "home" when no buildings are present
HarvesterUnit=HARV      ; preferred unit(s) to build for harvesting purposes
PadAircraft=ORCA,ORCAB   ; aircraft that can be produced (and land at) a helipad (or ground)

; Bret's hack section
TreeStrength=200 ; 25
WindDirection=1         ; Direction of wind (gets converted to a FacingType, so 0 is north
                        ; and increasing numbers rotate clockwise)
TrackedUphill=.5        ; coefficient for tracked vehicle movement uphill
TrackedDownhill=1.1     ; coefficient for tracked vehicle movement downhill
WheeledUphill=.5        ; coefficient for wheeled vehicle movement uphill
WheeledDownhill=1.2     ; coefficient for wheeled vehicle movement downhill
LeptonsPerSightIncrease=2000 ;how high does a unit have to go before it can see farther?
LeptonsPerFireIncrease=2000 ; how high does a unit have to go before it can fire farther?
AttackingAircraftSightRange=6
BlendedFog=yes          ; should we blend the fog (as opposed to dither it)
CliffBackImpassability=2 ; how impassable is it behind cliffs? (0 = minimal, 2 = maximal)
IceCrackingWeight=2.0   ; objects weighing more than this will crack ice
IceBreakingWeight=4.0   ; objects weighing more than this well break through ice
CloakingStages=9
TiberiumTransmogrify=40
TreeFlammability=.05
CraterLevel=1           ; controls how big the craters from meteorites are.
                        ; 0 is no cratering, while 4 is the largest craters.
;StatisticTimeInterval=30; controls how many seconds pass between statistic calculations, for score screen graphs
BridgeVoxelMax=3        ; maximum debris from each destroyed bridge section (def=3)
WallBuildSpeedCoefficient=.5  ; how much faster than normal objects do walls build?
WorstLowPowerBuildRateCoefficient=.3 ; what is the lowest the build rate can get for being low on power?
BestLowPowerBuildRateCoefficient=.75 ; what is the highest the build rate can get when in a low power condition?
AllowShroudedSubteranneanMoves=true
AircraftFogReveal=6
MaximumQueuedObjects=4
MaxWaypointPathLength=15

; firestorm defense controls
ChargeToDrainRatio=.333
DamageToFirestormDamageCoefficient=.1

; veinhole monster parameters
; VeinholeMonsterStrength=1000   ; no longer used.  To modify veinhole monster strength, edit the [VEINTREE] entry
VeinholeGrowthRate=300		; was 3000
VeinholeShrinkRate=100		; was 500
MaxVeinholeGrowth=2000
VeinDamage=5
VeinholeTypeClass=VEINTREE

; AI trigger weighting parameters
AITriggerSuccessWeightDelta=5
AITriggerFailureWeightDelta=-5
AITriggerTrackRecordCoefficient=1

; Some spotlight controls
SpotlightSpeed=.015     ; speed in radians
SpotlightMovementRadius=2000 ; offset of center of arc sweep
SpotlightLocationRadius=1000 ; offset from building
SpotlightAcceleration=.0025    ; acceleration in radians
SpotlightAngle=.5       ; maximum suggest angle of arc sweep

; Controls for radar events
; The events, in order, are:
; (1) Generic Combat Event,
; (2) Generic Noncombat Event,
; (3) Dropzone Event,
; (4) Base Under Attack Event,
; (5) Harvester Under Attack Event,
; (6) Enemy Object Sensed Event
; So, for example, to change the visibility duration of the Harvester Under Attack Event,
; you would change the fifth number in the list for RadarEventVisibilityDurations
;
RadarEventSuppressionDistances=8, 8, 8, 8, 8, 6			; suppression distance in cells
RadarEventVisibilityDurations=200,200,200,200,200,200  ; event visibility in frames
RadarEventDurations=400,400,400,400,400,400  ;  event duration in frames
FlashFrameTime=7
RadarCombatFlashTime=49	; this should ALWAYS be an odd multiple of FlashFrameTime, ie RadarCombatFlashTime / FlashFrameTime should be an odd number
RadarEventMinRadius=8
RadarEventSpeed=1.2
RadarEventRotationSpeed=.05
RadarEventColorSpeed=.1

RevealTriggerRadius=9   ; the sight range of a "reveal around waypoint" trigger, 10 is maximum

; id holders for particle systems and voxel debris
ExplosiveVoxelDebris=GASTANK,PIECE ; name of explosive voxel debris
TireVoxelDebris=TIRE    ; name of tire voxel debris
ScrapVoxelDebris=PIECE  ; name of scrap metal voxel debris
OKBuildingSmokeSystem=SmokeStackSys
DamagedBuildingSmokeSystem=SmallSmokeSys
DamagedUnitSmokeSystem=VSSmokeSys
DebrisSmokeSystem=VSSmokeSys

; Building prerequisite categories are specified here.
PrerequisitePower=GAPOWR,NAPOWR,NAAPWR
PrerequisiteFactory=GAWEAP,NAWEAP
PrerequisiteBarracks=NAHAND,GAPILE
PrerequisiteRadar=GARADR,NARADR
PrerequisiteTech=GATECH,NATECH

; hunter seeker controls
HunterSeekerDetonateProximity=150
HunterSeekerDescendProximity=700
HunterSeekerAscentSpeed=40
HunterSeekerDescentSpeed=50
HunterSeekerEmergeSpeed=6

; default threat evaluation controls
MyEffectivenessCoefficientDefault=200
TargetEffectivenessCoefficientDefault=-200
TargetSpecialThreatCoefficientDefault=200
TargetStrengthCoefficientDefault=-200
TargetDistanceCoefficientDefault=-10

; defaults for dumb threat evaluation
DumbMyEffectivenessCoefficient=200
DumbTargetEffectivenessCoefficient=200
DumbTargetSpecialThreatCoefficient=200
DumbTargetStrengthCoefficient=200
DumbTargetDistanceCoefficient=-1

EnemyHouseThreatBonus=400

; ******* Jumpjet Flight rules *******
; Jumpjet movement controls
[JumpjetControls]
TurnRate=4
Speed=14
Climb=5
CruiseHeight=500	; cruiseheight should be higher than a bridge, just to be safe
Acceleration=2
WobblesPerSecond=.15 ; was .25
WobbleDeviation=40 ; was 40

; ******* Special Weapon rules *******
; Special weapon rules are specified here.
[SpecialWeapons]
HSBuilding=GAPLUG,NATMPL ; list of buildings the hunter seeker tries to pop out of
NukeWarhead=Nuke        ; warhead used by falling nuke missile
NukeDown=NukeDown       ; nuclear missile as it descends
NukeProjectile=NukeUp   ; nuclear missile (from silo) projectile to launch
EMPulseWarhead=EMPuls   ; warhead used by falling nuke missile
EMPulseProjectile=PulsPr ; nuclear missile (from silo) projectile to launch

; ******* Audio / Visual rules *******
; General controls that deal with audio or visual appearance of
; the game or the units therein are specified here.
[AudioVisual]
UnloadingHarvester=HORV ; harvester image to use when unloading tiberium
PoseDir=2               ; aircraft landing facing (0=N, 1=NE, 2=E, etc)
DropPodPuff=DROPEXP     ; animation to play when drop pod hits the ground
WaypointAnimationSpeed=10	; how fast do the waypoint markers animate?
BarrelExplode=EXPLOLRG  ; exploding crates animation
BarrelDebris=GASTANK,PIECE  ; exploding crate debris list
BarrelParticle=SmallGreySSys
Wake=WAKE2              ; wake effect when traveling on/over water
VeinAttack=VEINATAC
DropPod=DROPPOD,DROPPOD2 ; mark to leave after drop pod lands
DeadBodies=DEATH_A,DEATH_B,DEATH_C,DEATH_D,DEATH_E,DEATH_F   ; choice of dead bodies to leave around
MetallicDebris=DBRIS1LG,DBRIS2LG,DBRIS3LG,DBRIS4LG,DBRIS5LG,DBRIS6LG,DBRIS7LG,DBRIS8LG,DBRIS9LG,DBRS10LG,DBRIS1SM,DBRIS2SM,DBRIS3SM,DBRIS4SM,DBRIS5SM,DBRIS6SM,DBRIS7SM,DBRIS8SM,DBRIS9SM,DBRS10SM
BridgeExplosions=TWLT026,TWLT036,TWLT050,TWLT070	; the explosions to use for the bridge explosion effect
DigSound=SUBDRIL1       ; sound when digging into the ground
Dig=DIG                 ; anim to play when unit digs into ground
IonBlast=RING1          ; initial anim when ion cannon hits
IonBeam=IONBEAM
InfantryExplode=S_BANG34 ; animation when infantry just explodes
AtmosphereEntry=PODRING ; animation to use when drop pod enters atmosphere
GateUp=GATEUP1          ; sound of gate rising
GateDown=GATEDWN1       ; sound of gate lowering
ShroudGrow=no           ; Does the shroud grow back over time?
ScrollMultiplier=.07     ; multiplier to default scroll speed
ShakeScreen=400         ; divide object strength by this to determine if the screen shakes when destroyed
CloakSound=CLOAK5       ; sound of cloaking or decloaking
SellSound=CASHTURN      ; sound of selling objects (typically buildings)
GameClosed=BLEEP1       ; game closed sound
IncomingMessage=Message1  ; incoming message sound
SystemError=BOOP        ; system error sound
OptionsChanged=Notify   ; options have changed sound
GameForming=GAMEFRM1    ; game forming sound
PlayerLeft=BOOP			; player has left sound
PlayerJoined=BOOP     ; player has joined sound
Construction=BOOP     ; sound of building construction
CreditTicks=CREDUP1,CREDDWN1 ; credit tick up and down sounds
CrumbleSound=CRMBLE2    ; building crumble sound when building is completely destroyed
BuildingSlam=PLACE2     ; placing building down sound
RadarOn=COMMUP1         ; radar activation sound
RadarOff=RADARDN1       ; radar deactivation sound
ScoldSound=SCOLD8       ; generic scold sound
TeslaCharge=OBELPOWR    ; tesla charge up sound
TeslaZap=OBELRAY1       ; tesla zap sound
BlowupSound=EXPNEW01    ; sound when building is damaged to half strength
ChuteSound=BOOP         ; parachute deploy sound
GenericClick=CLICKY1    ; generic click sound
GenericBeep=BLEEP1      ; generic beep sound
BuildingDrop=PLACE2     ; sound of building being placed down
StopSound=Notify		;Sound when units are commanded to stop
GuardSound=Notify		;Sound when units are commanded to guard
ScatterSound=Notify	;Sound when units are commanded to scatter
DeploySound=27-I002	;Sound when units are commanded to deploy
LightningSound=  ; Commented out because sound was way too annoying (AI)
TreeFire=FIRE2,FIRE1    ; small and large fires to attach to burning trees
OnFire=FIRE3,FIRE2,FIRE1 ; list of flames to use when something catches fire [must be 3 in list]
FlamingInfantry=FLAMEGUY  ; anim to use for special onfire infantry logic
Smoke=xxxx           ; smoke that rises from the ground after a building explosion
FirestormActiveAnim=GAFSDF_A
FirestormIdleAnim=FSIDLE
FirestormGroundAnim=FSGRND
FirestormAirAnim=FSAIR
MoveFlash=RING          ; movement destination click feedback animation
Parachute=PARACH        ; big parachute used for paratroopers
BombParachute=PARABOMB  ; parachute used for parabombs and other parachuted ordinance
SmallFire=FIRE3         ; animation for small fire [used after napalm]
LargeFire=FIRE2         ; animation for large fire [used after napalm]
AllyReveal=yes          ; Allies automatically reveal radar maps to each other?
ConditionRed=25%        ; when damaged to this percentage, health bar turns red
ConditionYellow=50%     ; when damaged to this percentage, health bar turns yellow
DropZoneRadius=4        ; distance around drop zone flair that map reveals itself
DropZoneAnim=BEACON     ; animation to use for the drop zone flair
EnemyHealth=yes         ; Show enemy health bar graph when selected?
Gravity=6               ; gravity constant for ballistic projectiles
IdleActionFrequency=.15 ; average minutes between infantry performing idle actions
MessageDelay=.6         ; time duration of multiplayer messages displayed over map
MovieTime=.06           ; minutes that movie recorder will record when activated (debug version only)
NamedCivilians=no       ; Show true names over civilians and civilian buildings?
SavourDelay=.1          ; delay between scenario end and ending movie [keep the delay short]
ShroudRate=4            ; minutes between each shroud creep process [0 means no shadow creep]
FogRate=.5
IceGrowthRate=1.5
IceSolidifyFrameTime=1000 ; how many frames between when ice is cracked and when it gets solidified
IceCrackSounds=ICECRAK1,ICECRAK2,ICECRAK3
AmbientChangeRate=.2    ; how many minutes between ambient light recalculations
AmbientChangeStep=.1    ; step rate for gradually changing ambient lighting
SpeakDelay=2            ; minutes between EVA repeating advice to the player
TimerWarning=2          ; if mission timer is less than this many minutes, then display in red
ExtraUnitLight=.2	; Extra light to make units glow.
ExtraInfantryLight=.2	; Extra light to make infantry glow.
ExtraAircraftLight=.2	; Extra light to make aircraft glow.
EMPulseSparkles=EMP_FX01	; Anim to play over units disabled by an EM Pulse.

; ******* Crate rules *******
; General crate rules and controls are specified here.
[CrateRules]
CrateMaximum=255        ; crates can never exceed this quantity
CrateMinimum=1          ; crates are normally one per human player but never below this number
CrateRadius=3.0         ; radius (cells) for area effect crate powerup bonuses
CrateRegen=3            ; average minutes between random powerup crate regeneration
SilverCrate=HealBase    ; solo play silver crate bonus
SoloCrateMoney=2000     ; money to give for money crate in solo play missions
UnitCrateType=none      ; specifies specific unit type for unit type crate ['none' means pick randomly]
WoodCrate=Money         ; solo play wood crate bonus
HealCrateSound=HEALER1    ; heal crate sound effect
WoodCrateImg=CRATE      ; wood crate overlay image to use
CrateImg=CRATE          ; normal crate overlay image to use
FreeMCV=yes             ; Give free MCV from crate if no buildings but still has money [multiplay only]?

; ******* Combat and damage rules *******
; General rules that control combat, damage, or related items are listed here.
[CombatDamage]
AmmoCrateDamage=200     ; damage generated from exploding ammo crate overlay
IonCannonDamage=751
HarvesterImmune=no      ; Are harvester immune to normal combat damage?
DestroyableBridges=yes  ; Can bridges be destroyed?
TiberiumExplosive=yes   ; Is tiberium extra explosive?
Scorches=BURN01,BURN02,BURN03,BURN04  ; scorch mark smudge types
Scorches1=BURN05,BURN06,BURN07 ; scorch mark smudge types
Scorches2=BURN08,BURN09,BURN10 ; scorch mark smudge types
Scorches3=BURN11,BURN12,BURN13 ; scorch mark smudge types
Scorches4=BURN14,BURN15,BURN16 ; scorch mark smudge types
TiberiumExplosionDamage = 100 ; the amount of damage dealt out by explosion in a big tiberium chain reaction
TiberiumStrength = 20 ;	the higher this value, the harder it is to get big tiberium to explode
Craters=CR1,CR2,CR3,CR4,CR5,CR6   ; crater smudge types
AtomDamage=1000         ; damage points when nuclear bomb explodes (regardless of source)
BallisticScatter=1.0    ; maximum scatter distance (cells) for inaccurate ballistic projectiles
BridgeStrength=1500     ; strength of bridge [smaller means more easily destroyed]
C4Delay=.03             ; minutes to delay after placing C4 before building will explode
C4Warhead=HE            ; this is the warhead that C4 uses to damage buildings
FirestormWarhead=FirestormWH ;	the warhead that the firestorm defense uses when active
IonCannonWarhead=IonCannonWH ;	the warhead that the ion cannon uses
VeinholeWarhead=VeinholeWH

;particle system defaults
DefaultFirestormExplosionSystem=FirestormSparkSys ; the particle system to use when the firestorm defense blows something up
DefaultLargeGreySmokeSystem=BigGreySmokeSys
DefaultSmallGreySmokeSystem=SmallGreySSys
DefaultSparkSystem=SparkSys
DefaultLargeRedSmokeSystem=BigGreySmokeSys
DefaultSmallRedSmokeSystem=SmallGreySSys
DefaultDebrisSmokeSystem=SmallGreySSys
DefaultFireStreamSystem=FireStreamSys
DefaultTestParticleSystem=TestSmokeSys
DefaultRepairParticleSystem=WeldingSys

Crush=1.8               ; if this close (cells) to crushable target, then crush instead of firing upon it (computer only)
ExpSpread=.7            ; cell damage spread per 100 damage points for exploding object types [if Explodes=yes]
FireSupress=1           ; radius from target to look for friendlies and thus discourage firing upon, if found
FlameDamage=Fire        ; damage (warhead type) to use when on object is in flames
FlameDamage2=Fire2
HomingScatter=2.0       ; maximum scatter distance (cells) for inaccurate homing projectiles
MaxDamage=1000          ; maximum damage (after adjustments) per shot
MinDamage=1             ; minimum damage (after adjustments) per shot
PlayerAutoCrush=no      ; Will player controlled units automatically try to crush enemy infantry?
PlayerReturnFire=no     ; More aggressive return fire from player controlled objects?
PlayerScatter=no        ; Will player units scatter, of their own accord, from threats and damage?
;ProneDamage=50%         ; when infantry is prone, damage is reduced to this percentage
SplashList=H2O_EXP3,H2O_EXP2,H2O_EXP1 ; water explosion set for conventional explosives
TreeTargeting=no        ; Automatically show target cursor when over trees?
TurboBoost=1.5          ; speed multiplier for turbo-boosted weapons when firing upon aircraft
Incoming=10             ; If an incoming projectile is as slow or slower than this, then
                        ; object in the target location will try to run away.
                        ; Grenades have this characteristic.
CollapseChance=100      ; Percent chance that a cliff will collapse when hit.
BerzerkAllowed=no       ; Allow Cyborgs to go berzerk when at half damage?

; *** House (players) List ***
; Each side has some basic controls on how they behave (when
; controlled by the computer. Here is the list of available
; house types.
[Houses]
0=GDI
1=Nod
2=Neutral
3=Special

; ******* Side Type List *******
; The combantants can be grouped according to side. This
; lists the sides and their respective member houses.
[Sides]
GDI=GDI
Nod=Nod
Civilian=Neutral
Mutant=Special

; ******* Infantry Type List *******
; This is the list of infantry types. Each infantry type listed
; here should also have a matching data section that specifies
; its data values. The purpose of this list is to identify infantry
; types that can't be implicitly determined by examining other
; entries in this rules file.
[InfantryTypes]
1=E1
2=E2
3=E3
4=MEDIC
5=WEEDGUY
6=ENGINEER
7=MUTANT
8=CIV1
9=CIV2
10=CIV3
11=JUMPJET
12=DOGGIE
13=CYC2
14=UMAGON
15=GHOST
16=MHIJACK
17=SLAV
18=CHAMSPY
19=MWMN
20=MUTANT3
21=OXANNA
22=TRATOS
23=CYBORG
24=CTECH

; ******* Building Type List *******
; This lists all the buildings types in the game. Each of these
; types will have a specific section in this file that gives the
; particulars about that building type.
[BuildingTypes]
1=GAPOWR
2=PROC
149=GASILO
4=GAPILE
5=GAPLUG
6=GACTWR
150=GAVULC
7=GASAND
8=GAFIRE
9=GADEPT
10=GATECH
11=GAWEAP
3=GACNST
12=GAHPAD
13=NAPOWR
14=NATECH
15=NAHAND
16=NAAPWR
17=GAWALL
65=CABHUT
153=NAPULS
154=GAGATE_A
155=GAGATE_B
21=NAWEAP
156=NASTLH
66=GALITE
67=REDLAMP
68=GRENLAMP
69=BLUELAMP
70=YELWLAMP
71=PURPLAMP
72=INORANLAMP
73=INGRNLMP
74=INREDLMP
23=NAWALL
75=INBLULMP
24=NATMPL
157=NAGATE_A
158=NAGATE_B
28=NAWAST
159=NAOBEL
160=NAMISL
161=GAPOWRUP
18=NAPOST
76=NAFNCE
35=NALASR
36=NASAM
85=CITY01
86=CITY02
87=CITY03
88=CITY04
89=CITY05
90=CITY06
91=CITY07
92=CITY08
93=CITY09
94=CITY10
95=CITY11
96=CITY12
97=CITY13
98=CITY14
99=CITY15
100=CITY16
101=CITY17
102=CITY18
103=CAHOSP
104=GASPOT
105=CTDAM
19=NARADR
38=GAROCK
106=INGALITE
107=INYELWLAMP
108=INPURPLAMP
39=GAPLUG1
20=GAPLUG2
41=GAPLUG3
42=GAFSDF
43=GARADR
109=BBOARD01
110=BBOARD02
111=BBOARD03
112=BBOARD04
113=BBOARD05
114=BBOARD06
115=BBOARD07
116=BBOARD08
117=BBOARD09
118=BBOARD10
119=BBOARD11
120=BBOARD12
121=BBOARD13
122=BBOARD14
123=BBOARD15
124=BBOARD16
125=NEGLAMP
126=NEGRED
127=ABAN01
128=ABAN02
129=ABAN03
130=ABAN04
131=ABAN05
132=ABAN06
133=ABAN07
134=ABAN08
135=ABAN09
136=ABAN10
137=ABAN11
138=ABAN12
139=ABAN13
140=ABAN14
141=ABAN15
142=ABAN16
143=ABAN17
144=ABAN18
145=CITY19
146=CITY20
147=CITY21
148=NTPYRA
151=CITY22
152=CTVEGA
200=GADPSA
201=CA0001
202=CA0002
203=CA0003
204=CA0004
205=CA0005
206=CA0006
207=CA0007
208=CA0008
209=CA0009
210=CA0010
211=CA0011
212=CA0012
213=CA0013
214=CA0014
215=CA0015
216=CA0016
217=CA0017
218=CA0018
219=CA0019
220=CA0020
221=CA0021
222=CAARMR
223=GACSAM
224=GATICK
225=CAPYR01
226=CAPYR02
227=CAPYR03
228=CACRSH01
229=CACRSH02
230=CACRSH03
231=CACRSH04
232=CACRSH05
233=CAARAY
234=GAICBM
235=GAOLDCC1
236=GAOLDCC2
237=GAOLDCC3
238=GAOLDCC4
239=GAOLDCC5
240=GAOLDCC6
241=GAARTY
242=TSTLAMP
243=NAHPAD
244=GAKODK
245=NAMNTK
246=UFO
247=AMMOCRAT
248=GAPAVE
249=GAGREEN

; ******* Aircraft Type List *******
; This lists all of the aircraft types in the game. Each aircraft
; type should have a matching section that specifies the data it
; requires.
[AircraftTypes]
1=ORCAB
2=DSHP
3=DPOD
4=SCRIN
5=APACHE
6=ORCATRAN
7=TRNSPORT
8=ORCA

; ******* Vehicle Type List *******
; This lists all of the vehicles types in the game. Each vehicle
; type should have a matching section that specifies the data it
; requires.
[VehicleTypes]
1=MCV
2=HARV
3=APC
11=4TNK
15=MMCH
16=BIKE
17=SAPC
18=SONIC
19=CAR
21=BUS
22=STNK
23=WINI
24=PICK
27=ART2
29=TTNK
30=HMEC
31=SMECH
32=HVR
34=LPST
35=REPAIR
36=HORV
37=LOCOMOTIVE
38=TRAINCAR
39=SUBTANK
40=BGGY
41=JEEP
42=TRUCKA
43=TRUCKB
44=VISC_SML
45=VISC_LRG
46=ICBM
47=CARGOCAR
48=WEED
49=GHUNTER
50=NHUNTER

; *** Terrain Object List ***
; This is the list of terrain objects. Typically, these include
; trees and rocks.
[TerrainTypes]
;1=MINE
2=BOXES01
3=BOXES02
4=BOXES03
5=BOXES04
6=BOXES05
7=BOXES06
8=BOXES07
9=BOXES08
10=BOXES09
11=ICE01
12=ICE02
13=ICE03
14=ICE04
15=ICE05
16=TREE01
17=TREE02
18=TREE03
19=TREE04
20=TREE05
21=TREE06
22=TREE07
23=TREE08
24=TREE09
25=TREE10
26=TREE11
27=TREE12
28=TREE13
29=TREE14
30=TREE15
31=TREE16
32=TREE17
33=TREE18
34=TREE19
35=TREE20
36=TREE21
37=TREE22
38=TREE23
39=TREE24
40=TREE25
41=TIBTRE01
42=TIBTRE02
43=TIBTRE03
44=VEINTREE

; *** Smudge Object List ***
; This is the list of smudge objects. Typically, these include
; craters and scorch marks.
[SmudgeTypes]
1=CR1
2=CR2
3=CR3
4=CR4
5=CR5
6=CR6
7=BURN01
8=BURN02
9=BURN03
10=BURN04
11=BURN05
12=BURN06
13=BURN07
14=BURN08
15=BURN09
16=BURN10
17=BURN11
18=BURN12
19=BURN13
20=BURN14
21=BURN15
22=BURN16
23=BURNT01
24=BURNT02
25=BURNT03
26=BURNT04
27=BURNT05
28=BURNT06
29=BURNT07
30=BURNT08
31=BURNT09
32=BURNT10
33=BURNT11
34=BURNT12
35=CRATER01
36=CRATER02
37=CRATER03
38=CRATER04
39=CRATER05
40=CRATER06
41=CRATER07
42=CRATER08
43=CRATER09
44=CRATER10
45=CRATER11
46=CRATER12

; *** Overlay Object List ***
; These specify the various overlay types. Overlays can affect the
; game state (unlike smudges).
[OverlayTypes]
1=GASAND
2=CYCL
3=GAWALL
4=BARB
5=WOOD
6=DUMMY
7=DUMMY2
8=DUMMY3
9=DUMMY4
10=DUMMY5
11=DUMMY6
12=DUMMY7
13=DUMMY8
14=DUMMY9
15=DUMMY10
16=DUMMY11
17=DUMMY12
18=V16
19=V17
20=V18
21=DUMMY13
22=DUMMY14
23=FENC
24=DUMMY15
25=BRIDGE1      ;26 &
26=BRIDGE2      ;27 are the same art.
27=NAWALL
28=BTIB01
29=BTIB02
30=BTIB03
31=BTIB04
32=BTIB05
33=BTIB06
34=BTIB07
35=BTIB08
36=BTIB09
37=BTIB10
38=BTIB11
39=BTIB12
42=TRACKS01
43=TRACKS02
44=TRACKS03
45=TRACKS04
46=TRACKS05
47=TRACKS06
48=TRACKS07
49=TRACKS08
50=TRACKS09
51=TRACKS10
52=TRACKS11
53=TRACKS12
54=TRACKS13
55=TRACKS14
56=TRACKS15
57=TRACKS16
58=TRACKTUNNEL01
59=TRACKTUNNEL02
60=TRACKTUNNEL03
61=TRACKTUNNEL04
62=RAILBRDG1
63=RAILBRDG2
64=CRAT01
65=CRAT02
66=CRAT03
67=CRAT04
68=CRAT0A
69=CRAT0B
70=CRAT0C
71=DRUM01
72=DRUM02
73=PALET01
74=PALET02
75=PALET03
76=PALET04
77=LOBRDG01
78=LOBRDG02
79=LOBRDG03
80=LOBRDG04
81=LOBRDG05
82=LOBRDG06
83=LOBRDG07
84=LOBRDG08
85=LOBRDG09
86=LOBRDG10
87=LOBRDG11
88=LOBRDG12
89=LOBRDG13
90=LOBRDG14
91=LOBRDG15
92=LOBRDG16
93=LOBRDG17
94=LOBRDG18
95=LOBRDG19
96=LOBRDG20
97=LOBRDG21
98=LOBRDG22
99=LOBRDG23
100=LOBRDG24
101=LOBRDG25
102=LOBRDG26
103=LOBRDG27
104=LOBRDG28
105=TIB01
106=TIB02
107=TIB03
108=TIB04
109=TIB05
110=TIB06
111=TIB07
112=TIB08
113=TIB09
114=TIB10
115=TIB11
116=TIB12
117=TIB13
118=TIB14
119=TIB15
120=TIB16
121=TIB17
122=TIB18
123=TIB19
124=TIB20
125=LOBRDGE1
126=LOBRDGE2
127=LOBRDGE3
128=LOBRDGE4
129=VEINS
130=TIB2_01
131=TIB2_02
132=TIB2_03
133=TIB2_04
134=TIB2_05
135=TIB2_06
136=TIB2_07
137=TIB2_08
138=TIB2_09
139=TIB2_10
140=TIB2_11
141=TIB2_12
142=TIB2_13
143=TIB2_14
144=TIB2_15
145=TIB2_16
146=TIB2_17
147=TIB2_18
148=TIB2_19
149=TIB2_20
150=TIB3_01
151=TIB3_02
152=TIB3_03
153=TIB3_04
154=TIB3_05
155=TIB3_06
156=TIB3_07
157=TIB3_08
158=TIB3_09
159=TIB3_10
160=TIB3_11
161=TIB3_12
162=TIB3_13
163=TIB3_14
164=TIB3_15
165=TIB3_16
166=TIB3_17
167=TIB3_18
168=TIB3_19
169=TIB3_20
170=VEINHOLE
171=SROCK01
172=SROCK02
173=SROCK03
174=SROCK04
175=SROCK05
176=TROCK01
177=TROCK02
178=TROCK03
179=TROCK04
180=TROCK05
181=VEINHOLEDUMMY
182=CRATE

; *** Animation List ***
; This is the complete list of animations available. There are
; internal tables that rely on this exact order. Additional
; animations should be appended to the end.
[Animations]
1=TWLT100
3=ELECTRO

; The following can occur in any order.
240=TWLT026
241=TWLT036
242=TWLT050
243=TWLT070
244=TWLT100
245=TWLT070T
246=TWLT100I

250=S_BANG16
251=S_BANG24
252=S_BANG34
253=S_BANG48

260=S_BRNL20
261=S_BRNL30
262=S_BRNL40
263=S_BRNL58

270=S_CLSN16
271=S_CLSN22
272=S_CLSN30
273=S_CLSN42
274=S_CLSN58

280=S_TUMU22
281=S_TUMU30
282=S_TUMU42
283=S_TUMU60

290=RING1
291=IONBEAM

12=SMOKEY
13=BURN-S
14=BURN-M
15=BURN-L
22=H2O_EXP1
23=H2O_EXP2
24=H2O_EXP3
25=PARACH
26=PARABOMB
28=RING
30=PIFF
31=PIFFPIFF
32=FIRE3
33=FIRE2
34=FIRE1
35=FIRE4
42=GUNFIRE
43=TWINKLE1
44=TWINKLE2
45=TWINKLE3
47=MONEY
48=MLTIMISL
49=HEALONE
50=HEALALL
51=ARMOR
52=CHEMISLE
53=CLOAK
54=FIREPOWR
63=MGUN-N
64=MGUN-NE
65=MGUN-E
66=MGUN-SE
67=MGUN-S
68=MGUN-SW
69=MGUN-W
70=MGUN-NW
71=SMOKLAND
72=VETERAN
73=REVEAL
74=SHROUDX
82=GAPOWR_A
83=GAPOWR_AD
84=NARADR_A
85=NARADR_AD
90=GAWEAP_1
91=GAWEAP_2
92=GAWEAP_A
93=GAWEAP_B
94=GAWEAP_C
95=GAWEAP_D
96=GAPILE_A
97=GAPILE_B
98=NAPULS_A
99=GACTWR_A
100=GACTWR_B
101=GACTWR_C
102=GACTWR_D
103=GAPILE_C
104=GAWEAP_1
105=GAWEAP_2
106=GAWEAP_A
107=GAWEAP_B
;108=GACOMM_A
;109=GACOMM_B
;110=GACOMM_C
;111=GACOMM_D
;112=GACOMM_AD
113=NASTLH_A
114=NASTLH_AD
115=GACNSTMK
116=GACNST_A
117=GACNST_AD
118=GACNST_B
119=GACNST_C
120=GACNST_CD
121=GACNST_D
122=NAHAND_A
123=NAHAND_B
124=NAHAND_BD
125=GAPILE_CD
126=NATMPL_A
127=NATMPLMK
128=NAREFN_A
129=NAREFN_B
130=NAREFN_C
131=GAHPAD_A
132=GAHPAD_AD
133=GAPOWR_B
134=GADEPT_A
135=GADEPT_AD
136=GADEPT_B
137=GATECH_A
138=GATECH_AD
139=NATECH_A
143=NAWAST_A
144=NAWAST_AD
145=NAWAST_B
146=NAWAST_BD
147=NAOBEL_A
148=NAMISL_A
149=NAMISL_AD
150=NAMISL_B
151=NAMISL_BD
152=GAFIRE_A
153=GAFIRE_B
154=GAFIRE_C
155=NAREFN_AR
156=NAPOST_A
157=NAPOST_AD
158=NAPOST_B
159=WA01X
160=WA02X
161=WA03X
162=WA04X
163=WB01X
164=WB02X
165=WB03X
166=WB04X
167=WC01X
168=WC02X
169=WC03X
170=WC04X
171=WD01X
172=WD02X
173=WD03X
174=WD04X
175=TREESPRD
176=NAOBEL_B
177=GADEPT_C1
178=GADEPT_C2
179=GADEPT_C3
180=GADEPT_D
181=GADEPT_DD
182=GASILO_A
183=GASILO_AD
184=GASILO_B
185=GASILO_BD
186=NAPOWR_A
187=NAPOWR_AD
188=CAHOSP_A
189=NAAPWR_A
190=NAAPWR_AD
191=GASPOT_A
192=GASPOT_AD
193=CTDAM_A
194=CTDAM_AD
195=TUNTOP01
196=TUNTOP02
197=TUNTOP03
198=TUNTOP04
199=NTPYRA_A
200=NTPYRA_AD
201=PULSEFX1
202=GADPSAMK
203=METLARGE
204=METSMALL
205=METDEBRI
206=METSTRAL
207=METLTRAL
208=PULSBALL
209=GAFSDF_A
210=FSIDLE
211=FSAIR
212=FSGRND
213=CAARMR_A
214=GADPSA_A
215=GATICK_A
216=GATICKMK
;217=UFO
218=CAARAY_A
219=CAARAY_B
220=CAARAY_C
221=CAARAY_CD
222=CAARAY_D
223=CAARAY_DD
224=GAICBM_A
225=GAICBMMK
226=NAHPAD_A
227=NAHPAD_AD
228=GAKODK_A
229=GAKODK_AD
230=GAKODK_B
231=GAKODK_C
232=GAKODK_CD
233=NAMNTK_A
234=CTDAM_B
235=CTDAM_BD
236=CARYLAND
237=DROPLAND

300=GAPLUG_A
301=GAPLUG_B
302=GAPLUG_BD
303=GAPLUG_C
304=GAPLUG_D
305=GAPLUG_E
306=GAPLUG_F
307=GARADR_A
308=GARADR_AD
309=NASAM_A
310=EMP_FX01


320=DIG

400=VEINATAC

500=INFDIE
501=DIRTEXPL
502=PULSEFX2
510=DBRIS1LG
511=DBRIS1SM
512=DBRIS2LG
513=DBRIS2SM
514=DBRIS3LG
515=DBRIS3SM
516=DBRIS4LG
517=DBRIS4SM
518=DBRIS5LG
519=DBRIS5SM
520=DBRIS6LG
521=DBRIS6SM
522=DBRIS7LG
523=DBRIS7SM
524=DBRIS8LG
525=DBRIS8SM
526=DBRIS9LG
527=DBRIS9SM
528=DBRS10LG
529=DBRS10SM
550=DEATH_A
551=DEATH_B
552=DEATH_C
553=DEATH_D
554=DEATH_E
555=DEATH_F
556=DROPPOD
557=DROPPOD2
558=FLAMEGUY

600=EXPLOSML
601=EXPLOMED
602=EXPLOLRG
603=XGRYMED1
604=XGRYMED2
605=XGRYSML1
606=XGRYSML2

610=STEAMPUF
611=SMOKEY2
612=PULSE
613=WAKE1
614=WAKE2
618=BEACON
619=PODRING

620=CLDRNGL1
621=CLDRNGL2
622=CLDRNGMD
623=CLDRNGSM

700=CRYSTAL1
701=CRYSTAL2
702=CRYSTAL3
703=CRYSTAL4
704=BIGBLUE

705=SGRYSMK1
706=DROPEXP
707=INVISO

; *** Voxel Animation List ***
; This is the complete list of voxel animations available.
; VoxelAnims are meant to be flying debris.  Things like
; turrets and tires make good voxel anims.
[VoxelAnims]
1=PIECE
2=TIRE
3=GASTANK
4=SONICTURRET
5=4TNKTURRET
6=CRYSTAL01
7=CRYSTAL02
8=METEOR01
9=METEOR02
10=PEBBLE

; *** Particle List ***
;  This is a list of the various particle types in the game
;  These are usually objects of gassy nature: poison gas, smoke, fire, etc...
[Particles]
; These first three must be in this order!
1=GasCloud1
2=GasCloud2
3=FireStream
4=Spark
5=FirestormSpark
6=LargeGreySmoke
7=SmallGreySmoke
8=TestSmoke
9=GasCloudD1
10=GasCloudD2
11=SmallRailgunPart
12=LargeRailgunPart
13=GasCloudM1
14=GasCloudM2
15=WeldingSpark
16=LargeSpark

; *** Particle System List **
; This is a list of the various types of particles systems available in the game
[ParticleSystems]
1=GasCloudSys
2=FireStreamSys
3=BigGreySmokeSys
4=SmallGreySSys
5=DebrisSmokeSys
6=SparkSys
7=FirestormSparkSys
8=TestSmokeSys
9=SmallRailgunSys
10=LargeRailgunSys
11=WeldingSys
12=LGSparkSys

; *** Super Weapon List **
; This is a list of the various types of super weapons available in the game
[SuperWeaponTypes]
1=MultiSpecial
2=EMPulseSpecial
3=FirestormSpecial
4=IonCannonSpecial
5=HuntSeekSpecial
6=ChemicalSpecial

; *** Warhead List **
; This is a list of the various types of warheads available in the game
[Warheads]
1=EMPuls
2=SonicWarhead
3=TankOGas
4=SA
5=HE
6=AP
7=Gas
8=Fire
9=HollowPoint
10=Super
11=Organic
12=Slimer
13=FirestormWH
14=IonCannonWH
15=RailShot
16=Mechanical
17=VeinholeWH
18=IonWH
19=ARTYHE
20=PlasmaWH
21=SAMWH
22=ORCAAP
23=RailShot2
24=ORCAHE

; ******* Multiplayer Settings *******
; These are the multiplayer dialog default settings. Does not apply to
; Westwood chat, only to the in-game dialogs.
[MultiplayerDefaults]
Money=10000
MaxMoney=10000
ShadowGrow=no
Bases=yes
TiberiumGrows=yes
Crates=yes
CaptureTheFlag=no

; ******* Special weapon charge times *******
; The time (minutes) for recharge of these special weapons.
;[Recharge]
;Nuke=13                 ; nuclear missile
;EMPulse=5                 ; nuclear missile
;IonCannon=11
;FirestormDefense=4

; ******* Object Heap Maximums *******
; These are the absolute maximum number of these object types
; allowed in the game (at any one time).
[Maximums]
Players=8                               ; ipx layer limits this to 8 maximum


; ******* AI Controls *******
; Computer Skirmish-Mode behavior controls. The ratio values are based on the
; number of buildings in the computer base that should be of the type specified.
; The ratio total should exceed 100% so that the base will always try to grow as
; it vainly attempts to achieve the specified percentage composition.

; These AI controls are held over from Red Alert. They will be replaced or augmented
; by Tiberian Sun improved AI subsystems. Changing these values will be only
; temporary until the new system comes on line.
[AI]
BuildConst=GACNST
BuildPower=NAPOWR,GAPOWR,NAAPWR  ; buildings to build to generate power
BuildRefinery=PROC      ; refinery ratio based on these buildings
BuildBarracks=NAHAND,GAPILE ; barracks ratio based on these buildings
BuildTech=NATECH,GATECH  ; should build on each of these
BuildWeapons=GAWEAP,NAWEAP       ; war factory ration based on these buildings
BuildDefense=NAOBEL      ; base defenses are based on these buildings
BuildPDefense=NAOBEL      ; excess power base defense
BuildAA=NASAM            ; air defenses based on these buildings
BuildHelipad=GAHPAD,NAHPAD     ; air helicopter offense based on these buildings
BuildRadar=GARADR,NARADR
ConcreteWalls=GAWALL,NAWALL
NSGates=NAGATE_B,GAGATE_B
EWGates=NAGATE_A,GAGATE_A
GDIWallDefense=6
GDIWallDefenseCoefficient=3
NodBaseDefenseCoefficient=1.2
GDIBaseDefenseCoefficient=1.5
MaximumBaseDefenseValue=60
ComputerBaseDefenseResponse=3	; how much does the computer overrespond to attacks on its base?

AttackInterval=3        ; average delay between computer attacks
AttackDelay=5           ; average delay time before computer begins first attack
PatrolScan=.016         ; minute interval between scanning for enemys while patrolling.
CreditReserve=100       ; Structure repair will not begin if available cash falls below this amount.
PathDelay=.01           ; Delay (minutes) between retrying when path is blocked.
BlockagePathDelay=60	; delay (frames) before unit paths around all blockage
TiberiumNearScan=6      ; cell radius to scan when harvesting a single patch of Tiberium
TiberiumFarScan=48      ; cells radius to scan when looking for a new Tiberium patch to harvest
AutocreateTime=5        ; average minutes between creating an 'autocreate' team
InfantryReserve=3000    ; always build infantry if cash reserve is greater than this
InfantryBaseMult=1      ; build infantry if building count times this number is less than current infantry quantity
PowerSurplus=50         ; build power plants until power surplus is at least this amount
BaseSizeAdd=3           ; computer base size can be no larger than the largest human opponent, plus this quantity
RefineryRatio=.16       ; ratio of base that should be composed of refineries
RefineryLimit=4         ; never build more than this many refineries
BarracksRatio=.16       ; ratio of base that should be composed of barracks
BarracksLimit=2         ; never build more than this many barracks
WarRatio=.1             ; ratio of base that should be composed of war factories
WarLimit=2              ; never build more than this many war factories
DefenseRatio=.4         ; ratio of base that should be defensive structures
DefenseLimit=40         ; maximum number of defensive buildings to build
AARatio=.14             ; ratio of base that should be anti-aircraft defense
AALimit=10              ; maximum number of anti-aircraft buildings to build
TeslaRatio=.16          ; ratio of base that should be telsa coils
TeslaLimit=10           ; maximum number of tesla coils to build
HelipadRatio=.12        ; ratio of base that should be composed of helipads
HelipadLimit=5          ; maximum number of helipads to build
AirstripRatio=.12       ; ratio of base that should be composed of airstrips
AirstripLimit=5         ; maximum number of airstrips to build
CompEasyBonus=no        ; When more than one human in game, computer player goes to "easy" mode?
Paranoid=yes            ; Will computer players ally with each other if the situation looks bleak?
PowerEmergency=75%      ; sell buildings to raise power level if it falls below this percentage
AIBaseSpacing=1			; spacing between buildings when AI is building a base


; ******* Lists the AI general COM objects *******
; These are COM objects that support the IAIHouse interface.
[AIGenerals]
;1={F706E6E0-86DA-11D1-B706-00A024DDAFD1}
;2={9E0F6120-87C1-11D1-B707-00A024DDAFD1}
;3={C6004D80-87D1-11d1-B707-00A024DDAFD1}
;4={FBE6D4A0-87D1-11d1-B707-00A024DDAFD1}
;5={FBE6D4A1-87D1-11d1-B707-00A024DDAFD1}


; ******* IQ setting for computer activity *******
; Each player (computer controlled or otherwise) is given an IQ rating that is used
; to control what the computer is allowed to automatically control. This is
; distinct from the difficulty setting. The higher the IQ setting, the more autonomous
; and intelligent the side will behave. Each ability is given a rating that
; indicates the IQ level (or above) that the ability will be granted. Because such
; abilities are automatically performed by the computer, giving a human controlled
; country a high IQ is not recommended. Otherwise the player's units will start to
; automatically "do their own thing"! A human controlled country is presumed to have
; an IQ rating of zero. A computer controlled country has an IQ of 1 or higher.
; When in skirmish mode or when multiplayer AIs are active, the computer IQ is set to
; the maximum.
[IQ]
MaxIQLevels=5           ; the maximum number of discrete IQ levels
SuperWeapons=4          ; super weapons are automatically fired by computer
Production=5            ; building/unit production is automatically controlled by computer
GuardArea=2             ; newly produced units start in guard area mode
RepairSell=1            ; allowed to choose repair or sell of damaged buildings
AutoCrush=2             ; automatically try to crush antogonists if possible
Scatter=2               ; will scatter from incoming threats [grenades and such]
ContentScan=3           ; will consider contents of transport when picking good target
Aircraft=3              ; automatically replace aircraft
Harvester=2             ; automatically replace lost harvesters
SellBack=2              ; allowed to sell buildings


; ******* Country Statistics *******
; Certain countries have special adjustments to their unit and building
; values. These are global values that affect ALL units and buildings owned
; by that country. This applies only to multiplayer games and skirmish mode. In
; normal game play, all values are "1.0".

; Airspeed = multiplier to speed for all air units [larger means faster] (def=1.0)
; Armor = multiplier to armor strength for all units and buildings [larger means stronger] (def=1.0)
; Cost = multiplier to cost for all units and buildings [larger means costlier] (def=1.0)
; Firepower = multiplier to firepower for all weapons [larger means more damage] (def=1.0)
; Groundspeed = multiplier to speed for all ground units [larger means faster] (def=1.0)
; ROF = multiplier to Rate Of Fire for all weapons [larger means slower ROF] (def=1.0)
; BuildTime = multiplier to general object build time [larger means longer to build] (def=1.0)
; Color = color to use when displaying objects owned by this country [see color schemes]
; Multiplay = This house used as placeholder for multiplay house (def=no)?
; WallOwner = Will this house own walls that are placed near its buildings (def=yes)?
; SmartAI = Does it presume to have the smart AI logic already enabled (def=no)?

[GDI]
Name=GDI
Suffix=GDI
Prefix=G
Color=Gold
Multiplay=yes
Side=GDI

[Nod]
Name=NOD
Suffix=NOD
Prefix=B
Color=DarkRed
Multiplay=yes
Side=GDI
SmartAI=yes

[Special]
Name=JP
Suffix=JP
Prefix=J
Color=Grey
Side=Mutant
SmartAI=yes
MultiplayPassive=true

[Neutral]
Name=Civilian
Suffix=CIV
Prefix=C
Color=Grey
MultiplayPassive=true
SmartAI=yes
Side=Civilian


; ******* Color Schemes *******
; Each country must be assigned a color. This lists the various
; colors available. The values represent the 'hue', 'saturation',
; and 'value'. The 'value' component specifies the maximum brightness
; allowed for the color as the color spread is generated. The 'hue'
; component remains constant. The 'saturation' curves through color
; space as the 'value' component changes such that darker colors
; become more saturated.
[Colors]
; Col. Mustard
LightGold=34,128,255		; 0
Gold=34,160,255			; 1
DarkGold=34,235,255		; 2

; Mrs White
LightGrey=0,0,220		; 3
Grey=0,0,190			; 4
DarkGrey=0,0,120		; 5
Black=0,100,0			; 6
;as white as we can get
White=0,0,255			; 7

; Miss Scarlet
LightRed=0,70,255		; 8
Red=0,160,255			; 9
DarkRed=0,235,255		; 10
Burgandy=0,255,150		; 11

;Orange Julius
LightOrange=24,165,255		; 12
Orange=24,255,255		; 13
DarkOrange=11,235,255		; 14

; Mrs Peacock
LightMagenta=228,120,255	; 15
Magenta=228,160,255		; 16
DarkMagenta=228,235,255		; 17

; Prof. Plum
LightPurple=200,160,255		; 18
Purple=200,235,255		; 19
HyundaiPurple=200,235,170	; 20

;Little Boy Blue
LightBlue=164,140,255		; 21
Blue=164,200,255		; 22
DarkBlue=164,200,179		; 23
NeonBlue=164,255,255		; 24

;Sky
LightSky=142,70,255		; 25
Sky=142,160,255			; 26
DarkSky=142,235,255		; 27

;Cyan
LightCyan=132,70,255		; 28
Cyan=132,160,255		; 29
DarkCyan=132,235,255		; 30

;Teal
LightTeal=110,70,255		; 31
Teal=110,160,255		; 32
DarkTeal=110,235,255		; 33

; Mr. Green
LightGreen=85,70,255		; 34
Green=85,160,200		; 35
DarkGreen=85,235,150		; 36
NeonGreen=85,255,255		; 37

;Mellow Yellow
LightYellow=43,70,255		; 38
Yellow=43,160,255		; 39
DarkYellow=43,235,255		; 40
NeonYellow=43,255,255		; 41

;Life is Peachy
LightPeach=21,120,255		; 42
Peach=21,150,255		; 43
DarkPeach=21,180,255		; 44
DarkerPeach=21,255,255		; 45

;Lemon lime
LightLime=53,70,255		; 46
Lime=53,160,255			; 47
Darklime=53,235,200		; 48
NeonLime=53,235,255		; 49


; ******* Difficulty Settings *******
; Game difficulty is controlled by these factors. Some of these factors will
; only affect a computer player. The computer and the player are handicapped by
; individual settings. Thus the computer may be playing at 'difficult' level while the
; player may be playing at 'easy' level.

; Airspeed = multiplier to speed for all air units (def=1.0)
; Armor = multiplier to armor strength for all units and buildings (def=1.0)
; Cost = multiplier to cost for all units and buildings (def=1.0)
; Firepower = multiplier to firepower for all weapons (def=1.0)
; Groundspeed = multiplier to speed for all ground units (def=1.0)
; ROF = multiplier to Rate Of Fire for all weapons [larger means slower ROF] (def=1.0)
; BuildSlowdown = Should the computer build slower than the player (def=no)?
;  <<< affects the computer player, not the human player >>>
;    ContentScan = Should the contents of a transport be considered when picking best target (def=no)?
;    RepairDelay = average delay (minutes) between initiating building repair
;    BuildDelay = average delay (minutes) between initiating construction
;    DestroyWalls = Allow scanning for nearby enemy walls and destroy them (def=yes)?

[Easy]
Groundspeed=1.0
Airspeed=1.0
BuildTime=.8
Armor=1.2
ROF=.8
Cost=1.0
RepairDelay=.02
BuildDelay=.03
DestroyWalls=yes
ContentScan=yes

[Normal]
Groundspeed=1.0
Airspeed=1.0
BuildTime=1
Armor=1.0
ROF=1.0
Cost=1.0
RepairDelay=.02
BuildDelay=.03
BuildSlowdown=yes
DestroyWalls=yes
ContentScan=yes

[Difficult]
Groundspeed=1.0
Airspeed=1.0
BuildTime=1.0
Armor=.8
ROF=1.2
Cost=1.0
RepairDelay=.05
BuildDelay=.1
BuildSlowdown=yes
DestroyWalls=no


; ******* Unit Statistics *******
; Specifies the characteristics of the various game objects.

; AllowedToStartInMultiplayer = Can the unit be allocated to a player when starting a multiplayer game (def=yes)
; Ammo = number of rounds carried between reloads [-1 means unlimited] (def=-1)
; Armor = the armor type of this object [none,wood,light,heavy,concrete] (def=none)
; BuildLimit = arbitrary maximum allowed to build [per house] (def=-1 -- no restriction)
; Cloakable = Is it equipped with a cloaking device (def=no)?
; Cost = cost to build object (in credits)
; Category = category of object [used by AI systems -- "Soldier", "Civilian", "VIP", "Ship",
;            "Recon", "AFV", "IFV", "LRFS", "Support", "Transport", "AirPower", "AirLift"]
; CloakStop = Does the unit cloak when stopped moving (def=no)?
; Crewed = Does it contain a crew that can escape [never infantry] (def=no)?
; CrushSound = sound to play if this object type is crushed (def=none)
; DeployTime = time, in minutes, to deploy or undeploy [if this object can do so]
; Disableable = Can this object be disabled by special multiplay option (def=yes)?
; DoubleOwned = Can be built/owned by all countries in a multiplayer game (def=no)?
; Explodes = Does it explode violently when destroyed [i.e., does it do collateral damage] (def=no)?
; Explosion = the explosion to use when it blows up [doesn't apply to infantry] (def=none)
; FireAngle = pitch of projectile launch [64 = horizontal, 0 = vertical] (def=50)
; Gate = Is this building a gate? (def=no)
; GateCloseDelay = time, in minutes, to delay before closing a gate after it has opened.
; GuardRange = distance to scan for enemies to attack (def=use weapon range)
; Image = name of graphic data to use for this object (def=same as object identifier)
; Immune = Is this object immune to damage
; ImmuneToVeins = Is it immune to vein creature attacks (def=no)?
; Invisible = Is completely and always invisible to enemy (def=no)?
; Insignificant = Will this object not be announed when destroyed (def=no)?
; LegalTarget = Is this allowed to be a combat target (def=yes)?
; Name = specifies the given name (displayed) for the object
; Nominal = Always use the given name rather than generic "enemy object" (def=no)?
; Owner = who can build this [GDI or Nod] (def=none)
; PipScale = what to base pip display on [Passengers, Tiberium, Ammo, Power] (def=none)
; Points = point value for scoring purposes (def=0)
; Prerequisite = list of buildings needed before this can be manufactured (def=no requirement)
; Primary = primary weapon equipped with (def=none)
; Secondary = secondary weapon equipped with (def=none)
; Elite = new primary weapon when at elite veteran status (def=same as primary)
; RadarVisible = Is visible on radar even when under shroud (def=yes [infantry=no])?
; ROT = Rate Of Turn for body (if present) and turret (if present) (def=0)
; Reload = time delay between reloads (def=0)
; RadarInvisible = Is it invisible on radar maps (def=no)?
; SelfHealing = Does the object heal automatically up to half strength (def=no)?
; Selectable = Can this object be selected by the player (def=yes)?
; Sensors = Has sensors to detect nearby cloaked objects (def=no)?
; Sight = sight range, in cells (def=1)
; Storage = the number of 'bails' this building or unit can store (def=0)
; Strength = strength (hit points) of this object
; TargetLaser = Does it have a targeting laser (def=no)?
; Trainable = Can this object become veteran by experience (def=yes, buildings def=no)?
; Turret = Is it equipped with a turret like superstructure [never infantry] (def=no)?
; TurretSpins = Does the turret just sit and spin [only if turret equipped] (def=no)?
; TechLevel = tech level required to build this [-1 means can't build] (def=-1)
; ToProtect = Should friendly units come to rescue if under attack [computer only] (def=no)?
; TypeImmune = Immune to damage from same type objects if owned by same side?
; VoiceSelect = list of voices when selecting this object (def=none)
; VoiceMove = list of voices to use when giving object a movement order (def=none)
; VoiceAttack = list of voices to use when giving object an attack order (def=none)
; VoiceDie = list of voices to use when it dies (def=none)
; VoiceFeedback = list of voices that may give when taking damage (def=none)
; Locomotor = CLSID of the object handling movement for this object (def=statue)
; VeteranAbilities = list of veteran abilities to grant (def=none)
; EliteAbilities = list of elite abilities to grant cumulative with veteran abilities (def=none)
;     [FASTER,STRONGER,FIREPOWER,SCATTER,ROF,SIGHT,
;      CLOAK,TIBERIUM_PROOF,VEIN_PROOF,SELF_HEAL,EXPLODES,
;      RADAR_INVISIBLE,SENSORS,FEARLESS,C4,TIBERIUM_HEAL,
;      GUARD_AREA,CRUSHER]
;  <<< applies only to infantry types >>>
;    Agent = Does it have spy-like abilities (def=no)?
;    Fearless = Is not prone to fear (def=no)?
;    VoiceComment = list of idle voices (def=none)
;    Pip = color of pip when inside a transport [green,yellow,white,red,blue] (def=green)
;    C4 = Equipped with building sabotage explosives [presumes Infiltrate is true] (def=no)?
;    Cyborg = Does it require special cyborg death handling (def=no)?
;    Fraidycat = Is it inherently afraid and will panic easily (def=no)?
;    TiberiumProof = Is it immune to tiberium and tiberium gas damage (def=no)?
;    Infiltrate = Can it enter a building like a spy or thief (def=no)?
;    IsCanine = Should special case dog logic be applied to this?
;    Civilian = Counts a civilian for evac and kill tracking (def=no)?
;    FemaleVoice = Uses the civilian female voice (def=no)?
;    Engineer = Does it behave like an engineer as far as repair and capture go (def=no)?
;    Disguised = Is it disguised as enemy soldier when seen by enemy (def=no)?
;    Agent = Does this infantry gather information if it enters an enemy building [like a spy] (def=no)?
;    Thief = Does it steal money if it infiltrates an enemy building (def=no)?
;    VehicleThief = Does it steal enemy vehicles when it gets close to one (def=no)?
;  <<< applies only to moving units (not buildings) >>>
;    MoveToShroud = Allowed to move into a shrouded cell (def=yes, aircraft def=no)?
;    Dock = preferred docking building [e.g., harvester -> refinery, helicopter -> helipad] (def=none)
;    TiberiumHeal = Does it heal slowly when in Tiberium field (def=no)?
;    Passengers = number of passengers it may carry (def=0)
;    Speed = speed of this object [n/a for buildings] (def=0)
;    ManualReload = Must this object reload by coordinating with reloader building (def=no)?
;    WalkRate = walking animation rate [larger means slower] (def=1)
;  <<< applies only to terrestrial driving vehicle types >>>
;    CrateGoodie = Can it appear out of a crate in multiplay (def=no)?
;    Crushable = Can it be crushed by a heavy tracked vehicle (def=no)?
;    Crusher = Is this vehicle able to crush infantry (def=no)?
;    NoMovingFire = The vehicle must stop before it can fire (def=no)?
;    DeployToFire = The vehicle must deploy before it can fire (def=no)?
;    Harvester = Does the special Tiberium harvesting rules apply (def=no)?
;    Weeder = Does the special weed-harvesting rules apply (def=no)?
;    Deployer = Does it deploy before being able to operate (def=no)? OBSOLETE
;    IsTilter = Does this unit tilt on slopes (def=yes)?
;    CarriesCrate = Might this unit drop a crate when it is destroyed (def=no)?
;  <<< applies only to aircraft >>>
;    Carryall = Can it tote vehicles around (def=no)?
;    Landable = Can this aircraft land on the map (def=no)?
;    PitchSpeed = Throttle setting at which aircraft pitch forward (def=.25);
;    PitchAngle = Amount that non-FixedWing aircraft pitch forward in degrees (def=20.0);
;    RollAngle = Amount that the aircraft rolls when turning (def=30.0)
;  <<< applies only to building types >>>
;    Adjacent = distance allowed to place from other buildings (def=1)
;    BaseNormal = Considered for building adjacency checks (def=yes)?
;    Barrel = Use barrel explosion logic when it is destroyed (def=no)?
;    Bib = Does the building have a bib built in (def=no)?
;    Capturable = Can this building be infiltrated by a spy/engineer (def=no)?
;    DockUnload = When a unit docks with this building should it unload (def=no)?
;    Factory = type of object to build [InfantryType, AircraftType, UnitType, BuildingType, VesselType] (def=none)
;    Fake = Is this a fake structure (def=no)?
;    FreeUnit = free unit to give this building [typically harvester with refinery] (def=none)
;    Power = power output [positive for output, negative for drain] (def=0)
;    Powered = Does it require power to function (def=no)?
;    Radar = Does this building give radar to owning player (def=no)?
;    Repairable = Can it be repaired (def=yes)?
;    UnitReload = Does this building reload units if they dock with it (def=no)?
;    UnitRepair = Does this building repair units if they dock with it (def=no)?
;    Unsellable = Cannot sell this building (even if it can be built)?
;    Wall = Is this a wall type structure [special rules apply] (def=no)?
;    WaterBound = Is this building placed on water only (def=no)?
;    Upgrades = Is the number of power-ups/upgrades that can be applied to this building (def=0)
;    ShipYard = This building is a ship yard or sub pen
;    SAM = This building is a SAM launcher
;    ConstructionYard = This building is a construction yard
;    Refinery = This building is a tiberium/ore refinery
;    WeaponsFactory = This building is a weapons factory
;    CloakGenerator = Does this building cloak objects around it?
;    LaserFencePost = This building is a laser fence post and obeys the rules for a building of this type.
;    LightIntensity = This building radiates this amount of light (def = 0).
;    LightVisibility= The distance (in leptons) that this light is visible from (def=5000).
;    LightRedTint   = The red tint of this buildings light (def=1.0)
;    LightGreenTint = The green tint of this buildings light (def=1.0)
;    LightBlueTint  = The blue tint of this buildings light (def=1.0)
;    InvisibleInGame= Building cannot be seen on selected in the game, only in the editor. (def=no)
;    PowersUpBuilding = Building that can be upgraded by attaching this building to it
;    PowersUpToLevel = Amount of upgrade provided by this attachment. -1=incremental upgrade. Positive number is specific upgrade.
;    Hospital = Can this building heal infantry (def = no) ?
;    Armory = Is this building an armory
;    PlaceAnywhere = Can this building ignore normal placement rules? Only use this for non-player placed buildings (def = no).
;    Weeder = Is this a weed collection facility (def=no)?
;    TogglePower = [override] Can be turned on/off under player control or affected by low power (def=yes)?
;
;	 WST 6/23/99. Below are new zbuffer adjustment for units
;	 ZFudgeCliff // fudge for units behind cliffs showing through rocks
;	 ZFudgeColumn // fudge for units behind bridge overpass support columns
;	 ZFudgeTunnel // fudge for unit behind tunnel entrances
;	 ZFudgeBridge // fudge for tall units when they are under a bridge... eg mammoth mk2
;


; Hover MLRS (hover multi-launch rocket system)
[HVR]
Name=Hover MLRS
Category=AFV
TargetLaser=yes
FireAngle=32
Prerequisite=GAWEAP,GARADR
Primary=HoverMissile
TooBigToFitUnderBridge=true
Strength=230
Armor=wood
TechLevel=7
CrateGoodie=yes
Sight=7
Speed=7
Owner=GDI
Cost=450
Turret=yes
Points=30
ROT=5
Crusher=no
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
MaxDebris=4
SpeedType=Hover
Locomotor={4A582742-9839-11d1-B709-00A024DDAFD1}
MovementZone=AmphibiousDestroyer
ThreatPosed=25	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
EliteAbilities=SELF_HEAL
ZFudgeColumn=12
ZFudgeTunnel=15

; Mammoth tank
[4TNK]
Name=Mammoth Tank
Category=AFV
TargetLaser=yes
Primary=120mmx
Secondary=MammothTusk
Strength=600
CrateGoodie=yes
Armor=heavy
Turret=yes
TechLevel=7
Sight=6
Speed=4
Owner=NOD
Cost=600
Points=60
ROT=5
Crusher=yes
SelfHealing=yes
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
MaxDebris=4
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
Weight=3.5
MovementZone=Destroyer
ThreatPosed=40	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
AllowedToStartInMultiplayer=no
ZFudgeColumn=9
ZFudgeTunnel=15

[TRUCKA]
Name=Truck
Category=AFV
Primary=none
Secondary=none
Strength=200
Armor=light
Turret=no
TechLevel=-1
Sight=5
Speed=4
Owner=GDI,Nod
AllowedToStartInMultiplayer=no
Cost=500
Points=40
ROT=5
Crusher=no
SelfHealing=no
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
Weight=2
MovementZone=Normal
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
MaxDebris=2
DebrisTypes=TIRE
DebrisMaximums=4

[TRUCKB]
Name=Truck (loaded)
Category=AFV
Primary=none
Secondary=none
Strength=200
Armor=light
Turret=no
TechLevel=-1
Sight=5
Speed=4
Owner=GDI,Nod
AllowedToStartInMultiplayer=no
Cost=500
Points=40
ROT=5
Crusher=no
SelfHealing=no
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
MaxDebris=2
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
Weight=2
MovementZone=Normal
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
DebrisTypes=TIRE
DebrisMaximums=4
CarriesCrate=yes

; Deployable Sensor Array
[LPST]
Name=Mobile Sensor Array
Category=Support
Prerequisite=FACTORY,RADAR
Strength=600
;CloakRadiusInCells=20
RadarInvisible=yes
Armor=wood
TechLevel=6
Sight=10
Speed=6
Owner=GDI,Nod
AllowedToStartInMultiplayer=no
Turret=no
Cost=317
Points=30
ROT=5
DeploysInto=GADPSA
Crusher=yes
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
MaxDebris=3
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
Weight=3.5
MovementZone=Crusher
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
ZFudgeColumn=8
ZFudgeTunnel=15

; ICBM launcher
[ICBM]
Name=Missile Launcher
Category=Support
Prerequisite=GAWEAP,GARADR
Strength=500
Armor=light
TechLevel=-1
Sight=7
Speed=6
Owner=GDI
AllowedToStartInMultiplayer=no
Turret=no
Cost=1400
Points=30
ROT=5
DeploysInto=GAICBM
Crusher=yes
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
MaxDebris=6
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
Weight=3.5
MovementZone=Crusher
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
DebrisTypes=TIRE
DebrisMaximums=4
ZFudgeColumn=18
ZFudgeTunnel=18

; repair vehicle
[REPAIR]
Name=Mobile Repair Vehicle
Category=Support
Prerequisite=NAWEAP
Primary=RepairBullet
Strength=200
Armor=light
TechLevel=7
Sight=5
Speed=6 ; Dropped from 8
Owner=Nod
AllowedToStartInMultiplayer=no
Turret=no
Cost=500
Points=30
ROT=5
Crusher=yes
Crewed=no
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
MaxDebris=3
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
Weight=3.5
MovementZone=Crusher
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SmallGreySSys ; The repair bot should not have a spark particle system in here!
GuardRange=8
SpecialThreatValue=1
ZFudgeColumn=10
ZFudgeTunnel=14

; advanced mobile artillery
; This unit needs a primary weapon type to allow targetting but it isn't actually
; allowed to fire unless deployed.
[ART2]
Name=Artillery
FireAngle=42
Prerequisite=NAWEAP,NARADR
Primary=155mm
Category=LRFS
Strength=300
;DeployTime=1.0
Turret=no
DeploysInto=GAARTY
Armor=light
TechLevel=6
Sight=9
Speed=5
Owner=Nod
AllowedToStartInMultiplayer=no
Cost=450
Points=35
CrateGoodie=yes
ROT=2
Crusher=yes
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
NoMovingFire=yes
DeployToFire=yes
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
MaxDebris=4
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
MovementZone=Crusher
ThreatPosed=10	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
Weight=3.5
EliteAbilities=SELF_HEAL
ZFudgeColumn=10
ZFudgeTunnel=14

; Weed-eater vehicle
[WEED]
Name=Weed Eater
Prerequisite=NAWEAP,NAWAST
ToProtect=yes
Category=Support
Strength=600
Armor=heavy
Dock=NAWAST
TechLevel=10
Sight=4
Weeder=yes
Speed=10
Owner=Nod
AllowedToStartInMultiplayer=no
PipScale=Tiberium
Storage=7
Cost=467
Points=55
ROT=5
Crusher=yes
Crewed=yes
SelfHealing=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
MaxDebris=6
DebrisTypes=TIRE
DebrisMaximums=4
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
Weight=3.5
MovementZone=Crusher
ThreatPosed=0	; This value MUST be 0 for all building addons
ThreatAvoidanceCoefficient=.6
DamageParticleSystems=SparkSys,SmallGreySSys
ImmuneToVeins=yes
ZFudgeColumn=7
ZFudgeTunnel=12

; harvester
[HARV]
Name=Harvester
Prerequisite=FACTORY,PROC
Nominal=yes
ToProtect=yes
Category=Support
Explodes=yes
Strength=1000
Armor=heavy
Dock=PROC
Harvester=yes
TechLevel=1
Sight=4
Speed=10
Owner=GDI,Nod
AllowedToStartInMultiplayer=no
PipScale=Tiberium
CrateGoodie=yes
Storage=28
Cost=467
Points=55
ROT=5
Crusher=yes
AutoCrush=yes
Crewed=yes
SelfHealing=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
MaxDebris=6
DebrisTypes=TIRE
DebrisMaximums=4
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
Weight=1
MovementZone=Crusher
ThreatPosed=0	; This value MUST be 0 for all building addons
ThreatAvoidanceCoefficient=.65
DamageParticleSystems=SparkSys,SmallGreySSys
ImmuneToVeins=yes
ZFudgeColumn=9
ZFudgeTunnel=14
ZFudgeBridge=7

; harvester without back
[HORV]
Name=Harvester
Nominal=yes
ToProtect=yes
Category=Support
Strength=1000
Armor=heavy
Dock=PROC
Harvester=yes
TechLevel=-1
Sight=4
Speed=8
Owner=GDI,Nod
AllowedToStartInMultiplayer=no
Cost=1400
Points=25
ROT=5
Crusher=yes
Crewed=yes
SelfHealing=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
MaxDebris=4
DebrisTypes=TIRE
DebrisMaximums=4
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
Weight=1
MovementZone=Crusher
ThreatPosed=0	; This value MUST be 0 for all building addons
ThreatAvoidanceCoefficient=1
DamageParticleSystems=SparkSys,SmallGreySSys

; Mobile Construction Vehicle
[MCV]
Name=Mobile Construction Vehicle
Prerequisite=FACTORY,TECH
Strength=1000
Category=Support
Armor=heavy
DeploysInto=GACNST
TechLevel=10
Sight=6
Speed=3
Owner=GDI,Nod
CrateGoodie=yes
Cost=833
Points=60
ROT=5
Crewed=yes
Crusher=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
MaxDebris=6
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
Weight=3.5
MovementZone=Normal
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
SpecialThreatValue=1
ZFudgeColumn=12
ZFudgeTunnel=15

; Amphibious APC
[APC]
Name= Amphibious APC
Prerequisite=GAWEAP,GAPILE
Strength=200
Category=Transport
Armor=heavy
DeployTime=.022
TechLevel=6
Sight=5
PipScale=Passengers
Speed=8
CrateGoodie=yes
Owner=GDI
AllowedToStartInMultiplayer=no
Cost=300
Points=25
ROT=5
Crusher=yes
Passengers=5
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
MaxDebris=4
DebrisTypes=TIRE
DebrisMaximums=6
SpeedType=Amphibious
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
MovementZone=AmphibiousCrusher
ThreatPosed=10	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
SpecialThreatValue=1
ZFudgeColumn=10
ZFudgeTunnel=13

; School Bus
[BUS]
Name=School Bus
Strength=100
Nominal=yes
Category=Transport
DeployTime=.022
Armor=light
TechLevel=-1
Sight=5
PipScale=Passengers
Speed=8
Owner=GDI
AllowedToStartInMultiplayer=no
Cost=800
Crusher=yes
Points=25
ROT=5
Passengers=20
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=
VoiceMove=
VoiceAttack=
VoiceFeedback=
MaxDebris=4
DebrisTypes=TIRE
DebrisMaximums=4
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
Weight=3.9
MovementZone=Normal
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys

; Train Locomotive
[LOCOMOTIVE]
Name=Locomotive
Nominal=yes
Image=MONOENG
Strength=100
Category=Transport
DeployTime=.022
Armor=light
TechLevel=-1
Sight=5
PipScale=Passengers
Speed=8
Crusher=yes
Owner=GDI
AllowedToStartInMultiplayer=no
Cost=800
Points=25
ROT=5
Passengers=2
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=
VoiceMove=
VoiceAttack=
VoiceFeedback=
MaxDebris=5
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
Weight=3.9
MovementRestrictedTo=Railroad
SlowdownDistance=700
DeaccelerationFactor=0.001
AccelerationFactor=0.01
IsTrain=yes
MovementZone=Crusher
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys

; Train car
[TRAINCAR]
Name=Train Car
Nominal=yes
Image=MONOCAR
Strength=100
Category=Transport
DeployTime=.022
Armor=light
TechLevel=-1
Sight=5
PipScale=Passengers
Speed=8
Crusher=yes
Owner=GDI
AllowedToStartInMultiplayer=no
Cost=800
Points=25
ROT=5
Passengers=10
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=
VoiceMove=
VoiceAttack=
VoiceFeedback=
MaxDebris=4
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
Weight=3.9
MovementRestrictedTo=Railroad
Passive=yes
IsTrain=yes
MovementZone=Crusher
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys

; Cargo car for train
[CARGOCAR]
Name=Cargo Car
Nominal=yes
Image=CARGOCAR
Strength=100
Crusher=yes
Category=Transport
DeployTime=.022
Armor=light
TechLevel=-1
Sight=5
PipScale=Passengers
Speed=8
Owner=GDI
AllowedToStartInMultiplayer=no
Cost=800
Points=25
ROT=5
Passengers=10
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=
VoiceMove=
VoiceAttack=
VoiceFeedback=
MaxDebris=4
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
Weight=3.9
MovementRestrictedTo=Railroad
Passive=yes
IsTrain=yes
MovementZone=Crusher
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
CarriesCrate=yes

; pickup truck
[PICK]
Name=Pickup Truck
Strength=100
Nominal=yes
Category=Transport
Armor=light
TechLevel=-1
Sight=5
PipScale=Passengers
Speed=8
Owner=GDI
AllowedToStartInMultiplayer=no
Cost=800
Points=25
ROT=5
Passengers=2
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=
VoiceMove=
VoiceAttack=
VoiceFeedback=
MaxDebris=4
DebrisTypes=TIRE
DebrisMaximums=4
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
MovementZone=Normal
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys

; Civilian automobile
[CAR]
Name=Automobile
Strength=100
Category=Transport
Nominal=yes
Armor=light
TechLevel=-1
Sight=5
PipScale=Passengers
Speed=8
Owner=GDI
AllowedToStartInMultiplayer=no
Cost=800
Points=25
ROT=5
Passengers=4
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=
VoiceMove=
VoiceAttack=
VoiceFeedback=
MaxDebris=4
DebrisTypes=TIRE
DebrisMaximums=4
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
MovementZone=Normal
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys

; Small Visceroid
[VISC_SML]
Name=Baby Visceroid
Nominal=yes
Insignificant=yes
Image=VISSML
Strength=200
Category=Civilian
Armor=light
TechLevel=-1
Sight=0
Speed=8
Owner=Civilian
AllowedToStartInMultiplayer=no
Cost=1
Points=50
ROT=16
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
TiberiumHeal=yes
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
MovementZone=Normal
SmallVisceroid=yes
ThreatPosed=0	; This value MUST be 0 for all building addons
ImmuneToVeins=yes

; Large Visceroid
[VISC_LRG]
Name=Adult Visceroid
Insignificant=yes
Image=VISLRG
Nominal=yes
AltImage=VISLGATK
Strength=500
Category=Civilian
Armor=heavy
TechLevel=-1
Sight=0
Speed=8
TiberiumHeal=yes
Owner=Civilian
AllowedToStartInMultiplayer=no
Cost=1
Points=50
ROT=16
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
MovementZone=Normal
LargeVisceroid=yes
ThreatPosed=20	; This value MUST be 0 for all building addons
Primary=SlimeAttack
GuardRange=5
ImmuneToVeins=yes

; Hunter-Seeker Droid
[GHUNTER]
Name=GDI Hunter-Seeker
Image=GGHUNT
Strength=500
Insignificant=yes
Category=AFV
Primary=SuicideBomb
Prerequisite=GAPLUG2
Armor=light
TechLevel=-1
Sight=7
Speed=25
FlightLevel=400
Owner=GDI
AllowedToStartInMultiplayer=no
Cost=1000
Points=50
ROT=16
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
ThreatPosed=10	; This value MUST be 0 for all building addons
GuardRange=5
Locomotor={4A582746-9839-11d1-B709-00A024DDAFD1}
MovementZone=Fly
HunterSeeker=yes
AlternateSpeed=10			; this value is just used when exiting the war factory
AlternateFlightLevel=50		; this value is just used when exiting the war factory
Selectable=false
IgnoresFirestorm=yes

; Hunter-Seeker Droid
[NHUNTER]
Name=Nod Hunter-Seeker
Image=GGHUNT
Strength=500
Insignificant=yes
Category=AFV
Primary=SuicideBomb
Prerequisite=NATMPL
Armor=light
TechLevel=-1
Sight=7
Speed=25
FlightLevel=400
Owner=Nod
AllowedToStartInMultiplayer=no
Cost=1000
Points=50
ROT=16
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
ThreatPosed=10	; This value MUST be 0 for all building addons
GuardRange=5
Locomotor={4A582746-9839-11d1-B709-00A024DDAFD1}
MovementZone=Fly
HunterSeeker=yes
AlternateSpeed=10			; this value is just used when exiting the war factory
AlternateFlightLevel=50		; this value is just used when exiting the war factory
Selectable=false
IgnoresFirestorm=yes

; Recreational Vehicle
[WINI]
Name=Recreational Vehicle
Nominal=yes
Strength=200
Category=Transport
Armor=light
TechLevel=-1
Sight=5
PipScale=Passengers
Speed=8
CrateGoodie=yes
Owner=GDI
AllowedToStartInMultiplayer=no
Cost=800
Points=25
ROT=5
Passengers=5
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
MaxDebris=4
DebrisTypes=TIRE
DebrisMaximums=4
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
Weight=4.0
MovementZone=Normal
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
ImmuneToVeins=yes

; Medium Mech
[MMCH]
Name=Titan
WalkRate=2
Image=MMCH
Prerequisite=GAWEAP
Primary=120mm
Strength=400
Category=AFV
Armor=heavy
Turret=yes
IsTilter=no
TargetLaser=yes
TooBigToFitUnderBridge=true
TechLevel=3
Sight=8
Speed=4
CrateGoodie=yes
Crusher=yes
Owner=GDI
Cost=450
Points=25
ROT=5
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
MaxDebris=4
Locomotor={55D141B8-DB94-11d1-AC98-006008055BB5}
MovementZone=Destroyer
ThreatPosed=40	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
DamageSmokeOffset=100, 100, 275
Weight=3.5
EliteAbilities=SENSORS
Accelerates=false
ZFudgeColumn=8
ZFudgeTunnel=13

; Mammoth Mk. II
[HMEC]
Name=Mammoth Mk.II
Prerequisite=GAWEAP,GATECH
Primary=MammothTusk
Secondary=MechRailgun
Strength=800
Category=AFV
Armor=heavy
TechLevel=10
Sight=8
Speed=3
Owner=GDI
AllowedToStartInMultiplayer=no
Cost=1000
Trainable=no
SelfHealing=yes
Points=25
ROT=3
Crusher=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
MaxDebris=6
Locomotor={55D141B8-DB94-11d1-AC98-006008055BB5}
MovementZone=Destroyer
ThreatPosed=80	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
DamageSmokeOffset=300, 300, 425
TiltsWhenCrushes=false
BuildLimit=1
Weight=3.5
Accelerates=false
ZFudgeColumn=12
ZFudgeTunnel=15
ZFudgeBridge=25

; Small Mech
[SMECH]
Name=Wolverine
Prerequisite=GAWEAP
Primary=AssaultCannon
Strength=175
Category=AFV
Armor=light
Turret=no
IsTilter=no
TooBigToFitUnderBridge=true
TechLevel=2
Sight=6
Speed=7
CrateGoodie=yes
Owner=GDI
Cost=300
Points=25
ROT=5
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=15-I000,15-I006,15-I040,15-I042
VoiceMove=15-I024,15-I044
VoiceAttack=15-I006,15-I046
VoiceFeedback=
MaxDebris=2
Locomotor={55D141B8-DB94-11d1-AC98-006008055BB5}
MovementZone=Normal
ThreatPosed=15	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
EliteAbilities=VEIN_PROOF
Accelerates=false
ImmuneToVeins=yes

; Attack Cycle
[BIKE]
Name=Attack Cycle
Prerequisite=NAWEAP
Primary=BikeMissile
Category=Recon
Strength=150
Armor=wood
Turret=no
IsTilter=yes
TechLevel=5
Sight=5
Speed=12
CrateGoodie=yes
Owner=Nod
Cost=300
Points=25
ROT=8
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
MaxDebris=2
DebrisTypes=TIRE
DebrisMaximums=2
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
MovementZone=Destroyer
ThreatPosed=20	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
Elite=HoverMissile
EliteAbilities=VEIN_PROOF

; Attack Buggy
[BGGY]
Name=Attack Buggy
Prerequisite=NAWEAP
Primary=RaiderCannon
Category=Recon
Strength=220
Armor=light
Turret=no
IsTilter=yes
TechLevel=2
Sight=6
Speed=10
CrateGoodie=yes
Owner=Nod
Cost=300
Points=25
ROT=8
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
MaxDebris=3
DebrisTypes=TIRE
DebrisMaximums=4
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
MovementZone=Normal
ThreatPosed=10	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
EliteAbilities=CRUSHER
ImmuneToVeins=yes

; Subterranean APC
[SAPC]
Name=Subterranean APC
Prerequisite=NAWEAP,NATECH
Strength=175
MoveToShroud=no
Category=Transport
DeployTime=.022
Armor=heavy
Turret=no
IsTilter=yes
TechLevel=6
Sight=5
PipScale=Passengers
Speed=5
CrateGoodie=yes
Owner=Nod
AllowedToStartInMultiplayer=no
Cost=450
Points=25
ROT=5
Crusher=yes
Passengers=5
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
MaxDebris=4
Locomotor={4A582743-9839-11d1-B709-00A024DDAFD1}
MovementZone=Subterannean
ThreatPosed=10	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
Weight=3.5
SpecialThreatValue=1
ZFudgeColumn=7
ZFudgeTunnel=13

; Subterranean Tank
[SUBTANK]
Name=Devil's Tongue
Prerequisite=NAWEAP,NATECH
Primary=FireballLauncher
MoveToShroud=no
Strength=300
Category=AFV
DeployTime=.022
TypeImmune=yes
Armor=light
Turret=no
IsTilter=yes
TechLevel=7
Sight=5
Speed=5
CrateGoodie=yes
Owner=Nod
AllowedToStartInMultiplayer=no
Cost=450
Points=25
ROT=6
Crusher=yes
NoMovingFire=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
MaxDebris=4
Locomotor={4A582743-9839-11d1-B709-00A024DDAFD1}
MovementZone=Subterannean
ThreatPosed=30	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
Weight=3.5
EliteAbilities=SELF_HEAL
AutoCrush=no
Accelerates=false
ZFudgeColumn=10
ZFudgeTunnel=14

; Disruptor
[SONIC]
Name=Disruptor
Prerequisite=GAWEAP,GATECH
Primary=SonicZap
Strength=500
TypeImmune=yes
Armor=heavy
Category=AFV
IsTilter=yes
TechLevel=9
Turret=yes
Sight=7
Speed=4
CrateGoodie=yes
Owner=GDI
Cost=433
Points=25
ROT=4
Crusher=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
AllowedToStartInMultiplayer=no
MaxDebris=5
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
Weight=3.5
MovementZone=Destroyer
ThreatPosed=60	; This value MUST be 0 for all building addons
NoMovingFire=true		; This MUST be set to true for the sonic tank
DamageParticleSystems=SparkSys,SmallGreySSys
EliteAbilities=EXPLODES
ZFudgeColumn=12
ZFudgeTunnel=15

; Tick Tank
[TTNK]
Name=Tick Tank
Category=AFV
Prerequisite=NAWEAP
Primary=90mm
Strength=350
Armor=light
TechLevel=3
CrateGoodie=yes
Sight=5
Speed=6
Owner=Nod
Cost=450
Points=40
ROT=5
Crusher=yes
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
MaxDebris=4
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
MovementZone=Destroyer
DeploysInto=GATICK
ThreatPosed=25	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
Weight=3.5
EliteAbilities=SENSORS
Elite=120mmx
AccelerationFactor=0.01
ZFudgeColumn=8
ZFudgeTunnel=13

; Stealth tank
[STNK]
Name=Stealth Tank
Prerequisite=NAWEAP,NATECH
Primary=Dragon
Strength=180 ; w250
Armor=light
Category=AFV
Turret=no
IsTilter=yes
TechLevel=8
Sight=5
Speed=6
CrateGoodie=yes
Owner=Nod
AllowedToStartInMultiplayer=no
Cost=425
Points=25
ROT=5
Crusher=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
VoiceFeedback=
MaxDebris=3
Locomotor={4A582741-9839-11d1-B709-00A024DDAFD1}
Cloakable=yes
CloakingSpeed=5
MovementZone=Destroyer
ThreatPosed=25	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
Weight=3.5
EliteAbilities=EXPLODES
ZFudgeColumn=8
ZFudgeTunnel=13

; ******* infantry types *******

[CYC2]
Name=Cyborg Commando
Category=Soldier
Primary=CyCannon
;Secondary=FireballLauncher
Prerequisite=NAHAND,NATMPL
CrushSound=SQUISHY2
Crushable=no
TiberiumProof=yes
TiberiumHeal=yes
Strength=500
Fearless=yes
Armor=heavy
TechLevel=10
Sight=7
Pip=white
Speed=4
Owner=Nod
Cost=667
Trainable=no
Cyborg=yes
Points=5
AllowedToStartInMultiplayer=no
VoiceSelect=23-I000,23-I002,23-I004,23-I006
VoiceMove=23-I008,23-I010,23-I012,23-I016
VoiceAttack=23-I014,23-I018,23-I020,23-I022
VoiceFeedback=
VoiceDie=DEDMAN1,DEDMAN2,DEDMAN2,DEDMAN4,DEDMAN5,DEDMAN6
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
MovementZone=Infantry
ThreatPosed=50	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys
BuildLimit=1
ImmuneToVeins=yes

; Chameleon Spy
[CHAMSPY]
Name=Chameleon Spy
Category=Soldier
Prerequisite=NAHAND,NATECH
CrushSound=SQUISH6
Strength=120
Armor=none
TechLevel=-1
Agent=yes
Sight=9
Speed=6
Infiltrate=yes
Owner=Nod
AllowedToStartInMultiplayer=no
Cost=700
Pip=white
Points=5
VoiceSelect=21-I000,21-I002,21-I004
VoiceMove=21-I010,21-I012,21-I016
VoiceAttack=21-I010,21-I012,21-I022
VoiceFeedback=21-I000,21-I002
VoiceDie=DEDMAN1,DEDMAN2,DEDMAN2,DEDMAN4,DEDMAN5,DEDMAN6
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
MovementZone=Infantry
Cloakable=yes
CloakingSpeed=10
ThreatPosed=0	; This value MUST be 0 for all building addons
SpecialThreatValue=1
ImmuneToVeins=yes

; rifle soldier
[E1]
Name=Light Infantry
Category=Soldier
Primary=Minigun
Prerequisite=BARRACKS
CrushSound=SQUISH6
Strength=125
Pip=green
Armor=none
TechLevel=1
Sight=5
Speed=5
Owner=GDI,Nod
Cost=120
Points=5
VoiceSelect=15-I000,15-I004,15-I012,15-I048
VoiceMove=15-I018,15-I024,15-I044
VoiceAttack=15-I044,15-I050,15-I044,15-I046
VoiceFeedback=15-I058,15-I064
VoiceDie=DEDMAN1,DEDMAN2,DEDMAN2,DEDMAN4,DEDMAN5,DEDMAN6
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
MovementZone=Infantry
ThreatPosed=10	; This value MUST be 0 for all building addons
Elite=M1Carbine
EliteAbilities=SCATTER
ImmuneToVeins=yes

[E2]
Name=Disc Thrower
Category=Soldier
Primary=Grenade
Prerequisite=GAPILE
CrushSound=SQUISH6
Strength=150
Armor=none
TechLevel=2
Pip=green
Sight=7
Speed=4
Owner=GDI
Cost=200
Points=5
VoiceSelect=15-I000,15-I004,15-I012,15-I048
VoiceMove=15-I018,15-I024,15-I044
VoiceAttack=15-I044,15-I050,15-I044,15-I046
VoiceFeedback=15-I058,15-I064
VoiceDie=DEDMAN1,DEDMAN2,DEDMAN2,DEDMAN4,DEDMAN5,DEDMAN6
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
MovementZone=InfantryDestroyer
ThreatPosed=15	; This value MUST be 0 for all building addons
EliteAbilities=SCATTER
ImmuneToVeins=yes

[E3]
Name=Rocket Infantry
Category=Soldier
Primary=BAZOOKA
Prerequisite=NAHAND
CrushSound=SQUISH6
Strength=100
Armor=none
TechLevel=2
Pip=green
Sight=7
Speed=4
Owner=Nod
Cost=250
Points=5
VoiceSelect=15-I000,15-I032,15-I048
VoiceMove=15-I008,15-I014,15-I026
VoiceAttack=15-I008,15-I014,15-I026,15-I050,15-I060
VoiceFeedback=15-I058,15-I064
VoiceDie=DEDMAN1,DEDMAN2,DEDMAN2,DEDMAN4,DEDMAN5,DEDMAN6
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
MovementZone=InfantryDestroyer
ThreatPosed=20	; This value MUST be 0 for all building addons
EliteAbilities=SCATTER
ImmuneToVeins=yes

; Hack to make MultiMissile work! Don't change data!
[WEEDGUY]
Name=Chem Spray Infantry
Category=Soldier
Primary=MultiCluster
Prerequisite=BARRACKS
TiberiumProof=yes
CrushSound=SQUISHY2
Strength=130
Storage=7
Pip=green
Fearless=yes
Armor=none
TechLevel=-1
Sight=4
Speed=3
Owner=GDI
AllowedToStartInMultiplayer=no
Cost=300
Points=5
VoiceSelect=15-I000,15-I006,15-I040,15-I042
VoiceMove=15-I024,15-I044
VoiceAttack=15-I006,15-I046
VoiceFeedback=15-I058,15-I064
VoiceDie=DEDMAN1,DEDMAN2,DEDMAN2,DEDMAN4,DEDMAN5,DEDMAN6
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
MovementZone=Infantry
ThreatPosed=0	; This value MUST be 0 for all building addons

[MEDIC]
Name=Medic
Category=Soldier
Primary=Heal
Prerequisite=GAPILE
CrushSound=SQUISHY2
Strength=125
Armor=none
TechLevel=4
Sight=6
Speed=4
SelfHealing=yes
Pip=red
Owner=GDI
AllowedToStartInMultiplayer=no
Cost=300
Points=5
VoiceSelect=20-I000,20-I004,20-I006
VoiceMove=20-I008,20-I010,20-I012
VoiceAttack=20-I016,20-I018,20-I020
VoiceFeedback=
VoiceDie=DEDMAN1,DEDMAN2,DEDMAN2,DEDMAN4,DEDMAN5,DEDMAN6
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
MovementZone=Infantry
ThreatPosed=0	; This value MUST be 0 for all building addons
GuardRange=8
SpecialThreatValue=1
ImmuneToVeins=yes

[UMAGON]
Name=Umagon
Category=Soldier
Primary=Sniper
CrushSound=SQUISH6
TiberiumProof=yes
TiberiumHeal=yes
Strength=150
Armor=light
TechLevel=-1
Sight=7
Speed=5
Owner=GDI
Pip=white
AllowedToStartInMultiplayer=no
Cost=400
Points=5
Trainable=no
VoiceSelect=10-I000,10-I002,10-I004,10-I006
VoiceMove=10-I016,10-I020,10-I022
VoiceAttack=10-I024,10-I026,10-I028,10-I030
VoiceFeedback=
VoiceDie=DEDGIRL1,DEDGIRL2,DEDGIRL2,DEDGIRL4
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
MovementZone=Infantry
ThreatPosed=15	; This value MUST be 0 for all building addons
ImmuneToVeins=yes

[GHOST]
Name=Ghost Stalker
Category=Soldier
Prerequisite=GAPILE,GATECH
Primary=LtRail
C4=yes
TiberiumHeal=yes
CrushSound=SQUISHY2
TiberiumProof=yes
Strength=200
Armor=light
TechLevel=10
Pip=white
Sight=6
Speed=4
Owner=GDI
AllowedToStartInMultiplayer=no
Cost=583
Points=5
Trainable=no
VoiceSelect=14-I000,14-I002,14-I004
VoiceMove=14-I008,14-I010,14-I012,14-I014
VoiceAttack=14-I008,14-I010,14-I014,14-I016
VoiceFeedback=
VoiceDie=DEDMAN1,DEDMAN2,DEDMAN2,DEDMAN4,DEDMAN5,DEDMAN6
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
MovementZone=Infantry
ThreatPosed=25	; This value MUST be 0 for all building addons
SpecialThreatValue=1
BuildLimit=1
ImmuneToVeins=yes

[CYBORG]
Name=Cyborg
Category=Soldier
Prerequisite=NAHAND
Primary=Vulcan3
CrushSound=SQUISHY2
Crushable=no
TiberiumProof=yes
TiberiumHeal=yes
Fearless=yes
Cyborg=yes
Pip=white
Strength=300 ; w350
Armor=light
TechLevel=4
Sight=5
Speed=4
Owner=Nod
Cost=300
Points=5
VoiceSelect=22-I000,22-I002,22-I006
VoiceMove=22-I008,22-I010,22-I014,22-I016,22-I020
VoiceAttack=22-I008,22-I010,22-I012,22-I018
VoiceFeedback=
VoiceDie=DEDMAN1,DEDMAN2,DEDMAN2,DEDMAN4,DEDMAN5,DEDMAN6
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
MovementZone=Infantry
DamageParticleSystems=SparkSys
ThreatPosed=15	; This value MUST be 0 for all building addons
EliteAbilities=STRONGER
ImmuneToVeins=yes

[MUTANT]
Name=Mutant
Category=Soldier
Primary=Vulcan
CrushSound=SQUISH6
TiberiumProof=yes
TiberiumHeal=yes
Strength=50
Armor=none
TechLevel=-1
Sight=4
Speed=4
Owner=GDI,Nod
Cost=100
Pip=white
Points=5
AllowedToStartInMultiplayer=no
VoiceSelect=15-I032,15-I048
VoiceMove=15-I008,15-I014,15-I026
VoiceAttack=15-I008,15-I014,15-I026,15-I050,15-I060
VoiceFeedback=
VoiceDie=DEDMAN1,DEDMAN2,DEDMAN2,DEDMAN4,DEDMAN5,DEDMAN6
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
MovementZone=Infantry
ThreatPosed=10	; This value MUST be 0 for all building addons
ImmuneToVeins=yes

[MWMN]
Name=Mutant Soldier
Category=Soldier
Primary=Vulcan
CrushSound=SQUISH6
TiberiumProof=yes
TiberiumHeal=yes
Strength=50
Armor=none
TechLevel=-1
Sight=4
Speed=4
Pip=white
Owner=GDI,Nod
Cost=100
Points=5
AllowedToStartInMultiplayer=no
VoiceSelect=
VoiceMove=
VoiceAttack=
VoiceFeedback=
VoiceDie=DEDGIRL1,DEDGIRL2,DEDGIRL2,DEDGIRL4
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
MovementZone=Infantry
ThreatPosed=10	; This value MUST be 0 for all building addons
ImmuneToVeins=yes

[MUTANT3]
Name=Mutant Sergeant
Category=Soldier
Primary=Vulcan
CrushSound=SQUISHY2
TiberiumProof=yes
TiberiumHeal=yes
Strength=50
Pip=white
Armor=none
TechLevel=-1
Sight=4
Speed=4
Owner=GDI,Nod
Cost=100
Points=5
AllowedToStartInMultiplayer=no
VoiceSelect=15-I032,15-I048
VoiceMove=15-I008,15-I014,15-I026
VoiceAttack=15-I008,15-I014,15-I026,15-I050,15-I060
VoiceFeedback=
VoiceDie=DEDMAN1,DEDMAN2,DEDMAN2,DEDMAN4,DEDMAN5,DEDMAN6
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
MovementZone=Infantry
ThreatPosed=10	; This value MUST be 0 for all building addons
ImmuneToVeins=yes

[TRATOS]
Name=Tratos
Category=Soldier
Primary=none
CrushSound=SQUISHY2
TiberiumProof=yes
TiberiumHeal=yes
Strength=200
Armor=none
TechLevel=-1
Sight=4
Speed=5
Owner=GDI,Nod
Pip=white
Cost=100
Points=5
AllowedToStartInMultiplayer=no
VoiceSelect=13-I000,13-I002,13-I004,13-I006
VoiceMove=13-I008,13-I010,13-I012,13-I014
VoiceAttack=13-I016,13-I018,13-I020
VoiceFeedback=
VoiceDie=DEDMAN1,DEDMAN2,DEDMAN2,DEDMAN4,DEDMAN5,DEDMAN6
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
MovementZone=Infantry
ThreatPosed=10	; This value MUST be 0 for all building addons
ImmuneToVeins=yes

[OXANNA]
Name=Oxanna
Category=Soldier
Primary=Vulcan
CrushSound=SQUISH6
TiberiumProof=yes
TiberiumHeal=yes
Strength=50
Armor=none
TechLevel=-1
Sight=4
Speed=4
AllowedToStartInMultiplayer=no
Owner=GDI,Nod
Cost=100
Pip=white
Points=5
VoiceSelect=11-I000,11-I002,11-I004,11-I006
VoiceMove=11-I008,11-I010,11-I012
VoiceAttack=11-I014,11-I016,11-I018
VoiceFeedback=
VoiceDie=DEDGIRL1,DEDGIRL2,DEDGIRL2,DEDGIRL4
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
MovementZone=Infantry
ThreatPosed=10	; This value MUST be 0 for all building addons
ImmuneToVeins=yes

[DOGGIE]
Name=Tiberian Fiend
Nominal=yes
Category=Soldier
Doggie=yes
Primary=FiendShard
CrushSound=SQUISHY2
Strength=250
Armor=light
Fearless=no
TiberiumProof=yes
TiberiumHeal=yes
Trainable=no
Pip=green
TechLevel=-1
Sight=4
Speed=8
Owner=GDI,Nod
AllowedToStartInMultiplayer=no
Cost=100
Points=5
VoiceSelect=
VoiceMove=
VoiceAttack=
VoiceFeedback=
VoiceDie=FIEND1
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
MovementZone=Infantry
ThreatPosed=25	; This value MUST be 0 for all building addons

[ENGINEER]
Name=Engineer
Category=Soldier
Primary=none
Prerequisite=BARRACKS
CrushSound=SQUISH6
Strength=100
Armor=none
TechLevel=2
Sight=4
Speed=4
Pip=yellow
Engineer=yes
Owner=GDI,Nod
AllowedToStartInMultiplayer=no
Cost=300
Points=5
VoiceSelect=19-I000,19-I002,19-I006
VoiceMove=19-I010,19-I016
VoiceAttack=19-I018,19-I016
VoiceFeedback=
VoiceDie=DEDMAN1,DEDMAN2,DEDMAN2,DEDMAN4,DEDMAN5,DEDMAN6
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
MovementZone=Infantry
ThreatPosed=0	; This value MUST be 0 for all building addons
SpecialThreatValue=1	; this should be between 0 and 1
ImmuneToVeins=yes
GuardRange=9

[JUMPJET]
Name=Jumpjet Infantry
Category=Soldier
JumpJet=yes
Primary=JumpCannon
Prerequisite=GAPILE,GARADR
Crushable=no
Strength=120
Fearless=yes
Armor=light
TechLevel=6
Sight=6
Pip=green
Speed=5
Owner=GDI
AllowedToStartInMultiplayer=no
Cost=600
Points=5
VoiceSelect=15-I000,15-I004,15-I012,15-I048
VoiceMove=15-I018,15-I024,15-I044
VoiceAttack=15-I044,15-I050,15-I044,15-I046
VoiceFeedback=15-I058,15-I064
VoiceDie=DEDMAN1,DEDMAN2,DEDMAN2,DEDMAN4,DEDMAN5,DEDMAN6
Locomotor={92612C46-F71F-11d1-AC9F-006008055BB5}
PhysicalSize=1
MovementZone=Fly		; This needs to be None, like aircraft
ThreatPosed=15	; This value MUST be 0 for all building addons
EliteAbilities=RADAR_INVISIBLE

[MHIJACK]
Name=Mutant Hijacker
Category=Soldier
Prerequisite=NAHAND,NATMPL
Primary=none
Crushable=no
;CrushSound=SQUISHY2
Strength=300
Armor=none
TiberiumProof=yes
TiberiumHeal=yes
TechLevel=10
Sight=6
Speed=7
Pip=white
Owner=Nod
Cost=617
AllowedToStartInMultiplayer=no
Points=5
Trainable=no
VoiceSelect=24-I000,24-I002,24-I004,24-I006
VoiceMove=24-I008,24-I010,24-I012,24-I014
VoiceAttack=24-I016,24-I018,24-I020,24-I022,24-I024
VoiceFeedback=
VoiceDie=DEDMAN1,DEDMAN2,DEDMAN2,DEDMAN4,DEDMAN5,DEDMAN6
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
VehicleThief=yes
MovementZone=Infantry
ThreatPosed=20	; This value MUST be 0 for all building addons
SpecialThreatValue=1	; this should be between 0 and 1
GuardRange=6
BuildLimit=1
ImmuneToVeins=yes

[SLAV]
Name=Slavick
Category=Soldier
Primary=none
CrushSound=SQUISH6
Strength=300
Armor=none
Pip=white
TechLevel=-1
Sight=4
Speed=4
Owner=GDI,Nod
Cost=100
AllowedToStartInMultiplayer=no
Points=5
VoiceSelect=12-I000,12-I002,12-I004
VoiceMove=12-I006,12-I008,12-I010
VoiceAttack=12-I012,12-I014,12-I016
VoiceFeedback=
VoiceDie=DEDMAN1,DEDMAN2,DEDMAN2,DEDMAN4,DEDMAN5,DEDMAN6
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
MovementZone=Infantry
ThreatPosed=10	; This value MUST be 0 for all building addons
ImmuneToVeins=yes

; civilians

[CIV1]
Name=Civilian
Category=Civilian
Strength=50
Armor=none
TechLevel=-1
CrushSound=SQUISH6
Insignificant=yes
Sight=2
Speed=5
Owner=GDI,Nod
AllowedToStartInMultiplayer=no
Cost=10
Points=1
;Ammo=10
Fraidycat=yes
Civilian=yes
Nominal=yes
Pip=white
VoiceSelect=Boop
VoiceMove=Boop
VoiceAttack=Boop
VoiceFeedback=
VoiceDie=DEDMAN1,DEDMAN2,DEDMAN2,DEDMAN4,DEDMAN5,DEDMAN6
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
MovementZone=Infantry
ThreatPosed=0	; This value MUST be 0 for all building addons
ImmuneToVeins=yes

[CIV2]
Name=Civilian
Category=Civilian
Strength=50
Armor=none
TechLevel=-1
CrushSound=SQUISHY2
Insignificant=yes
Sight=2
Speed=5
Owner=GDI,Nod
AllowedToStartInMultiplayer=no
Cost=10
Points=1
;Ammo=10
Fraidycat=yes
Civilian=yes
Nominal=yes
Pip=white
VoiceSelect=Boop
VoiceMove=Boop
VoiceAttack=Boop
VoiceFeedback=
VoiceDie=DEDMAN1,DEDMAN2,DEDMAN2,DEDMAN4,DEDMAN5,DEDMAN6
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
MovementZone=Infantry
ThreatPosed=0	; This value MUST be 0 for all building addons
ImmuneToVeins=yes

[CIV3]
Name=Civilian
Category=Civilian
Strength=50
Armor=none
TechLevel=-1
CrushSound=SQUISH6
Insignificant=yes
Sight=2
Speed=5
Owner=GDI,Nod
AllowedToStartInMultiplayer=no
Cost=10
Points=1
;Ammo=10
Fraidycat=yes
Civilian=yes
Nominal=yes
Pip=white
VoiceSelect=
VoiceMove=
VoiceAttack
VoiceFeedback=
VoiceDie=DEDMAN1,DEDMAN2,DEDMAN2,DEDMAN4,DEDMAN5,DEDMAN6
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
MovementZone=Infantry
ThreatPosed=0	; This value MUST be 0 for all building addons
ImmuneToVeins=yes

[CTECH]
Name=Technician
Image=CIV3
Category=Civilian
Strength=50
Primary=Pistola
Armor=none
TechLevel=-1
CrushSound=SQUISH6
Insignificant=yes
Sight=2
Speed=5
Owner=GDI,Nod
AllowedToStartInMultiplayer=no
Cost=10
Points=1
Ammo=10
Reload=80
Fraidycat=no
Civilian=yes
Nominal=yes
Pip=white
VoiceSelect=
VoiceMove=
VoiceAttack=
VoiceFeedback=
VoiceDie=DEDMAN1,DEDMAN2,DEDMAN2,DEDMAN4,DEDMAN5,DEDMAN6
Locomotor={4A582744-9839-11d1-B709-00A024DDAFD1}
PhysicalSize=1
MovementZone=Infantry
ThreatPosed=0	; This value MUST be 0 for all building addons
ImmuneToVeins=yes

; ******* aircraft types *******

; Drop Pod
[DPOD]
Name=Drop Pod
Category=AirPower
Prerequisite=afld
Primary=Vulcan2
Strength=60
Selectable=no
Armor=light
TechLevel=-1
Sight=0
RadarInvisible=yes
Speed=16
Owner=GDI
Cost=10
Points=20
ROT=5
Ammo=5
Passengers=5
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=3
VoiceSelect=30-I000,30-I002,30-I004,30-I006
VoiceMove=30-I014,30-I016,30-I018,30-I022
VoiceAttack=30-I022,30-I030,30-I034,30-I036
Locomotor={4A582745-9839-11d1-B709-00A024DDAFD1}
MovementZone=Fly
ThreatPosed=10	; This value MUST be 0 for all building addons

; Dropship
[DSHP]
Name=Dropship
Prerequisite=GAWEAP
Strength=200
Category=AirLift
Armor=heavy
Landable=yes
TechLevel=-1
Sight=3
PipScale=Passengers
Speed=18
PitchSpeed=.4
RadarInvisible=yes
Owner=GDI
Cost=0
Points=25
ROT=5
Selectable=yes
Passengers=5
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=30-I000,30-I002,30-I004,30-I006
VoiceMove=30-I014,30-I016,30-I018,30-I022
VoiceAttack=30-I022,30-I034,30-I036
IsDropship=yes
FlightLevel=1600
MaxDebris=9
Locomotor={4A582746-9839-11d1-B709-00A024DDAFD1}
MovementZone=Fly
ThreatPosed=0	; This value MUST be 0 for all building addons
;Dock=GADROP
SlowdownDistance=2000
DamageParticleSystems=SparkSys,SmallGreySSys
LegalTarget=no
AuxSound1=DROPUP1	;Taking off
AuxSound2=DROPDWN1	;Landing

; ORCA Fighter
[ORCA]
Name=Orca Fighter
Prerequisite=GAHPAD
Primary=Hellfire
Strength=200
Category=AirPower
Armor=light
TechLevel=5
Sight=4
RadarInvisible=no
Landable=yes
MoveToShroud=no
Dock=GAHPAD,NAHPAD
PipScale=Ammo
Speed=20
PitchSpeed=.16
Owner=GDI
Cost=333
Points=20
ROT=5
Ammo=5
Crewed=yes
GuardRange=30
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=4
VoiceSelect=30-I000,30-I002,30-I004,30-I006
VoiceMove=30-I014,30-I016,30-I018,30-I022
VoiceAttack=30-I022,30-I030,30-I034,30-I036
Locomotor={4A582746-9839-11d1-B709-00A024DDAFD1}
MovementZone=Fly
ThreatPosed=20	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
AuxSound1=ORCAUP1	;Taking off
AuxSound2=ORCADWN1	;Landing

; ORCA Bomber
[ORCAB]
Name=Orca Bomber
Prerequisite=GAHPAD,GATECH
Primary=Bomb
Strength=260
Category=AirPower
Armor=light
TechLevel=8
Sight=4
RadarInvisible=no
Landable=yes
MoveToShroud=no
Dock=GAHPAD,NAHPAD
PipScale=Ammo
Speed=12
PitchSpeed=.16
Owner=GDI
Cost=533
Points=20
ROT=5
Ammo=2
Crewed=yes
GuardRange=30
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=4
VoiceSelect=30-I000,30-I002,30-I004,30-I006
VoiceMove=30-I014,30-I016,30-I018,30-I022
VoiceAttack=30-I022,30-I030,30-I034,30-I036
Locomotor={4A582746-9839-11d1-B709-00A024DDAFD1}
MovementZone=Fly
ThreatPosed=25	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
AuxSound1=ORCAUP1	;Taking off
AuxSound2=ORCADWN1	;Landing
EliteAbilities=RADAR_INVISIBLE

; Orca Transport
[ORCATRAN]
Name=Orca Transport
Prerequisite=GAHPAD
Strength=200
Category=AirPower
Armor=light
TechLevel=-1
Sight=2
RadarInvisible=no
Landable=yes
PipScale=Passengers
Passengers=5
Speed=9
PitchSpeed=1.1
Owner=GDI
Cost=1200
Points=20
ROT=5
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=4
VoiceSelect=30-I000,30-I002,30-I004,30-I006
VoiceMove=30-I014,30-I016,30-I018,30-I022
VoiceAttack=30-I022,30-I034,30-I036
Locomotor={4A582746-9839-11d1-B709-00A024DDAFD1}
MovementZone=Fly
DamageParticleSystems=SparkSys,SmallGreySSys
AuxSound1=ORCAUP1	;Taking off
AuxSound2=ORCADWN1	;Landing
ThreatPosed=0
SpecialThreatValue=1

; Carryall
[TRNSPORT]
Name=Carryall
Prerequisite=GAHPAD,GADEPT
Strength=175
Category=AirPower
Armor=light
TechLevel=9
Sight=4
RadarInvisible=no
Carryall=yes
Landable=yes
MoveToShroud=no
Speed=16
PitchSpeed=1.1
Owner=GDI
Cost=300
Points=20
ROT=5
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=4
VoiceSelect=30-I000,30-I002,30-I004,30-I006
VoiceMove=30-I014,30-I016,30-I018,30-I022
VoiceAttack=30-I022,30-I034,30-I036
Locomotor={4A582746-9839-11d1-B709-00A024DDAFD1}
MovementZone=Fly
DamageParticleSystems=SparkSys,SmallGreySSys
AuxSound1=DROPUP1 ;Taking off
AuxSound2=DROPDWN1 ;Landing
ThreatPosed=0
SpecialThreatValue=1

; Banshee Fighter
[SCRIN]
Name=Banshee
Prerequisite=NAHPAD,NATECH
Primary=Proton
Strength=280
Category=AirPower
Armor=light
TechLevel=9
Sight=4
RadarInvisible=no
Landable=yes
MoveToShroud=no
Dock=NAHPAD,GAHPAD
PipScale=Ammo
Speed=18
PitchSpeed=.9
Owner=Nod
Cost=500
Points=20
ROT=3
Ammo=3
Crewed=yes
GuardRange=30
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=3
VoiceSelect=32-I000
VoiceMove=32-I004
VoiceAttack=32-I002,32-I004,32-I006
VoiceFeedback=32-I008
VoiceDie=32-I008
Locomotor={4A582746-9839-11d1-B709-00A024DDAFD1}
MovementZone=Fly
ThreatPosed=30	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
AuxSound1=DROPUP1 ;Taking off
AuxSound2=DROPDWN1 ;Landing
EliteAbilities=RADAR_INVISIBLE

; Apache Chopper
[APACHE]
Name=Harpy
Prerequisite=NAHPAD
Primary=HarpyClaw
Strength=225
Category=AirPower
Armor=light
TechLevel=5
Sight=4
RadarInvisible=yes
Landable=yes
MoveToShroud=no
Dock=NAHPAD,GAHPAD
PipScale=Ammo
Speed=14
PitchSpeed=.16
Owner=Nod
Cost=333
Points=20
ROT=5
Ammo=12
Crewed=yes
GuardRange=30
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=3
VoiceSelect=30-I000,30-I002,30-I004,30-I006
VoiceMove=30-I014,30-I016,30-I018,30-I022
VoiceAttack=30-I022,30-I030,30-I034,30-I036
Locomotor={4A582746-9839-11d1-B709-00A024DDAFD1}
MovementZone=Fly
ThreatPosed=15	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys

; ******* building types *******

; advanced tech center
[GATECH]
Name=GDI Tech Center
Prerequisite=GAWEAP,GARADR
Strength=500
Armor=wood
TechLevel=6
Adjacent=2
Sight=6
Owner=GDI
Cost=167
Points=85
Power=-200
Capturable=true
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=5
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=1500, 1055, 815
AIBuildThis=yes
TogglePower=no

; GDI weapons factory
[GAWEAP]
Name=GDI War Factory
Image=GAWEAP
WeaponsFactory=yes
Prerequisite=PROC,GAPILE
Factory=UnitType
DeployTime=.044
Strength=1000
Armor=heavy
TechLevel=2
Sight=4
Adjacent=2
Owner=GDI
Cost=667
Points=80
Power=-30
Capturable=true
Crewed=yes
Bib=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=408, 880, 435
AIBuildThis=yes

; NOD weapons factory
[NAWEAP]
Name=Nod War Factory
WeaponsFactory=yes
Prerequisite=PROC,NAHAND
Factory=UnitType
DeployTime=.044
Strength=1000
Adjacent=2
Armor=heavy
TechLevel=2
Sight=4
Owner=Nod
Cost=667
Points=80
Power=-30
Capturable=true
Crewed=yes
Bib=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
NaturalSmokeLocation=-12,0,370
MaxDebris=8
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=395, 750, 410
AIBuildThis=yes

; construction yard
[GACNST]
Name=Construction Yard
ConstructionYard=yes
Strength=1000
Armor=heavy
TechLevel=-1
Adjacent=2
Factory=BuildingType
UndeploysInto=MCV
Sight=6
Owner=GDI,Nod
Cost=2500
Points=80
Power=0
Capturable=true
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=10
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=1470, 1060, 1078
AIBuildThis=yes
TogglePower=no

[GADPSA]
Name=Deployed Sensor Array
TechLevel=-1
Strength=600
Points=50
Cost=950
Sight=8
Power=0
Armor=wood
SensorArray=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
VoiceSelect=25-I000
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
MaxDebris=2
UndeploysInto=LPST
BaseNormal=no
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=500, 500, 400
HasRadialIndicator=true
RadialColor=0,200,0
CloakRadiusInCells=25
TogglePower=no

[GAICBM]
Name=Deployed ICBM
TechLevel=-1
Strength=400
Points=50
Power=0
Armor=wood
ICBMLauncher=yes
;SuperWeapon=MultiSpecial
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
UndeploysInto=ICBM
BaseNormal=no
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=500, 500, 400
TogglePower=no

[GATICK]
Name=Deployed Tick Tank
TechLevel=5
Strength=350
Points=50
Cost=800
Power=0
Armor=concrete
Sight=5
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=4
UndeploysInto=TTNK
BaseNormal=no
VoiceSelect=25-I000,25-I002,25-I004,25-I006
VoiceMove=25-I012,25-I014,25-I016,25-I018,25-I022
VoiceAttack=25-I014,25-I022,25-I024,25-I026
Crewed=yes
Primary=90mm
Elite=120mmx
Turret=yes
ROT=5
TickTank=yes
TurretAnim=TTNKTUR
TurretAnimIsVoxel=true
TurretAnimX=4
TurretAnimY=10
TurretAnimZAdjust=-20
ThreatPosed=30	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys
DamageSmokeOffset=500, 500, 400
Trainable=yes
TogglePower=no
EliteAbilities=SENSORS
HasStupidGuardMode=false

[GAARTY]
Name=Deployed Artillery
TechLevel=8
Strength=300
Points=50
Cost=975
Power=0
Armor=light
Sight=9
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=4
UndeploysInto=ART2
BaseNormal=no
VoiceSelect=15-I004,15-I006,15-I008,15-I010,15-I012,15-I038,15-I040,15-I048
VoiceMove=15-I014,15-I016,15-I018,15-I020,15-I022,15-I024,15-I060
VoiceAttack=15-I026,15-I032,15-I044,15-I046,15-I050
Crewed=yes
Primary=155mm
Turret=yes
ROT=5
Artillary=yes
TurretAnim=ART2TUR
TurretAnimIsVoxel=true
TurretAnimX=-8
TurretAnimY=15
TurretAnimZAdjust=-20
ThreatPosed=30	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=500, 500, 400
EliteAbilities=SELF_HEAL
Trainable=yes
TogglePower=no
HasStupidGuardMode=false

; Tiberium Refinery
[PROC]
Name=Tiberium Refinery
Image=NAREFN
Refinery=yes
Bib=yes
Prerequisite=POWER
Strength=900
Adjacent=2
Armor=heavy
TechLevel=1
FreeUnit=HARV
DockUnload=yes
Sight=6
Owner=GDI,Nod
Cost=667
Points=80
Power=-30
Storage=80
Capturable=true
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
HalfDamageSmokeLocation1=0,0,0
MaxDebris=8
PipScale=Tiberium
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=410, 100, 165
AIBuildThis=yes
TogglePower=no

; storage silo
[GASILO]
Name=Tiberium Silo
Prerequisite=PROC
Strength=300
Armor=wood
TechLevel=1
Adjacent=2
Sight=2
Owner=GDI,Nod
Cost=50
Points=25
Power=-10
Storage=240
Explodes=yes
Capturable=true
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=2
PipScale=Tiberium
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,LGSparkSys
DamageSmokeOffset=700, 700, 500
TogglePower=no

; helipad
[GAHPAD]
Name=Helipad
Prerequisite=GARADR
Strength=600
Armor=wood
Adjacent=2
TechLevel=5
Sight=5
UnitReload=yes
Helipad=yes
Owner=GDI
Cost=167
Points=70
Power=-10
Factory=AircraftType
Capturable=true
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=4
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=75, 270, 140
AIBuildThis=yes
HasStupidGuardMode=false

; helipad
[NAHPAD]
Name=Helipad
Prerequisite=NARADR
Strength=600
Armor=wood
Adjacent=2
TechLevel=5
Sight=5
UnitReload=yes
Helipad=yes
Owner=Nod
Cost=167
Points=70
Power=-10
Factory=AircraftType
Capturable=true
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=4
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=275, 60, 140
AIBuildThis=yes
HasStupidGuardMode=false

; GDI Radar
[GARADR]
Name=Radar
Prerequisite=PROC
Strength=1000
Radar=yes
Armor=wood
TechLevel=3
Adjacent=2
Sight=10
Owner=GDI
Cost=333
Points=60
Power=-40
Powered=true
Capturable=true
Sensors=yes
Crewed=yes
Upgrades=0
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=6
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=440, 200, 200
AIBuildThis=yes

; GDI Communications tower
[GAPLUG]
Name=GDI Upgrade Center
Prerequisite=PROC,GATECH
Strength=1000
Radar=no
Armor=wood
TechLevel=10
Adjacent=2
Sight=6
Owner=GDI
Cost=333
Points=60
Power=-150
Powered=true
Capturable=true
Sensors=yes
Crewed=yes
Upgrades=2
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=6
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=800, 550, 400
AIBuildThis=yes
SpecialThreatValue=1
IsPlug=true

; NOD Stealth Generator
[NASTLH]
Name=Stealth Generator
Prerequisite=PROC,NATECH
CloakGenerator=yes
CloakRadiusInCells=12
HasRadialIndicator=true
RadialColor=255,0,0
Strength=600
Armor=wood
TechLevel=9
Adjacent=2
Sight=6
Owner=Nod
Cost=833 ; w2000
Points=60
Power=-350
Powered=true
Capturable=true
Sensors=yes
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=5
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=450, 200, 150
AIBuildThis=yes ; commented out so that it's easier to debug base building

; gdi power plant
[GAPOWR]
Name=GDI Power Plant
Strength=750
Armor=wood
TechLevel=1
Adjacent=2
Sight=4
Owner=GDI
Cost=100
Points=40
Power=200
Capturable=true
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
Upgrades=2
MaxDebris=6
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=300, 300, 450
TogglePower=no

; nod power plant
[NAPOWR]
Name=NOD Power Plant
Strength=750
Armor=wood
TechLevel=1
Sight=4
Adjacent=2
Owner=Nod
Cost=100
Points=40
Power=200
Capturable=true
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=6
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=450, 200, 300
TogglePower=no

; Nod advanced power plant
[NAAPWR]
Name=Advanced Power Plant
Prerequisite=NAWEAP
Strength=750
Armor=wood
TechLevel=7
Adjacent=2
Sight=4
Owner=Nod
Cost=167
Points=40
Power=400
Capturable=true
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=290, 570, 320
TogglePower=no

; NOD Tech Center
[NATECH]
Name=NOD Tech Center
Prerequisite=NAWEAP,NARADR
Strength=500
Armor=wood
TechLevel=6
Adjacent=2
Sight=6
Owner=Nod
Cost=500
Points=85
Power=-100
Capturable=true
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=5
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=200, 325, 200
AIBuildThis=yes
TogglePower=no

; NOD Barracks
[NAHAND]
Name=Hand Of Nod
Prerequisite=POWER
Strength=800
Armor=wood
TechLevel=1
Adjacent=2
Sight=5
Owner=Nod
Cost=100
Points=30
Power=-20
Factory=InfantryType
Crewed=yes
Capturable=true
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=4
ThreatPosed=0	; This value MUST be 0 for all building addons
ExitCoord = 0,0,0
NODBarracks=yes
DamageParticleSystems=SparkSys,SmallGreySmokeSys,BigGreySmokeSys
DamageSmokeOffset=480, 96, 125
AIBuildThis=yes

; GDI Barracks
[GAPILE]
Name=Barracks
Prerequisite=POWER
Strength=800
Armor=wood
Factory=InfantryType
Adjacent=2
TechLevel=1
Sight=5
Owner=GDI
Cost=100
Points=30
Power=-20
Crewed=yes
Capturable=true
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=4
ThreatPosed=0	; This value MUST be 0 for all building addons
ExitCoord = -64,64,0
GDIBarracks=yes
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=215, 395, 200
AIBuildThis=yes

; service depot
[GADEPT]
Name=Service Depot
Prerequisite=FACTORY
Strength=1100
Armor=wood
TechLevel=7
Adjacent=2
Sight=5
UnitRepair=yes
UnitReload=yes
Owner=GDI ; removed from Nod side
Cost=400
Points=80
Power=-30
Capturable=true
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=4
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=270, 580, 260
AIBuildThis=yes
HasStupidGuardMode=false

; Pavenent
[GAPAVE]
Name=Pavement
Strength=150
Prerequisite=BARRACKS
High=yes
Armor=concrete
TechLevel=6
Adjacent=3
Sight=0
Selectable=no
Insignificant=yes
Nominal=yes
Owner=GDI,Nod
Cost=75
BaseNormal=no
Points=5
Repairable=false
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
ThreatPosed=0	; This value MUST be 0 for all building addons
ToTile=pvclr01

; green lat (not used)
[GAGREEN]
Name=Green Building
Image=null
Strength=150
Prerequisite=GAPILE
High=yes
Armor=concrete
TechLevel=-1
Adjacent=3
Sight=0
Selectable=no
Insignificant=yes
Nominal=yes
Owner=GDI,Nod
Cost=100
BaseNormal=no
Points=5
Repairable=false
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
ThreatPosed=0	; This value MUST be 0 for all building addons
ToTile=Green01

; sandbag wall
[GASAND]
Name=Sandbags
Strength=250
Prerequisite=BARRACKS
Armor=light
CrushSound=SANDBAG1
Crushable=yes
Wall=yes
TechLevel=-1
Adjacent=4
Sight=0
Nominal=yes
Selectable=no
Owner=GDI,NOD
Cost=25
BaseNormal=no
Insignificant=yes
Points=1
Repairable=false
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
ThreatPosed=0	; This value MUST be 0 for all building addons
IsBase=no

; concrete wall
[GAWALL]
Name=Concrete Wall
Strength=150
Prerequisite=GAPILE
High=yes
Armor=concrete
TechLevel=6
Adjacent=4
Wall=yes
Sight=1
Selectable=no
Insignificant=yes
Nominal=yes
Owner=GDI
Cost=50
BaseNormal=no
Points=5
Repairable=false
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
ThreatPosed=0	; This value MUST be 0 for all building addons
IsBase=no

; NOD wall
[NAWALL]
Name=Nod Wall
Strength=150
Prerequisite=NAHAND
High=yes
Armor=concrete
TechLevel=6
Adjacent=4
Wall=yes
Sight=1
Selectable=no
Insignificant=yes
Nominal=yes
Owner=Nod
Cost=50
BaseNormal=no
Points=5
Repairable=false
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
ThreatPosed=0	; This value MUST be 0 for all building addons
IsBase=no

; Bridge repair hut
[CABHUT]
Name=Bridge repair hut
Strength=2000
Immune=yes
LegalTarget=no
Nominal=yes
TechLevel=-1
RadarInvisible=yes
Repairable=true
Selectable=no
Insignificant=yes
BridgeRepairHut=yes
Adjacent=0
BaseNormal=no
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
ThreatPosed=0	; This value MUST be 0 for all building addons

; Nod pulse cannon
[NAPULS]
Name=EMP Cannon
Strength=500
Armor=heavy
Prerequisite=Radar
TechLevel=6
Sight=8
Adjacent=2
Owner=Nod,GDI
Cost=333
Turret=yes
Points=50
Power=-150
Sensors=yes
Crewed=yes
ROT=12
EMPulseCannon=yes
SuperWeapon=EMPulseSpecial
Primary=EMPulseWeapon
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=5
TurretAnim=PULSCAN
TurretAnimIsVoxel=true
TurretAnimY=7
TurretAnimX=1
TurretAnimZAdjust=-100
ThreatPosed=30	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=350, 125, 100
HasStupidGuardMode=false

; GDI Component Tower
[GACTWR]
Name=Component Tower
Strength=500
Armor=light
Prerequisite=GAPILE
TechLevel=2
Sight=4
Adjacent=3
Owner=GDI
Cost=67
Turret=yes
Points=50
Power=-10
Sensors=yes
BaseNormal=no
Crewed=no
ROT=12
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
TurretAnimZAdjust=-45   ;WST 6/18/99 was 50 but cause z buffer problem: Component towers turret animation depends on what the player attaches :
HasSpotlight=false;
MaxDebris=2
ThreatPosed=30	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,LGSparkSys
DamageSmokeOffset=500, 500, 400
IsBase=no
HasStupidGuardMode=false

; GDI gate in wall
[GAGATE_A]
Name=Gate
Strength=350
Prerequisite=GAPILE
Armor=heavy
TechLevel=6
Selectable=yes
Capturable=false
Insignificant=yes
Adjacent=4
Owner=GDI
Cost=250
BaseNormal=no
Points=50
Repairable=true
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=3
Gate=yes
DeployTime=.044
GateCloseDelay=.2
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,LGSparkSys
IsBase=no

; GDI gate in wall
[GAGATE_B]
Name=Gate
Strength=350
Armor=heavy
Prerequisite=GAPILE
TechLevel=6
Adjacent=4
Selectable=yes
Capturable=false
Insignificant=yes
Owner=GDI
Cost=250
BaseNormal=no
Points=50
Repairable=true
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
Gate=yes
DeployTime=.044
GateCloseDelay=.2
MaxDebris=2
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,LGSparkSys
IsBase=no

; Nod gate in wall
[NAGATE_A]
Name=Gate
Strength=350
Armor=heavy
Prerequisite=NAHAND
TechLevel=6
Adjacent=4
Selectable=yes
Capturable=false
Insignificant=yes
Owner=Nod
Cost=250
BaseNormal=no
Points=50
Repairable=true
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
Gate=yes
DeployTime=.044
GateCloseDelay=.2
MaxDebris=2
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,LGSparkSys
IsBase=no

; Nod gate in wall
[NAGATE_B]
Name=Gate
Strength=350
Armor=heavy
Prerequisite=NAHAND
TechLevel=6
Adjacent=4
Selectable=yes
Capturable=false
Insignificant=yes
Owner=Nod
Cost=250
BaseNormal=no
Points=50
Repairable=true
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
Gate=yes
DeployTime=.044
GateCloseDelay=.2
MaxDebris=2
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,LGSparkSys
IsBase=no

; Light post
[TSTLAMP]
Name=AlphaLightPost
Image=GALITE
Strength=600
Armor=wood
TechLevel=-1
Nominal=yes
Sight=0
Points=30
Power=0
Crewed=no		; why would we want guys to come out of the lightpost? BNA 7/15/99
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=1
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys
Insignificant=yes
AlphaImage=ALPHATST

; Light post
[GALITE]
Name=Light Post
Image=GALITE
Strength=600
Armor=wood
Owner=GDI,NOD
Cost=200
TechLevel=-1 ; changed from 12
Nominal=yes
Sight=0
Points=30
Power=0
Crewed=NO
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=1
LightVisibility=5000
LightIntensity=0.2
LightRedTint=0.05
LightGreenTint=0.05
LightBlueTint=0.01
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,LGSparkSys
AlphaImage=NONE
Powered=true

; Black Light post
[NEGLAMP]
Name=Negative Light Post
Image=GALITE
Strength=1000
Armor=wood
TechLevel=-1
InvisibleInGame=yes
Nominal=yes
Sight=0
Points=30
Power=0
Crewed=no
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=4
LightVisibility=3500
LightIntensity=-0.15
LightRedTint=0.03
LightGreenTint=0.04
LightBlueTint=0.04
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,LGSparkSys
Insignificant=yes

; Light post
[INGALITE]
Name=Invisible Light Post
Image=GALITE
InvisibleInGame=yes
Insignificant=yes
Selectable=no
Strength=6000
Armor=wood
TechLevel=-1
Nominal=yes
Sight=0
Points=30
Power=0
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=1
LightVisibility=5000
LightIntensity=0.2
LightRedTint=0.05
LightGreenTint=0.05
LightBlueTint=0.01
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,LGSparkSys
Powered=true

; Light post
[REDLAMP]
Name=Red Light Post
Image=GALITE
Insignificant=yes
Strength=600
Armor=wood
TechLevel=-1
Nominal=yes
Sight=0
Points=30
Power=0
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=1
LightVisibility=4000
LightIntensity=0.01
LightRedTint=1.5
LightGreenTint=0.01
LightBlueTint=0.01
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,LGSparkSys
AlphaImage=NONE
Powered=true

; Light post
[NEGRED]
Name=Negative Red Light
Image=GALITE
Insignificant=yes
Strength=6000
Armor=wood
TechLevel=-1
Nominal=yes
Sight=0
Points=30
Power=0
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=1
LightVisibility=4000
LightIntensity=-0.05
LightRedTint=-1.5
LightGreenTint=0.01
LightBlueTint=0.01
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,LGSparkSys

; Light post
[GRENLAMP]
Name=Green Light Post
Image=GALITE
Strength=600
Armor=wood
TechLevel=-1
Nominal=yes
Sight=0
Points=30
Power=0
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=1
LightVisibility=4000
LightIntensity=0.01
LightRedTint=0.01
LightGreenTint=1.5
LightBlueTint=0.01
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,LGSparkSys
AlphaImage=NONE
Powered=true
Insignificant=yes

; Light post
[BLUELAMP]
Name=Blue Light Post
Image=GALITE
Strength=600
Armor=wood
TechLevel=-1
Nominal=yes
Sight=0
Points=30
Power=0
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=1
LightVisibility=4000
LightIntensity=0.01
LightRedTint=0.01
LightGreenTint=0,01
LightBlueTint=0.7
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,LGSparkSys
AlphaImage=NONE
Powered=true
Insignificant=yes

; Light post
[YELWLAMP]
Name=Yellow Light Post
Image=GALITE
Strength=600
Armor=wood
TechLevel=-1
Nominal=yes
Sight=0
Points=30
Power=0
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=1
LightVisibility=4000
LightIntensity=.01
LightRedTint=1.5
LightGreenTint=1.5
LightBlueTint=0.01
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,LGSparkSys
Powered=true
Insignificant=yes

; Light post
[INYELWLAMP]
Name=Invisible Yellow Light Post
Image=GALITE
Insignificant=yes
Selectable=no
InvisibleInGame=yes
Strength=6000
Armor=wood
TechLevel=-1
Nominal=yes
Sight=0
Points=30
Power=0
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=1
LightVisibility=4000
LightIntensity=.01
LightRedTint=1.5
LightGreenTint=1.5
LightBlueTint=0.01
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,LGSparkSys
Powered=true

; Light post
[PURPLAMP]
Name=Purple Light Post
Image=GALITE
Strength=600
Armor=wood
TechLevel=-1
Nominal=yes
Sight=0
Points=30
Power=0
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=1
LightVisibility=3000
LightIntensity=0.01
LightRedTint=2.0
LightGreenTint=0.01
LightBlueTint=2.0
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,LGSparkSys
AlphaImage=NONE
Powered=true
Insignificant=yes

; Light post
[INPURPLAMP]
Name=Invisible Purple Light Post
Image=GALITE
Selectable=no
Insignificant=yes
InvisibleInGame=yes
Strength=6000
Armor=wood
TechLevel=-1
Nominal=yes
Sight=0
Points=30
Power=0
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
LightVisibility=3000
LightIntensity=0.01
LightRedTint=2.0
LightGreenTint=0.01
LightBlueTint=2.0
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,LGSparkSys
Powered=true

; Light post
[INORANLAMP]
Name=Orange Light Post
Image=GALITE
Selectable=no
InvisibleInGame=yes
Strength=600
Armor=wood
TechLevel=-1
Nominal=yes
Sight=0
Points=30
Power=0
Crewed=no
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
LightVisibility=3000
LightIntensity=0.01
LightRedTint=2.0
LightGreenTint=1.4
LightBlueTint=0.3
DamageParticleSystems=SparkSys,LGSparkSys
Powered=true
Insignificant=yes

; Light post
[INGRNLMP]
Name=Invisible Green Light Post
Image=GALITE
Selectable=no
InvisibleInGame=yes
Insignificant=yes
Strength=6000
Armor=wood
TechLevel=-1
Nominal=yes
Sight=0
Points=30
Power=0
Crewed=no
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
LightVisibility=4000
LightIntensity=0.01
LightRedTint=0.01
LightGreenTint=1.5
LightBlueTint=0.01
DamageParticleSystems=SparkSys,LGSparkSys
Powered=true

; Light post
[INREDLMP]
Name=Invisible Red Light Post
Image=GALITE
Selectable=no
Insignificant=yes
InvisibleInGame=yes
Strength=6000
Armor=wood
TechLevel=-1
Nominal=yes
Sight=0
Points=30
Power=0
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
LightVisibility=4000
LightIntensity=0.01
LightRedTint=1.5
LightGreenTint=0.01
LightBlueTint=0.01
DamageParticleSystems=SparkSys,LGSparkSys
Powered=true

; Invisible Light post
[INBLULMP]
Name=Invisible Blue Light Post
Selectable=no
InvisibleInGame=yes
Insignificant=yes
Image=GALITE
Strength=6000
Armor=wood
TechLevel=-1
Nominal=yes
Sight=0
Points=30
Power=0
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
LightVisibility=4000
LightIntensity=0.01
LightRedTint=0.01
LightGreenTint=0,01
LightBlueTint=0.7
DamageParticleSystems=SparkSys,LGSparkSys
Powered=true

; Temple of NOD
[NATMPL]
Name=Temple of NOD
Prerequisite=NATECH
Strength=1000
Armor=wood
TechLevel=10
Adjacent=3
Sight=6
Owner=Nod
Cost=667
Points=60
Power=-200
Capturable=true
Sensors=yes
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=9
ThreatPosed=0	; This value MUST be 0 for all building addons
SuperWeapon=HuntSeekSpecial
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=1210, 680, 400
AIBuildThis=yes
IsTemple=yes

; pyramid of NOD
[NTPYRA]
Name=NOD Pyramid
Strength=1500
Armor=heavy
TechLevel=-1
Adjacent=2
Sight=0
Owner=Nod
Cost=1000
Points=60
Power=-40
Capturable=true
Sensors=yes
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=9
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=1150, 660, 475

;Kodiak
[GAKODK]
Name=GDI Kodiak
Strength=1500
Armor=heavy
TechLevel=-1
Adjacent=2
Sight=10
Owner=GDI
Cost=1000
Points=60
Power=0
Capturable=true
Sensors=yes
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=9
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=1200, 880, 635
IsBase=no
TogglePower=no

;Montauk
[NAMNTK]
Name=NOD Montauk
Strength=1500
Armor=heavy
TechLevel=-1
Adjacent=2
Sight=0
Owner=NOD
Cost=1000
Points=60
Power=0
Capturable=true
Sensors=yes
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=9
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=700, 1180, 800
IsBase=no
TogglePower=no

; Dropship bay (obsolete)
;[GADROP]
;Name=Dropship Bay
;Prerequisite=DOME,GATECH
;Strength=3000
;TechLevel=9
;Adjacent=2
;Sight=10
;Owner=GDI
;Cost=1000
;Points=60
;Power=-40
;Powered=true
;Capturable=true
;Sensors=yes
;Crewed=yes
;Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
;MaxDebris=8
;ThreatPosed=0	; This value MUST be 0 for all building addons
;DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys

;NOD Radar Facility
[NARADR]
Name=NOD Radar
Prerequisite=PROC
Strength=1000
Radar=yes
Armor=wood
TechLevel=3
Adjacent=2
Sight=10
Owner=NOD
Cost=333
Points=60
Power=-40
Powered=true
Capturable=true
Sensors=yes
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=4
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=220, 390, 150
AIBuildThis=yes

; Nod tiberium waste facility
[NAWAST]
Name=Tiberium Waste Facility
Prerequisite=NAMISL
Strength=400
Armor=wood
TechLevel=10
Adjacent=2
Sight=5
Owner=Nod
Cost=533
Points=60
Power=-40
FreeUnit=WEED
Capturable=true
Sensors=yes
Crewed=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=4
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=400, 625, 200
Weeder=yes
Bib=yes
PipScale=Tiberium
;SuperWeapon=ChemicalSpecial
AIBuildThis=yes
TogglePower=no
BuildLimit=1

; NOD Obelisk
[NAOBEL]
Name=Obelisk of Light
Prerequisite=NATECH
Strength=725
Armor=wood
TechLevel=9
Adjacent=2
Sight=8
Owner=Nod
Cost=500
Points=30
Power=-150
Crewed=yes
Capturable=false
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
Primary=LaserFire
Turret=no
TurretAnim=NAOBEL_B
TurretAnimZAdjust=-100
MaxDebris=4
ThreatPosed=40	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=355, 525, 225
IsBaseDefense=yes
BaseNormal=no
Powered=yes
HasStupidGuardMode=false

; Nod missile silo
[NAMISL]
Name=Missile Silo
SuperWeapon=MultiSpecial
SuperWeapon2=ChemicalSpecial
Prerequisite=NATECH
Strength=1000
Armor=wood
TechLevel=10
Adjacent=2
Sight=4
Owner=Nod
Cost=433
Points=30
Power=-50
Crewed=yes
Capturable=true
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=6
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,LGSparkSys
AIBuildThis=yes
SpecialThreatValue=1
NukeSilo=yes
HasStupidGuardMode=false

; Vulcan cannon add-on for component tower
[GAVULC]
Name=Vulcan Cannon
Image=GAVULC
Prerequisite=GACTWR,GAPILE
TechLevel=2
Armor=wood
Sight=7
Owner=GDI
Cost=50
Points=30
Power=-20
Crewed=no
Capturable=no
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
PowersUpBuilding=gactwr
PowersUpToLevel=1
Primary=VulcanTower
Secondary=VulcanTower
Turret=yes
ThreatPosed=0	; This value MUST be 0 for all building addons
IsBaseDefense=yes

; Rocket launcher addon for component tower
[GAROCK]
Name=RPG Upgrade
Image=GAROCK
Prerequisite=GACTWR,GAPILE
TechLevel=9
Armor=wood
Sight=8
Owner=GDI
Cost=200
Points=30
Power=-20
Crewed=no
Capturable=no
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
PowersUpBuilding=gactwr
PowersUpToLevel=2
Primary=RPGTower
Turret=yes
ThreatPosed=0	; This value MUST be 0 for all building addons
IsBaseDefense=yes

; SAM addon for component tower
[GACSAM]
Name=SAM Upgrade
Image=GACSAM
Prerequisite=GACTWR,GARADR
TechLevel=5
Armor=wood
Sight=10
Owner=GDI
Cost=100
Points=30
Power=-30
Crewed=no
Capturable=no
Explosion=TWLT070
PowersUpBuilding=gactwr
PowersUpToLevel=3
Primary=RedEye2
Secondary=RedEye2
Turret=yes
ThreatPosed=0	; This value MUST be 0 for all building addons
IsBaseDefense=yes
Powered=yes

; GDI Power plant upgrade.
[GAPOWRUP]
Name=Power Turbine
Prerequisite=GAPOWR
Image=GAPOWR_B
TechLevel=7
Armor=wood
Sight=1
Owner=GDI
Cost=100
Points=30
Power=100
Crewed=no
Capturable=no
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
PowersUpBuilding=gapowr
PowersUpToLevel=-1
ThreatPosed=0	; This value MUST be 0 for all building addons

; OBSOLETE Upgrade No. 1 for GDI radar
[GAPLUG1]
Name=Threat Rating Node
Image=GAPLUG_D
Prerequisite=GAPLUG
TechLevel=-1
Armor=wood
Sight=1
Owner=GDI
Cost=500
Points=30
Power=-20
Crewed=no
Capturable=no
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
PowersUpBuilding=gaplug
PowersUpToLevel=-1
ThreatPosed=0	; This value MUST be 0 for all building addons
IsThreatRatingNode=true

; Upgrade No. 2 for GDI radar
[GAPLUG2]
Name=Seeker Control
Image=GAPLUG_E
Prerequisite=GAPLUG,GATECH,GAWEAP
TechLevel=10
Armor=wood
Sight=1
Owner=GDI
Cost=333
Points=30
Power=-50
Crewed=no
Capturable=no
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
PowersUpBuilding=gaplug
PowersUpToLevel=-1
ThreatPosed=0	; This value MUST be 0 for all building addons
SuperWeapon=HuntSeekSpecial
AIBuildThis=yes

; Upgrade No. 3 for GDI radar
[GAPLUG3]
Name=Ion Cannon Uplink
Image=GAPLUG_F
Prerequisite=GAPLUG,GATECH
TechLevel=10
Armor=wood
Sight=1
Owner=GDI
Cost=500
Points=30
Power=-100
Crewed=no
Capturable=no
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
PowersUpBuilding=gaplug
PowersUpToLevel=-1
SuperWeapon=IonCannonSpecial
ThreatPosed=0	; This value MUST be 0 for all building addons
AIBuildThis=yes

; Firestorm defense
[GAFIRE]
Name=Fire Storm Generator
Strength=800
Armor=heavy
TechLevel=9
Prerequisite=GATECH
Adjacent=2
Sight=5
Owner=GDI
Cost=667
Points=30
Power=-200
Crewed=yes
Capturable=true
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=9
SuperWeapon=FirestormSpecial
DamageParticleSystems=SparkSys,SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=410, 600, 290

; Laser fence post
[NAPOST]
Name=Laser Fence Post
Prerequisite=NAAPWR
Strength=300
Armor=concrete
TechLevel=8
Adjacent=3
Sight=4
Owner=Nod
Cost=200
BaseNormal=no
Points=30
Power=-25
Crewed=no
Capturable=false
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
LaserFencePost=yes
MaxDebris=2
Powered=yes
ThreatPosed=0	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,LGSparkSys
IsBase=no
GuardRange=10  ; Used to set max. intra-post distance

[NAFNCE]
Name=Laser Fence Section
Strength=800
Armor=concrete
TechLevel=-1
Sight=1
Owner=Nod
Capturable=false
Cost=0
Points=00
Power=0
Selectable=no
Crewed=no
LaserFence=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
ThreatPosed=10	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,LGSparkSys
IsBase=no
LegalTarget=false
TogglePower=no

; Laser turret
[NALASR]
Name=Laser
Strength=500
Armor=wood
Prerequisite=NAHAND
TechLevel=2
Adjacent=4
ROT=10
Sight=7
Owner=Nod
Cost=100
BaseNormal=no
Points=30
Power=-40
Crewed=no
Capturable=false
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=2
Primary=LaserFire2
Turret=yes
TurretAnim=LASER
TurretAnimIsVoxel=true
TurretAnimX=-8
TurretAnimY=16
TurretAnimZAdjust=-40
ThreatPosed=30	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,LGSparkSys
IsBaseDefense=yes
HasStupidGuardMode=false

; SAM
[NASAM]
Name=Sam
Strength=600
Armor=wood
TechLevel=5
Prerequisite=NARADR
Adjacent=4
Sight=10
Owner=Nod
Cost=167
BaseNormal=no
Points=30
Power=-30
Crewed=no
Primary=RedEye2
Capturable=false
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=3
ThreatPosed=0	; This value should be 0 for objects that are purely anti-air, since aircraft do not use the threat values
DamageParticleSystems=SparkSys,LGSparkSys
IsBaseDefense=yes
Powered=yes
Turret=yes
TurretAnim=NASAM_A
TurretAnimIsVoxel=false
TurretAnimX=-2
TurretAnimY=10
TurretAnimZAdjust=-20
HasStupidGuardMode=false

[GAFSDF]
Name=Firestorm Wall Section
Strength=200
Armor=concrete
Prerequisite=GAFIRE
TechLevel=9
Repairable=false
Sight=2
Owner=GDI
Capturable=false
Cost=50
Points=00
Power=-2
Selectable=no
Crewed=no
FirestormWall=yes
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
ThreatPosed=20	; This value MUST be 0 for all building addons
DamageParticleSystems=SparkSys,LGSparkSys
IsBase=no
BaseNormal=no
TogglePower=no
Insignificant=yes

[ABAN01]
Name=WS Logging Company
TechLevel=-1
Strength=600
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=wood
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[ABAN02]
Name=Panullo Hacienda
TechLevel=-1
Strength=600
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[ABAN03]
Name=Abandoned Factory
TechLevel=-1
Strength=500
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=wood
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[ABAN04]
Name=City Hall
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[ABAN05]
Name=Hunting Lodge
TechLevel=-1
Strength=500
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=wood
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[ABAN06]
Name=Local Inn & Lodging
TechLevel=-1
Strength=500
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=wood
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[ABAN07]
Name=Church
TechLevel=-1
Strength=350
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[ABAN08]
Name=Abandoned Wharehouse
TechLevel=-1
Strength=500
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[ABAN09]
Name=Tall's Residence
TechLevel=-1
Strength=350
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[ABAN10]
Name=Denzil's Last Chance Motel
TechLevel=-1
Strength=500
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=wood
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[ABAN11]
Name=Miele Manor
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=wood
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[ABAN12]
Name=Kettler's Place
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=wood
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[ABAN13]
Name=Long's Home
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=wood
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[ABAN14]
Name=Local Store
TechLevel=-1
Strength=300
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[ABAN15]
Name=Adam's House
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[ABAN16]
Name=Gas Station
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=wood
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=2
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[ABAN17]
Name=Gas Pumps
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=wood
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=2
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[ABAN18]
Name=Gas Station Sign
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=wood
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=2
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CA0001]
Name=Rade's Roadhouse
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CA0002]
Name=Sandberg and Son's
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CA0003]
Name=Temp Housing
TechLevel=-1
Strength=300
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=light
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CA0004]
Name=Waystation
TechLevel=-1
Strength=300
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=light
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CA0005]
Name=Ferbie's 4 Sale
TechLevel=-1
Strength=300
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=light
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CA0006]
Name=Deluxe Accomodations
TechLevel=-1
Strength=300
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CA0007]
Name=Field Generator
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=light
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CA0008]
Name=Subterranean Dwelling
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CA0009]
Name=Subterranean Dwelling
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CA0010]
Name=Leary Traveller Inn
TechLevel=-1
Strength=300
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CA0011]
Name=Water Tank
TechLevel=-1
Strength=200
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CA0012]
Name=Greenhouse
TechLevel=-1
Strength=100
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=light
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CA0013]
Name=Water Purifier
TechLevel=-1
Strength=300
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CA0014]
Name=Observation Tower
TechLevel=-1
Strength=300
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CA0015]
Name=Port-A-Shack
TechLevel=-1
Strength=300
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=light
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CA0016]
Name=Port-A-Shack Deluxe
TechLevel=-1
Strength=300
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=light
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CA0017]
Name=Energy Transformer
TechLevel=-1
Strength=300
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CA0018]
Name=Solar Panel
TechLevel=-1
Strength=200
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=light
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CA0019]
Name=Solar Panel
TechLevel=-1
Strength=200
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=light
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CA0020]
Name=Solar Panel
TechLevel=-1
Strength=200
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=light
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CA0021]
Name=Solar Panel
TechLevel=-1
Strength=200
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=light
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[GAOLDCC1]
Name=Old Construction Yard
TechLevel=-1
Strength=400
Insignificant=yes
Capturable=false
Repairable=false
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=3
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[GAOLDCC2]
Name=Old Temple
TechLevel=-1
Strength=400
Insignificant=yes
Capturable=false
Repairable=false
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=3
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[GAOLDCC3]
Name=Old Weapons Factory
TechLevel=-1
Strength=400
Capturable=false
Repairable=false
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=3
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[GAOLDCC4]
Name=Old Refinery
TechLevel=-1
Strength=400
Capturable=false
Repairable=false
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=3
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[GAOLDCC5]
Name=Old Advanced Power Plant
TechLevel=-1
Strength=400
Capturable=false
Repairable=false
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=3
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[GAOLDCC6]
Name=Old Silos
TechLevel=-1
Strength=400
Capturable=false
Repairable=false
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=3
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

; Use Ammo to specify the number of times to allow healing.
[CAHOSP]
Name=Civilian Hospital
TechLevel=-1
Strength=800
LegalTarget=no
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=concrete
Hospital=yes
PipScale=Ammo
Ammo=5
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=3
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

; Use Ammo to specify number of time the building can be used to upgrade infantry
[CAARMR]
Name=Civilian Armory
TechLevel=-1
Strength=800
Immune=no
LegalTarget=no
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=concrete
Armory=yes
PipScale=Ammo
Ammo=5
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=3
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CAPYR01]
Name=Pyramid
TechLevel=-1
Strength=400
Immune=yes
LegalTarget=no
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=concrete
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
IsBase=no

[CAPYR02]
Name=Pyramid
TechLevel=-1
Strength=400
Immune=yes
LegalTarget=no
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=concrete
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
IsBase=no

[CAPYR03]
Name=Pyramid
TechLevel=-1
Strength=400
Immune=yes
LegalTarget=no
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=concrete
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
IsBase=no

[CACRSH01]
Name=Crash 1
TechLevel=-1
Strength=400
Immune=yes
LegalTarget=no
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=concrete
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
Selectable=no
IsBase=no

[CACRSH02]
Name=Crash 2
TechLevel=-1
Strength=400
Immune=yes
LegalTarget=no
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=concrete
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
Selectable=no
IsBase=no

[CACRSH03]
Name=Crash 3
TechLevel=-1
Strength=400
Immune=yes
LegalTarget=no
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=concrete
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
Selectable=no
IsBase=no

[CACRSH04]
Name=Crash 4
TechLevel=-1
Strength=400
Immune=yes
LegalTarget=no
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=concrete
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
Selectable=no
IsBase=no

[CACRSH05]
Name=Crash 5
TechLevel=-1
Strength=400
Immune=yes
LegalTarget=no
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=concrete
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
Selectable=no
IsBase=no

[CAARAY]
Name=Civilian Array
TechLevel=-1
Strength=400
LegalTarget=yes
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=concrete
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=3
IsBase=no

[GASPOT]
Name=Light Tower
TechLevel=-1
Strength=400
Points=50
Power=-10
Armor=wood
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
HasSpotlight=true
MaxDebris=2
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
DamageSmokeOffset=450, 500, 710
IsBase=no

[CITY01]
Name=Connelly Court Apts.
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=wood
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CITY02]
Name=Lightner's Luxury Suites
TechLevel=-1
Strength=700
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CITY03]
Name=Office Building
TechLevel=-1
Strength=500
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CITY04]
Name=Westwood Stock Exchange
TechLevel=-1
Strength=600
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CITY05]
Name=Daily Sun Times
TechLevel=-1
Strength=600
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CITY06]
Name=YEO-CA Cola Corp.
TechLevel=-1
Strength=500
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=concrete
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CITY07]
Name=Urban Housing
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=wood
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CITY08]
Name=Yee's Discount Liquor
TechLevel=-1
Strength=300
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CITY09]
Name=Abandoned Warehouse
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=wood
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CITY10]
Name=Urban Storefront
TechLevel=-1
Strength=300
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CITY11]
Name=Ambrose Lounge
TechLevel=-1
Strength=500
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CITY12]
Name=Bostic Tower
TechLevel=-1
Strength=600
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=concrete
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CITY13]
Name=Hewitt Hair Salon
TechLevel=-1
Strength=500
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=wood
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CITY14]
Name=Business Offices
TechLevel=-1
Strength=600
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CITY15]
Name=2nd National Bank
TechLevel=-1
Strength=500
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CITY16]
Name=Highrise Hotel
TechLevel=-1
Strength=500
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=wood
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CITY17]
Name=The Projects
TechLevel=-1
Strength=300
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=wood
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CITY18]
Name=Archer Asylum
TechLevel=-1
Strength=600
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=concrete
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CITY19]
Name=Fill'er Up-Pump'N'Go
TechLevel=-1
Strength=500
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=wood
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CITY20]
Name=Gas Pump
TechLevel=-1
Strength=250
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=wood
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=6
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CITY21]
Name=Gas Station Sign
TechLevel=-1
Strength=100
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=none
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CITY22]
Name=Church
TechLevel=-1
Strength=100
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=none
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[CTVEGA]
Name=Vega's Pyramid
TechLevel=-1
Strength=100
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=none
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
DamageParticleSystems=SmallGreySSys,BigGreySmokeSys
IsBase=no

[BBOARD01]
Name=Eat at Rade's Roadhouse
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
Selectable=no
IsBase=no

[BBOARD02]
Name=Drink YEO-CA Cola!
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
Selectable=no
IsBase=no

[BBOARD03]
Name=Hamburgers $.99
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
Selectable=no
IsBase=no

[BBOARD04]
Name=Visit Scenic Las Vegas
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
Selectable=no
IsBase=no

[BBOARD05]
Name=Rooms $29 a nite
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
Selectable=no
IsBase=no

[BBOARD06]
Name=Kaspm's Tiberium Warhouse
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
Selectable=no
IsBase=no

[BBOARD07]
Name=Alkaline's Battery Superstore
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
Selectable=no
IsBase=no

[BBOARD08]
Name=Alex-gators petshop just ahead!
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
Selectable=no
IsBase=no

[BBOARD09]
Name=TacticX games rock!
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
Selectable=no
IsBase=no

[BBOARD10]
Name=WW Surf and Turf hits the spot!
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
Selectable=no
IsBase=no

[BBOARD11]
Name=Only 11 miles to Zydeko's cafe!
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
Selectable=no
IsBase=no

[BBOARD12]
Name=No escape from Archer's Asylum!
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
Selectable=no
IsBase=no

[BBOARD13]
Name=Stop in at Hewitt's hair salon
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
Selectable=no
IsBase=no

[BBOARD14]
Name=Billy Bob's Harvester school
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
Selectable=no
IsBase=no

[BBOARD15]
Name=Pannullo's hacienda es bueno
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
Selectable=no
IsBase=no

[BBOARD16]
Name=Join GDI: We save lives.
TechLevel=-1
Strength=400
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=0
Selectable=no
IsBase=no

[CTDAM]
Name=Dam
TechLevel=1
Strength=1000
Power=200
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
PlaceAnywhere=yes
;DamageParticleSystems=SparkSys,LGSparkSys WST 7/16 commented out cuz it looked like bad palette
DamageSmokeOffset=500, 100, 500
IsBase=no

[UFO]
Name=Scrin Ship
TechLevel=1
Strength=1000
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=heavy
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=8
PlaceAnywhere=yes
IsBase=no

[AMMOCRAT]
Name=Ammo Crates
Image=AMMO01
Selectable=no
Explodes=yes
TechLevel=-1
Strength=1
Insignificant=yes
Nominal=yes
RadarInvisible=yes
Points=5
Armor=none
Explosion=TWLT070,S_BANG48,S_BRNL58,S_CLSN58,S_TUMU60
MaxDebris=4
PlaceAnywhere=yes
IsBase=no
ThreatPosed=10
SpecialThreatValue=1

; ******* Weapon Statistics *******
; The weapons specified here are attached to the various combat
; units and buildings.

; Anim = animation to display as a firing effect [use 8 for directional variation]
; Burst = number of rapid succession shots from this weapon (def=1)
; Camera = Reveals area around firer (def=no)?
; Charges = Does it have charge-up-before-firing logic (def=no)?
; Damage = the amount of damage (unattenuated) dealt with every bullet
; Floater = floats like a frizbee
; Lobber = does the projectile fly to target in a high arc (def=no)?
; Projectile = projectile characteristic to use
; ROF = delay between shots [15 = 1 second at middle speed setting]
; Range = maximum cell range
; MinimumRange = minimum range to target (def=0)
; Report = List of sounds to random play when firing
; Speed = speed of projectile to target (100 is maximum)
; Warhead = warhead to attach to projectile
; Supress = Should nearby friendly buildings be scanned for and if found, discourage firing on target (def=no)?
; TurboBoost = Should the weapon get a boosted speed bonus when firing upon aircraft?
; UseFireParticles = Should the weapon spawn a flame particle system? (def = no)
; Bright = Does this weapons bullet cause a lighting effect when it impacts (def=no)? If set, this will override the warheads 'Bright' flag.
; IonSensitive = Shuts down during an ion storm (def=no)?

;Light infantry Rifle
[Minigun]
Damage=8
ROF=21
Range=4
Projectile=Invisible
Speed=100
Warhead=SA
Report=INFGUN3,GOSTGUN1,SLVKGUN1

;Rocket Infantry
[BAZOOKA]
Damage=25
ROF=60
Range=6
Projectile=AAHeatSeeker2
Speed=25
Warhead=AP
Report=RKETINF1

;Jump Jet Cannon
[JumpCannon]
Damage=15 ; was 20
Burst=2
ROF=40
Range=5  ; was 4
Projectile=Invisible3
Speed=100
Warhead=SA
Report=JUMPJET1
;Anim=MGUN-N,MGUN-NE,MGUN-E,MGUN-SE,MGUN-S,MGUN-SW,MGUN-W,MGUN-NW

;Assault Suit Cannon
[AssaultCannon]
Damage=40
ROF=50
Range=5
Projectile=Invisible
Speed=100
Warhead=SA
Report=TSGUN4

;Cyborg Commando Plasma Cannon
[CyCannon]
Damage=120
ROF=50
Range=7
Projectile=ProtonBlast
Speed=70
Warhead=PlasmaWH
Report=scrin5b

;Harpy Vulcan Cannon
[HarpyClaw]
Damage=60
ROF=36
Range=5
Projectile=Invisible2
Speed=100
Warhead=SA
Report=CYGUN1

;Assault Buggy Cannon
[RaiderCannon]
Damage=40
ROF=55
Range=4
Projectile=Invisible
Speed=100
Warhead=SA
Report=CHAINGN1
Anim=MGUN-N,MGUN-NE,MGUN-E,MGUN-SE,MGUN-S,MGUN-SW,MGUN-W,MGUN-NW

;Vulcan Tower Cannon
[VulcanTower]
Damage=18
ROF=26
Range=6
Projectile=Invisible
Speed=100
Warhead=SA
Report=CHAINGN1
Anim=MGUN-N,MGUN-NE,MGUN-E,MGUN-SE,MGUN-S,MGUN-SW,MGUN-W,MGUN-NW
Bright=true

;Rocket Tower Grenade
[RPGTower]
Damage=110
ROF=80
Range=8
Projectile=Lobbed2
Speed=30 ; 5
Warhead=RPG
MinimumRange=2
Report=GLNCH4

;Bike Missile
[BikeMissile]
Damage=40
ROF=60
Range=5
Projectile=HeatSeeker
Speed=30
Report=MISL1
Warhead=AP

;SAM missile
[RedEye2]
Damage=33
ROF=55
Range=15
Projectile=AAHeatSeeker
Speed=30
Warhead=SAMWH
Report=SAMSHOT1
TurboBoost=yes

;Hover Missile
[HoverMissile]
Damage=30
ROF=68
Range=8
Burst=2
Projectile=AAHeatSeeker2
Speed=30
Warhead=AP
Report=HOVRMIS1
MinimumRange=2

;Ghost's Rail Gun
[LtRail]
Damage=0			; this should be 0 for railgun shots
AmbientDamage=150	; use this for the railgun damage field.  Leave damage = 0
ROF=60		; ROF for railgun is tied to the duration (MaxEC) of the railgun particle
Range=6
Projectile=Invisible
Speed=100
Warhead=RailShot2
Anim=GUNFIRE
IsRailgun=true
AttachedParticleSystem=SmallRailgunSys
Report=BIGGGUN1

;Mammoth Rail Gun
[MechRailgun]
AmbientDamage=200	; use this for the railgun damage field.  Leave damage = 0
Damage=0			; this should be 0 for railgun shots
ROF=60		; ROF for railgun is tied to the duration (MaxEC) of the railgun particle
Range=8
Projectile=Invisible
Speed=100
Warhead=RailShot
Report=RAILUSE5
Anim=GUNFIRE
IsRailgun=true
AttachedParticleSystem=LargeRailgunSys

; rapid fire machine gun
[Vulcan]
Damage=20
ROF=60
Range=4
Projectile=Invisible
Speed=100
Warhead=SA
Report=CHAINGN1
Anim=MGUN-N,MGUN-NE,MGUN-E,MGUN-SE,MGUN-S,MGUN-SW,MGUN-W,MGUN-NW

;Cyborg's Vulcan cannon
[Vulcan3]
Damage=10
ROF=30
Burst=3
Range=4
Projectile=Invisible
Speed=100
Warhead=SA
Report=CYGUN1
;Anim=MGUN-N,MGUN-NE,MGUN-E,MGUN-SE,MGUN-S,MGUN-SW,MGUN-W,MGUN-NW

; fireball from flame tank
[FireballLauncher]
Damage=0
AmbientDamage=2
ROF=50
Range=4.25
Projectile=Invisible
Speed=1
Warhead=Fire
Report=FLAMTNK1
UseFireParticles=yes
AttachedParticleSystem=FireStreamSys
Burst=2

; sniper rifle
[Sniper]
Damage=150
ROF=60
Range=6.75
Projectile=Invisible
Speed=100
Warhead=HollowPoint
Report=SILENCER

; rifle soldier weapons (multiple shots)
[M1Carbine]
Damage=15
ROF=20
Range=4
Projectile=Invisible
Speed=100
Warhead=SA
Report=INFGUN3

; man-packed anti-tank missile (bazooka type)
[Dragon]
Damage=30
ROF=50
Burst=2
Range=6
Projectile=AAHeatSeeker2
Speed=25
Warhead=AP
Report=MISL1

; air-to-surface homing missile (launched from helicopter)
[Hellfire]
Damage=30 ; 25
ROF=50
Range=6
Projectile=AAHeatSeeker2 ; was HeatSeeker
Speed=30
Warhead=ORCAAP
Report=ORCAMIS1
Burst=2

[Proton]
Damage=20
ROF=3
Range=5
Projectile=ProtonTorpedo
Speed=30
Warhead=AP
Report=scrin5b

; hand grenade (discus)
[Grenade]
Damage=40
ROF=60
Range=4.5
Projectile=Lobbed
;Floater=yes
Speed=5
Warhead=HE
;Lobber=yes
Bright=yes

; small anti-armor cannon
[75mm]
Damage=35
ROF=40
Range=6
Projectile=Cannon
Speed=40
Warhead=AP
Anim=GUNFIRE
Bright=yes

; light anti-armor cannon
[90mm]
Damage=36
ROF=50
Range=6.75
Projectile=Cannon
Speed=40
Warhead=AP
Report=120MMF
Anim=GUNFIRE
Bright=yes

; large anti-armor cannon (two shooter)
[120mmx]
Damage=50
ROF=80
Range=6.75
Projectile=Cannon
Speed=40
Warhead=AP
Report=120MMX9
Anim=GUNFIRE
Burst=2
Bright=yes

; large anti-armor cannon (single shooter)
[120mm]
Damage=70
ROF=80
Range=6.75
Projectile=Invisible
Speed=90
Warhead=AP
Report=120MMF
Anim=GUNFIRE
Bright=yes

[Bomb]
Damage=160
ROF=10  ; was 1
Range=5
Projectile=Cannon2
Speed=0
Warhead=ORCAHE
Floater=yes

[SuicideBomb]
Damage=11000
ROF=1
Range=.5
Projectile=Invisible
Speed=0
Warhead=SUPER
Bright=yes
Report=HUNTER2

; Vehicle carried anti-tank missile
[MammothTusk]
Damage=40
ROF=80
Range=6
Projectile=AAHeatSeeker
Speed=20
Warhead=HE
Burst=2
Report=MISL1

; artillery cannon
[155mm]
Damage=150
ROF=110
Range=18
MinimumRange=5
Projectile=Ballistic
Speed=10
Warhead=ARTYHE
Report=120MMF
Anim=GUNFIRE
Lobber=yes

; Sonic Zap
[SonicZap]
Damage=1
AmbientDamage=3
ROF=120
Range=6
Projectile=Null
Speed=100
Warhead=SonicWarhead
Report=SONIC4
IsSonic=Yes

; repair bot repairing
[RepairBullet]
Damage=-50
ROF=80
Range=1.8
Projectile=Invisible
Speed=100
Warhead=Mechanical
Report=REPAIR11
UseSparkParticles=yes
AttachedParticleSystem=WeldingSys

; medic healing
[Heal]
Damage=-50
ROF=80
Range=2.83
Projectile=Invisible
Speed=100
Warhead=Organic
Report=HEALER1

; rapid fire machine gun
[Vulcan2]
Damage=50
ROF=50
Range=6
Projectile=Invisible
Speed=100
Warhead=SA
Report=TSGUN4
Anim=GUNFIRE

; Solid laser beam.
[LaserFire]
Damage=250
ROF=120
Range=10.5
Speed=100
Warhead=Super
Report=OBELRAY1
LaserInnerColor = 255,0,0
LaserOuterColor = 0,0,0
LaserOuterSpread= 20,40,40
LaserDuration = 15
Projectile=LLine
IsBigLaser=true
IsLaser=true	; this flag tells the game to use the special laser draw effect
Charges=yes		; non-charging lasers should use LaserFire2 instead

; Laser Turret Beam
[LaserFire2]
Damage=30
ROF=40
Range=5.5
Speed=100
Warhead=Super
Report=LASTUR1
Charges=no
LaserInnerColor = 255,0,0
LaserOuterColor = 0,0,0
LaserOuterSpread= 20,40,40
LaserDuration = 15
Projectile=LLine2
IsLaser=true	; this flag tells the game to use the special laser draw effect

[EMPulseWeapon]
Damage=1200       ; Damage is duration for EM Pulse
ROF=1
Speed=25
Warhead=EMPuls
Projectile=PulsPr
Range=40 ; was 30
Lobber=yes
Report=PLSECAN2

; Visceroid attack
[SlimeAttack]
Damage=100
ROF=80
Range=1.3		;2.83
Projectile=Invisible
Speed=25	;100
Warhead=Slimer
Report=VICER1

; Chemical missile launcher
[ChemLauncher]
Damage=100
ROF=1 ; 0
Range=6
Projectile=ChemMissile
Speed=30
Warhead=Gas
Report=ICBM1

[FiendShard]
Damage=35
ROF=30
Burst=3
Range=5
Projectile=DogShard
Speed=25
Warhead=Shard
Report=FIEND2

[MultiLauncher]
Damage=130
ROF=80
Range=30
Projectile=MultiMissile
Speed=35  ; was 10
Warhead=HE
Report=SAMSHOT1

[Pistola]
Damage=2
ROF=20
Range=3
Projectile=Invisible
Speed=100
Warhead=SA
Report=GUN18

; MultiMissile Cluster Missiles
[MultiCluster]
Damage=65
ROF=80
Range=6
Projectile=HeatSeeker
Speed=20
Warhead=HE
Burst=2
Report=MISL1

; ******* Projectile Statistics *******
; Projectiles describe how and what image to use as the weapon flies
; to its target. Think of the projectile as the "delivery method" used
; to get the warhead to the desired target.

; AA = Can this weapon fire upon flying aircraft (def=no)?
; AG = Can this weapon fire upon ground objects (def=yes)?
; ASW = Is this an Anti-Submarine-Warfare projectile (def=no)?
; Acceleration = amount to increase missile speed (def=3)
; Airburst = Does it try to fly over the target instead of hit it (def=no)?
; Arm = arming delay (def=0)
; Bouncy = Does it bounce a bit upon impact (def=no)?
; Degenerates = Does the bullet strength weaken as it travels (def=no)?
; Dropping = Does it fall from a starting height (def=no)?
; Elasticity = "bounciness" of the object [should be 0.0 through 1.0] (def=0.75)
; High = Can it fly over walls (def=no)?
; Image = image to use during flight
; Inaccurate = Is it inherently inaccurate (def=no)?
; Inviso = Is the projectile invisible as it travels (def=no)?
; Parachuted = Equipped with a parachute for dropping from plane (def=no)?
; Proximity = Does it blow up when near its target (def=no)?
; ROT = Rate Of Turn [non zero implies homing] (def=0)
; Ranged = Can it run out of fuel (def=no)?
; Shadow = If High, does this bullet need to have a shadow drawn? (def = yes)
; Color = Color scheme to use for special remapping projectiles (def = none)
; VeryHigh = Does it fly at a very high cruise altitude (def=no)?
; Cluster = number of explosions attached to projectile [cluster-bomb] (def=1)

; invisible flight to target
[Invisible]
Inviso=yes
Image=none

; Harpy Claw tracking projectile
[Invisible2]
Inviso=yes
Image=none
ROT=3
AA=yes
AG=yes

; Jump jet cannon
[Invisible3]
Inviso=yes
Image=none
AA=yes
AG=yes

[Null]
Inviso=yes
Arm=9999999
Image=none

; straight high-speed ballistic shot
[Cannon]
Image=120MM
Arcing=true

; orca bomber bomblets
[Cannon2]
Image=120MM
AA=no

; chemical missile
[ChemMissile]
Arm=2
High=yes
VeryHigh=yes
Cluster=8
;Shadow=no
Proximity=yes
Ranged=yes
AA=no
Image=MISLCHEM
ROT=4
Color=DarkGreen
IgnoresFirestorm=yes

[MultiMissile]
Arm=2
High=yes
VeryHigh=yes
;Shadow=no
Proximity=yes
Cluster=10          ; number of small missiles to launch
Ranged=yes
AA=no
Image=MISLMLTI
ROT=4
Color=DarkGreen
Airburst=yes
AirburstWeapon=MultiCluster
IgnoresFirestorm=yes

; small homing missile (targets vehicles best)
[HeatSeeker]
Arm=2
High=yes
Shadow=no
Proximity=yes
Ranged=yes
Image=DRAGON
ROT=8

[ProtonTorpedo]
Arm=2
High=yes
Shadow=no
Proximity=yes
Ranged=yes
Image=TORPEDO
ROT=1
IgnoresFirestorm=yes

[ProtonBlast]
High=yes
Shadow=no
Proximity=yes
Ranged=yes
Image=TORPEDO
ROT=1
IgnoresFirestorm=yes

; aircraft-only heatseeker
[AAHeatSeeker]
Arm=2
High=yes
Shadow=no
Proximity=yes
Ranged=yes
AA=yes
AG=no
Image=DRAGON
ROT=5

; aircraft and ground heatseeker
[AAHeatSeeker2]
Arm=2
High=yes
Shadow=no
Proximity=yes
Ranged=yes
AA=yes
AG=yes
Image=DRAGON
ROT=8

[Lobbed]
High=yes
Image=DISCUS
Bouncy=yes
Arcing=yes
Floater=yes

[Lobbed2]
High=yes
Image=CANISTER
Arcing=true

; arcing ballistic projectile
[Ballistic]
High=yes
Image=120MM
Arcing=true

[PulsPr]
High=yes
Image=PULSBALL

[LLine]
Inviso=yes
Image=none
AA=no
AG=yes

[LLine2]
Inviso=yes
Image=none
AA=no
AG=yes

[DogShard]
Image=CRYSTAL4
Arcing=true


; *** Particle Systems ***
;
; HoldsWhat = type of particle (see below) that this system manages (required)
; Spawns = does this system spawn particles by itself (def = no)
; SpawnFrames = number of frames to wait before spawning another particle
; ParticleCap = maximum number of particles that can be in this system

[SmallRailgunSys]
HoldsWhat=SmallRailgunPart
BehavesLike=Railgun
SpiralRadius=6
ParticlesPerCoord=.1
SpiralDeltaPerCoord=.035
MovementPerturbationCoefficient=.3
PositionPerturbationCoefficient=20
VelocityPerturbationCoefficient=.6
Laser=yes
LaserColor=255,128,0

[LargeRailgunSys]
HoldsWhat=LargeRailgunPart
BehavesLike=Railgun
SpiralRadius=15
ParticlesPerCoord=.15
SpiralDeltaPerCoord=.03
MovementPerturbationCoefficient=.4
PositionPerturbationCoefficient=30
VelocityPerturbationCoefficient=.6
Laser=yes
LaserColor=25,20,255
;R,G,B for laser color

[WeldingSys]
HoldsWhat=WeldingSpark
BehavesLike=Spark
ParticleCap=25
SparkSpawnFrames=20
LightSize=25
OneFrameLight=true
SpawnSparkPercentage=.4

[SparkSys]
HoldsWhat=Spark
BehavesLike=Spark
ParticleCap=12
SparkSpawnFrames=1
LightSize=21
SpawnSparkPercentage=1

[FirestormSparkSys]
HoldsWhat=FirestormSpark
BehavesLike=Spark
ParticleCap=25
SparkSpawnFrames=1
LightSize=21
SpawnSparkPercentage=1

; this is the global gas system
[GasCloudSys]
HoldsWhat=GasCloud1
BehavesLike=Gas

; a system for large amounts of smoke (damaged buildings, destroyed things)
[BigGreySmokeSys]
HoldsWhat=LargeGreySmoke
Spawns=yes
SpawnFrames=10
SpawnRadius=10
Slowdown=.0025
ParticleCap=30
SpawnCutoff=15.0
SpawnTranslucencyCutoff=13.0
BehavesLike=Smoke

; a system for small amounts of smoke (damaged units)
[SmallGreySSys]
HoldsWhat=SmallGreySmoke
Spawns=yes
SpawnFrames=5
SpawnRadius=5
Slowdown=.0025
ParticleCap=15
SpawnCutoff=13.0
SpawnTranslucencyCutoff=12.5
BehavesLike=Smoke

; a system for small amounts of smoke (damaged units)
[TestSmokeSys]
HoldsWhat=TestSmoke
Spawns=yes
SpawnFrames=10
SpawnRadius=5
Slowdown=.0025
ParticleCap=15
SpawnCutoff=13.0
SpawnTranslucencyCutoff=12.5
BehavesLike=Smoke

[DebrisSmokeSys]
HoldsWhat=SmallGreySmoke
Spawns=yes
SpawnFrames=2
SpawnRadius=3
ParticleCap=15
SpawnCutoff=13.0
SpawnTranslucencyCutoff=13.0
BehavesLike=Smoke

[FireStreamSys]
HoldsWhat=FireStream
Spawns=yes
SpawnFrames=4
BehavesLike=Fire
Image=TWLT036
Lifetime=30 ; was 100

[LGSparkSys]
HoldsWhat=LargeSpark
BehavesLike=Spark
ParticleCap=15
SparkSpawnFrames=5
LightSize=25
OneFrameLight=true
SpawnSparkPercentage=.2

; *** Particles ***
;
; Image = Imagelist to use for particle
; Persistent = Does this particle stick around; should always be yes
; MaxDC = How many frames go by before this particle damages the things near it? (def = 0)
; MaxEC = How many frames does this object last (def = 0)
; Damage = How much damage does it do (def = 0)
; Warhead = What warhead to use for damage purposes (def = WARHEAD_NONE)
; StartFrame = what frame of image to start on? (def = 0)
; NumLoopFrames = how many frames form a single loop? (def = 1)
; WindEffect = to what degree does the wind affect his particle, 0 = not at all, 5 = a lot (def = 0)
; Velocity = speed at which particle travels (def = 0.0)
; Radius = how big is this particle? (used for attract/repel)
;
; BehavesLike, DeleteOnStateLimit, EndStateAI, StateAIAdvance are things that
; shouldn't be messed with

; the particle that makes up the fire stream of flamethrowers, and flame tanks
[FireStream]
Image=FLAMEALL
Deacc=0.01
Velocity=28.0
BehavesLike=Fire
MaxEC=500
MaxDC=3
Warhead=Fire
Damage=2
StartStateAI=1
EndStateAI=19
StateAIAdvance=6
Translucent50State=15
Translucent25State=10
DeleteOnStateLimit=yes
Normalized=yes
FinalDamageState=14
Report=FLAMTNK1

[WeldingSpark]
BehavesLike=Spark
MaxEC=500
XVelocity=16
YVelocity=16
MinZVelocity=40
ZVelocityRange=15
ColorList=(0,128,255),(255,255,255),(200,200,150),(80,80,80),(0,0,0)
StartColor1=80,255,255
StartColor2=255,255,100
ColorSpeed=.13

[Spark]
BehavesLike=Spark
MaxEC=500
XVelocity=10
YVelocity=10
MinZVelocity=40
ZVelocityRange=15
ColorList=(255,255,255),(200,200,80),(200,10,10),(0,0,0)
ColorSpeed=.13

[FirestormSpark]
BehavesLike=Spark
MaxEC=500
XVelocity=16
YVelocity=16
MinZVelocity=40
ZVelocityRange=15
ColorList=(0,0,255),(255,255,255),(200,200,80),(200,10,10),(0,0,0)
ColorSpeed=.13

; Cloud of Poison Gas #1 Formation particle
[GasCloudM1]
Image=gaslrgmk
MaxDC=60
MaxEC=448
Damage=0
Warhead=Gas
StartFrame=0
EndStateAI=11
Translucency=50
WindEffect=0
BehavesLike=Gas
StateAIAdvance=3
NextParticle=GasCloud1
DeleteOnStateLimit=yes
NextParticleOffset=0,0,150

; Cloud of Poison Gas #2 formation particle
[GasCloudM2]
Image=gaslrgmk
MaxDC=60
MaxEC=448
Damage=0
Warhead=Gas
StartFrame=0
EndStateAI=11
Translucency=50
WindEffect=0
BehavesLike=Gas
StateAIAdvance=3
NextParticle=GasCloud2
DeleteOnStateLimit=yes
NextParticleOffset=0,0,150

; Cloud of Poison Gas #1
[GasCloud1]
Image=CLOUD1
MaxDC=60
MaxEC=1000
Damage=50
Warhead=Gas
StartFrame=0
EndStateAI=28
Translucency=50
WindEffect=0
BehavesLike=Gas
StateAIAdvance=4
NextParticle=GasCloudD1

; Cloud of Poison Gas #2
[GasCloud2]
Image=CLOUD2
MaxDC=60
MaxEC=1000
Damage=40
Warhead=Gas
StartFrame=0
EndStateAI=28
Translucency=50
WindEffect=0
BehavesLike=Gas
StateAIAdvance=4
NextParticle=GasCloudD2

; Cloud of Poison Gas #1 Dissipation particle
[GasCloudD1]
Image=CLOUD1D
MaxDC=60
MaxEC=50
Damage=10
Warhead=Gas
StartFrame=0
EndStateAI=12
Translucency=50
WindEffect=0
BehavesLike=Gas
StateAIAdvance=4
DeleteOnStateLimit=yes

; Cloud of Poison Gas #2 dissipating
[GasCloudD2]
Image=CLOUD2D
MaxDC=60
MaxEC=50
Damage=10
Warhead=Gas
StartFrame=0
EndStateAI=12
Translucency=50
WindEffect=0
BehavesLike=Gas
StateAIAdvance=4
DeleteOnStateLimit=yes


[LargeGreySmoke]
Image=LGRYSMK1
MaxEC=80
Translucency=25
Velocity=8.0
Deacc=.05
WindEffect=0
BehavesLike=Smoke
DeleteOnStateLimit=yes
EndStateAI=20
StateAIAdvance=4

[SmallGreySmoke]
Image=SGRYSMK1
MaxEC=80
Translucency=25
Velocity=9.0
Deacc=.05
WindEffect=0
BehavesLike=Smoke
DeleteOnStateLimit=yes
EndStateAI=20
StateAIAdvance=4

[TestSmoke]
Image=SGRYSMK1
MaxEC=80
Translucency=25
Velocity=6.0
Deacc=.05
WindEffect=0
BehavesLike=Smoke
DeleteOnStateLimit=yes
EndStateAI=20
StateAIAdvance=3

[SmallRailgunPart]
BehavesLike=Railgun
MaxEC=70
ColorList=(200,200,200),(150,150,150)
ColorSpeed=.03
Velocity=.4

[LargeRailgunPart]
BehavesLike=Railgun
MaxEC=70
ColorList=(25,70,205),(150,150,150)
ColorSpeed=.009
Velocity=.3

[LargeSpark]
BehavesLike=Spark
MaxEC=500
XVelocity=13
YVelocity=13
MinZVelocity=40
ZVelocityRange=15
ColorList=(255,255,255),(200,200,80),(200,10,10),(0,0,0)
ColorSpeed=.13

; ******* Warhead Characteristics *******
; This is what gives the "rock, paper, scissors" character to the game.
; It describes how the damage is to be applied to the target. The
; values should take into consideration the 'area of effect'.
; example: Although an armor piercing tank round would instantly
; kill a soldier IF it hit, the anti-infantry rating is still
; very low because the tank round has such a limited area of
; effect, lacks pinpoint accuracy, and acknowledges the fact that
; tanks pose little threat to infantry that take cover.

; Spread = damage spread factor [larger means greater spread] (def=1)
;          [A value of 1 means the damage is halved every pixel distant from center point.
;          a value of 2 means damage is halved every 2 pixels, etc.]
; Wall = Does this warhead damage concrete walls (def=no)?
; Wood = Does this warhead damage wood walls (def=no)?
; Fire = Does this produce great heat and thus will melt ice (def=no)?
; Tiberium = Does this warhead destroy tiberium (def=no)?
; Sparky = Does this warhead cause residual flames (def=no)?
; Conventional = Is explosive warhead big enough to cause a splash when it hits water [nukes are too big for this] (def=no)?
; Rocker = Can this warhead cause nearby units to rock upon impact (def=no)?
; AnimList = list of animations to play when warhead explodes [listed from lesser to greater damage]
; Verses = damage value verses various armor types (as percentage of full damage)...
;           -vs- none, wood (buildings), light armor, heavy armor, concrete
; InfDeath = which infantry death animation to use (def=0)
;             0=instant die, 1=twirl die, 2=explodes, 3=flying death, 4=burn death, 5=electro
; Deform = % chance that this warhead will damage the ground when it hits. (def=0)
; DeformThreshhold = damage must exceed this amount before deformation can occur (def=0)
; Particle = Particle effect to use when explosion occurs (def=none)
; ProneDamage = Damage modifer for infantry when prone (def=1.0)
; Bright = Does this warhead normally cause a lighting effect when it goes off (def=no). This is overridden in the case of bullets by the weapon 'Bright' flag.

; EM Pulse cannon warhead.
[EMPuls]
Spread=11       ; Spread is radius of EM pulse effect.
EMEffect=yes
AnimList=PULSEFX1,PULSEFX2

; warhead for the sonic zap
[SonicWarhead]
Spread=2
Wood=yes
Verses=100%,100%,100%,80%,60%  ; was 65, 50
InfDeath=3
Rocker=yes
ProneDamage=50%

; warhead for the flying tank of gas
[TankOGas]
Spread=8
Wall=yes
Wood=yes
Tiberium=yes
Sparky=yes
Rocker=no
AnimList=TWLT026,TWLT036,TWLT050,TWLT070,TWLT100
Verses=90%,100%,60%,25%,10%
Fire=yes
InfDeath=4
ProneDamage=50%

[RailShot]
Spread=1
Verses=200%,175%,160%,100%,25%
Rocker=no
ProneDamage=100%
InfDeath=2

; Ghost's Railgun
[RailShot2]
Spread=1
Verses=100%,130%,150%,110%,5%
Rocker=no
ProneDamage=100%
InfDeath=2

; general multiple small arms fire
[SA]
Spread=3
Verses=100%,60%,40%,25%,10%
InfDeath=1
AnimList=PIFFPIFF,PIFFPIFF
Bright=yes
ProneDamage=70%

; high explosive (shrapnel)
[HE]
Spread=4
Wall=yes
Wood=yes
Verses=100%,85%,70%,35%,28%   ; changed conc from 10%
Conventional=yes
Rocker=no
InfDeath=2
AnimList=XGRYSML1,XGRYSML2,EXPLOSML,XGRYMED1,XGRYMED2,EXPLOMED,EXPLOLRG,TWLT070
Deform=10%
DeformThreshhold=300
Tiberium=yes
Sparky=yes
Bright=yes
ProneDamage=70%     ; Presumes air burst

; Artillery shell
[ARTYHE]
Spread=6
Wall=yes
Wood=yes
Verses=100%,85%,68%,35%,35%
Conventional=yes
Rocker=yes
InfDeath=2
AnimList=XGRYSML1,XGRYSML2,EXPLOSML,XGRYMED1,XGRYMED2,EXPLOMED,EXPLOLRG
Deform=15%
DeformThreshhold=120
Tiberium=yes
Bright=yes
ProneDamage=150%

; Ion storm strike
[IonWH]
Spread=6
Wall=yes
Wood=yes
Verses=90%,75%,60%,25%,100%
Conventional=yes
Rocker=yes
InfDeath=5
AnimList=XGRYSML1,XGRYSML2,EXPLOSML,XGRYMED1,XGRYMED2,EXPLOMED,EXPLOLRG
Deform=10%
DeformThreshhold=300
Tiberium=yes
Sparky=yes
Bright=yes
ProneDamage=75%     ; Presumes air burst

; armor piercing (discarding sabot, narrow effect)
[AP]
Spread=3
Wall=yes
Wood=yes
Verses=25%,65%,75%,100%,60%
Conventional=yes
InfDeath=3
AnimList=S_CLSN16,S_CLSN22,S_CLSN30,S_CLSN42,S_CLSN58
ProneDamage=50%

; RPG Warhead
[RPG]
Spread=3
Wall=yes
Wood=yes
Rocker=yes
Verses=30%,75%,90%,100%,70%
Conventional=yes
InfDeath=3
AnimList=S_CLSN16,S_CLSN22,S_CLSN30,S_CLSN42,S_CLSN58
ProneDamage=100%

; Poison Gas Cloud
[Gas]
Spread=512
Verses=200%,150%,100%,20%,0%
InfDeath=1
Particle=GasCloudSys
ProneDamage=300%    ; Gas concentrates at gound level

; napalm and fire in general
[Fire]
Spread=8
Wood=yes
Verses=600%,148%,59%,6%,2%
InfDeath=4
Sparky=yes
Fire=yes
ProneDamage=600%

; napalm and fire in general, that doesn't set other things on fire (weird, but necessary)
[Fire2]
Spread=8
Wood=yes
Verses=600%,148%,59%,6%,2%
InfDeath=4
Sparky=no
Fire=yes
ProneDamage=600%

; anti-infantry rifle bullet (single shot -- very effective verses infantry)
[HollowPoint]
Spread=1
Verses=100%,5%,5%,5%,5%
InfDeath=1
AnimList=PIFF
ProneDamage=100%

; special case damage effect (do not use for regular weapons)
[Super]
Spread=0
Verses=100%,100%,100%,100%,100%
InfDeath=5
Tiberium=yes
ProneDamage=60%
Sparky=yes

; special case to only affect mechanical units
[Mechanical]
Spread=0
Verses=0%,100%,100%,100%,100%
InfDeath=0

; special case to only affect infantry (do not use for regular weapons)
[Organic]
Spread=0
Verses=100%,0%,0%,0%,0%
InfDeath=0

[Slimer]
Spread=0
Verses=100%,100%,60%,40%,20%
InfDeath=0

[Shard]
Spread=0
Verses=100%,100%,60%,40%,20%
InfDeath=1

[FirestormWH]
Spread=0
Verses=100%,100%,100%,100%,100%
InfDeath=4

[IonCannonWH]
Spread=40
Verses=100%,100%,100%,100%,100%
InfDeath=5
Wood=yes
Wall=yes
Fire=yes
Deform=100%
Sparky=yes

[VeinholeWH]
Spread=1
Verses=100%,100%,100%,100%,100%
InfDeath=0
Veinhole=yes

[PlasmaWH]
Spread=0
Verses=350%,260%,205%,150%,80%
InfDeath=5
Wall=yes
Bright=yes
Tiberium=yes
ProneDamage=350%
AnimList=EXPLOMED,EXPLOLRG
Sparky=yes

[SAMWH]
Spread=3
Verses=100%,100%,100%,100%,100%
InfDeath=3
AnimList=XGRYSML1,XGRYSML2,EXPLOSML
ProneDamage=100%

; Special Orca AP missile
[ORCAAP]
Spread=2
Wall=yes
Wood=yes
Verses=30%,65%,150%,100%,30%
Conventional=yes
InfDeath=3
AnimList=S_CLSN16,S_CLSN22,S_CLSN30,S_CLSN42,S_CLSN58
ProneDamage=50%

; Orca bomber HE bomb
[ORCAHE]
Spread=512
Wall=yes
Sparky=yes
Wood=yes
Bright=yes
Fire=yes
Verses=200%,90%,75%,32%,100%   ; changed conc from 10%
Conventional=yes
Rocker=yes
InfDeath=2
AnimList=EXPLOMED,EXPLOLRG
Deform=8%
DeformThreshhold=160
Tiberium=yes
ProneDamage=150%

; ******* Terrain Objects *******
; This section lists all the terrain object types and
; specifies their characteristics.

; Immune = Is the terrain immune to combat damage (def=no)?
; WaterBound = Is the terrain only allowed on the water (def=no)?
; SpawnsTiberium = Does it spawn growth of Tiberium around it (def=no)?
; IsFlammable = Can "Forest Fires" spread to and damage this terrain type?

[BOXES01]
Name=Boxes
Immune=yes

[BOXES02]
Name=Boxes
Immune=yes

[BOXES03]
Name=Boxes
Immune=yes

[BOXES04]
Name=Boxes
Immune=yes

[BOXES05]
Name=Boxes
Immune=yes

[BOXES06]
Name=Boxes
Immune=yes

[BOXES07]
Name=Boxes
Immune=yes

[BOXES08]
Name=Boxes
Immune=yes

[BOXES09]
Name=Boxes
Immune=yes

[ICE01]
Name=Ice Floe
Immune=yes
WaterBound=yes

[ICE02]
Name=Ice Floe
Immune=yes
WaterBound=yes

[ICE03]
Name=Ice Floe
Immune=yes
WaterBound=yes

[ICE04]
Name=Ice Floe
Immune=yes
WaterBound=yes

[ICE05]
Name=Ice Floe
Immune=yes
WaterBound=yes

[TREE01]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=4
SnowOccupationBits=6

[TREE02]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=4
SnowOccupationBits=7

[TREE03]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=4
SnowOccupationBits=6

[TREE04]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=7
SnowOccupationBits=6

[TREE05]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=5
SnowOccupationBits=7

[TREE06]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=4
SnowOccupationBits=7

[TREE07]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=4
SnowOccupationBits=7

[TREE08]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=7
SnowOccupationBits=4

[TREE09]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=4
SnowOccupationBits=4

[TREE10]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=6
SnowOccupationBits=3

[TREE11]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=4
SnowOccupationBits=3

[TREE12]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=4
SnowOccupationBits=7

[TREE13]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=4
SnowOccupationBits=4

[TREE14]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=4
SnowOccupationBits=4

[TREE15]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=4
SnowOccupationBits=7

[TREE16]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=4
SnowOccupationBits=7

[TREE17]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=4
SnowOccupationBits=7

[TREE18]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=4
SnowOccupationBits=7

[TREE19]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=4
SnowOccupationBits=2

[TREE20]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=4
SnowOccupationBits=3

[TREE21]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=4
SnowOccupationBits=1

[TREE22]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=4
SnowOccupationBits=3

[TREE23]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=4
SnowOccupationBits=3

[TREE24]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=4
SnowOccupationBits=6

[TREE25]
Name=Tree
IsFlammable=yes
RadarColor=0,192,0
TemperateOccupationBits=4
SnowOccupationBits=7

[TIBTRE01]
Name=Tiberium Tree
SpawnsTiberium=yes
RadarColor=192,192,0
IsAnimated=yes
LightVisibility=4000
LightIntensity=0.01
LightRedTint=0.01
LightGreenTint=1.5
LightBlueTint=0.01
AnimationRate=3
AnimationProbability=.003
Immune=yes

[TIBTRE02]
Name=Tiberium Tree
SpawnsTiberium=yes
RadarColor=192,192,0
IsAnimated=yes
LightVisibility=4000
LightIntensity=0.01
LightRedTint=0.01
LightGreenTint=1.5
LightBlueTint=0.01
AnimationRate=3
AnimationProbability=.003
Immune=yes

[TIBTRE03]
Name=Tiberium Tree
SpawnsTiberium=yes
RadarColor=192,192,0
IsAnimated=yes
LightVisibility=4000
LightIntensity=0.01
LightRedTint=0.01
LightGreenTint=1.5
LightBlueTint=0.01
AnimationRate=3
AnimationProbability=.003
Immune=yes

[VEINTREE]
Name=Veinhole Tree
Image=None
Armor=None
IsVeinhole=true
Strength=1000

; ******* Overlay Objects *******
; These are graphic objects that can have an effect on the game.

; Tiberium = Is this tiberium [Tiberium grown and graphic logic applies] (def=no)?
; Crate = Is this overlay a crate (def=no)?
; CrateTrigger = Is crate to trigger game events (def=no)?
; RadarInvisible = Is this overlay not visible on the radar map (def=no)?
; Explodes = Does it explode violently when destroyed [i.e., does it do collateral damage] (def=no)?
; LegalTarget = Can it be a legal target for attack (def=no)?
; ChainReaction = Does it explode and affect adjacent cells (def=no)?

[TIB01]
Name=Tiberium (Green)
Tiberium=yes
LegalTarget=false
RadarInvisible=false

[TIB02]
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false

[TIB03]
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false

[TIB04]
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false

[TIB05]
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false

[TIB06]
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false

[TIB07]
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false

[TIB08]
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false

[TIB09]
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false

[TIB10]
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false

[TIB11]
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false

[TIB12]
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false

[TIB13]
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false

[TIB14]
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false

[TIB15]
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false

[TIB16]
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false

[TIB17]
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false

[TIB18]
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false

[TIB19]
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false

[TIB20]
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false

[TIB2_01]
Image=TIB01
Name=Tiberium (Blue)
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB2_02]
Image=TIB02
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB2_03]
Image=TIB03
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB2_04]
Image=TIB04
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB2_05]
Image=TIB05
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB2_06]
Image=TIB06
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB2_07]
Image=TIB07
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB2_08]
Image=TIB08
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB2_09]
Image=TIB09
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB2_10]
Image=TIB10
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB2_11]
Image=TIB11
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB2_12]
Image=TIB12
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB2_13]
Image=TIB13
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB2_14]
Image=TIB14
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB2_15]
Image=TIB15
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB2_16]
Image=TIB16
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB2_17]
Image=TIB17
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB2_18]
Image=TIB18
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB2_19]
Image=TIB19
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB2_20]
Image=TIB20
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB3_01]
Image=TIB01
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB3_02]
Image=TIB02
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB3_03]
Image=TIB03
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB3_04]
Image=TIB04
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB3_05]
Image=TIB05
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB3_06]
Image=TIB06
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB3_07]
Image=TIB07
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB3_08]
Image=TIB08
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB3_09]
Image=TIB09
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB3_10]
Image=TIB10
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB3_11]
Image=TIB11
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB3_12]
Image=TIB12
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB3_13]
Image=TIB13
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB3_14]
Image=TIB14
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB3_15]
Image=TIB15
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB3_16]
Image=TIB16
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB3_17]
Image=TIB17
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB3_18]
Image=TIB18
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB3_19]
Image=TIB19
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[TIB3_20]
Image=TIB20
Name=Tiberium
Tiberium=yes
LegalTarget=false
RadarInvisible=false
ChainReaction=yes

[VEINHOLE]
Name=Veinhole Monster
LegalTarget=yes
RadarColor=92,92,0
Land=Rock
IsVeinholeMonster=true
IsVeins=true
NoUseTileLandType=true

[VEINHOLEDUMMY]
Name=Veinhole Monster Dummy
Image=blahblahblah
LegalTarget=no
RadarColor=92,92,0
IsVeins=true

[SROCK01]
LegalTarget=false
Name=Sand Rock #1
Land=Rock
RadarColor=64,64,64
NoUseTileLandType=true
DrawFlat=false
IsARock=true ;WST 6/21/99 all pesky rocks need to have this

[SROCK02]
LegalTarget=false
Name=Sand Rock #2
Land=Rock
RadarColor=64,64,64
NoUseTileLandType=true
DrawFlat=false
IsARock=true ;WST 6/21/99 all pesky rocks need to have this

[SROCK03]
LegalTarget=false
Name=Sand Rock #3
Land=Rock
RadarColor=64,64,64
NoUseTileLandType=true
DrawFlat=false
IsARock=true ;WST 6/21/99 all pesky rocks need to have this

[SROCK04]
LegalTarget=false
Name=Sand Rock #4
Land=Rock
RadarColor=64,64,64
NoUseTileLandType=true
DrawFlat=false
IsARock=true ;WST 6/21/99 all pesky rocks need to have this

[SROCK05]
LegalTarget=false
Name=Sand Rock #5
Land=Rock
RadarColor=64,64,64
NoUseTileLandType=true
DrawFlat=false
IsARock=true ;WST 6/21/99 all pesky rocks need to have this

[TROCK01]
LegalTarget=false
Name=Clear Rock #1
Land=Rock
RadarColor=64,64,64
NoUseTileLandType=true
DrawFlat=false;
IsARock=true ;WST 6/21/99 all pesky rocks need to have this

[TROCK02]
LegalTarget=false
Name=Clear Rock #2
Land=Rock
RadarColor=64,64,64
NoUseTileLandType=true
DrawFlat=false
IsARock=true ;WST 6/21/99 all pesky rocks need to have this

[TROCK03]
LegalTarget=false
Name=Clear Rock #3
Land=Rock
RadarColor=64,64,64
NoUseTileLandType=true
DrawFlat=false
IsARock=true ;WST 6/21/99 all pesky rocks need to have this

[TROCK04]
LegalTarget=false
Name=Clear Rock #4
Land=Rock
RadarColor=64,64,64
NoUseTileLandType=true
DrawFlat=false
IsARock=true ;WST 6/21/99 all pesky rocks need to have this

[TROCK05]
LegalTarget=false
Name=Clear Rock #5
Land=Rock
RadarColor=64,64,64
NoUseTileLandType=true
DrawFlat=false
IsARock=true ;WST 6/21/99 all pesky rocks need to have this

[BTIB01]
Name=Tiberium (Large)
Tiberium=yes
LegalTarget=false
RadarColor=80,0,0
Land=Rock
ChainReaction=yes
CellAnim=BIGBLUE
Image=None
NoUseTileLandType=true
DrawFlat=false

[BTIB02]
Name=Large Tiberium
Tiberium=yes
LegalTarget=false
RadarColor=80,0,0
Land=Rock
ChainReaction=yes
CellAnim=BIGBLUE
Image=None
NoUseTileLandType=true
DrawFlat=false

[BTIB03]
Name=Large Tiberium
Tiberium=yes
LegalTarget=false
RadarColor=80,0,0
Land=Rock
ChainReaction=yes
CellAnim=BIGBLUE
Image=None
NoUseTileLandType=true
DrawFlat=false

[BTIB04]
Name=Large Tiberium
Tiberium=yes
LegalTarget=false
RadarColor=80,0,0
Land=Rock
ChainReaction=yes
CellAnim=BIGBLUE
Image=None
NoUseTileLandType=true
DrawFlat=false

[BTIB05]
Name=Large Tiberium
Tiberium=yes
LegalTarget=false
RadarColor=80,0,0
Land=Rock
ChainReaction=yes
CellAnim=BIGBLUE
Image=None
NoUseTileLandType=true
DrawFlat=false

[BTIB06]
Name=Large Tiberium
Tiberium=yes
LegalTarget=false
RadarColor=80,0,0
Land=Rock
ChainReaction=yes
CellAnim=BIGBLUE
Image=None
NoUseTileLandType=true
DrawFlat=false

[BTIB07]
Name=Large Tiberium
Tiberium=yes
LegalTarget=false
RadarColor=80,0,0
Land=Rock
ChainReaction=yes
CellAnim=BIGBLUE
Image=None
NoUseTileLandType=true
DrawFlat=false

[BTIB08]
Name=Large Tiberium
Tiberium=yes
LegalTarget=false
RadarColor=80,0,0
Land=Rock
ChainReaction=yes
CellAnim=BIGBLUE
Image=None
NoUseTileLandType=true
DrawFlat=false

[BTIB09]
Name=Large Tiberium
Tiberium=yes
LegalTarget=false
RadarColor=80,0,0
Land=Rock
ChainReaction=yes
CellAnim=BIGBLUE
Image=None
NoUseTileLandType=true
DrawFlat=false

[BTIB10]
Name=Large Tiberium
Tiberium=yes
LegalTarget=false
RadarColor=80,0,0
Land=Rock
ChainReaction=yes
CellAnim=BIGBLUE
Image=None
NoUseTileLandType=true
DrawFlat=false

[BTIB11]
Name=Large Tiberium
Tiberium=yes
LegalTarget=false
RadarColor=80,0,0
Land=Rock
ChainReaction=yes
CellAnim=BIGBLUE
Image=None
NoUseTileLandType=true
DrawFlat=false

[BTIB12]
Name=Large Tiberium
Tiberium=yes
LegalTarget=false
RadarColor=80,0,0
Land=Rock
ChainReaction=yes
CellAnim=BIGBLUE
Image=None
NoUseTileLandType=true
DrawFlat=false

[TRACKS01]
Name=Track NwSe
Land=Railroad
LegalTarget=false
RadarColor=92,92,92
RadarInvisible = false

[TRACKS02]
Name=Track NeSw
Land=Railroad
LegalTarget=false
RadarColor=92,92,92
RadarInvisible = false

[TRACKS03]
Name=Track NS
Land=Railroad
LegalTarget=false
RadarColor=92,92,92
RadarInvisible = false

[TRACKS04]
Name=Track EW
Land=Railroad
LegalTarget=false
RadarColor=92,92,92
RadarInvisible = false

[TRACKS05]
Name=Train Tracks
Land=Railroad
LegalTarget=false
RadarColor=92,92,92
RadarInvisible = false

[TRACKS06]
Name=Train Tracks
Land=Railroad
LegalTarget=false
RadarColor=92,92,92
RadarInvisible = false

[TRACKS07]
Name=Train Tracks
Land=Railroad
LegalTarget=false
RadarColor=92,92,92
RadarInvisible = false

[TRACKS08]
Name=Train Tracks
Land=Railroad
LegalTarget=false
RadarColor=92,92,92
RadarInvisible = false

[TRACKS09]
Name=Train Tracks
Land=Railroad
LegalTarget=false
RadarColor=92,92,92
RadarInvisible = false

[TRACKS10]
Name=Train Tracks
Land=Railroad
LegalTarget=false
RadarColor=92,92,92
RadarInvisible = false

[TRACKS11]
Name=Train Tracks
Land=Railroad
LegalTarget=false
RadarColor=92,92,92
RadarInvisible = false

[TRACKS12]
Name=Train Tracks
Land=Railroad
LegalTarget=false
RadarColor=92,92,92
RadarInvisible = false

[TRACKS13]
Name=Train Tracks
Land=Railroad
LegalTarget=false
RadarColor=92,92,92
RadarInvisible = false

[TRACKS14]
Name=Train Tracks
Land=Railroad
LegalTarget=false
RadarColor=92,92,92
RadarInvisible = false

[TRACKS15]
Name=Train Tracks
Land=Railroad
LegalTarget=false
RadarColor=92,92,92
RadarInvisible = false

[TRACKS16]
Name=Train Tracks
Land=Railroad
LegalTarget=false
RadarColor=92,92,92
RadarInvisible = false

[TRACKTUNNEL01]
Name=Train Tracks
Image=TRTUNN01
Land=Railroad
LegalTarget=false
RadarColor=92,92,92

[TRACKTUNNEL02]
Name=Train Tracks
Image=TRTUNN02
Land=Railroad
LegalTarget=false
RadarColor=92,92,92

[TRACKTUNNEL03]
Name=Train Tracks
Image=TRTUNN03
Land=Railroad
LegalTarget=false
RadarColor=92,92,92

[TRACKTUNNEL04]
Name=Train Tracks
Image=TRTUNN04
Land=Railroad
LegalTarget=false
RadarColor=92,92,92

[LOBRDG01]
Image=LOBRDG01
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG02]
Image=LOBRDG02
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG03]
Image=LOBRDG03
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG04]
Image=LOBRDG04
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG05]
Image=LOBRDG05
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG06]
Image=LOBRDG06
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG07]
Image=LOBRDG07
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG08]
Image=LOBRDG08
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG09]
Image=LOBRDG09
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG10]
Image=LOBRDG10
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG11]
Image=LOBRDG11
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG12]
Image=LOBRDG12
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG13]
Image=LOBRDG13
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG14]
Image=LOBRDG14
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG15]
Image=LOBRDG15
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG16]
Image=LOBRDG16
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG17]
Image=LOBRDG17
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG18]
Image=LOBRDG18
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG19]
Image=LOBRDG19
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG20]
Image=LOBRDG20
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG21]
Image=LOBRDG21
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG22]
Image=LOBRDG22
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG23]
Image=LOBRDG23
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG24]
Image=LOBRDG24
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG25]
Image=LOBRDG25
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG26]
Image=LOBRDG26
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=true
RadarInvisible = false

[LOBRDG27]
Image=LOBRDG27
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=false
RadarInvisible = true

[LOBRDG28]
Image=LOBRDG28
Name=Low Bridge
Land=Road
RadarColor=92,92,92
NoUseTileLandType=false
RadarInvisible = true

[LOBRDGE1]
Image=LOBRDGE1
Name=Low Bridge End 1
Land=Road
NoUseTileLandType=true
RadarColor=92,92,92

[LOBRDGE2]
Image=LOBRDGE2
Name=Low Bridge End 2
Land=Road
NoUseTileLandType=true
RadarColor=92,92,92

[LOBRDGE3]
Image=LOBRDGE3
Name=Low Bridge End 3
Land=Road
NoUseTileLandType=true
RadarColor=92,92,92

[LOBRDGE4]
Image=LOBRDGE4
Name=Low Bridge End 4
Land=Road
NoUseTileLandType=true
RadarColor=92,92,92

[VEINS]
Image=VEINS
Name=Tiberium Veins
RadarColor=0,0,92
IsVeins=true
Land=Weeds

[RAILBRDG1]
Image=RAILBRDG
Name=Railroad Bridge 1
LegalTarget=true
RadarColor=92,92,92
Overrides=yes
NoUseTileLandType=false

[RAILBRDG2]
Image=RAILBRDG
Name=Railroad Bridge 2
LegalTarget=true
RadarColor=92,92,92
Overrides=yes
NoUseTileLandType=false

[BRIDGE1]
Image=BRIDGE
Name = Bridge 1
LegalTarget=true
RadarColor=92,92,92
Overrides=yes
NoUseTileLandType=false

[BRIDGE2]
Image=BRIDGE
Name = Bridge 2
LegalTarget=true
RadarColor=92,92,92
Overrides=yes
NoUseTileLandType=false

[CRATE]
Name=Goodie Crate
RadarColor=92,92,92
Crate=yes
CrateTrigger=yes
RadarInvisible=yes
Land=Clear
DrawFlat=false

[CRAT01]
Name=Crate
LegalTarget=true
RadarColor=92,92,92
;Crate=yes
;CrateTrigger=yes
;RadarInvisible=yes
Land=Rock

[CRAT02]
Name=Crate
LegalTarget=true
RadarColor=92,92,92
;Crate=yes
;RadarInvisible=yes
Land=Rock

[CRAT03]
Name=Crate
LegalTarget=true
RadarColor=92,92,92
;Crate=yes
;RadarInvisible=yes
Land=Rock

[CRAT04]
Name=Crate
LegalTarget=true
RadarColor=92,92,92
Land=Rock

[CRAT0A]
Name=Crate
LegalTarget=true
RadarColor=92,92,92
Land=Rock

[CRAT0B]
Name=Crate
LegalTarget=true
RadarColor=92,92,92
Land=Rock

[CRAT0C]
Name=Crate
LegalTarget=true
RadarColor=92,92,92
Land=Rock

[DRUM01]
Name=Drum
LegalTarget=true
RadarColor=92,92,92
Land=Rock

[DRUM02]
Name=Drum
LegalTarget=true
RadarColor=92,92,92
Land=Rock

[PALET01]
Name=Palette
LegalTarget=true
RadarColor=92,92,92
Land=Rock

[PALET02]
Name=Palette
LegalTarget=true
RadarColor=92,92,92
Land=Rock

[PALET03]
Name=Palette
LegalTarget=true
RadarColor=92,92,92
Land=Rock

[PALET04]
Name=Palette
LegalTarget=true
RadarColor=92,92,92
Land=Rock


; ******* Smudge Objects *******
; These specify the objects (actually more of an artwork
; element than a game object) called smudges. These typically
; are used to mark the effects of battle.

; Crater = Is this a crater smudge [special growth logic] (def=no)?
[CRATER01]
Crater=yes

[CRATER02]
Crater=yes

[CRATER03]
Crater=yes

[CRATER04]
Crater=yes

[CRATER05]
Crater=yes

[CRATER06]
Crater=yes

[CRATER07]
Crater=yes

[CRATER08]
Crater=yes

[CRATER09]
Crater=yes

[CRATER10]
Crater=yes

[CRATER11]
Crater=yes
Width=2
Height=2

[CRATER12]
Crater=yes
Width=2
Height=2

[BURNT01]
Burn=yes

[BURNT02]
Burn=yes

[BURNT03]
Burn=yes

[BURNT04]
Burn=yes

[BURNT05]
Burn=yes

[BURNT06]
Burn=yes

[BURNT07]
Burn=yes
Width=2

[BURNT08]
Burn=yes
Width=2

[BURNT09]
Burn=yes
Height=2

[BURNT10]
Burn=yes
Height=2

[BURNT11]
Burn=yes
Width=2
Height=2

[BURNT12]
Burn=yes
Width=2
Height=2

[CR1]

[CR2]

[CR3]

[CR4]

[CR5]

[CR6]

[BURN01]

[BURN02]

[BURN03]

[BURN04]

[BURN05]

[BURN06]

[BURN07]

[BURN08]

[BURN09]

[BURN10]

[BURN11]

[BURN12]

[BURN13]

[BURN14]

[BURN15]

[BURN16]


; ******* Land Characteristics *******
; This section specifies the characteristics of the various
; terrain types. The primary purpose is to differentiate the
; movement capabilities.

; Float = % of full speed for ships [0 means impassable] (def=100)
; Foot = % of full speed for foot soldiers [0 means impassable] (def=100)
; Track = % of full speed for tracked vehicles [0 means impassable] (def=100)
; Wheel = % of full speed for wheeled vehicles [0 means impassable] (def=100)
; Hover = % of full speed for hovering vehicles [0 means impassable] (def=100)
; Amphibious = % of full speed for amphibious vehicles [0 impassable] (def=100)
; Buildable = Can buildings be built upon this terrain (def=no)?

; clear grassy terrain
[Clear]
Foot=90%
Track=70%
Wheel=70%
Float=0%
Hover=100%
Amphibious=80%
Buildable=yes

; rocky terrain
[Rough]
Foot=80%
Track=60%
Wheel=40%
Float=0%
Hover=100%
Amphibious=40%
Buildable=yes

; roads
[Road]
Foot=100%
Track=100%
Wheel=100%
Hover=100%
Float=0%
Amphibious=100%
Buildable=yes

; open water
[Water]
Foot=0%
Track=0%
Wheel=0%
Hover=100%
Float=100%
Amphibious=80%
Buildable=no

; cliffs
[Rock]
Foot=0%
Track=0%
Wheel=0%
Float=0%
Hover=0%
Amphibious=0%
Buildable=no

; walls and other man made obstacles
[Wall]
Foot=0%
Track=0%
Wheel=0%
Float=0%
Hover=0%
Amphibious=0%
Buildable=no

; Tiberium
[Tiberium]
Foot=90%
Track=70%
Wheel=50%
Float=0%
Hover=100%
Amphibious=50%
Buildable=no

; Vein hole creater weeds
[Weeds]
Foot=50%
Track=70%
Wheel=50%
Float=0%
Hover=100%
Amphibious=50%
Buildable=no

; sandy beach
[Beach]
Foot=0%
Track=0%
Wheel=0%
Float=0%
Hover=100%
Amphibious=60%
Buildable=no

; ice
[Ice]
Foot=50%
Track=80%
Wheel=50%
Float=0%
Hover=100%
Amphibious=50%
Buildable=no

; train tracks
[Railroad]
Foot=90%
Track=100%
Wheel=50%
Float=0%
Hover=100%
Amphibious=50%
Buildable=no

; tunnels
[Tunnel]
Foot=100%
Track=100%
Wheel=100%
Float=0%
Hover=100%
Amphibious=100%
Buildable=no


; ******* Random Crate Powerups *******
; This specifies the chance for the specified crate powerup to appear
; in a 'random' crate. The chance is expressed in the form of 'shares'
; out of the total shares specified. The second parameter is the animation
; to use when this crate is picked up. The third parameter, if present, specifies
; the data value needed for that crate powerup. They mean different things
; for the different powerups.
[Powerups]
Armor=33,ARMOR,2.0              ; armor of nearby objects increased (armor multiplier)
Cloak=20,CLOAK                   ; enable cloaking on nearby objects
Darkness=5,SHROUDX              ; cloak entire radar map
Explosion=38,<none>,500          ; high explosive baddie (damage per explosion)
Firepower=28,FIREPOWR,2.0       ; firepower of nearby objects increased (firepower multiplier)
HealBase=23,HEALALL              ; all buildings to full strength
ICBM=13,CHEMISLE                 ; nuke missile one time shot
Money=55,MONEY,2000             ; a chunk o' cash (maximum cash)
Napalm=25,<none>,600             ; fire explosion baddie (damage)
Reveal=8,REVEAL                 ; reveal entire radar map
Speed=30,ARMOR,1.7              ; speed of nearby objects increased (speed multiplier)
Squad=45,<none>                 ; squad of random infantry
Unit=40,<none>                  ; vehicle
Invulnerability=10,ARMOR,1.0     ; invulnerability (duration in minutes)
Veteran=15,VETERAN,1             ; veteran upgrade (levels to upgrade)
IonStorm=0,<none>               ; initiate ion storm
Gas=18,<none>,100                ; tiberium gas (damage for each gas cloud)
Tiberium=35,<none>               ; tiberium patch
Pod=0,<none>                    ; drop pod special

; ******* Tiberium Varieties *******
; There are various kinds of tiberium. This lists their number and
; particulars.

[Tiberiums]
0=Riparius
1=Cruentus
2=Vinifera
3=Aboreus

; Name = display name
; Image = image to use [1=small, 2=large, 3=vine]
; Value = credit value per 'bail'
; Growth = growth rate
; Spread = spread rate
; Power = explosive power per 'bail' (def=0)
; Color = display color of the Tiberium
; Shard = crystal to fly off when chain reacting (def=none)

; This is green tiberium.  It grows and spreads quickly and is not explosive
[Riparius]
Name=Tiberium Riparius
Image=1
Power=4
Value=25
Growth=2200
GrowthPercentage=.09
Spread=2200
SpreadPercentage=.09
Color=NeonGreen			; **WARNING**: If you change this color, notify Bret_a

; This is the big tiberium crystal.  It does not grow or spread, is impassable and is explosive
; Not currently in use in TS (AI)
[Cruentus]
Name=Tiberium Cruentus
Image=2
Value=70
Growth=10000
GrowthPercentage=0
Spread=10000
SpreadPercentage=0
Power=10
Color=NeonBlue			; **WARNING**: If you change this color, notify Bret_a
Debris=CRYSTAL1,CRYSTAL2,CRYSTAL3,CRYSTAL4

; This is blue tiberium.  It grows and spreads slowly and is explosive.
[Vinifera]
Name=Tiberium Vinifera
Image=3
Value=40
Growth=10000
GrowthPercentage=.05
Spread=10000
SpreadPercentage=.05
Power=100 ; 10
Color=NeonBlue		; **WARNING**: If you change this color, notify Bret_a
Debris=CRYSTAL1,CRYSTAL2,CRYSTAL3,CRYSTAL4

; This is blue tiberium.  It grows and spreads slowly and is explosive.  This entry should be
; the same as [vinifera] except for Name and Image
[Aboreus]
Name=Tiberium Aboreus
Image=4
Value=30
Growth=10000
GrowthPercentage=.05
Spread=10000
SpreadPercentage=.05
Power=10
Color=NeonBlue		; **WARNING**: If you change this color, notify Bret_a
Debris=CRYSTAL1,CRYSTAL2,CRYSTAL3,CRYSTAL4


; ******* Mission Control *******
; This specifies the various general behavior characteristics of
; the missions that objects can be assigned. Each of the game objects must
; be in a mission. The mission behavior is generally hard coded into
; the program, but there are some behavior characteristics that can
; be overridden. Don't modify these.

; NoThreat = Is its weapons disabled and thus ignored as a potential target until fired upon (def=no)?
; Zombie = Is forced to sit there like a zombie and never recovers (def=no)?
; Recruitable = Can it be recruited into a team or base defense (def=yes)?
; Paralyzed = Is the object frozen in place but can still fire and function (def=no)?
; Retaliate = Is allowed to retaliate while on this mission (def=yes)?
; Scatter = Is allowed to scatter from threats (def=yes)?
; Rate = delay between normal processing (larger = faster game, less responsiveness)
; AARate = anti-aircraft delay rate (if not specifed it uses regular rate).

; Unit sits still and plays dead.
[Sleep]
Recruitable=no
Zombie=yes
Retaliate=no
Scatter=no
Rate=1

; Unit doesn't fire and is not considered a threat.
[Harmless]
Recruitable=no
NoThreat=yes
Retaliate=no
Rate=.5

; Just like guard mode, but cannot move.
[Sticky]
Recruitable=no
Paralyzed=yes
Scatter=no
Rate=.016

; Special attack mission used by team logic.
[Attack]
Rate=.016
AARate=.016

; Move to destination.
[Move]
Rate=.016

; Patrol a series of waypoints
[Patrol]
Rate=.016

; Special move to destination after all other queued moves occur.
[QMove]
Rate=.016

; Run away (possibly leave the map).
[Retreat]
Recruitable=no
Retaliate=no
Rate=.1

; Sit around and engage any enemy that wanders within weapon range.
[Guard]
Rate=.030
AARate=.016

; Enter building or transport for loading purposes.
[Enter]
Retaliate=no
Recruitable=no
Rate=.016

; Engineer entry logic.
[Capture]
Retaliate=no
Recruitable=no
Scatter=no
Rate=.016

; Handle harvest ore - dump at refinery loop.
[Harvest]
Retaliate=no
Recruitable=no
Scatter=no
Rate=.016

; Guard the general area where the unit starts at.
[Area Guard]
Recruitable=yes
Rate=.040
AARate=.032

; <unused>
[Return]

; Stop moving and firing at the first available opportunity.
[Stop]

; <unused>
[Ambush]

; Scan for and attack any enemies whereever they may be.
[Hunt]
Recruitable=no
Retaliate=no
Rate=.016

; While dropping off cargo (e.g., APC unloading passengers).
[Unload]
Recruitable=no
Retaliate=no
Scatter=no
Rate=.016

; Tanya running to place bomb in building.
[Sabotage]
Recruitable=no
Rate=.016

; Buildings use this when building up after initial placement.
[Construction]
Recruitable=no
Retaliate=no
Scatter=no

; Buildings use this when deconstruction after being sold.
[Selling]
Recruitable=no
NoThreat=yes
Retaliate=no
Scatter=no

; Service depot uses this mission to repair attached object.
[Repair]
Rate=.08

; Special team override mission.
[Rescue]
Rate=.016

; Missile silo special launch missile mission.
[Missile]
Rate=.1

; While opening or closing a gate to allow passage.
[Open]
Rate=.016


; ******* Voxel Debris types *******
; Translucent = is the debris to be drawn with translucency (def=no)?
; Elasticity = "bounciness" of the object [should be 0.0 through 1.0] (def=0.75)
; MinAngularVelocity = minimum rate at which the debris is to spin in degrees (def=0.0)
; MaxAngularVelocity = maximum rate at which the debris is to spin in degrees (def=10.0)
; Duration = max number of frames to let the debris exist (def=30)
; MinZVel = minimum starting Z velocity (def=3.5)
; MaxZVel = maximum starting Z velocity (def=5.0)
; MaxXYVel = maximim starting lateral velocity (def=15.0)
; ShareBodyData = Get the voxel data from another Type's body voxel data (def = no)?
; ShareTurretData = Get the voxel data from another Type's turret voxel data (def = no)?
; ShareBarrelData = Get the voxel data from another Type's barrel voxel data (def = no)?
; ShareSource = name of the object to share voxel data from (def = none)
; VoxelIndex = voxel piece within the voxel data to use (def = 0)
; StartSound = sound to play when the voxel anim is created (def = VOC_NONE).
; BounceSound = sound to play when the voxel anim bounces (def = VOC_NONE).
; ExpireSound = sound to play when the voxel anim expires (def = VOC_NONE).
; BounceAnim = animation to launch when the voxel anim bounces (def = ANIM_NONE).
; ExpireAnim = animation to launch when the voxel anim expires (def = ANIM_NONE).
; TrailerAnim = animation to trail behind the object (usually smoke or flame)
; DamageRadius = the debris damages objects that it hits if they're closer than this distance
; Damage = amount of damage to apply to objects that are hit
; Warhead = warhead to use for damage purposes
; AttachedSystem = particle system to attach to the voxel anim
; Spawns = the particle spawned when this voxel debris explodes (def = none)
; SpawnCount = number of particles spawned [on average] (def = 0)

[PIECE]
Name=Scrap Metal Debris
Elasticity=0
MinAngularVelocity=5.0
MaxAngularVelocity=9.0
MinZVel=24.0
MaxZVel=28.0
MaxXYVel=15.0
Duration=75
Damage=5
ExpireAnim=TWLT036
DamageRadius=100
Warhead=TankOGas

[TIRE]
Name=Flying Tire
Elasticity=0.8
MinAngularVelocity=12.0
MaxAngularVelocity=24.0
MinZVel=28.0
MaxZVel=32.0
MaxXYVel=10.0
Duration=150

[GASTANK]
Name=Flying Gas Tank
Elasticity=0.0
MinAngularVelocity=9.0
MaxAngularVelocity=15.0
MinZVel=30.0
MaxZVel=35.0
MaxXYVel=8.0
Duration=100
ExpireAnim=TWLT036
Damage=20
DamageRadius=100
Warhead=TankOGas

[SONICTURRET]
Name=Disruptor Turret
ShareTurretData=yes
ShareSource=SONIC
Elasticity=0.0
MinAngularVelocity=10.0
MaxAngularVelocity=14.0
MinZVel=30.0
MaxZVel=38.0
MaxXYVel=8.0
Duration=100
ExpireAnim=TWLT026
Damage=90
DamageRadius=100
Warhead=TankOGas

[4TNKTURRET]
Name=Mammoth Tank Turret
ShareTurretData=yes
ShareSource=4TNK
Elasticity=0.0
MinAngularVelocity=10.0
MaxAngularVelocity=14.0
MinZVel=30.0
MaxZVel=38.0
MaxXYVel=8.0
Duration=100
ExpireAnim=TWLT036
Damage=30
DamageRadius=50
Warhead=TankOGas

[CRYSTAL01]
Name=TiberiumCrystal01
ShareTurretData=yes
ShareSource=SONIC
Elasticity=0.0
MinAngularVelocity=12.0
MaxAngularVelocity=24.0
MinZVel=28.0
MaxZVel=32.0
MaxXYVel=10.0
Duration=150
ExpireAnim=TWLT050
Damage=40
DamageRadius=100
Warhead=TankOGas
IsTiberium=true

[CRYSTAL02]
Name=TiberiumCrystal02
Image=GASTANK
Elasticity=0.0
MinAngularVelocity=12.0
MaxAngularVelocity=24.0
MinZVel=40.0
MaxZVel=45.0
MaxXYVel=18.0
Duration=150
ExpireAnim=TWLT050
Damage=40
DamageRadius=100
Warhead=TankOGas
IsTiberium=true

[METEOR01]
Name=Meteorite01
Image=MTRS
Elasticity=0.0
MinAngularVelocity=12.0
MaxAngularVelocity=30.0
MinZVel=-100.0
MaxZVel=-100.0
MaxXYVel=100.0
Duration=70
ExpireAnim=TWLT070
Damage=500
DamageRadius=300
Warhead=Meteorite
IsMeteor=true
Spawns=PEBBLE
SpawnCount=5

[METEOR02]
Name=Meteorite02
Image=MTRB
Elasticity=0.0
MinAngularVelocity=12.0
MaxAngularVelocity=30.0
MinZVel=-100.0
MaxZVel=-100.0
MaxXYVel=100.0
Duration=70
ExpireAnim=TWLT100
Damage=500
DamageRadius=300
Warhead=Meteorite
IsMeteor=true
IsTiberium=true
Spawns=PEBBLE
SpawnCount=7

[PEBBLE]
Name=TiberiumShard
Image=MTRB
Elasticity=0.0
MinAngularVelocity=12.0
MaxAngularVelocity=24.0
MinZVel=40.0
MaxZVel=45.0
MaxXYVel=18.0
Duration=150
ExpireAnim=TWLT036
Damage=20
DamageRadius=100
Warhead=TankOGas
IsTiberium=true


; ******* Special Weapon types *******
; IsPowered -- does this super weapon become inoperative in a low power situation?
; RechargeVoice -- Voice to use when weapon is fully recharged and ready.
; ChargingVoice -- Voice to use when weapon begins charging.
; ImpatientVoice -- Voice to use when user clicks on weapon that isn't finished charging.
; SuspendVoice -- Voice to use when special weapon charging is suspended.
; RechargeTime -- time in minutes to recharge this special

; Chem weapon. The logic will fail if this weapon is 'powered'
[ChemicalSpecial]
Name=Chemical Missile
IsPowered=false
RechargeVoice=00-I152
ChargingVoice=
ImpatientVoice=
SuspendVoice=
RechargeTime=.3
Type=ChemMissile
SidebarImage=ChemIcon
Action=ChemBomb
ManualControl=yes
WeaponType=ChemLauncher
AuxBuilding=NAWAST

[MultiSpecial]
Name=Multi-Missile
IsPowered=true
RechargeVoice=00-I154
ChargingVoice=
ImpatientVoice=
SuspendVoice=
RechargeTime=7
Type=MultiMissile
SidebarImage=MltiIcon
Action=Nuke
WeaponType=MultiLauncher

[EMPulseSpecial]
Name=E.M. Pulse
IsPowered=true
RechargeVoice=00-I158
ChargingVoice=
ImpatientVoice=
SuspendVoice=
RechargeTime=3.1
Type=EMPulse
SidebarImage=PulsIcon
Action=EMPulse

[FirestormSpecial]
Name=Firestorm Defense
IsPowered=true
RechargeVoice=00-I162
ChargingVoice=
ImpatientVoice=
SuspendVoice=
RechargeTime=2.1
Type=Firestorm
SidebarImage=FSTDICON
UseChargeDrain=true

[IonCannonSpecial]
Name=Ion Cannon
IsPowered=true
RechargeVoice=00-I156
ChargingVoice=
ImpatientVoice=
SuspendVoice=
RechargeTime=5.95
Type=IonCannon
Action=IonCannon
SidebarImage=IONCICON

[HuntSeekSpecial]
Name=Hunter Seeker
IsPowered=true
RechargeVoice=
ChargingVoice=
ImpatientVoice=
SuspendVoice=
RechargeTime=8.4
Type=HunterSeeker
SidebarImage=DETNICON


; ******* Globals Variable Names *******
; These must be constant throughout all scenarios based on these
; rules. These are numbered starting from zero. Do not change the
; number values or else all preexisting triggers using them will
; break.

[VariableNames]
0=<Alternate Start Location>
1=<Alternate Next Scenario>
2=<reserved2>
3=Sensor Array Down
4=Toxin Trucks Found
5=Dam Destroyed
6=Ion Cannon Codes Found
7=C4 Placed
8=Completed 3B
9=Prisoners Freed
10=Train Stolen
11=Completed 9B

