
//**************************************************************************
//**
//** builtin.hc
//**
//** $Header: /HexenWorld/Siege/builtin.hc 19    5/25/98 1:38p Mgummelt $
//**
//**************************************************************************

// Sets v_forward, etc.
void makevectors(vector ang) : 1;

void setorigin(entity e, vector o) : 2;

// Set movetype and solid before calling.
void setmodel(entity e, string m) : 3;

void setsize(entity e, vector min, vector max) : 4;
void lightstylestatic(float style, float value) : 5;
void debugbreak(void) : 6;

// Returns 0 - 1.
float random(void) : 7;

void sound(entity e, float chan, string samp, float vol, float atten) : 8;
vector normalize(vector v) : 9;
void error(string e) : 10;
void objerror(string e) : 11;
float vlen(vector v) : 12;
float vectoyaw(vector v) : 13;
entity spawn(void) : 14;
void remove(entity e) : 15;

// Sets trace_* globals.
void traceline(vector v1, vector v2, float nomonsters,
	entity forent) : 16;

// Returns a client to look for.
entity checkclient(void) : 17;

entity find(entity start, .string fld, string match) : 18;

// For sounds in demo and retail version.
string precache_sound(string s) : 19;

// For models in demo and retail version.
string precache_model(string s) : 20;

void stuffcmd(entity client, string s) : 21;
entity findradius(vector org, float rad) : 22;
void bprint(float level, string s) : 23;
void sprint(entity client, float level, string s) : 24;
void dprint(string s) : 25;
string ftos(float f) : 26;
string vtos(vector v) : 27;

// Prints all edicts.
void coredump(void) : 28;

void traceon(void) : 29;
void traceoff(void) : 30;

// Prints an entire edict.
void eprint(entity e) : 31;

// Returns TRUE or FALSE.
float walkmove (float yaw, float dist, float set_trace) : 32;

float tracearea(vector v1, vector v2, vector mins, vector maxs,
	float nomonsters, entity forent) : 33;

// TRUE if landed on floor.
float droptofloor(void) : 34;

void lightstyle(float style, string value) : 35;

// Round to nearest int.
float rint(float v) : 36;

// Largest integer <= v.
float floor(float v) : 37;

// Smallest integer >= v.
float ceil(float v) : 38;

// Award experience to player.
//void AwardExperience(entity ToEnt, entity FromEnt, float Amount) : 39;

// TRUE if self is on ground.
float checkbottom(entity e) : 40;

// Returns a CONTENT_*.
float pointcontents(vector v) : 41;

// Start a particle effect.
void particle2(vector o, vector dmin, vector dmax, float color,
	float type, float count) : 42;

float fabs(float f) : 43;

// Returns a shooting vector.
vector aim(entity e,vector d,float speed) : 44;

// Returns the cvar value.
float cvar(string s) : 45;

// Put a string into local que.
void localcmd(string s) : 46;

// For looping through all ents.
entity nextent(entity e) : 47;

// Start a particle effect.
void particle(vector o, vector d, float color, float count) : 48;

// Turn towards self.ideal_yaw at self.yaw_speed.
float ChangeYaw(void) : 49;

// Calculate distance, ignoring z.
float vhlen(vector v) : 50;

vector vectoangles(vector v) : 51;

void WriteByte(float to, float f) : 52;
void WriteChar(float to, float f) : 53;
void WriteShort(float to, float f) : 54;
void WriteLong(float to, float f) : 55;
void WriteCoord(float to, float f) : 56;
void WriteAngle(float to, float f) : 57;
void WriteString(float to, string s) : 58;
void WriteEntity(float to, entity s) : 59;
void dprintf(string s, float num) : 60;
float cos(float angle) : 61;
float sin(float angle) : 62;
float AdvanceFrame(float start, float end) : 63;
void dprintv(string s, vector vec) : 64;
float RewindFrame(float start, float end) : 65;

void setclass(entity e, float value) : 66;

void movetogoal(float step) : 67;

// For files in demo and retail version.
string precache_file(string s) : 68;

void makestatic(entity e) : 69;
void changelevel(string level, string spot) : 70;

// Returns the current value of a light style.
float lightstylevalue(float style) : 71;

// Sets a cvar value.
void cvar_set(string var, string val) : 72;

// Same as sprint(), but centered.
void centerprint(entity client, string s) : 73;

void ambientsound(vector pos, string samp, float vol, float atten) : 74;

// For models only in retail version.
string precache_model2(string s) : 75;

// For sounds only in retail version.
string precache_sound2(string s) : 76;

// For files only in retail version.
string precache_file2(string s) : 77;


// Sets parm1... to the values at level start for coop respawn.
void setspawnparms(entity e) : 78;

void plaque_draw(float to, float index) : 79;

// Create rain.
void rain_go(vector v1, vector v2, vector e_size, vector dir,
	float color, float count) : 80;

// Particle explosion.
void particleexplosion(vector v,float f,float c,float s) : 81;

// Move a step.
float movestep(float x, float y, float z, float set_trace) : 82;

// Returns TRUE or FALSE (move other).
float advanceweaponframe(float startframe, float endframe) : 83;

float sqrt(float num1)   : 84;

void particle3(vector o, vector box, float color, float type, float count) : 85;
void particle4(vector o, float radius, float color, float type, float count) : 86;

// m will used as:  models/puzzle/m.mdl
void setpuzzlemodel(entity e, string m) : 87;

//float starteffect(float to, float effect) : 88;
float starteffect(...) : 88;
float endeffect(float to, float effect_id) : 89;

string precache_puzzle_model(string s) : 90;
vector concatv(vector in, vector limit) : 91;
string getstring(float id) : 92;
entity spawn_temp(void) : 93;
vector v_factor(vector factor) : 94;
	// returns (v_right * factor_x) + (v_forward * factor_y) + (v_up * factor_z)
vector v_factorrange(vector start, vector end) : 95;

string precache_sound3(string s) : 96;
string precache_model3(string s) : 97;
string precache_file3(string s) : 98;

void logfrag(entity killer, entity killee) : 99;       // add to stats

string infokey(entity e, string key) : 100;  // get a key value (world = serverinfo)
float stof(string s)                             : 101;          // convert string to float
void multicast(vector where, float set) : 102;  // sends the temp message to a set
void turneffect(float effect_id, vector pos, vector dir) : 103;
void updateeffect(...) : 104;  //have server send an update message (type-specific) to clients
								// format:  updateeffect(<effect index>, <effect type>, <type-specific extra info>);

void setseed(float seed) : 105;	//seed is really a short int
float seedrand(void) : 106;
void multieffect(...) : 107;
float getmeid(void) : 108;
void weapon_sound(entity e, string s) : 109;  //net efficient weapon sound on entity
void bcenterprint2(string s, string s) : 110; // center prints two concated strings to all clients
void print_indexed(float to, float level, float index): 111;//print string in strings.txt indicated by index
void centerprint2(entity e, string s, string s) : 112;
void print_name(float to, float level, entity who) : 113;//print name of who

void stopSound(entity e, float chan) : 114;
void updateSoundPos(entity e, float chan) : 115;

string precache_sound5(string s) : 116;
string precache_model5(string s) : 117;
string precache_file5(string s) : 118;
void setsiegeteam(entity who, float s_team) : 119;
void updateSiegeInfo(void) : 120;
