#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_LINE_LENGTH 1024

char *ReadLine( const char *pFilename, unsigned int iLine )
{
    FILE *fp = NULL;
    char *pLine = NULL;

    /* First line in file is numbered 1 */
    if( 0 == iLine )
        return NULL;
    
    fp = fopen( pFilename, "r" );
    if( NULL != fp )
    {
        char aBuffer[MAX_LINE_LENGTH];
        int  fOK = 1;

        do
        {
            if( fgets( aBuffer, sizeof(aBuffer), fp ) )
            {
                iLine--;

                if( iLine > 0 )
                {
                    /* Make sure we have read the whole
                    of the line, ready for next time */
                    while( fOK && (NULL == strchr( aBuffer, '\n' )) )
                        fOK = (NULL != fgets( aBuffer, sizeof(aBuffer), fp ));
                }
            }
            else
            {
                /* error, could not read line */
                fOK = 0;
            }
        } while( fOK && iLine );

        if( fOK )
        {
            /* Line found */
            pLine = malloc( strlen( aBuffer ) + 1 );
            if( pLine )
            {
                strcpy( pLine, aBuffer );
            }
            else
            {
                /* error, out of mem */
            }
        }

        fclose(fp);
    }
    else
    {
        /* Failed to open file */
    }
    
    return pLine;
}

int main( int argc, char *argv[] )
{
    char *pLine = NULL;
    
    if( argc < 3 )
    {
        printf( "Usage %s <file> <line>\n", argv[0] );
        return -1;
    }


    pLine = ReadLine( argv[1], atoi(argv[2]) );
    if(pLine)
    {
        puts(pLine);
        free(pLine);
    }

    return 0;
}