/*==========================================================================
 * 
 * Project : QuakeForge
 * Author  : Terry 'Mongoose' Hendrix II
 * Website : http://www.westga.edu/~stu7440
 * Email   : stu7440@westga.edu
 * Object  : qw_interface
 * Comments: This is will be the contained qw_interface for CS/SS bots.
 *
 *           For now it's the SS QW interfce by thefatal, put in a
 *           contained object to avoid damaging QW server development.
 *
 *           Hopefully I can get the new networking for the SS/CS bot 
 *           Athena/QW interface done soon, and merge it as well. 
 *
 *           Plans are to move all the code possible from the QW server
 *           into the AI server and this ( the QW bot/game interface ).
 *
 *
 * Notes   : This first version is just a blind merge  
 *
 *           The QW faux client code is based on code from:
 *           GENEBOT QUAKEWORLD SERVER SOURCE CODE DISTRIBUTION
 *           --------------------------------------------------
 *           AUTHOR:            Rich Whitehouse
 *           CONTACT:           thefatal@telefragged.com
 *           HOMEPAGE:          http://www.telefragged.com/thefatal/ 
 *           RELEASE NUMBER:    1
 *
 *
 *-- History ---------------------------------------------------------- 
 *
 * 1999-12-30
 * Mongoose - Bot chat
 *            More code abstraction
 *
 * 1999-12-29
 * Mongoose - Make bot file if DNE
 *            Moved all of Rich's screwy gobals here, extern from header
 *            Moved all the bot specific functions here
 *            Cleaned up the code, so it's readable/added a few comments
 *            Started merging into QF fork
 *            #define QW_AI_PLAYERS_ALLOWED to toggle bot server build
 *            Created from source release from thefatal
 *
 ==========================================================================*/

#include "qw_interface.h"

float  ADDTIME;      /* addtime  */
float  OLDBOTS;      /* oldbots  */
float  BOTS;         /* bots     */
int    HACKIT;       /* hackit   */
int    DONTADD;      /* dontadd  */
int    MSECNUM;      /* msecnum  */
float  MSECDEL;      /* msecdel  */
float  MSECVAL;      /* msecval  */



/* External vars - fixme */
extern   cvar_t   sv_gravity;
extern   cvar_t   sv_maxspeed;
extern   cvar_t   maxclients;
extern   cvar_t   maxspectators;
extern   int      sv_playermodel;
extern   int      numnails;               // sv_ents.c
extern   int      biff;


/* External functions - fixme */
extern void ED_ClearEdict(edict_t *e);
extern byte *SV_FatPVS (vec3_t org);                 // sv_ents.c
extern qboolean SV_AddNailUpdate (edict_t *ent);     // sv_ents.c
extern void SV_PreRunCmd(void);                      // sv_user.c
extern void SV_RunCmd (usercmd_t *ucmd);             // sv_user.c
extern void SV_PostRunCmd(void);                     // sv_user.c

/*-------------------------------------------------------------------------
 *
 * ED_ClientAlloc  ( was ED_Alloc in pr_edict.c )
 *
 * Either finds a free edict, or allocates a new one.
 * Try to avoid reusing an entity that was recently freed, because it
 * can cause the client to think the entity morphed into something else
 * instead of being removed and recreated, which can cause interpolated
 * angles and bad trails.
 *
 * 1999-12-29:
 * Mongoose  - Cleaned up the code
 *             Moved function here
 -------------------------------------------------------------------------*/
edict_t *ED_ClientAlloc(void)
{
   int i;
   edict_t *e;
   int clients = 0;
   client_t *cl;
 

   for (i = 0, cl = svs.clients; i < MAX_CLIENTS; i++, cl++)
   {
      if (cl->state != cs_free)
         clients++;
  
      /* if (cl->state != cs_free && cl->isabot != 1)
         return NULL; */
   }

   clients++;

   /* Mongoose: We load bots starting at the end to aviod conflicts 
                with real clients, and we can free spots for real
                clients easier as well this way. */

   for (i = clients; i < MAX_CLIENTS; i++)  
   /* for (i = MAX_CLIENTS; i > clients; i--) */
   {
      e = EDICT_NUM(i);

      /* The first couple seconds of server time can involve a lot of
         freeing and allocating, so relax the replacement policy */

      if (!((int)e->v.flags & FL_CLIENT))
      /* if (!((int)e->v.flags & FL_CLIENT) && 
          e->free && ( e->freetime < 2 || sv.time - e->freetime > 0.5 ))*/
      {
         ED_ClearEdict(e);
         return e;
      }
   }

   return NULL;

   if (i == MAX_CLIENTS + 1)
   {
      /* Con_Printf("WARNING: ED_Alloc: no free edicts\n");
         i--;   // Step on whatever is the last edict
         e = EDICT_NUM(i);
         SV_UnlinkEdict(e);  */

      return NULL;
   }
   else
      sv.num_edicts++;

   e = EDICT_NUM(i);
   ED_ClearEdict(e);

   return e;
}

/*-------------------------------------------------------------------------
 *
 * SV_WritePlayersToBot  ( was in sv_ents.c )
 *
 *
 * 1999-12-29:
 * Mongoose  - Cleaned up the code
 *             Moved function here
 -------------------------------------------------------------------------*/
void SV_WritePlayersToBot(client_t *client, edict_t *clent, 
                          byte *pvs, sizebuf_t *msg)
{
   int         i, j;
   client_t    *cl;
   edict_t      *ent;
   int         msec;
   usercmd_t   cmd;
   int         pflags;

   for (j=0,cl=svs.clients ; j<MAX_CLIENTS ; j++,cl++)
   {
      if (cl->state != cs_spawned && cl->isabot != 1)
         continue;

      ent = cl->edict;

      // ZOID visibility tracking
      if (ent != clent &&
         !(client->spec_track && client->spec_track - 1 == j)) 
      {
         if (cl->spectator)
            continue;

         // ignore if not touching a PV leaf
         for (i=0 ; i < ent->num_leafs ; i++)
            if (pvs[ent->leafnums[i] >> 3] & (1 << (ent->leafnums[i]&7) ))
               break;
         if (i == ent->num_leafs)
            continue;      // not visible
      }

      if (client->isabot == 1 && client != cl && cl->edict && cl->edict->v.health > 0 && cl->edict->v.takedamage != DAMAGE_NO) {
         vec3_t dis, dis2;

         //SV_BroadcastPrintf (2, "Bot vis check\n");
         VectorSubtract(client->edict->v.origin, cl->edict->v.origin, dis);
         if (!client->enemy && cl->edict != client->edict)
            client->enemy = cl->edict;
         else {
            VectorSubtract(client->edict->v.origin, client->enemy->v.origin, dis2);
            if (vlen2(dis) < vlen2(dis2) && cl->edict != client->edict)
               client->enemy = cl->edict;
         }
      }

      pflags = PF_MSEC | PF_COMMAND;
      
      if (ent->v.modelindex != sv_playermodel)
         pflags |= PF_MODEL;
      for (i=0 ; i<3 ; i++)
         if (ent->v.velocity[i])
            pflags |= PF_VELOCITY1<<i;
      if (ent->v.effects)
         pflags |= PF_EFFECTS;
      if (ent->v.skin)
         pflags |= PF_SKINNUM;
      if (ent->v.health <= 0)
         pflags |= PF_DEAD;
      if (ent->v.mins[2] != -24)
         pflags |= PF_GIB;

      if (cl->spectator)
      {   // only sent origin and velocity to spectators
         pflags &= PF_VELOCITY1 | PF_VELOCITY2 | PF_VELOCITY3;
      }
      else if (ent == clent)
      {   // don't send a lot of data on personal entity
         pflags &= ~(PF_MSEC|PF_COMMAND);
         if (ent->v.weaponframe)
            pflags |= PF_WEAPONFRAME;
      }

      if (client->spec_track && client->spec_track - 1 == j &&
         ent->v.weaponframe) 
         pflags |= PF_WEAPONFRAME;

      //MSG_WriteByte (msg, svc_playerinfo);
      //MSG_WriteByte (msg, j);
      //MSG_WriteShort (msg, pflags);

      //for (i=0 ; i<3 ; i++)
      //   MSG_WriteCoord (msg, ent->v.origin[i]);
      
      //MSG_WriteByte (msg, ent->v.frame);

      //if (pflags & PF_MSEC)
      //{
      //   msec = 1000*(sv.time - cl->localtime);
      //   if (msec > 255)
      //      msec = 255;
      //   MSG_WriteByte (msg, msec);
      //}
      
      if (pflags & PF_COMMAND)
      {
         cmd = cl->lastcmd;

         if (ent->v.health <= 0)
         {   // don't show the corpse looking around...
            cmd.angles[0] = 0;
            cmd.angles[1] = ent->v.angles[1];
            cmd.angles[0] = 0;
         }

         if (cl->isabot == 1) {
            cmd.angles[0] = ent->v.v_angle[0];
            cmd.angles[1] = ent->v.v_angle[1];
            cmd.angles[2] = ent->v.v_angle[2];

            if (cmd.angles[PITCH] > 80)
               cmd.angles[PITCH] = 80;
            if (cmd.angles[PITCH] < -70)
               cmd.angles[PITCH] = -70;
         }

         cmd.buttons = 0;   // never send buttons
         cmd.impulse = 0;   // never send impulses

         //MSG_WriteDeltaUsercmd (msg, &nullcmd, &cmd);
      }

/*      for (i=0 ; i<3 ; i++)
         if (pflags & (PF_VELOCITY1<<i) )
            MSG_WriteShort (msg, ent->v.velocity[i]);

      if (pflags & PF_MODEL)
         MSG_WriteByte (msg, ent->v.modelindex);

      if (pflags & PF_SKINNUM)
         MSG_WriteByte (msg, ent->v.skin);

      if (pflags & PF_EFFECTS)
         MSG_WriteByte (msg, ent->v.effects);

      if (pflags & PF_WEAPONFRAME)
         MSG_WriteByte (msg, ent->v.weaponframe);*/
   }
}

/*-------------------------------------------------------------------------
 *
 * SV_WriteEntitiesToBot  ( was in sv_ents.c )
 *
 *
 * 1999-12-29:
 * Mongoose  - Cleaned up the code
 *             Moved function here
 -------------------------------------------------------------------------*/
void SV_WriteEntitiesToBot (client_t *client, sizebuf_t *msg)
{
   int      e, i;
   byte   *pvs;
   vec3_t   org;
   edict_t   *ent;
   packet_entities_t   *pack;
   edict_t   *clent;
   client_frame_t   *frame;
   entity_state_t   *state;

   // this is the frame we are creating
   frame = &client->frames[client->netchan.incoming_sequence & UPDATE_MASK];

   // find the client's PVS
   clent = client->edict;
   VectorAdd (clent->v.origin, clent->v.view_ofs, org);
   pvs = SV_FatPVS (org);

   // send over the players in the PVS
   SV_WritePlayersToBot(client, clent, pvs, NULL);
   
   // put other visible entities into either a packet_entities or a nails message
   pack = &frame->entities;
   pack->num_entities = 0;

   numnails = 0;

   for (e=MAX_CLIENTS+1, ent=EDICT_NUM(e) ; e<sv.num_edicts ; e++, ent = NEXT_EDICT(ent))
   {
      // ignore ents without visible models
      if (!ent->v.modelindex || !*PR_GetString(ent->v.model))
         continue;

      // ignore if not touching a PV leaf
      for (i=0 ; i < ent->num_leafs ; i++)
         if (pvs[ent->leafnums[i] >> 3] & (1 << (ent->leafnums[i]&7) ))
            break;
         
      if (i == ent->num_leafs)
         continue;      // not visible

      if (SV_AddNailUpdate (ent))
         continue;   // added to the special update list

      // add to the packetentities
      if (pack->num_entities == MAX_PACKET_ENTITIES)
         continue;   // all full

      if (!client->enemy && !client->afteritem && client->item_noget < sv.time) {
         if (strcmp(PR_GetString(ent->v.model), "") != 0 && (int)ent->v.flags & FL_ITEM) {
            client->afteritem = ent;
            client->item_to = sv.time + 7;
         }
      }

      state = &pack->entities[pack->num_entities];
      pack->num_entities++;

      state->number = e;
      state->flags = 0;
      VectorCopy (ent->v.origin, state->origin);
      VectorCopy (ent->v.angles, state->angles);
      state->modelindex = ent->v.modelindex;
      state->frame = ent->v.frame;
      state->colormap = ent->v.colormap;
      state->skinnum = ent->v.skin;
      state->effects = ent->v.effects;
   }

   // encode the packet entities as a delta from the
   // last packetentities acknowledged by the client

   //SV_EmitPacketEntities (client, pack, msg);

   // now add the specialized nail update
   //SV_EmitNailUpdate (msg);
}

/*-------------------------------------------------------------------------
 *
 * SVC_DirectBotConnect  ( was in sv_main.c )
 *
 *
 * 1999-12-29:
 * Mongoose  - Cleaned up the code
 *             Moved function here
 -------------------------------------------------------------------------*/
qboolean SVC_DirectBotConnect (client_t *newcl, edict_t *botent)
{
   static      int userid;
   int         i;
   client_t    *cl;
   client_t    temp;
   int         edictnum;
   char        *s;
   int         clients, spectators;
   qboolean    spectator;
   int         qport;
   int         challenge;
   int         charnum = 0;
   char        *tempuserinfo;

   qport = 27500;

   challenge = 0;

   userid++;   // Bots all get userid 0 anyway

   newcl->userid = userid;

   clients = 0;
   spectators = 0;
   for (i = 0, cl = svs.clients ; i < MAX_CLIENTS; i++, cl++)
   {
      if (cl->state == cs_free)
         continue;
      if (cl->spectator)
         spectators++;
      else
         clients++;
   }

   if (maxclients.value > MAX_CLIENTS )
      Cvar_SetValue ("maxclients", MAX_CLIENTS);
   if (maxspectators.value > MAX_CLIENTS)
      Cvar_SetValue ("maxspectators", MAX_CLIENTS);
   if (maxspectators.value + maxclients.value > MAX_CLIENTS)
      Cvar_SetValue ("maxspectators", MAX_CLIENTS - maxspectators.value + maxclients.value);
   if ( clients >= (int)maxclients.value )
   {
      return false;
   }

   newcl = NULL;
   for (i=0,cl=svs.clients ; i<MAX_CLIENTS ; i++,cl++)
   {
      if (cl->state == cs_free)
      {
         newcl = cl;
         break;
      }
   }

   if (!newcl)
   {
      Con_Printf ("WARNING: miscounted available clients\n");
      return false;
   }

   
   edictnum = (newcl-svs.clients)+1;

   newcl->state = cs_connected;

   newcl->datagram.allowoverflow = true;
   newcl->datagram.data = newcl->datagram_buf;
   newcl->datagram.maxsize = sizeof(newcl->datagram_buf);

   newcl->edict = botent;

   tempuserinfo = GetUserInfo(newcl);
   
   while (tempuserinfo[charnum]) 
   {
      newcl->userinfo[charnum] = tempuserinfo[charnum];
      charnum++;
   }

   newcl->userinfo[charnum] = '\0';
   SV_ExtractFromUserinfo (newcl);

   for (i = 0; i < 10; i++)
      newcl->whensaid[i] = 0.0;

   newcl->whensaidhead = 0;
   newcl->lockedtill = 0;

   PR_ExecuteProgram(pr_global_struct->SetNewParms);

   for (i = 0; i < NUM_SPAWN_PARMS; i++)
      newcl->spawn_parms[i] = (&pr_global_struct->parm1)[i];

   if (newcl->spectator)
      Con_Printf("Spectator %s connected\n", newcl->name);
   else
      Con_DPrintf("Client %s connected\n", newcl->name);

   newcl->sendinfo = true;
   newcl->isabot = 1;

   return true;
}

/*-------------------------------------------------------------------------
 *
 * SetNetName
 *
 * 1999-12-29:
 * Mongoose  - Cleaned up the code
 *             Moved function here
 -------------------------------------------------------------------------*/
void SetNetName(client_t *cl, char *constname) 
{
   cl->edict->v.netname = PR_SetString(constname); //NETNAME STUFF
}

/*-------------------------------------------------------------------------
 *
 * GetUserInfo
 *
 * 1999-12-29:
 * Mongoose  - Cleaned up the code
 *             Moved function here
 -------------------------------------------------------------------------*/
char *GetUserInfo(client_t *cl) 
{
   FILE *f;
   fpos_t position;
   char buffer;
   char *readstr;
   char *netname = (char *)malloc(64);
   int netpos = 0;
   int readchar = 0;
   int filelines = 0;
   int getline = 0;

   f = fopen("bots.rc", "r");

   if (!f) 
   {
      f = fopen("bots.rc", "w");
      fprintf(f, "\\name\\Biff\\skin\\base\\topcolor\\4\\bottomcolor\\7\n");
      fprintf(f, "\\name\\7\\skin\\watchmen\\topcolor\\4\\bottomcolor\\7\n");
      fprintf(f,"\\name\\notthefatal\\skin\\wolfpak\\topcolor\\13\\bottomcolor\\6\\n");
      fprintf(f, "\\name\\Mr_WooWoo_Head\\skin\\base\\topcolor\\3\\bottomcolor\\5\n");
      fclose(f);

      cl->edict->v.netname = PR_SetString("QWBot"); //NETNAME STUFF
      return "\\*ver\\2.40-0373\\name\\Bot\\noaim\\1\\msg\\1\\rate\\4000\\bottomcolor\\0\\topcolor\\0\\skin\\base\\pmodel\\33168\\emodel\\6967\\*ip\\127.0.0.1:27500";
   }

   fgetpos(f, &position);

   readstr = Hunk_Alloc (512);

   while (!feof(f)) {
      buffer = fgetc(f);

      if (buffer == '\n')
         filelines++;
   }
   getline = BOTS;
   if (getline > filelines - 1)
      getline = rand()%filelines - 1;
   filelines = 0;
   fsetpos(f, &position);

   while (!feof(f)) {
      buffer = fgetc(f);
      if (getline == filelines) {
         fgetpos(f, &position);
         buffer = fgetc(f);
         while (buffer != '\\')
            buffer = fgetc(f);
         buffer = fgetc(f);
         while (buffer != '\\') {
            netname[netpos] = buffer;
            netpos++;
            buffer = fgetc(f);
         }
         netname[netpos] = '\0';
         fsetpos(f, &position);
         while (buffer != '\n') {
            readstr[readchar] = buffer;
            readchar++;
            buffer = fgetc(f);
         }
         break;
      }
      else {
         if (buffer == '\n')
            filelines++;
      }
   }
   readstr[readchar] = '\0';

   SetNetName(cl, netname);
   return readstr;
}

/*-------------------------------------------------------------------------
 *
 * Bot_Spawn
 *
 * 1999-12-29:
 * Mongoose  - Cleaned up the code
 *             Moved function here
 -------------------------------------------------------------------------*/
void Bot_Spawn(void) 
{
   edict_t *bot;
   int charnum = 0;
   usercmd_t ucmd;
   client_t fakeclient;
   int i = 0;
   client_t *cl;
   int clients = 0;

   bot = ED_ClientAlloc();

   if (!bot) 
   {
      SV_BroadcastPrintf(2, "Could not add bot. Server is full.\n");
      return;
   }

   bot->free = false;
   bot->v.flags = FL_CLIENT;
   bot->v.model = PR_SetString("progs/player.mdl");
   bot->v.modelindex = SV_ModelIndex("progs/player.mdl");
   bot->v.weaponmodel = PR_SetString("progs/v_shot.mdl");
   bot->v.solid = SOLID_BBOX;
   bot->v.movetype = MOVETYPE_WALK;
   bot->v.takedamage = DAMAGE_AIM;
   fakeclient.edict = bot;
   fakeclient.messagelevel = 0;
   fakeclient.sendinfo = true;

   for (i = 0, cl = svs.clients; i < MAX_CLIENTS; i++, cl++)
   {
      if (cl->state == cs_free)
         continue;
      clients++;
   }

   clients++;

   if (SVC_DirectBotConnect(&fakeclient, bot) != true) 
   {
      SV_BroadcastPrintf(2, "Could not add bot - server is full.\n");
      return;
   }

   SV_SendMessagesToAll();
   HACKIT = 1;
   fakeclient.edict->v.colormap = NUM_FOR_EDICT(fakeclient.edict);
   fakeclient.edict->v.team = 0;   // FIXME
   pr_global_struct->time = sv.time;
   pr_global_struct->self = EDICT_TO_PROG(fakeclient.edict);
   PR_ExecuteProgram (pr_global_struct->ClientConnect);

   // actually spawn the player
   pr_global_struct->time = sv.time;
   pr_global_struct->self = EDICT_TO_PROG(fakeclient.edict);
   PR_ExecuteProgram (pr_global_struct->PutClientInServer);   

   BOTS++;
}

/*-------------------------------------------------------------------------
 *
 * Bot_SpawnLevel
 *
 * 1999-12-29:
 * Mongoose  - Cleaned up the code
 *             Moved function here
 -------------------------------------------------------------------------*/
void Bot_SpawnLevel(void) 
{
   edict_t *bot;
   int charnum = 0;
   usercmd_t ucmd;
   client_t fakeclient;
   int i = 0;
   client_t *cl;
   int clients = 0;

   bot = ED_ClientAlloc();

   if (!bot) 
   {
      SV_BroadcastPrintf(2, "Could not add bot. Server is full.\n");
      return;
   }

   bot->free = false;
   bot->v.flags = FL_CLIENT;
   bot->v.model = PR_SetString("progs/player.mdl");
   bot->v.modelindex = SV_ModelIndex("progs/player.mdl");
   bot->v.weaponmodel = PR_SetString("progs/v_shot.mdl");
   bot->v.solid = SOLID_BBOX;
   bot->v.movetype = MOVETYPE_WALK;
   bot->v.takedamage = DAMAGE_AIM;
   fakeclient.messagelevel = 0;
   fakeclient.sendinfo = true;

   for (i = 0, cl = svs.clients; i < MAX_CLIENTS; i++, cl++)
   {
      if (cl->state == cs_free)
         continue;
      clients++;
   }

   clients++;

   if (SVC_DirectBotConnect (&fakeclient, bot) != true) 
   {
      SV_BroadcastPrintf (2, "Could not add bot - server is full.\n");
      return;
   }

   SV_SendMessagesToAll();
   HACKIT = 1;
   fakeclient.edict->v.colormap = NUM_FOR_EDICT(fakeclient.edict);
   fakeclient.edict->v.team = 0;   // FIXME
   pr_global_struct->time = sv.time;
   pr_global_struct->self = EDICT_TO_PROG(fakeclient.edict);
   PR_ExecuteProgram (pr_global_struct->ClientConnect);

   // actually spawn the player
   pr_global_struct->time = sv.time;
   pr_global_struct->self = EDICT_TO_PROG(fakeclient.edict);
   PR_ExecuteProgram (pr_global_struct->PutClientInServer);   
}

/*-------------------------------------------------------------------------
 *
 * vlen2
 *
 * 1999-12-29:
 * Mongoose  - Cleaned up the code
 *             Moved function here
 -------------------------------------------------------------------------*/
float vlen2(vec3_t v)
{
   return sqrt(v[0]*v[0] + v[1]*v[1] + v[2]*v[2]);
}

/*-------------------------------------------------------------------------
 *
 * vectoanglesbot
 *
 * 1999-12-29:
 * Mongoose  - Cleaned up the code
 *             Moved function here
 -------------------------------------------------------------------------*/
void vectoanglesbot(vec3_t vec, vec3_t ang)
{
   float   forward;
   float   yaw, pitch;
   
   if (vec[1] == 0 && vec[0] == 0)
   {
      yaw = 0;
      if (vec[2] > 0)
         pitch = 90;
      else
         pitch = 270;
   }
   else
   {
      yaw = (int) (atan2(vec[1], vec[0]) * 180 / M_PI);

      if (yaw < 0)
         yaw += 360;

      forward = sqrt (vec[0]*vec[0] + vec[1]*vec[1]);
      pitch = (int)(atan2(vec[2], forward) * 180 / M_PI);

      if (pitch < 0)
         pitch += 360;
   }

   ang[0] = pitch;
   ang[1] = yaw;
   ang[2] = 0;
}

/*-------------------------------------------------------------------------
 *
 * Bot_Remove
 *
 * 1999-12-29:
 * Mongoose  - Cleaned up the code
 *             Moved function here
 -------------------------------------------------------------------------*/
void Bot_Remove(client_t *thisclient) 
{
   SV_DropClient(thisclient);
   thisclient->state = cs_zombie;
   thisclient->isabot = 0;
   thisclient->enemy = NULL;
   thisclient->afteritem = NULL;

   ED_ClearEdict(thisclient->edict);
   BOTS--;
}

/*-------------------------------------------------------------------------
 *
 * Bot_RemoveLevel
 *
 * 1999-12-29:
 * Mongoose  - Cleaned up the code
 *             Moved function here
 -------------------------------------------------------------------------*/
void Bot_RemoveLevel(client_t *thisclient) 
{
   DONTADD = 1;
   SV_DropClient(thisclient);
   thisclient->state = cs_zombie;
   thisclient->isabot = 0;
   thisclient->enemy = NULL;
   thisclient->afteritem = NULL;

   ED_ClearEdict(thisclient->edict);
}

/*-------------------------------------------------------------------------
 *
 * Cmd_RemoveBot
 *
 * 1999-12-29:
 * Mongoose  - Cleaned up the code
 *             Moved function here
 -------------------------------------------------------------------------*/
void Cmd_RemoveBot(void) 
{
   client_t *cl;
   int i;

   for (i=0,cl=svs.clients ; i<MAX_CLIENTS ; i++,cl++)
   {
      if (cl->state != cs_free && cl->isabot == 1)
         break;
   }
   if (cl && cl->isabot == 1)
      Bot_Remove(cl);
}

/*-------------------------------------------------------------------------
 *
 * Bot_Think
 *
 * 1999-12-29:
 * Mongoose  - Cleaned up the code
 *             Moved function here
 -------------------------------------------------------------------------*/
void Bot_Think() 
{
   int i = 0;
   int found = 0;
   int targetdis = 0;
   int worstdis = 0;
   vec3_t product, start, end;

   
   /* Mongoose: sv.time is the number of seconds the game has gone so far */

   if (MSECDEL <= sv.time) 
   {
     MSECDEL = sv.time + 1;
  
     if (MSECNUM > 0)
         MSECVAL = 800 / MSECNUM;
 
      MSECNUM = 0;
   }
   else
      MSECNUM++;

   if (MSECVAL < 5)
      MSECVAL = 5;

   if (MSECVAL > 100)
      MSECVAL = 100;

   for (i = 0; i < MAX_CLIENTS; i++) 
   {
      if (svs.clients[i].isabot == 1) 
      {
         usercmd_t ucmd;
         client_t *thisclient;
         int stopthistime = 0;
         int charnum = 0;
         int rfact = 0;


         thisclient = &svs.clients[i];
 
         if (!thisclient)
            continue;

         if (thisclient->num_backbuf > 0)
            thisclient->num_backbuf = 0;

         if (thisclient->backbuf.cursize > 0)
            thisclient->backbuf.cursize = 0;

         found++;

         if (thisclient->state != cs_spawned)
            thisclient->state = cs_spawned;
         
         /* Mongoose: here's where the bot's gravity and speed are set */
         thisclient->entgravity = sv_gravity.value / 1000;	 
         thisclient->maxspeed = sv_maxspeed.value;

         SV_WriteEntitiesToBot(thisclient, NULL);

         if (thisclient->enemy) 
         {
            trace_t   trace;
            vec3_t trmin, trmax;

            trmax[0] = 0;
            trmax[1] = 0;
            trmax[2] = 0;

            trmin[0] = 0;
            trmin[1] = 0;
            trmin[2] = 0;

            trace = SV_Move(thisclient->edict->v.origin, trmin, trmax, 
                            thisclient->enemy->v.origin, 0, thisclient->edict);

            if (trace.fraction != 1.0 && (!(trace.ent) || 
                trace.ent != thisclient->enemy) ) 
            {
               thisclient->enemy = NULL;
            }

            if (thisclient->enemy && thisclient->enemy->v.health < 1)
               thisclient->enemy = NULL;

            if (thisclient->enemy && 
                thisclient->enemy->v.takedamage == DAMAGE_NO)
               thisclient->enemy = NULL;
         }

         if (thisclient->afteritem) 
         {
            if (thisclient->item_to < sv.time) 
            {
               thisclient->afteritem = NULL;
               thisclient->item_noget = sv.time + 5 + rand() % 5;
            }
         }

         if (thisclient->afteritem) 
         {
            trace_t   trace;
            vec3_t trmin, trmax;

            trmax[0] = 0;
            trmax[1] = 0;
            trmax[2] = 0;

            trmin[0] = 0;
            trmin[1] = 0;
            trmin[2] = 0;

            trace = SV_Move(thisclient->edict->v.origin, trmin, trmax, 
                            thisclient->afteritem->v.origin, 0, 
                            thisclient->edict);

            if (trace.fraction != 1.0 && (!(trace.ent) || 
                trace.ent != thisclient->afteritem) ) 
            {
               thisclient->afteritem = NULL;
            }

            if (thisclient->afteritem && 
                strcmp(PR_GetString(thisclient->afteritem->v.model), "") == 0)
               thisclient->afteritem = NULL;

            //ADD "DO I NEED THIS?" CHECKS HERE
         }

         if (thisclient->afteritem && !thisclient->enemy) 
         {
            end[0] = thisclient->edict->v.origin[0];
            end[1] = thisclient->edict->v.origin[1];
            end[2] = thisclient->edict->v.origin[2];

            start[0] = thisclient->afteritem->v.origin[0];
            start[1] = thisclient->afteritem->v.origin[1];
            start[2] = thisclient->afteritem->v.origin[2];

            VectorSubtract(start, end, product);

            vectoanglesbot(product, product);

            thisclient->edict->v.v_angle[YAW] = product[YAW];
            thisclient->edict->v.v_angle[PITCH] = 0;

            ucmd.angles[0] = thisclient->edict->v.v_angle[0];
            ucmd.angles[1] = thisclient->edict->v.v_angle[1];
            ucmd.angles[2] = thisclient->edict->v.v_angle[2];
            thisclient->edict->v.angles[0] = thisclient->edict->v.v_angle[0];
            thisclient->edict->v.angles[1] = thisclient->edict->v.v_angle[1];
            thisclient->edict->v.angles[2] = thisclient->edict->v.v_angle[2];
         }

         if (thisclient->enemy)
         {
            end[0] = thisclient->edict->v.origin[0];
            end[1] = thisclient->edict->v.origin[1];
            end[2] = thisclient->edict->v.origin[2];

            start[0] = thisclient->enemy->v.origin[0];
            start[1] = thisclient->enemy->v.origin[1];
            start[2] = thisclient->enemy->v.origin[2];

            VectorSubtract(start, end, product);

            /* Mongoose: Removed test AI for weapon selection
                         Make it use an axe for easier testing */
            Bot_ChangeWeapon(thisclient, IT_AXE);


            if (vlen2(product) < worstdis)
               ucmd.forwardmove = -sv_maxspeed.value;
            else if (vlen2(product) > targetdis)
               ucmd.forwardmove = sv_maxspeed.value;
            else
               ucmd.forwardmove = 0;

            if (thisclient->edict->v.weapon == IT_ROCKET_LAUNCHER) 
            {
               start[2] -= 40;
               VectorSubtract(start, end, product);
            }

            vectoanglesbot(product, product);

            if (rand()%10 < 5)
               thisclient->edict->v.v_angle[YAW] = product[YAW] + rand()%25;
            else
               thisclient->edict->v.v_angle[YAW] = product[YAW] - rand()%25;
            if (start[2] < end[2]) {
               VectorSubtract (end, start, product);
               vectoanglesbot(product, product);
            }
            else
               product[PITCH] = -product[PITCH];
            if (product[PITCH] > 80)
               product[PITCH] = 80;
            if (product[PITCH] < -70)
               product[PITCH] = -70;
            thisclient->edict->v.v_angle[PITCH] = product[PITCH];
            ucmd.angles[0] = thisclient->edict->v.v_angle[0];
            ucmd.angles[1] = thisclient->edict->v.v_angle[1];
            ucmd.angles[2] = thisclient->edict->v.v_angle[2];
            thisclient->edict->v.angles[0] = thisclient->edict->v.v_angle[0];
            thisclient->edict->v.angles[1] = thisclient->edict->v.v_angle[1];
            thisclient->edict->v.angles[2] = thisclient->edict->v.v_angle[2];
         }
         else {
            ucmd.forwardmove = sv_maxspeed.value;

            if (thisclient->turntime < sv.time) 
            {
               thisclient->roamyaw = rand()%360;

               if (thisclient->roamyaw < 0)
                  thisclient->roamyaw = 0;

               if (thisclient->roamyaw > 360)
                  thisclient->roamyaw = 360;

               thisclient->edict->v.v_angle[YAW] = thisclient->roamyaw;
               thisclient->turntime = sv.time + 1 + rand()%4;
            }
            else {
               trace_t   trace;
               vec3_t fororg, forward, right, up, yawangle;

               thisclient->edict->v.v_angle[PITCH] = 0;
               yawangle[YAW] = thisclient->edict->v.v_angle[YAW];

               AngleVectors(yawangle, forward, right, up);

               fororg[0] = thisclient->edict->v.origin[0] + forward[0]*100;
               fororg[1] = thisclient->edict->v.origin[1] + forward[1]*100;
               fororg[2] = thisclient->edict->v.origin[2] + forward[2]*100;

               trace = SV_Move(thisclient->edict->v.origin, thisclient->edict->v.mins, thisclient->edict->v.maxs, fororg, 0, thisclient->edict);

               if (trace.fraction != 1.0) {
                  thisclient->roamyaw = rand()%360;
                  thisclient->edict->v.v_angle[YAW] = thisclient->roamyaw;
               }
            }

            ucmd.angles[0] = thisclient->edict->v.v_angle[0];
            ucmd.angles[1] = thisclient->edict->v.v_angle[1];
            ucmd.angles[2] = thisclient->edict->v.v_angle[2];
            thisclient->edict->v.angles[0] = thisclient->edict->v.v_angle[0];
            thisclient->edict->v.angles[1] = thisclient->edict->v.v_angle[1];
            thisclient->edict->v.angles[2] = thisclient->edict->v.v_angle[2];
         }
         ucmd.upmove = 0;

         if (thisclient->enemy && thisclient->edict->v.weapon != IT_AXE) {
            if (thisclient->strafedir == 1)
               ucmd.sidemove = sv_maxspeed.value;
            else
               ucmd.sidemove = -sv_maxspeed.value;

            if (thisclient->strafetime < sv.time) {
               if (thisclient->strafedir == 1)
                  thisclient->strafedir = 0;
               else
                  thisclient->strafedir = 1;
               thisclient->strafetime = sv.time + 0.5 + rand()%2;
            }
         }
         else
            ucmd.sidemove = 0;

         if (thisclient->enemy)
            ucmd.buttons = 1;
         else
            ucmd.buttons = 0;

         if (thisclient->edict->v.health < 1) 
         {
            if (rand() % 10 < 3)
               ucmd.buttons = 1;
            else
               ucmd.buttons = 0;
         }

         if (stopthistime == 1)
            ucmd.buttons = 0;

         ucmd.msec = 10;

         thisclient->delta_sequence = -1;
         thisclient->chokecount = 0;

         if (thisclient->edict->v.weapon == IT_AXE)
            rfact = 18;
         else
            rfact = 10;

         if (rand() % rfact < 3 && 
             (int)thisclient->edict->v.flags & FL_ONGROUND && 
             thisclient->jumptime < sv.time && thisclient->enemy)
         {
            ucmd.buttons += 2;
            thisclient->jumptime = sv.time + rand() % 5;
         }
         else if (ucmd.buttons & 2)
            ucmd.buttons -= 2;

         sv_player = thisclient->edict;
         host_client = thisclient;

         SV_PreRunCmd();
         SV_RunCmd(&ucmd);
         SV_PostRunCmd(); //h4h4h4h4h4h
      }
   }
   //SV_BroadcastPrintf (2, "Bots found: %i\n", found);
}


void Bot_ChangeWeapon(client_t *client, int weapon_flag)
{
   switch(weapon_flag)
   {
   case IT_LIGHTNING:
   case IT_ROCKET_LAUNCHER:
   case IT_GRENADE_LAUNCHER:
   case IT_SUPER_NAILGUN:
   case IT_SUPER_SHOTGUN:
   case IT_NAILGUN:
   case IT_SHOTGUN:
   case IT_AXE:

      if (client->edict->v.weapon != weapon_flag)
         Bot_SV_Say("%s: I'm switching to weapon[%i].\n", 
                    client->name, weapon_flag);

      client->edict->v.weapon = weapon_flag;
      break;
   default:
      Bot_SV_Say("%s: I don't understand how to use weapon[%i]!\n", 
                 client->name, weapon_flag);
   };
}

void Bot_SV_Say(char *s, ...)
{
   va_list    args;
   char       buffer[2048];
   client_t   *client;
   int        i;

   va_start(args, s);
   vsprintf(buffer, s, args);
   va_end(args);

   Sys_Printf("%s", buffer);

   for (i = 0, client = svs.clients; i < MAX_CLIENTS; i++, client++)
   {
      if (client->state != cs_spawned)
         continue;

      if (client->isabot == 1)
         continue;

      SV_ClientPrintf(client, PRINT_CHAT, "%s", buffer);
   }
}



///////////////////////////////////////////////////////////////////////////
// FIXME: Make these work *after pulling them out
//        We have abstraction as priority, not test ai  
#ifdef ENABLE_TEST_AI
void Bot_AI_Move()
{
   /* Mongoose: Run Forward   +sv_maxspeed.value
                Run Backward  -sv_maxspeed.value
                Stand         0 */
   ucmd.forwardmove = -sv_maxspeed.value;


   /* Mongoose: Strafe Left   -sv_maxspeed.value
                Strafe Right  +sv_maxspeed.value */
   ucmd.sidemove = sv_maxspeed.value;



   /* Mongoose: Jump        +sv_maxspeed.value
                Crouch      -sv_maxspeed.value
                Stand       0

                Crouching will be added to the engine */
   ucmd.upmove = 0;
}

void  Bot_AI_ChooseBestWeapon(vec3_t product)
{
   if (vlen2(product) < 220 && 
       (((int)thisclient->edict->v.items & IT_LIGHTNING && 
         thisclient->edict->v.ammo_cells > 0) || 
       ((int)thisclient->edict->v.items & IT_SUPER_NAILGUN && 
                  thisclient->edict->v.ammo_nails > 1) || 
                 ((int)thisclient->edict->v.items & IT_SUPER_SHOTGUN && 
                  thisclient->edict->v.ammo_shells > 1) ) && 
                 ((int)thisclient->edict->v.weapon == IT_ROCKET_LAUNCHER || 
                  thisclient->edict->v.weapon == IT_GRENADE_LAUNCHER)) 
                {
                   if ((int)thisclient->edict->v.items & IT_LIGHTNING && 
                       thisclient->edict->v.ammo_cells > 0)
                      thisclient->edict->v.weapon = IT_LIGHTNING;
                   else if ((int)thisclient->edict->v.items & IT_SUPER_NAILGUN &&
                            thisclient->edict->v.ammo_nails > 1)
                      thisclient->edict->v.weapon = IT_SUPER_NAILGUN;
                   else if ((int)thisclient->edict->v.items & IT_SUPER_SHOTGUN && 
                            thisclient->edict->v.ammo_shells > 1)
                      thisclient->edict->v.weapon = IT_SUPER_SHOTGUN;
                }
            if (vlen2(product) > 260 && thisclient->enemy->v.origin[2] <= thisclient->edict->v.origin[2] && ((int)thisclient->edict->v.items & IT_ROCKET_LAUNCHER && thisclient->edict->v.ammo_rockets > 0 && thisclient->edict->v.weapon != IT_ROCKET_LAUNCHER)) {
               stopthistime = 1;
               thisclient->edict->v.weapon = IT_ROCKET_LAUNCHER;
            }

            if (vlen2(product) < 900 && thisclient->enemy->v.origin[2] > thisclient->edict->v.origin[2] + 100 && ((int)thisclient->edict->v.items & IT_LIGHTNING && thisclient->edict->v.ammo_cells > 0)) {
               thisclient->edict->v.weapon = IT_LIGHTNING;
            }

            if (thisclient->edict->v.weapon == IT_ROCKET_LAUNCHER || thisclient->edict->v.weapon == IT_GRENADE_LAUNCHER || (thisclient->edict->v.weapon != IT_ROCKET_LAUNCHER && (int)thisclient->edict->v.items & IT_ROCKET_LAUNCHER && thisclient->edict->v.ammo_rockets > 0)) {
               targetdis = 450;
               worstdis = 400;
            }
            else if (thisclient->edict->v.weapon == IT_AXE)
            {
               targetdis = 10;
               worstdis = 25;
            }
            else {
               targetdis = 125;
               worstdis = 75;
            }
}
#endif
