#!/usr/local/bin/perl
##
## maps.pl
## This package exists so that all user-configurable defaults can be set in one
## package and then used by all of the QstatList packages.
##
## David G. Hesprich (Dark Grue)
## darkgrue@iname.com
## Last Revision: February 22, 1999
##
## QstatList is Copyright (c) 1999 David G. Hesprich (Dark Grue).
##
## This program is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by the
## Free Software Foundation; either version 2 of the License, or (at your
## option) any later version.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License along
## with this program; if not, write to the Free Software Foundation, Inc.,
## 675 Mass Ave, Cambridge, MA 02139, USA.
##


## Be pragmatic.
##
use strict 'vars';


## ============================================================================
## ============================================================================
##
## PUBLIC VARIABLES
##

use vars qw(
  %Map
);

# Map table; translate map BSP names into map title.
# DO NOT FORGET TO ESCAPE SPECIAL CHARACTERS!
%Map = (
  # Hexen II
  'demo1',	"Blackmarsh",
  'demo2',	"Barbican",
  'demo3',	"The Mill",
  'village1',	"Kings Court",
  'village2',	"Inner Courtyard",
  'village3',	"Stable",
  'village4',	"Pallace Entrance",
  'village5',	"The Forgotten Chapel",
  'rider1a',	"Famine's Domain",
  'meso1',	"The Palace of Columns",
  'meso2',	"Plaza of the Sun",
  'meso3',	"Square of the Stream",
  'meso4',	"Tome of the High Priest",
  'meso5',	"Obelisk of the Moon",
  'meso6',	"Court of the 1000 Warriors",
  'meso7',	"??????????????",
  'meso8',	"Bridge of Stars",
  'meso9',	"Well of Souls",
  'egypt1',	"Temple of Horus",
  'egypt2',	"Ancient Temple of Nefertum",
  'egypt3',	"Temple of Nefertum",
  'egypt4',	"Palace of the Pharaoh",
  'egypt5',	"Pyramid of Anubis",
  'egypt6',	"Temple of Light",
  'egypt7',	"Shrine of Naos",
  'rider2c',	"Pestilence's Lair",
  'romeric1',	"The Hall of Heroes",
  'romeric2',	"Gardens of Athena",
  'romeric3',	"Forem of Zeus",
  'romeric4',	"Baths of Demetrius",
  'romeric5',	"Temple of Mars",
  'romeric6',	"Coliseum of Mars",
  'romeric7',	"Reflecting Pool",
  'cath',	"Cathedral",
  'tower',	"Tower of the Dark Mage",
  'castle4',	"The Underhalls",
  'castle5',	"Eidolon's Ordeal",
  'eidolion',	"Eidolon's Lair",
  'ravdm1',	"Atrium of Immolation",
  'ravdm2',	"Total Carnage",
  'ravdm3',	"Reckless Abandon",
  'ravdm4',	"Temple of RA",
  'ravdm5',	"Tom Foolery",

  # id Quake Shareware
  'start',	"Introduction",
  'e1m1',	"Slipgate Complex",
  'e1m2',	"Castle Of The Damned",
  'e1m3',	"The Necropolis",
  'e1m4',	"The Grisly Grotto",
  'e1m5',	"Gloom Keep",
  'e1m6',	"The Door To Chthon",
  'e1m7',	"The House Of Chthon",
  'e1m8',	"Ziggurat Vertigo",

  # id Quake Registered
  'e2m1',	"The Installation",
  'e2m2',	"The Ogre Citadel",
  'e2m3',	"The Crypt Of Decay",
  'e2m4',	"The Ebon Fortress",
  'e2m5',	"The Wizard's Manse",
  'e2m6',	"The Dismal Oubliette",
  'e2m7',	"Underearth",
  'e3m1',	"Termination Central",
  'e3m2',	"The Vaults Of Zin",
  'e3m3',	"The Tomb Of Terror",
  'e3m4',	"Satan's Dark Delight",
  'e3m5',	"Wind Tunnels",
  'e3m6',	"Chambers Of Torment",
  'e3m7',	"The Haunted Halls",
  'e4m1',	"The Sewage System",
  'e4m2',	"The Tower Of Despair",
  'e4m3',	"The Elder God Shrine",
  'e4m4',	"The Palace Of Hate",
  'e4m5',	"Hell's Atrium",
  'e4m6',	"The Pain Maze",
  'e4m7',	"Azure Agony",
  'e4m8',	"The Nameless City",
  'end',	"Shub-Niggurath's Pit",
  'dm1',	"Place Of Two Deaths",
  'dm2',	"Claustrophobopolis",
  'dm3',	"The Abandoned Base",
  'dm4',	"The Bad Place",
  'dm5',	"The Cistern",
  'dm6',	"The Dark Zone",
  'dm7',	"Aracnophobia",

  # Quake Mission Pack 1 - Scourge of Armagon
  'hip1m1',	"Pumping Station",
  'hip1m2',	"Storage Facility",
  'hip1m3',	"The Lost Mine",
  'hip1m4',	"Research Facility",
  'hip1m5',	"Military Complex",
  'hip2m1',	"Ancient Realms",
  'hip2m2',	"The Black Cathedral",
  'hip2m3',	"The Catacombs",
  'hip2m4',	"The Crypt",
  'hip2m5',	"Mortum's Keep",
  'hip2m6',	"The Gremlin's Domain",
  'hip3m1',	"Tur Torment",
  'hip3m2',	"Pandemonium",
  'hip3m3',	"Limbo",
  'hip3m4',	"The Gauntlet",
  'hipend',	"Armagon's Lair",
  'hipdm1',	"The Edge Of Oblivion",

  # Quake Mission Pack 2 - Dissolution of Eternity
  'r1m1',	"Deviant's Domain",
  'r1m2',	"Dread Portal",
  'r1m3',	"Judgement Call",
  'r1m4',	"Cave Of Death",
  'r1m5',	"Towers Of Wrath",
  'r1m6',	"Temple Of Pain",
  'r1m7',	"Tomb Of The Overlord",
  'r2m1',	"Tempus Fugit",
  'r2m2',	"Elemental Fury I",
  'r2m3',	"Elemental Fury II",
  'r2m4',	"Curse Of Osiris",
  'r2m5',	"Wizard's Keep",
  'r2m6',	"Blood Sacrifice",
  'r2m7',	"Last Bastion",
  'r2m8',	"Source Of Evil",

  # Threewave CTF
  'ctfstart',	"CTF Introduction",
  'ctf1',	"McKinley Base",
  'ctf2',	"The Kiln",
  'ctf3',	"Dysphoria",
  'ctf4',	"The Forgotten Mines",
  'ctf5',	"Da Ancient War Grounds",
  'ctf6',	"Vertigo",
  'ctf7',	"Tale Of Two Cities",
  'ctf8',	"The Strongbox",
  'ctf2m1',	"McKinley Station",
  'ctf2m2',	"The Warzone",
  'ctf2m3',	"Spill the Blood",
  'ctf2m4',	"The Ruins Of NeoMinonk",
  'ctf2m5',	"Disciple War Grounds",
  'ctf2m6',	"The Two Towers",
  'ctf2m7',	"Gloom Castles",
  'ctf2m8',	"Capturephobopolis",

  # Quake II
  'base1',	"Outer Base",
  'base2',	"Installation",
  'base3',	"Comm Center",
  'biggun',	"Big Gun",
  'boss1',	"Inner Chamber",
  'boss2',	"Final Showdown",
  'bunk1',	"Ammo Depot",
  'city1',	"Outer Courts",
  'city2',	"Lower Palace",
  'city3',	"Upper Palace",
  'command',	"Launch Command",
  'cool1',	"Cooling Facility",
  'fact1',	"Receiving Center",
  'fact2',	"Processing Plant",
  'fact3',	"Sudden Death",
  'hangar1',	"Outer Hangar",
  'hangar2',	"Inner Hangar",
  'jail1',	"Main Gate",
  'jail2',	"Detention Center",
  'jail3',	"Security Complex",
  'jail4',	"The Torture Chambers",
  'jail5',	"Guard House",
  'lab',	"Research Lab",
  'mine1',	"Upper Mines",
  'mine2',	"Borehole",
  'mine3',	"Drilling Area",
  'mine4',	"Lower Mines",
  'mintro',	"Mine Entrance",
  'power1',	"Power Plant",
  'power2',	"The Reactor",
  'security',	"Grid Control",
  'space',	"Comm Satellite",
  'strike',	"Outlands",
  'train',	"Lost Station",
  'ware1',	"Supply Station",
  'ware2',	"Warehouse",
  'waste1',	"Toxic Waste Dump",
  'waste2',	"Pumping Station 1",
  'waste3',	"Pumping Station 2",

  # Quake II Point Release
  'q2dm1',	"The Edge",
  'q2dm2',	"Tokay's Towers",
  'q2dm3',	"The Fray Pipe",
  'q2dm4',	"Lost Hallways",
  'q2dm5',	"The Pits",
  'q2dm6',	"Lava Tomb",
  'q2dm7',	"The Slimy Place",
  'q2dm8',	"WareHouse",

  # Quake II Mega DM
  'base64',	"MegaBase 64",
  'city64',	"MegaCity 64",
  'sewer64',	"MegaSewer 64",
  'base100',	"MegaBase 100",

  # Quake II Mission Pack 1 - The Reckoning
  'badlands',	"Badlands",
  'industry',	"Industrial Facility",
  'outbase',	"Outer Base",
  'refinery',	"Refinery",
  'w_treat',	"Water Treatment Plant",
  'xcompnd1',	"Outer Compound",
  'xcompnd2',	"Inner Compound",
  'xdm1',	"Munitions Dump",
  'xdm2',	"Deadly Reckoning",
  'xdm3',	"Reservoir Stroggs",
  'xdm4',	"The Sludge Pit",
  'xdm5',	"Stomping Grounds",
  'xdm6',	"Hidden Agenda",
  'xdm7',	"XEdge",
  'xhangar1',	"Lower Hangars",
  'xhangar2',	"The Hangar",
  'xintell',	"Intelligence Center",
  'xmoon1',	"Cargo Bay",
  'xmoon2',	"Command Center",
  'xreactor',	"Core Reactor",
  'xsewer1',	"Sewers",
  'xsewer2',	"Waste Sieve",
  'xship',	"Strogg Freighter",
  'xswamp',	"The Swamps",
  'xware',	"The Warehouse",

  # Quake II Mission Pack 2 - Ground Zero
  'rammo1',	"Munitions Plant",
  'rammo2',	"Ammo Depot",
  'rbase1',	"Logistics Complex",
  'rbase2',	"Tactical Command",
  'rboss',	"Widow's Lair",
  'rdm1',	"The Low Road",
  'rdm10',	"Great Divide",
  'rdm11',	"Dish It Out",
  'rdm12',	"Fall From Grace",
  'rdm13',	"Roads To Nowhere",
  'rdm14',	"Rogue's Edge",
  'rdm2',	"The High Road",
  'rdm3',	"Boxed In",
  'rdm4',	"Razor Close",
  'rdm5',	"Stone Hinge",
  'rdm6',	"Nexus",
  'rdm7',	"Sewer Citadel",
  'rdm8',	"Styx and Stones",
  'rdm9',	"Scenic Overlook",
  'rhangar1',	"Research Hangar",
  'rhangar2',	"Maintenance Hangars",
  'rlava1',	"Thaelite Mines",
  'rlava2',	"Tectonic Stabilizer",
  'rmine1',	"Lower Mines",
  'rmine2',	"Mine Engineering",
  'rsewer1',	"Waste Processing",
  'rsewer2',	"Waste Disposal",
  'runit2',	"runit2",
  'runit3',	"runit3",
  'runit4',	"runit4",
  'rware1',	"Eastern Warehouse",
  'rware2',	"Waterfront Storage",

  # Quake II CTF
  'q2ctf1',	"McKinley Revival",
  'q2ctf2',	"Stronghold Opposition",
  'q2ctf3',	"The Smelter",
  'q2ctf4',	"Outlands",
  'q2ctf5',	"Capture Showdown",
);

1;  # THIS LINE MUST BE LAST -- DO NOT CHANGE IT
