#!/usr/local/bin/perl
##
## html.pl
## This package exists so that all user-configurable defaults can be set in one
## package and then used by all of the QstatList packages.
##
## David G. Hesprich (Dark Grue)
## darkgrue@iname.com
## Last Revision: February 22, 1999
##
## QstatList is Copyright (c) 1999 David G. Hesprich (Dark Grue).
##
## This program is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by the
## Free Software Foundation; either version 2 of the License, or (at your
## option) any later version.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License along
## with this program; if not, write to the Free Software Foundation, Inc.,
## 675 Mass Ave, Cambridge, MA 02139, USA.
##


## ============================================================================
## ============================================================================
##
## PRIVATE SUBROUTINES
##

## Closure: Compute ceiling.
my($ceil) = sub ($) {
  my($floatvalue) = shift();

  my($integervalue) = int($floatvalue);

  $integervalue++ if ($integervalue < $floatvalue);

  return($integervalue);
};


## Closure: Encode query string.
my($encode) = sub ($) {
  my($string) = shift();

  $string =~ s/(\W)/sprintf("%%%x", ord($1))/eg;

  return($string);
};


## Closure: Create page header.
my($make_page_header) = sub () {
  my($stest) = 0;

  # Generate valid DOCTYPE for page testing purposes.
  print(sfh "<!DOCTYPE HTML PUBLIC \"-//Microsoft//DTD Internet Explorer 3.0 HTML//EN\">\n\n");

  print(sfh <<End_of_Here);
<HTML>
<HEAD>
<TITLE>$SERVERTYPE{$servertype} Server List</TITLE>
<META NAME="Generated-By" CONTENT="QstatList v$QSTATLIST_VERSION">
<META NAME="robots" CONTENT="none">
End_of_Here

  # Generate valid EXPIRES for caching/proxy purposes.
  return_meta_expires($Time, $lastrun, sfh);

  print(sfh <<End_of_Here);
</HEAD>
<BODY BGCOLOR="#000000" TEXT="#FFFFFF" LINK="#FF3300" VLINK="#FF3300" ALINK="#66CC33">
<TABLE BORDER="0" WIDTH="100%">
<TR>
<TD ROWSPAN="3" VALIGN="MIDDLE" WIDTH="$TITLE_PIC_WIDTH">$TITLE_PIC</TD>
<TD ROWSPAN="3" WIDTH="10"></TD>
End_of_Here

  # Page numbering.
  print(sfh "<TD NOWRAP=\"NOWRAP\"><FONT SIZE=\"+3\" COLOR=\"#FFFFFF\">$SERVERTYPE{$servertype} Server List");
  print(sfh "<BR>(Page $pageno of $pagemax)") if ($pagemax > 1);
  print(sfh "</FONT></TD>\n</TR>");

  print(sfh <<End_of_Here);
<TR>
<TD NOWRAP="NOWRAP" VALIGN="TOP">
  <UL>
  <LI><A HREF="#add">Add A Server</A></LI>
  <LI><A HREF="#info">List Information</A></LI>
  <LI><A HREF="#key">Key to List</A></LI>
  </UL></TD>
</TR>
End_of_Here

  # Server jump bar.
  print(sfh "<TR><TD VALIGN=\"TOP\" ALIGN=\"CENTER\"><B>[ ");
  foreach (sort(@DOLIST)) {
    print(sfh "| ") if ($stest);

    $stest = 1;

    if ($_ eq $servertype) {
      print(sfh "<FONT COLOR=\"#BBBBBB\">", join('&nbsp;', split(/ /, $SERVERTYPE{$_})), "</FONT> ");
    }
    else {
      print(sfh "<A HREF=\"$URL_BASE/$_-1.html\">", join('&nbsp;', split(/ /, $SERVERTYPE{$_})), "</A> ");
    }
  }
  print(sfh "]</B>");
  if (($COLLECT_STATS) && (-r "$STATSDIR")) {
    print(sfh "<BR><BR><B>&lt; <A HREF=\"$STATSDIR_REL/index.html\">QstatList Statistics</A> &gt;</B>");
  }
  print(sfh "</TD>\n</TR>\n</TABLE>\n<HR>\n");
  print(sfh "<FONT SIZE=\"-4\"><A HREF=\"#bottom\">Jump to Bottom of Table</A></FONT>\n");
  print(sfh "<P><BR></P>\n");
};


## Closure: Create table header.
my($make_table_header) = sub () {
  print "    Writing QStat table to HTML page...\n" if ($DEBUG >= 2);	# debug info
									# debug info
  # Calculate date.
  print(sfh "<P ALIGN=\"CENTER\"><FONT SIZE=\"+1\">Last updated: ", scalar(localtime($Time)) , "</FONT></P>\n");

  if ($is_qm_only) {
    # Lists containing only Master servers get a different heading block.
    print(sfh <<End_of_Here);
<CENTER>
<TABLE BORDER="1" CELLPADDING="4">
<TR>
<TD ALIGN="CENTER" NOWRAP="NOWRAP"$bghcolor><FONT SIZE="-1"><B>Type</B></FONT></TD>
<TD NOWRAP="NOWRAP"$bghcolor><B>CNAME /<BR>IP Address:Port</B></TD>
<TD NOWRAP="NOWRAP"$bghcolor><B>Location</B></TD>
<TD NOWRAP="NOWRAP"$bghcolor><B>Response</B></TD>
</TR>
End_of_Here

  }
  elsif ($is_qw_only) {
    # Lists containing only QuakeWorld servers get a different heading block.
    print(sfh <<End_of_Here);
<CENTER>
<TABLE BORDER="1" CELLPADDING="4">
<TR>
<TD ALIGN="CENTER" NOWRAP="NOWRAP"$bghcolor><FONT SIZE="-1"><B>Type</B></FONT></TD>
<TD NOWRAP="NOWRAP"$bghcolor><B>CNAME /<BR>IP Address:Port</B></TD>
<TD NOWRAP="NOWRAP"$bghcolor><B>Location</B></TD>
<TD NOWRAP="NOWRAP"$bghcolor><B>Hostname</B></TD>
<TD NOWRAP="NOWRAP"$bghcolor><FONT SIZE="-1"><B>Game /<BR>Map</B></FONT></TD>
<TD NOWRAP="NOWRAP"$bghcolor><FONT SIZE="-1"><B>Players</B></FONT></TD>
<TD NOWRAP="NOWRAP"$bghcolor><FONT SIZE="-1"><B>Ping</B></FONT></TD>
</TR>
End_of_Here

  }
  elsif ($is_uns_only) {
    # Lists containing only Unreal servers get a different heading block.
    print(sfh <<End_of_Here);
<CENTER>
<TABLE BORDER="1" CELLPADDING="4">
<TR>
<TD ALIGN="CENTER" NOWRAP="NOWRAP"$bghcolor><FONT SIZE="-1"><B>Type</B></FONT></TD>
<TD NOWRAP="NOWRAP"$bghcolor><B>CNAME /<BR>IP Address:qPort/hPort</B></TD>
<TD NOWRAP="NOWRAP"$bghcolor><B>Location</B></TD>
<TD NOWRAP="NOWRAP"$bghcolor><B>Hostname</B></TD>
<TD NOWRAP="NOWRAP"$bghcolor><FONT SIZE="-1"><B>Gametype /<BR>Map</B></FONT></TD>
<TD NOWRAP="NOWRAP"$bghcolor><FONT SIZE="-1"><B>Players</B></FONT></TD>
</TR>
End_of_Here

  }
  else {
    print(sfh <<End_of_Here);
<CENTER><TABLE BORDER="1" CELLPADDING="4">
<TR>
<TD ALIGN="CENTER" NOWRAP="NOWRAP"$bghcolor><FONT SIZE="-1"><B>Type</B></FONT></TD>
<TD NOWRAP="NOWRAP"$bghcolor><B>CNAME /<BR>IP Address:Port</B></TD>
<TD NOWRAP="NOWRAP"$bghcolor><B>Location</B></TD>
<TD NOWRAP="NOWRAP"$bghcolor><B>Hostname</B></TD>
<TD NOWRAP="NOWRAP"$bghcolor><B>Map</B></TD>
<TD NOWRAP="NOWRAP"$bghcolor><FONT SIZE="-1"><B>Players</B></FONT></TD>
<TD NOWRAP="NOWRAP"$bghcolor><FONT SIZE="-1"><B>Ping</B></FONT></TD>
</TR>
End_of_Here

  }
};


## Closure: Create a new HTML page.
my($make_new_page) = sub () {
  my($file) = "$basedir/$servertype-$pageno.html";

  print "  Getting HTML page output file $file for write operation...\n" if ($DEBUG >= 2);	# debug info
  open(sfh, ">$file") || die("Can't write to file '$file': $!\n");

  print "  Writing to file...\n" if ($DEBUG >= 2);			# debug info
    
  # Reset counter.
  $rowcount = 0;

  &$make_page_header();
  &$make_table_header();
};


## Closure: Create table footer.
my($make_table_footer) = sub () {
  # Mark bottom of table.
  print(sfh "</TABLE>\n<A NAME=\"bottom\"></A></CENTER>\n");
									# debug info
  if ($DEBUG >= 2) {							# debug info
    print "    Wrote $rowcount records on page $pageno.\n";		# debug info
    print "  Finished.\n";						# debug info
  }									# debug info
};


## Closure: Create page footer and close file.
my($make_page_footer) = sub () {
  print(sfh "<P><BR></P>\n");

  # Generate page "jump bar", if warranted.
  if ($pagemax > 1) {
    print(sfh "<CENTER>\n<TABLE BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\">\n<TR>\n");

    # Insert "previous" button if there is at least one previous page.
    print(sfh "<TD ALIGN=\"CENTER\"><A HREF=\"$URL_BASE/$servertype-", $pageno - 1, ".html\">$PREV_PIC</A><BR><FONT FACE=\"ARIAL\" SIZE=\"-2\">", $pageno - 1, "</FONT></TD>\n") if ($pageno > 1);

    foreach my $i (1 .. $pagemax) {
      if ($i == $pageno) {
        # Current page.
        print(sfh "<TD ALIGN=\"CENTER\">$DOTBOX_PIC<BR><FONT FACE=\"ARIAL\" SIZE=\"-2\">$i</FONT></TD>\n");
      }
      else {
        # Other page.
        print(sfh "<TD ALIGN=\"CENTER\"><A HREF=\"$URL_BASE/$servertype-", $i, ".html\">$BOX_PIC</A><BR><FONT FACE=\"ARIAL\" SIZE=\"-2\">$i</FONT></TD>\n");
      }
    }

    # Insert "next" button if there is another page.
    print(sfh "<TD ALIGN=\"CENTER\"><A HREF=\"$URL_BASE/$servertype-", $pageno + 1, ".html\">$NEXT_PIC</A><BR><FONT FACE=\"ARIAL\" SIZE=\"-2\">", $pageno + 1, "</FONT></TD>\n") if (($pagemax - $pageno) > 0);
    print(sfh "</TR>\n</TABLE>\n</CENTER>\n<P><BR></P>\n");
  }

  # Generate page tail.
  print(sfh <<End_of_Here);
<HR WIDTH="80%" ALIGN="CENTER">
<H2><A NAME="add">Add A Server</A></H2>
<P>If you want to add a server go to the
  <A HREF="$CGI_URL_BASE/addqserver.cgi?$servertype-$pageno">Add A Server</A>
  page.  You will need to know either the fully qualified domain name (FQDN) or
  the IP address of the server.  The server must be in operation and responding
  to queries in order to be added.  Corrections that need to be made to the list
  should be sent to the list maintainer at
  <A HREF="mailto:$LIST_MAINTAINER">$LIST_MAINTAINER</A>.</P>
<P><BR></P>
<H2><A NAME="info">List Information</A></H2>
<P>This list is generated and maintained using
  <A HREF="$QSTATLIST_URL">QstatList</A>, a publicly-available set of Perl
  scripts written by <A HREF="$AUTHOR_URL">David "Dark Grue" Hesprich</A>,
  which work in conjunction with Steve Jankowski's
  <A HREF="$QSTAT_URL">QStat</A> software.</P>
<P>This list is updated every few minutes.  In order to keep our list current,
  any servers that have been down for $TIMEOUT days consecutively are
  automatically removed from the list database.</P>
<P>Performance on these servers is going to be mostly dependant on your
  connection and how much (and how fast) core network equipment is between
  you and the server.  Most of the regularly up servers are T1 or better,
  with fairly significant system resources, so you may wish to look closer to
  home when diagnosing performance problems.</P>
<P><BR></P>
<H2><A NAME="key">Key to List</A></H2>
<P>The table contains the following infomation about Quake servers listed in
  the database:</P>
<UL>
<LI><B>Server Type:</B> The type of server.  The following types are recognized
  by QStat:
  <UL>
End_of_Here

  foreach (sort(@DOLIST)) {
    print(sfh "<LI><EM><FONT");
    print(sfh " COLOR=\"$BGH{$_}\"") if (defined($BGH{$_}));
    print(sfh ">$_</FONT></EM> - $SERVERTYPE{$_}</LI>\n");
  }

  print(sfh <<End_of_Here);
  </UL></LI>
<LI><B>Server Address:</B>
  <UL>
  <LI><EM>CNAME</EM> - This is the canonical name of the server as reported by
    the DNS.</LI>
  <LI><EM>IP Address</EM> - The IP address of the server provided for players
    who don't have domain name services working.  The list is sorted on this
    field.</LI>
  <LI><EM>Port</EM> - Service port number.</LI>
  </UL>These items are linked to "live" detailed information on the current
  server and player status.</LI>
<LI><B>Location:</B> The physical location of the server in the Real
  World&reg;.</LI>
<LI><B>Hostname:</B> The name returned from the server itself.</LI>
<LI><B>Game (QuakeWorld and Quake II only):</B> The game in play.</LI>
<LI><B>Map:</B> name of level running on the server.</LI>
<LI><B>Players:</B> The current number of players and player maximum. Green
  indicates that the server has less than eight players. Yellow indicates that
  more than eight players are on the server (in which case all IPX or TCP/IP
  connections may be in use) or that the server is half-full. Red indicates
  that the server is full.</LI>
</UL>
End_of_Here

  # Generate page footer.
  return_html_tail(\*sfh);

  close(sfh);
};


## Closure: Create QStat data table.
my($make_table) = sub () {
  local(*sfh);

  local($count) = 0;		# Number of records for $servertype.
  local($rowcount) = 0;		# Number of records on page $pageno.

  local($pageno) = 1;		# Page counter.
  local($pagemax);		# Total number of pages.

  # ADD SERVERTYPES HERE
  local($is_qm_only) = ($servertype =~ /^$ST_QM_PAT$/);
  local($is_qw_only) = ($servertype =~ /^$ST_QW_PAT$/);
  local($is_uns_only) = ($servertype eq 'UNS');

  local($bghcolor);

  # Set background highlight color.
  if (defined($BGH{$servertype})) {
    $bghcolor = " BGCOLOR=\"$BGH{$servertype}\"";
  }
  else {
    undef($bghcolor);
  }

  # Calculate $pagemax.
  if ($INCLUDE_UNRESPONSIVE) {
    $pagemax = &$ceil($Rstats{$servertype}{'servers'} / $MAX_HOSTS_PER_PAGE);
  }
  else {
    $pagemax = &$ceil($Rstats{$servertype}{'actservers'} / $MAX_HOSTS_PER_PAGE);
  }

  # Iterate through all records of type $servertype.
  foreach my $id (sort(keys(%{$Hosts{$servertype}}))) {
    # Skip bogus iterations through hash.
    next if (!defined($Hosts{$servertype}{$id}));
    next if ($Hosts{$servertype}{$id}{'remove'} > $INCLUDE_UNRESPONSIVE);

    # Handle maximum page length.
    if (($MAX_HOSTS_PER_PAGE > 0) && ($rowcount == $MAX_HOSTS_PER_PAGE)) {
      # Complete page assembly.
      &$make_table_footer();
      &$make_page_footer();

      # Set next page.
      $pageno++;
      $rowcount = 0;
    }

    # ROW TYPE
    # Print the "unresponsive server" row text.
    if ($Hosts{$servertype}{$id}{'remove'} == 1) {
      if ($rowcount == 0) {
        # Create new page.
        &$make_new_page();
      }

      print(sfh "<TR>");
      print(sfh "<TD VALIGN=\"MIDDLE\" ALIGN=\"CENTER\" NOWRAP=\"NOWRAP\"$bghcolor>$servertype</TD>");
      print(sfh "<TD NOWRAP=\"NOWRAP\">");
      print(sfh "<A HREF=\"$CGI_URL_BASE/qstatwrap.cgi?", &$encode($servertype . " " . $id . " " . $Hosts{$servertype}{$id}{'locale'}) , "\">") if ($QSTATWRAP_UNRESPONSIVE);
      if ($id !~ /^$Hosts{$servertype}{$id}{'cname'}/) {
        print(sfh "<FONT SIZE=\"-2\">$Hosts{$servertype}{$id}{'cname'}</FONT><BR>");
      }
      print(sfh "$id");
      if (defined($Hosts{$servertype}{$id}{'hostport'})) {
        print(sfh "/$Hosts{$servertype}{$id}{'hostport'}");
      }
      print(sfh "</A>") if ($QSTATWRAP_UNRESPONSIVE);
      print(sfh "</TD>");
      print(sfh "<TD><FONT SIZE=\"-1\">$Hosts{$servertype}{$id}{'locale'}</FONT></TD>");
      if ($is_qm_only) {
        # Lists containing only Master servers get a different row text block.
        print(sfh "<TD NOWRAP=\"NOWRAP\">");
      }
      elsif ($is_uns_only) {
        # Lists containing only Unreal servers get a different row text block.
        print(sfh "<TD COLSPAN=\"3\" NOWRAP=\"NOWRAP\">");
      }
      else {
        print(sfh "<TD COLSPAN=\"4\" NOWRAP=\"NOWRAP\">");
      }
      print(sfh "<FONT COLOR=\"#FFFF00\">No response from server.</FONT></TD>");
      print(sfh "</TR>\n");

      # Increment record counters.
      $count++;
      $rowcount++;

      next;
    }

    # ROW TYPE
    # Print the Master server row text.
    if ($servertype =~ /^$ST_QM_PAT$/) {
      if ($rowcount == 0) {
        # Create new page.
        &$make_new_page();
      }

      print(sfh "<TR>");
      print(sfh "<TD VALIGN=\"MIDDLE\" ALIGN=\"CENTER\" NOWRAP=\"NOWRAP\"$bghcolor>$servertype</TD>");
      print(sfh "<TD NOWRAP=\"NOWRAP\">");
      if ($id !~ /^$Hosts{$servertype}{$id}{'cname'}/) {
        print(sfh "<FONT SIZE=\"-2\">$Hosts{$servertype}{$id}{'cname'}</FONT><BR>");
      }
      print(sfh "$id</TD>");
      print(sfh "<TD><FONT SIZE=\"-1\">$Hosts{$servertype}{$id}{'locale'}</FONT></TD>");
      if ($is_qm_only) {
        # Lists containing only Master servers get a different row text block.
        print(sfh "<TD NOWRAP=\"NOWRAP\">Number of known servers: $Hosts{$servertype}{$id}{numservers}</TD>");
      }
      else {
        print(sfh "<TD COLSPAN=\"4\" NOWRAP=\"NOWRAP\">Number of known servers: $Hosts{$servertype}{$id}{numservers}</TD>");
      }
      print(sfh "</TR>\n");

      # Increment record counters.
      $count++;
      $rowcount++;

      next;
    }
    # ROW TYPE
    # Print the Unreal server row text.
    if ($servertype eq 'UNS') {
      if ($rowcount == 0) {
        # Create new page.
        &$make_new_page();
      }

      print(sfh "<TR>");
      print(sfh "<TD VALIGN=\"MIDDLE\" ALIGN=\"CENTER\" NOWRAP=\"NOWRAP\"$bghcolor>$servertype</TD>");
      print(sfh "<TD NOWRAP=\"NOWRAP\"><A HREF=\"$CGI_URL_BASE/qstatwrap.cgi?" , &$encode($servertype . " " . $id . " " . $Hosts{$servertype}{$id}{'locale'}) , "\">");
      if ($id !~ /^$Hosts{$servertype}{$id}{'cname'}/) {
        print(sfh "<FONT SIZE=\"-2\">$Hosts{$servertype}{$id}{'cname'}</FONT><BR>");
      }
      print(sfh "$id");
      if (defined($Hosts{$servertype}{$id}{'hostport'})) {
        print(sfh "/$Hosts{$servertype}{$id}{'hostport'}");
      }
      print(sfh "</A></TD>");
      print(sfh "<TD><FONT SIZE=\"-1\">$Hosts{$servertype}{$id}{'locale'}</FONT></TD>");

      # Split up the hostname to keep the table width reasonable.
      if (length($Hosts{$servertype}{$id}{'hostname'}) > 16) {
        # Convert underscores to spaces to allow word wrapping.
        $Hosts{$servertype}{$id}{'hostname'} =~ s/_/ /g;
      }
      print(sfh "<TD><FONT SIZE=\"-1\">$Hosts{$servertype}{$id}{'hostname'}</FONT></TD>");

      print(sfh "<TD NOWRAP=\"NOWRAP\"><FONT SIZE=\"-1\">");
      if (defined($Hosts{$servertype}{$id}{'game'})) {
        print(sfh "$Hosts{$servertype}{$id}{'game'}<BR>");
      }
      print(sfh "<I>$Hosts{$servertype}{$id}{'mapname'}</I></FONT></TD>");

      print(sfh "<TD><FONT SIZE=\"-1\">$Hosts{$servertype}{$id}{'players'}</FONT></TD>");
      if (!$is_uns_only) {
        # Lists containing only Unreal servers get a different row text block.
        print(sfh "<TD><FONT SIZE=\"-1\">N/A</FONT></TD>");
      }
      print(sfh "</TR>\n");

      # Increment record counters.
      $count++;
      $rowcount++;

      next;
    }
    else {
      # ROW TYPE
      # Print the "POQS (Plain Old Quake Server)", QuakeWorld, and Quake II row text.
      if ($rowcount == 0) {
        # Create new page.
        &$make_new_page();
      }

      print(sfh "<TR>");
      print(sfh "<TD VALIGN=\"MIDDLE\" ALIGN=\"CENTER\" NOWRAP=\"NOWRAP\"$bghcolor>$servertype</TD>");
      print(sfh "<TD NOWRAP=\"NOWRAP\"><A HREF=\"$CGI_URL_BASE/qstatwrap.cgi?" , &$encode($servertype . " " . $id . " " . $Hosts{$servertype}{$id}{'locale'}) , "\">");
      if ($id !~ /^$Hosts{$servertype}{$id}{'cname'}/) {
        print(sfh "<FONT SIZE=\"-2\">$Hosts{$servertype}{$id}{'cname'}</FONT><BR>");
      }
      print(sfh "$id</A></TD>");
      print(sfh "<TD><FONT SIZE=\"-1\">$Hosts{$servertype}{$id}{'locale'}</FONT></TD>");

      # Split up the hostname to keep the table width reasonable.
      if (length($Hosts{$servertype}{$id}{'hostname'}) > 16) {
        # Convert underscores to spaces to allow word wrapping.
        $Hosts{$servertype}{$id}{'hostname'} =~ s/_/ /g;
      }
      print(sfh "<TD><FONT SIZE=\"-1\">$Hosts{$servertype}{$id}{'hostname'}</FONT></TD>");

      print(sfh "<TD NOWRAP=\"NOWRAP\"><FONT SIZE=\"-1\">");
      if (defined($Hosts{$servertype}{$id}{'game'})) {
        print(sfh "$Hosts{$servertype}{$id}{'game'}<BR>");
      }
      print(sfh "<I>$Hosts{$servertype}{$id}{'mapname'}</I></FONT></TD>");

      print(sfh "<TD NOWRAP=\"NOWRAP\" BGCOLOR=\"");
      if ($Hosts{$servertype}{$id}{'players'} == $Hosts{$servertype}{$id}{'maxplayers'}) {
        # server is full, red
        print(sfh "#FF0000");
      }
      elsif (($Hosts{$servertype}{$id}{'players'} >= ($Hosts{$servertype}{$id}{'maxplayers'} / 2)) && ($Hosts{$servertype}{$id}{'players'} >= 8)) {
        # server is half-full or out of IPX connections, yellow
        print(sfh "#FFFF00");
      }
      else {
        # server is OK, green
        print(sfh "#66FF33");
      }
      print(sfh "\"><FONT COLOR=\"#000000\" SIZE=\"-1\">$Hosts{$servertype}{$id}{'players'} of $Hosts{$servertype}{$id}{'maxplayers'}</FONT></TD>");
      print(sfh "<TD NOWRAP=\"NOWRAP\"><FONT SIZE=\"-1\">$Hosts{$servertype}{$id}{'avgping'}</FONT></TD>");
      print(sfh "</TR>\n");

      # Increment record counters.
      $count++;
      $rowcount++;
    }
  }

  # Print "empty list" table.
  if ($rowcount == 0) {
    # Create new page.
    &$make_new_page();

    print(sfh "<TR>");
    print(sfh "<TD VALIGN=\"MIDDLE\" ALIGN=\"CENTER\" NOWRAP=\"NOWRAP\"$bghcolor>$WARNING_PIC</TD>");
    if ($is_qm_only) {
      # Lists containing only Master servers get a different row text block.
      print(sfh "<TD VALIGN=\"MIDDLE\" COLSPAN=\"3\" NOWRAP=\"NOWRAP\">No data found.</TD>");
    }
    elsif ($is_uns_only) {
      # Lists containing only Unreal servers get a different row text block.
      print(sfh "<TD VALIGN=\"MIDDLE\" COLSPAN=\"3\" NOWRAP=\"NOWRAP\">No data found.</TD>");
    }
    else {
      print(sfh "<TD VALIGN=\"MIDDLE\" COLSPAN=\"6\" NOWRAP=\"NOWRAP\">No data found.</TD>");
    }
    print(sfh "</TR>\n");
  }

  # Complete page assembly.
  &$make_table_footer();
  &$make_page_footer();
									# debug info
  if ($DEBUG) {								# debug info
    print "\n" if ($debug >= 2);					# debug info
    print "  Wrote $count total records on $pageno pages(s).\n";	# debug info
    print "Done.\n";							# debug info
  }									# debug info
};


## ============================================================================
## ============================================================================
##
## MAIN
##

sub do_HTML {
  local(*DIR);

  local($basedir) = $LIST_BASEDIR;
  local($lastrun) = (-M "$basedir/$DODEFAULT-1.html") * 86400;
  local($servertype);

  # Create the HTML listings.
  print "\n<-- HTML page generation starting. -->\n" if ($DEBUG);	# debug info
									# debug info
  # Check the index.
  if (eval("symlink('', '');"), $@ eq '') {
    unless (readlink("$LIST_BASEDIR/index.html") eq "./$DODEFAULT-1.html") {
      unlink("$LIST_BASEDIR/index.html");
      symlink("./$DODEFAULT-1.html", "$LIST_BASEDIR/index.html");
      print "Created new index symbolic link.\n" if ($DEBUG);		# debug info
    }
  }
  else {
    # Log it.
    write_log("WARNING: symbolic links not supported. Can't check or create index.");
  }

  # Get list of old HTML files.
  opendir(DIR, "$basedir") || die("$!\n");
  my(@datafiles) = grep((!/^(?:\.\.?|index\.html)$/ && /\.html$/), readdir(DIR));
  closedir(DIR);

  # Iterate through all $servertype and generate HTML page sets.
  foreach $servertype (@DOLIST) {
    # Unlink old HTML files as we start to write each group.
    foreach (@datafiles) {
      unlink("$basedir/$_") if (/$servertype-\d+\.html$/);
    }

    # Work from the center out.
    print "\nCreating HTML page output files for \"$servertype\" servers...\n" if ($DEBUG);	# debug info
    &$make_table();
  }
									# debug info
  print "\n<-- HTML page generation finished. -->\n" if ($DEBUG);	# debug info
}

1;  # THIS LINE MUST BE LAST -- DO NOT CHANGE IT
