/*
 *  GoodBot - autonomous client side Quake2 robot
 *  Copyright (C) 1998 Jens Vaasjo <jvaasjo@iname.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _VECTOR_H
#define _VECTOR_H

typedef struct
{
	float x;
	float y;
	float z;
} vector;

vector vec_mk(float x,float y,float z);
float vec_len(vector v);
vector vec_neg(vector v);
vector vec_normalize(vector v);
vector vec_add(vector a,vector b);
vector vec_sub(vector a,vector b);
vector vec_mul(vector v,float f);
vector vec_cross(vector a,vector b);
float vec_dot(vector a,vector b);

#endif /*ndef _VECTOR_H*/
