/*
 *  GoodBot - autonomous client side Quake2 robot
 *  Copyright (C) 1998 Jens Vaasjo <jvaasjo@iname.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include<config.h>
#endif

#include<math.h>
#include"vector.h"

vector vec_mk(float x,float y,float z)
{
	vector v;

	v.x = x;
	v.y = y;
	v.z = z;

	return v;
}

float vec_len(vector v)
{
	return sqrt(v.x * v.x + v.y * v.y + v.z * v.z);
}

vector vec_neg(vector v)
{
	return vec_mul(v,-1.0);
}

vector vec_normalize(vector v)
{
	float len = vec_len(v);

	return vec_mk(v.x / len,v.y / len,v.z / len);
}

vector vec_add(vector a,vector b)
{
	return vec_mk(a.x + b.x,a.y + b.y,a.z + b.z);
}

vector vec_sub(vector a,vector b)
{
	return vec_add(a,vec_neg(b));
}

vector vec_mul(vector v,float f)
{
	return vec_mk(f * v.x,f * v.y,f * v.z);
}

vector vec_cross(vector a,vector b)
{
	return vec_mk(a.y*b.z - b.y*a.z,a.z*b.x - b.z*a.x,a.x*b.y - b.x*a.y);
}

float vec_dot(vector a,vector b)
{
	return a.x * b.x + a.y * b.y + a.z * b.z;
}

