/*
 *  GoodBot - autonomous client side Quake2 robot
 *  Copyright (C) 1998 Jens Vaasjo <jvaasjo@iname.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _SHARED_H
#define _SHARED_H

#include"vector.h"
#include"msgdefs.h"

typedef struct
{
	int valid;
	vector origin;
	vector angles;
	vector velocity;
	unsigned modelindex;
	unsigned long skinnum;
	unsigned mframe;
	double last;
} edict;

typedef struct
{
	vector origin;
	vector velocity;
	vector angles;
	unsigned gun_index;
	short stats[MAX_STATS];
} playerinfo;

/*derived from q2source-3.14/game/q_shared.h 484-492*/
typedef struct
{
	unsigned char buttons;
	vector angles;
	vector move;
} usercmd_t;

typedef struct
{
	double ping;
	playerinfo player_info;
	edict edicts[MAX_EDICTS];
	char *configs[MAX_CONFIGSTRINGS];
	void (*scc)(void*,char*);
	void *scc_arg;
	void (*smn)(void*,char*);
	void *smn_arg;
} shared_data;

#endif /*ndef _SHARED_H*/
