/*
 *  GoodBot - autonomous client side Quake2 robot
 *  Copyright (C) 1998 Jens Vaasjo <jvaasjo@iname.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _PROTOCOL_H
#define _PROTOCOL_H

#include"buffer.h"
#include"msgdefs.h"
#include"shared.h"

struct packet_node
{
	buffer *buf;
	unsigned long seq;
	struct packet_node *next;
};
typedef struct packet_node packet;

typedef enum
{
	PRE_CHALLENGE,
	POST_CHALLENGE,
	PRE_CONNECT,
	POST_CONNECT,
	POST_SYN,
	PRE_GAME,
	IN_GAME,
	POST_GAME,
	PRE_GAME_OVER,
	GAME_OVER
} game_state;

typedef struct
{
	char *host;
	char *addr;
	unsigned short port;
	char *name;
	unsigned long rate;
	int sock;
	packet *need_ack;
	usercmd_t last_updates[3];
	double pinglast;
	double need_ack_last;
	game_state level;
	char *challenge;
	unsigned short qport;
	unsigned long seq;
	unsigned long last_seq;
	unsigned long frame_num;
	unsigned long delta_frame;
	edict baseline[MAX_EDICTS];
	edict *oldframes[16];
	unsigned long oldframe_nums[16];
	vector delta_angles;
	shared_data *shared;
} protocol;

protocol *protocol_init(char *name,unsigned long rate,
			char *host,unsigned short port,shared_data *shared);
void protocol_free(protocol *state);

void protocol_connect(protocol *state);
void protocol_disconnect(protocol *state);

void protocol_update(protocol *state);

void protocol_send_player_update(protocol *state,usercmd_t update);
void protocol_send_user_info(protocol *state,char *str);
void protocol_send_console_command(protocol *state,char *str);

int protocol_getstate(protocol *state);

#endif /*ndef _PROTOCOL_H*/
