/*
 *  GoodBot - autonomous client side Quake2 robot
 *  Copyright (C) 1998 Jens Vaasjo <jvaasjo@iname.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include<config.h>
#endif

#include<stdio.h>
#include<stdlib.h>

#ifdef HAVE_STRING_H
#include<string.h>
#endif

#ifdef HAVE_STRINGS_H
#include<strings.h>
#endif

#include<errno.h>

#ifdef HAVE_UNISTD_H
#include<unistd.h>
#endif

#ifdef HAVE_SYS_TIME_H
#include<sys/time.h>
#endif

#include<sys/types.h>
#include<sys/socket.h>

#ifdef HAVE_SYS_SELECT_H
#include<sys/select.h>
#endif

#include<netinet/in.h>
#include<arpa/inet.h>
#include<netdb.h>
#include"buffer.h"
#include"misc.h"
#include"net.h"

static struct in_addr getaddr(char *host);

static struct in_addr getaddr(char *host)
{
	struct hostent *hostinfo;
	struct in_addr addr;

	if(inet_aton(host,&addr)) return addr;

retry_gethostbyname:
	hostinfo = gethostbyname(host);
	if(!hostinfo)
	{
		if(h_errno == TRY_AGAIN) goto retry_gethostbyname;
		herror(host);
		exit(2);
	}

	memset(&(addr.s_addr),0,sizeof(addr.s_addr));
	memcpy((char*)&(addr.s_addr)+sizeof(addr.s_addr)-hostinfo->h_length,
					hostinfo->h_addr,hostinfo->h_length);

	return addr;
}

int sock_init(char *host,unsigned short port,char **addr)
{
	struct sockaddr_in sin;
	int sock;

	sock = socket(AF_INET,SOCK_DGRAM,0);
	if(sock == -1)
	{
		perror("socket");
		exit(2);
	}

	sin.sin_family = AF_INET;
	sin.sin_port = 0;
	sin.sin_addr.s_addr = INADDR_ANY;

	if(bind(sock,(struct sockaddr*)&sin,sizeof(sin)))
	{
		perror("bind");
		exit(2);
	}

	sin.sin_family = AF_INET;
	sin.sin_port = htons(port);
	sin.sin_addr = getaddr(host);

	if(connect(sock,(struct sockaddr*)&sin,sizeof(sin)))
	{
		perror("connect");
		exit(2);
	}

	if(addr) (*addr) = xstrdup(inet_ntoa(sin.sin_addr));

	return sock;
}

buffer *sock_recv(int sock)
{
	unsigned char mem[64*1024];
	struct timeval timeout;
	buffer *buf;
	fd_set fds;
	int c;

	timeout.tv_sec  = 1;
	timeout.tv_usec = 0;

retry_select:
	FD_ZERO(&fds);
	FD_SET(sock,&fds);

	c = select(sock+1,&fds,NULL,NULL,&timeout);
	if(c == 0) return NULL;
	else if(c != 1)
	{
		if(errno == EINTR) goto retry_select;
		perror("select");
		exit(2);
	}

retry_recv:
	c = recv(sock,(void*)mem,sizeof(mem),0);
	if(c <= 0)
	{
		if(errno == EINTR) goto retry_recv;
		perror("recv");
		exit(2);
	}

	buf = newbuffer();
	putmem(buf,mem,c);
	return buf;
}

void sock_send(int sock,buffer *buf)
{
	unsigned long size = getsize(buf);

retry_send:
	if(send(sock,(void*)getdata(buf),size,0) != size)
	{
		if(errno == EINTR) goto retry_send;
		perror("send");
		exit(2);
	}
}

void sock_free(int sock)
{
	if(close(sock))
	{
		perror("close");
		exit(2);
	}
}

