/*
 *  GoodBot - autonomous client side Quake2 robot
 *  Copyright (C) 1998 Jens Vaasjo <jvaasjo@iname.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _MSGDEFS_H
#define _MSGDEFS_H

#define PROTOCOL_VERSION	31
#define HIDDEN_BIT		0x80000000

#define Q_PI            32767.0
#define MAX_VELOCITY    400.0

#define BUTTON_ATTACK   0x01
#define BUTTON_USE      0x02
#define BUTTON_ANY      0x80

enum
{
	CLIENT_BAD,
	CLIENT_NOP,
	CLIENT_PLAYER_UPDATE,
	CLIENT_USER_INFO,
	CLIENT_CONSOLE_COMMAND
};

enum
{
	SERVER_BAD,
	SERVER_MUZZLE_FLASH,
	SERVER_MUZZLE_FLASH2,
	SERVER_TEMP_ENTITY,
	SERVER_LAYOUT,
	SERVER_INVENTORY,
	SERVER_NOP,
	SERVER_DISCONNECT,
	SERVER_RECONNECT,
	SERVER_SOUND,
	SERVER_PRINT,
	SERVER_STUFF_TEXT,
	SERVER_SERVER_DATA,
	SERVER_CONFIG_STRING,
	SERVER_SPAWN_BASELINE,
	SERVER_CENTER_PRINT,
	SERVER_DOWNLOAD,
	SERVER_PLAYER_INFO,
	SERVER_PACKET_ENTITIES,
	SERVER_DELTA_PACKET_ENTITIES,
	SERVER_FRAME
};


/*taken from q2source-3.14/game/q_shared.h 758-788*/
enum
{
	TE_GUNSHOT,
	TE_BLOOD,
	TE_BLASTER,
	TE_RAILTRAIL,
	TE_SHOTGUN,
	TE_EXPLOSION1,
	TE_EXPLOSION2,
	TE_ROCKET_EXPLOSION,
	TE_GRENADE_EXPLOSION,
	TE_SPARKS,
	TE_SPLASH,
	TE_BUBBLETRAIL,
	TE_SCREEN_SPARKS,
	TE_SHIELD_SPARKS,
	TE_BULLET_SPARKS,
	TE_LASER_SPARKS,
	TE_PARASITE_ATTACK,
	TE_ROCKET_EXPLOSION_WATER,
	TE_GRENADE_EXPLOSION_WATER,
	TE_MEDIC_CABLE_ATTACK,
	TE_BFG_EXPLOSION,
	TE_BFG_BIGEXPLOSION,
	TE_BOSSTPORT, 
	TE_BFG_LASER,
	TE_GRAPPLE_CABLE,
	TE_WELDING_SPARKS,
	TE_PLASMATRAIL,
	TE_GREENBLOOD
};

/*taken from q2source-3.14/game/q_shared.h 820-837*/
enum
{
	STAT_HEALTH_ICON,
	STAT_HEALTH,
	STAT_AMMO_ICON,
	STAT_AMMO,
	STAT_ARMOR_ICON,
	STAT_ARMOR,
	STAT_SELECTED_ICON,
	STAT_PICKUP_ICON,
	STAT_PICKUP_STRING,
	STAT_TIMER_ICON,
	STAT_TIMER,
	STAT_HELPICON,
	STAT_SELECTED_ITEM,
	STAT_LAYOUTS,
	STAT_FRAGS,
	STAT_FLASHES
};

/*taken from q2source-3.14/game/q_shared.h 59-65*/
#define MAX_CLIENTS		256
#define MAX_EDICTS		1024
#define MAX_LIGHTSTYLES		256
#define MAX_MODELS		256
#define MAX_SOUNDS		256
#define MAX_IMAGES		256
#define MAX_ITEMS		256

#define MAX_STATS		32

/*taken from q2source-3.14/game/q_shared.h 875-891*/
#define CS_NAME			0
#define CS_CDTRACK		1
#define CS_SKY			2
#define CS_SKYAXIS		3
#define CS_SKYROTATE		4
#define CS_STATUSBAR		5
#define CS_MAXCLIENTS		30
#define CS_MAPCHECKSUM		31
#define CS_MODELS		32
#define CS_SOUNDS		(CS_MODELS+MAX_MODELS)
#define CS_IMAGES		(CS_SOUNDS+MAX_SOUNDS)
#define CS_LIGHTS		(CS_IMAGES+MAX_IMAGES)
#define CS_ITEMS		(CS_LIGHTS+MAX_LIGHTSTYLES)
#define CS_PLAYERSKINS		(CS_ITEMS+MAX_ITEMS)
#define MAX_CONFIGSTRINGS	(CS_PLAYERSKINS+MAX_CLIENTS)


#endif /*ndef _MSGDEFS_H*/
