/*
 *  GoodBot - autonomous client side Quake2 robot
 *  Copyright (C) 1998 Jens Vaasjo <jvaasjo@iname.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _MISC_H
#define _MISC_H

#include<math.h>

#ifndef M_PI
#define M_PI	(3.14159265358979323846)
#endif

void *xmalloc(unsigned long size);
void *xrealloc(void *ptr,unsigned long size);
void *xcalloc(unsigned long nmemb,unsigned long size);

char *getline(void);
char *xstrdup(char *str);
char *va_strcat(char *first,...);
char **delim_to_array(char *str,char tok);

char *stristr(char *haystack,char *needle);
void strip_head_space(char **str);
void strip_tail_space(char *str);
void strlower(char *str);

double gettime(void);
void regsigs(RETSIGTYPE (*handler)(int));

#endif /*ndef _MISC_H*/
