/*
 *  GoodBot - autonomous client side Quake2 robot
 *  Copyright (C) 1998 Jens Vaasjo <jvaasjo@iname.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include<config.h>
#endif

#include<stdio.h>
#include<stdlib.h>

#ifdef HAVE_STRING_H
#include<string.h>
#endif

#ifdef HAVE_STRINGS_H
#include<strings.h>
#endif

#include<errno.h>
#include"misc.h"
#include"buffer.h"
#include"buffile.h"

buffer *buf_fread(char *path,FILE *stream,
	unsigned long offset,unsigned long count)
{
	buffer *buf=NULL;
	void *mem;

	if(fseek(stream,offset,SEEK_SET))
	{
		fprintf(stderr,"%s: fseek: %s\n",path,strerror(errno));
		return NULL;
	}

	mem = xmalloc(count);

	errno = 0;
	if(fread(mem,1,count,stream) == count)
	{
		buf = newbuffer();
		buf->getp = 0;
		buf->putp = count;
		buf->size = count;
		buf->maxs = count;
		buf->data = mem;
		return buf;
	}

	if(errno) fprintf(stderr,"%s: fread: %s\n",path,strerror(errno));
	else fprintf(stderr,"%s: fread: unexpected end of file\n",path);

	free(mem);
	return NULL;
}

