/*
 *  GoodBot - autonomous client side Quake2 robot
 *  Copyright (C) 1998 Jens Vaasjo <jvaasjo@iname.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _BUFFER_H
#define _BUFFER_H

typedef struct
{
	unsigned long getp;
	unsigned long putp;
	unsigned long size;
	unsigned long maxs;
	unsigned char *data;
} buffer;

buffer *newbuffer(void);
void freebuffer(buffer *buf);

unsigned long getsize(buffer *buf);
unsigned char *getdata(buffer *buf);

void bufgseek(buffer *buf,long off);
void bufpseek(buffer *buf,long off);

unsigned long bufgetgpos(buffer *buf);
void bufsetgpos(buffer *buf,unsigned long off);

unsigned long bufgetppos(buffer *buf);
void bufsetppos(buffer *buf,unsigned long off);

void getmem(buffer *buf,void *mem,unsigned long count);
void putmem(buffer *buf,void *mem,unsigned long count);

void reset(buffer *buf);

char *getstr(buffer *buf);
void putstr(buffer *buf,char *s);
void putnstr(buffer *buf,char *s);

unsigned char getu8(buffer *buf);
void putu8(buffer *buf,unsigned char v);

char gets8(buffer *buf);
void puts8(buffer *buf,char v);

unsigned short getLEu16(buffer *buf);
void putLEu16(buffer *buf,unsigned short v);

short getLEs16(buffer *buf);
void putLEs16(buffer *buf,short v);

unsigned long getLEu32(buffer *buf);
void putLEu32(buffer *buf,unsigned long v);

long getLEs32(buffer *buf);
void putLEs32(buffer *buf,long v);

float getLEf32(buffer *buf);
void putLEf32(buffer *buf,float v);

#endif /*ndef _BUFFER_H*/
