/*
 *  GoodBot - autonomous client side Quake2 robot
 *  Copyright (C) 1998 Jens Vaasjo <jvaasjo@iname.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _BSP_H
#define _BSP_H

#include"vector.h"

typedef struct
{
	vector normal;
	float dist;
} plane_t;

typedef struct
{
	unsigned long plane;
	long c1;
	long c2;
} node_t;

typedef struct
{
	unsigned long contents;
} leaf_t;

typedef struct
{
	plane_t *planes;
	node_t *nodes;
	leaf_t *leafs;
} bsp;

bsp *bsp_load(char *name,char **path);
void bsp_free(bsp *map);

int bsp_isvisible(bsp *map,vector p1,vector p2);

#endif /*ndef _BSP_H*/
