/*
 *  GoodBot - autonomous client side Quake2 robot
 *  Copyright (C) 1998 Jens Vaasjo <jvaasjo@iname.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include<config.h>
#endif

#include<stdio.h>
#include<stdlib.h>

#ifdef HAVE_STRING_H
#include<string.h>
#endif

#ifdef HAVE_STRINGS_H
#include<strings.h>
#endif

#include<time.h>
#include"misc.h"
#include"protocol.h"
#include"ai.h"
#include"bot.h"

static unsigned quit = 0;

static RETSIGTYPE sig_handler(int signum)
{
	(void)signum;

	quit++;
	regsigs(NULL);

#if RETSIGTYPE != void
	return 0;
#endif
}

static void proc_console(protocol *state,ai *ai_state)
{
	char *line;

	line = getline();
	if(!line) return;

	if(strncmp(line,"gb_",3))
	{
		protocol_send_console_command(state,line);
	}
	else
	{
		ai_proc_console_command(ai_state,line);
	}

	free(line);
}

int bot(char **path,char *name,unsigned long rate,
			char *host,unsigned short port)
{
	shared_data *shared;
	protocol *state;
	ai *ai_state;

	srand(time(NULL));
	regsigs(sig_handler);

	shared = (shared_data*)calloc(1,sizeof(shared_data));
	state = protocol_init(name,rate,host,port,shared);
	ai_state = ai_init(shared,path);

	protocol_connect(state);

	while((!quit) && (protocol_getstate(state) <= 0))
	{
		protocol_update(state);
		protocol_send_player_update(state,ai_getmove(ai_state));

		proc_console(state,ai_state);
	}

	protocol_disconnect(state);

	ai_free(ai_state);
	protocol_free(state);
	free(shared);

	return 0;
}

