// Construction Tools for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"
#include <math.h>

void MakeSectorDoor(int num)    // ignore "num"
{
  // standard door creation:
  int       i, j, SectorNum, Sides = 0,
            Sector1 = Nothing, Sector2 = Nothing,
            LineDef1 = Nothing, LineDef2 = Nothing,
            dx, dy, LineLength1, LineLength2;
  double    ddx, ddy;
  char      DoorTexture1[10], DoorTexture2[10];

  for(SectorNum = 0; SectorNum < SectorsNum; SectorNum++)
    if(eSector[SectorNum].Used &&
       eSector[SectorNum].Selected) {
      Sides = 0;        // clear for this door:
      Sector1 = Nothing;
      Sector2 = Nothing,
      LineDef1 = Nothing;
      LineDef2 = Nothing;
      
      for(i = 0; i < SideDefsNum; i++)
        if(eSideDef[i].Used &&
           (SideDef[i].sector == SectorNum))
          Sides++;
    
      if(Sides != 4) {
        ErrorMessage(IDS_DOORFOURSIDES);
        return;
        }
      
      for(i = 0; i < LineDefsNum; i++) {
        if(!eLineDef[i].Used)
          continue;
        if((LineDef[i].sidedef1 != Nothing) &&
           (SideDef[LineDef[i].sidedef1].sector == SectorNum) &&
           (LineDef[i].sidedef2 != Nothing))  
          if(Sector1 == Nothing) {
            Sector1 = SideDef[LineDef[i].sidedef2].sector;
            LineDef1 = i;
            }
          else {
            Sector2 = SideDef[LineDef[i].sidedef2].sector;
            LineDef2 = i;
            }
        if((LineDef[i].sidedef2 != Nothing) &&
           (SideDef[LineDef[i].sidedef2].sector == SectorNum))
          if(Sector1 == Nothing) {
            Sector1 = SideDef[LineDef[i].sidedef1].sector;
            LineDef1 = i;
            }
          else {
            Sector2 = SideDef[LineDef[i].sidedef1].sector;
            LineDef2 = i;
            }
        }   // next i
      // Sector1 and Sector2 now contain two sector numbers which border this door.
      // LineDef1 and LineDef2 contain the linedefs for these borders.
      if((Sector1 == Nothing) || (Sector2 == Nothing)) {
        ErrorMessage(IDS_DOORSANDWICH);
        return;
        }
      if(Sector[Sector1].floorZ != Sector[Sector2].floorZ) {
        ErrorMessage(IDS_DOORFLOORS);
        return;
        }
      dx=abs(Vertex[LineDef[LineDef1].to].x -
             Vertex[LineDef[LineDef1].from].x);
      ddx = (double)dx;
      dy=abs(Vertex[LineDef[LineDef1].to].y -
             Vertex[LineDef[LineDef1].from].y);
      ddy = (double)dy;
      if(dx==0 && dy==0)
        LineLength1 = 0;
      else
        LineLength1 = (int)sqrt(ddx*ddx + ddy*ddy);
      if(LineLength1 < 65)
        { CopyWall(DoorTexture1, "DOOR3"); }
      else  
        { CopyWall(DoorTexture1, "BIGDOOR2"); }
      dx=abs(Vertex[LineDef[LineDef2].to].x -
             Vertex[LineDef[LineDef2].from].x);
      ddx = (double)dx;
      dy=abs(Vertex[LineDef[LineDef2].to].y -
             Vertex[LineDef[LineDef2].from].y);
      ddy = (double)dy;
      if(dx==0 && dy==0)
        LineLength2 = 0;
      else
        LineLength2 = (int)sqrt(ddx*ddx + ddy*ddy);
      if(LineLength2 < 65)
        { CopyWall(DoorTexture2, "DOOR3"); }
      else  
        { CopyWall(DoorTexture2, "BIGDOOR2"); }
      // null term strings for the dialog box ahead:
      DoorTexture1[8] = '\0';
      DoorTexture2[8] = '\0';
      // floors are same height.
      // adjust the Sides to be DOORTRAK, pegged
      for(i=0; i<SideDefsNum; i++)
        if((i != Sector1) && (i != Sector2) &&
           (SideDef[i].sector == SectorNum)) {
          NullWall(SideDef[i].t1)
          NullWall(SideDef[i].t2)
          CopyWall(SideDef[i].t3, "DOORTRAK");
          for(j=0; j<LineDefsNum; j++)
            if(eLineDef[j].Used &&
               (LineDef[j].sidedef1 == i)) {
              LineDef[j].solidity |= ML_DONTPEGBOTTOM;  // unpeg the texture
              break;                                    // out of loop
              }
          } // done adjusting doortrak
      // set the floor and ceiling heights the same:
      Sector[SectorNum].ceilZ = Sector[Sector1].floorZ;
      Sector[SectorNum].floorZ = Sector[Sector1].floorZ;
      if(IsWindowVisible(hwndDialogSector))
        PutValueInFloorAndCeiling(SectorNum, Sector[SectorNum].floorZ);
    
      // see if we need to flip the walls:
      if(eLineDef[LineDef1].Used &&
         (LineDef[LineDef1].sidedef1 != Nothing))
        if(SideDef[LineDef[LineDef1].sidedef1].sector == SectorNum) {
          // sure 'nuff, need to flip this one.
          j = LineDef[LineDef1].sidedef1;
          LineDef[LineDef1].sidedef1 = LineDef[LineDef1].sidedef2;
          LineDef[LineDef1].sidedef2 = j;
          j = LineDef[LineDef1].from;
          LineDef[LineDef1].from = LineDef[LineDef1].to;
          LineDef[LineDef1].to = j;
          }
      if(eLineDef[LineDef2].Used &&
         (LineDef[LineDef2].sidedef1 != Nothing))
        if(SideDef[LineDef[LineDef2].sidedef1].sector == SectorNum) {
          // sure 'nuff, need to flip this one.
          j = LineDef[LineDef2].sidedef1;
          LineDef[LineDef2].sidedef1 = LineDef[LineDef2].sidedef2;
          LineDef[LineDef2].sidedef2 = j;
          j = LineDef[LineDef2].from;
          LineDef[LineDef2].from = LineDef[LineDef2].to;
          LineDef[LineDef2].to = j;
          }
      // now set up the textures:
      CopyWall(SideDef[LineDef[LineDef1].sidedef1].t1, DoorTexture1);
      NullWall(SideDef[LineDef[LineDef1].sidedef1].t2);
      NullWall(SideDef[LineDef[LineDef1].sidedef1].t3);
      NullWall(SideDef[LineDef[LineDef1].sidedef2].t1);
      NullWall(SideDef[LineDef[LineDef1].sidedef2].t2);
      NullWall(SideDef[LineDef[LineDef1].sidedef2].t3);
      SideDef[LineDef[LineDef1].sidedef1].x = 0;
      SideDef[LineDef[LineDef1].sidedef1].y = 0;
      // second linedef:
      CopyWall(SideDef[LineDef[LineDef2].sidedef1].t1, DoorTexture2);
      NullWall(SideDef[LineDef[LineDef2].sidedef1].t2);
      NullWall(SideDef[LineDef[LineDef2].sidedef1].t3);
      NullWall(SideDef[LineDef[LineDef2].sidedef2].t1);
      NullWall(SideDef[LineDef[LineDef2].sidedef2].t2);
      NullWall(SideDef[LineDef[LineDef2].sidedef2].t3);
      SideDef[LineDef[LineDef2].sidedef1].x = 0;
      SideDef[LineDef[LineDef2].sidedef1].y = 0;
      // The bottom of the door should be little tiles:
      CopyWall(Sector[SectorNum].Ceil, "FLAT20");
      // Set the solidity to Transparent
      LineDef[LineDef1].solidity = ML_TWOSIDED;
      LineDef[LineDef2].solidity = ML_TWOSIDED;
      // Define the linedef actions as "Manual door raise"
      LineDef[LineDef1].special = 1;
      LineDef[LineDef2].special = 1;
      // Double check that no tags are set:
      // (doors don't use tags)
      LineDef[LineDef1].tag = 0;
      LineDef[LineDef2].tag = 0;
      // done all door tweaks
      }
  return;
}

void DropSectors(POINT Current, POINT Gridded)
{
  // the sector(s) which are/were being dragged are now dropped.
  // this routine must handle the new placement
  BOOL  LineHacked;
  int   n;
  // check if single sector was just dropped into another:
  SectorInside = NearestSectorNotMove(Current);
  if((SectorInside != Nothing) && !eSector[SectorInside].Selected) {
    // process sector/within/sector
    // o - add linedefs matching the lines of the inserted sector,
    // o - reverse the lines (so new sector faces "out")
    // x - popup the sector-in-sector dialog and use results

      for(n = 0; n < LineDefsNum; n++) {
        if(eLineDef[n].Moving) {
          LineHacked = FALSE;
          for(int j = 0; j < LineDefsNum; j++) {
            if(eLineDef[j].Used &&
               ((LineDef[n].sidedef1 == Nothing) ||
                (LineDef[n].sidedef2 == Nothing)) &&
               (j != n) &&
               ((((Vertex[LineDef[n].from].x == Vertex[LineDef[j].to  ].x) &&
                  (Vertex[LineDef[n].from].y == Vertex[LineDef[j].to  ].y)) &&
                 ((Vertex[LineDef[n].to  ].x == Vertex[LineDef[j].from].x) &&
                  (Vertex[LineDef[n].to  ].y == Vertex[LineDef[j].from].y))) ||
                (((Vertex[LineDef[n].from].x == Vertex[LineDef[j].from].x) &&
                  (Vertex[LineDef[n].from].y == Vertex[LineDef[j].from].y)) &&
                 ((Vertex[LineDef[n].to  ].x == Vertex[LineDef[j].to  ].x) &&
                  (Vertex[LineDef[n].to  ].y == Vertex[LineDef[j].to  ].y))))) {
              // already a line here...
              Join2Lines(n, j);
              }     // endif another line already here
            }       // next j
          // add side to single sided lines
          if(!LineHacked &&
             ((LineDef[n].sidedef1 == Nothing) ||
              (LineDef[n].sidedef2 == Nothing))) {
            int newv;
            int newl = LineDefSideDefNew();
            newv = VertexNew();
            Vertex[newv] = Vertex[LineDef[n].from];
            LineDef[newl].from = newv;
            newv = VertexNew();
            Vertex[newv] = Vertex[LineDef[n].to];
            LineDef[newl].to = newv;
            SideDef[LineDef[newl].sidedef1].sector = SectorInside;

            int tempswap = LineDef[n].from; // temp value
            LineDef[n].from = LineDef[n].to;
            LineDef[n].to = tempswap;
            tempswap = LineDef[n].sidedef1;
            LineDef[n].sidedef1 = LineDef[n].sidedef2;
            LineDef[n].sidedef2 = tempswap;
            }       // endif !LineHacked
          }         // endif eLineDef[n].Moving
        }           // next n
    }         // endif sector in sector
  else
    SectorInside = Nothing;
}

void SectorDuplicate(void)
{
  RECT          re, extent;
  int           i, j, news, newl, newd, leftoffset = 0, OriginalSectorsNum;
  HGLOBAL       hglb;
  ExtraSectors  __huge *eSect;

  if(SelectedSectors == 0) {
    ErrorMessage(IDS_NOSECTORS);
    return;
    }
  hglb  = GlobalAlloc(GHND, (DWORD)SectorsNum *
                      sizeof(ExtraSectors));
  eSect = (ExtraSectors __huge *)GlobalLock(hglb);
  
  for(i = 0; i < SectorsNum; i++)
    eSect[i] = eSector[i];
  
  OriginalSectorsNum = SectorsNum;
  
  extent = GetMapExtents();
  re.left = re.bottom = MAXINT;
  re.right = re.top = MININT;
  GetSectorExtents();
  for(i = 0; i < SectorsNum; i++)
    if(eSector[i].Used && eSector[i].Selected) {
      re.left   = min(re.left,   eSector[i].Extent.left);
      re.right  = max(re.right,  eSector[i].Extent.right);
      re.top    = max(re.top,    eSector[i].Extent.top);
      re.bottom = min(re.bottom, eSector[i].Extent.bottom);
      }

  leftoffset = extent.right - re.left;

  for(i = 0; i < OriginalSectorsNum; i++)
    if(eSect[i].Used && eSect[i].Selected) {
      news = SectorNew();
      Sector[news] = Sector[i];
      for(j = 0; j < LineDefsNum; j++)
        if(eLineDef[j].Used) {
          if(LineDef[j].sidedef1 != Nothing)
            if(SideDef[LineDef[j].sidedef1].sector == i) {
              newl = LineDefNew();
              eLineDef[newl].Moving = TRUE;
              LineDef[newl].from = VertexNew();
              LineDef[newl].to   = VertexNew();
              Vertex[LineDef[newl].from] = Vertex[LineDef[j].from];
              Vertex[LineDef[newl].to]   = Vertex[LineDef[j].to];
              eVertex[LineDef[newl].from].Moving = TRUE;
              eVertex[LineDef[newl].to].Moving   = TRUE;
              LineDef[newl].solidity = LineDef[j].solidity;
              LineDef[newl].special  = LineDef[j].special;
              LineDef[newl].tag      = LineDef[j].tag;
              newd = SideDefNew();
              SideDef[newd] = SideDef[LineDef[j].sidedef1];
              SideDef[newd].sector = news;
              LineDef[newl].sidedef1 = newd;
              Vertex[LineDef[newl].from].x += leftoffset;
              Vertex[LineDef[newl].to].x   += leftoffset;
              }     // endif dupe this sidedef
          if(LineDef[j].sidedef2 != Nothing)
            if(SideDef[LineDef[j].sidedef2].sector == i) {
              newl = LineDefNew();
              eLineDef[newl].Moving = TRUE;
              LineDef[newl].from = VertexNew();
              LineDef[newl].to   = VertexNew();
              Vertex[LineDef[newl].from] = Vertex[LineDef[j].from];
              Vertex[LineDef[newl].to]   = Vertex[LineDef[j].to];
              eVertex[LineDef[newl].from].Moving = TRUE;
              eVertex[LineDef[newl].to].Moving   = TRUE;
              LineDef[newl].solidity = LineDef[j].solidity;
              LineDef[newl].special  = LineDef[j].special;
              LineDef[newl].tag      = LineDef[j].tag;
              newd = SideDefNew();
              SideDef[newd] = SideDef[LineDef[j].sidedef2];
              SideDef[newd].sector = news;
              LineDef[newl].sidedef2 = newd;
              Vertex[LineDef[newl].from].x += leftoffset;
              Vertex[LineDef[newl].to].x   += leftoffset;
              }     // endif dupe this sidedef
          }         // endif linedef.used
      SelectSector(i);
      SelectSector(news);
      }             // endif sector.used && selected
  
  GlobalUnlock(hglb);
  GlobalFree(hglb);

  ProcessJoins();
}

int EXPORT DialogSearch(HWND hDlg,
                        WORD wMsg,
                        WORD wParam,
                        DWORD lParam);

void DoSearch(void)
{
  FARPROC lpfnDlgProc;
  lpfnDlgProc = MakeProcInstance((FARPROC)DialogSearch, hinst);
  if(lpfnDlgProc) {
    DialogBox(hinst,
              MAKEINTRESOURCE(IDD_SEARCH),
              hwnd,
              lpfnDlgProc);
    FreeProcInstance(lpfnDlgProc);
    }
}

static HWND hWhat, hCombo;

int EXPORT DialogSearch(HWND hDlg,
                        WORD wMsg,
                        WORD wParam,
                        DWORD lParam)
{
  char  szTemp[10];
  int   i, j, NumSelected;
  
  switch(wMsg) 
    {
    case WM_INITDIALOG:
      hWhat  = GetDlgItem(hDlg, IDC_WHAT);
      hCombo = GetDlgItem(hDlg, IDC_COMBO1);
      switch(Tool) {
        case T_THING:
          Static_SetText(hWhat, "Thing:");
          FillComboWithThings(hCombo);
          break;
        case T_SECTOR:
          Static_SetText(hWhat, "Floor / Ceiling");
          FillComboWithTiles(hCombo);
          break;
        case T_LINE:
          Static_SetText(hWhat, "Wall Texture:");
          FillComboWithTextures(hCombo);
          break;
        default:
          break;
        }
      break;

    case WM_COMMAND:
      switch(wParam) {
        case IDOK:
          NumSelected = 0;
          switch(Tool) {
            case T_THING:
              UnSelectAllThings();
              j = (int)ComboBox_GetItemData(hCombo, ComboBox_GetCurSel(hCombo));
              for(i = 0; i < ThingsNum; i++)
                if(eThing[i].Used && (Thing[i].item == j)) {
                  SelectThing(i);
                  NumSelected++;
                  }
              break;
            case T_SECTOR:
              UnSelectAllSectors();
              ComboBox_GetText(hCombo, szTemp, 9);
              j = strlen(szTemp);
              if(j < 9) {
                for(i = 0; i < SectorsNum; i++)
                  if(eSector[i].Used &&
                    ((strncmp(szTemp, Sector[i].Floor, j) == 0) ||
                     (strncmp(szTemp, Sector[i].Ceil,  j) == 0))) {
                    if(!eSector[i].Selected)
                      SelectSector(i);
                    NumSelected++;
                    }
                }
              break;
            case T_LINE:
              UnSelectAllLineDefs();
              ComboBox_GetText(hCombo, szTemp, 9);
              j = strlen(szTemp);
              if(j < 9) {
                for(i = 0; i < LineDefsNum; i++)
                  if(eLineDef[i].Used) {
                    if(LineDef[i].sidedef1 != Nothing)
                      if((strncmp(szTemp, SideDef[LineDef[i].sidedef1].t1, j) == 0) ||
                         (strncmp(szTemp, SideDef[LineDef[i].sidedef1].t2, j) == 0) ||
                         (strncmp(szTemp, SideDef[LineDef[i].sidedef1].t3, j) == 0)) {
                        if(!eLineDef[i].Selected)
                          SelectLineDef(i);
                        NumSelected++;
                        }
                    if(LineDef[i].sidedef2 != Nothing)
                      if((strncmp(szTemp, SideDef[LineDef[i].sidedef2].t1, j) == 0) ||
                         (strncmp(szTemp, SideDef[LineDef[i].sidedef2].t2, j) == 0) ||
                         (strncmp(szTemp, SideDef[LineDef[i].sidedef2].t3, j) == 0)) {
                        if(!eLineDef[i].Selected)
                          SelectLineDef(i);
                        NumSelected++;
                        }
                    }
                }
              break;
            default:
              break;
            }
          wsprintf(lpszMessage, "Total of %u found.", NumSelected);
          BottomMessage(lpszMessage);
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        case IDCANCEL:
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        default:
          break;
        }
    default:
      return FALSE;
    }
    return FALSE;
}

int EXPORT DialogReplace(HWND hDlg,
                         WORD wMsg,
                         WORD wParam,
                         DWORD lParam);

void DoReplace(void)
{
  FARPROC lpfnDlgProc;
  lpfnDlgProc = MakeProcInstance((FARPROC)DialogReplace, hinst);
  if(lpfnDlgProc) {
    DialogBox(hinst,
              MAKEINTRESOURCE(IDD_REPLACE),
              hwnd,
              lpfnDlgProc);
    FreeProcInstance(lpfnDlgProc);
    }
}

static HWND hCombo2;    // hCombo already above ^

int EXPORT DialogReplace(HWND hDlg,
                         WORD wMsg,
                         WORD wParam,
                         DWORD lParam)
{
  char  szTemp[10], szTemp2[10];
  int   i, j, k, NumReplaced;
  
  switch(wMsg) 
    {
    case WM_INITDIALOG:
      hCombo  = GetDlgItem(hDlg, IDC_COMBO1);
      hCombo2 = GetDlgItem(hDlg, IDC_COMBO2);
      switch(Tool) {
        case T_THING:
          FillComboWithThings(hCombo);
          FillComboWithThings(hCombo2);
          break;
        case T_SECTOR:
          FillComboWithTiles(hCombo);
          FillComboWithTiles(hCombo2);
          break;
        case T_LINE:
          FillComboWithTextures(hCombo);
          FillComboWithTextures(hCombo2);
          break;
        default:
          break;
        }
      break;

    case WM_COMMAND:
      switch(wParam) {
        case IDOK:
          NumReplaced = 0;
          switch(Tool) {
            case T_THING:
              j = (int)ComboBox_GetItemData(hCombo,  ComboBox_GetCurSel(hCombo));
              k = (int)ComboBox_GetItemData(hCombo2, ComboBox_GetCurSel(hCombo2));
              for(i = 0; i < ThingsNum; i++)
                if(eThing[i].Used && (Thing[i].item == j)) {
                  Thing[i].item = k;
                  NumReplaced++;
                  }
              break;
            case T_SECTOR:
              ComboBox_GetText(hCombo,  szTemp, 9);
              ComboBox_GetText(hCombo2, szTemp2, 9);
              j = strlen(szTemp);
              if(j < 9) {
                for(i = 0; i < SectorsNum; i++)
                  if(eSector[i].Used) {
                    if(strncmp(szTemp, Sector[i].Floor, j) == 0) {
                      CopyWall(Sector[i].Floor, szTemp2); }
                    if(strncmp(szTemp, Sector[i].Ceil, j) == 0) {
                      CopyWall(Sector[i].Ceil,  szTemp2); }
                    NumReplaced++;
                    }
                }
              break;
            case T_LINE:
              ComboBox_GetText(hCombo,  szTemp, 9);
              ComboBox_GetText(hCombo2, szTemp2, 9);
              j = strlen(szTemp);
              if(j < 9) {
                for(i = 0; i < LineDefsNum; i++)
                  if(eLineDef[i].Used) {
                    if(LineDef[i].sidedef1 != Nothing) {
                      if(strncmp(szTemp, SideDef[LineDef[i].sidedef1].t1, j) == 0) {
                        CopyWall(SideDef[LineDef[i].sidedef1].t1,  szTemp2);
                        NumReplaced++;
                        }
                      if(strncmp(szTemp, SideDef[LineDef[i].sidedef1].t2, j) == 0) {
                        CopyWall(SideDef[LineDef[i].sidedef1].t2,  szTemp2);
                        NumReplaced++;
                        }
                      if(strncmp(szTemp, SideDef[LineDef[i].sidedef1].t3, j) == 0) {
                        CopyWall(SideDef[LineDef[i].sidedef1].t3,  szTemp2);
                        NumReplaced++;
                        }
                      } // endif sidedef1 != Nothing
                    if(LineDef[i].sidedef2 != Nothing) {
                      if(strncmp(szTemp, SideDef[LineDef[i].sidedef2].t1, j) == 0) {
                        CopyWall(SideDef[LineDef[i].sidedef2].t1,  szTemp2);
                        NumReplaced++;
                        }
                      if(strncmp(szTemp, SideDef[LineDef[i].sidedef2].t2, j) == 0) {
                        CopyWall(SideDef[LineDef[i].sidedef2].t2,  szTemp2);
                        NumReplaced++;
                        }
                      if(strncmp(szTemp, SideDef[LineDef[i].sidedef2].t3, j) == 0) {
                        CopyWall(SideDef[LineDef[i].sidedef2].t3,  szTemp2);
                        NumReplaced++;
                        }
                      } // endif sidedef2 != Nothing
                    }   // endif linedef.Used
                }       // endif j < 9
              break;
            default:
              break;
            }
          wsprintf(lpszMessage, "Replaced %u occurrences.", NumReplaced);
          BottomMessage(lpszMessage);
          if(NumReplaced)
            MapChange();
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        case IDCANCEL:
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        default:
          break;
        }
    default:
      return FALSE;
    }
    return FALSE;
}

void AddProblem(HWND lb, prob *pr)
{
  if(ProblemsNum > 49)
    return;
  int j = ListBox_AddString(lb, pr->desc);
  ListBox_SetItemData(lb, j, ProblemsNum);
  strcpy(Problem[ProblemsNum].desc, pr->desc);
  Problem[ProblemsNum].what = pr->what;
  Problem[ProblemsNum++].which = pr->which;
}

static HWND hProb;

void ClearProblems(void)
{
  ListBox_ResetContent(hProb);
  ProblemsNum = 0;
}

#define ADDPROB     AddProblem(hProb, &This);

int EXPORT DialogMapCheck(HWND hDlg,
                          WORD wMsg,
                          WORD wParam,
                          DWORD lParam)
{
  int       i, j;
  prob      This;
  POINT     srch;
  char      szTemp[10];
  
  switch(wMsg) 
    {
    case WM_INITDIALOG:
      hProb  = GetDlgItem(hDlg, IDC_PROBLEMS);
      break;

    case WM_COMMAND:
      switch(wParam) {
        case IDC_BEGIN:
          CURSOR_BUSY
          ListBox_ResetContent(hProb);
          ProblemsNum = 0;
       // check Deathmatch locations:
          j = 0;
          for(i = 0; i < ThingsNum; i++) {
            if(eThing[i].Used && (Thing[i].item == 11)) // deathmatch start
              j++;
            }
          if(j < 4) {
            strcpy(This.desc, "Less than 4 Deathmatch starts");
            This.what = T_THING;
            This.which = Nothing;
            ADDPROB;
            }
          if(j > 10) {
            strcpy(This.desc, "More than 10 Deathmatch starts");
            This.what = T_THING;
            This.which = Nothing;
            ADDPROB;
            }
       // check textures:
          // floors:
          for(i = 0; i < SectorsNum; i++)
            if(eSector[i].Used) {
              szTemp[8] = '\0';
              CopyWall(szTemp, Sector[i].Floor);
              if(DoomEntry(szTemp) == NotFound) {
                wsprintf(This.desc, "Invalid Floor: %s", szTemp);
                This.what = T_SECTOR;
                This.which = i;
                ADDPROB;
                }
              }
          // ceilings:
          for(i = 0; i < SectorsNum; i++)
            if(eSector[i].Used) {
              szTemp[8] = '\0';
              CopyWall(szTemp, Sector[i].Ceil);
              if(DoomEntry(szTemp) == NotFound) {
                wsprintf(This.desc, "Invalid Ceiling: %s", szTemp);
                This.what = T_SECTOR;
                This.which = i;
                ADDPROB;
                }
              }
          // walls
          for(i = 0; i < LineDefsNum; i++)
            if(eLineDef[i].Used) {
              WadSideDefs *pSide;
              if(LineDef[i].sidedef1 != Nothing) {
                pSide = &SideDef[LineDef[i].sidedef1];
                if(pSide->t1[0] != '-') {
                  szTemp[8] = '\0';
                  CopyWall(szTemp, pSide->t1);
                  if(TextureEntry(szTemp) == NotFound) {
                    wsprintf(This.desc, "Invalid Front \"Below\" Texture: %s", szTemp);
                    This.what = T_LINE;
                    This.which = i;
                    ADDPROB;
                    }
                  }
                if(pSide->t2[0] != '-') {
                  szTemp[8] = '\0';
                  CopyWall(szTemp, pSide->t2);
                  if(TextureEntry(szTemp) == NotFound) {
                    wsprintf(This.desc, "Invalid Front \"Above\" Texture: %s", szTemp);
                    This.what = T_LINE;
                    This.which = i;
                    ADDPROB;
                    }
                  }
                if(pSide->t3[0] != '-') {
                  szTemp[8] = '\0';
                  CopyWall(szTemp, pSide->t3);
                  if(TextureEntry(szTemp) == NotFound) {
                    wsprintf(This.desc, "Invalid Front \"Main\" Texture: %s", szTemp);
                    This.what = T_LINE;
                    This.which = i;
                    ADDPROB;
                    }
                  }
                }
              if(LineDef[i].sidedef2 != Nothing) {
                pSide = &SideDef[LineDef[i].sidedef2];
                if(pSide->t1[0] != '-') {
                  szTemp[8] = '\0';
                  CopyWall(szTemp, pSide->t1);
                  if(TextureEntry(szTemp) == NotFound) {
                    wsprintf(This.desc, "Invalid Back \"Below\" Texture: %s", szTemp);
                    This.what = T_LINE;
                    This.which = i;
                    ADDPROB;
                    }
                  }
                if(pSide->t2[0] != '-') {
                  szTemp[8] = '\0';
                  CopyWall(szTemp, pSide->t2);
                  if(TextureEntry(szTemp) == NotFound) {
                    wsprintf(This.desc, "Invalid Back \"Above\" Texture: %s", szTemp);
                    This.what = T_LINE;
                    This.which = i;
                    ADDPROB;
                    }
                  }
                if(pSide->t3[0] != '-') {
                  szTemp[8] = '\0';
                  CopyWall(szTemp, pSide->t3);
                  if(TextureEntry(szTemp) == NotFound) {
                    wsprintf(This.desc, "Invalid Back \"Main\" Texture: %s", szTemp);
                    This.what = T_LINE;
                    This.which = i;
                    ADDPROB;
                    }
                  }
                }
              }
          // check that textures exist in proper places:
          for(i = 0; i < LineDefsNum; i++)
            if(eLineDef[i].Used) {
              if((LineDef[i].sidedef1 == Nothing) ||
                 (LineDef[i].sidedef2 == Nothing)) {
                if((LineDef[i].sidedef1 != Nothing) &&
                   (SideDef[LineDef[i].sidedef1].t3[0] == '-')) {
                    strcpy(This.desc, "Missing Front \"Main\" Texture");
                    This.what = T_LINE;
                    This.which = i;
                    ADDPROB;
                    }   // endif missing texture on front
                if((LineDef[i].sidedef2 != Nothing) &&
                   (SideDef[LineDef[i].sidedef2].t3[0] == '-')) {
                    strcpy(This.desc, "Missing Back \"Main\" Texture");
                    This.what = T_LINE;
                    This.which = i;
                    ADDPROB;
                    }   // endif missing texture on back
                  }     // endif one-sided line
              else {
                if(Sector[SideDef[LineDef[i].sidedef1].sector].floorZ <
                   Sector[SideDef[LineDef[i].sidedef2].sector].floorZ) {
                  if((SideDef[LineDef[i].sidedef1].t2[0] == '-') ||
                     (SideDef[LineDef[i].sidedef1].t2[0] == '\0'))
                    if(!TestLineBit(i, ML_DONTPEGTOP)) {
                      strcpy(This.desc, "Missing Front \"Below\" Texture");
                      This.what = T_LINE;
                      This.which = i;
                      ADDPROB;
                      }
                  }     // endif  floor1 < floor2
                if(Sector[SideDef[LineDef[i].sidedef1].sector].floorZ >
                   Sector[SideDef[LineDef[i].sidedef2].sector].floorZ) {
                  if((SideDef[LineDef[i].sidedef2].t2[0] == '-') ||
                     (SideDef[LineDef[i].sidedef2].t2[0] == '\0'))
                    if(!TestLineBit(i, ML_DONTPEGTOP)) {
                      strcpy(This.desc, "Missing Back \"Below\" Texture");
                      This.what = T_LINE;
                      This.which = i;
                      ADDPROB;
                      }   // endif missing texture
                  }     // endif  floor1 > floor2
                if(Sector[SideDef[LineDef[i].sidedef1].sector].ceilZ >
                   Sector[SideDef[LineDef[i].sidedef2].sector].ceilZ) {
                  if((SideDef[LineDef[i].sidedef1].t1[0] == '-') ||
                     (SideDef[LineDef[i].sidedef1].t1[0] == '\0'))
                    if(!TestLineBit(i, ML_DONTPEGBOTTOM)) {
                      strcpy(This.desc, "Missing Front \"Above\" Texture");
                      This.what = T_LINE;
                      This.which = i;
                      ADDPROB;
                      }   // endif missing texture
                  }     // endif  ceil1 > ceil2
                if(Sector[SideDef[LineDef[i].sidedef1].sector].ceilZ <
                   Sector[SideDef[LineDef[i].sidedef2].sector].ceilZ) {
                  if((SideDef[LineDef[i].sidedef2].t1[0] == '-') ||
                     (SideDef[LineDef[i].sidedef2].t1[0] == '\0'))
                    if(!TestLineBit(i, ML_DONTPEGBOTTOM)) {
                      strcpy(This.desc, "Missing Back \"Above\" Texture");
                      This.what = T_LINE;
                      This.which = i;
                      ADDPROB;
                      }   // endif missing texture
                  }     // endif  ceil1 < ceil2
                }       // endif two-sided line
              }         // endif linedef.used
       // look for orphans:
          for(i = 0; i < ThingsNum; i++)
            if(eThing[i].Used) {
              srch.x = Thing[i].x;
              srch.y = Thing[i].y;
              if(NearestSector(srch) == Nothing) {
                strcpy(This.desc, "Orphan Thing (not in sector)");
                This.what = T_THING;
                This.which = i;
                ADDPROB;
                }
              }
          CURSOR_NOTBUSY
          break;

        case IDC_PROBLEMS:
          if(HIWORD(lParam) == LBN_SELCHANGE) {
            j = ListBox_GetCurSel(hProb);
            This = Problem[ListBox_GetItemData(hProb, j)];
            switch(This.what) {
              case T_THING:
                if(Tool != T_THING)
                  SendMessage(hwndControlBar, WM_COMMAND, IDC_CB_THINGS, NULL);
                break;
              case T_LINE:
                if(Tool != T_LINE)
                  SendMessage(hwndControlBar, WM_COMMAND, IDC_CB_LINEDEFS, NULL);
                break;
              case T_SECTOR:
                if(Tool != T_SECTOR)
                  SendMessage(hwndControlBar, WM_COMMAND, IDC_CB_SECTORS, NULL);
                break;
              default:
                break;
              }
            if(This.which != Nothing)
              switch(This.what) {
                case T_THING:
                  UnSelectAllThings();
                  SelectThing(This.which);
                  break;
                case T_LINE:
                  UnSelectAllLineDefs();
                  SelectLineDef(This.which);
                  break;
                case T_SECTOR:
                  UnSelectAllSectors();
                  SelectSector(This.which);
                  break;
                default:
                  break;
                }
            }
          break;

        case IDCANCEL:  // labelled "close"
          PostMessage(hwnd, DOOMED_HIDE_PROBLEMS, 0, 0L);
          return TRUE;
          break;
        default:
          break;
        }
    default:
      return FALSE;
    }
    return FALSE;
}
