// Selection Routines for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

void GetSectorExtents(void)
{ 
  // fills the eSector rectangles with
  // the extent of each sector
  int  i;
  RECT r;
  
  // clear out all values
  r.left   = MAXINT;
  r.right  = MININT;
  r.top    = MININT;
  r.bottom = MAXINT;
  for(i = 0; i < SectorsNum; i++)
    if(eSector[i].Used)
      eSector[i].Extent = r;

  // now go through:
  for(i = 0; i < LineDefsNum; i++) {
    if(eLineDef[i].Used &&
       (LineDef[i].sidedef1 != Nothing)) {
      eSector[SideDef[LineDef[i].sidedef1].sector].Extent.left =
        min(eSector[SideDef[LineDef[i].sidedef1].sector].Extent.left,
            Vertex[LineDef[i].from].x);
      eSector[SideDef[LineDef[i].sidedef1].sector].Extent.left =
        min(eSector[SideDef[LineDef[i].sidedef1].sector].Extent.left,
            Vertex[LineDef[i].to].x);
      eSector[SideDef[LineDef[i].sidedef1].sector].Extent.right =
        max(eSector[SideDef[LineDef[i].sidedef1].sector].Extent.right,
            Vertex[LineDef[i].from].x);
      eSector[SideDef[LineDef[i].sidedef1].sector].Extent.right =
        max(eSector[SideDef[LineDef[i].sidedef1].sector].Extent.right,
            Vertex[LineDef[i].to].x);
      eSector[SideDef[LineDef[i].sidedef1].sector].Extent.top =
        max(eSector[SideDef[LineDef[i].sidedef1].sector].Extent.top,
            Vertex[LineDef[i].from].y);
      eSector[SideDef[LineDef[i].sidedef1].sector].Extent.top =
        max(eSector[SideDef[LineDef[i].sidedef1].sector].Extent.top,
            Vertex[LineDef[i].to].y);
      eSector[SideDef[LineDef[i].sidedef1].sector].Extent.bottom =
        min(eSector[SideDef[LineDef[i].sidedef1].sector].Extent.bottom,
            Vertex[LineDef[i].from].y);
      eSector[SideDef[LineDef[i].sidedef1].sector].Extent.bottom =
        min(eSector[SideDef[LineDef[i].sidedef1].sector].Extent.bottom,
            Vertex[LineDef[i].to].y);
      }     // endif sidedef1 != Nothing
    {
    char szt[64];
    wsprintf(szt, "GSE - %i", i);
    BottomMessage(szt);
    }
    if(eLineDef[i].Used &&
       (LineDef[i].sidedef2 != Nothing)) {
      eSector[SideDef[LineDef[i].sidedef2].sector].Extent.left =
        min(eSector[SideDef[LineDef[i].sidedef2].sector].Extent.left,
            Vertex[LineDef[i].from].x);
      eSector[SideDef[LineDef[i].sidedef2].sector].Extent.left =
        min(eSector[SideDef[LineDef[i].sidedef2].sector].Extent.left,
            Vertex[LineDef[i].to].x);
      eSector[SideDef[LineDef[i].sidedef2].sector].Extent.right =
        max(eSector[SideDef[LineDef[i].sidedef2].sector].Extent.right,
            Vertex[LineDef[i].from].x);
      eSector[SideDef[LineDef[i].sidedef2].sector].Extent.right =
        max(eSector[SideDef[LineDef[i].sidedef2].sector].Extent.right,
            Vertex[LineDef[i].to].x);
      eSector[SideDef[LineDef[i].sidedef2].sector].Extent.top =
        max(eSector[SideDef[LineDef[i].sidedef2].sector].Extent.top,
            Vertex[LineDef[i].from].y);
      eSector[SideDef[LineDef[i].sidedef2].sector].Extent.top =
        max(eSector[SideDef[LineDef[i].sidedef2].sector].Extent.top,
            Vertex[LineDef[i].to].y);
      eSector[SideDef[LineDef[i].sidedef2].sector].Extent.bottom =
        min(eSector[SideDef[LineDef[i].sidedef2].sector].Extent.bottom,
            Vertex[LineDef[i].from].y);
      eSector[SideDef[LineDef[i].sidedef2].sector].Extent.bottom =
        min(eSector[SideDef[LineDef[i].sidedef2].sector].Extent.bottom,
            Vertex[LineDef[i].to].y);
      }     // endif sidedef2 != Nothing
    }       // next i
}

void QuickSectorRepaint(void)
{
  HDC   rDC;
  int   i;
  // draw it, don't paint it...
  // (individual sector draws are slooowwwwwwwww....)
  // get device context
  rDC = GetDC(hwnd);
  SelectPen(rDC, hPenMapLines);
  for(i=0; i<LineDefsNum; i++)
    if(eLineDef[i].Used &&
       (((LineDef[i].sidedef1 != Nothing) &&
          eSector[SideDef[LineDef[i].sidedef1].sector].Selected) ||
        ((LineDef[i].sidedef2 != Nothing) &&
          eSector[SideDef[LineDef[i].sidedef2].sector].Selected)))
      continue;
    else if(eLineDef[i].Used) {
      if((LineDef[i].sidedef1 != Nothing) &&
         (LineDef[i].sidedef2 != Nothing))
        SelectPen(rDC, hPenMapInnerLines);
      else
        SelectPen(rDC, hPenMapLines);
      MoveTo(rDC, Vertex[LineDef[i].from].x,
                  Vertex[LineDef[i].from].y);
      LineTo(rDC, Vertex[LineDef[i].to].x,
                  Vertex[LineDef[i].to].y);
      }
  SelectPen(rDC, hPenSelected);
  for(i=0; i<LineDefsNum; i++)
    if(eLineDef[i].Used &&
       (((LineDef[i].sidedef1 != Nothing) &&
          eSector[SideDef[LineDef[i].sidedef1].sector].Selected) ||
        ((LineDef[i].sidedef2 != Nothing) &&
          eSector[SideDef[LineDef[i].sidedef2].sector].Selected))) {
      MoveTo(rDC, Vertex[LineDef[i].from].x,
                  Vertex[LineDef[i].from].y);
      LineTo(rDC, Vertex[LineDef[i].to].x,
                  Vertex[LineDef[i].to].y);
      }
  ReleaseDC(hwnd, rDC);
}

void QuickLineDefRepaint(void)
{
  HDC   rDC;
  int   i, m, n;

  rDC = GetDC(hwnd);
  for(i=0; i<LineDefsNum; i++) {
    if(!eLineDef[i].Used)
      continue;
    if(eLineDef[i].Selected)
      SelectPen(rDC, hPenSelected);
    else {
      if((LineDef[i].sidedef1 != Nothing) &&
         (LineDef[i].sidedef2 != Nothing))
        SelectPen(rDC, hPenMapInnerLines);
      else
        SelectPen(rDC, hPenMapLines);
      }
    MoveTo(rDC, Vertex[LineDef[i].from].x,
                Vertex[LineDef[i].from].y);
    LineTo(rDC, Vertex[LineDef[i].to].x,
                Vertex[LineDef[i].to].y);
    n = (Vertex[LineDef[i].from].x + Vertex[LineDef[i].to].x) / 2;
    m = (Vertex[LineDef[i].from].y + Vertex[LineDef[i].to].y) / 2;
    MoveTo(rDC, n, m); // this is the center of the line just drawn
    LineTo(rDC, n + (Vertex[LineDef[i].to].y - Vertex[LineDef[i].from].y) / 3,
                m + (Vertex[LineDef[i].from].x - Vertex[LineDef[i].to].x) / 3);
    }       // next i
  ReleaseDC(hwnd, rDC);
}

void SelectThing(int num)
{
  int   i;
  if(num == Nothing) {
    // select from RECT SelRect;
    for(i=0; i<ThingsNum; i++)
      if(eThing[i].Used &&
        (Thing[i].x >= SelRect.left) &&
        (Thing[i].x <= SelRect.right) &&
        (Thing[i].y >= SelRect.bottom) &&
        (Thing[i].y <= SelRect.top))
        if(!eThing[i].Selected) {
          eThing[i].Selected = TRUE;
          MarkThing(i);
          SelectedThings++;
          if(IsWindowVisible(hwndDialogThing))
            PutThingInDialog(i);
          }
    }
  else {
    if(!eThing[num].Used)
      return;
    eThing[num].Selected = !eThing[num].Selected;
    if(eThing[num].Selected) {
      MarkThing(num);
      SelectedThings++;
      }
    else {
      UnMarkThing(num);
      SelectedThings--;
      }
    }
}

void SelectVertex(int num)
{
  int   i;
  if(num == Nothing) {
    // select from RECT SelRect;
    for(i=0; i<VertexNum; i++)
      if(eVertex[i].Used &&
        (Vertex[i].x >= SelRect.left) &&
        (Vertex[i].x <= SelRect.right) &&
        (Vertex[i].y >= SelRect.bottom) &&
        (Vertex[i].y <= SelRect.top))
        if(!eVertex[i].Selected) {
          eVertex[i].Selected = TRUE;
          MarkVertex(i);
          SelectedVertexes++;
          }
    }
  else {
    if(!eVertex[num].Used)
      return;
    eVertex[num].Selected = !eVertex[num].Selected;
    if(eVertex[num].Selected) {
      MarkVertex(num);
      SelectedVertexes++;
      }
    else {
      UnMarkVertex(num);
      SelectedVertexes--;
      }
    }
}

void SelectSector(int num)
{
  int   i;

  if(num == NotFound)   // just in case ;)
    return;

  if(num == Nothing) {
    // select if all of sector is within RECT SelRect;
    GetSectorExtents();
    for(i=0; i<SectorsNum; i++) {
      if(eSector[i].Used &&
         !eSector[i].Selected &&
         (eSector[i].Extent.left   >= SelRect.left) &&
         (eSector[i].Extent.right  <= SelRect.right) &&
         (eSector[i].Extent.top    <= SelRect.top) &&
         (eSector[i].Extent.bottom >= SelRect.bottom)) {
        eSector[i].Selected = TRUE;
        SelectedSectors++;
        if(IsWindowVisible(hwndDialogSector))
          PutSectorInDialog(i);
        }
      }
    QuickSectorRepaint();
    }           // endif num == nothing
  else {
    if(!eSector[num].Used)
      return;
    eSector[num].Selected = !eSector[num].Selected;
    if(eSector[num].Selected) {
      MarkSector(num);
      SelectedSectors++;
      }
    else {
      UnMarkSector(num);
      SelectedSectors--;
      }
    if(IsWindowVisible(hwndDialogSector) &&
       (SelectedSectors == 1))
      PutSectorInDialog(num);
    }
  return;
}

void SelectLineDef(int num)
{
  int   i;
  if(num == Nothing) {
    // select where all of LineDef is within RECT SelRect;
    for(i=0; i<LineDefsNum; i++)
      if(eLineDef[i].Used &&
         (Vertex[LineDef[i].from].x >= SelRect.left) &&
         (Vertex[LineDef[i].from].x <= SelRect.right) &&
         (Vertex[LineDef[i].from].y >= SelRect.bottom) &&
         (Vertex[LineDef[i].from].y <= SelRect.top) &&
         (Vertex[LineDef[i].to].x >= SelRect.left) &&
         (Vertex[LineDef[i].to].x <= SelRect.right) &&
         (Vertex[LineDef[i].to].y >= SelRect.bottom) &&
         (Vertex[LineDef[i].to].y <= SelRect.top))
        if(!eLineDef[i].Selected) {
          eLineDef[i].Selected = TRUE;
          SelectedLineDefs++;
          if(IsWindowVisible(hwndDialogLineDef))
            PutLineDefInDialog(i);
          }
    QuickLineDefRepaint();
    }   // endif num == Nothing
  else {
    if(!eLineDef[num].Used)
      return;
    eLineDef[num].Selected = !eLineDef[num].Selected;
    if(eLineDef[num].Selected) {
      MarkLineDef(num);
      SelectedLineDefs++;
      if(IsWindowVisible(hwndDialogLineDef))
        PutLineDefInDialog(num);
      } // endif eLineDef[num].Selected
    else {
      UnMarkLineDef(num);
      SelectedLineDefs--;
      if(IsWindowVisible(hwndDialogLineDef) &&
         (SelectedLineDefs == 0))
        PutLineDefInDialog(Nothing);
      }
    }
  return;
}

void UnSelectAll(void)
{
  UnSelectAllThings();
  UnSelectAllSectors();
  UnSelectAllVertexes();
  UnSelectAllLineDefs();
  return;
}

void UnSelectAllThings(void)
{
  int   i;
  for(i=0; i<MAX_THING; i++)
    if(eThing[i].Used && eThing[i].Selected) {
      UnMarkThing(i);
      eThing[i].Selected = FALSE;
      }
  SelectedThings = 0;
  return;
}

void UnSelectAllSectors(void)
{
  if(SelectedSectors) {
    for(int tt = 0; tt < MAX_SECTOR; tt++)
      eSector[tt].Selected = FALSE;
    SelectedSectors = 0;
    QuickSectorRepaint();
    }
  return;
}

void UnSelectAllLineDefs(void)
{
  if(SelectedLineDefs) {
    for(int tt = 0; tt < MAX_LINEDEF; tt++)
      eLineDef[tt].Selected = FALSE;
    SelectedLineDefs = 0;
    QuickLineDefRepaint();
    }
  return;
}

void UnSelectAllVertexes(void)
{
  int   i;
  for(i=0; i<MAX_VERTEX; i++)
    if(eVertex[i].Used && eVertex[i].Selected) {
      UnMarkVertex(i);
      eVertex[i].Selected = FALSE;
      }
  SelectedVertexes = 0;
  return;
}

// routines to highlight or remove highlighting
void MarkLineDef(int num)
{
  int   m, n;
  HDC   rDC = GetDC(hwnd);
  if(!eLineDef[num].Used)
    return;
  SelectPen(rDC, hPenSelected);
  MoveTo(rDC, Vertex[LineDef[num].from].x,
              Vertex[LineDef[num].from].y);
  LineTo(rDC, Vertex[LineDef[num].to].x,
              Vertex[LineDef[num].to].y);
  n = (Vertex[LineDef[num].from].x + Vertex[LineDef[num].to].x) / 2;
  m = (Vertex[LineDef[num].from].y + Vertex[LineDef[num].to].y) / 2;
  MoveTo(rDC, n, m); // this is the center of the line just drawn
  LineTo(rDC, n + (Vertex[LineDef[num].to].y - Vertex[LineDef[num].from].y) / 3,
              m + (Vertex[LineDef[num].from].x - Vertex[LineDef[num].to].x) / 3);
  ReleaseDC(hwnd, rDC);
}

void TagLineDef(int num)
{
  // num is the tag number
  // Tagging LineDefs is only done from Sector mode - so draw that way
  int   i;
  HDC   rDC;

  TagShowing = num;
  if(num < 1)
    return;

  rDC = GetDC(hwnd);
  SelectPen(rDC, hPenMarked);
  for(i=0; i<LineDefsNum; i++)
    if(eLineDef[i].Used &&
       (LineDef[i].tag == num)) {
      MoveTo(rDC, Vertex[LineDef[i].from].x,
                  Vertex[LineDef[i].from].y);
      LineTo(rDC, Vertex[LineDef[i].to].x,
                  Vertex[LineDef[i].to].y);
      }
  ReleaseDC(hwnd, rDC);
}

void UnTagLineDef(int num)
{
  int   i;
  HDC   rDC;

  TagShowing = num;
  if(num < 1)
    return;

  rDC = GetDC(hwnd);
  for(i=0; i<LineDefsNum; i++)
    if(eLineDef[i].Used &&
       (LineDef[i].tag == num)) {
      if((LineDef[i].sidedef1 != Nothing) &&
         (LineDef[i].sidedef2 != Nothing))
        SelectPen(rDC, hPenMapInnerLines);
      else
        SelectPen(rDC, hPenMapLines);
      MoveTo(rDC, Vertex[LineDef[i].from].x,
                  Vertex[LineDef[i].from].y);
      LineTo(rDC, Vertex[LineDef[i].to].x,
                  Vertex[LineDef[i].to].y);
      }
  ReleaseDC(hwnd, rDC);
}

void MarkVertex(int num)
{
  HDC   rDC = GetDC(hwnd);
  SelectPen(rDC, hPenSelected); // Make it purple
  SelectBrush(rDC, hBrushNull);
  Rectangle(rDC, Vertex[num].x - 4, Vertex[num].y - 4,
                 Vertex[num].x + 4, Vertex[num].y + 4);
  ReleaseDC(hwnd, rDC);
}

void MarkSector(int num)
{
  int   i;
  HDC   rDC = GetDC(hwnd);
  SelectPen(rDC, hPenSelected);
  for(i=0; i<LineDefsNum; i++)
    if(eLineDef[i].Used &&
       (((LineDef[i].sidedef1 != Nothing) &&
         (SideDef[LineDef[i].sidedef1].sector == num)) ||
        ((LineDef[i].sidedef2 != Nothing) &&
         (SideDef[LineDef[i].sidedef2].sector == num)))) {
        MoveTo(rDC, Vertex[LineDef[i].from].x,
                    Vertex[LineDef[i].from].y);
        LineTo(rDC, Vertex[LineDef[i].to].x,
                    Vertex[LineDef[i].to].y);
        }  // end if
  ReleaseDC(hwnd, rDC);
  return;
}

void TagSector(int num)
{
  // Tag all sectors with "num" tag
  // tagging sectors is only done from Linedef mode, so draw that way
  int   m, n;
  int   i;
  HDC   rDC;

  TagShowing = num;
  // check if valid tag
  if(num < 1)
    return;
  
  rDC = GetDC(hwnd);
  SelectPen(rDC, hPenMarked);
  for(i=0; i<LineDefsNum; i++)
    if(eLineDef[i].Used &&
       (((LineDef[i].sidedef1 != Nothing) &&
         (Sector[SideDef[LineDef[i].sidedef1].sector].tag == num)) ||
        ((LineDef[i].sidedef2 != Nothing) &&
         (Sector[SideDef[LineDef[i].sidedef2].sector].tag == num)))) {
        MoveTo(rDC, Vertex[LineDef[i].from].x,
                    Vertex[LineDef[i].from].y);
        LineTo(rDC, Vertex[LineDef[i].to].x,
                    Vertex[LineDef[i].to].y);
        n = (Vertex[LineDef[i].from].x + Vertex[LineDef[i].to].x) / 2;
        m = (Vertex[LineDef[i].from].y + Vertex[LineDef[i].to].y) / 2;
        MoveTo(rDC, n, m); // this is the center of the line just drawn
        LineTo(rDC, n + (Vertex[LineDef[i].to].y -
                         Vertex[LineDef[i].from].y) / 3,
                    m + (Vertex[LineDef[i].from].x -
                         Vertex[LineDef[i].to].x) / 3);
        }  // end if
  ReleaseDC(hwnd, rDC);
  return;
}

void UnTagSector(int num)
{
  // Tag all sectors with "num" tag
  int   m, n;
  int   i;
  HDC   rDC;
  // check if valid tag
  TagShowing = num;
  if(num < 1)
    return;
  rDC = GetDC(hwnd);
  for(i=0; i<LineDefsNum; i++)
    if(eLineDef[i].Used &&
       (((LineDef[i].sidedef1 != Nothing) &&
         (Sector[SideDef[LineDef[i].sidedef1].sector].tag == num)) ||
        ((LineDef[i].sidedef2 != Nothing) &&
         (Sector[SideDef[LineDef[i].sidedef2].sector].tag == num)))) {
        if((LineDef[i].sidedef1 != Nothing) &&
           (LineDef[i].sidedef2 != Nothing))
          SelectPen(rDC, hPenMapInnerLines);
        else
          SelectPen(rDC, hPenMapLines);
        MoveTo(rDC, Vertex[LineDef[i].from].x,
                    Vertex[LineDef[i].from].y);
        LineTo(rDC, Vertex[LineDef[i].to].x,
                    Vertex[LineDef[i].to].y);
        n = (Vertex[LineDef[i].from].x + Vertex[LineDef[i].to].x) / 2;
        m = (Vertex[LineDef[i].from].y + Vertex[LineDef[i].to].y) / 2;
        MoveTo(rDC, n, m); // this is the center of the line just drawn
        LineTo(rDC, n + (Vertex[LineDef[i].to].y -
                         Vertex[LineDef[i].from].y) / 3,
                    m + (Vertex[LineDef[i].from].x -
                         Vertex[LineDef[i].to].x) / 3);
        }  // end if
  ReleaseDC(hwnd, rDC);
  return;
}

void MarkThing(int num)
{
  HDC   rDC = GetDC(hwnd);
  SelectPen(rDC, hPenSelected);
  Rectangle(rDC, Thing[num].x - 8, Thing[num].y - 8,
                 Thing[num].x + 8, Thing[num].y + 8);
  ReleaseDC(hwnd, rDC);
}

void UnMarkLineDef(int num)
{
  int   m, n;
  HDC   rDC = GetDC(hwnd);
  if((LineDef[num].sidedef1 != Nothing) &&
     (LineDef[num].sidedef2 != Nothing))
    SelectPen(rDC, hPenMapInnerLines);
  else
    SelectPen(rDC, hPenMapLines);
  MoveTo(rDC, Vertex[LineDef[num].from].x,
              Vertex[LineDef[num].from].y);
  LineTo(rDC, Vertex[LineDef[num].to].x,
              Vertex[LineDef[num].to].y);
  n = (Vertex[LineDef[num].from].x + Vertex[LineDef[num].to].x) / 2;
  m = (Vertex[LineDef[num].from].y + Vertex[LineDef[num].to].y) / 2;
  MoveTo(rDC, n, m); // this is the center of the line just drawn
  LineTo(rDC, n + (Vertex[LineDef[num].to].y - Vertex[LineDef[num].from].y) / 3,
              m + (Vertex[LineDef[num].from].x - Vertex[LineDef[num].to].x) / 3);
  ReleaseDC(hwnd, rDC);
}

void UnMarkVertex(int num)
{
  HDC   rDC = GetDC(hwnd);
  SelectPen(rDC, hPenMarked);   // back to green...
  SelectBrush(rDC, hBrushNull);
  Rectangle(rDC, Vertex[num].x - 4, Vertex[num].y - 4,
                 Vertex[num].x + 4, Vertex[num].y + 4);
  ReleaseDC(hwnd, rDC);
}

void UnMarkSector(int num)
{
  int   i;
  HDC   rDC = GetDC(hwnd);
  for(i=0; i<LineDefsNum; i++)
    if(eLineDef[i].Used &&
       (((LineDef[i].sidedef1 != Nothing) &&
         (SideDef[LineDef[i].sidedef1].sector == num)) ||
        ((LineDef[i].sidedef2 != Nothing) &&
         (SideDef[LineDef[i].sidedef2].sector == num)))) {
      if((LineDef[i].sidedef1 != Nothing) &&
         (LineDef[i].sidedef2 != Nothing))
        SelectPen(rDC, hPenMapInnerLines);
      else
        SelectPen(rDC, hPenMapLines);
      MoveTo(rDC, Vertex[LineDef[i].from].x,
                  Vertex[LineDef[i].from].y);
      LineTo(rDC, Vertex[LineDef[i].to].x,
                  Vertex[LineDef[i].to].y);
      }  // end if
  ReleaseDC(hwnd, rDC);
  return;
}

void UnMarkThing(int num)
{
  HDC   rDC = GetDC(hwnd);
  SelectPen(rDC, hPenMapLines);
  Rectangle(rDC, Thing[num].x - 8, Thing[num].y - 8,
                 Thing[num].x + 8, Thing[num].y + 8);
  ReleaseDC(hwnd, rDC);
}

