// Control Bars for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

// handles used only in this module:
HWND        hCBZoomAll, hCBZoomWin, hCBZoomPrev, hCBX, hCBY,
            hCBThings, hCBVertexes, hCBLineDefs, hCBSectors,
            hCBContents, hCBOpen, hCBNew;
HBITMAP     hbTools, hbTools1;


#define DoAButton(sx, sy) hMemDC = CreateCompatibleDC(lpdis->hDC); \
                          hOldbm = SelectObject(hMemDC, hbTools);  \
                          if(hOldbm) {                             \
                            BitBlt(lpdis->hDC,                     \
                                  (lpdis->rcItem).left,            \
                                  (lpdis->rcItem).top,             \
                                  (lpdis->rcItem).right - (lpdis->rcItem).left,  \
                                  (lpdis->rcItem).bottom - (lpdis->rcItem).top,  \
                                  hMemDC,                          \
                                  sx, sy,                          \
                                  SRCCOPY);                        \
                            SelectObject(hMemDC, hOldbm);          \
                            }                                      \
                          DeleteDC(hMemDC);                        \
                          return TRUE;

#define DoAButton1(sx, sy) hMemDC = CreateCompatibleDC(lpdis->hDC); \
                          hOldbm = SelectObject(hMemDC, hbTools1); \
                          if(hOldbm) {                             \
                            BitBlt(lpdis->hDC,                     \
                                  (lpdis->rcItem).left,            \
                                  (lpdis->rcItem).top,             \
                                  (lpdis->rcItem).right - (lpdis->rcItem).left,  \
                                  (lpdis->rcItem).bottom - (lpdis->rcItem).top,  \
                                  hMemDC,                          \
                                  sx, sy,                          \
                                  SRCCOPY);                        \
                            SelectObject(hMemDC, hOldbm);          \
                            }                                      \
                          DeleteDC(hMemDC);                        \
                          return TRUE;

#define RepaintButtons    InvalidateRect(hCBThings, NULL, FALSE);   \
                          UpdateWindow(hCBThings);                  \
                          InvalidateRect(hCBVertexes, NULL, FALSE); \
                          UpdateWindow(hCBVertexes);                \
                          InvalidateRect(hCBLineDefs, NULL, FALSE); \
                          UpdateWindow(hCBLineDefs);                \
                          InvalidateRect(hCBSectors, NULL, FALSE);  \
                          UpdateWindow(hCBSectors);



void ClientRect(HWND hWnd, RECT FAR *rr)
{
  // returns client rectangle with top 30 pixels (control bar height) removed
  GetClientRect(hWnd, rr);
  rr->top += 26;
  rr->bottom -=20;
  return;
}

void EnableControlBarItems(void)
{
  Button_Enable(hCBZoomPrev, TRUE);
  Button_Enable(hCBZoomAll, TRUE);
  Button_Enable(hCBZoomWin, TRUE);
  Button_Enable(hCBThings, TRUE);
  Button_Enable(hCBVertexes, TRUE);
  Button_Enable(hCBLineDefs, TRUE);
  Button_Enable(hCBSectors, TRUE);
}

void DisableControlBarItems(void)
{
  Button_Enable(hCBZoomPrev, FALSE);
  Button_Enable(hCBZoomAll, FALSE);
  Button_Enable(hCBZoomWin, FALSE);
  Button_Enable(hCBThings, FALSE);
  Button_Enable(hCBVertexes, FALSE);
  Button_Enable(hCBLineDefs, FALSE);
  Button_Enable(hCBSectors, FALSE);
}

void InvalidateMain(void)
{
  InvalidateRect(hwnd, NULL, TRUE);
  return;
}

// The Control bar is implemented as a modeless dialog box.
// This is a child window of hwnd, & will be destroyed at exit.

int EXPORT ControlBar(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
  LPDRAWITEMSTRUCT  lpdis;
  HBITMAP           hOldbm;
  HDC               hMemDC;
  
  switch(wMsg)
    {
    case WM_INITDIALOG:
      // scheme: each button is 24 wide, each space is 12 wide.
      hCBContents = CreateWindow("button", NULL,
                                 BS_OWNERDRAW | WS_CHILD | WS_VISIBLE,
                                 16, 3, 24, 22, hDlg, IDC_CB_CONTENTS,
                                 hinst, NULL);
      hCBOpen =     CreateWindow("button", NULL,
                                 BS_OWNERDRAW | WS_CHILD | WS_VISIBLE,
                                 52, 3, 24, 22, hDlg, IDC_CB_OPEN,
                                 hinst, NULL);
      hCBNew =      CreateWindow("button", NULL,
                                 BS_OWNERDRAW | WS_CHILD | WS_VISIBLE,
                                 76, 3, 24, 22, hDlg, IDC_CB_NEW,
                                 hinst, NULL);
      hCBSave     = CreateWindow("button", NULL,
                                 BS_OWNERDRAW | WS_CHILD | WS_VISIBLE | WS_DISABLED,
                                 100, 3, 24, 22, hDlg, IDC_CB_SAVE,
                                 hinst, NULL);
      hCBThings =   CreateWindow("button", NULL,
                                 BS_OWNERDRAW | WS_CHILD |
                                 WS_VISIBLE | WS_DISABLED, 
                                 136, 3, 24, 22, hDlg, IDC_CB_THINGS,
                                 hinst, NULL);
      hCBVertexes = CreateWindow("button", NULL,
                                 BS_OWNERDRAW | WS_CHILD |
                                 WS_VISIBLE | WS_DISABLED, 
                                 160, 3, 24, 22, hDlg, IDC_CB_VERTEXES,
                                 hinst, NULL);
      hCBLineDefs = CreateWindow("button", NULL,
                                 BS_OWNERDRAW | WS_CHILD |
                                 WS_VISIBLE | WS_DISABLED, 
                                 184, 3, 24, 22, hDlg, IDC_CB_LINEDEFS,
                                 hinst, NULL);
      hCBSectors =  CreateWindow("button", NULL,
                                 BS_OWNERDRAW | WS_CHILD |
                                 WS_VISIBLE | WS_DISABLED, 
                                 208, 3, 24, 22, hDlg, IDC_CB_SECTORS,
                                 hinst, NULL);
      hCBZoomPrev = CreateWindow("button", NULL,
                                 BS_OWNERDRAW | WS_CHILD |
                                 WS_VISIBLE | WS_DISABLED,
                                 244, 3, 24, 22, hDlg, IDC_CB_ZOOMPREV,
                                 hinst, NULL);
      hCBZoomAll =  CreateWindow("button", NULL,
                                 BS_OWNERDRAW | WS_CHILD |
                                 WS_VISIBLE | WS_DISABLED,
                                 268, 3, 24, 22, hDlg, IDC_CB_ZOOMALL,
                                 hinst, NULL);
      hCBZoomWin =  CreateWindow("button", NULL,
                                 BS_OWNERDRAW | WS_CHILD |
                                 WS_VISIBLE | WS_DISABLED,
                                 292, 3, 24, 22, hDlg, IDC_CB_ZOOMWIN,
                                 hinst, NULL);
      hbTools  = LoadBitmap(hinst, MAKEINTRESOURCE(IDB_TOOLS));
      hbTools1 = LoadBitmap(hinst, MAKEINTRESOURCE(IDB_TOOLS1));
      Tool = T_THING;
      return TRUE;
      break;

    case WM_DESTROY:
      DeleteBitmap(hbTools);
      DeleteBitmap(hbTools1);
      return FALSE;
      break;

    case WM_DRAWITEM:
      lpdis = (DRAWITEMSTRUCT FAR *)lParam;
      if(lpdis->CtlType != ODT_BUTTON) {
        // we only handle buttons on control bar, thank you...
        return FALSE;
        break;
        }
                       
      // help support:
      if(lpdis->itemState & ODS_SELECTED)
        DoomEdButtonSelect(lpdis->CtlID);
      
      switch(lpdis->CtlID) {
        case IDC_CB_CONTENTS:
          if(lpdis->itemState & ODS_DISABLED) {
            DoAButton1(48, 66); // disabled (grayed)
            break;
            }
          if(lpdis->itemState & ODS_SELECTED) {
            DoAButton1(24, 66); // button down
            break;
            }
          DoAButton1(0, 66);    // normal button
          break;

        case IDC_CB_OPEN:
          if(lpdis->itemState & ODS_DISABLED) {
            DoAButton1(48, 22); // disabled (grayed)
            break;
            }
          if(lpdis->itemState & ODS_SELECTED) {
            DoAButton1(24, 22); // button down
            break;
            }
          DoAButton1(0, 22);    // normal button
          break;
        case IDC_CB_SAVE:
          if(lpdis->itemState & ODS_DISABLED) {
            DoAButton1(48, 44); // disabled (grayed)
            break;
            }
          if(lpdis->itemState & ODS_SELECTED) {
            DoAButton1(24, 44); // button down
            break;
            }
          DoAButton1(0, 44);    // normal button
          break;
        case IDC_CB_NEW:
          if(lpdis->itemState & ODS_DISABLED) {
            DoAButton1(48, 0);  // disabled (grayed)
            break;
            }
          if(lpdis->itemState & ODS_SELECTED) {
            DoAButton1(24, 0);  // button down
            break;
            }
          DoAButton1(0, 0);     // normal button
          break;

        case IDC_CB_THINGS:
          if(lpdis->itemState & ODS_DISABLED) {
            DoAButton(48, 0);   // disabled (grayed)
            break;
            }
          if(lpdis->itemState & ODS_SELECTED) {
            DoAButton(24, 0);   // button down
            break;
            }
          if(Tool == T_THING) {
            DoAButton(72, 0);   // current tool
            }
          else {
            DoAButton(0, 0);    // normal button
            }
          break;
        case IDC_CB_VERTEXES:
          if(lpdis->itemState & ODS_DISABLED) {
            DoAButton(48, 22);   // disabled (grayed)
            break;
            }
          if(lpdis->itemState & ODS_SELECTED) {
            DoAButton(24, 22);   // button down
            break;
            }
          if(Tool == T_VERTEX) {
            DoAButton(72, 22);   // current tool
            }
          else {
            DoAButton(0, 22);    // normal button
            }
          break;
        case IDC_CB_LINEDEFS:
          if(lpdis->itemState & ODS_DISABLED) {
            DoAButton(48, 44);   // disabled (grayed)
            break;
            }
          if(lpdis->itemState & ODS_SELECTED) {
            DoAButton(24, 44);   // button down
            break;
            }
          if(Tool == T_LINE) {
            DoAButton(72, 44);   // current tool
            }
          else {
            DoAButton(0, 44);    // normal button
            }
          break;
        case IDC_CB_SECTORS:
          if(lpdis->itemState & ODS_DISABLED) {
            DoAButton(48, 66);   // disabled (grayed)
            break;
            }
          if(lpdis->itemState & ODS_SELECTED) {
            DoAButton(24, 66);   // button down
            break;
            }
          if(Tool == T_SECTOR) {
            DoAButton(72, 66);   // current tool
            }
          else {
            DoAButton(0, 66);    // normal button
            }
          break;

        case IDC_CB_ZOOMPREV:
          if(lpdis->itemState & ODS_DISABLED) {
            DoAButton1(48, 88); // disabled (grayed)
            break;
            }
          if(lpdis->itemState & ODS_SELECTED) {
            DoAButton1(24, 88); // button down
            break;
            }
          DoAButton1(0, 88);    // normal button
          break;
        case IDC_CB_ZOOMALL:
          if(lpdis->itemState & ODS_DISABLED) {
            DoAButton1(48, 110); // disabled (grayed)
            break;
            }
          if(lpdis->itemState & ODS_SELECTED) {
            DoAButton1(24, 110); // button down
            break;
            }
          DoAButton1(0, 110);    // normal button
          break;
        case IDC_CB_ZOOMWIN:
          if(lpdis->itemState & ODS_DISABLED) {
            DoAButton1(48, 132); // disabled (grayed)
            break;
            }
          if(lpdis->itemState & ODS_SELECTED) {
            DoAButton1(24, 132); // button down
            break;
            }
          DoAButton1(0, 132);    // normal button
          break;
        default:
          ;
        }   // end switch (which control)

      return FALSE;
      break;
      
    case WM_ACTIVATE:
      if(wParam==WA_INACTIVE)
        Frontmost = NULL;
      else
        Frontmost = hwndControlBar;
      break;

    case WM_MOUSEMOVE:
      if(ShowingSplash)
        SplashDown();
      return TRUE;
      break;
      
    case WM_COMMAND:
      if(ShowingSplash)
        SplashDown();
      switch (wParam) {

        case IDC_CB_ZOOMALL:
          PreviousZoom = MapExtent;
          MapExtent = GetMapExtents();
          RepaintMap();
          return FALSE;
          break;

        case IDC_CB_ZOOMWIN:
          PreviousZoom = MapExtent;
          MouseAction = MA_ZOOMWINDOW;
          hCursorMag  = LoadCursor(hinst,
                        MAKEINTRESOURCE(IDC_MAGGLASS1));
          oldCursor = SetCursor(hCursorMag);
          BottomMessage("Use Mouse to outline a new viewing window:");
          return FALSE;
          break;

        case IDC_CB_ZOOMPREV:
          MapExtent = PreviousZoom;
          RepaintMap();
          return FALSE;
          break;

        case IDC_CB_CONTENTS:
          DoDirectory();
          return FALSE;
          break;

        case IDC_CB_OPEN:
          DoomEdFileOpen();
          return FALSE;
          break;

        case IDC_CB_SAVE:
          DoomEdFileSave();
          return FALSE;
          break;

        case IDC_CB_NEW:
          DoomEdFileNew();
          return FALSE;
          break;

        case IDC_CB_THINGS:
          Tool = T_THING;
          RepaintButtons;
          PutSectorInDialog(Nothing);
          PutLineDefInDialog(Nothing);
          UnSelectAll();
          RepaintMap();
          return TRUE;
          break;

        case IDC_CB_SECTORS:
          Tool = T_SECTOR;
          RepaintButtons;
          PutLineDefInDialog(Nothing);
          PutThingInDialog(Nothing);
          UnSelectAll();
          RepaintMap();
          return TRUE;
          break;

        case IDC_CB_LINEDEFS:
          Tool = T_LINE;
          RepaintButtons;
          PutSectorInDialog(Nothing);
          PutThingInDialog(Nothing);
          UnSelectAll();
          RepaintMap();
          return TRUE;
          break;

        case IDC_CB_VERTEXES:
          FindVertexesInUse();
          Tool = T_VERTEX;
          RepaintButtons;
          PutLineDefInDialog(Nothing);
          PutSectorInDialog(Nothing);
          PutThingInDialog(Nothing);
          UnSelectAll();
          RepaintMap();
          return TRUE;
          break;

        default:
          return FALSE;
          break;
        }
      
    default:
      return FALSE;
    }
    return FALSE;
}

HWND    hMessage, hMapName;

int EXPORT ControlBot(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{

  switch(wMsg)
    {
    case WM_INITDIALOG:
      hCBX =     GetDlgItem(hDlg, IDC_CB_X);
      hCBY =     GetDlgItem(hDlg, IDC_CB_Y);
      hMessage = GetDlgItem(hDlg, IDC_MESSAGE);
      hMapName = GetDlgItem(hDlg, IDC_MAPNAME);
      return TRUE;
      break;

    case WM_ACTIVATE:
      if(wParam==WA_INACTIVE)
        Frontmost = NULL;
      else
        Frontmost = hwndControlBot;
      break;

    case WM_COMMAND:
      if(wParam == IDC_MAPNAME)
        DoMapName();
      return FALSE;
      break;
    default:
      return FALSE;
    }
    return FALSE;
}

void BottomMessage(char *text)
{
  if(text[0]=='\0')
    Static_SetText(hMessage, "DoomEd 4.2 - "
                             "Copyright  1995 by Geoff Allan.");
  else
    Static_SetText(hMessage, text);
  return;
}

void BottomMapName(char *text)
{
  if(text[0]=='\0') {
    Button_SetText(hMapName, "");
    Button_Enable(hMapName, FALSE);
    }
  else {
    Button_SetText(hMapName, text);
    Button_Enable(hMapName, TRUE);
    }
  return;
}

void DisplayCoords(int x, int y)
{
  static char szTemp[8];
  
  if(!MapLoaded)
    return;
  sprintf(szTemp,"%i", x);
  Static_SetText(hCBX, szTemp);
  sprintf(szTemp,"%i", y);
  Static_SetText(hCBY, szTemp);
  return;
}


