// BSP Dialogs for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

int     WhichBuilder;

void DoBuilders(void)
{
  FARPROC lpfnDlgProc;
  lpfnDlgProc = MakeProcInstance((FARPROC)DialogBuilders, hinst);
  if(lpfnDlgProc) {
    DialogBox(hinst,
              MAKEINTRESOURCE(IDD_BSPBUILDERS),
              hwnd,
              lpfnDlgProc);
    FreeProcInstance(lpfnDlgProc);
    }
}

HWND    hList;

int EXPORT DialogBuilders(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
  int   i;
  switch(wMsg) {
    case WM_INITDIALOG:
      hList = GetDlgItem(hDlg, IDC_BSP_LIST);
      FillListWithBuilders(hList);
      break;

    case WM_COMMAND:
      switch(wParam) {
        case IDC_BSP_LIST:
          switch(HIWORD(lParam)) {
            case LBN_DBLCLK:
              // the first click selected the right one...
              SendMessage(hDlg, WM_COMMAND, IDC_BSP_EDIT, 0L);
              return TRUE;
              break;
            case LBN_SELCHANGE:
              WhichBuilder = ListBox_GetCurSel(hList);
              Button_Enable(GetDlgItem(hDlg, IDC_BSP_EDIT), TRUE);
              Button_Enable(GetDlgItem(hDlg, IDC_BSP_DELETE), TRUE);
              return TRUE;
              break;
            default:
              return TRUE;
              break;
            }
        case IDC_BSP_ADD:
          WhichBuilder = Nothing;
          SendMessage(hDlg, WM_COMMAND, IDC_BSP_EDIT, 0L);
          return TRUE;
          break;
        case IDC_BSP_DELETE:
          {
            char szTemp[128];
            sprintf(szTemp, "Are you sure you want to delete the\n"
                            "Builder \"%s\"?", Builder[WhichBuilder].Name);
            if(MessageBox(hDlg, szTemp, ProgName, MB_YESNO |
                          MB_ICONQUESTION) == IDYES) {
              for(i=WhichBuilder; i<BuildersNum; i++)
                Builder[i] = Builder[i + 1];
              BuildersNum--;
              }
          }
          FillListWithBuilders(hList);
          return TRUE;
          break;
        case IDC_BSP_EDIT:
          {
          FARPROC lpfnDlgProc;
          lpfnDlgProc = MakeProcInstance((FARPROC)DialogBuilder, hinst);
          if(lpfnDlgProc) {
            DialogBox(hinst,
                      MAKEINTRESOURCE(IDD_BSPBUILDER),
                      hDlg,
                      lpfnDlgProc);
            FreeProcInstance(lpfnDlgProc);
            }
          }
          FillListWithBuilders(hList);
          return TRUE;
          break;
        case IDOK:
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        case IDCANCEL:
          EndDialog(hDlg, IDCANCEL);
          return TRUE;
          break;
        default:
          break;
      }
    default:
      return FALSE;
    }
    return FALSE;
}

HWND    hName, hCommand, hFormat0, hFormat1;

int EXPORT DialogBuilder(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
  switch(wMsg) {
    case WM_INITDIALOG:
      hName    = GetDlgItem(hDlg, IDC_BSP_NAME);
      hCommand = GetDlgItem(hDlg, IDC_BSP_COMMAND);
      hFormat0 = GetDlgItem(hDlg, IDC_BSP_WAD);
      hFormat1 = GetDlgItem(hDlg, IDC_BSP_DWD);
      Edit_LimitText(hName, 32);
      Edit_LimitText(hCommand, 128);
      if(WhichBuilder != Nothing) {
        Edit_SetText(hName, Builder[WhichBuilder].Name);
        Edit_SetText(hCommand, Builder[WhichBuilder].Command);
        if(Builder[WhichBuilder].Format == 0) {
          Button_SetCheck(hFormat0, TRUE);
          Button_SetCheck(hFormat1, FALSE);
          }
        else {
          Button_SetCheck(hFormat0, FALSE);
          Button_SetCheck(hFormat1, TRUE);
          }
        }
      else {
        Edit_SetText(hName, "noname");
        Edit_SetText(hCommand, "");
        }
      break;

    case WM_COMMAND:
      switch(wParam) {
        case IDOK:
          if(WhichBuilder == Nothing)
            WhichBuilder = BuildersNum++;
          Edit_GetText(hName, Builder[WhichBuilder].Name, 32);
          Edit_GetText(hCommand, Builder[WhichBuilder].Command, 128);
          if(Button_GetCheck(hFormat0))
            Builder[WhichBuilder].Format = 0;
          if(Button_GetCheck(hFormat1))
            Builder[WhichBuilder].Format = 1;
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        case IDCANCEL:
          EndDialog(hDlg, IDCANCEL);
          return TRUE;
          break;
        default:
          break;
      }
    default:
      return FALSE;
    }
    return FALSE;
}


