// Internal Blockmap builder for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.
//
// Note: only BuildBlockmap is declared in Prototyp.hpp

#include "DoomEd40.hpp"
#include "nodebldr.h"

void BuildReject(void);

void AddLineToBlockMap(int **block, int lndx, int nlines)
{
  int k;

  if(*block == NULL)                    // allocate if no list yet 
    *block = (int *)calloc((size_t)(min(nlines, 50)),sizeof(int));
  for(k = 0; (*block)[k]; k++);         // seek to end of list 
  (*block)[k] = lndx + 1;               // add this LINEDEF 
}

void BuildBlockmap(void)
{
  int  xmin,ymin, xmax,ymax;            // map coords min/max 
  long scl = 1000;                      // line following scaling 
  int  size = 0x80;                     // block size (map coords) 
  int  xorig, yorig;                    // blockmap x,y origin 
  int  xn, yn;                          // # blocks in x,y dirs 
  int  xcc, xcl;
  long xf,yf, xt,yt;
  long xd, yd;                          // x direction, y direction 
  int  o;
  int  l, k, i, p, c, m;
  int  **boxlist;                       // array of blocks' lists 
  int  b;
  int  t;

  BottomMessage("Building BLOCKMAP");
  // find the min and max for x and y   (GLA)
  FindVertexesInUse();
  xmin = ymin = MAXINT;
  xmax = ymax = MININT;
  for(i = 0; i < VertexNum; i++)
    if(eVertex[i].Used) {
      xmin = min(Vertex[i].x, xmin);
      xmax = max(Vertex[i].x, xmax);
      ymax = max(Vertex[i].y, ymax);
      ymin = min(Vertex[i].y, ymin);
      }
  xorig = xmin - 8;                         // get x origin 
  yorig = ymin - 8;                         // get y origin 
  xn = (xmax - xmin + size) / size;         // get # in x direction 
  yn = (ymax - ymin + size) / size;         // get # in y direction 
  boxlist = (int **)calloc((size_t)(xn * yn), sizeof(int **));
  t = 0;                                    // total len of all lists 
  for(l = 0; l < LineDefsNum; l++) {             // scan LINEDEFS here 
    xf = Vertex[LineDef[l].from].x - xorig;
    yf = Vertex[LineDef[l].from].y - yorig;
    xt = Vertex[LineDef[l].to].x - xorig;
    yt = Vertex[LineDef[l].to].y - yorig;
    xd = sgn(xt - xf);
    yd = sgn(yt - yf);
    switch (2 * (xf/size == xt/size) + (yf/size == yt/size)) {
      case 0:                           // diagonal line
        c = 0;
        p = (int)yd * xn;
        break;
      case 1:                           // horizontal line
        c = (int)abs(xt / size - xf / size) + 1;
        p = (int)xd;
        break;
      case 2:                           // vertical line
        c = (int)abs(yt / size - yf / size) + 1;
        p = (int)(yd * xn);
        break;
      case 3:                           // within block
        c = 1;
        p = 1;
      }
    b = (int)(xf / size + xn * (yf / size));   // start @ this block
    for(i = 0; i < c; i++, b+=p) {      // add to lists for special 
      AddLineToBlockMap(&boxlist[b], l, LineDefsNum);
      t++;
      }
    if(c == 0) {                        // handle diagonal lines 
      m = (int)(scl * (yt - yf) / (xt - xf));  // spanning > 1 block    
      xcl = (int)xf;
      if(yd == -1)
        xcc = (int)(xf + scl * ((yf / size) * size - 1 - yf) / m);
      else
        xcc = (int)(xf + scl * ((yf / size) * size + 128 - yf) / m);
      do {
        for(c = 0; c < (int)(abs(xcc / size - xcl / size) + 1); c++, b += (int)xd) {
          AddLineToBlockMap(&boxlist[b], l, LineDefsNum);
          t++;
          }
        b += p - (int)xd;
        xcl = xcc;
        xcc += (int)(yd * scl * size / m);
        if((xd * xcc) > (xd * xt))
          xcc = (int)xt;              // don't overrun endpoint
        }
        while ((xd * xcl) < (xd * xt));
      }
    }
  t = 0;
  BlockMap[t++] = xorig;                // fill in X,Y origin 
  BlockMap[t++] = yorig;
  BlockMap[t++] = xn;                   // fill in # in X and 
  BlockMap[t++] = yn;                   // Y directions       
  o = t;
  t += (xn * yn);
  for(i = 0; i < xn * yn; i++) {        // now fill in BLOCKMAP 
    BlockMap[o++] = t;                  // offset in BLOCKMAP 
    BlockMap[t++] = 0;                  // always zero 
    if(boxlist[i] != NULL) {
      for(k = 0; boxlist[i][k]; k++)    // list of lines in this block
        BlockMap[t++] = boxlist[i][k] - 1;
      ((boxlist[i]) != NULL ? free((char *)(boxlist[i])) : 0);
      }
    BlockMap[t++] = Nothing;            // end of block
    }
  ((boxlist) != NULL ? free((char *)boxlist) : 0);
  BlockMapSize = (long)t * 2;   // bytes are 2 words!
}
