#ifndef polymost_h_
# define polymost_h_

#ifdef USE_OPENGL

#include "glbuild.h"
#include "hightile.h"
#include "baselayer.h"  // glinfo

#ifdef __cplusplus
extern "C" {
#endif

typedef struct { uint8_t r, g, b, a; } coltype;
typedef struct { float r, g, b, a; } coltypef;

extern int32_t rendmode;
extern float gtang;
extern float glox1, gloy1;
extern float gxyaspect, grhalfxdown10x;
extern float gcosang, gsinang, gcosang2, gsinang2;
extern float gchang, gshang, gctang, gstang, gvisibility;

struct glfiltermodes {
	const char *name;
	int32_t min,mag;
};
#define NUMGLFILTERMODES 6
extern struct glfiltermodes glfiltermodes[NUMGLFILTERMODES];

//void phex(char v, char *s);
void uploadtexture(int32_t doalloc, vec2_t siz, int32_t intexfmt, int32_t texfmt, coltype *pic, vec2_t tsiz, int32_t dameth);
void polymost_drawsprite(int32_t snum);
void polymost_drawmaskwall(int32_t damaskwallcnt);
void polymost_dorotatesprite(int32_t sx, int32_t sy, int32_t z, int16_t a, int16_t picnum,
                             int8_t dashade, char dapalnum, int32_t dastat, uint8_t daalpha, int32_t cx1, int32_t cy1, int32_t cx2, int32_t cy2, int32_t uniqid);
void polymost_fillpolygon(int32_t npoints);
void polymost_initosdfuncs(void);
void polymost_drawrooms(void);

void polymost_glinit(void);
void polymost_glreset(void);

enum {
    INVALIDATE_ALL,
    INVALIDATE_ART
};

void gltexinvalidate(int32_t dapicnum, int32_t dapalnum, int32_t dameth);
void gltexinvalidatetype(int32_t type);
int32_t polymost_printext256(int32_t xpos, int32_t ypos, int16_t col, int16_t backcol, const char *name, char fontsize);

extern float curpolygonoffset;

extern float shadescale;
extern int32_t shadescale_unbounded;
extern uint8_t alphahackarray[MAXTILES];

extern int32_t r_usenewshading;
extern int32_t r_usetileshades;
extern int32_t r_npotwallmode;

extern int16_t globalpicnum;
extern int32_t globalpal;

// Compare with polymer_eligible_for_artmap()
static inline int32_t eligible_for_tileshades(int32_t const picnum, int32_t const pal)
{
    return (!usehightile || !hicfindsubst(picnum, pal)) &&
        (!usemodels || md_tilehasmodel(picnum, pal) < 0);
}

static inline float getshadefactor(int32_t const shade)
{
    int32_t const shadebound = (shadescale_unbounded || shade>=numshades) ? numshades : numshades-1;
    float const clamped_shade = min(max(shade*shadescale, 0), shadebound);

    // 8-bit tiles, i.e. non-hightiles and non-models, don't get additional
    // glColor() shading with r_usetileshades!
    if (getrendermode() == REND_POLYMOST && r_usetileshades &&
            !(globalflags & GLOBAL_NO_GL_TILESHADES) &&
            eligible_for_tileshades(globalpicnum, globalpal))
        return 1.f;

    return ((float)(numshades-clamped_shade))/(float)numshades;
}

#define POLYMOST_CHOOSE_FOG_PAL(fogpal, pal) \
    ((fogpal) ? (fogpal) : (pal))
static inline int32_t get_floor_fogpal(tsectortype const * const sec)
{
    return POLYMOST_CHOOSE_FOG_PAL(sec->fogpal, sec->floorpal);
}
static inline int32_t get_ceiling_fogpal(tsectortype const * const sec)
{
    return POLYMOST_CHOOSE_FOG_PAL(sec->fogpal, sec->ceilingpal);
}
static inline int32_t fogpal_shade(tsectortype const * const sec, int32_t const shade)
{
    // When fogging is due to sector[].fogpal, don't make the fog parameters
    // depend on the shade of the object.
    return sec->fogpal ? 0 : shade;
}

static inline int check_nonpow2(int32_t const x)
{
    return (x > 1 && (x&(x-1)));
}

// Are we using the mode that uploads non-power-of-two wall textures like they
// render in classic?
static inline int polymost_is_npotmode(void)
{
    // The glinfo.texnpot check is so we don't have to deal with that case in
    // gloadtile_art().
    return glinfo.texnpot &&
        // r_npotwallmode is NYI for hightiles. We require r_hightile off
        // because in calc_ypanning(), the repeat would be multiplied by a
        // factor even if no modified texture were loaded.
        !usehightile &&
#ifdef NEW_MAP_FORMAT
        g_loadedMapVersion < 10 &&
#endif
        r_npotwallmode;
}

static inline float polymost_invsqrt_approximation(float x)
{
#ifdef B_LITTLE_ENDIAN
    float const haf = x * .5f;
    struct conv { union { uint32_t i; float f; } ; } * const n = (struct conv *)&x;
    n->i = 0x5f3759df - (n->i >> 1);
    return n->f * (1.5f - haf * (n->f * n->f));
#else
    // this is the comment
    return 1.f / Bsqrtf(x);
#endif
}

// Flags of the <dameth> argument of various functions
enum {
    DAMETH_CLAMPED = 4,

    DAMETH_WALL = 32,  // signals a texture for a wall (for r_npotwallmode)

    DAMETH_NOCOMPRESS = 4096,
    DAMETH_HI = 8192,
    DAMETH_NOFIX = 16384,
};

// DAMETH_CLAMPED -> PTH_CLAMPED conversion
#define TO_PTH_CLAMPED(dameth) (((dameth)&DAMETH_CLAMPED)>>2)

// Do we want a NPOT-y-as-classic texture for this <dameth> and <ysiz>?
static inline int polymost_want_npotytex(int32_t dameth, int32_t ysiz)
{
    return getrendermode() != REND_POLYMER &&  // r_npotwallmode NYI in Polymer
        polymost_is_npotmode() && (dameth&DAMETH_WALL) && check_nonpow2(ysiz);
}

// pthtyp pth->flags bits
enum {
    PTH_CLAMPED = 1,
    PTH_HIGHTILE = 2,
    PTH_SKYBOX = 4,
    PTH_HASALPHA = 8,
    PTH_HASFULLBRIGHT = 16,
    PTH_NPOTWALL = DAMETH_WALL,  // r_npotwallmode=1 generated texture
    PTH_FORCEFILTER = 64,

    PTH_INVALIDATED = 128,
};

typedef struct pthtyp_t
{
    struct pthtyp_t *next;
    struct pthtyp_t *ofb; // fullbright pixels
    hicreplctyp     *hicr;

    uint32_t        glpic;
    vec2f_t         scale;
    vec2_t          siz;
    int16_t         picnum;

    char            palnum;
    char            shade;
    char            effects;
    char            flags;      // 1 = clamped (dameth&4), 2 = hightile, 4 = skybox face, 8 = hasalpha, 16 = hasfullbright, 128 = invalidated
    char            skyface;
} pthtyp;

extern void gloadtile_art(int32_t,int32_t,int32_t,int32_t,int32_t,pthtyp *,int32_t);
extern int32_t gloadtile_hi(int32_t,int32_t,int32_t,hicreplctyp *,int32_t,pthtyp *,int32_t,char);

extern int32_t globalnoeffect;
extern int32_t drawingskybox;
extern int32_t hicprecaching;
extern float gyxscale, gxyaspect, ghalfx, grhalfxdown10;
extern float fcosglobalang, fsinglobalang;
extern float fxdim, fydim, fydimen, fviewingrange;

extern char ptempbuf[MAXWALLSB<<1];

extern hitdata_t polymost_hitdata;

#include "texcache.h"

extern void polymost_setupglowtexture(int32_t texunits, int32_t tex);
extern void polymost_setupdetailtexture(int32_t texunits, int32_t tex);

#ifdef __cplusplus
}
#endif

#endif

#endif
