//-------------------------------------------------------------------------
/*
Copyright (C) 2013 EDuke32 developers and contributors

This file is part of EDuke32.

EDuke32 is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License version 2
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
//-------------------------------------------------------------------------

#include "compat.h"
#include "build.h"

#include "namesdyn.h"
#include "sounds.h"
#include "soundsdyn.h"
#include "global.h"

#ifdef DYNSOUNDREMAP_ENABLE
# define DVPTR(x) &x
#else
# define DVPTR(x) NULL
#endif

int16_t DynamicSoundMap[MAXSOUNDS];

struct dynitem
{
    const char *str;
    int32_t *dynvalptr;
    const int16_t staticval;
};

LUNATIC_EXTERN struct dynitem g_dynSoundList[] =
{
    { "KICK_HIT", DVPTR(KICK_HIT), KICK_HIT__STATIC },
    { "PISTOL_RICOCHET", DVPTR(PISTOL_RICOCHET), PISTOL_RICOCHET__STATIC },
    { "PISTOL_BODYHIT", DVPTR(PISTOL_BODYHIT), PISTOL_BODYHIT__STATIC },
    { "PISTOL_FIRE", DVPTR(PISTOL_FIRE), PISTOL_FIRE__STATIC },
    { "EJECT_CLIP", DVPTR(EJECT_CLIP), EJECT_CLIP__STATIC },
    { "INSERT_CLIP", DVPTR(INSERT_CLIP), INSERT_CLIP__STATIC },
    { "CHAINGUN_FIRE", DVPTR(CHAINGUN_FIRE), CHAINGUN_FIRE__STATIC },
    { "RPG_SHOOT", DVPTR(RPG_SHOOT), RPG_SHOOT__STATIC },
    { "POOLBALLHIT", DVPTR(POOLBALLHIT), POOLBALLHIT__STATIC },
    { "RPG_EXPLODE", DVPTR(RPG_EXPLODE), RPG_EXPLODE__STATIC },
    { "CAT_FIRE", DVPTR(CAT_FIRE), CAT_FIRE__STATIC },
    { "SHRINKER_FIRE", DVPTR(SHRINKER_FIRE), SHRINKER_FIRE__STATIC },
    { "ACTOR_SHRINKING", DVPTR(ACTOR_SHRINKING), ACTOR_SHRINKING__STATIC },
    { "PIPEBOMB_BOUNCE", DVPTR(PIPEBOMB_BOUNCE), PIPEBOMB_BOUNCE__STATIC },
    { "PIPEBOMB_EXPLODE", DVPTR(PIPEBOMB_EXPLODE), PIPEBOMB_EXPLODE__STATIC },
    { "LASERTRIP_ONWALL", DVPTR(LASERTRIP_ONWALL), LASERTRIP_ONWALL__STATIC },
    { "LASERTRIP_ARMING", DVPTR(LASERTRIP_ARMING), LASERTRIP_ARMING__STATIC },
    { "LASERTRIP_EXPLODE", DVPTR(LASERTRIP_EXPLODE), LASERTRIP_EXPLODE__STATIC },
    { "VENT_BUST", DVPTR(VENT_BUST), VENT_BUST__STATIC },
    { "GLASS_BREAKING", DVPTR(GLASS_BREAKING), GLASS_BREAKING__STATIC },
    { "GLASS_HEAVYBREAK", DVPTR(GLASS_HEAVYBREAK), GLASS_HEAVYBREAK__STATIC },
    { "SHORT_CIRCUIT", DVPTR(SHORT_CIRCUIT), SHORT_CIRCUIT__STATIC },
    { "ITEM_SPLASH", DVPTR(ITEM_SPLASH), ITEM_SPLASH__STATIC },
    { "DUKE_BREATHING", DVPTR(DUKE_BREATHING), DUKE_BREATHING__STATIC },
    { "DUKE_EXHALING", DVPTR(DUKE_EXHALING), DUKE_EXHALING__STATIC },
    { "DUKE_GASP", DVPTR(DUKE_GASP), DUKE_GASP__STATIC },
    { "SLIM_RECOG", DVPTR(SLIM_RECOG), SLIM_RECOG__STATIC },
//     { "ENDSEQVOL3SND1", DVPTR(ENDSEQVOL3SND1), ENDSEQVOL3SND1__STATIC },
    { "DUKE_URINATE", DVPTR(DUKE_URINATE), DUKE_URINATE__STATIC },
    { "ENDSEQVOL3SND2", DVPTR(ENDSEQVOL3SND2), ENDSEQVOL3SND2__STATIC },
    { "ENDSEQVOL3SND3", DVPTR(ENDSEQVOL3SND3), ENDSEQVOL3SND3__STATIC },
    { "DUKE_PASSWIND", DVPTR(DUKE_PASSWIND), DUKE_PASSWIND__STATIC },
    { "DUKE_CRACK", DVPTR(DUKE_CRACK), DUKE_CRACK__STATIC },
    { "SLIM_ATTACK", DVPTR(SLIM_ATTACK), SLIM_ATTACK__STATIC },
    { "SOMETHINGHITFORCE", DVPTR(SOMETHINGHITFORCE), SOMETHINGHITFORCE__STATIC },
    { "DUKE_DRINKING", DVPTR(DUKE_DRINKING), DUKE_DRINKING__STATIC },
    { "DUKE_KILLED1", DVPTR(DUKE_KILLED1), DUKE_KILLED1__STATIC },
    { "DUKE_GRUNT", DVPTR(DUKE_GRUNT), DUKE_GRUNT__STATIC },
    { "DUKE_HARTBEAT", DVPTR(DUKE_HARTBEAT), DUKE_HARTBEAT__STATIC },
    { "DUKE_ONWATER", DVPTR(DUKE_ONWATER), DUKE_ONWATER__STATIC },
    { "DUKE_DEAD", DVPTR(DUKE_DEAD), DUKE_DEAD__STATIC },
    { "DUKE_LAND", DVPTR(DUKE_LAND), DUKE_LAND__STATIC },
    { "DUKE_WALKINDUCTS", DVPTR(DUKE_WALKINDUCTS), DUKE_WALKINDUCTS__STATIC },
    { "DUKE_GLAD", DVPTR(DUKE_GLAD), DUKE_GLAD__STATIC },
    { "DUKE_YES", DVPTR(DUKE_YES), DUKE_YES__STATIC },
    { "DUKE_HEHE", DVPTR(DUKE_HEHE), DUKE_HEHE__STATIC },
    { "DUKE_SHUCKS", DVPTR(DUKE_SHUCKS), DUKE_SHUCKS__STATIC },
    { "DUKE_UNDERWATER", DVPTR(DUKE_UNDERWATER), DUKE_UNDERWATER__STATIC },
    { "DUKE_JETPACK_ON", DVPTR(DUKE_JETPACK_ON), DUKE_JETPACK_ON__STATIC },
    { "DUKE_JETPACK_IDLE", DVPTR(DUKE_JETPACK_IDLE), DUKE_JETPACK_IDLE__STATIC },
    { "DUKE_JETPACK_OFF", DVPTR(DUKE_JETPACK_OFF), DUKE_JETPACK_OFF__STATIC },
    { "LIZTROOP_GROWL", DVPTR(LIZTROOP_GROWL), LIZTROOP_GROWL__STATIC },
    { "LIZTROOP_TALK1", DVPTR(LIZTROOP_TALK1), LIZTROOP_TALK1__STATIC },
    { "LIZTROOP_TALK2", DVPTR(LIZTROOP_TALK2), LIZTROOP_TALK2__STATIC },
    { "LIZTROOP_TALK3", DVPTR(LIZTROOP_TALK3), LIZTROOP_TALK3__STATIC },
    { "DUKETALKTOBOSS", DVPTR(DUKETALKTOBOSS), DUKETALKTOBOSS__STATIC },
    { "LIZCAPT_GROWL", DVPTR(LIZCAPT_GROWL), LIZCAPT_GROWL__STATIC },
    { "LIZCAPT_TALK1", DVPTR(LIZCAPT_TALK1), LIZCAPT_TALK1__STATIC },
    { "LIZCAPT_TALK2", DVPTR(LIZCAPT_TALK2), LIZCAPT_TALK2__STATIC },
    { "LIZCAPT_TALK3", DVPTR(LIZCAPT_TALK3), LIZCAPT_TALK3__STATIC },
    { "LIZARD_BEG", DVPTR(LIZARD_BEG), LIZARD_BEG__STATIC },
    { "LIZARD_PAIN", DVPTR(LIZARD_PAIN), LIZARD_PAIN__STATIC },
    { "LIZARD_DEATH", DVPTR(LIZARD_DEATH), LIZARD_DEATH__STATIC },
    { "LIZARD_SPIT", DVPTR(LIZARD_SPIT), LIZARD_SPIT__STATIC },
    { "DRONE1_HISSRATTLE", DVPTR(DRONE1_HISSRATTLE), DRONE1_HISSRATTLE__STATIC },
    { "DRONE1_HISSSCREECH", DVPTR(DRONE1_HISSSCREECH), DRONE1_HISSSCREECH__STATIC },
    { "DUKE_TIP2", DVPTR(DUKE_TIP2), DUKE_TIP2__STATIC },
    { "FLESH_BURNING", DVPTR(FLESH_BURNING), FLESH_BURNING__STATIC },
    { "SQUISHED", DVPTR(SQUISHED), SQUISHED__STATIC },
    { "TELEPORTER", DVPTR(TELEPORTER), TELEPORTER__STATIC },
    { "ELEVATOR_ON", DVPTR(ELEVATOR_ON), ELEVATOR_ON__STATIC },
    { "DUKE_KILLED3", DVPTR(DUKE_KILLED3), DUKE_KILLED3__STATIC },
    { "ELEVATOR_OFF", DVPTR(ELEVATOR_OFF), ELEVATOR_OFF__STATIC },
    { "DOOR_OPERATE1", DVPTR(DOOR_OPERATE1), DOOR_OPERATE1__STATIC },
    { "SUBWAY", DVPTR(SUBWAY), SUBWAY__STATIC },
    { "SWITCH_ON", DVPTR(SWITCH_ON), SWITCH_ON__STATIC },
    { "FAN", DVPTR(FAN), FAN__STATIC },
    { "DUKE_GETWEAPON3", DVPTR(DUKE_GETWEAPON3), DUKE_GETWEAPON3__STATIC },
    { "FLUSH_TOILET", DVPTR(FLUSH_TOILET), FLUSH_TOILET__STATIC },
    { "HOVER_CRAFT", DVPTR(HOVER_CRAFT), HOVER_CRAFT__STATIC },
    { "EARTHQUAKE", DVPTR(EARTHQUAKE), EARTHQUAKE__STATIC },
    { "INTRUDER_ALERT", DVPTR(INTRUDER_ALERT), INTRUDER_ALERT__STATIC },
    { "END_OF_LEVEL_WARN", DVPTR(END_OF_LEVEL_WARN), END_OF_LEVEL_WARN__STATIC },
    { "ENGINE_OPERATING", DVPTR(ENGINE_OPERATING), ENGINE_OPERATING__STATIC },
    { "REACTOR_ON", DVPTR(REACTOR_ON), REACTOR_ON__STATIC },
    { "COMPUTER_AMBIENCE", DVPTR(COMPUTER_AMBIENCE), COMPUTER_AMBIENCE__STATIC },
    { "GEARS_GRINDING", DVPTR(GEARS_GRINDING), GEARS_GRINDING__STATIC },
    { "BUBBLE_AMBIENCE", DVPTR(BUBBLE_AMBIENCE), BUBBLE_AMBIENCE__STATIC },
    { "MACHINE_AMBIENCE", DVPTR(MACHINE_AMBIENCE), MACHINE_AMBIENCE__STATIC },
    { "SEWER_AMBIENCE", DVPTR(SEWER_AMBIENCE), SEWER_AMBIENCE__STATIC },
    { "WIND_AMBIENCE", DVPTR(WIND_AMBIENCE), WIND_AMBIENCE__STATIC },
    { "SOMETHING_DRIPPING", DVPTR(SOMETHING_DRIPPING), SOMETHING_DRIPPING__STATIC },
    { "STEAM_HISSING", DVPTR(STEAM_HISSING), STEAM_HISSING__STATIC },
    { "THEATER_BREATH", DVPTR(THEATER_BREATH), THEATER_BREATH__STATIC },
    { "BAR_MUSIC", DVPTR(BAR_MUSIC), BAR_MUSIC__STATIC },
    { "BOS1_ROAM", DVPTR(BOS1_ROAM), BOS1_ROAM__STATIC },
    { "BOS1_RECOG", DVPTR(BOS1_RECOG), BOS1_RECOG__STATIC },
    { "BOS1_ATTACK1", DVPTR(BOS1_ATTACK1), BOS1_ATTACK1__STATIC },
    { "BOS1_PAIN", DVPTR(BOS1_PAIN), BOS1_PAIN__STATIC },
    { "BOS1_DYING", DVPTR(BOS1_DYING), BOS1_DYING__STATIC },
    { "BOS2_ROAM", DVPTR(BOS2_ROAM), BOS2_ROAM__STATIC },
    { "BOS2_RECOG", DVPTR(BOS2_RECOG), BOS2_RECOG__STATIC },
    { "BOS2_ATTACK", DVPTR(BOS2_ATTACK), BOS2_ATTACK__STATIC },
    { "BOS2_PAIN", DVPTR(BOS2_PAIN), BOS2_PAIN__STATIC },
    { "BOS2_DYING", DVPTR(BOS2_DYING), BOS2_DYING__STATIC },
    { "GETATOMICHEALTH", DVPTR(GETATOMICHEALTH), GETATOMICHEALTH__STATIC },
    { "DUKE_GETWEAPON2", DVPTR(DUKE_GETWEAPON2), DUKE_GETWEAPON2__STATIC },
    { "BOS3_DYING", DVPTR(BOS3_DYING), BOS3_DYING__STATIC },
    { "SHOTGUN_FIRE", DVPTR(SHOTGUN_FIRE), SHOTGUN_FIRE__STATIC },
    { "PRED_ROAM", DVPTR(PRED_ROAM), PRED_ROAM__STATIC },
    { "PRED_RECOG", DVPTR(PRED_RECOG), PRED_RECOG__STATIC },
    { "PRED_ATTACK", DVPTR(PRED_ATTACK), PRED_ATTACK__STATIC },
    { "PRED_PAIN", DVPTR(PRED_PAIN), PRED_PAIN__STATIC },
    { "PRED_DYING", DVPTR(PRED_DYING), PRED_DYING__STATIC },
    { "CAPT_ROAM", DVPTR(CAPT_ROAM), CAPT_ROAM__STATIC },
    { "CAPT_ATTACK", DVPTR(CAPT_ATTACK), CAPT_ATTACK__STATIC },
    { "CAPT_RECOG", DVPTR(CAPT_RECOG), CAPT_RECOG__STATIC },
    { "CAPT_PAIN", DVPTR(CAPT_PAIN), CAPT_PAIN__STATIC },
    { "CAPT_DYING", DVPTR(CAPT_DYING), CAPT_DYING__STATIC },
    { "PIG_ROAM", DVPTR(PIG_ROAM), PIG_ROAM__STATIC },
    { "PIG_RECOG", DVPTR(PIG_RECOG), PIG_RECOG__STATIC },
    { "PIG_ATTACK", DVPTR(PIG_ATTACK), PIG_ATTACK__STATIC },
    { "PIG_PAIN", DVPTR(PIG_PAIN), PIG_PAIN__STATIC },
    { "PIG_DYING", DVPTR(PIG_DYING), PIG_DYING__STATIC },
    { "RECO_ROAM", DVPTR(RECO_ROAM), RECO_ROAM__STATIC },
    { "RECO_RECOG", DVPTR(RECO_RECOG), RECO_RECOG__STATIC },
    { "RECO_ATTACK", DVPTR(RECO_ATTACK), RECO_ATTACK__STATIC },
    { "RECO_PAIN", DVPTR(RECO_PAIN), RECO_PAIN__STATIC },
    { "RECO_DYING", DVPTR(RECO_DYING), RECO_DYING__STATIC },
    { "DRON_ROAM", DVPTR(DRON_ROAM), DRON_ROAM__STATIC },
    { "DRON_RECOG", DVPTR(DRON_RECOG), DRON_RECOG__STATIC },
    { "DRON_ATTACK1", DVPTR(DRON_ATTACK1), DRON_ATTACK1__STATIC },
    { "DRON_PAIN", DVPTR(DRON_PAIN), DRON_PAIN__STATIC },
    { "DRON_DYING", DVPTR(DRON_DYING), DRON_DYING__STATIC },
    { "COMM_ROAM", DVPTR(COMM_ROAM), COMM_ROAM__STATIC },
    { "COMM_RECOG", DVPTR(COMM_RECOG), COMM_RECOG__STATIC },
    { "COMM_ATTACK", DVPTR(COMM_ATTACK), COMM_ATTACK__STATIC },
    { "COMM_PAIN", DVPTR(COMM_PAIN), COMM_PAIN__STATIC },
    { "COMM_DYING", DVPTR(COMM_DYING), COMM_DYING__STATIC },
    { "OCTA_ROAM", DVPTR(OCTA_ROAM), OCTA_ROAM__STATIC },
    { "OCTA_RECOG", DVPTR(OCTA_RECOG), OCTA_RECOG__STATIC },
    { "OCTA_ATTACK1", DVPTR(OCTA_ATTACK1), OCTA_ATTACK1__STATIC },
    { "OCTA_PAIN", DVPTR(OCTA_PAIN), OCTA_PAIN__STATIC },
    { "OCTA_DYING", DVPTR(OCTA_DYING), OCTA_DYING__STATIC },
    { "TURR_ROAM", DVPTR(TURR_ROAM), TURR_ROAM__STATIC },
    { "TURR_RECOG", DVPTR(TURR_RECOG), TURR_RECOG__STATIC },
    { "TURR_ATTACK", DVPTR(TURR_ATTACK), TURR_ATTACK__STATIC },
    { "DUMPSTER_MOVE", DVPTR(DUMPSTER_MOVE), DUMPSTER_MOVE__STATIC },
    { "SLIM_DYING", DVPTR(SLIM_DYING), SLIM_DYING__STATIC },
    { "BOS3_ROAM", DVPTR(BOS3_ROAM), BOS3_ROAM__STATIC },
    { "BOS3_RECOG", DVPTR(BOS3_RECOG), BOS3_RECOG__STATIC },
    { "BOS3_ATTACK1", DVPTR(BOS3_ATTACK1), BOS3_ATTACK1__STATIC },
    { "BOS3_PAIN", DVPTR(BOS3_PAIN), BOS3_PAIN__STATIC },
    { "BOS1_ATTACK2", DVPTR(BOS1_ATTACK2), BOS1_ATTACK2__STATIC },
    { "COMM_SPIN", DVPTR(COMM_SPIN), COMM_SPIN__STATIC },
    { "BOS1_WALK", DVPTR(BOS1_WALK), BOS1_WALK__STATIC },
    { "DRON_ATTACK2", DVPTR(DRON_ATTACK2), DRON_ATTACK2__STATIC },
    { "THUD", DVPTR(THUD), THUD__STATIC },
    { "OCTA_ATTACK2", DVPTR(OCTA_ATTACK2), OCTA_ATTACK2__STATIC },
    { "WIERDSHOT_FLY", DVPTR(WIERDSHOT_FLY), WIERDSHOT_FLY__STATIC },
    { "TURR_PAIN", DVPTR(TURR_PAIN), TURR_PAIN__STATIC },
    { "TURR_DYING", DVPTR(TURR_DYING), TURR_DYING__STATIC },
    { "SLIM_ROAM", DVPTR(SLIM_ROAM), SLIM_ROAM__STATIC },
    { "LADY_SCREAM", DVPTR(LADY_SCREAM), LADY_SCREAM__STATIC },
    { "DOOR_OPERATE2", DVPTR(DOOR_OPERATE2), DOOR_OPERATE2__STATIC },
    { "DOOR_OPERATE3", DVPTR(DOOR_OPERATE3), DOOR_OPERATE3__STATIC },
    { "DOOR_OPERATE4", DVPTR(DOOR_OPERATE4), DOOR_OPERATE4__STATIC },
    { "BORNTOBEWILDSND", DVPTR(BORNTOBEWILDSND), BORNTOBEWILDSND__STATIC },
    { "SHOTGUN_COCK", DVPTR(SHOTGUN_COCK), SHOTGUN_COCK__STATIC },
    { "GENERIC_AMBIENCE1", DVPTR(GENERIC_AMBIENCE1), GENERIC_AMBIENCE1__STATIC },
    { "GENERIC_AMBIENCE2", DVPTR(GENERIC_AMBIENCE2), GENERIC_AMBIENCE2__STATIC },
    { "GENERIC_AMBIENCE3", DVPTR(GENERIC_AMBIENCE3), GENERIC_AMBIENCE3__STATIC },
    { "GENERIC_AMBIENCE4", DVPTR(GENERIC_AMBIENCE4), GENERIC_AMBIENCE4__STATIC },
    { "GENERIC_AMBIENCE5", DVPTR(GENERIC_AMBIENCE5), GENERIC_AMBIENCE5__STATIC },
    { "GENERIC_AMBIENCE6", DVPTR(GENERIC_AMBIENCE6), GENERIC_AMBIENCE6__STATIC },
    { "BOS3_ATTACK2", DVPTR(BOS3_ATTACK2), BOS3_ATTACK2__STATIC },
    { "GENERIC_AMBIENCE17", DVPTR(GENERIC_AMBIENCE17), GENERIC_AMBIENCE17__STATIC },
    { "GENERIC_AMBIENCE18", DVPTR(GENERIC_AMBIENCE18), GENERIC_AMBIENCE18__STATIC },
    { "GENERIC_AMBIENCE19", DVPTR(GENERIC_AMBIENCE19), GENERIC_AMBIENCE19__STATIC },
    { "GENERIC_AMBIENCE20", DVPTR(GENERIC_AMBIENCE20), GENERIC_AMBIENCE20__STATIC },
    { "GENERIC_AMBIENCE21", DVPTR(GENERIC_AMBIENCE21), GENERIC_AMBIENCE21__STATIC },
    { "GENERIC_AMBIENCE22", DVPTR(GENERIC_AMBIENCE22), GENERIC_AMBIENCE22__STATIC },
    { "SECRETLEVELSND", DVPTR(SECRETLEVELSND), SECRETLEVELSND__STATIC },
    { "GENERIC_AMBIENCE8", DVPTR(GENERIC_AMBIENCE8), GENERIC_AMBIENCE8__STATIC },
    { "GENERIC_AMBIENCE9", DVPTR(GENERIC_AMBIENCE9), GENERIC_AMBIENCE9__STATIC },
    { "GENERIC_AMBIENCE10", DVPTR(GENERIC_AMBIENCE10), GENERIC_AMBIENCE10__STATIC },
    { "GENERIC_AMBIENCE11", DVPTR(GENERIC_AMBIENCE11), GENERIC_AMBIENCE11__STATIC },
    { "GENERIC_AMBIENCE12", DVPTR(GENERIC_AMBIENCE12), GENERIC_AMBIENCE12__STATIC },
    { "GENERIC_AMBIENCE13", DVPTR(GENERIC_AMBIENCE13), GENERIC_AMBIENCE13__STATIC },
    { "GENERIC_AMBIENCE14", DVPTR(GENERIC_AMBIENCE14), GENERIC_AMBIENCE14__STATIC },
    { "GENERIC_AMBIENCE15", DVPTR(GENERIC_AMBIENCE15), GENERIC_AMBIENCE15__STATIC },
    { "GENERIC_AMBIENCE16", DVPTR(GENERIC_AMBIENCE16), GENERIC_AMBIENCE16__STATIC },
    { "FIRE_CRACKLE", DVPTR(FIRE_CRACKLE), FIRE_CRACKLE__STATIC },
    { "BONUS_SPEECH1", DVPTR(BONUS_SPEECH1), BONUS_SPEECH1__STATIC },
    { "BONUS_SPEECH2", DVPTR(BONUS_SPEECH2), BONUS_SPEECH2__STATIC },
    { "BONUS_SPEECH3", DVPTR(BONUS_SPEECH3), BONUS_SPEECH3__STATIC },
    { "PIG_CAPTURE_DUKE", DVPTR(PIG_CAPTURE_DUKE), PIG_CAPTURE_DUKE__STATIC },
    { "BONUS_SPEECH4", DVPTR(BONUS_SPEECH4), BONUS_SPEECH4__STATIC },
    { "DUKE_LAND_HURT", DVPTR(DUKE_LAND_HURT), DUKE_LAND_HURT__STATIC },
    { "DUKE_HIT_STRIPPER1", DVPTR(DUKE_HIT_STRIPPER1), DUKE_HIT_STRIPPER1__STATIC },
    { "DUKE_TIP1", DVPTR(DUKE_TIP1), DUKE_TIP1__STATIC },
    { "DUKE_KILLED2", DVPTR(DUKE_KILLED2), DUKE_KILLED2__STATIC },
    { "PRED_ROAM2", DVPTR(PRED_ROAM2), PRED_ROAM2__STATIC },
    { "PIG_ROAM2", DVPTR(PIG_ROAM2), PIG_ROAM2__STATIC },
    { "DUKE_GETWEAPON1", DVPTR(DUKE_GETWEAPON1), DUKE_GETWEAPON1__STATIC },
    { "DUKE_SEARCH2", DVPTR(DUKE_SEARCH2), DUKE_SEARCH2__STATIC },
    { "DUKE_CRACK2", DVPTR(DUKE_CRACK2), DUKE_CRACK2__STATIC },
    { "DUKE_SEARCH", DVPTR(DUKE_SEARCH), DUKE_SEARCH__STATIC },
    { "DUKE_GET", DVPTR(DUKE_GET), DUKE_GET__STATIC },
    { "DUKE_LONGTERM_PAIN", DVPTR(DUKE_LONGTERM_PAIN), DUKE_LONGTERM_PAIN__STATIC },
    { "MONITOR_ACTIVE", DVPTR(MONITOR_ACTIVE), MONITOR_ACTIVE__STATIC },
    { "NITEVISION_ONOFF", DVPTR(NITEVISION_ONOFF), NITEVISION_ONOFF__STATIC },
    { "DUKE_HIT_STRIPPER2", DVPTR(DUKE_HIT_STRIPPER2), DUKE_HIT_STRIPPER2__STATIC },
    { "DUKE_CRACK_FIRST", DVPTR(DUKE_CRACK_FIRST), DUKE_CRACK_FIRST__STATIC },
    { "DUKE_USEMEDKIT", DVPTR(DUKE_USEMEDKIT), DUKE_USEMEDKIT__STATIC },
    { "DUKE_TAKEPILLS", DVPTR(DUKE_TAKEPILLS), DUKE_TAKEPILLS__STATIC },
    { "DUKE_PISSRELIEF", DVPTR(DUKE_PISSRELIEF), DUKE_PISSRELIEF__STATIC },
    { "SELECT_WEAPON", DVPTR(SELECT_WEAPON), SELECT_WEAPON__STATIC },
    { "WATER_GURGLE", DVPTR(WATER_GURGLE), WATER_GURGLE__STATIC },
    { "DUKE_GETWEAPON4", DVPTR(DUKE_GETWEAPON4), DUKE_GETWEAPON4__STATIC },
    { "JIBBED_ACTOR1", DVPTR(JIBBED_ACTOR1), JIBBED_ACTOR1__STATIC },
    { "JIBBED_ACTOR2", DVPTR(JIBBED_ACTOR2), JIBBED_ACTOR2__STATIC },
    { "JIBBED_ACTOR3", DVPTR(JIBBED_ACTOR3), JIBBED_ACTOR3__STATIC },
    { "JIBBED_ACTOR4", DVPTR(JIBBED_ACTOR4), JIBBED_ACTOR4__STATIC },
    { "JIBBED_ACTOR5", DVPTR(JIBBED_ACTOR5), JIBBED_ACTOR5__STATIC },
    { "JIBBED_ACTOR6", DVPTR(JIBBED_ACTOR6), JIBBED_ACTOR6__STATIC },
    { "JIBBED_ACTOR7", DVPTR(JIBBED_ACTOR7), JIBBED_ACTOR7__STATIC },
    { "DUKE_GOTHEALTHATLOW", DVPTR(DUKE_GOTHEALTHATLOW), DUKE_GOTHEALTHATLOW__STATIC },
    { "BOSSTALKTODUKE", DVPTR(BOSSTALKTODUKE), BOSSTALKTODUKE__STATIC },
    { "WAR_AMBIENCE1", DVPTR(WAR_AMBIENCE1), WAR_AMBIENCE1__STATIC },
    { "WAR_AMBIENCE2", DVPTR(WAR_AMBIENCE2), WAR_AMBIENCE2__STATIC },
    { "WAR_AMBIENCE3", DVPTR(WAR_AMBIENCE3), WAR_AMBIENCE3__STATIC },
    { "WAR_AMBIENCE4", DVPTR(WAR_AMBIENCE4), WAR_AMBIENCE4__STATIC },
    { "WAR_AMBIENCE5", DVPTR(WAR_AMBIENCE5), WAR_AMBIENCE5__STATIC },
    { "WAR_AMBIENCE6", DVPTR(WAR_AMBIENCE6), WAR_AMBIENCE6__STATIC },
    { "WAR_AMBIENCE7", DVPTR(WAR_AMBIENCE7), WAR_AMBIENCE7__STATIC },
    { "WAR_AMBIENCE8", DVPTR(WAR_AMBIENCE8), WAR_AMBIENCE8__STATIC },
    { "WAR_AMBIENCE9", DVPTR(WAR_AMBIENCE9), WAR_AMBIENCE9__STATIC },
    { "WAR_AMBIENCE10", DVPTR(WAR_AMBIENCE10), WAR_AMBIENCE10__STATIC },
    { "ALIEN_TALK1", DVPTR(ALIEN_TALK1), ALIEN_TALK1__STATIC },
    { "ALIEN_TALK2", DVPTR(ALIEN_TALK2), ALIEN_TALK2__STATIC },
    { "EXITMENUSOUND", DVPTR(EXITMENUSOUND), EXITMENUSOUND__STATIC },
    { "FLY_BY", DVPTR(FLY_BY), FLY_BY__STATIC },
    { "DUKE_SCREAM", DVPTR(DUKE_SCREAM), DUKE_SCREAM__STATIC },
    { "SHRINKER_HIT", DVPTR(SHRINKER_HIT), SHRINKER_HIT__STATIC },
    { "RATTY", DVPTR(RATTY), RATTY__STATIC },
    { "INTO_MENU", DVPTR(INTO_MENU), INTO_MENU__STATIC },
    { "BONUSMUSIC", DVPTR(BONUSMUSIC), BONUSMUSIC__STATIC },
    { "DUKE_BOOBY", DVPTR(DUKE_BOOBY), DUKE_BOOBY__STATIC },
    { "DUKE_TALKTOBOSSFALL", DVPTR(DUKE_TALKTOBOSSFALL), DUKE_TALKTOBOSSFALL__STATIC },
    { "DUKE_LOOKINTOMIRROR", DVPTR(DUKE_LOOKINTOMIRROR), DUKE_LOOKINTOMIRROR__STATIC },
    { "PIG_ROAM3", DVPTR(PIG_ROAM3), PIG_ROAM3__STATIC },
    { "KILLME", DVPTR(KILLME), KILLME__STATIC },
    { "DRON_JETSND", DVPTR(DRON_JETSND), DRON_JETSND__STATIC },
    { "SPACE_DOOR1", DVPTR(SPACE_DOOR1), SPACE_DOOR1__STATIC },
    { "SPACE_DOOR2", DVPTR(SPACE_DOOR2), SPACE_DOOR2__STATIC },
    { "SPACE_DOOR3", DVPTR(SPACE_DOOR3), SPACE_DOOR3__STATIC },
    { "SPACE_DOOR4", DVPTR(SPACE_DOOR4), SPACE_DOOR4__STATIC },
    { "SPACE_DOOR5", DVPTR(SPACE_DOOR5), SPACE_DOOR5__STATIC },
    { "ALIEN_ELEVATOR1", DVPTR(ALIEN_ELEVATOR1), ALIEN_ELEVATOR1__STATIC },
    { "VAULT_DOOR", DVPTR(VAULT_DOOR), VAULT_DOOR__STATIC },
    { "JIBBED_ACTOR13", DVPTR(JIBBED_ACTOR13), JIBBED_ACTOR13__STATIC },
    { "DUKE_GETWEAPON6", DVPTR(DUKE_GETWEAPON6), DUKE_GETWEAPON6__STATIC },
    { "JIBBED_ACTOR8", DVPTR(JIBBED_ACTOR8), JIBBED_ACTOR8__STATIC },
    { "JIBBED_ACTOR9", DVPTR(JIBBED_ACTOR9), JIBBED_ACTOR9__STATIC },
    { "JIBBED_ACTOR10", DVPTR(JIBBED_ACTOR10), JIBBED_ACTOR10__STATIC },
    { "JIBBED_ACTOR11", DVPTR(JIBBED_ACTOR11), JIBBED_ACTOR11__STATIC },
    { "JIBBED_ACTOR12", DVPTR(JIBBED_ACTOR12), JIBBED_ACTOR12__STATIC },
    { "DUKE_KILLED4", DVPTR(DUKE_KILLED4), DUKE_KILLED4__STATIC },
    { "DUKE_KILLED5", DVPTR(DUKE_KILLED5), DUKE_KILLED5__STATIC },
    { "ALIEN_SWITCH1", DVPTR(ALIEN_SWITCH1), ALIEN_SWITCH1__STATIC },
    { "DUKE_STEPONFECES", DVPTR(DUKE_STEPONFECES), DUKE_STEPONFECES__STATIC },
    { "DUKE_LONGTERM_PAIN2", DVPTR(DUKE_LONGTERM_PAIN2), DUKE_LONGTERM_PAIN2__STATIC },
    { "DUKE_LONGTERM_PAIN3", DVPTR(DUKE_LONGTERM_PAIN3), DUKE_LONGTERM_PAIN3__STATIC },
    { "DUKE_LONGTERM_PAIN4", DVPTR(DUKE_LONGTERM_PAIN4), DUKE_LONGTERM_PAIN4__STATIC },
    { "COMPANB2", DVPTR(COMPANB2), COMPANB2__STATIC },
    { "KTIT", DVPTR(KTIT), KTIT__STATIC },
    { "HELICOP_IDLE", DVPTR(HELICOP_IDLE), HELICOP_IDLE__STATIC },
    { "STEPNIT", DVPTR(STEPNIT), STEPNIT__STATIC },
    { "SPACE_AMBIENCE1", DVPTR(SPACE_AMBIENCE1), SPACE_AMBIENCE1__STATIC },
    { "SPACE_AMBIENCE2", DVPTR(SPACE_AMBIENCE2), SPACE_AMBIENCE2__STATIC },
    { "SLIM_HATCH", DVPTR(SLIM_HATCH), SLIM_HATCH__STATIC },
    { "RIPHEADNECK", DVPTR(RIPHEADNECK), RIPHEADNECK__STATIC },
    { "FOUNDJONES", DVPTR(FOUNDJONES), FOUNDJONES__STATIC },
    { "ALIEN_DOOR1", DVPTR(ALIEN_DOOR1), ALIEN_DOOR1__STATIC },
    { "ALIEN_DOOR2", DVPTR(ALIEN_DOOR2), ALIEN_DOOR2__STATIC },
    { "ENDSEQVOL3SND4", DVPTR(ENDSEQVOL3SND4), ENDSEQVOL3SND4__STATIC },
    { "ENDSEQVOL3SND5", DVPTR(ENDSEQVOL3SND5), ENDSEQVOL3SND5__STATIC },
    { "ENDSEQVOL3SND6", DVPTR(ENDSEQVOL3SND6), ENDSEQVOL3SND6__STATIC },
    { "ENDSEQVOL3SND7", DVPTR(ENDSEQVOL3SND7), ENDSEQVOL3SND7__STATIC },
    { "ENDSEQVOL3SND8", DVPTR(ENDSEQVOL3SND8), ENDSEQVOL3SND8__STATIC },
    { "ENDSEQVOL3SND9", DVPTR(ENDSEQVOL3SND9), ENDSEQVOL3SND9__STATIC },
    { "WHIPYOURASS", DVPTR(WHIPYOURASS), WHIPYOURASS__STATIC },
    { "ENDSEQVOL2SND1", DVPTR(ENDSEQVOL2SND1), ENDSEQVOL2SND1__STATIC },
    { "ENDSEQVOL2SND2", DVPTR(ENDSEQVOL2SND2), ENDSEQVOL2SND2__STATIC },
    { "ENDSEQVOL2SND3", DVPTR(ENDSEQVOL2SND3), ENDSEQVOL2SND3__STATIC },
    { "ENDSEQVOL2SND4", DVPTR(ENDSEQVOL2SND4), ENDSEQVOL2SND4__STATIC },
    { "ENDSEQVOL2SND5", DVPTR(ENDSEQVOL2SND5), ENDSEQVOL2SND5__STATIC },
    { "ENDSEQVOL2SND6", DVPTR(ENDSEQVOL2SND6), ENDSEQVOL2SND6__STATIC },
    { "ENDSEQVOL2SND7", DVPTR(ENDSEQVOL2SND7), ENDSEQVOL2SND7__STATIC },
    { "GENERIC_AMBIENCE23", DVPTR(GENERIC_AMBIENCE23), GENERIC_AMBIENCE23__STATIC },
    { "SOMETHINGFROZE", DVPTR(SOMETHINGFROZE), SOMETHINGFROZE__STATIC },
    { "DUKE_LONGTERM_PAIN5", DVPTR(DUKE_LONGTERM_PAIN5), DUKE_LONGTERM_PAIN5__STATIC },
    { "DUKE_LONGTERM_PAIN6", DVPTR(DUKE_LONGTERM_PAIN6), DUKE_LONGTERM_PAIN6__STATIC },
    { "DUKE_LONGTERM_PAIN7", DVPTR(DUKE_LONGTERM_PAIN7), DUKE_LONGTERM_PAIN7__STATIC },
    { "DUKE_LONGTERM_PAIN8", DVPTR(DUKE_LONGTERM_PAIN8), DUKE_LONGTERM_PAIN8__STATIC },
    { "WIND_REPEAT", DVPTR(WIND_REPEAT), WIND_REPEAT__STATIC },
    { "MYENEMY_ROAM", DVPTR(MYENEMY_ROAM), MYENEMY_ROAM__STATIC },
    { "MYENEMY_HURT", DVPTR(MYENEMY_HURT), MYENEMY_HURT__STATIC },
    { "MYENEMY_DEAD", DVPTR(MYENEMY_DEAD), MYENEMY_DEAD__STATIC },
    { "MYENEMY_SHOOT", DVPTR(MYENEMY_SHOOT), MYENEMY_SHOOT__STATIC },
    { "STORE_MUSIC", DVPTR(STORE_MUSIC), STORE_MUSIC__STATIC },
    { "STORE_MUSIC_BROKE", DVPTR(STORE_MUSIC_BROKE), STORE_MUSIC_BROKE__STATIC },
    { "ACTOR_GROWING", DVPTR(ACTOR_GROWING), ACTOR_GROWING__STATIC },
    { "NEWBEAST_ROAM", DVPTR(NEWBEAST_ROAM), NEWBEAST_ROAM__STATIC },
    { "NEWBEAST_RECOG", DVPTR(NEWBEAST_RECOG), NEWBEAST_RECOG__STATIC },
    { "NEWBEAST_ATTACK", DVPTR(NEWBEAST_ATTACK), NEWBEAST_ATTACK__STATIC },
    { "NEWBEAST_PAIN", DVPTR(NEWBEAST_PAIN), NEWBEAST_PAIN__STATIC },
    { "NEWBEAST_DYING", DVPTR(NEWBEAST_DYING), NEWBEAST_DYING__STATIC },
    { "NEWBEAST_SPIT", DVPTR(NEWBEAST_SPIT), NEWBEAST_SPIT__STATIC },
    { "VOL4_1", DVPTR(VOL4_1), VOL4_1__STATIC },
    { "SUPERMARKET", DVPTR(SUPERMARKET), SUPERMARKET__STATIC },
    { "MOUSEANNOY", DVPTR(MOUSEANNOY), MOUSEANNOY__STATIC },
    { "BOOKEM", DVPTR(BOOKEM), BOOKEM__STATIC },
    { "SUPERMARKETCRY", DVPTR(SUPERMARKETCRY), SUPERMARKETCRY__STATIC },
    { "DESTRUCT", DVPTR(DESTRUCT), DESTRUCT__STATIC },
    { "EATFOOD", DVPTR(EATFOOD), EATFOOD__STATIC },
    { "MAKEMYDAY", DVPTR(MAKEMYDAY), MAKEMYDAY__STATIC },
    { "WITNESSSTAND", DVPTR(WITNESSSTAND), WITNESSSTAND__STATIC },
    { "VACATIONSPEECH", DVPTR(VACATIONSPEECH), VACATIONSPEECH__STATIC },
    { "YIPPEE1", DVPTR(YIPPEE1), YIPPEE1__STATIC },
    { "YOHOO1", DVPTR(YOHOO1), YOHOO1__STATIC },
    { "YOHOO2", DVPTR(YOHOO2), YOHOO2__STATIC },
    { "DOLPHINSND", DVPTR(DOLPHINSND), DOLPHINSND__STATIC },
    { "TOUGHGALSND1", DVPTR(TOUGHGALSND1), TOUGHGALSND1__STATIC },
    { "TOUGHGALSND2", DVPTR(TOUGHGALSND2), TOUGHGALSND2__STATIC },
    { "TOUGHGALSND3", DVPTR(TOUGHGALSND3), TOUGHGALSND3__STATIC },
    { "TOUGHGALSND4", DVPTR(TOUGHGALSND4), TOUGHGALSND4__STATIC },
    { "TANK_ROAM", DVPTR(TANK_ROAM), TANK_ROAM__STATIC },
    { "BOS4_ROAM", DVPTR(BOS4_ROAM), BOS4_ROAM__STATIC },
    { "BOS4_RECOG", DVPTR(BOS4_RECOG), BOS4_RECOG__STATIC },
    { "BOS4_ATTACK", DVPTR(BOS4_ATTACK), BOS4_ATTACK__STATIC },
    { "BOS4_PAIN", DVPTR(BOS4_PAIN), BOS4_PAIN__STATIC },
    { "BOS4_DYING", DVPTR(BOS4_DYING), BOS4_DYING__STATIC },
    { "NEWBEAST_ATTACKMISS", DVPTR(NEWBEAST_ATTACKMISS), NEWBEAST_ATTACKMISS__STATIC },
    { "VOL4_2", DVPTR(VOL4_2), VOL4_2__STATIC },
    { "COOKINGDEEPFRIER", DVPTR(COOKINGDEEPFRIER), COOKINGDEEPFRIER__STATIC },
    { "WHINING_DOG", DVPTR(WHINING_DOG), WHINING_DOG__STATIC },
    { "DEAD_DOG", DVPTR(DEAD_DOG), DEAD_DOG__STATIC },
    { "LIGHTNING_SLAP", DVPTR(LIGHTNING_SLAP), LIGHTNING_SLAP__STATIC },
    { "THUNDER", DVPTR(THUNDER), THUNDER__STATIC },
    { "HAPPYMOUSESND1", DVPTR(HAPPYMOUSESND1), HAPPYMOUSESND1__STATIC },
    { "HAPPYMOUSESND2", DVPTR(HAPPYMOUSESND2), HAPPYMOUSESND2__STATIC },
    { "HAPPYMOUSESND3", DVPTR(HAPPYMOUSESND3), HAPPYMOUSESND3__STATIC },
    { "HAPPYMOUSESND4", DVPTR(HAPPYMOUSESND4), HAPPYMOUSESND4__STATIC },
    { "ALARM", DVPTR(ALARM), ALARM__STATIC },
    { "RAIN", DVPTR(RAIN), RAIN__STATIC },
    { "DTAG_GREENRUN", DVPTR(DTAG_GREENRUN), DTAG_GREENRUN__STATIC },
    { "DTAG_BROWNRUN", DVPTR(DTAG_BROWNRUN), DTAG_BROWNRUN__STATIC },
    { "DTAG_GREENSCORE", DVPTR(DTAG_GREENSCORE), DTAG_GREENSCORE__STATIC },
    { "DTAG_BROWNSCORE", DVPTR(DTAG_BROWNSCORE), DTAG_BROWNSCORE__STATIC },
    { "INTRO4_1", DVPTR(INTRO4_1), INTRO4_1__STATIC },
    { "INTRO4_2", DVPTR(INTRO4_2), INTRO4_2__STATIC },
    { "INTRO4_3", DVPTR(INTRO4_3), INTRO4_3__STATIC },
    { "INTRO4_4", DVPTR(INTRO4_4), INTRO4_4__STATIC },
    { "INTRO4_5", DVPTR(INTRO4_5), INTRO4_5__STATIC },
    { "INTRO4_6", DVPTR(INTRO4_6), INTRO4_6__STATIC },
    { "SCREECH", DVPTR(SCREECH), SCREECH__STATIC },
    { "BOSS4_DEADSPEECH", DVPTR(BOSS4_DEADSPEECH), BOSS4_DEADSPEECH__STATIC },
    { "BOSS4_FIRSTSEE", DVPTR(BOSS4_FIRSTSEE), BOSS4_FIRSTSEE__STATIC },
    { "PARTY_SPEECH", DVPTR(PARTY_SPEECH), PARTY_SPEECH__STATIC },
    { "POSTAL_SPEECH", DVPTR(POSTAL_SPEECH), POSTAL_SPEECH__STATIC },
    { "TGSPEECH", DVPTR(TGSPEECH), TGSPEECH__STATIC },
    { "DOGROOMSPEECH", DVPTR(DOGROOMSPEECH), DOGROOMSPEECH__STATIC },
    { "SMACKED", DVPTR(SMACKED), SMACKED__STATIC },
    { "MDEVSPEECH", DVPTR(MDEVSPEECH), MDEVSPEECH__STATIC },
    { "AREA51SPEECH", DVPTR(AREA51SPEECH), AREA51SPEECH__STATIC },
    { "JEEPSOUND", DVPTR(JEEPSOUND), JEEPSOUND__STATIC },
    { "BIGDOORSLAM", DVPTR(BIGDOORSLAM), BIGDOORSLAM__STATIC },
    { "BOS4_LAY", DVPTR(BOS4_LAY), BOS4_LAY__STATIC },
    { "WAVESOUND", DVPTR(WAVESOUND), WAVESOUND__STATIC },
    { "ILLBEBACK", DVPTR(ILLBEBACK), ILLBEBACK__STATIC },
    { "VOL4ENDSND1", DVPTR(VOL4ENDSND1), VOL4ENDSND1__STATIC },
    { "VOL4ENDSND2", DVPTR(VOL4ENDSND2), VOL4ENDSND2__STATIC },
    { "EXPANDERHIT", DVPTR(EXPANDERHIT), EXPANDERHIT__STATIC },
    { "SNAKESPEECH", DVPTR(SNAKESPEECH), SNAKESPEECH__STATIC },
    { "EXPANDERSHOOT", DVPTR(EXPANDERSHOOT), EXPANDERSHOOT__STATIC },
    { "GETBACKTOWORK", DVPTR(GETBACKTOWORK), GETBACKTOWORK__STATIC },
    { "JIBBED_ACTOR14", DVPTR(JIBBED_ACTOR14), JIBBED_ACTOR14__STATIC },
    { "JIBBED_ACTOR15", DVPTR(JIBBED_ACTOR15), JIBBED_ACTOR15__STATIC },
    { "INTRO4_B", DVPTR(INTRO4_B), INTRO4_B__STATIC },
    { "BIGBANG", DVPTR(BIGBANG), BIGBANG__STATIC },
    { "HORNSND", DVPTR(HORNSND), HORNSND__STATIC },
    { "BELLSND", DVPTR(BELLSND), BELLSND__STATIC },
    { "GOAWAY", DVPTR(GOAWAY), GOAWAY__STATIC },
    { "JOKE", DVPTR(JOKE), JOKE__STATIC },
    { NULL, NULL, -1 },
 };

#ifdef DYNSOUNDREMAP_ENABLE

int32_t KICK_HIT = KICK_HIT__STATIC;
int32_t PISTOL_RICOCHET = PISTOL_RICOCHET__STATIC;
int32_t PISTOL_BODYHIT = PISTOL_BODYHIT__STATIC;
int32_t PISTOL_FIRE = PISTOL_FIRE__STATIC;
int32_t EJECT_CLIP = EJECT_CLIP__STATIC;
int32_t INSERT_CLIP = INSERT_CLIP__STATIC;
int32_t CHAINGUN_FIRE = CHAINGUN_FIRE__STATIC;
int32_t RPG_SHOOT = RPG_SHOOT__STATIC;
int32_t POOLBALLHIT = POOLBALLHIT__STATIC;
int32_t RPG_EXPLODE = RPG_EXPLODE__STATIC;
int32_t CAT_FIRE = CAT_FIRE__STATIC;
int32_t SHRINKER_FIRE = SHRINKER_FIRE__STATIC;
int32_t ACTOR_SHRINKING = ACTOR_SHRINKING__STATIC;
int32_t PIPEBOMB_BOUNCE = PIPEBOMB_BOUNCE__STATIC;
int32_t PIPEBOMB_EXPLODE = PIPEBOMB_EXPLODE__STATIC;
int32_t LASERTRIP_ONWALL = LASERTRIP_ONWALL__STATIC;
int32_t LASERTRIP_ARMING = LASERTRIP_ARMING__STATIC;
int32_t LASERTRIP_EXPLODE = LASERTRIP_EXPLODE__STATIC;
int32_t VENT_BUST = VENT_BUST__STATIC;
int32_t GLASS_BREAKING = GLASS_BREAKING__STATIC;
int32_t GLASS_HEAVYBREAK = GLASS_HEAVYBREAK__STATIC;
int32_t SHORT_CIRCUIT = SHORT_CIRCUIT__STATIC;
int32_t ITEM_SPLASH = ITEM_SPLASH__STATIC;
int32_t DUKE_BREATHING = DUKE_BREATHING__STATIC;
int32_t DUKE_EXHALING = DUKE_EXHALING__STATIC;
int32_t DUKE_GASP = DUKE_GASP__STATIC;
int32_t SLIM_RECOG = SLIM_RECOG__STATIC;
// int32_t ENDSEQVOL3SND1 = ENDSEQVOL3SND1__STATIC;
int32_t DUKE_URINATE = DUKE_URINATE__STATIC;
int32_t ENDSEQVOL3SND2 = ENDSEQVOL3SND2__STATIC;
int32_t ENDSEQVOL3SND3 = ENDSEQVOL3SND3__STATIC;
int32_t DUKE_PASSWIND = DUKE_PASSWIND__STATIC;
int32_t DUKE_CRACK = DUKE_CRACK__STATIC;
int32_t SLIM_ATTACK = SLIM_ATTACK__STATIC;
int32_t SOMETHINGHITFORCE = SOMETHINGHITFORCE__STATIC;
int32_t DUKE_DRINKING = DUKE_DRINKING__STATIC;
int32_t DUKE_KILLED1 = DUKE_KILLED1__STATIC;
int32_t DUKE_GRUNT = DUKE_GRUNT__STATIC;
int32_t DUKE_HARTBEAT = DUKE_HARTBEAT__STATIC;
int32_t DUKE_ONWATER = DUKE_ONWATER__STATIC;
int32_t DUKE_DEAD = DUKE_DEAD__STATIC;
int32_t DUKE_LAND = DUKE_LAND__STATIC;
int32_t DUKE_WALKINDUCTS = DUKE_WALKINDUCTS__STATIC;
int32_t DUKE_GLAD = DUKE_GLAD__STATIC;
int32_t DUKE_YES = DUKE_YES__STATIC;
int32_t DUKE_HEHE = DUKE_HEHE__STATIC;
int32_t DUKE_SHUCKS = DUKE_SHUCKS__STATIC;
int32_t DUKE_UNDERWATER = DUKE_UNDERWATER__STATIC;
int32_t DUKE_JETPACK_ON = DUKE_JETPACK_ON__STATIC;
int32_t DUKE_JETPACK_IDLE = DUKE_JETPACK_IDLE__STATIC;
int32_t DUKE_JETPACK_OFF = DUKE_JETPACK_OFF__STATIC;
int32_t LIZTROOP_GROWL = LIZTROOP_GROWL__STATIC;
int32_t LIZTROOP_TALK1 = LIZTROOP_TALK1__STATIC;
int32_t LIZTROOP_TALK2 = LIZTROOP_TALK2__STATIC;
int32_t LIZTROOP_TALK3 = LIZTROOP_TALK3__STATIC;
int32_t DUKETALKTOBOSS = DUKETALKTOBOSS__STATIC;
int32_t LIZCAPT_GROWL = LIZCAPT_GROWL__STATIC;
int32_t LIZCAPT_TALK1 = LIZCAPT_TALK1__STATIC;
int32_t LIZCAPT_TALK2 = LIZCAPT_TALK2__STATIC;
int32_t LIZCAPT_TALK3 = LIZCAPT_TALK3__STATIC;
int32_t LIZARD_BEG = LIZARD_BEG__STATIC;
int32_t LIZARD_PAIN = LIZARD_PAIN__STATIC;
int32_t LIZARD_DEATH = LIZARD_DEATH__STATIC;
int32_t LIZARD_SPIT = LIZARD_SPIT__STATIC;
int32_t DRONE1_HISSRATTLE = DRONE1_HISSRATTLE__STATIC;
int32_t DRONE1_HISSSCREECH = DRONE1_HISSSCREECH__STATIC;
int32_t DUKE_TIP2 = DUKE_TIP2__STATIC;
int32_t FLESH_BURNING = FLESH_BURNING__STATIC;
int32_t SQUISHED = SQUISHED__STATIC;
int32_t TELEPORTER = TELEPORTER__STATIC;
int32_t ELEVATOR_ON = ELEVATOR_ON__STATIC;
int32_t DUKE_KILLED3 = DUKE_KILLED3__STATIC;
int32_t ELEVATOR_OFF = ELEVATOR_OFF__STATIC;
int32_t DOOR_OPERATE1 = DOOR_OPERATE1__STATIC;
int32_t SUBWAY = SUBWAY__STATIC;
int32_t SWITCH_ON = SWITCH_ON__STATIC;
int32_t FAN = FAN__STATIC;
int32_t DUKE_GETWEAPON3 = DUKE_GETWEAPON3__STATIC;
int32_t FLUSH_TOILET = FLUSH_TOILET__STATIC;
int32_t HOVER_CRAFT = HOVER_CRAFT__STATIC;
int32_t EARTHQUAKE = EARTHQUAKE__STATIC;
int32_t INTRUDER_ALERT = INTRUDER_ALERT__STATIC;
int32_t END_OF_LEVEL_WARN = END_OF_LEVEL_WARN__STATIC;
int32_t ENGINE_OPERATING = ENGINE_OPERATING__STATIC;
int32_t REACTOR_ON = REACTOR_ON__STATIC;
int32_t COMPUTER_AMBIENCE = COMPUTER_AMBIENCE__STATIC;
int32_t GEARS_GRINDING = GEARS_GRINDING__STATIC;
int32_t BUBBLE_AMBIENCE = BUBBLE_AMBIENCE__STATIC;
int32_t MACHINE_AMBIENCE = MACHINE_AMBIENCE__STATIC;
int32_t SEWER_AMBIENCE = SEWER_AMBIENCE__STATIC;
int32_t WIND_AMBIENCE = WIND_AMBIENCE__STATIC;
int32_t SOMETHING_DRIPPING = SOMETHING_DRIPPING__STATIC;
int32_t STEAM_HISSING = STEAM_HISSING__STATIC;
int32_t THEATER_BREATH = THEATER_BREATH__STATIC;
int32_t BAR_MUSIC = BAR_MUSIC__STATIC;
int32_t BOS1_ROAM = BOS1_ROAM__STATIC;
int32_t BOS1_RECOG = BOS1_RECOG__STATIC;
int32_t BOS1_ATTACK1 = BOS1_ATTACK1__STATIC;
int32_t BOS1_PAIN = BOS1_PAIN__STATIC;
int32_t BOS1_DYING = BOS1_DYING__STATIC;
int32_t BOS2_ROAM = BOS2_ROAM__STATIC;
int32_t BOS2_RECOG = BOS2_RECOG__STATIC;
int32_t BOS2_ATTACK = BOS2_ATTACK__STATIC;
int32_t BOS2_PAIN = BOS2_PAIN__STATIC;
int32_t BOS2_DYING = BOS2_DYING__STATIC;
int32_t GETATOMICHEALTH = GETATOMICHEALTH__STATIC;
int32_t DUKE_GETWEAPON2 = DUKE_GETWEAPON2__STATIC;
int32_t BOS3_DYING = BOS3_DYING__STATIC;
int32_t SHOTGUN_FIRE = SHOTGUN_FIRE__STATIC;
int32_t PRED_ROAM = PRED_ROAM__STATIC;
int32_t PRED_RECOG = PRED_RECOG__STATIC;
int32_t PRED_ATTACK = PRED_ATTACK__STATIC;
int32_t PRED_PAIN = PRED_PAIN__STATIC;
int32_t PRED_DYING = PRED_DYING__STATIC;
int32_t CAPT_ROAM = CAPT_ROAM__STATIC;
int32_t CAPT_ATTACK = CAPT_ATTACK__STATIC;
int32_t CAPT_RECOG = CAPT_RECOG__STATIC;
int32_t CAPT_PAIN = CAPT_PAIN__STATIC;
int32_t CAPT_DYING = CAPT_DYING__STATIC;
int32_t PIG_ROAM = PIG_ROAM__STATIC;
int32_t PIG_RECOG = PIG_RECOG__STATIC;
int32_t PIG_ATTACK = PIG_ATTACK__STATIC;
int32_t PIG_PAIN = PIG_PAIN__STATIC;
int32_t PIG_DYING = PIG_DYING__STATIC;
int32_t RECO_ROAM = RECO_ROAM__STATIC;
int32_t RECO_RECOG = RECO_RECOG__STATIC;
int32_t RECO_ATTACK = RECO_ATTACK__STATIC;
int32_t RECO_PAIN = RECO_PAIN__STATIC;
int32_t RECO_DYING = RECO_DYING__STATIC;
int32_t DRON_ROAM = DRON_ROAM__STATIC;
int32_t DRON_RECOG = DRON_RECOG__STATIC;
int32_t DRON_ATTACK1 = DRON_ATTACK1__STATIC;
int32_t DRON_PAIN = DRON_PAIN__STATIC;
int32_t DRON_DYING = DRON_DYING__STATIC;
int32_t COMM_ROAM = COMM_ROAM__STATIC;
int32_t COMM_RECOG = COMM_RECOG__STATIC;
int32_t COMM_ATTACK = COMM_ATTACK__STATIC;
int32_t COMM_PAIN = COMM_PAIN__STATIC;
int32_t COMM_DYING = COMM_DYING__STATIC;
int32_t OCTA_ROAM = OCTA_ROAM__STATIC;
int32_t OCTA_RECOG = OCTA_RECOG__STATIC;
int32_t OCTA_ATTACK1 = OCTA_ATTACK1__STATIC;
int32_t OCTA_PAIN = OCTA_PAIN__STATIC;
int32_t OCTA_DYING = OCTA_DYING__STATIC;
int32_t TURR_ROAM = TURR_ROAM__STATIC;
int32_t TURR_RECOG = TURR_RECOG__STATIC;
int32_t TURR_ATTACK = TURR_ATTACK__STATIC;
int32_t DUMPSTER_MOVE = DUMPSTER_MOVE__STATIC;
int32_t SLIM_DYING = SLIM_DYING__STATIC;
int32_t BOS3_ROAM = BOS3_ROAM__STATIC;
int32_t BOS3_RECOG = BOS3_RECOG__STATIC;
int32_t BOS3_ATTACK1 = BOS3_ATTACK1__STATIC;
int32_t BOS3_PAIN = BOS3_PAIN__STATIC;
int32_t BOS1_ATTACK2 = BOS1_ATTACK2__STATIC;
int32_t COMM_SPIN = COMM_SPIN__STATIC;
int32_t BOS1_WALK = BOS1_WALK__STATIC;
int32_t DRON_ATTACK2 = DRON_ATTACK2__STATIC;
int32_t THUD = THUD__STATIC;
int32_t OCTA_ATTACK2 = OCTA_ATTACK2__STATIC;
int32_t WIERDSHOT_FLY = WIERDSHOT_FLY__STATIC;
int32_t TURR_PAIN = TURR_PAIN__STATIC;
int32_t TURR_DYING = TURR_DYING__STATIC;
int32_t SLIM_ROAM = SLIM_ROAM__STATIC;
int32_t LADY_SCREAM = LADY_SCREAM__STATIC;
int32_t DOOR_OPERATE2 = DOOR_OPERATE2__STATIC;
int32_t DOOR_OPERATE3 = DOOR_OPERATE3__STATIC;
int32_t DOOR_OPERATE4 = DOOR_OPERATE4__STATIC;
int32_t BORNTOBEWILDSND = BORNTOBEWILDSND__STATIC;
int32_t SHOTGUN_COCK = SHOTGUN_COCK__STATIC;
int32_t GENERIC_AMBIENCE1 = GENERIC_AMBIENCE1__STATIC;
int32_t GENERIC_AMBIENCE2 = GENERIC_AMBIENCE2__STATIC;
int32_t GENERIC_AMBIENCE3 = GENERIC_AMBIENCE3__STATIC;
int32_t GENERIC_AMBIENCE4 = GENERIC_AMBIENCE4__STATIC;
int32_t GENERIC_AMBIENCE5 = GENERIC_AMBIENCE5__STATIC;
int32_t GENERIC_AMBIENCE6 = GENERIC_AMBIENCE6__STATIC;
int32_t BOS3_ATTACK2 = BOS3_ATTACK2__STATIC;
int32_t GENERIC_AMBIENCE17 = GENERIC_AMBIENCE17__STATIC;
int32_t GENERIC_AMBIENCE18 = GENERIC_AMBIENCE18__STATIC;
int32_t GENERIC_AMBIENCE19 = GENERIC_AMBIENCE19__STATIC;
int32_t GENERIC_AMBIENCE20 = GENERIC_AMBIENCE20__STATIC;
int32_t GENERIC_AMBIENCE21 = GENERIC_AMBIENCE21__STATIC;
int32_t GENERIC_AMBIENCE22 = GENERIC_AMBIENCE22__STATIC;
int32_t SECRETLEVELSND = SECRETLEVELSND__STATIC;
int32_t GENERIC_AMBIENCE8 = GENERIC_AMBIENCE8__STATIC;
int32_t GENERIC_AMBIENCE9 = GENERIC_AMBIENCE9__STATIC;
int32_t GENERIC_AMBIENCE10 = GENERIC_AMBIENCE10__STATIC;
int32_t GENERIC_AMBIENCE11 = GENERIC_AMBIENCE11__STATIC;
int32_t GENERIC_AMBIENCE12 = GENERIC_AMBIENCE12__STATIC;
int32_t GENERIC_AMBIENCE13 = GENERIC_AMBIENCE13__STATIC;
int32_t GENERIC_AMBIENCE14 = GENERIC_AMBIENCE14__STATIC;
int32_t GENERIC_AMBIENCE15 = GENERIC_AMBIENCE15__STATIC;
int32_t GENERIC_AMBIENCE16 = GENERIC_AMBIENCE16__STATIC;
int32_t FIRE_CRACKLE = FIRE_CRACKLE__STATIC;
int32_t BONUS_SPEECH1 = BONUS_SPEECH1__STATIC;
int32_t BONUS_SPEECH2 = BONUS_SPEECH2__STATIC;
int32_t BONUS_SPEECH3 = BONUS_SPEECH3__STATIC;
int32_t PIG_CAPTURE_DUKE = PIG_CAPTURE_DUKE__STATIC;
int32_t BONUS_SPEECH4 = BONUS_SPEECH4__STATIC;
int32_t DUKE_LAND_HURT = DUKE_LAND_HURT__STATIC;
int32_t DUKE_HIT_STRIPPER1 = DUKE_HIT_STRIPPER1__STATIC;
int32_t DUKE_TIP1 = DUKE_TIP1__STATIC;
int32_t DUKE_KILLED2 = DUKE_KILLED2__STATIC;
int32_t PRED_ROAM2 = PRED_ROAM2__STATIC;
int32_t PIG_ROAM2 = PIG_ROAM2__STATIC;
int32_t DUKE_GETWEAPON1 = DUKE_GETWEAPON1__STATIC;
int32_t DUKE_SEARCH2 = DUKE_SEARCH2__STATIC;
int32_t DUKE_CRACK2 = DUKE_CRACK2__STATIC;
int32_t DUKE_SEARCH = DUKE_SEARCH__STATIC;
int32_t DUKE_GET = DUKE_GET__STATIC;
int32_t DUKE_LONGTERM_PAIN = DUKE_LONGTERM_PAIN__STATIC;
int32_t MONITOR_ACTIVE = MONITOR_ACTIVE__STATIC;
int32_t NITEVISION_ONOFF = NITEVISION_ONOFF__STATIC;
int32_t DUKE_HIT_STRIPPER2 = DUKE_HIT_STRIPPER2__STATIC;
int32_t DUKE_CRACK_FIRST = DUKE_CRACK_FIRST__STATIC;
int32_t DUKE_USEMEDKIT = DUKE_USEMEDKIT__STATIC;
int32_t DUKE_TAKEPILLS = DUKE_TAKEPILLS__STATIC;
int32_t DUKE_PISSRELIEF = DUKE_PISSRELIEF__STATIC;
int32_t SELECT_WEAPON = SELECT_WEAPON__STATIC;
int32_t WATER_GURGLE = WATER_GURGLE__STATIC;
int32_t DUKE_GETWEAPON4 = DUKE_GETWEAPON4__STATIC;
int32_t JIBBED_ACTOR1 = JIBBED_ACTOR1__STATIC;
int32_t JIBBED_ACTOR2 = JIBBED_ACTOR2__STATIC;
int32_t JIBBED_ACTOR3 = JIBBED_ACTOR3__STATIC;
int32_t JIBBED_ACTOR4 = JIBBED_ACTOR4__STATIC;
int32_t JIBBED_ACTOR5 = JIBBED_ACTOR5__STATIC;
int32_t JIBBED_ACTOR6 = JIBBED_ACTOR6__STATIC;
int32_t JIBBED_ACTOR7 = JIBBED_ACTOR7__STATIC;
int32_t DUKE_GOTHEALTHATLOW = DUKE_GOTHEALTHATLOW__STATIC;
int32_t BOSSTALKTODUKE = BOSSTALKTODUKE__STATIC;
int32_t WAR_AMBIENCE1 = WAR_AMBIENCE1__STATIC;
int32_t WAR_AMBIENCE2 = WAR_AMBIENCE2__STATIC;
int32_t WAR_AMBIENCE3 = WAR_AMBIENCE3__STATIC;
int32_t WAR_AMBIENCE4 = WAR_AMBIENCE4__STATIC;
int32_t WAR_AMBIENCE5 = WAR_AMBIENCE5__STATIC;
int32_t WAR_AMBIENCE6 = WAR_AMBIENCE6__STATIC;
int32_t WAR_AMBIENCE7 = WAR_AMBIENCE7__STATIC;
int32_t WAR_AMBIENCE8 = WAR_AMBIENCE8__STATIC;
int32_t WAR_AMBIENCE9 = WAR_AMBIENCE9__STATIC;
int32_t WAR_AMBIENCE10 = WAR_AMBIENCE10__STATIC;
int32_t ALIEN_TALK1 = ALIEN_TALK1__STATIC;
int32_t ALIEN_TALK2 = ALIEN_TALK2__STATIC;
int32_t EXITMENUSOUND = EXITMENUSOUND__STATIC;
int32_t FLY_BY = FLY_BY__STATIC;
int32_t DUKE_SCREAM = DUKE_SCREAM__STATIC;
int32_t SHRINKER_HIT = SHRINKER_HIT__STATIC;
int32_t RATTY = RATTY__STATIC;
int32_t INTO_MENU = INTO_MENU__STATIC;
int32_t BONUSMUSIC = BONUSMUSIC__STATIC;
int32_t DUKE_BOOBY = DUKE_BOOBY__STATIC;
int32_t DUKE_TALKTOBOSSFALL = DUKE_TALKTOBOSSFALL__STATIC;
int32_t DUKE_LOOKINTOMIRROR = DUKE_LOOKINTOMIRROR__STATIC;
int32_t PIG_ROAM3 = PIG_ROAM3__STATIC;
int32_t KILLME = KILLME__STATIC;
int32_t DRON_JETSND = DRON_JETSND__STATIC;
int32_t SPACE_DOOR1 = SPACE_DOOR1__STATIC;
int32_t SPACE_DOOR2 = SPACE_DOOR2__STATIC;
int32_t SPACE_DOOR3 = SPACE_DOOR3__STATIC;
int32_t SPACE_DOOR4 = SPACE_DOOR4__STATIC;
int32_t SPACE_DOOR5 = SPACE_DOOR5__STATIC;
int32_t ALIEN_ELEVATOR1 = ALIEN_ELEVATOR1__STATIC;
int32_t VAULT_DOOR = VAULT_DOOR__STATIC;
int32_t JIBBED_ACTOR13 = JIBBED_ACTOR13__STATIC;
int32_t DUKE_GETWEAPON6 = DUKE_GETWEAPON6__STATIC;
int32_t JIBBED_ACTOR8 = JIBBED_ACTOR8__STATIC;
int32_t JIBBED_ACTOR9 = JIBBED_ACTOR9__STATIC;
int32_t JIBBED_ACTOR10 = JIBBED_ACTOR10__STATIC;
int32_t JIBBED_ACTOR11 = JIBBED_ACTOR11__STATIC;
int32_t JIBBED_ACTOR12 = JIBBED_ACTOR12__STATIC;
int32_t DUKE_KILLED4 = DUKE_KILLED4__STATIC;
int32_t DUKE_KILLED5 = DUKE_KILLED5__STATIC;
int32_t ALIEN_SWITCH1 = ALIEN_SWITCH1__STATIC;
int32_t DUKE_STEPONFECES = DUKE_STEPONFECES__STATIC;
int32_t DUKE_LONGTERM_PAIN2 = DUKE_LONGTERM_PAIN2__STATIC;
int32_t DUKE_LONGTERM_PAIN3 = DUKE_LONGTERM_PAIN3__STATIC;
int32_t DUKE_LONGTERM_PAIN4 = DUKE_LONGTERM_PAIN4__STATIC;
int32_t COMPANB2 = COMPANB2__STATIC;
int32_t KTIT = KTIT__STATIC;
int32_t HELICOP_IDLE = HELICOP_IDLE__STATIC;
int32_t STEPNIT = STEPNIT__STATIC;
int32_t SPACE_AMBIENCE1 = SPACE_AMBIENCE1__STATIC;
int32_t SPACE_AMBIENCE2 = SPACE_AMBIENCE2__STATIC;
int32_t SLIM_HATCH = SLIM_HATCH__STATIC;
int32_t RIPHEADNECK = RIPHEADNECK__STATIC;
int32_t FOUNDJONES = FOUNDJONES__STATIC;
int32_t ALIEN_DOOR1 = ALIEN_DOOR1__STATIC;
int32_t ALIEN_DOOR2 = ALIEN_DOOR2__STATIC;
int32_t ENDSEQVOL3SND4 = ENDSEQVOL3SND4__STATIC;
int32_t ENDSEQVOL3SND5 = ENDSEQVOL3SND5__STATIC;
int32_t ENDSEQVOL3SND6 = ENDSEQVOL3SND6__STATIC;
int32_t ENDSEQVOL3SND7 = ENDSEQVOL3SND7__STATIC;
int32_t ENDSEQVOL3SND8 = ENDSEQVOL3SND8__STATIC;
int32_t ENDSEQVOL3SND9 = ENDSEQVOL3SND9__STATIC;
int32_t WHIPYOURASS = WHIPYOURASS__STATIC;
int32_t ENDSEQVOL2SND1 = ENDSEQVOL2SND1__STATIC;
int32_t ENDSEQVOL2SND2 = ENDSEQVOL2SND2__STATIC;
int32_t ENDSEQVOL2SND3 = ENDSEQVOL2SND3__STATIC;
int32_t ENDSEQVOL2SND4 = ENDSEQVOL2SND4__STATIC;
int32_t ENDSEQVOL2SND5 = ENDSEQVOL2SND5__STATIC;
int32_t ENDSEQVOL2SND6 = ENDSEQVOL2SND6__STATIC;
int32_t ENDSEQVOL2SND7 = ENDSEQVOL2SND7__STATIC;
int32_t GENERIC_AMBIENCE23 = GENERIC_AMBIENCE23__STATIC;
int32_t SOMETHINGFROZE = SOMETHINGFROZE__STATIC;
int32_t DUKE_LONGTERM_PAIN5 = DUKE_LONGTERM_PAIN5__STATIC;
int32_t DUKE_LONGTERM_PAIN6 = DUKE_LONGTERM_PAIN6__STATIC;
int32_t DUKE_LONGTERM_PAIN7 = DUKE_LONGTERM_PAIN7__STATIC;
int32_t DUKE_LONGTERM_PAIN8 = DUKE_LONGTERM_PAIN8__STATIC;
int32_t WIND_REPEAT = WIND_REPEAT__STATIC;
int32_t MYENEMY_ROAM = MYENEMY_ROAM__STATIC;
int32_t MYENEMY_HURT = MYENEMY_HURT__STATIC;
int32_t MYENEMY_DEAD = MYENEMY_DEAD__STATIC;
int32_t MYENEMY_SHOOT = MYENEMY_SHOOT__STATIC;
int32_t STORE_MUSIC = STORE_MUSIC__STATIC;
int32_t STORE_MUSIC_BROKE = STORE_MUSIC_BROKE__STATIC;
int32_t ACTOR_GROWING = ACTOR_GROWING__STATIC;
int32_t NEWBEAST_ROAM = NEWBEAST_ROAM__STATIC;
int32_t NEWBEAST_RECOG = NEWBEAST_RECOG__STATIC;
int32_t NEWBEAST_ATTACK = NEWBEAST_ATTACK__STATIC;
int32_t NEWBEAST_PAIN = NEWBEAST_PAIN__STATIC;
int32_t NEWBEAST_DYING = NEWBEAST_DYING__STATIC;
int32_t NEWBEAST_SPIT = NEWBEAST_SPIT__STATIC;
int32_t VOL4_1 = VOL4_1__STATIC;
int32_t SUPERMARKET = SUPERMARKET__STATIC;
int32_t MOUSEANNOY = MOUSEANNOY__STATIC;
int32_t BOOKEM = BOOKEM__STATIC;
int32_t SUPERMARKETCRY = SUPERMARKETCRY__STATIC;
int32_t DESTRUCT = DESTRUCT__STATIC;
int32_t EATFOOD = EATFOOD__STATIC;
int32_t MAKEMYDAY = MAKEMYDAY__STATIC;
int32_t WITNESSSTAND = WITNESSSTAND__STATIC;
int32_t VACATIONSPEECH = VACATIONSPEECH__STATIC;
int32_t YIPPEE1 = YIPPEE1__STATIC;
int32_t YOHOO1 = YOHOO1__STATIC;
int32_t YOHOO2 = YOHOO2__STATIC;
int32_t DOLPHINSND = DOLPHINSND__STATIC;
int32_t TOUGHGALSND1 = TOUGHGALSND1__STATIC;
int32_t TOUGHGALSND2 = TOUGHGALSND2__STATIC;
int32_t TOUGHGALSND3 = TOUGHGALSND3__STATIC;
int32_t TOUGHGALSND4 = TOUGHGALSND4__STATIC;
int32_t TANK_ROAM = TANK_ROAM__STATIC;
int32_t BOS4_ROAM = BOS4_ROAM__STATIC;
int32_t BOS4_RECOG = BOS4_RECOG__STATIC;
int32_t BOS4_ATTACK = BOS4_ATTACK__STATIC;
int32_t BOS4_PAIN = BOS4_PAIN__STATIC;
int32_t BOS4_DYING = BOS4_DYING__STATIC;
int32_t NEWBEAST_ATTACKMISS = NEWBEAST_ATTACKMISS__STATIC;
int32_t VOL4_2 = VOL4_2__STATIC;
int32_t COOKINGDEEPFRIER = COOKINGDEEPFRIER__STATIC;
int32_t WHINING_DOG = WHINING_DOG__STATIC;
int32_t DEAD_DOG = DEAD_DOG__STATIC;
int32_t LIGHTNING_SLAP = LIGHTNING_SLAP__STATIC;
int32_t THUNDER = THUNDER__STATIC;
int32_t HAPPYMOUSESND1 = HAPPYMOUSESND1__STATIC;
int32_t HAPPYMOUSESND2 = HAPPYMOUSESND2__STATIC;
int32_t HAPPYMOUSESND3 = HAPPYMOUSESND3__STATIC;
int32_t HAPPYMOUSESND4 = HAPPYMOUSESND4__STATIC;
int32_t ALARM = ALARM__STATIC;
int32_t RAIN = RAIN__STATIC;
int32_t DTAG_GREENRUN = DTAG_GREENRUN__STATIC;
int32_t DTAG_BROWNRUN = DTAG_BROWNRUN__STATIC;
int32_t DTAG_GREENSCORE = DTAG_GREENSCORE__STATIC;
int32_t DTAG_BROWNSCORE = DTAG_BROWNSCORE__STATIC;
int32_t INTRO4_1 = INTRO4_1__STATIC;
int32_t INTRO4_2 = INTRO4_2__STATIC;
int32_t INTRO4_3 = INTRO4_3__STATIC;
int32_t INTRO4_4 = INTRO4_4__STATIC;
int32_t INTRO4_5 = INTRO4_5__STATIC;
int32_t INTRO4_6 = INTRO4_6__STATIC;
int32_t SCREECH = SCREECH__STATIC;
int32_t BOSS4_DEADSPEECH = BOSS4_DEADSPEECH__STATIC;
int32_t BOSS4_FIRSTSEE = BOSS4_FIRSTSEE__STATIC;
int32_t PARTY_SPEECH = PARTY_SPEECH__STATIC;
int32_t POSTAL_SPEECH = POSTAL_SPEECH__STATIC;
int32_t TGSPEECH = TGSPEECH__STATIC;
int32_t DOGROOMSPEECH = DOGROOMSPEECH__STATIC;
int32_t SMACKED = SMACKED__STATIC;
int32_t MDEVSPEECH = MDEVSPEECH__STATIC;
int32_t AREA51SPEECH = AREA51SPEECH__STATIC;
int32_t JEEPSOUND = JEEPSOUND__STATIC;
int32_t BIGDOORSLAM = BIGDOORSLAM__STATIC;
int32_t BOS4_LAY = BOS4_LAY__STATIC;
int32_t WAVESOUND = WAVESOUND__STATIC;
int32_t ILLBEBACK = ILLBEBACK__STATIC;
int32_t VOL4ENDSND1 = VOL4ENDSND1__STATIC;
int32_t VOL4ENDSND2 = VOL4ENDSND2__STATIC;
int32_t EXPANDERHIT = EXPANDERHIT__STATIC;
int32_t SNAKESPEECH = SNAKESPEECH__STATIC;
int32_t EXPANDERSHOOT = EXPANDERSHOOT__STATIC;
int32_t GETBACKTOWORK = GETBACKTOWORK__STATIC;
int32_t JIBBED_ACTOR14 = JIBBED_ACTOR14__STATIC;
int32_t JIBBED_ACTOR15 = JIBBED_ACTOR15__STATIC;
int32_t INTRO4_B = INTRO4_B__STATIC;
int32_t BIGBANG = BIGBANG__STATIC;
int32_t HORNSND = HORNSND__STATIC;
int32_t BELLSND = BELLSND__STATIC;
int32_t GOAWAY = GOAWAY__STATIC;
int32_t JOKE = JOKE__STATIC;

#if !defined LUNATIC
static hashtable_t h_names = {512, NULL};

void G_ProcessDynamicSoundMapping(const char *szLabel, int32_t lValue)
{
    int32_t i;

    if ((unsigned)lValue >= MAXSOUNDS || !szLabel)
        return;

    i = hash_find(&h_names,szLabel);
    if (i>=0)
    {
        struct dynitem *di = &g_dynSoundList[i];
#ifdef DEBUGGINGAIDS
        if (di->staticval != lValue)
            OSD_Printf("REMAP %s (%d) --> %d\n", di->str, di->staticval, lValue);
#endif
        *di->dynvalptr = lValue;
    }
}

void initsoundhashnames(void)
{
    int32_t i;

    hash_init(&h_names);

    for (i=0; g_dynSoundList[i].staticval >= 0; i++)
        hash_add(&h_names, g_dynSoundList[i].str, i, 0);
}

void freesoundhashnames(void)
{
    hash_free(&h_names);
}
#endif
#endif

// This is run after all CON define's have been processed to set up the
// dynamic->static sound mapping.
void G_InitDynamicSounds(void)
{
    int32_t i;

    Bmemset(DynamicSoundMap, 0, sizeof(DynamicSoundMap));

    for (i=0; g_dynSoundList[i].staticval >= 0; i++)
#ifdef DYNSOUNDREMAP_ENABLE
        DynamicSoundMap[*(g_dynSoundList[i].dynvalptr)] = g_dynSoundList[i].staticval;
#else
        DynamicSoundMap[g_dynSoundList[i].staticval] = g_dynSoundList[i].staticval;
#endif

}
