#!/bin/sh

if [ -z "$1" ]; then
    # S or G can be used to display SETGLOBALs or GETGLOBALs, respectively
    echo "Usage: $0 [S|G] <files.lua...>"
    exit 1;
fi

GS=

if [ "$1" = G ]; then
    GS=G
    shift
elif [ "$1" = S ]; then
    GS=S
    shift
fi

# Lua 5.2 required to parse ::label:: / goto generated by LunaCON.
LUAC=luac

for f in "$@"; do
    echo "[$f]"
    # Strip LuaJIT specific syntax first. Run luac and extract interesting lines.
    sed -r -e "s/[0-9]+U?LL/0/g" "$f" | $LUAC -p -l - | grep "${GS}ETTABUP.*; _ENV " |
        # Reformat them.
        sed -e 's/.*\[\(.*\)\].*\([SG]ET\)TABUP.*"\(.*\)".*/\1: \2 \3/' |
        # Mark where the new module environment starts.
        sed -e 's/GET module/& ____________________/'
    echo
done
