//-------------------------------------------------------------------------
/*
Copyright (C) 2010 EDuke32 developers and contributors

This file is part of EDuke32.

EDuke32 is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License version 2
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
//-------------------------------------------------------------------------

// Maybe this should be called "hacks.c" instead of "namesdyn.c"...

#include "compat.h"
#include "build.h"

#include "namesdyn.h"
#include "global.h"

int16_t DynamicTileMap[MAXTILES];

#ifdef DYNTILEREMAP_ENABLE
struct dynitem
{
    char *str;
    int32_t *dynvalptr;
    const int16_t staticval;
};

static hashtable_t h_names = {512, NULL};

static struct dynitem list[]=
{
    { "SECTOREFFECTOR", &SECTOREFFECTOR, SECTOREFFECTOR__STATIC },
    { "ACTIVATOR", &ACTIVATOR, ACTIVATOR__STATIC },
    { "TOUCHPLATE", &TOUCHPLATE, TOUCHPLATE__STATIC },
    { "ACTIVATORLOCKED", &ACTIVATORLOCKED, ACTIVATORLOCKED__STATIC },
    { "MUSICANDSFX", &MUSICANDSFX, MUSICANDSFX__STATIC },
    { "LOCATORS", &LOCATORS, LOCATORS__STATIC },
    { "CYCLER", &CYCLER, CYCLER__STATIC },
    { "MASTERSWITCH", &MASTERSWITCH, MASTERSWITCH__STATIC },
    { "RESPAWN", &RESPAWN, RESPAWN__STATIC },
    { "GPSPEED", &GPSPEED, GPSPEED__STATIC },
    { "FOF", &FOF, FOF__STATIC },
    { "ARROW", &ARROW, ARROW__STATIC },
    { "FIRSTGUNSPRITE", &FIRSTGUNSPRITE, FIRSTGUNSPRITE__STATIC },
    { "CHAINGUNSPRITE", &CHAINGUNSPRITE, CHAINGUNSPRITE__STATIC },
    { "RPGSPRITE", &RPGSPRITE, RPGSPRITE__STATIC },
    { "FREEZESPRITE", &FREEZESPRITE, FREEZESPRITE__STATIC },
    { "SHRINKERSPRITE", &SHRINKERSPRITE, SHRINKERSPRITE__STATIC },
    { "HEAVYHBOMB", &HEAVYHBOMB, HEAVYHBOMB__STATIC },
    { "TRIPBOMBSPRITE", &TRIPBOMBSPRITE, TRIPBOMBSPRITE__STATIC },
    { "SHOTGUNSPRITE", &SHOTGUNSPRITE, SHOTGUNSPRITE__STATIC },
    { "DEVISTATORSPRITE", &DEVISTATORSPRITE, DEVISTATORSPRITE__STATIC },
    { "HEALTHBOX", &HEALTHBOX, HEALTHBOX__STATIC },
    { "AMMOBOX", &AMMOBOX, AMMOBOX__STATIC },
    { "GROWSPRITEICON", &GROWSPRITEICON, GROWSPRITEICON__STATIC },
    { "INVENTORYBOX", &INVENTORYBOX, INVENTORYBOX__STATIC },
    { "FREEZEAMMO", &FREEZEAMMO, FREEZEAMMO__STATIC },
    { "AMMO", &AMMO, AMMO__STATIC },
    { "BATTERYAMMO", &BATTERYAMMO, BATTERYAMMO__STATIC },
    { "DEVISTATORAMMO", &DEVISTATORAMMO, DEVISTATORAMMO__STATIC },
    { "RPGAMMO", &RPGAMMO, RPGAMMO__STATIC },
    { "GROWAMMO", &GROWAMMO, GROWAMMO__STATIC },
    { "CRYSTALAMMO", &CRYSTALAMMO, CRYSTALAMMO__STATIC },
    { "HBOMBAMMO", &HBOMBAMMO, HBOMBAMMO__STATIC },
    { "AMMOLOTS", &AMMOLOTS, AMMOLOTS__STATIC },
    { "SHOTGUNAMMO", &SHOTGUNAMMO, SHOTGUNAMMO__STATIC },
    { "COLA", &COLA, COLA__STATIC },
    { "SIXPAK", &SIXPAK, SIXPAK__STATIC },
    { "FIRSTAID", &FIRSTAID, FIRSTAID__STATIC },
    { "SHIELD", &SHIELD, SHIELD__STATIC },
    { "STEROIDS", &STEROIDS, STEROIDS__STATIC },
    { "AIRTANK", &AIRTANK, AIRTANK__STATIC },
    { "JETPACK", &JETPACK, JETPACK__STATIC },
    { "HEATSENSOR", &HEATSENSOR, HEATSENSOR__STATIC },
    { "ACCESSCARD", &ACCESSCARD, ACCESSCARD__STATIC },
    { "BOOTS", &BOOTS, BOOTS__STATIC },
    { "MIRRORBROKE", &MIRRORBROKE, MIRRORBROKE__STATIC },
    { "CLOUDYOCEAN", &CLOUDYOCEAN, CLOUDYOCEAN__STATIC },
    { "CLOUDYSKIES", &CLOUDYSKIES, CLOUDYSKIES__STATIC },
    { "MOONSKY1", &MOONSKY1, MOONSKY1__STATIC },
    { "MOONSKY2", &MOONSKY2, MOONSKY2__STATIC },
    { "MOONSKY3", &MOONSKY3, MOONSKY3__STATIC },
    { "MOONSKY4", &MOONSKY4, MOONSKY4__STATIC },
    { "BIGORBIT1", &BIGORBIT1, BIGORBIT1__STATIC },
    { "BIGORBIT2", &BIGORBIT2, BIGORBIT2__STATIC },
    { "BIGORBIT3", &BIGORBIT3, BIGORBIT3__STATIC },
    { "BIGORBIT4", &BIGORBIT4, BIGORBIT4__STATIC },
    { "BIGORBIT5", &BIGORBIT5, BIGORBIT5__STATIC },
    { "LA", &LA, LA__STATIC },
    { "REDSKY1", &REDSKY1, REDSKY1__STATIC },
    { "REDSKY2", &REDSKY2, REDSKY2__STATIC },
    { "ATOMICHEALTH", &ATOMICHEALTH, ATOMICHEALTH__STATIC },
    { "TECHLIGHT2", &TECHLIGHT2, TECHLIGHT2__STATIC },
    { "TECHLIGHTBUST2", &TECHLIGHTBUST2, TECHLIGHTBUST2__STATIC },
    { "TECHLIGHT4", &TECHLIGHT4, TECHLIGHT4__STATIC },
    { "TECHLIGHTBUST4", &TECHLIGHTBUST4, TECHLIGHTBUST4__STATIC },
    { "WALLLIGHT4", &WALLLIGHT4, WALLLIGHT4__STATIC },
    { "WALLLIGHTBUST4", &WALLLIGHTBUST4, WALLLIGHTBUST4__STATIC },
    { "ACCESSSWITCH", &ACCESSSWITCH, ACCESSSWITCH__STATIC },
    { "SLOTDOOR", &SLOTDOOR, SLOTDOOR__STATIC },
    { "LIGHTSWITCH", &LIGHTSWITCH, LIGHTSWITCH__STATIC },
    { "SPACEDOORSWITCH", &SPACEDOORSWITCH, SPACEDOORSWITCH__STATIC },
    { "SPACELIGHTSWITCH", &SPACELIGHTSWITCH, SPACELIGHTSWITCH__STATIC },
    { "FRANKENSTINESWITCH", &FRANKENSTINESWITCH, FRANKENSTINESWITCH__STATIC },
    { "NUKEBUTTON", &NUKEBUTTON, NUKEBUTTON__STATIC },
    { "MULTISWITCH", &MULTISWITCH, MULTISWITCH__STATIC },
    { "DOORTILE5", &DOORTILE5, DOORTILE5__STATIC },
    { "DOORTILE6", &DOORTILE6, DOORTILE6__STATIC },
    { "DOORTILE1", &DOORTILE1, DOORTILE1__STATIC },
    { "DOORTILE2", &DOORTILE2, DOORTILE2__STATIC },
    { "DOORTILE3", &DOORTILE3, DOORTILE3__STATIC },
    { "DOORTILE4", &DOORTILE4, DOORTILE4__STATIC },
    { "DOORTILE7", &DOORTILE7, DOORTILE7__STATIC },
    { "DOORTILE8", &DOORTILE8, DOORTILE8__STATIC },
    { "DOORTILE9", &DOORTILE9, DOORTILE9__STATIC },
    { "DOORTILE10", &DOORTILE10, DOORTILE10__STATIC },
    { "DOORSHOCK", &DOORSHOCK, DOORSHOCK__STATIC },
    { "DIPSWITCH", &DIPSWITCH, DIPSWITCH__STATIC },
    { "DIPSWITCH2", &DIPSWITCH2, DIPSWITCH2__STATIC },
    { "TECHSWITCH", &TECHSWITCH, TECHSWITCH__STATIC },
    { "DIPSWITCH3", &DIPSWITCH3, DIPSWITCH3__STATIC },
    { "ACCESSSWITCH2", &ACCESSSWITCH2, ACCESSSWITCH2__STATIC },
    { "REFLECTWATERTILE", &REFLECTWATERTILE, REFLECTWATERTILE__STATIC },
    { "FLOORSLIME", &FLOORSLIME, FLOORSLIME__STATIC },
    { "BIGFORCE", &BIGFORCE, BIGFORCE__STATIC },
    { "EPISODE", &EPISODE, EPISODE__STATIC },
    { "MASKWALL9", &MASKWALL9, MASKWALL9__STATIC },
    { "W_LIGHT", &W_LIGHT, W_LIGHT__STATIC },
    { "SCREENBREAK1", &SCREENBREAK1, SCREENBREAK1__STATIC },
    { "SCREENBREAK2", &SCREENBREAK2, SCREENBREAK2__STATIC },
    { "SCREENBREAK3", &SCREENBREAK3, SCREENBREAK3__STATIC },
    { "SCREENBREAK4", &SCREENBREAK4, SCREENBREAK4__STATIC },
    { "SCREENBREAK5", &SCREENBREAK5, SCREENBREAK5__STATIC },
    { "SCREENBREAK6", &SCREENBREAK6, SCREENBREAK6__STATIC },
    { "SCREENBREAK7", &SCREENBREAK7, SCREENBREAK7__STATIC },
    { "SCREENBREAK8", &SCREENBREAK8, SCREENBREAK8__STATIC },
    { "SCREENBREAK9", &SCREENBREAK9, SCREENBREAK9__STATIC },
    { "SCREENBREAK10", &SCREENBREAK10, SCREENBREAK10__STATIC },
    { "SCREENBREAK11", &SCREENBREAK11, SCREENBREAK11__STATIC },
    { "SCREENBREAK12", &SCREENBREAK12, SCREENBREAK12__STATIC },
    { "SCREENBREAK13", &SCREENBREAK13, SCREENBREAK13__STATIC },
    { "MASKWALL1", &MASKWALL1, MASKWALL1__STATIC },
    { "W_TECHWALL1", &W_TECHWALL1, W_TECHWALL1__STATIC },
    { "W_TECHWALL2", &W_TECHWALL2, W_TECHWALL2__STATIC },
    { "W_TECHWALL15", &W_TECHWALL15, W_TECHWALL15__STATIC },
    { "W_TECHWALL3", &W_TECHWALL3, W_TECHWALL3__STATIC },
    { "W_TECHWALL4", &W_TECHWALL4, W_TECHWALL4__STATIC },
    { "W_TECHWALL10", &W_TECHWALL10, W_TECHWALL10__STATIC },
    { "W_TECHWALL16", &W_TECHWALL16, W_TECHWALL16__STATIC },
    { "WATERTILE2", &WATERTILE2, WATERTILE2__STATIC },
    { "BPANNEL1", &BPANNEL1, BPANNEL1__STATIC },
    { "PANNEL1", &PANNEL1, PANNEL1__STATIC },
    { "PANNEL2", &PANNEL2, PANNEL2__STATIC },
    { "WATERTILE", &WATERTILE, WATERTILE__STATIC },
    { "STATIC", &STATIC, STATIC__STATIC },
    { "W_SCREENBREAK", &W_SCREENBREAK, W_SCREENBREAK__STATIC },
    { "W_HITTECHWALL3", &W_HITTECHWALL3, W_HITTECHWALL3__STATIC },
    { "W_HITTECHWALL4", &W_HITTECHWALL4, W_HITTECHWALL4__STATIC },
    { "W_HITTECHWALL2", &W_HITTECHWALL2, W_HITTECHWALL2__STATIC },
    { "W_HITTECHWALL1", &W_HITTECHWALL1, W_HITTECHWALL1__STATIC },
    { "MASKWALL10", &MASKWALL10, MASKWALL10__STATIC },
    { "MASKWALL11", &MASKWALL11, MASKWALL11__STATIC },
    { "DOORTILE22", &DOORTILE22, DOORTILE22__STATIC },
    { "FANSPRITE", &FANSPRITE, FANSPRITE__STATIC },
    { "FANSPRITEBROKE", &FANSPRITEBROKE, FANSPRITEBROKE__STATIC },
    { "FANSHADOW", &FANSHADOW, FANSHADOW__STATIC },
    { "FANSHADOWBROKE", &FANSHADOWBROKE, FANSHADOWBROKE__STATIC },
    { "DOORTILE18", &DOORTILE18, DOORTILE18__STATIC },
    { "DOORTILE19", &DOORTILE19, DOORTILE19__STATIC },
    { "DOORTILE20", &DOORTILE20, DOORTILE20__STATIC },
    { "SATELLITE", &SATELLITE, SATELLITE__STATIC },
    { "VIEWSCREEN2", &VIEWSCREEN2, VIEWSCREEN2__STATIC },
    { "VIEWSCREENBROKE", &VIEWSCREENBROKE, VIEWSCREENBROKE__STATIC },
    { "VIEWSCREEN", &VIEWSCREEN, VIEWSCREEN__STATIC },
    { "GLASS", &GLASS, GLASS__STATIC },
    { "GLASS2", &GLASS2, GLASS2__STATIC },
    { "STAINGLASS1", &STAINGLASS1, STAINGLASS1__STATIC },
    { "MASKWALL5", &MASKWALL5, MASKWALL5__STATIC },
    { "SATELITE", &SATELITE, SATELITE__STATIC },
    { "FUELPOD", &FUELPOD, FUELPOD__STATIC },
    { "SLIMEPIPE", &SLIMEPIPE, SLIMEPIPE__STATIC },
    { "CRACK1", &CRACK1, CRACK1__STATIC },
    { "CRACK2", &CRACK2, CRACK2__STATIC },
    { "CRACK3", &CRACK3, CRACK3__STATIC },
    { "CRACK4", &CRACK4, CRACK4__STATIC },
    { "FOOTPRINTS", &FOOTPRINTS, FOOTPRINTS__STATIC },
    { "DOMELITE", &DOMELITE, DOMELITE__STATIC },
    { "CAMERAPOLE", &CAMERAPOLE, CAMERAPOLE__STATIC },
    { "CHAIR1", &CHAIR1, CHAIR1__STATIC },
    { "CHAIR2", &CHAIR2, CHAIR2__STATIC },
    { "BROKENCHAIR", &BROKENCHAIR, BROKENCHAIR__STATIC },
    { "MIRROR", &MIRROR, MIRROR__STATIC },
    { "WATERFOUNTAIN", &WATERFOUNTAIN, WATERFOUNTAIN__STATIC },
    { "WATERFOUNTAINBROKE", &WATERFOUNTAINBROKE, WATERFOUNTAINBROKE__STATIC },
    { "FEMMAG1", &FEMMAG1, FEMMAG1__STATIC },
    { "TOILET", &TOILET, TOILET__STATIC },
    { "STALL", &STALL, STALL__STATIC },
    { "STALLBROKE", &STALLBROKE, STALLBROKE__STATIC },
    { "FEMMAG2", &FEMMAG2, FEMMAG2__STATIC },
    { "REACTOR2", &REACTOR2, REACTOR2__STATIC },
    { "REACTOR2BURNT", &REACTOR2BURNT, REACTOR2BURNT__STATIC },
    { "REACTOR2SPARK", &REACTOR2SPARK, REACTOR2SPARK__STATIC },
    { "GRATE1", &GRATE1, GRATE1__STATIC },
    { "BGRATE1", &BGRATE1, BGRATE1__STATIC },
    { "SOLARPANNEL", &SOLARPANNEL, SOLARPANNEL__STATIC },
    { "NAKED1", &NAKED1, NAKED1__STATIC },
    { "ANTENNA", &ANTENNA, ANTENNA__STATIC },
    { "MASKWALL12", &MASKWALL12, MASKWALL12__STATIC },
    { "TOILETBROKE", &TOILETBROKE, TOILETBROKE__STATIC },
    { "PIPE2", &PIPE2, PIPE2__STATIC },
    { "PIPE1B", &PIPE1B, PIPE1B__STATIC },
    { "PIPE3", &PIPE3, PIPE3__STATIC },
    { "PIPE1", &PIPE1, PIPE1__STATIC },
    { "CAMERA1", &CAMERA1, CAMERA1__STATIC },
    { "BRICK", &BRICK, BRICK__STATIC },
    { "SPLINTERWOOD", &SPLINTERWOOD, SPLINTERWOOD__STATIC },
    { "PIPE2B", &PIPE2B, PIPE2B__STATIC },
    { "BOLT1", &BOLT1, BOLT1__STATIC },
    { "W_NUMBERS", &W_NUMBERS, W_NUMBERS__STATIC },
    { "WATERDRIP", &WATERDRIP, WATERDRIP__STATIC },
    { "WATERBUBBLE", &WATERBUBBLE, WATERBUBBLE__STATIC },
    { "WATERBUBBLEMAKER", &WATERBUBBLEMAKER, WATERBUBBLEMAKER__STATIC },
    { "W_FORCEFIELD", &W_FORCEFIELD, W_FORCEFIELD__STATIC },
    { "VACUUM", &VACUUM, VACUUM__STATIC },
    { "FOOTPRINTS2", &FOOTPRINTS2, FOOTPRINTS2__STATIC },
    { "FOOTPRINTS3", &FOOTPRINTS3, FOOTPRINTS3__STATIC },
    { "FOOTPRINTS4", &FOOTPRINTS4, FOOTPRINTS4__STATIC },
    { "EGG", &EGG, EGG__STATIC },
    { "SCALE", &SCALE, SCALE__STATIC },
    { "CHAIR3", &CHAIR3, CHAIR3__STATIC },
    { "CAMERALIGHT", &CAMERALIGHT, CAMERALIGHT__STATIC },
    { "MOVIECAMERA", &MOVIECAMERA, MOVIECAMERA__STATIC },
    { "IVUNIT", &IVUNIT, IVUNIT__STATIC },
    { "POT1", &POT1, POT1__STATIC },
    { "POT2", &POT2, POT2__STATIC },
    { "POT3", &POT3, POT3__STATIC },
    { "PIPE3B", &PIPE3B, PIPE3B__STATIC },
    { "WALLLIGHT3", &WALLLIGHT3, WALLLIGHT3__STATIC },
    { "WALLLIGHTBUST3", &WALLLIGHTBUST3, WALLLIGHTBUST3__STATIC },
    { "WALLLIGHT1", &WALLLIGHT1, WALLLIGHT1__STATIC },
    { "WALLLIGHTBUST1", &WALLLIGHTBUST1, WALLLIGHTBUST1__STATIC },
    { "WALLLIGHT2", &WALLLIGHT2, WALLLIGHT2__STATIC },
    { "WALLLIGHTBUST2", &WALLLIGHTBUST2, WALLLIGHTBUST2__STATIC },
    { "LIGHTSWITCH2", &LIGHTSWITCH2, LIGHTSWITCH2__STATIC },
    { "WAITTOBESEATED", &WAITTOBESEATED, WAITTOBESEATED__STATIC },
    { "DOORTILE14", &DOORTILE14, DOORTILE14__STATIC },
    { "STATUE", &STATUE, STATUE__STATIC },
    { "MIKE", &MIKE, MIKE__STATIC },
    { "VASE", &VASE, VASE__STATIC },
    { "SUSHIPLATE1", &SUSHIPLATE1, SUSHIPLATE1__STATIC },
    { "SUSHIPLATE2", &SUSHIPLATE2, SUSHIPLATE2__STATIC },
    { "SUSHIPLATE3", &SUSHIPLATE3, SUSHIPLATE3__STATIC },
    { "SUSHIPLATE4", &SUSHIPLATE4, SUSHIPLATE4__STATIC },
    { "DOORTILE16", &DOORTILE16, DOORTILE16__STATIC },
    { "SUSHIPLATE5", &SUSHIPLATE5, SUSHIPLATE5__STATIC },
    { "OJ", &OJ, OJ__STATIC },
    { "MASKWALL13", &MASKWALL13, MASKWALL13__STATIC },
    { "HURTRAIL", &HURTRAIL, HURTRAIL__STATIC },
    { "POWERSWITCH1", &POWERSWITCH1, POWERSWITCH1__STATIC },
    { "LOCKSWITCH1", &LOCKSWITCH1, LOCKSWITCH1__STATIC },
    { "POWERSWITCH2", &POWERSWITCH2, POWERSWITCH2__STATIC },
    { "ATM", &ATM, ATM__STATIC },
    { "STATUEFLASH", &STATUEFLASH, STATUEFLASH__STATIC },
    { "ATMBROKE", &ATMBROKE, ATMBROKE__STATIC },
    { "BIGHOLE2", &BIGHOLE2, BIGHOLE2__STATIC },
    { "STRIPEBALL", &STRIPEBALL, STRIPEBALL__STATIC },
    { "QUEBALL", &QUEBALL, QUEBALL__STATIC },
    { "POCKET", &POCKET, POCKET__STATIC },
    { "WOODENHORSE", &WOODENHORSE, WOODENHORSE__STATIC },
    { "TREE1", &TREE1, TREE1__STATIC },
    { "TREE2", &TREE2, TREE2__STATIC },
    { "CACTUS", &CACTUS, CACTUS__STATIC },
    { "MASKWALL2", &MASKWALL2, MASKWALL2__STATIC },
    { "MASKWALL3", &MASKWALL3, MASKWALL3__STATIC },
    { "MASKWALL4", &MASKWALL4, MASKWALL4__STATIC },
    { "FIREEXT", &FIREEXT, FIREEXT__STATIC },
    { "TOILETWATER", &TOILETWATER, TOILETWATER__STATIC },
    { "NEON1", &NEON1, NEON1__STATIC },
    { "NEON2", &NEON2, NEON2__STATIC },
    { "CACTUSBROKE", &CACTUSBROKE, CACTUSBROKE__STATIC },
    { "BOUNCEMINE", &BOUNCEMINE, BOUNCEMINE__STATIC },
    { "BROKEFIREHYDRENT", &BROKEFIREHYDRENT, BROKEFIREHYDRENT__STATIC },
    { "BOX", &BOX, BOX__STATIC },
    { "BULLETHOLE", &BULLETHOLE, BULLETHOLE__STATIC },
    { "BOTTLE1", &BOTTLE1, BOTTLE1__STATIC },
    { "BOTTLE2", &BOTTLE2, BOTTLE2__STATIC },
    { "BOTTLE3", &BOTTLE3, BOTTLE3__STATIC },
    { "BOTTLE4", &BOTTLE4, BOTTLE4__STATIC },
    { "FEMPIC5", &FEMPIC5, FEMPIC5__STATIC },
    { "FEMPIC6", &FEMPIC6, FEMPIC6__STATIC },
    { "FEMPIC7", &FEMPIC7, FEMPIC7__STATIC },
    { "HYDROPLANT", &HYDROPLANT, HYDROPLANT__STATIC },
    { "OCEANSPRITE1", &OCEANSPRITE1, OCEANSPRITE1__STATIC },
    { "OCEANSPRITE2", &OCEANSPRITE2, OCEANSPRITE2__STATIC },
    { "OCEANSPRITE3", &OCEANSPRITE3, OCEANSPRITE3__STATIC },
    { "OCEANSPRITE4", &OCEANSPRITE4, OCEANSPRITE4__STATIC },
    { "OCEANSPRITE5", &OCEANSPRITE5, OCEANSPRITE5__STATIC },
    { "GENERICPOLE", &GENERICPOLE, GENERICPOLE__STATIC },
    { "CONE", &CONE, CONE__STATIC },
    { "HANGLIGHT", &HANGLIGHT, HANGLIGHT__STATIC },
    { "HYDRENT", &HYDRENT, HYDRENT__STATIC },
    { "MASKWALL14", &MASKWALL14, MASKWALL14__STATIC },
    { "TIRE", &TIRE, TIRE__STATIC },
    { "PIPE5", &PIPE5, PIPE5__STATIC },
    { "PIPE6", &PIPE6, PIPE6__STATIC },
    { "PIPE4", &PIPE4, PIPE4__STATIC },
    { "PIPE4B", &PIPE4B, PIPE4B__STATIC },
    { "BROKEHYDROPLANT", &BROKEHYDROPLANT, BROKEHYDROPLANT__STATIC },
    { "PIPE5B", &PIPE5B, PIPE5B__STATIC },
    { "NEON3", &NEON3, NEON3__STATIC },
    { "NEON4", &NEON4, NEON4__STATIC },
    { "NEON5", &NEON5, NEON5__STATIC },
    { "BOTTLE5", &BOTTLE5, BOTTLE5__STATIC },
    { "BOTTLE6", &BOTTLE6, BOTTLE6__STATIC },
    { "BOTTLE8", &BOTTLE8, BOTTLE8__STATIC },
    { "SPOTLITE", &SPOTLITE, SPOTLITE__STATIC },
    { "HANGOOZ", &HANGOOZ, HANGOOZ__STATIC },
    { "MASKWALL15", &MASKWALL15, MASKWALL15__STATIC },
    { "BOTTLE7", &BOTTLE7, BOTTLE7__STATIC },
    { "HORSEONSIDE", &HORSEONSIDE, HORSEONSIDE__STATIC },
    { "GLASSPIECES", &GLASSPIECES, GLASSPIECES__STATIC },
    { "HORSELITE", &HORSELITE, HORSELITE__STATIC },
    { "DONUTS", &DONUTS, DONUTS__STATIC },
    { "NEON6", &NEON6, NEON6__STATIC },
    { "MASKWALL6", &MASKWALL6, MASKWALL6__STATIC },
    { "CLOCK", &CLOCK, CLOCK__STATIC },
    { "RUBBERCAN", &RUBBERCAN, RUBBERCAN__STATIC },
    { "BROKENCLOCK", &BROKENCLOCK, BROKENCLOCK__STATIC },
    { "PLUG", &PLUG, PLUG__STATIC },
    { "OOZFILTER", &OOZFILTER, OOZFILTER__STATIC },
    { "FLOORPLASMA", &FLOORPLASMA, FLOORPLASMA__STATIC },
    { "REACTOR", &REACTOR, REACTOR__STATIC },
    { "REACTORSPARK", &REACTORSPARK, REACTORSPARK__STATIC },
    { "REACTORBURNT", &REACTORBURNT, REACTORBURNT__STATIC },
    { "DOORTILE15", &DOORTILE15, DOORTILE15__STATIC },
    { "HANDSWITCH", &HANDSWITCH, HANDSWITCH__STATIC },
    { "CIRCLEPANNEL", &CIRCLEPANNEL, CIRCLEPANNEL__STATIC },
    { "CIRCLEPANNELBROKE", &CIRCLEPANNELBROKE, CIRCLEPANNELBROKE__STATIC },
    { "PULLSWITCH", &PULLSWITCH, PULLSWITCH__STATIC },
    { "MASKWALL8", &MASKWALL8, MASKWALL8__STATIC },
    { "BIGHOLE", &BIGHOLE, BIGHOLE__STATIC },
    { "ALIENSWITCH", &ALIENSWITCH, ALIENSWITCH__STATIC },
    { "DOORTILE21", &DOORTILE21, DOORTILE21__STATIC },
    { "HANDPRINTSWITCH", &HANDPRINTSWITCH, HANDPRINTSWITCH__STATIC },
    { "BOTTLE10", &BOTTLE10, BOTTLE10__STATIC },
    { "BOTTLE11", &BOTTLE11, BOTTLE11__STATIC },
    { "BOTTLE12", &BOTTLE12, BOTTLE12__STATIC },
    { "BOTTLE13", &BOTTLE13, BOTTLE13__STATIC },
    { "BOTTLE14", &BOTTLE14, BOTTLE14__STATIC },
    { "BOTTLE15", &BOTTLE15, BOTTLE15__STATIC },
    { "BOTTLE16", &BOTTLE16, BOTTLE16__STATIC },
    { "BOTTLE17", &BOTTLE17, BOTTLE17__STATIC },
    { "BOTTLE18", &BOTTLE18, BOTTLE18__STATIC },
    { "BOTTLE19", &BOTTLE19, BOTTLE19__STATIC },
    { "DOORTILE17", &DOORTILE17, DOORTILE17__STATIC },
    { "MASKWALL7", &MASKWALL7, MASKWALL7__STATIC },
    { "JAILBARBREAK", &JAILBARBREAK, JAILBARBREAK__STATIC },
    { "DOORTILE11", &DOORTILE11, DOORTILE11__STATIC },
    { "DOORTILE12", &DOORTILE12, DOORTILE12__STATIC },
    { "VENDMACHINE", &VENDMACHINE, VENDMACHINE__STATIC },
    { "VENDMACHINEBROKE", &VENDMACHINEBROKE, VENDMACHINEBROKE__STATIC },
    { "COLAMACHINE", &COLAMACHINE, COLAMACHINE__STATIC },
    { "COLAMACHINEBROKE", &COLAMACHINEBROKE, COLAMACHINEBROKE__STATIC },
    { "CRANEPOLE", &CRANEPOLE, CRANEPOLE__STATIC },
    { "CRANE", &CRANE, CRANE__STATIC },
    { "BARBROKE", &BARBROKE, BARBROKE__STATIC },
    { "BLOODPOOL", &BLOODPOOL, BLOODPOOL__STATIC },
    { "NUKEBARREL", &NUKEBARREL, NUKEBARREL__STATIC },
    { "NUKEBARRELDENTED", &NUKEBARRELDENTED, NUKEBARRELDENTED__STATIC },
    { "NUKEBARRELLEAKED", &NUKEBARRELLEAKED, NUKEBARRELLEAKED__STATIC },
    { "CANWITHSOMETHING", &CANWITHSOMETHING, CANWITHSOMETHING__STATIC },
    { "MONEY", &MONEY, MONEY__STATIC },
    { "BANNER", &BANNER, BANNER__STATIC },
    { "EXPLODINGBARREL", &EXPLODINGBARREL, EXPLODINGBARREL__STATIC },
    { "EXPLODINGBARREL2", &EXPLODINGBARREL2, EXPLODINGBARREL2__STATIC },
    { "FIREBARREL", &FIREBARREL, FIREBARREL__STATIC },
    { "SEENINE", &SEENINE, SEENINE__STATIC },
    { "SEENINEDEAD", &SEENINEDEAD, SEENINEDEAD__STATIC },
    { "STEAM", &STEAM, STEAM__STATIC },
    { "CEILINGSTEAM", &CEILINGSTEAM, CEILINGSTEAM__STATIC },
    { "PIPE6B", &PIPE6B, PIPE6B__STATIC },
    { "TRANSPORTERBEAM", &TRANSPORTERBEAM, TRANSPORTERBEAM__STATIC },
    { "RAT", &RAT, RAT__STATIC },
    { "TRASH", &TRASH, TRASH__STATIC },
    { "FEMPIC1", &FEMPIC1, FEMPIC1__STATIC },
    { "FEMPIC2", &FEMPIC2, FEMPIC2__STATIC },
    { "BLANKSCREEN", &BLANKSCREEN, BLANKSCREEN__STATIC },
    { "PODFEM1", &PODFEM1, PODFEM1__STATIC },
    { "FEMPIC3", &FEMPIC3, FEMPIC3__STATIC },
    { "FEMPIC4", &FEMPIC4, FEMPIC4__STATIC },
    { "FEM1", &FEM1, FEM1__STATIC },
    { "FEM2", &FEM2, FEM2__STATIC },
    { "FEM3", &FEM3, FEM3__STATIC },
    { "FEM5", &FEM5, FEM5__STATIC },
    { "BLOODYPOLE", &BLOODYPOLE, BLOODYPOLE__STATIC },
    { "FEM4", &FEM4, FEM4__STATIC },
    { "FEM6", &FEM6, FEM6__STATIC },
    { "FEM6PAD", &FEM6PAD, FEM6PAD__STATIC },
    { "FEM8", &FEM8, FEM8__STATIC },
    { "HELECOPT", &HELECOPT, HELECOPT__STATIC },
    { "FETUSJIB", &FETUSJIB, FETUSJIB__STATIC },
    { "HOLODUKE", &HOLODUKE, HOLODUKE__STATIC },
    { "SPACEMARINE", &SPACEMARINE, SPACEMARINE__STATIC },
    { "INDY", &INDY, INDY__STATIC },
    { "FETUS", &FETUS, FETUS__STATIC },
    { "FETUSBROKE", &FETUSBROKE, FETUSBROKE__STATIC },
    { "MONK", &MONK, MONK__STATIC },
    { "LUKE", &LUKE, LUKE__STATIC },
    { "COOLEXPLOSION1", &COOLEXPLOSION1, COOLEXPLOSION1__STATIC },
    { "WATERSPLASH2", &WATERSPLASH2, WATERSPLASH2__STATIC },
    { "FIREVASE", &FIREVASE, FIREVASE__STATIC },
    { "SCRATCH", &SCRATCH, SCRATCH__STATIC },
    { "FEM7", &FEM7, FEM7__STATIC },
    { "APLAYERTOP", &APLAYERTOP, APLAYERTOP__STATIC },
    { "APLAYER", &APLAYER, APLAYER__STATIC },
    { "PLAYERONWATER", &PLAYERONWATER, PLAYERONWATER__STATIC },
    { "DUKELYINGDEAD", &DUKELYINGDEAD, DUKELYINGDEAD__STATIC },
    { "DUKETORSO", &DUKETORSO, DUKETORSO__STATIC },
    { "DUKEGUN", &DUKEGUN, DUKEGUN__STATIC },
    { "DUKELEG", &DUKELEG, DUKELEG__STATIC },
    { "SHARK", &SHARK, SHARK__STATIC },
    { "BLOOD", &BLOOD, BLOOD__STATIC },
    { "FIRELASER", &FIRELASER, FIRELASER__STATIC },
    { "TRANSPORTERSTAR", &TRANSPORTERSTAR, TRANSPORTERSTAR__STATIC },
    { "SPIT", &SPIT, SPIT__STATIC },
    { "LOOGIE", &LOOGIE, LOOGIE__STATIC },
    { "FIST", &FIST, FIST__STATIC },
    { "FREEZEBLAST", &FREEZEBLAST, FREEZEBLAST__STATIC },
    { "DEVISTATORBLAST", &DEVISTATORBLAST, DEVISTATORBLAST__STATIC },
    { "SHRINKSPARK", &SHRINKSPARK, SHRINKSPARK__STATIC },
    { "TONGUE", &TONGUE, TONGUE__STATIC },
    { "MORTER", &MORTER, MORTER__STATIC },
    { "SHRINKEREXPLOSION", &SHRINKEREXPLOSION, SHRINKEREXPLOSION__STATIC },
    { "RADIUSEXPLOSION", &RADIUSEXPLOSION, RADIUSEXPLOSION__STATIC },
    { "FORCERIPPLE", &FORCERIPPLE, FORCERIPPLE__STATIC },
    { "LIZTROOP", &LIZTROOP, LIZTROOP__STATIC },
    { "LIZTROOPRUNNING", &LIZTROOPRUNNING, LIZTROOPRUNNING__STATIC },
    { "LIZTROOPSTAYPUT", &LIZTROOPSTAYPUT, LIZTROOPSTAYPUT__STATIC },
    { "LIZTOP", &LIZTOP, LIZTOP__STATIC },
    { "LIZTROOPSHOOT", &LIZTROOPSHOOT, LIZTROOPSHOOT__STATIC },
    { "LIZTROOPJETPACK", &LIZTROOPJETPACK, LIZTROOPJETPACK__STATIC },
    { "LIZTROOPDSPRITE", &LIZTROOPDSPRITE, LIZTROOPDSPRITE__STATIC },
    { "LIZTROOPONTOILET", &LIZTROOPONTOILET, LIZTROOPONTOILET__STATIC },
    { "LIZTROOPJUSTSIT", &LIZTROOPJUSTSIT, LIZTROOPJUSTSIT__STATIC },
    { "LIZTROOPDUCKING", &LIZTROOPDUCKING, LIZTROOPDUCKING__STATIC },
    { "HEADJIB1", &HEADJIB1, HEADJIB1__STATIC },
    { "ARMJIB1", &ARMJIB1, ARMJIB1__STATIC },
    { "LEGJIB1", &LEGJIB1, LEGJIB1__STATIC },
    { "CANNONBALL", &CANNONBALL, CANNONBALL__STATIC },
    { "OCTABRAIN", &OCTABRAIN, OCTABRAIN__STATIC },
    { "OCTABRAINSTAYPUT", &OCTABRAINSTAYPUT, OCTABRAINSTAYPUT__STATIC },
    { "OCTATOP", &OCTATOP, OCTATOP__STATIC },
    { "OCTADEADSPRITE", &OCTADEADSPRITE, OCTADEADSPRITE__STATIC },
    { "INNERJAW", &INNERJAW, INNERJAW__STATIC },
    { "DRONE", &DRONE, DRONE__STATIC },
    { "EXPLOSION2", &EXPLOSION2, EXPLOSION2__STATIC },
    { "COMMANDER", &COMMANDER, COMMANDER__STATIC },
    { "COMMANDERSTAYPUT", &COMMANDERSTAYPUT, COMMANDERSTAYPUT__STATIC },
    { "RECON", &RECON, RECON__STATIC },
    { "TANK", &TANK, TANK__STATIC },
    { "PIGCOP", &PIGCOP, PIGCOP__STATIC },
    { "PIGCOPSTAYPUT", &PIGCOPSTAYPUT, PIGCOPSTAYPUT__STATIC },
    { "PIGCOPDIVE", &PIGCOPDIVE, PIGCOPDIVE__STATIC },
    { "PIGCOPDEADSPRITE", &PIGCOPDEADSPRITE, PIGCOPDEADSPRITE__STATIC },
    { "PIGTOP", &PIGTOP, PIGTOP__STATIC },
    { "LIZMAN", &LIZMAN, LIZMAN__STATIC },
    { "LIZMANSTAYPUT", &LIZMANSTAYPUT, LIZMANSTAYPUT__STATIC },
    { "LIZMANSPITTING", &LIZMANSPITTING, LIZMANSPITTING__STATIC },
    { "LIZMANFEEDING", &LIZMANFEEDING, LIZMANFEEDING__STATIC },
    { "LIZMANJUMP", &LIZMANJUMP, LIZMANJUMP__STATIC },
    { "LIZMANDEADSPRITE", &LIZMANDEADSPRITE, LIZMANDEADSPRITE__STATIC },
    { "FECES", &FECES, FECES__STATIC },
    { "LIZMANHEAD1", &LIZMANHEAD1, LIZMANHEAD1__STATIC },
    { "LIZMANARM1", &LIZMANARM1, LIZMANARM1__STATIC },
    { "LIZMANLEG1", &LIZMANLEG1, LIZMANLEG1__STATIC },
    { "EXPLOSION2BOT", &EXPLOSION2BOT, EXPLOSION2BOT__STATIC },
    { "USERWEAPON", &USERWEAPON, USERWEAPON__STATIC },
    { "HEADERBAR", &HEADERBAR, HEADERBAR__STATIC },
    { "JIBS1", &JIBS1, JIBS1__STATIC },
    { "JIBS2", &JIBS2, JIBS2__STATIC },
    { "JIBS3", &JIBS3, JIBS3__STATIC },
    { "JIBS4", &JIBS4, JIBS4__STATIC },
    { "JIBS5", &JIBS5, JIBS5__STATIC },
    { "BURNING", &BURNING, BURNING__STATIC },
    { "FIRE", &FIRE, FIRE__STATIC },
    { "JIBS6", &JIBS6, JIBS6__STATIC },
    { "BLOODSPLAT1", &BLOODSPLAT1, BLOODSPLAT1__STATIC },
    { "BLOODSPLAT3", &BLOODSPLAT3, BLOODSPLAT3__STATIC },
    { "BLOODSPLAT2", &BLOODSPLAT2, BLOODSPLAT2__STATIC },
    { "BLOODSPLAT4", &BLOODSPLAT4, BLOODSPLAT4__STATIC },
    { "OOZ", &OOZ, OOZ__STATIC },
    { "OOZ2", &OOZ2, OOZ2__STATIC },
    { "WALLBLOOD1", &WALLBLOOD1, WALLBLOOD1__STATIC },
    { "WALLBLOOD2", &WALLBLOOD2, WALLBLOOD2__STATIC },
    { "WALLBLOOD3", &WALLBLOOD3, WALLBLOOD3__STATIC },
    { "WALLBLOOD4", &WALLBLOOD4, WALLBLOOD4__STATIC },
    { "WALLBLOOD5", &WALLBLOOD5, WALLBLOOD5__STATIC },
    { "WALLBLOOD6", &WALLBLOOD6, WALLBLOOD6__STATIC },
    { "WALLBLOOD7", &WALLBLOOD7, WALLBLOOD7__STATIC },
    { "WALLBLOOD8", &WALLBLOOD8, WALLBLOOD8__STATIC },
    { "BURNING2", &BURNING2, BURNING2__STATIC },
    { "FIRE2", &FIRE2, FIRE2__STATIC },
    { "CRACKKNUCKLES", &CRACKKNUCKLES, CRACKKNUCKLES__STATIC },
    { "SMALLSMOKE", &SMALLSMOKE, SMALLSMOKE__STATIC },
    { "SMALLSMOKEMAKER", &SMALLSMOKEMAKER, SMALLSMOKEMAKER__STATIC },
    { "FLOORFLAME", &FLOORFLAME, FLOORFLAME__STATIC },
    { "ROTATEGUN", &ROTATEGUN, ROTATEGUN__STATIC },
    { "GREENSLIME", &GREENSLIME, GREENSLIME__STATIC },
    { "WATERDRIPSPLASH", &WATERDRIPSPLASH, WATERDRIPSPLASH__STATIC },
    { "SCRAP6", &SCRAP6, SCRAP6__STATIC },
    { "SCRAP1", &SCRAP1, SCRAP1__STATIC },
    { "SCRAP2", &SCRAP2, SCRAP2__STATIC },
    { "SCRAP3", &SCRAP3, SCRAP3__STATIC },
    { "SCRAP4", &SCRAP4, SCRAP4__STATIC },
    { "SCRAP5", &SCRAP5, SCRAP5__STATIC },
    { "ORGANTIC", &ORGANTIC, ORGANTIC__STATIC },
    { "BETAVERSION", &BETAVERSION, BETAVERSION__STATIC },
    { "PLAYERISHERE", &PLAYERISHERE, PLAYERISHERE__STATIC },
    { "PLAYERWASHERE", &PLAYERWASHERE, PLAYERWASHERE__STATIC },
    { "SELECTDIR", &SELECTDIR, SELECTDIR__STATIC },
    { "F1HELP", &F1HELP, F1HELP__STATIC },
    { "NOTCHON", &NOTCHON, NOTCHON__STATIC },
    { "NOTCHOFF", &NOTCHOFF, NOTCHOFF__STATIC },
    { "GROWSPARK", &GROWSPARK, GROWSPARK__STATIC },
    { "DUKEICON", &DUKEICON, DUKEICON__STATIC },
    { "BADGUYICON", &BADGUYICON, BADGUYICON__STATIC },
    { "FOODICON", &FOODICON, FOODICON__STATIC },
    { "GETICON", &GETICON, GETICON__STATIC },
    { "MENUSCREEN", &MENUSCREEN, MENUSCREEN__STATIC },
    { "MENUBAR", &MENUBAR, MENUBAR__STATIC },
    { "KILLSICON", &KILLSICON, KILLSICON__STATIC },
    { "FIRSTAID_ICON", &FIRSTAID_ICON, FIRSTAID_ICON__STATIC },
    { "HEAT_ICON", &HEAT_ICON, HEAT_ICON__STATIC },
    { "BOTTOMSTATUSBAR", &BOTTOMSTATUSBAR, BOTTOMSTATUSBAR__STATIC },
    { "BOOT_ICON", &BOOT_ICON, BOOT_ICON__STATIC },
    { "FRAGBAR", &FRAGBAR, FRAGBAR__STATIC },
    { "JETPACK_ICON", &JETPACK_ICON, JETPACK_ICON__STATIC },
    { "AIRTANK_ICON", &AIRTANK_ICON, AIRTANK_ICON__STATIC },
    { "STEROIDS_ICON", &STEROIDS_ICON, STEROIDS_ICON__STATIC },
    { "HOLODUKE_ICON", &HOLODUKE_ICON, HOLODUKE_ICON__STATIC },
    { "ACCESS_ICON", &ACCESS_ICON, ACCESS_ICON__STATIC },
    { "DIGITALNUM", &DIGITALNUM, DIGITALNUM__STATIC },
    { "DUKECAR", &DUKECAR, DUKECAR__STATIC },
    { "CAMCORNER", &CAMCORNER, CAMCORNER__STATIC },
    { "CAMLIGHT", &CAMLIGHT, CAMLIGHT__STATIC },
    { "LOGO", &LOGO, LOGO__STATIC },
    { "TITLE", &TITLE, TITLE__STATIC },
    { "NUKEWARNINGICON", &NUKEWARNINGICON, NUKEWARNINGICON__STATIC },
    { "MOUSECURSOR", &MOUSECURSOR, MOUSECURSOR__STATIC },
    { "SLIDEBAR", &SLIDEBAR, SLIDEBAR__STATIC },
    { "DREALMS", &DREALMS, DREALMS__STATIC },
    { "BETASCREEN", &BETASCREEN, BETASCREEN__STATIC },
    { "WINDOWBORDER1", &WINDOWBORDER1, WINDOWBORDER1__STATIC },
    { "TEXTBOX", &TEXTBOX, TEXTBOX__STATIC },
    { "WINDOWBORDER2", &WINDOWBORDER2, WINDOWBORDER2__STATIC },
    { "DUKENUKEM", &DUKENUKEM, DUKENUKEM__STATIC },
    { "THREEDEE", &THREEDEE, THREEDEE__STATIC },
    { "INGAMEDUKETHREEDEE", &INGAMEDUKETHREEDEE, INGAMEDUKETHREEDEE__STATIC },
    { "TENSCREEN", &TENSCREEN, TENSCREEN__STATIC },
    { "PLUTOPAKSPRITE", &PLUTOPAKSPRITE, PLUTOPAKSPRITE__STATIC },
    { "DEVISTATOR", &DEVISTATOR, DEVISTATOR__STATIC },
    { "KNEE", &KNEE, KNEE__STATIC },
    { "CROSSHAIR", &CROSSHAIR, CROSSHAIR__STATIC },
    { "FIRSTGUN", &FIRSTGUN, FIRSTGUN__STATIC },
    { "FIRSTGUNRELOAD", &FIRSTGUNRELOAD, FIRSTGUNRELOAD__STATIC },
    { "FALLINGCLIP", &FALLINGCLIP, FALLINGCLIP__STATIC },
    { "CLIPINHAND", &CLIPINHAND, CLIPINHAND__STATIC },
    { "HAND", &HAND, HAND__STATIC },
    { "SHELL", &SHELL, SHELL__STATIC },
    { "SHOTGUNSHELL", &SHOTGUNSHELL, SHOTGUNSHELL__STATIC },
    { "CHAINGUN", &CHAINGUN, CHAINGUN__STATIC },
    { "RPGGUN", &RPGGUN, RPGGUN__STATIC },
    { "RPGMUZZLEFLASH", &RPGMUZZLEFLASH, RPGMUZZLEFLASH__STATIC },
    { "FREEZE", &FREEZE, FREEZE__STATIC },
    { "CATLITE", &CATLITE, CATLITE__STATIC },
    { "SHRINKER", &SHRINKER, SHRINKER__STATIC },
    { "HANDHOLDINGLASER", &HANDHOLDINGLASER, HANDHOLDINGLASER__STATIC },
    { "TRIPBOMB", &TRIPBOMB, TRIPBOMB__STATIC },
    { "LASERLINE", &LASERLINE, LASERLINE__STATIC },
    { "HANDHOLDINGACCESS", &HANDHOLDINGACCESS, HANDHOLDINGACCESS__STATIC },
    { "HANDREMOTE", &HANDREMOTE, HANDREMOTE__STATIC },
    { "HANDTHROW", &HANDTHROW, HANDTHROW__STATIC },
    { "TIP", &TIP, TIP__STATIC },
    { "GLAIR", &GLAIR, GLAIR__STATIC },
    { "SCUBAMASK", &SCUBAMASK, SCUBAMASK__STATIC },
    { "SPACEMASK", &SPACEMASK, SPACEMASK__STATIC },
    { "FORCESPHERE", &FORCESPHERE, FORCESPHERE__STATIC },
    { "SHOTSPARK1", &SHOTSPARK1, SHOTSPARK1__STATIC },
    { "RPG", &RPG, RPG__STATIC },
    { "LASERSITE", &LASERSITE, LASERSITE__STATIC },
    { "SHOTGUN", &SHOTGUN, SHOTGUN__STATIC },
    { "BOSS1", &BOSS1, BOSS1__STATIC },
    { "BOSS1STAYPUT", &BOSS1STAYPUT, BOSS1STAYPUT__STATIC },
    { "BOSS1SHOOT", &BOSS1SHOOT, BOSS1SHOOT__STATIC },
    { "BOSS1LOB", &BOSS1LOB, BOSS1LOB__STATIC },
    { "BOSSTOP", &BOSSTOP, BOSSTOP__STATIC },
    { "BOSS2", &BOSS2, BOSS2__STATIC },
    { "BOSS3", &BOSS3, BOSS3__STATIC },
    { "SPINNINGNUKEICON", &SPINNINGNUKEICON, SPINNINGNUKEICON__STATIC },
    { "BIGFNTCURSOR", &BIGFNTCURSOR, BIGFNTCURSOR__STATIC },
    { "SMALLFNTCURSOR", &SMALLFNTCURSOR, SMALLFNTCURSOR__STATIC },
    { "STARTALPHANUM", &STARTALPHANUM, STARTALPHANUM__STATIC },
    { "ENDALPHANUM", &ENDALPHANUM, ENDALPHANUM__STATIC },
    { "BIGALPHANUM", &BIGALPHANUM, BIGALPHANUM__STATIC },
    { "BIGPERIOD", &BIGPERIOD, BIGPERIOD__STATIC },
    { "BIGCOMMA", &BIGCOMMA, BIGCOMMA__STATIC },
    { "BIGX", &BIGX, BIGX__STATIC },
    { "BIGQ", &BIGQ, BIGQ__STATIC },
    { "BIGSEMI", &BIGSEMI, BIGSEMI__STATIC },
    { "BIGCOLIN", &BIGCOLIN, BIGCOLIN__STATIC },
    { "THREEBYFIVE", &THREEBYFIVE, THREEBYFIVE__STATIC },
    { "BIGAPPOS", &BIGAPPOS, BIGAPPOS__STATIC },
    { "BLANK", &BLANK, BLANK__STATIC },
    { "MINIFONT", &MINIFONT, MINIFONT__STATIC },
    { "BUTTON1", &BUTTON1, BUTTON1__STATIC },
    { "GLASS3", &GLASS3, GLASS3__STATIC },
    { "RESPAWNMARKERRED", &RESPAWNMARKERRED, RESPAWNMARKERRED__STATIC },
    { "RESPAWNMARKERYELLOW", &RESPAWNMARKERYELLOW, RESPAWNMARKERYELLOW__STATIC },
    { "RESPAWNMARKERGREEN", &RESPAWNMARKERGREEN, RESPAWNMARKERGREEN__STATIC },
    { "BONUSSCREEN", &BONUSSCREEN, BONUSSCREEN__STATIC },
    { "VIEWBORDER", &VIEWBORDER, VIEWBORDER__STATIC },
    { "VICTORY1", &VICTORY1, VICTORY1__STATIC },
    { "ORDERING", &ORDERING, ORDERING__STATIC },
    { "TEXTSTORY", &TEXTSTORY, TEXTSTORY__STATIC },
    { "LOADSCREEN", &LOADSCREEN, LOADSCREEN__STATIC },
    { "BORNTOBEWILDSCREEN", &BORNTOBEWILDSCREEN, BORNTOBEWILDSCREEN__STATIC },
    { "BLIMP", &BLIMP, BLIMP__STATIC },
    { "FEM9", &FEM9, FEM9__STATIC },
    { "FOOTPRINT", &FOOTPRINT, FOOTPRINT__STATIC },
    { "FRAMEEFFECT1_13", &FRAMEEFFECT1_13, FRAMEEFFECT1_13__STATIC },
    { "POOP", &POOP, POOP__STATIC },
    { "FRAMEEFFECT1", &FRAMEEFFECT1, FRAMEEFFECT1__STATIC },
    { "PANNEL3", &PANNEL3, PANNEL3__STATIC },
    { "SCREENBREAK14", &SCREENBREAK14, SCREENBREAK14__STATIC },
    { "SCREENBREAK15", &SCREENBREAK15, SCREENBREAK15__STATIC },
    { "SCREENBREAK19", &SCREENBREAK19, SCREENBREAK19__STATIC },
    { "SCREENBREAK16", &SCREENBREAK16, SCREENBREAK16__STATIC },
    { "SCREENBREAK17", &SCREENBREAK17, SCREENBREAK17__STATIC },
    { "SCREENBREAK18", &SCREENBREAK18, SCREENBREAK18__STATIC },
    { "W_TECHWALL11", &W_TECHWALL11, W_TECHWALL11__STATIC },
    { "W_TECHWALL12", &W_TECHWALL12, W_TECHWALL12__STATIC },
    { "W_TECHWALL13", &W_TECHWALL13, W_TECHWALL13__STATIC },
    { "W_TECHWALL14", &W_TECHWALL14, W_TECHWALL14__STATIC },
    { "W_TECHWALL5", &W_TECHWALL5, W_TECHWALL5__STATIC },
    { "W_TECHWALL6", &W_TECHWALL6, W_TECHWALL6__STATIC },
    { "W_TECHWALL7", &W_TECHWALL7, W_TECHWALL7__STATIC },
    { "W_TECHWALL8", &W_TECHWALL8, W_TECHWALL8__STATIC },
    { "W_TECHWALL9", &W_TECHWALL9, W_TECHWALL9__STATIC },
    { "BPANNEL3", &BPANNEL3, BPANNEL3__STATIC },
    { "W_HITTECHWALL16", &W_HITTECHWALL16, W_HITTECHWALL16__STATIC },
    { "W_HITTECHWALL10", &W_HITTECHWALL10, W_HITTECHWALL10__STATIC },
    { "W_HITTECHWALL15", &W_HITTECHWALL15, W_HITTECHWALL15__STATIC },
    { "W_MILKSHELF", &W_MILKSHELF, W_MILKSHELF__STATIC },
    { "W_MILKSHELFBROKE", &W_MILKSHELFBROKE, W_MILKSHELFBROKE__STATIC },
    { "PURPLELAVA", &PURPLELAVA, PURPLELAVA__STATIC },
    { "LAVABUBBLE", &LAVABUBBLE, LAVABUBBLE__STATIC },
    { "DUKECUTOUT", &DUKECUTOUT, DUKECUTOUT__STATIC },
    { "TARGET", &TARGET, TARGET__STATIC },
    { "GUNPOWDERBARREL", &GUNPOWDERBARREL, GUNPOWDERBARREL__STATIC },
    { "DUCK", &DUCK, DUCK__STATIC },
    { "HATRACK", &HATRACK, HATRACK__STATIC },
    { "DESKLAMP", &DESKLAMP, DESKLAMP__STATIC },
    { "COFFEEMACHINE", &COFFEEMACHINE, COFFEEMACHINE__STATIC },
    { "CUPS", &CUPS, CUPS__STATIC },
    { "GAVALS", &GAVALS, GAVALS__STATIC },
    { "GAVALS2", &GAVALS2, GAVALS2__STATIC },
    { "POLICELIGHTPOLE", &POLICELIGHTPOLE, POLICELIGHTPOLE__STATIC },
    { "FLOORBASKET", &FLOORBASKET, FLOORBASKET__STATIC },
    { "PUKE", &PUKE, PUKE__STATIC },
    { "DOORTILE23", &DOORTILE23, DOORTILE23__STATIC },
    { "TOPSECRET", &TOPSECRET, TOPSECRET__STATIC },
    { "SPEAKER", &SPEAKER, SPEAKER__STATIC },
    { "TEDDYBEAR", &TEDDYBEAR, TEDDYBEAR__STATIC },
    { "ROBOTDOG", &ROBOTDOG, ROBOTDOG__STATIC },
    { "ROBOTPIRATE", &ROBOTPIRATE, ROBOTPIRATE__STATIC },
    { "ROBOTMOUSE", &ROBOTMOUSE, ROBOTMOUSE__STATIC },
    { "MAIL", &MAIL, MAIL__STATIC },
    { "MAILBAG", &MAILBAG, MAILBAG__STATIC },
    { "HOTMEAT", &HOTMEAT, HOTMEAT__STATIC },
    { "COFFEEMUG", &COFFEEMUG, COFFEEMUG__STATIC },
    { "DONUTS2", &DONUTS2, DONUTS2__STATIC },
    { "TRIPODCAMERA", &TRIPODCAMERA, TRIPODCAMERA__STATIC },
    { "METER", &METER, METER__STATIC },
    { "DESKPHONE", &DESKPHONE, DESKPHONE__STATIC },
    { "GUMBALLMACHINE", &GUMBALLMACHINE, GUMBALLMACHINE__STATIC },
    { "GUMBALLMACHINEBROKE", &GUMBALLMACHINEBROKE, GUMBALLMACHINEBROKE__STATIC },
    { "PAPER", &PAPER, PAPER__STATIC },
    { "MACE", &MACE, MACE__STATIC },
    { "GENERICPOLE2", &GENERICPOLE2, GENERICPOLE2__STATIC },
    { "XXXSTACY", &XXXSTACY, XXXSTACY__STATIC },
    { "WETFLOOR", &WETFLOOR, WETFLOOR__STATIC },
    { "BROOM", &BROOM, BROOM__STATIC },
    { "MOP", &MOP, MOP__STATIC },
    { "LETTER", &LETTER, LETTER__STATIC },
    { "PIRATE1A", &PIRATE1A, PIRATE1A__STATIC },
    { "PIRATE4A", &PIRATE4A, PIRATE4A__STATIC },
    { "PIRATE2A", &PIRATE2A, PIRATE2A__STATIC },
    { "PIRATE5A", &PIRATE5A, PIRATE5A__STATIC },
    { "PIRATE3A", &PIRATE3A, PIRATE3A__STATIC },
    { "PIRATE6A", &PIRATE6A, PIRATE6A__STATIC },
    { "PIRATEHALF", &PIRATEHALF, PIRATEHALF__STATIC },
    { "CHESTOFGOLD", &CHESTOFGOLD, CHESTOFGOLD__STATIC },
    { "SIDEBOLT1", &SIDEBOLT1, SIDEBOLT1__STATIC },
    { "FOODOBJECT1", &FOODOBJECT1, FOODOBJECT1__STATIC },
    { "FOODOBJECT2", &FOODOBJECT2, FOODOBJECT2__STATIC },
    { "FOODOBJECT3", &FOODOBJECT3, FOODOBJECT3__STATIC },
    { "FOODOBJECT4", &FOODOBJECT4, FOODOBJECT4__STATIC },
    { "FOODOBJECT5", &FOODOBJECT5, FOODOBJECT5__STATIC },
    { "FOODOBJECT6", &FOODOBJECT6, FOODOBJECT6__STATIC },
    { "FOODOBJECT7", &FOODOBJECT7, FOODOBJECT7__STATIC },
    { "FOODOBJECT8", &FOODOBJECT8, FOODOBJECT8__STATIC },
    { "FOODOBJECT9", &FOODOBJECT9, FOODOBJECT9__STATIC },
    { "FOODOBJECT10", &FOODOBJECT10, FOODOBJECT10__STATIC },
    { "FOODOBJECT11", &FOODOBJECT11, FOODOBJECT11__STATIC },
    { "FOODOBJECT12", &FOODOBJECT12, FOODOBJECT12__STATIC },
    { "FOODOBJECT13", &FOODOBJECT13, FOODOBJECT13__STATIC },
    { "FOODOBJECT14", &FOODOBJECT14, FOODOBJECT14__STATIC },
    { "FOODOBJECT15", &FOODOBJECT15, FOODOBJECT15__STATIC },
    { "FOODOBJECT16", &FOODOBJECT16, FOODOBJECT16__STATIC },
    { "FOODOBJECT17", &FOODOBJECT17, FOODOBJECT17__STATIC },
    { "FOODOBJECT18", &FOODOBJECT18, FOODOBJECT18__STATIC },
    { "FOODOBJECT19", &FOODOBJECT19, FOODOBJECT19__STATIC },
    { "FOODOBJECT20", &FOODOBJECT20, FOODOBJECT20__STATIC },
    { "HEADLAMP", &HEADLAMP, HEADLAMP__STATIC },
    { "TAMPON", &TAMPON, TAMPON__STATIC },
    { "SKINNEDCHICKEN", &SKINNEDCHICKEN, SKINNEDCHICKEN__STATIC },
    { "FEATHEREDCHICKEN", &FEATHEREDCHICKEN, FEATHEREDCHICKEN__STATIC },
    { "ROBOTDOG2", &ROBOTDOG2, ROBOTDOG2__STATIC },
    { "JOLLYMEAL", &JOLLYMEAL, JOLLYMEAL__STATIC },
    { "DUKEBURGER", &DUKEBURGER, DUKEBURGER__STATIC },
    { "SHOPPINGCART", &SHOPPINGCART, SHOPPINGCART__STATIC },
    { "CANWITHSOMETHING2", &CANWITHSOMETHING2, CANWITHSOMETHING2__STATIC },
    { "CANWITHSOMETHING3", &CANWITHSOMETHING3, CANWITHSOMETHING3__STATIC },
    { "CANWITHSOMETHING4", &CANWITHSOMETHING4, CANWITHSOMETHING4__STATIC },
    { "SNAKEP", &SNAKEP, SNAKEP__STATIC },
    { "DOLPHIN1", &DOLPHIN1, DOLPHIN1__STATIC },
    { "DOLPHIN2", &DOLPHIN2, DOLPHIN2__STATIC },
    { "NEWBEAST", &NEWBEAST, NEWBEAST__STATIC },
    { "NEWBEASTSTAYPUT", &NEWBEASTSTAYPUT, NEWBEASTSTAYPUT__STATIC },
    { "NEWBEASTJUMP", &NEWBEASTJUMP, NEWBEASTJUMP__STATIC },
    { "NEWBEASTHANG", &NEWBEASTHANG, NEWBEASTHANG__STATIC },
    { "NEWBEASTHANGDEAD", &NEWBEASTHANGDEAD, NEWBEASTHANGDEAD__STATIC },
    { "BOSS4", &BOSS4, BOSS4__STATIC },
    { "BOSS4STAYPUT", &BOSS4STAYPUT, BOSS4STAYPUT__STATIC },
    { "FEM10", &FEM10, FEM10__STATIC },
    { "TOUGHGAL", &TOUGHGAL, TOUGHGAL__STATIC },
    { "MAN", &MAN, MAN__STATIC },
    { "MAN2", &MAN2, MAN2__STATIC },
    { "WOMAN", &WOMAN, WOMAN__STATIC },
    { "PLEASEWAIT", &PLEASEWAIT, PLEASEWAIT__STATIC },
    { "NATURALLIGHTNING", &NATURALLIGHTNING, NATURALLIGHTNING__STATIC },
    { "WEATHERWARN", &WEATHERWARN, WEATHERWARN__STATIC },
    { "DUKETAG", &DUKETAG, DUKETAG__STATIC },
    { "SIGN1", &SIGN1, SIGN1__STATIC },
    { "SIGN2", &SIGN2, SIGN2__STATIC },
    { "JURYGUY", &JURYGUY, JURYGUY__STATIC },
    { "RESERVEDSLOT1", &RESERVEDSLOT1, RESERVEDSLOT1__STATIC },
    { "RESERVEDSLOT2", &RESERVEDSLOT2, RESERVEDSLOT2__STATIC },
    { "RESERVEDSLOT3", &RESERVEDSLOT3, RESERVEDSLOT3__STATIC },
    { "RESERVEDSLOT4", &RESERVEDSLOT4, RESERVEDSLOT4__STATIC },
    { "RESERVEDSLOT5", &RESERVEDSLOT5, RESERVEDSLOT5__STATIC },
    { "RESERVEDSLOT6", &RESERVEDSLOT6, RESERVEDSLOT6__STATIC },
    { "RESERVEDSLOT7", &RESERVEDSLOT7, RESERVEDSLOT7__STATIC },
    { "RESERVEDSLOT8", &RESERVEDSLOT8, RESERVEDSLOT8__STATIC },
    { "RESERVEDSLOT9", &RESERVEDSLOT9, RESERVEDSLOT9__STATIC },
    { "RESERVEDSLOT10", &RESERVEDSLOT10, RESERVEDSLOT10__STATIC },
    { "RESERVEDSLOT11", &RESERVEDSLOT11, RESERVEDSLOT11__STATIC },
    { "RESERVEDSLOT12", &RESERVEDSLOT12, RESERVEDSLOT12__STATIC },
    { 0, NULL, 0 },
 };

int32_t SECTOREFFECTOR = SECTOREFFECTOR__STATIC;
int32_t ACTIVATOR = ACTIVATOR__STATIC;
int32_t TOUCHPLATE = TOUCHPLATE__STATIC;
int32_t ACTIVATORLOCKED = ACTIVATORLOCKED__STATIC;
int32_t MUSICANDSFX = MUSICANDSFX__STATIC;
int32_t LOCATORS = LOCATORS__STATIC;
int32_t CYCLER = CYCLER__STATIC;
int32_t MASTERSWITCH = MASTERSWITCH__STATIC;
int32_t RESPAWN = RESPAWN__STATIC;
int32_t GPSPEED = GPSPEED__STATIC;
int32_t FOF = FOF__STATIC;
int32_t ARROW = ARROW__STATIC;
int32_t FIRSTGUNSPRITE = FIRSTGUNSPRITE__STATIC;
int32_t CHAINGUNSPRITE = CHAINGUNSPRITE__STATIC;
int32_t RPGSPRITE = RPGSPRITE__STATIC;
int32_t FREEZESPRITE = FREEZESPRITE__STATIC;
int32_t SHRINKERSPRITE = SHRINKERSPRITE__STATIC;
int32_t HEAVYHBOMB = HEAVYHBOMB__STATIC;
int32_t TRIPBOMBSPRITE = TRIPBOMBSPRITE__STATIC;
int32_t SHOTGUNSPRITE = SHOTGUNSPRITE__STATIC;
int32_t DEVISTATORSPRITE = DEVISTATORSPRITE__STATIC;
int32_t HEALTHBOX = HEALTHBOX__STATIC;
int32_t AMMOBOX = AMMOBOX__STATIC;
int32_t GROWSPRITEICON = GROWSPRITEICON__STATIC;
int32_t INVENTORYBOX = INVENTORYBOX__STATIC;
int32_t FREEZEAMMO = FREEZEAMMO__STATIC;
int32_t AMMO = AMMO__STATIC;
int32_t BATTERYAMMO = BATTERYAMMO__STATIC;
int32_t DEVISTATORAMMO = DEVISTATORAMMO__STATIC;
int32_t RPGAMMO = RPGAMMO__STATIC;
int32_t GROWAMMO = GROWAMMO__STATIC;
int32_t CRYSTALAMMO = CRYSTALAMMO__STATIC;
int32_t HBOMBAMMO = HBOMBAMMO__STATIC;
int32_t AMMOLOTS = AMMOLOTS__STATIC;
int32_t SHOTGUNAMMO = SHOTGUNAMMO__STATIC;
int32_t COLA = COLA__STATIC;
int32_t SIXPAK = SIXPAK__STATIC;
int32_t FIRSTAID = FIRSTAID__STATIC;
int32_t SHIELD = SHIELD__STATIC;
int32_t STEROIDS = STEROIDS__STATIC;
int32_t AIRTANK = AIRTANK__STATIC;
int32_t JETPACK = JETPACK__STATIC;
int32_t HEATSENSOR = HEATSENSOR__STATIC;
int32_t ACCESSCARD = ACCESSCARD__STATIC;
int32_t BOOTS = BOOTS__STATIC;
int32_t MIRRORBROKE = MIRRORBROKE__STATIC;
int32_t CLOUDYOCEAN = CLOUDYOCEAN__STATIC;
int32_t CLOUDYSKIES = CLOUDYSKIES__STATIC;
int32_t MOONSKY1 = MOONSKY1__STATIC;
int32_t MOONSKY2 = MOONSKY2__STATIC;
int32_t MOONSKY3 = MOONSKY3__STATIC;
int32_t MOONSKY4 = MOONSKY4__STATIC;
int32_t BIGORBIT1 = BIGORBIT1__STATIC;
int32_t BIGORBIT2 = BIGORBIT2__STATIC;
int32_t BIGORBIT3 = BIGORBIT3__STATIC;
int32_t BIGORBIT4 = BIGORBIT4__STATIC;
int32_t BIGORBIT5 = BIGORBIT5__STATIC;
int32_t LA = LA__STATIC;
int32_t REDSKY1 = REDSKY1__STATIC;
int32_t REDSKY2 = REDSKY2__STATIC;
int32_t ATOMICHEALTH = ATOMICHEALTH__STATIC;
int32_t TECHLIGHT2 = TECHLIGHT2__STATIC;
int32_t TECHLIGHTBUST2 = TECHLIGHTBUST2__STATIC;
int32_t TECHLIGHT4 = TECHLIGHT4__STATIC;
int32_t TECHLIGHTBUST4 = TECHLIGHTBUST4__STATIC;
int32_t WALLLIGHT4 = WALLLIGHT4__STATIC;
int32_t WALLLIGHTBUST4 = WALLLIGHTBUST4__STATIC;
int32_t ACCESSSWITCH = ACCESSSWITCH__STATIC;
int32_t SLOTDOOR = SLOTDOOR__STATIC;
int32_t LIGHTSWITCH = LIGHTSWITCH__STATIC;
int32_t SPACEDOORSWITCH = SPACEDOORSWITCH__STATIC;
int32_t SPACELIGHTSWITCH = SPACELIGHTSWITCH__STATIC;
int32_t FRANKENSTINESWITCH = FRANKENSTINESWITCH__STATIC;
int32_t NUKEBUTTON = NUKEBUTTON__STATIC;
int32_t MULTISWITCH = MULTISWITCH__STATIC;
int32_t DOORTILE5 = DOORTILE5__STATIC;
int32_t DOORTILE6 = DOORTILE6__STATIC;
int32_t DOORTILE1 = DOORTILE1__STATIC;
int32_t DOORTILE2 = DOORTILE2__STATIC;
int32_t DOORTILE3 = DOORTILE3__STATIC;
int32_t DOORTILE4 = DOORTILE4__STATIC;
int32_t DOORTILE7 = DOORTILE7__STATIC;
int32_t DOORTILE8 = DOORTILE8__STATIC;
int32_t DOORTILE9 = DOORTILE9__STATIC;
int32_t DOORTILE10 = DOORTILE10__STATIC;
int32_t DOORSHOCK = DOORSHOCK__STATIC;
int32_t DIPSWITCH = DIPSWITCH__STATIC;
int32_t DIPSWITCH2 = DIPSWITCH2__STATIC;
int32_t TECHSWITCH = TECHSWITCH__STATIC;
int32_t DIPSWITCH3 = DIPSWITCH3__STATIC;
int32_t ACCESSSWITCH2 = ACCESSSWITCH2__STATIC;
int32_t REFLECTWATERTILE = REFLECTWATERTILE__STATIC;
int32_t FLOORSLIME = FLOORSLIME__STATIC;
int32_t BIGFORCE = BIGFORCE__STATIC;
int32_t EPISODE = EPISODE__STATIC;
int32_t MASKWALL9 = MASKWALL9__STATIC;
int32_t W_LIGHT = W_LIGHT__STATIC;
int32_t SCREENBREAK1 = SCREENBREAK1__STATIC;
int32_t SCREENBREAK2 = SCREENBREAK2__STATIC;
int32_t SCREENBREAK3 = SCREENBREAK3__STATIC;
int32_t SCREENBREAK4 = SCREENBREAK4__STATIC;
int32_t SCREENBREAK5 = SCREENBREAK5__STATIC;
int32_t SCREENBREAK6 = SCREENBREAK6__STATIC;
int32_t SCREENBREAK7 = SCREENBREAK7__STATIC;
int32_t SCREENBREAK8 = SCREENBREAK8__STATIC;
int32_t SCREENBREAK9 = SCREENBREAK9__STATIC;
int32_t SCREENBREAK10 = SCREENBREAK10__STATIC;
int32_t SCREENBREAK11 = SCREENBREAK11__STATIC;
int32_t SCREENBREAK12 = SCREENBREAK12__STATIC;
int32_t SCREENBREAK13 = SCREENBREAK13__STATIC;
int32_t MASKWALL1 = MASKWALL1__STATIC;
int32_t W_TECHWALL1 = W_TECHWALL1__STATIC;
int32_t W_TECHWALL2 = W_TECHWALL2__STATIC;
int32_t W_TECHWALL15 = W_TECHWALL15__STATIC;
int32_t W_TECHWALL3 = W_TECHWALL3__STATIC;
int32_t W_TECHWALL4 = W_TECHWALL4__STATIC;
int32_t W_TECHWALL10 = W_TECHWALL10__STATIC;
int32_t W_TECHWALL16 = W_TECHWALL16__STATIC;
int32_t WATERTILE2 = WATERTILE2__STATIC;
int32_t BPANNEL1 = BPANNEL1__STATIC;
int32_t PANNEL1 = PANNEL1__STATIC;
int32_t PANNEL2 = PANNEL2__STATIC;
int32_t WATERTILE = WATERTILE__STATIC;
int32_t STATIC = STATIC__STATIC;
int32_t W_SCREENBREAK = W_SCREENBREAK__STATIC;
int32_t W_HITTECHWALL3 = W_HITTECHWALL3__STATIC;
int32_t W_HITTECHWALL4 = W_HITTECHWALL4__STATIC;
int32_t W_HITTECHWALL2 = W_HITTECHWALL2__STATIC;
int32_t W_HITTECHWALL1 = W_HITTECHWALL1__STATIC;
int32_t MASKWALL10 = MASKWALL10__STATIC;
int32_t MASKWALL11 = MASKWALL11__STATIC;
int32_t DOORTILE22 = DOORTILE22__STATIC;
int32_t FANSPRITE = FANSPRITE__STATIC;
int32_t FANSPRITEBROKE = FANSPRITEBROKE__STATIC;
int32_t FANSHADOW = FANSHADOW__STATIC;
int32_t FANSHADOWBROKE = FANSHADOWBROKE__STATIC;
int32_t DOORTILE18 = DOORTILE18__STATIC;
int32_t DOORTILE19 = DOORTILE19__STATIC;
int32_t DOORTILE20 = DOORTILE20__STATIC;
int32_t SATELLITE = SATELLITE__STATIC;
int32_t VIEWSCREEN2 = VIEWSCREEN2__STATIC;
int32_t VIEWSCREENBROKE = VIEWSCREENBROKE__STATIC;
int32_t VIEWSCREEN = VIEWSCREEN__STATIC;
int32_t GLASS = GLASS__STATIC;
int32_t GLASS2 = GLASS2__STATIC;
int32_t STAINGLASS1 = STAINGLASS1__STATIC;
int32_t MASKWALL5 = MASKWALL5__STATIC;
int32_t SATELITE = SATELITE__STATIC;
int32_t FUELPOD = FUELPOD__STATIC;
int32_t SLIMEPIPE = SLIMEPIPE__STATIC;
int32_t CRACK1 = CRACK1__STATIC;
int32_t CRACK2 = CRACK2__STATIC;
int32_t CRACK3 = CRACK3__STATIC;
int32_t CRACK4 = CRACK4__STATIC;
int32_t FOOTPRINTS = FOOTPRINTS__STATIC;
int32_t DOMELITE = DOMELITE__STATIC;
int32_t CAMERAPOLE = CAMERAPOLE__STATIC;
int32_t CHAIR1 = CHAIR1__STATIC;
int32_t CHAIR2 = CHAIR2__STATIC;
int32_t BROKENCHAIR = BROKENCHAIR__STATIC;
int32_t MIRROR = MIRROR__STATIC;
int32_t WATERFOUNTAIN = WATERFOUNTAIN__STATIC;
int32_t WATERFOUNTAINBROKE = WATERFOUNTAINBROKE__STATIC;
int32_t FEMMAG1 = FEMMAG1__STATIC;
int32_t TOILET = TOILET__STATIC;
int32_t STALL = STALL__STATIC;
int32_t STALLBROKE = STALLBROKE__STATIC;
int32_t FEMMAG2 = FEMMAG2__STATIC;
int32_t REACTOR2 = REACTOR2__STATIC;
int32_t REACTOR2BURNT = REACTOR2BURNT__STATIC;
int32_t REACTOR2SPARK = REACTOR2SPARK__STATIC;
int32_t GRATE1 = GRATE1__STATIC;
int32_t BGRATE1 = BGRATE1__STATIC;
int32_t SOLARPANNEL = SOLARPANNEL__STATIC;
int32_t NAKED1 = NAKED1__STATIC;
int32_t ANTENNA = ANTENNA__STATIC;
int32_t MASKWALL12 = MASKWALL12__STATIC;
int32_t TOILETBROKE = TOILETBROKE__STATIC;
int32_t PIPE2 = PIPE2__STATIC;
int32_t PIPE1B = PIPE1B__STATIC;
int32_t PIPE3 = PIPE3__STATIC;
int32_t PIPE1 = PIPE1__STATIC;
int32_t CAMERA1 = CAMERA1__STATIC;
int32_t BRICK = BRICK__STATIC;
int32_t SPLINTERWOOD = SPLINTERWOOD__STATIC;
int32_t PIPE2B = PIPE2B__STATIC;
int32_t BOLT1 = BOLT1__STATIC;
int32_t W_NUMBERS = W_NUMBERS__STATIC;
int32_t WATERDRIP = WATERDRIP__STATIC;
int32_t WATERBUBBLE = WATERBUBBLE__STATIC;
int32_t WATERBUBBLEMAKER = WATERBUBBLEMAKER__STATIC;
int32_t W_FORCEFIELD = W_FORCEFIELD__STATIC;
int32_t VACUUM = VACUUM__STATIC;
int32_t FOOTPRINTS2 = FOOTPRINTS2__STATIC;
int32_t FOOTPRINTS3 = FOOTPRINTS3__STATIC;
int32_t FOOTPRINTS4 = FOOTPRINTS4__STATIC;
int32_t EGG = EGG__STATIC;
int32_t SCALE = SCALE__STATIC;
int32_t CHAIR3 = CHAIR3__STATIC;
int32_t CAMERALIGHT = CAMERALIGHT__STATIC;
int32_t MOVIECAMERA = MOVIECAMERA__STATIC;
int32_t IVUNIT = IVUNIT__STATIC;
int32_t POT1 = POT1__STATIC;
int32_t POT2 = POT2__STATIC;
int32_t POT3 = POT3__STATIC;
int32_t PIPE3B = PIPE3B__STATIC;
int32_t WALLLIGHT3 = WALLLIGHT3__STATIC;
int32_t WALLLIGHTBUST3 = WALLLIGHTBUST3__STATIC;
int32_t WALLLIGHT1 = WALLLIGHT1__STATIC;
int32_t WALLLIGHTBUST1 = WALLLIGHTBUST1__STATIC;
int32_t WALLLIGHT2 = WALLLIGHT2__STATIC;
int32_t WALLLIGHTBUST2 = WALLLIGHTBUST2__STATIC;
int32_t LIGHTSWITCH2 = LIGHTSWITCH2__STATIC;
int32_t WAITTOBESEATED = WAITTOBESEATED__STATIC;
int32_t DOORTILE14 = DOORTILE14__STATIC;
int32_t STATUE = STATUE__STATIC;
int32_t MIKE = MIKE__STATIC;
int32_t VASE = VASE__STATIC;
int32_t SUSHIPLATE1 = SUSHIPLATE1__STATIC;
int32_t SUSHIPLATE2 = SUSHIPLATE2__STATIC;
int32_t SUSHIPLATE3 = SUSHIPLATE3__STATIC;
int32_t SUSHIPLATE4 = SUSHIPLATE4__STATIC;
int32_t DOORTILE16 = DOORTILE16__STATIC;
int32_t SUSHIPLATE5 = SUSHIPLATE5__STATIC;
int32_t OJ = OJ__STATIC;
int32_t MASKWALL13 = MASKWALL13__STATIC;
int32_t HURTRAIL = HURTRAIL__STATIC;
int32_t POWERSWITCH1 = POWERSWITCH1__STATIC;
int32_t LOCKSWITCH1 = LOCKSWITCH1__STATIC;
int32_t POWERSWITCH2 = POWERSWITCH2__STATIC;
int32_t ATM = ATM__STATIC;
int32_t STATUEFLASH = STATUEFLASH__STATIC;
int32_t ATMBROKE = ATMBROKE__STATIC;
int32_t BIGHOLE2 = BIGHOLE2__STATIC;
int32_t STRIPEBALL = STRIPEBALL__STATIC;
int32_t QUEBALL = QUEBALL__STATIC;
int32_t POCKET = POCKET__STATIC;
int32_t WOODENHORSE = WOODENHORSE__STATIC;
int32_t TREE1 = TREE1__STATIC;
int32_t TREE2 = TREE2__STATIC;
int32_t CACTUS = CACTUS__STATIC;
int32_t MASKWALL2 = MASKWALL2__STATIC;
int32_t MASKWALL3 = MASKWALL3__STATIC;
int32_t MASKWALL4 = MASKWALL4__STATIC;
int32_t FIREEXT = FIREEXT__STATIC;
int32_t TOILETWATER = TOILETWATER__STATIC;
int32_t NEON1 = NEON1__STATIC;
int32_t NEON2 = NEON2__STATIC;
int32_t CACTUSBROKE = CACTUSBROKE__STATIC;
int32_t BOUNCEMINE = BOUNCEMINE__STATIC;
int32_t BROKEFIREHYDRENT = BROKEFIREHYDRENT__STATIC;
int32_t BOX = BOX__STATIC;
int32_t BULLETHOLE = BULLETHOLE__STATIC;
int32_t BOTTLE1 = BOTTLE1__STATIC;
int32_t BOTTLE2 = BOTTLE2__STATIC;
int32_t BOTTLE3 = BOTTLE3__STATIC;
int32_t BOTTLE4 = BOTTLE4__STATIC;
int32_t FEMPIC5 = FEMPIC5__STATIC;
int32_t FEMPIC6 = FEMPIC6__STATIC;
int32_t FEMPIC7 = FEMPIC7__STATIC;
int32_t HYDROPLANT = HYDROPLANT__STATIC;
int32_t OCEANSPRITE1 = OCEANSPRITE1__STATIC;
int32_t OCEANSPRITE2 = OCEANSPRITE2__STATIC;
int32_t OCEANSPRITE3 = OCEANSPRITE3__STATIC;
int32_t OCEANSPRITE4 = OCEANSPRITE4__STATIC;
int32_t OCEANSPRITE5 = OCEANSPRITE5__STATIC;
int32_t GENERICPOLE = GENERICPOLE__STATIC;
int32_t CONE = CONE__STATIC;
int32_t HANGLIGHT = HANGLIGHT__STATIC;
int32_t HYDRENT = HYDRENT__STATIC;
int32_t MASKWALL14 = MASKWALL14__STATIC;
int32_t TIRE = TIRE__STATIC;
int32_t PIPE5 = PIPE5__STATIC;
int32_t PIPE6 = PIPE6__STATIC;
int32_t PIPE4 = PIPE4__STATIC;
int32_t PIPE4B = PIPE4B__STATIC;
int32_t BROKEHYDROPLANT = BROKEHYDROPLANT__STATIC;
int32_t PIPE5B = PIPE5B__STATIC;
int32_t NEON3 = NEON3__STATIC;
int32_t NEON4 = NEON4__STATIC;
int32_t NEON5 = NEON5__STATIC;
int32_t BOTTLE5 = BOTTLE5__STATIC;
int32_t BOTTLE6 = BOTTLE6__STATIC;
int32_t BOTTLE8 = BOTTLE8__STATIC;
int32_t SPOTLITE = SPOTLITE__STATIC;
int32_t HANGOOZ = HANGOOZ__STATIC;
int32_t MASKWALL15 = MASKWALL15__STATIC;
int32_t BOTTLE7 = BOTTLE7__STATIC;
int32_t HORSEONSIDE = HORSEONSIDE__STATIC;
int32_t GLASSPIECES = GLASSPIECES__STATIC;
int32_t HORSELITE = HORSELITE__STATIC;
int32_t DONUTS = DONUTS__STATIC;
int32_t NEON6 = NEON6__STATIC;
int32_t MASKWALL6 = MASKWALL6__STATIC;
int32_t CLOCK = CLOCK__STATIC;
int32_t RUBBERCAN = RUBBERCAN__STATIC;
int32_t BROKENCLOCK = BROKENCLOCK__STATIC;
int32_t PLUG = PLUG__STATIC;
int32_t OOZFILTER = OOZFILTER__STATIC;
int32_t FLOORPLASMA = FLOORPLASMA__STATIC;
int32_t REACTOR = REACTOR__STATIC;
int32_t REACTORSPARK = REACTORSPARK__STATIC;
int32_t REACTORBURNT = REACTORBURNT__STATIC;
int32_t DOORTILE15 = DOORTILE15__STATIC;
int32_t HANDSWITCH = HANDSWITCH__STATIC;
int32_t CIRCLEPANNEL = CIRCLEPANNEL__STATIC;
int32_t CIRCLEPANNELBROKE = CIRCLEPANNELBROKE__STATIC;
int32_t PULLSWITCH = PULLSWITCH__STATIC;
int32_t MASKWALL8 = MASKWALL8__STATIC;
int32_t BIGHOLE = BIGHOLE__STATIC;
int32_t ALIENSWITCH = ALIENSWITCH__STATIC;
int32_t DOORTILE21 = DOORTILE21__STATIC;
int32_t HANDPRINTSWITCH = HANDPRINTSWITCH__STATIC;
int32_t BOTTLE10 = BOTTLE10__STATIC;
int32_t BOTTLE11 = BOTTLE11__STATIC;
int32_t BOTTLE12 = BOTTLE12__STATIC;
int32_t BOTTLE13 = BOTTLE13__STATIC;
int32_t BOTTLE14 = BOTTLE14__STATIC;
int32_t BOTTLE15 = BOTTLE15__STATIC;
int32_t BOTTLE16 = BOTTLE16__STATIC;
int32_t BOTTLE17 = BOTTLE17__STATIC;
int32_t BOTTLE18 = BOTTLE18__STATIC;
int32_t BOTTLE19 = BOTTLE19__STATIC;
int32_t DOORTILE17 = DOORTILE17__STATIC;
int32_t MASKWALL7 = MASKWALL7__STATIC;
int32_t JAILBARBREAK = JAILBARBREAK__STATIC;
int32_t DOORTILE11 = DOORTILE11__STATIC;
int32_t DOORTILE12 = DOORTILE12__STATIC;
int32_t VENDMACHINE = VENDMACHINE__STATIC;
int32_t VENDMACHINEBROKE = VENDMACHINEBROKE__STATIC;
int32_t COLAMACHINE = COLAMACHINE__STATIC;
int32_t COLAMACHINEBROKE = COLAMACHINEBROKE__STATIC;
int32_t CRANEPOLE = CRANEPOLE__STATIC;
int32_t CRANE = CRANE__STATIC;
int32_t BARBROKE = BARBROKE__STATIC;
int32_t BLOODPOOL = BLOODPOOL__STATIC;
int32_t NUKEBARREL = NUKEBARREL__STATIC;
int32_t NUKEBARRELDENTED = NUKEBARRELDENTED__STATIC;
int32_t NUKEBARRELLEAKED = NUKEBARRELLEAKED__STATIC;
int32_t CANWITHSOMETHING = CANWITHSOMETHING__STATIC;
int32_t MONEY = MONEY__STATIC;
int32_t BANNER = BANNER__STATIC;
int32_t EXPLODINGBARREL = EXPLODINGBARREL__STATIC;
int32_t EXPLODINGBARREL2 = EXPLODINGBARREL2__STATIC;
int32_t FIREBARREL = FIREBARREL__STATIC;
int32_t SEENINE = SEENINE__STATIC;
int32_t SEENINEDEAD = SEENINEDEAD__STATIC;
int32_t STEAM = STEAM__STATIC;
int32_t CEILINGSTEAM = CEILINGSTEAM__STATIC;
int32_t PIPE6B = PIPE6B__STATIC;
int32_t TRANSPORTERBEAM = TRANSPORTERBEAM__STATIC;
int32_t RAT = RAT__STATIC;
int32_t TRASH = TRASH__STATIC;
int32_t FEMPIC1 = FEMPIC1__STATIC;
int32_t FEMPIC2 = FEMPIC2__STATIC;
int32_t BLANKSCREEN = BLANKSCREEN__STATIC;
int32_t PODFEM1 = PODFEM1__STATIC;
int32_t FEMPIC3 = FEMPIC3__STATIC;
int32_t FEMPIC4 = FEMPIC4__STATIC;
int32_t FEM1 = FEM1__STATIC;
int32_t FEM2 = FEM2__STATIC;
int32_t FEM3 = FEM3__STATIC;
int32_t FEM5 = FEM5__STATIC;
int32_t BLOODYPOLE = BLOODYPOLE__STATIC;
int32_t FEM4 = FEM4__STATIC;
int32_t FEM6 = FEM6__STATIC;
int32_t FEM6PAD = FEM6PAD__STATIC;
int32_t FEM8 = FEM8__STATIC;
int32_t HELECOPT = HELECOPT__STATIC;
int32_t FETUSJIB = FETUSJIB__STATIC;
int32_t HOLODUKE = HOLODUKE__STATIC;
int32_t SPACEMARINE = SPACEMARINE__STATIC;
int32_t INDY = INDY__STATIC;
int32_t FETUS = FETUS__STATIC;
int32_t FETUSBROKE = FETUSBROKE__STATIC;
int32_t MONK = MONK__STATIC;
int32_t LUKE = LUKE__STATIC;
int32_t COOLEXPLOSION1 = COOLEXPLOSION1__STATIC;
int32_t WATERSPLASH2 = WATERSPLASH2__STATIC;
int32_t FIREVASE = FIREVASE__STATIC;
int32_t SCRATCH = SCRATCH__STATIC;
int32_t FEM7 = FEM7__STATIC;
int32_t APLAYERTOP = APLAYERTOP__STATIC;
int32_t APLAYER = APLAYER__STATIC;
int32_t PLAYERONWATER = PLAYERONWATER__STATIC;
int32_t DUKELYINGDEAD = DUKELYINGDEAD__STATIC;
int32_t DUKETORSO = DUKETORSO__STATIC;
int32_t DUKEGUN = DUKEGUN__STATIC;
int32_t DUKELEG = DUKELEG__STATIC;
int32_t SHARK = SHARK__STATIC;
int32_t BLOOD = BLOOD__STATIC;
int32_t FIRELASER = FIRELASER__STATIC;
int32_t TRANSPORTERSTAR = TRANSPORTERSTAR__STATIC;
int32_t SPIT = SPIT__STATIC;
int32_t LOOGIE = LOOGIE__STATIC;
int32_t FIST = FIST__STATIC;
int32_t FREEZEBLAST = FREEZEBLAST__STATIC;
int32_t DEVISTATORBLAST = DEVISTATORBLAST__STATIC;
int32_t SHRINKSPARK = SHRINKSPARK__STATIC;
int32_t TONGUE = TONGUE__STATIC;
int32_t MORTER = MORTER__STATIC;
int32_t SHRINKEREXPLOSION = SHRINKEREXPLOSION__STATIC;
int32_t RADIUSEXPLOSION = RADIUSEXPLOSION__STATIC;
int32_t FORCERIPPLE = FORCERIPPLE__STATIC;
int32_t LIZTROOP = LIZTROOP__STATIC;
int32_t LIZTROOPRUNNING = LIZTROOPRUNNING__STATIC;
int32_t LIZTROOPSTAYPUT = LIZTROOPSTAYPUT__STATIC;
int32_t LIZTOP = LIZTOP__STATIC;
int32_t LIZTROOPSHOOT = LIZTROOPSHOOT__STATIC;
int32_t LIZTROOPJETPACK = LIZTROOPJETPACK__STATIC;
int32_t LIZTROOPDSPRITE = LIZTROOPDSPRITE__STATIC;
int32_t LIZTROOPONTOILET = LIZTROOPONTOILET__STATIC;
int32_t LIZTROOPJUSTSIT = LIZTROOPJUSTSIT__STATIC;
int32_t LIZTROOPDUCKING = LIZTROOPDUCKING__STATIC;
int32_t HEADJIB1 = HEADJIB1__STATIC;
int32_t ARMJIB1 = ARMJIB1__STATIC;
int32_t LEGJIB1 = LEGJIB1__STATIC;
int32_t CANNONBALL = CANNONBALL__STATIC;
int32_t OCTABRAIN = OCTABRAIN__STATIC;
int32_t OCTABRAINSTAYPUT = OCTABRAINSTAYPUT__STATIC;
int32_t OCTATOP = OCTATOP__STATIC;
int32_t OCTADEADSPRITE = OCTADEADSPRITE__STATIC;
int32_t INNERJAW = INNERJAW__STATIC;
int32_t DRONE = DRONE__STATIC;
int32_t EXPLOSION2 = EXPLOSION2__STATIC;
int32_t COMMANDER = COMMANDER__STATIC;
int32_t COMMANDERSTAYPUT = COMMANDERSTAYPUT__STATIC;
int32_t RECON = RECON__STATIC;
int32_t TANK = TANK__STATIC;
int32_t PIGCOP = PIGCOP__STATIC;
int32_t PIGCOPSTAYPUT = PIGCOPSTAYPUT__STATIC;
int32_t PIGCOPDIVE = PIGCOPDIVE__STATIC;
int32_t PIGCOPDEADSPRITE = PIGCOPDEADSPRITE__STATIC;
int32_t PIGTOP = PIGTOP__STATIC;
int32_t LIZMAN = LIZMAN__STATIC;
int32_t LIZMANSTAYPUT = LIZMANSTAYPUT__STATIC;
int32_t LIZMANSPITTING = LIZMANSPITTING__STATIC;
int32_t LIZMANFEEDING = LIZMANFEEDING__STATIC;
int32_t LIZMANJUMP = LIZMANJUMP__STATIC;
int32_t LIZMANDEADSPRITE = LIZMANDEADSPRITE__STATIC;
int32_t FECES = FECES__STATIC;
int32_t LIZMANHEAD1 = LIZMANHEAD1__STATIC;
int32_t LIZMANARM1 = LIZMANARM1__STATIC;
int32_t LIZMANLEG1 = LIZMANLEG1__STATIC;
int32_t EXPLOSION2BOT = EXPLOSION2BOT__STATIC;
int32_t USERWEAPON = USERWEAPON__STATIC;
int32_t HEADERBAR = HEADERBAR__STATIC;
int32_t JIBS1 = JIBS1__STATIC;
int32_t JIBS2 = JIBS2__STATIC;
int32_t JIBS3 = JIBS3__STATIC;
int32_t JIBS4 = JIBS4__STATIC;
int32_t JIBS5 = JIBS5__STATIC;
int32_t BURNING = BURNING__STATIC;
int32_t FIRE = FIRE__STATIC;
int32_t JIBS6 = JIBS6__STATIC;
int32_t BLOODSPLAT1 = BLOODSPLAT1__STATIC;
int32_t BLOODSPLAT3 = BLOODSPLAT3__STATIC;
int32_t BLOODSPLAT2 = BLOODSPLAT2__STATIC;
int32_t BLOODSPLAT4 = BLOODSPLAT4__STATIC;
int32_t OOZ = OOZ__STATIC;
int32_t OOZ2 = OOZ2__STATIC;
int32_t WALLBLOOD1 = WALLBLOOD1__STATIC;
int32_t WALLBLOOD2 = WALLBLOOD2__STATIC;
int32_t WALLBLOOD3 = WALLBLOOD3__STATIC;
int32_t WALLBLOOD4 = WALLBLOOD4__STATIC;
int32_t WALLBLOOD5 = WALLBLOOD5__STATIC;
int32_t WALLBLOOD6 = WALLBLOOD6__STATIC;
int32_t WALLBLOOD7 = WALLBLOOD7__STATIC;
int32_t WALLBLOOD8 = WALLBLOOD8__STATIC;
int32_t BURNING2 = BURNING2__STATIC;
int32_t FIRE2 = FIRE2__STATIC;
int32_t CRACKKNUCKLES = CRACKKNUCKLES__STATIC;
int32_t SMALLSMOKE = SMALLSMOKE__STATIC;
int32_t SMALLSMOKEMAKER = SMALLSMOKEMAKER__STATIC;
int32_t FLOORFLAME = FLOORFLAME__STATIC;
int32_t ROTATEGUN = ROTATEGUN__STATIC;
int32_t GREENSLIME = GREENSLIME__STATIC;
int32_t WATERDRIPSPLASH = WATERDRIPSPLASH__STATIC;
int32_t SCRAP6 = SCRAP6__STATIC;
int32_t SCRAP1 = SCRAP1__STATIC;
int32_t SCRAP2 = SCRAP2__STATIC;
int32_t SCRAP3 = SCRAP3__STATIC;
int32_t SCRAP4 = SCRAP4__STATIC;
int32_t SCRAP5 = SCRAP5__STATIC;
int32_t ORGANTIC = ORGANTIC__STATIC;
int32_t BETAVERSION = BETAVERSION__STATIC;
int32_t PLAYERISHERE = PLAYERISHERE__STATIC;
int32_t PLAYERWASHERE = PLAYERWASHERE__STATIC;
int32_t SELECTDIR = SELECTDIR__STATIC;
int32_t F1HELP = F1HELP__STATIC;
int32_t NOTCHON = NOTCHON__STATIC;
int32_t NOTCHOFF = NOTCHOFF__STATIC;
int32_t GROWSPARK = GROWSPARK__STATIC;
int32_t DUKEICON = DUKEICON__STATIC;
int32_t BADGUYICON = BADGUYICON__STATIC;
int32_t FOODICON = FOODICON__STATIC;
int32_t GETICON = GETICON__STATIC;
int32_t MENUSCREEN = MENUSCREEN__STATIC;
int32_t MENUBAR = MENUBAR__STATIC;
int32_t KILLSICON = KILLSICON__STATIC;
int32_t FIRSTAID_ICON = FIRSTAID_ICON__STATIC;
int32_t HEAT_ICON = HEAT_ICON__STATIC;
int32_t BOTTOMSTATUSBAR = BOTTOMSTATUSBAR__STATIC;
int32_t BOOT_ICON = BOOT_ICON__STATIC;
int32_t FRAGBAR = FRAGBAR__STATIC;
int32_t JETPACK_ICON = JETPACK_ICON__STATIC;
int32_t AIRTANK_ICON = AIRTANK_ICON__STATIC;
int32_t STEROIDS_ICON = STEROIDS_ICON__STATIC;
int32_t HOLODUKE_ICON = HOLODUKE_ICON__STATIC;
int32_t ACCESS_ICON = ACCESS_ICON__STATIC;
int32_t DIGITALNUM = DIGITALNUM__STATIC;
int32_t DUKECAR = DUKECAR__STATIC;
int32_t CAMCORNER = CAMCORNER__STATIC;
int32_t CAMLIGHT = CAMLIGHT__STATIC;
int32_t LOGO = LOGO__STATIC;
int32_t TITLE = TITLE__STATIC;
int32_t NUKEWARNINGICON = NUKEWARNINGICON__STATIC;
int32_t MOUSECURSOR = MOUSECURSOR__STATIC;
int32_t SLIDEBAR = SLIDEBAR__STATIC;
int32_t DREALMS = DREALMS__STATIC;
int32_t BETASCREEN = BETASCREEN__STATIC;
int32_t WINDOWBORDER1 = WINDOWBORDER1__STATIC;
int32_t TEXTBOX = TEXTBOX__STATIC;
int32_t WINDOWBORDER2 = WINDOWBORDER2__STATIC;
int32_t DUKENUKEM = DUKENUKEM__STATIC;
int32_t THREEDEE = THREEDEE__STATIC;
int32_t INGAMEDUKETHREEDEE = INGAMEDUKETHREEDEE__STATIC;
int32_t TENSCREEN = TENSCREEN__STATIC;
int32_t PLUTOPAKSPRITE = PLUTOPAKSPRITE__STATIC;
int32_t DEVISTATOR = DEVISTATOR__STATIC;
int32_t KNEE = KNEE__STATIC;
int32_t CROSSHAIR = CROSSHAIR__STATIC;
int32_t FIRSTGUN = FIRSTGUN__STATIC;
int32_t FIRSTGUNRELOAD = FIRSTGUNRELOAD__STATIC;
int32_t FALLINGCLIP = FALLINGCLIP__STATIC;
int32_t CLIPINHAND = CLIPINHAND__STATIC;
int32_t HAND = HAND__STATIC;
int32_t SHELL = SHELL__STATIC;
int32_t SHOTGUNSHELL = SHOTGUNSHELL__STATIC;
int32_t CHAINGUN = CHAINGUN__STATIC;
int32_t RPGGUN = RPGGUN__STATIC;
int32_t RPGMUZZLEFLASH = RPGMUZZLEFLASH__STATIC;
int32_t FREEZE = FREEZE__STATIC;
int32_t CATLITE = CATLITE__STATIC;
int32_t SHRINKER = SHRINKER__STATIC;
int32_t HANDHOLDINGLASER = HANDHOLDINGLASER__STATIC;
int32_t TRIPBOMB = TRIPBOMB__STATIC;
int32_t LASERLINE = LASERLINE__STATIC;
int32_t HANDHOLDINGACCESS = HANDHOLDINGACCESS__STATIC;
int32_t HANDREMOTE = HANDREMOTE__STATIC;
int32_t HANDTHROW = HANDTHROW__STATIC;
int32_t TIP = TIP__STATIC;
int32_t GLAIR = GLAIR__STATIC;
int32_t SCUBAMASK = SCUBAMASK__STATIC;
int32_t SPACEMASK = SPACEMASK__STATIC;
int32_t FORCESPHERE = FORCESPHERE__STATIC;
int32_t SHOTSPARK1 = SHOTSPARK1__STATIC;
int32_t RPG = RPG__STATIC;
int32_t LASERSITE = LASERSITE__STATIC;
int32_t SHOTGUN = SHOTGUN__STATIC;
int32_t BOSS1 = BOSS1__STATIC;
int32_t BOSS1STAYPUT = BOSS1STAYPUT__STATIC;
int32_t BOSS1SHOOT = BOSS1SHOOT__STATIC;
int32_t BOSS1LOB = BOSS1LOB__STATIC;
int32_t BOSSTOP = BOSSTOP__STATIC;
int32_t BOSS2 = BOSS2__STATIC;
int32_t BOSS3 = BOSS3__STATIC;
int32_t SPINNINGNUKEICON = SPINNINGNUKEICON__STATIC;
int32_t BIGFNTCURSOR = BIGFNTCURSOR__STATIC;
int32_t SMALLFNTCURSOR = SMALLFNTCURSOR__STATIC;
int32_t STARTALPHANUM = STARTALPHANUM__STATIC;
int32_t ENDALPHANUM = ENDALPHANUM__STATIC;
int32_t BIGALPHANUM = BIGALPHANUM__STATIC;
int32_t BIGPERIOD = BIGPERIOD__STATIC;
int32_t BIGCOMMA = BIGCOMMA__STATIC;
int32_t BIGX = BIGX__STATIC;
int32_t BIGQ = BIGQ__STATIC;
int32_t BIGSEMI = BIGSEMI__STATIC;
int32_t BIGCOLIN = BIGCOLIN__STATIC;
int32_t THREEBYFIVE = THREEBYFIVE__STATIC;
int32_t BIGAPPOS = BIGAPPOS__STATIC;
int32_t BLANK = BLANK__STATIC;
int32_t MINIFONT = MINIFONT__STATIC;
int32_t BUTTON1 = BUTTON1__STATIC;
int32_t GLASS3 = GLASS3__STATIC;
int32_t RESPAWNMARKERRED = RESPAWNMARKERRED__STATIC;
int32_t RESPAWNMARKERYELLOW = RESPAWNMARKERYELLOW__STATIC;
int32_t RESPAWNMARKERGREEN = RESPAWNMARKERGREEN__STATIC;
int32_t BONUSSCREEN = BONUSSCREEN__STATIC;
int32_t VIEWBORDER = VIEWBORDER__STATIC;
int32_t VICTORY1 = VICTORY1__STATIC;
int32_t ORDERING = ORDERING__STATIC;
int32_t TEXTSTORY = TEXTSTORY__STATIC;
int32_t LOADSCREEN = LOADSCREEN__STATIC;
int32_t BORNTOBEWILDSCREEN = BORNTOBEWILDSCREEN__STATIC;
int32_t BLIMP = BLIMP__STATIC;
int32_t FEM9 = FEM9__STATIC;
int32_t FOOTPRINT = FOOTPRINT__STATIC;
int32_t FRAMEEFFECT1_13 = FRAMEEFFECT1_13__STATIC;
int32_t POOP = POOP__STATIC;
int32_t FRAMEEFFECT1 = FRAMEEFFECT1__STATIC;
int32_t PANNEL3 = PANNEL3__STATIC;
int32_t SCREENBREAK14 = SCREENBREAK14__STATIC;
int32_t SCREENBREAK15 = SCREENBREAK15__STATIC;
int32_t SCREENBREAK19 = SCREENBREAK19__STATIC;
int32_t SCREENBREAK16 = SCREENBREAK16__STATIC;
int32_t SCREENBREAK17 = SCREENBREAK17__STATIC;
int32_t SCREENBREAK18 = SCREENBREAK18__STATIC;
int32_t W_TECHWALL11 = W_TECHWALL11__STATIC;
int32_t W_TECHWALL12 = W_TECHWALL12__STATIC;
int32_t W_TECHWALL13 = W_TECHWALL13__STATIC;
int32_t W_TECHWALL14 = W_TECHWALL14__STATIC;
int32_t W_TECHWALL5 = W_TECHWALL5__STATIC;
int32_t W_TECHWALL6 = W_TECHWALL6__STATIC;
int32_t W_TECHWALL7 = W_TECHWALL7__STATIC;
int32_t W_TECHWALL8 = W_TECHWALL8__STATIC;
int32_t W_TECHWALL9 = W_TECHWALL9__STATIC;
int32_t BPANNEL3 = BPANNEL3__STATIC;
int32_t W_HITTECHWALL16 = W_HITTECHWALL16__STATIC;
int32_t W_HITTECHWALL10 = W_HITTECHWALL10__STATIC;
int32_t W_HITTECHWALL15 = W_HITTECHWALL15__STATIC;
int32_t W_MILKSHELF = W_MILKSHELF__STATIC;
int32_t W_MILKSHELFBROKE = W_MILKSHELFBROKE__STATIC;
int32_t PURPLELAVA = PURPLELAVA__STATIC;
int32_t LAVABUBBLE = LAVABUBBLE__STATIC;
int32_t DUKECUTOUT = DUKECUTOUT__STATIC;
int32_t TARGET = TARGET__STATIC;
int32_t GUNPOWDERBARREL = GUNPOWDERBARREL__STATIC;
int32_t DUCK = DUCK__STATIC;
int32_t HATRACK = HATRACK__STATIC;
int32_t DESKLAMP = DESKLAMP__STATIC;
int32_t COFFEEMACHINE = COFFEEMACHINE__STATIC;
int32_t CUPS = CUPS__STATIC;
int32_t GAVALS = GAVALS__STATIC;
int32_t GAVALS2 = GAVALS2__STATIC;
int32_t POLICELIGHTPOLE = POLICELIGHTPOLE__STATIC;
int32_t FLOORBASKET = FLOORBASKET__STATIC;
int32_t PUKE = PUKE__STATIC;
int32_t DOORTILE23 = DOORTILE23__STATIC;
int32_t TOPSECRET = TOPSECRET__STATIC;
int32_t SPEAKER = SPEAKER__STATIC;
int32_t TEDDYBEAR = TEDDYBEAR__STATIC;
int32_t ROBOTDOG = ROBOTDOG__STATIC;
int32_t ROBOTPIRATE = ROBOTPIRATE__STATIC;
int32_t ROBOTMOUSE = ROBOTMOUSE__STATIC;
int32_t MAIL = MAIL__STATIC;
int32_t MAILBAG = MAILBAG__STATIC;
int32_t HOTMEAT = HOTMEAT__STATIC;
int32_t COFFEEMUG = COFFEEMUG__STATIC;
int32_t DONUTS2 = DONUTS2__STATIC;
int32_t TRIPODCAMERA = TRIPODCAMERA__STATIC;
int32_t METER = METER__STATIC;
int32_t DESKPHONE = DESKPHONE__STATIC;
int32_t GUMBALLMACHINE = GUMBALLMACHINE__STATIC;
int32_t GUMBALLMACHINEBROKE = GUMBALLMACHINEBROKE__STATIC;
int32_t PAPER = PAPER__STATIC;
int32_t MACE = MACE__STATIC;
int32_t GENERICPOLE2 = GENERICPOLE2__STATIC;
int32_t XXXSTACY = XXXSTACY__STATIC;
int32_t WETFLOOR = WETFLOOR__STATIC;
int32_t BROOM = BROOM__STATIC;
int32_t MOP = MOP__STATIC;
int32_t LETTER = LETTER__STATIC;
int32_t PIRATE1A = PIRATE1A__STATIC;
int32_t PIRATE4A = PIRATE4A__STATIC;
int32_t PIRATE2A = PIRATE2A__STATIC;
int32_t PIRATE5A = PIRATE5A__STATIC;
int32_t PIRATE3A = PIRATE3A__STATIC;
int32_t PIRATE6A = PIRATE6A__STATIC;
int32_t PIRATEHALF = PIRATEHALF__STATIC;
int32_t CHESTOFGOLD = CHESTOFGOLD__STATIC;
int32_t SIDEBOLT1 = SIDEBOLT1__STATIC;
int32_t FOODOBJECT1 = FOODOBJECT1__STATIC;
int32_t FOODOBJECT2 = FOODOBJECT2__STATIC;
int32_t FOODOBJECT3 = FOODOBJECT3__STATIC;
int32_t FOODOBJECT4 = FOODOBJECT4__STATIC;
int32_t FOODOBJECT5 = FOODOBJECT5__STATIC;
int32_t FOODOBJECT6 = FOODOBJECT6__STATIC;
int32_t FOODOBJECT7 = FOODOBJECT7__STATIC;
int32_t FOODOBJECT8 = FOODOBJECT8__STATIC;
int32_t FOODOBJECT9 = FOODOBJECT9__STATIC;
int32_t FOODOBJECT10 = FOODOBJECT10__STATIC;
int32_t FOODOBJECT11 = FOODOBJECT11__STATIC;
int32_t FOODOBJECT12 = FOODOBJECT12__STATIC;
int32_t FOODOBJECT13 = FOODOBJECT13__STATIC;
int32_t FOODOBJECT14 = FOODOBJECT14__STATIC;
int32_t FOODOBJECT15 = FOODOBJECT15__STATIC;
int32_t FOODOBJECT16 = FOODOBJECT16__STATIC;
int32_t FOODOBJECT17 = FOODOBJECT17__STATIC;
int32_t FOODOBJECT18 = FOODOBJECT18__STATIC;
int32_t FOODOBJECT19 = FOODOBJECT19__STATIC;
int32_t FOODOBJECT20 = FOODOBJECT20__STATIC;
int32_t HEADLAMP = HEADLAMP__STATIC;
int32_t TAMPON = TAMPON__STATIC;
int32_t SKINNEDCHICKEN = SKINNEDCHICKEN__STATIC;
int32_t FEATHEREDCHICKEN = FEATHEREDCHICKEN__STATIC;
int32_t ROBOTDOG2 = ROBOTDOG2__STATIC;
int32_t JOLLYMEAL = JOLLYMEAL__STATIC;
int32_t DUKEBURGER = DUKEBURGER__STATIC;
int32_t SHOPPINGCART = SHOPPINGCART__STATIC;
int32_t CANWITHSOMETHING2 = CANWITHSOMETHING2__STATIC;
int32_t CANWITHSOMETHING3 = CANWITHSOMETHING3__STATIC;
int32_t CANWITHSOMETHING4 = CANWITHSOMETHING4__STATIC;
int32_t SNAKEP = SNAKEP__STATIC;
int32_t DOLPHIN1 = DOLPHIN1__STATIC;
int32_t DOLPHIN2 = DOLPHIN2__STATIC;
int32_t NEWBEAST = NEWBEAST__STATIC;
int32_t NEWBEASTSTAYPUT = NEWBEASTSTAYPUT__STATIC;
int32_t NEWBEASTJUMP = NEWBEASTJUMP__STATIC;
int32_t NEWBEASTHANG = NEWBEASTHANG__STATIC;
int32_t NEWBEASTHANGDEAD = NEWBEASTHANGDEAD__STATIC;
int32_t BOSS4 = BOSS4__STATIC;
int32_t BOSS4STAYPUT = BOSS4STAYPUT__STATIC;
int32_t FEM10 = FEM10__STATIC;
int32_t TOUGHGAL = TOUGHGAL__STATIC;
int32_t MAN = MAN__STATIC;
int32_t MAN2 = MAN2__STATIC;
int32_t WOMAN = WOMAN__STATIC;
int32_t PLEASEWAIT = PLEASEWAIT__STATIC;
int32_t NATURALLIGHTNING = NATURALLIGHTNING__STATIC;
int32_t WEATHERWARN = WEATHERWARN__STATIC;
int32_t DUKETAG = DUKETAG__STATIC;
int32_t SIGN1 = SIGN1__STATIC;
int32_t SIGN2 = SIGN2__STATIC;
int32_t JURYGUY = JURYGUY__STATIC;
int32_t RESERVEDSLOT1 = RESERVEDSLOT1__STATIC;
int32_t RESERVEDSLOT2 = RESERVEDSLOT2__STATIC;
int32_t RESERVEDSLOT3 = RESERVEDSLOT3__STATIC;
int32_t RESERVEDSLOT4 = RESERVEDSLOT4__STATIC;
int32_t RESERVEDSLOT5 = RESERVEDSLOT5__STATIC;
int32_t RESERVEDSLOT6 = RESERVEDSLOT6__STATIC;
int32_t RESERVEDSLOT7 = RESERVEDSLOT7__STATIC;
int32_t RESERVEDSLOT8 = RESERVEDSLOT8__STATIC;
int32_t RESERVEDSLOT9 = RESERVEDSLOT9__STATIC;
int32_t RESERVEDSLOT10 = RESERVEDSLOT10__STATIC;
int32_t RESERVEDSLOT11 = RESERVEDSLOT11__STATIC;
int32_t RESERVEDSLOT12 = RESERVEDSLOT12__STATIC;

void G_ProcessDynamicTileMapping(const char *szLabel, int32_t lValue)
{
    int32_t i;

    if ((unsigned)lValue >= MAXTILES || !szLabel)
        return;

    i = hash_find(&h_names,szLabel);
    if (i>=0)
        *(list[i].dynvalptr) = lValue;
}

void inithashnames(void)
{
    int32_t i;

    hash_init(&h_names);

    for (i=0; list[i].staticval; i++)
        hash_add(&h_names, list[i].str, i, 0);
}

void freehashnames(void)
{
    hash_free(&h_names);
}

void G_InitDynamicTiles(void)
{
    int32_t i;

    Bmemset(DynamicTileMap, 0, sizeof(DynamicTileMap));

    for (i=0; list[i].staticval; i++)
        DynamicTileMap[*(list[i].dynvalptr)] = list[i].staticval;

    BlimpSpawnSprites[0] = RPGSPRITE;
    BlimpSpawnSprites[1] = CHAINGUNSPRITE;
    BlimpSpawnSprites[2] = DEVISTATORAMMO;
    BlimpSpawnSprites[3] = RPGAMMO;
    BlimpSpawnSprites[4] = RPGAMMO;
    BlimpSpawnSprites[5] = JETPACK;
    BlimpSpawnSprites[6] = SHIELD;
    BlimpSpawnSprites[7] = FIRSTAID;
    BlimpSpawnSprites[8] = STEROIDS;
    BlimpSpawnSprites[9] = RPGAMMO;
    BlimpSpawnSprites[10] = RPGAMMO;
    BlimpSpawnSprites[11] = RPGSPRITE;
    BlimpSpawnSprites[12] = RPGAMMO;
    BlimpSpawnSprites[13] = FREEZESPRITE;
    BlimpSpawnSprites[14] = FREEZEAMMO;

    WeaponPickupSprites[0] = KNEE;
    WeaponPickupSprites[1] = FIRSTGUNSPRITE;
    WeaponPickupSprites[2] = SHOTGUNSPRITE;
    WeaponPickupSprites[3] = CHAINGUNSPRITE;
    WeaponPickupSprites[4] = RPGSPRITE;
    WeaponPickupSprites[5] = HEAVYHBOMB;
    WeaponPickupSprites[6] = SHRINKERSPRITE;
    WeaponPickupSprites[7] = DEVISTATORSPRITE;
    WeaponPickupSprites[8] = TRIPBOMBSPRITE;
    WeaponPickupSprites[9] = FREEZESPRITE;
    WeaponPickupSprites[10] = HEAVYHBOMB;
    WeaponPickupSprites[11] = SHRINKERSPRITE;
}
#endif
