//-------------------------------------------------------------------------
/*
Copyright (C) 2016 EDuke32 developers and contributors

This file is part of EDuke32.

EDuke32 is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License version 2
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
//-------------------------------------------------------------------------

#ifndef gamedef_h_
#define gamedef_h_

// #define CON_DISCRETE_VAR_ACCESS

#include "actors.h"
#include "build.h"  // hashtable_t
#include "cheats.h"
#include "common.h"  // tokenlist
#include "player.h"  // projectile_t

#ifdef __cplusplus
extern "C" {
#endif

enum
{
    LABEL_ACTION = 0x01,
    LABEL_ACTOR  = 0x02,
    LABEL_AI     = 0x04,
    LABEL_DEFINE = 0x08,
    LABEL_EVENT  = 0x10,
    LABEL_MOVE   = 0x20,
    LABEL_STATE  = 0x40,

    LABEL_ANY    = -1,
};

#define MAXLABELS 16384

#define LABEL_CHAR sizeof(uint8_t)
#define LABEL_SHORT sizeof(uint16_t)
#define LABEL_INT sizeof(uint32_t)
#define LABEL_UNSIGNED 8
#define LABEL_HASPARM2 16
#define LABEL_ISSTRING 32
#define LABEL_READFUNC 64
#define LABEL_WRITEFUNC 128

#define VM_IFELSE_MAGIC_BIT (1<<31)
#define VM_INSTMASK 0xfff
#define VM_VSIZE_LINE_END -1
#define VM_DECODE_INST(xxx) ((int)((xxx) & VM_INSTMASK))
#define VM_DECODE_LINE_NUMBER(xxx) ((int)((xxx&~VM_IFELSE_MAGIC_BIT) >> 12))
#define C_CUSTOMERROR(Text, ...)                                                               \
    do                                                                                         \
    {                                                                                          \
        C_ReportError(-1);                                                                     \
        LOG_F(ERROR, "%s:%d: " Text, g_scriptFileName, g_lineNumber, ##__VA_ARGS__); \
        g_errorCnt++;                                                                          \
    } while (0)

#define C_CUSTOMWARNING(Text, ...)                                                               \
    do                                                                                           \
    {                                                                                            \
        C_ReportError(-1);                                                                       \
        LOG_F(WARNING, "%s:%d: " Text, g_scriptFileName, g_lineNumber, ##__VA_ARGS__); \
        g_warningCnt++;                                                                          \
    } while (0)

struct vmofs
{
    char *fn;
    struct vmofs *next;
    int offset;
};

extern struct vmofs *vmoffset;

static inline const char *C_GetFileForOffset(int const offset)
{
    auto ofs = vmoffset;
    while (ofs->offset > offset)
        ofs = ofs->next;
    return ofs->fn;
}

#define VM_FILENAME(xxx) C_GetFileForOffset((xxx)-apScript)

extern intptr_t const * insptr;
void VM_ScriptInfo(intptr_t const * const ptr, int const range);

extern hashtable_t h_gamefuncs;

extern hashtable_t h_gamevars;
extern hashtable_t h_arrays;
extern hashtable_t h_labels;

extern int32_t g_aimAngleVarID;   // var ID of "AUTOAIMANGLE"
extern int32_t g_angRangeVarID;   // var ID of "ANGRANGE"
extern int32_t g_hitagVarID;      // var ID of "HITAG"
extern int32_t g_lotagVarID;      // var ID of "LOTAG"
extern int32_t g_returnVarID;     // var ID of "RETURN"
extern int32_t g_textureVarID;    // var ID of "TEXTURE"
extern int32_t g_thisActorVarID;  // var ID of "THISACTOR"
extern int32_t g_weaponVarID;     // var ID of "WEAPON"
extern int32_t g_worksLikeVarID;  // var ID of "WORKSLIKE"
extern int32_t g_zRangeVarID;     // var ID of "ZRANGE"

// KEEPINSYNC gamevars.cpp: "special vars for struct access"
enum QuickStructureAccess_t
{
    STRUCT_SPRITE,
    STRUCT_SPRITE_INTERNAL__,
    STRUCT_ACTOR_INTERNAL__,
    STRUCT_SPRITEEXT_INTERNAL__,
    STRUCT_SECTOR,
    STRUCT_SECTOR_INTERNAL__,
    STRUCT_WALL,
    STRUCT_WALL_INTERNAL__,
    STRUCT_PLAYER,
    STRUCT_PLAYER_INTERNAL__,
    STRUCT_ACTORVAR,
    STRUCT_PLAYERVAR,
    STRUCT_TSPR,
    STRUCT_PROJECTILE,
    STRUCT_THISPROJECTILE,
    STRUCT_USERDEF,
    STRUCT_INPUT,
    STRUCT_TILEDATA,
    STRUCT_PALDATA,
    NUMQUICKSTRUCTS,
};

extern int32_t g_structVarIDs;

#include "events_defs.h"
extern intptr_t apScriptEvents[MAXEVENTS];

extern char g_scriptFileName[BMAX_PATH];

extern const uint32_t CheatFunctionFlags[];
extern const uint8_t  CheatFunctionIDs[];

extern int32_t g_errorCnt;
extern int32_t g_lineNumber;
extern int32_t g_numXStrings;
extern int32_t g_scriptVersion;
extern int32_t g_totalLines;
extern int32_t g_warningCnt;
extern int32_t otherp;
extern uint8_t *bitptr;

extern const char *EventNames[MAXEVENTS];

extern intptr_t *g_scriptPtr;

typedef projectile_t defaultprojectile_t;

extern defaultprojectile_t DefaultProjectile;
int32_t C_AllocQuote(int32_t qnum);
void C_AllocProjectile(int32_t j);
void C_FreeProjectile(int32_t j);
void C_InitQuotes(void);
void C_InitProjectiles(void);

typedef struct {
    int spriteNum;
    int playerNum;
    int playerDist;
    int flags;

    union {
        spritetype * pSprite;
        uspritetype *pUSprite;
    };

    int32_t *     pData;
    DukePlayer_t *pPlayer;
    actor_t *     pActor;
} vmstate_t;

extern vmstate_t vm;

void G_DoGameStartup(const int32_t *params);
void C_DefineMusic(int volumeNum, int levelNum, const char *fileName);

void C_DefineVolumeFlags(int32_t vol, int32_t flags);
void C_UndefineVolume(int32_t vol);
void C_UndefineSkill(int32_t skill);
void C_UndefineLevel(int32_t vol, int32_t lev);
void C_ReportError(int error);
void C_Compile(const char *filenam);

extern int32_t g_tw;

typedef struct {
    const char* token;
    int32_t val;
} tokenmap_t;

extern const tokenmap_t iter_tokens[];

extern char const * VM_GetKeywordForID(int32_t id);

enum SystemString_t {
    STR_MAPNAME,
    STR_MAPFILENAME,
    STR_PLAYERNAME,
    STR_VERSION,
    STR_GAMETYPE,
    STR_VOLUMENAME,
    STR_YOURTIME,
    STR_PARTIME,
    STR_DESIGNERTIME,
    STR_BESTTIME,
    STR_USERMAPFILENAME,
    STR_REVISION,
};

enum ScriptError_t
{
    ERROR_ARRAYREADONLY,
    ERROR_EVENTONLY,
    ERROR_EXCEEDSMAXTILES,
    ERROR_EXPECTEDKEYWORD,
    ERROR_FOUNDWITHIN,
    ERROR_GAMEARRAYBNC,
    ERROR_GAMEARRAYBNO,
    ERROR_INVALIDARRAYWRITE,
    ERROR_ISAKEYWORD,
    ERROR_NOENDSWITCH,
    ERROR_NOTAGAMEARRAY,
    ERROR_NOTAGAMEDEF,
    ERROR_NOTAGAMEVAR,
    ERROR_NOTAMEMBER,
    ERROR_NOTTOPLEVEL,
    ERROR_PARAMUNDEFINED,
    ERROR_SYNTAXERROR,
    ERROR_TOOMANYLABELS,
    ERROR_VARREADONLY,
    ERROR_VARTYPEMISMATCH,
    WARNING_ARRAYMASKSKEYWORD,
    WARNING_BADGAMEVAR,
    WARNING_DUPLICATECASE,
    WARNING_DUPLICATEDEFINITION,
    WARNING_EVENTSYNC,
    WARNING_LABELSONLY,
    WARNING_NAMEMATCHESVAR,
    WARNING_VARMASKSKEYWORD,
};

enum PlayerLabel_t
{
    PLAYER_ZOOM,
    PLAYER_LOOGIEX,
    PLAYER_LOOGIEY,
    PLAYER_NUMLOOGS,
    PLAYER_LOOGCNT,
    PLAYER_POSX,
    PLAYER_POSY,
    PLAYER_POSZ,
    PLAYER_HORIZ,
    PLAYER_HORIZOFF,
    PLAYER_OHORIZ,
    PLAYER_OHORIZOFF,
    PLAYER_Q16HORIZ,
    PLAYER_Q16HORIZOFF,
    PLAYER_OQ16HORIZ,
    PLAYER_OQ16HORIZOFF,
    PLAYER_INVDISPTIME,
    PLAYER_BOBPOSX,
    PLAYER_BOBPOSY,
    PLAYER_OPOSX,
    PLAYER_OPOSY,
    PLAYER_OPOSZ,
    PLAYER_PYOFF,
    PLAYER_OPYOFF,
    PLAYER_POSXV,
    PLAYER_POSYV,
    PLAYER_POSZV,
    PLAYER_LAST_PISSED_TIME,
    PLAYER_TRUEFZ,
    PLAYER_TRUECZ,
    PLAYER_PLAYER_PAR,
    PLAYER_VISIBILITY,
    PLAYER_BOBCOUNTER,
    PLAYER_WEAPON_SWAY,
    PLAYER_PALS_TIME,
    PLAYER_CRACK_TIME,
    PLAYER_AIM_MODE,
    PLAYER_ANG,
    PLAYER_OANG,
    PLAYER_Q16ANG,
    PLAYER_OQ16ANG,
    PLAYER_ANGVEL,
    PLAYER_Q16ANGVEL,
    PLAYER_CURSECTNUM,
    PLAYER_LOOK_ANG,
    PLAYER_LAST_EXTRA,
    PLAYER_SUBWEAPON,
    PLAYER_AMMO_AMOUNT,
    PLAYER_WACKEDBYACTOR,
    PLAYER_FRAG,
    PLAYER_FRAGGEDSELF,
    PLAYER_CURR_WEAPON,
    PLAYER_LAST_WEAPON,
    PLAYER_TIPINCS,
    PLAYER_WANTWEAPONFIRE,
    PLAYER_HOLODUKE_AMOUNT,
    PLAYER_NEWOWNER,
    PLAYER_HURT_DELAY,
    PLAYER_HBOMB_HOLD_DELAY,
    PLAYER_JUMPING_COUNTER,
    PLAYER_AIRLEFT,
    PLAYER_KNEE_INCS,
    PLAYER_ACCESS_INCS,
    PLAYER_FTA,
    PLAYER_FTQ,
    PLAYER_ACCESS_WALLNUM,
    PLAYER_ACCESS_SPRITENUM,
    PLAYER_KICKBACK_PIC,
    PLAYER_GOT_ACCESS,
    PLAYER_WEAPON_ANG,
    PLAYER_FIRSTAID_AMOUNT,
    PLAYER_SOMETHINGONPLAYER,
    PLAYER_ON_CRANE,
    PLAYER_I,
    PLAYER_PARALLAX_SECTNUM,
    PLAYER_OVER_SHOULDER_ON,
    PLAYER_RANDOM_CLUB_FRAME,
    PLAYER_FIST_INCS,
    PLAYER_ONE_EIGHTY_COUNT,
    PLAYER_CHEAT_PHASE,
    PLAYER_DUMMYPLAYERSPRITE,
    PLAYER_EXTRA_EXTRA8,
    PLAYER_QUICK_KICK,
    PLAYER_HEAT_AMOUNT,
    PLAYER_ACTORSQU,
    PLAYER_TIMEBEFOREEXIT,
    PLAYER_CUSTOMEXITSOUND,
    PLAYER_WEAPRECS,
    PLAYER_WEAPRECCNT,
    PLAYER_INTERFACE_TOGGLE,
    PLAYER_ROTSCRNANG,
    PLAYER_DEAD_FLAG,
    PLAYER_SHOW_EMPTY_WEAPON,
    PLAYER_SCUBA_AMOUNT,
    PLAYER_JETPACK_AMOUNT,
    PLAYER_STEROIDS_AMOUNT,
    PLAYER_SHIELD_AMOUNT,
    PLAYER_HOLODUKE_ON,
    PLAYER_PYCOUNT,
    PLAYER_WEAPON_POS,
    PLAYER_FRAG_PS,
    PLAYER_TRANSPORTER_HOLD,
    PLAYER_CLIPDIST,
    PLAYER_LAST_FULL_WEAPON,
    PLAYER_FOOTPRINTSHADE,
    PLAYER_BOOT_AMOUNT,
    PLAYER_SCREAM_VOICE,
    PLAYER_GM,
    PLAYER_ON_WARPING_SECTOR,
    PLAYER_FOOTPRINTCOUNT,
    PLAYER_HBOMB_ON,
    PLAYER_JUMPING_TOGGLE,
    PLAYER_RAPID_FIRE_HOLD,
    PLAYER_ON_GROUND,
    PLAYER_NAME,
    PLAYER_INVEN_ICON,
    PLAYER_BUTTONPALETTE,
    PLAYER_JETPACK_ON,
    PLAYER_SPRITEBRIDGE,
    PLAYER_SCUBA_ON,
    PLAYER_FOOTPRINTPAL,
    PLAYER_HEAT_ON,
    PLAYER_HOLSTER_WEAPON,
    PLAYER_FALLING_COUNTER,
    PLAYER_GOTWEAPON,
    PLAYER_PALETTE,
    PLAYER_TOGGLE_KEY_FLAG,
    PLAYER_KNUCKLE_INCS,
    PLAYER_WALKING_SND_TOGGLE,
    PLAYER_PALOOKUP,
    PLAYER_HARD_LANDING,
    PLAYER_MAX_SECRET_ROOMS,
    PLAYER_SECRET_ROOMS,
    PLAYER_PALS,
    PLAYER_MAX_ACTORS_KILLED,
    PLAYER_ACTORS_KILLED,
    PLAYER_RETURN_TO_CENTER,
    PLAYER_RUNSPEED,
    PLAYER_SBS,
    PLAYER_RELOADING,
    PLAYER_AUTO_AIM,
    PLAYER_MOVEMENT_LOCK,
    PLAYER_SOUND_PITCH,
    PLAYER_WEAPONSWITCH,
    PLAYER_TEAM,
    PLAYER_MAX_PLAYER_HEALTH,
    PLAYER_MAX_SHIELD_AMOUNT,
    PLAYER_MAX_AMMO_AMOUNT,
    PLAYER_LAST_QUICK_KICK,
    PLAYER_AUTOSTEP,
    PLAYER_AUTOSTEP_SBW,
    PLAYER_HUDPAL,
    PLAYER_INDEX,
    PLAYER_CONNECTED,
    PLAYER_FRAGS,
    PLAYER_DEATHS,
    PLAYER_LAST_USED_WEAPON,
    PLAYER_BSUBWEAPON,
    PLAYER_CROUCH_TOGGLE,
    PLAYER_GRAVITY,
    PLAYER_FLOORZOFFSET,
    PLAYER_SPRITEZOFFSET,
    PLAYER_MINWATERZDIST,
    PLAYER_WATERZOFFSET,
    PLAYER_SHRUNKZOFFSET,
    PLAYER_CROUCHZINCREMENT,
    PLAYER_CROUCHSPEEDMODIFIER,
    PLAYER_SWIMSPEEDMODIFIER,
    PLAYER_SWIMZINCREMENT,
    PLAYER_MINSWIMZVEL,
    PLAYER_MAXSWIMZVEL,
    PLAYER_JETPACKZINCREMENT,
    PLAYER_OLOOK_ANG,
    PLAYER_OROTSCRNANG,
    PLAYER_FLOORZREBOUND,
    PLAYER_FLOORZCUTOFF,
    PLAYER_END
};

enum UserdefsLabel_t
{
    USERDEFS_GOD,
    USERDEFS_WARP_ON,
    USERDEFS_CASHMAN,
    USERDEFS_EOG,
    USERDEFS_SHOWALLMAP,
    USERDEFS_SHOW_HELP,
    USERDEFS_SCROLLMODE,
    USERDEFS_CLIPPING,
    USERDEFS_USER_NAME,
    USERDEFS_RIDECULE,
    USERDEFS_SAVEGAME,
    USERDEFS_PWLOCKOUT,
    USERDEFS_RTSNAME,
    USERDEFS_OVERHEAD_ON,
    USERDEFS_LAST_OVERHEAD,
    USERDEFS_SHOWWEAPONS,
    USERDEFS_PAUSE_ON,
    USERDEFS_FROM_BONUS,
    USERDEFS_CAMERASPRITE,
    USERDEFS_LAST_CAMSPRITE,
    USERDEFS_LAST_LEVEL,
    USERDEFS_SECRETLEVEL,
    USERDEFS_CONST_VISIBILITY,
    USERDEFS_UW_FRAMERATE,
    USERDEFS_CAMERA_TIME,
    USERDEFS_FOLFVEL,
    USERDEFS_FOLSVEL,
    USERDEFS_FOLAVEL,
    USERDEFS_FOLX,
    USERDEFS_FOLY,
    USERDEFS_FOLA,
    USERDEFS_RECCNT,
    USERDEFS_ENTERED_NAME,
    USERDEFS_SCREEN_TILTING,
    USERDEFS_SHADOWS,
    USERDEFS_FTA_ON,
    USERDEFS_EXECUTIONS,
    USERDEFS_AUTO_RUN,
    USERDEFS_COORDS,
    USERDEFS_TICKRATE,
    USERDEFS_M_COOP,
    USERDEFS_COOP,
    USERDEFS_SCREEN_SIZE,
    USERDEFS_LOCKOUT,
    USERDEFS_CROSSHAIR,
    USERDEFS_PLAYERAI,
    USERDEFS_RESPAWN_MONSTERS,
    USERDEFS_RESPAWN_ITEMS,
    USERDEFS_RESPAWN_INVENTORY,
    USERDEFS_RECSTAT,
    USERDEFS_MONSTERS_OFF,
    USERDEFS_BRIGHTNESS,
    USERDEFS_M_RESPAWN_ITEMS,
    USERDEFS_M_RESPAWN_MONSTERS,
    USERDEFS_M_RESPAWN_INVENTORY,
    USERDEFS_M_RECSTAT,
    USERDEFS_M_MONSTERS_OFF,
    USERDEFS_DETAIL,
    USERDEFS_M_FFIRE,
    USERDEFS_FFIRE,
    USERDEFS_M_PLAYER_SKILL,
    USERDEFS_M_LEVEL_NUMBER,
    USERDEFS_M_VOLUME_NUMBER,
    USERDEFS_MULTIMODE,
    USERDEFS_PLAYER_SKILL,
    USERDEFS_LEVEL_NUMBER,
    USERDEFS_VOLUME_NUMBER,
    USERDEFS_M_MARKER,
    USERDEFS_MARKER,
    USERDEFS_MOUSEFLIP,
    USERDEFS_STATUSBARSCALE,
    USERDEFS_DRAWWEAPON,
    USERDEFS_MOUSEAIMING,
    USERDEFS_WEAPONSWITCH,
    USERDEFS_DEMOCAMS,
    USERDEFS_COLOR,
    USERDEFS_MSGDISPTIME,
    USERDEFS_STATUSBARMODE,
    USERDEFS_M_NOEXITS,
    USERDEFS_NOEXITS,
    USERDEFS_AUTOVOTE,
    USERDEFS_AUTOMSG,
    USERDEFS_IDPLAYERS,
    USERDEFS_TEAM,
    USERDEFS_VIEWBOB,
    USERDEFS_WEAPONSWAY,
    USERDEFS_OBITUARIES,
    USERDEFS_LEVELSTATS,
    USERDEFS_CROSSHAIRSCALE,
    USERDEFS_ALTHUD,
    USERDEFS_DISPLAY_BONUS_SCREEN,
    USERDEFS_SHOW_LEVEL_TEXT,
    USERDEFS_WEAPONSCALE,
    USERDEFS_TEXTSCALE,
    USERDEFS_RUNKEY_MODE,
    USERDEFS_M_ORIGIN_X,
    USERDEFS_M_ORIGIN_Y,
    USERDEFS_PLAYERBEST,
    USERDEFS_MUSICTOGGLE,
    USERDEFS_USEVOXELS,
    USERDEFS_USEHIGHTILE,
    USERDEFS_USEMODELS,
    USERDEFS_GAMETYPEFLAGS,
    USERDEFS_M_GAMETYPEFLAGS,
    USERDEFS_GLOBALFLAGS,
    USERDEFS_GLOBALGAMEFLAGS,
    USERDEFS_VM_PLAYER,
    USERDEFS_VM_SPRITE,
    USERDEFS_VM_DISTANCE,
    USERDEFS_SOUNDTOGGLE,
    USERDEFS_GAMETEXT_TRACKING,
    USERDEFS_MGAMETEXT_TRACKING,
    USERDEFS_MENUTEXT_TRACKING,
    USERDEFS_MAXSPRITESONSCREEN,
    USERDEFS_SCREENAREA_X1,
    USERDEFS_SCREENAREA_Y1,
    USERDEFS_SCREENAREA_X2,
    USERDEFS_SCREENAREA_Y2,
    USERDEFS_SCREENFADE,
    USERDEFS_MENUBACKGROUND,
    USERDEFS_STATUSBARFLAGS,
    USERDEFS_STATUSBARRANGE,
    USERDEFS_STATUSBARCUSTOM,
    USERDEFS_HUDONTOP,
    USERDEFS_MENU_SLIDEBARZ,
    USERDEFS_MENU_SLIDEBARMARGIN,
    USERDEFS_MENU_SLIDECURSORZ,
    USERDEFS_GLOBAL_R,
    USERDEFS_GLOBAL_G,
    USERDEFS_GLOBAL_B,
    USERDEFS_DEFAULT_VOLUME,
    USERDEFS_DEFAULT_SKILL,
    USERDEFS_MENU_SHADEDESELECTED,
    USERDEFS_MENU_SHADEDISABLED,
    USERDEFS_MENUTEXT_ZOOM,
    USERDEFS_MENUTEXT_XSPACE,
    USERDEFS_MENUTEXT_PAL,
    USERDEFS_MENUTEXT_PALSELECTED,
    USERDEFS_MENUTEXT_PALDESELECTED,
    USERDEFS_MENUTEXT_PALDISABLED,
    USERDEFS_MENUTEXT_PALSELECTED_RIGHT,
    USERDEFS_MENUTEXT_PALDESELECTED_RIGHT,
    USERDEFS_MENUTEXT_PALDISABLED_RIGHT,
    USERDEFS_GAMETEXT_ZOOM,
    USERDEFS_GAMETEXT_XSPACE,
    USERDEFS_GAMETEXT_PAL,
    USERDEFS_GAMETEXT_PALSELECTED,
    USERDEFS_GAMETEXT_PALDESELECTED,
    USERDEFS_GAMETEXT_PALDISABLED,
    USERDEFS_GAMETEXT_PALSELECTED_RIGHT,
    USERDEFS_GAMETEXT_PALDESELECTED_RIGHT,
    USERDEFS_GAMETEXT_PALDISABLED_RIGHT,
    USERDEFS_MINITEXT_ZOOM,
    USERDEFS_MINITEXT_XSPACE,
    USERDEFS_MINITEXT_TRACKING,
    USERDEFS_MINITEXT_PAL,
    USERDEFS_MINITEXT_PALSELECTED,
    USERDEFS_MINITEXT_PALDESELECTED,
    USERDEFS_MINITEXT_PALDISABLED,
    USERDEFS_MINITEXT_PALSELECTED_RIGHT,
    USERDEFS_MINITEXT_PALDESELECTED_RIGHT,
    USERDEFS_MINITEXT_PALDISABLED_RIGHT,
    USERDEFS_MENUTITLE_PAL,
    USERDEFS_SLIDEBAR_PALSELECTED,
    USERDEFS_SLIDEBAR_PALDISABLED,
    USERDEFS_USER_MAP,
    USERDEFS_M_USER_MAP,
    USERDEFS_MUSIC_EPISODE,
    USERDEFS_MUSIC_LEVEL,
    USERDEFS_SHADOW_PAL,
    USERDEFS_MENU_SCROLLBARTILENUM,
    USERDEFS_MENU_SCROLLBARZ,
    USERDEFS_MENU_SCROLLCURSORZ,
    USERDEFS_RETURN,
    USERDEFS_USERBYTEVERSION,
    USERDEFS_AUTOSAVE,
    USERDEFS_DRAW_Y,
    USERDEFS_DRAW_YXASPECT,
    USERDEFS_FOV,
    USERDEFS_NEWGAMECUSTOMOPEN,
    USERDEFS_NEWGAMECUSTOMSUBOPEN,
    USERDEFS_GAMEPADACTIVE,
    USERDEFS_M_NEWGAMECUSTOM,
    USERDEFS_M_NEWGAMECUSTOMSUB,
    USERDEFS_M_NEWGAMECUSTOML3,
    USERDEFS_KICK_MODE,
    USERDEFS_END
};

enum SectorLabel_t
{
    SECTOR_WALLPTR,
    SECTOR_WALLNUM,
    SECTOR_CEILINGZ,
    SECTOR_CEILINGZGOAL,
    SECTOR_CEILINGZVEL,
    SECTOR_FLOORZ,
    SECTOR_FLOORZGOAL,
    SECTOR_FLOORZVEL,
    SECTOR_CEILINGSTAT,
    SECTOR_FLOORSTAT,
    SECTOR_CEILINGPICNUM,
    SECTOR_CEILINGSLOPE,
    SECTOR_CEILINGSHADE,
    SECTOR_CEILINGPAL,
    SECTOR_CEILINGXPANNING,
    SECTOR_CEILINGYPANNING,
    SECTOR_FLOORPICNUM,
    SECTOR_FLOORSLOPE,
    SECTOR_FLOORSHADE,
    SECTOR_FLOORPAL,
    SECTOR_FLOORXPANNING,
    SECTOR_FLOORYPANNING,
    SECTOR_VISIBILITY,
    SECTOR_FOGPAL,
    SECTOR_LOTAG,
    SECTOR_HITAG,
    SECTOR_EXTRA,
    SECTOR_CEILINGBUNCH,
    SECTOR_FLOORBUNCH,
    SECTOR_ULOTAG,
    SECTOR_UHITAG,
    SECTOR_END
};

enum WallLabel_t
{
    WALL_X,
    WALL_Y,
    WALL_POINT2,
    WALL_NEXTWALL,
    WALL_NEXTSECTOR,
    WALL_CSTAT,
    WALL_PICNUM,
    WALL_OVERPICNUM,
    WALL_SHADE,
    WALL_PAL,
    WALL_XREPEAT,
    WALL_YREPEAT,
    WALL_XPANNING,
    WALL_YPANNING,
    WALL_LOTAG,
    WALL_HITAG,
    WALL_EXTRA,
    WALL_ULOTAG,
    WALL_UHITAG,
    WALL_BLEND,
    WALL_ANG,
    WALL_END
};

enum ActorLabel_t
{
    ACTOR_X,
    ACTOR_Y,
    ACTOR_Z,
    ACTOR_CSTAT,
    ACTOR_PICNUM,
    ACTOR_SHADE,
    ACTOR_PAL,
    ACTOR_CLIPDIST,
    ACTOR_DETAIL,
    ACTOR_XREPEAT,
    ACTOR_YREPEAT,
    ACTOR_XOFFSET,
    ACTOR_YOFFSET,
    ACTOR_SECTNUM,
    ACTOR_STATNUM,
    ACTOR_ANG,
    ACTOR_OWNER,
    ACTOR_XVEL,
    ACTOR_YVEL,
    ACTOR_ZVEL,
    ACTOR_LOTAG,
    ACTOR_HITAG,
    ACTOR_EXTRA,
    ACTOR_ULOTAG,
    ACTOR_UHITAG,
    ACTOR_STRUCT_BEGIN,
    ACTOR_HTCGG = ACTOR_STRUCT_BEGIN,
    ACTOR_HTPICNUM,
    ACTOR_HTANG,
    ACTOR_HTEXTRA,
    ACTOR_HTOWNER,
    ACTOR_HTMOVFLAG,
    ACTOR_HTUMOVFLAG,
    ACTOR_HTTEMPANG,
    ACTOR_HTSTAYPUT,
    ACTOR_HTFLOORZOFFSET,
    ACTOR_HTWATERZOFFSET,
    ACTOR_HTDISPICNUM,
    ACTOR_HTTIMETOSLEEP,
    ACTOR_HTFLOORZ,
    ACTOR_HTCEILINGZ,
    ACTOR_HTLASTVX,
    ACTOR_HTLASTVY,
    ACTOR_HTBPOSX,
    ACTOR_HTBPOSY,
    ACTOR_HTBPOSZ,
    ACTOR_HTG_T,
    ACTOR_HTFLAGS,
    ACTOR_SPRITEEXT_BEGIN,
    ACTOR_ANGOFF = ACTOR_SPRITEEXT_BEGIN,
    ACTOR_PITCH,
    ACTOR_ROLL,
    ACTOR_MDPIVOTXOFF,
    ACTOR_MDPIVOTYOFF,
    ACTOR_MDPIVOTZOFF,
    ACTOR_MDPOSITIONXOFF,
    ACTOR_MDPOSITIONYOFF,
    ACTOR_MDPOSITIONZOFF,
    ACTOR_MDFLAGS,
    ACTOR_XPANNING,
    ACTOR_YPANNING,
    ACTOR_ALPHA,
    ACTOR_ISVALID,
    ACTOR_END
};

enum InputLabel_t
{
    INPUT_AVEL,
    INPUT_Q16AVEL,
    INPUT_HORZ,
    INPUT_Q16HORZ,
    INPUT_FVEL,
    INPUT_SVEL,
    INPUT_BITS,
    INPUT_EXTBITS,
    INPUT_END
};

enum TileDataLabel_t
{
    TILEDATA_XSIZE,
    TILEDATA_YSIZE,
    TILEDATA_ANIMFRAMES,
    TILEDATA_XOFFSET,
    TILEDATA_YOFFSET,
    TILEDATA_ANIMSPEED,
    TILEDATA_ANIMTYPE,
    TILEDATA_GAMEFLAGS,
    TILEDATA_END
};

enum PalDataLabel_t
{
    PALDATA_NOFLOORPAL,
    PALDATA_DUMMY, // so the hash table is size 1. remove when another member is added.
    PALDATA_END
};

enum ProjectileLabel_t
{
    PROJ_WORKSLIKE,  // 0
    PROJ_SPAWNS,
    PROJ_SXREPEAT,
    PROJ_SYREPEAT,
    PROJ_SOUND,
    PROJ_ISOUND,  // 5
    PROJ_VEL,
    PROJ_EXTRA,
    PROJ_DECAL,
    PROJ_TRAIL,
    PROJ_TXREPEAT,  // 10
    PROJ_TYREPEAT,
    PROJ_TOFFSET,
    PROJ_TNUM,
    PROJ_DROP,
    PROJ_CSTAT,  // 15
    PROJ_CLIPDIST,
    PROJ_SHADE,
    PROJ_XREPEAT,
    PROJ_YREPEAT,
    PROJ_PAL,  // 20
    PROJ_EXTRA_RAND,
    PROJ_HITRADIUS,
    PROJ_MOVECNT,
    PROJ_OFFSET,
    PROJ_BOUNCES,  // 25
    PROJ_BSOUND,
    PROJ_RANGE,
    PROJ_FLASH_COLOR,
    PROJ_USERDATA,
    PROJ_END
};

enum IterationTypes_t
{
    ITER_ALLSPRITES,
    ITER_ALLSECTORS,
    ITER_ALLWALLS,
    ITER_ACTIVELIGHTS,
    ITER_DRAWNSPRITES,
    // ---
    ITER_SPRITESOFSECTOR,
    ITER_SPRITESOFSTATUS,
    ITER_WALLSOFSECTOR,
    ITER_LOOPOFWALL,
    ITER_RANGE,
    ITER_ALLSPRITESBYSTAT,
    ITER_ALLSPRITESBYSECT,
    ITER_END
};

// most keywords have opcodes but some opcodes don't have keywords
#define TRANSFORM_SCRIPT_KEYWORDS_LIST(TRANSFORM, DELIMITER) \
    TRANSFORM(CON_SETVAR_GLOBAL) DELIMITER \
    TRANSFORM(CON_SETVAR_PLAYER) DELIMITER \
    TRANSFORM(CON_SETVAR_ACTOR) DELIMITER \
/*  CON_DISCRETE_VAR_ACCESS \

    TRANSFORM(CON_IFVARA_GLOBAL) DELIMITER \
    TRANSFORM(CON_IFVARAE_GLOBAL) DELIMITER \
    TRANSFORM(CON_IFVARAND_GLOBAL) DELIMITER \
    TRANSFORM(CON_IFVARB_GLOBAL) DELIMITER \
    TRANSFORM(CON_IFVARBE_GLOBAL) DELIMITER \
    TRANSFORM(CON_IFVARBOTH_GLOBAL) DELIMITER \
    TRANSFORM(CON_IFVARE_GLOBAL) DELIMITER \
    TRANSFORM(CON_IFVAREITHER_GLOBAL) DELIMITER \
    TRANSFORM(CON_IFVARG_GLOBAL) DELIMITER \
    TRANSFORM(CON_IFVARGE_GLOBAL) DELIMITER \
    TRANSFORM(CON_IFVARL_GLOBAL) DELIMITER \
    TRANSFORM(CON_IFVARLE_GLOBAL) DELIMITER \
    TRANSFORM(CON_IFVARN_GLOBAL) DELIMITER \
    TRANSFORM(CON_IFVAROR_GLOBAL) DELIMITER \
    TRANSFORM(CON_IFVARXOR_GLOBAL) DELIMITER \
    \
    TRANSFORM(CON_ADDVAR_GLOBAL) DELIMITER \
    TRANSFORM(CON_ANDVAR_GLOBAL) DELIMITER \
    TRANSFORM(CON_DIVVAR_GLOBAL) DELIMITER \
    TRANSFORM(CON_MODVAR_GLOBAL) DELIMITER \
    TRANSFORM(CON_MULVAR_GLOBAL) DELIMITER \
    TRANSFORM(CON_ORVAR_GLOBAL) DELIMITER \
    TRANSFORM(CON_RANDVAR_GLOBAL) DELIMITER \
    TRANSFORM(CON_SHIFTVARL_GLOBAL) DELIMITER \
    TRANSFORM(CON_SHIFTVARR_GLOBAL) DELIMITER \
    TRANSFORM(CON_SUBVAR_GLOBAL) DELIMITER \
    TRANSFORM(CON_WHILEVARE_GLOBAL) DELIMITER \
    TRANSFORM(CON_WHILEVARL_GLOBAL) DELIMITER \
    TRANSFORM(CON_WHILEVARN_GLOBAL) DELIMITER \
    TRANSFORM(CON_XORVAR_GLOBAL) DELIMITER \
    \
    TRANSFORM(CON_IFVARA_PLAYER) DELIMITER \
    TRANSFORM(CON_IFVARAE_PLAYER) DELIMITER \
    TRANSFORM(CON_IFVARAND_PLAYER) DELIMITER \
    TRANSFORM(CON_IFVARB_PLAYER) DELIMITER \
    TRANSFORM(CON_IFVARBE_PLAYER) DELIMITER \
    TRANSFORM(CON_IFVARBOTH_PLAYER) DELIMITER \
    TRANSFORM(CON_IFVARE_PLAYER) DELIMITER \
    TRANSFORM(CON_IFVAREITHER_PLAYER) DELIMITER \
    TRANSFORM(CON_IFVARG_PLAYER) DELIMITER \
    TRANSFORM(CON_IFVARGE_PLAYER) DELIMITER \
    TRANSFORM(CON_IFVARL_PLAYER) DELIMITER \
    TRANSFORM(CON_IFVARLE_PLAYER) DELIMITER \
    TRANSFORM(CON_IFVARN_PLAYER) DELIMITER \
    TRANSFORM(CON_IFVAROR_PLAYER) DELIMITER \
    TRANSFORM(CON_IFVARXOR_PLAYER) DELIMITER \
    \
    TRANSFORM(CON_ADDVAR_PLAYER) DELIMITER \
    TRANSFORM(CON_ANDVAR_PLAYER) DELIMITER \
    TRANSFORM(CON_DIVVAR_PLAYER) DELIMITER \
    TRANSFORM(CON_MODVAR_PLAYER) DELIMITER \
    TRANSFORM(CON_MULVAR_PLAYER) DELIMITER \
    TRANSFORM(CON_ORVAR_PLAYER) DELIMITER \
    TRANSFORM(CON_RANDVAR_PLAYER) DELIMITER \
    TRANSFORM(CON_SHIFTVARL_PLAYER) DELIMITER \
    TRANSFORM(CON_SHIFTVARR_PLAYER) DELIMITER \
    TRANSFORM(CON_SUBVAR_PLAYER) DELIMITER \
    TRANSFORM(CON_WHILEVARE_PLAYER) DELIMITER \
    TRANSFORM(CON_WHILEVARL_PLAYER) DELIMITER \
    TRANSFORM(CON_WHILEVARN_PLAYER) DELIMITER \
    TRANSFORM(CON_XORVAR_PLAYER) DELIMITER \
    \
    TRANSFORM(CON_IFVARA_ACTOR) DELIMITER \
    TRANSFORM(CON_IFVARAE_ACTOR) DELIMITER \
    TRANSFORM(CON_IFVARAND_ACTOR) DELIMITER \
    TRANSFORM(CON_IFVARB_ACTOR) DELIMITER \
    TRANSFORM(CON_IFVARBE_ACTOR) DELIMITER \
    TRANSFORM(CON_IFVARBOTH_ACTOR) DELIMITER \
    TRANSFORM(CON_IFVARE_ACTOR) DELIMITER \
    TRANSFORM(CON_IFVAREITHER_ACTOR) DELIMITER \
    TRANSFORM(CON_IFVARG_ACTOR) DELIMITER \
    TRANSFORM(CON_IFVARGE_ACTOR) DELIMITER \
    TRANSFORM(CON_IFVARL_ACTOR) DELIMITER \
    TRANSFORM(CON_IFVARLE_ACTOR) DELIMITER \
    TRANSFORM(CON_IFVARN_ACTOR) DELIMITER \
    TRANSFORM(CON_IFVAROR_ACTOR) DELIMITER \
    TRANSFORM(CON_IFVARXOR_ACTOR) DELIMITER \
    \
    TRANSFORM(CON_ADDVAR_ACTOR) DELIMITER \
    TRANSFORM(CON_ANDVAR_ACTOR) DELIMITER \
    TRANSFORM(CON_DIVVAR_ACTOR) DELIMITER \
    TRANSFORM(CON_MODVAR_ACTOR) DELIMITER \
    TRANSFORM(CON_MULVAR_ACTOR) DELIMITER \
    TRANSFORM(CON_ORVAR_ACTOR) DELIMITER \
    TRANSFORM(CON_RANDVAR_ACTOR) DELIMITER \
    TRANSFORM(CON_SHIFTVARL_ACTOR) DELIMITER \
    TRANSFORM(CON_SHIFTVARR_ACTOR) DELIMITER \
    TRANSFORM(CON_SUBVAR_ACTOR) DELIMITER \
    TRANSFORM(CON_WHILEVARE_ACTOR) DELIMITER \
    TRANSFORM(CON_WHILEVARL_ACTOR) DELIMITER \
    TRANSFORM(CON_WHILEVARN_ACTOR) DELIMITER \
    TRANSFORM(CON_XORVAR_ACTOR) DELIMITER \
*/    \
    TRANSFORM(CON_IFVARVARA) DELIMITER \
    TRANSFORM(CON_IFVARVARAE) DELIMITER \
    TRANSFORM(CON_IFVARVARAND) DELIMITER \
    TRANSFORM(CON_IFVARVARB) DELIMITER \
    TRANSFORM(CON_IFVARVARBE) DELIMITER \
    TRANSFORM(CON_IFVARVARBOTH) DELIMITER \
    TRANSFORM(CON_IFVARVARE) DELIMITER \
    TRANSFORM(CON_IFVARVAREITHER) DELIMITER \
    TRANSFORM(CON_IFVARVARG) DELIMITER \
    TRANSFORM(CON_IFVARVARGE) DELIMITER \
    TRANSFORM(CON_IFVARVARL) DELIMITER \
    TRANSFORM(CON_IFVARVARLE) DELIMITER \
    TRANSFORM(CON_IFVARVARN) DELIMITER \
    TRANSFORM(CON_IFVARVAROR) DELIMITER \
    TRANSFORM(CON_IFVARVARXOR) DELIMITER \
    \
    TRANSFORM(CON_ADDVARVAR) DELIMITER \
    TRANSFORM(CON_ANDVARVAR) DELIMITER \
    TRANSFORM(CON_DIVVARVAR) DELIMITER \
    TRANSFORM(CON_MODVARVAR) DELIMITER \
    TRANSFORM(CON_MULVARVAR) DELIMITER \
    TRANSFORM(CON_ORVARVAR) DELIMITER \
    TRANSFORM(CON_RANDVARVAR) DELIMITER \
    TRANSFORM(CON_SETVARVAR) DELIMITER \
    TRANSFORM(CON_SHIFTVARVARL) DELIMITER \
    TRANSFORM(CON_SHIFTVARVARR) DELIMITER \
    TRANSFORM(CON_SUBVARVAR) DELIMITER \
    TRANSFORM(CON_WHILEVARVARE) DELIMITER \
    TRANSFORM(CON_WHILEVARVARL) DELIMITER \
    TRANSFORM(CON_WHILEVARVARN) DELIMITER \
    TRANSFORM(CON_XORVARVAR) DELIMITER \
    \
    TRANSFORM(CON_IFVARA) DELIMITER \
    TRANSFORM(CON_IFVARAE) DELIMITER \
    TRANSFORM(CON_IFVARAND) DELIMITER \
    TRANSFORM(CON_IFVARB) DELIMITER \
    TRANSFORM(CON_IFVARBE) DELIMITER \
    TRANSFORM(CON_IFVARBOTH) DELIMITER \
    TRANSFORM(CON_IFVARE) DELIMITER \
    TRANSFORM(CON_IFVAREITHER) DELIMITER \
    TRANSFORM(CON_IFVARG) DELIMITER \
    TRANSFORM(CON_IFVARGE) DELIMITER \
    TRANSFORM(CON_IFVARL) DELIMITER \
    TRANSFORM(CON_IFVARLE) DELIMITER \
    TRANSFORM(CON_IFVARN) DELIMITER \
    TRANSFORM(CON_IFVAROR) DELIMITER \
    TRANSFORM(CON_IFVARXOR) DELIMITER \
    \
    TRANSFORM(CON_ADDVAR) DELIMITER \
    TRANSFORM(CON_ANDVAR) DELIMITER \
    TRANSFORM(CON_DIVVAR) DELIMITER \
    TRANSFORM(CON_MODVAR) DELIMITER \
    TRANSFORM(CON_MULVAR) DELIMITER \
    TRANSFORM(CON_ORVAR) DELIMITER \
    TRANSFORM(CON_RANDVAR) DELIMITER \
    TRANSFORM(CON_SETVAR) DELIMITER \
    TRANSFORM(CON_SHIFTVARL) DELIMITER \
    TRANSFORM(CON_SHIFTVARR) DELIMITER \
    TRANSFORM(CON_SUBVAR) DELIMITER \
    TRANSFORM(CON_WHILEVARE) DELIMITER \
    TRANSFORM(CON_WHILEVARL) DELIMITER \
    TRANSFORM(CON_WHILEVARN) DELIMITER \
    TRANSFORM(CON_XORVAR) DELIMITER \
    \
    TRANSFORM(CON_ELSE) DELIMITER \
    TRANSFORM(CON_ENDA) DELIMITER \
    TRANSFORM(CON_ENDEVENT) DELIMITER \
    TRANSFORM(CON_ENDS) DELIMITER \
    TRANSFORM(CON_ENDSWITCH) DELIMITER \
    TRANSFORM(CON_LEFTBRACE) DELIMITER \
    TRANSFORM(CON_RIGHTBRACE) DELIMITER \
    TRANSFORM(CON_STATE) DELIMITER \
    \
    TRANSFORM(CON_SETACTOR) DELIMITER \
    TRANSFORM(CON_SETACTORSTRUCT) DELIMITER \
    TRANSFORM(CON_SETACTORVAR) DELIMITER \
    TRANSFORM(CON_SETARRAY) DELIMITER \
    TRANSFORM(CON_SETARRAYSEQUENCE) DELIMITER \
    TRANSFORM(CON_SETPLAYER) DELIMITER \
    TRANSFORM(CON_SETPLAYERSTRUCT) DELIMITER \
    TRANSFORM(CON_SETPLAYERVAR) DELIMITER \
    TRANSFORM(CON_SETPROJECTILE) DELIMITER \
    TRANSFORM(CON_SETSECTOR) DELIMITER \
    TRANSFORM(CON_SETSECTORSTRUCT) DELIMITER \
    TRANSFORM(CON_SETSPRITEEXT) DELIMITER \
    TRANSFORM(CON_SETSPRITESTRUCT) DELIMITER \
    TRANSFORM(CON_SETTHISPROJECTILE) DELIMITER \
    TRANSFORM(CON_SETTSPR) DELIMITER \
    TRANSFORM(CON_SETUSERDEF) DELIMITER \
    TRANSFORM(CON_SETWALL) DELIMITER \
    TRANSFORM(CON_SETWALLSTRUCT) DELIMITER \
    \
    TRANSFORM(CON_GETACTOR) DELIMITER \
    TRANSFORM(CON_GETACTORSTRUCT) DELIMITER \
    TRANSFORM(CON_GETACTORVAR) DELIMITER \
    TRANSFORM(CON_GETANGLE) DELIMITER \
    TRANSFORM(CON_GETPLAYER) DELIMITER \
    TRANSFORM(CON_GETPLAYERSTRUCT) DELIMITER \
    TRANSFORM(CON_GETPLAYERVAR) DELIMITER \
    TRANSFORM(CON_GETPROJECTILE) DELIMITER \
    TRANSFORM(CON_GETSECTOR) DELIMITER \
    TRANSFORM(CON_GETSECTORSTRUCT) DELIMITER \
    TRANSFORM(CON_GETSPRITEEXT) DELIMITER \
    TRANSFORM(CON_GETSPRITESTRUCT) DELIMITER \
    TRANSFORM(CON_GETTSPR) DELIMITER \
    TRANSFORM(CON_GETUSERDEF) DELIMITER \
    TRANSFORM(CON_GETWALL) DELIMITER \
    TRANSFORM(CON_GETWALLSTRUCT) DELIMITER \
    \
    TRANSFORM(CON_ACTION) DELIMITER \
    TRANSFORM(CON_ACTIVATEBYSECTOR) DELIMITER \
    TRANSFORM(CON_ACTIVATECHEAT) DELIMITER \
    TRANSFORM(CON_ACTORSOUND) DELIMITER \
    TRANSFORM(CON_ADDAMMO) DELIMITER \
    TRANSFORM(CON_ADDINVENTORY) DELIMITER \
    TRANSFORM(CON_ADDKILLS) DELIMITER \
    TRANSFORM(CON_ADDLOGVAR) DELIMITER \
    TRANSFORM(CON_ADDPHEALTH) DELIMITER \
    TRANSFORM(CON_ADDSTRENGTH) DELIMITER \
    TRANSFORM(CON_ADDWEAPON) DELIMITER \
    TRANSFORM(CON_AI) DELIMITER \
    TRANSFORM(CON_ANGOFF) DELIMITER \
    TRANSFORM(CON_BREAK) DELIMITER \
    TRANSFORM(CON_CACTOR) DELIMITER \
    TRANSFORM(CON_CALCHYPOTENUSE) DELIMITER \
    TRANSFORM(CON_CANSEE) DELIMITER \
    TRANSFORM(CON_CANSEESPR) DELIMITER \
    TRANSFORM(CON_CAPIA) DELIMITER \
    TRANSFORM(CON_CAPIS) DELIMITER \
    TRANSFORM(CON_CHANGESPRITESECT) DELIMITER \
    TRANSFORM(CON_CHANGESPRITESTAT) DELIMITER \
    TRANSFORM(CON_CHECKACTIVATORMOTION) DELIMITER \
    TRANSFORM(CON_CHECKAVAILINVEN) DELIMITER \
    TRANSFORM(CON_CHECKAVAILWEAPON) DELIMITER \
    TRANSFORM(CON_CLAMP) DELIMITER \
    TRANSFORM(CON_CLEARMAPSTATE) DELIMITER \
    TRANSFORM(CON_CLIPDIST) DELIMITER \
    TRANSFORM(CON_CLIPMOVE) DELIMITER \
    TRANSFORM(CON_CLIPMOVENOSLIDE) DELIMITER \
    TRANSFORM(CON_CMENU) DELIMITER \
    TRANSFORM(CON_COPY) DELIMITER \
    TRANSFORM(CON_COS) DELIMITER \
    TRANSFORM(CON_COUNT) DELIMITER \
    TRANSFORM(CON_CSTAT) DELIMITER \
    TRANSFORM(CON_CSTATOR) DELIMITER \
    TRANSFORM(CON_DEBRIS) DELIMITER \
    TRANSFORM(CON_DEBUG) DELIMITER \
    TRANSFORM(CON_DIGITALNUMBER) DELIMITER \
    TRANSFORM(CON_DIGITALNUMBERZ) DELIMITER \
    TRANSFORM(CON_DISPLAYRAND) DELIMITER \
    TRANSFORM(CON_DIST) DELIMITER \
    TRANSFORM(CON_DIVR) DELIMITER \
    TRANSFORM(CON_DIVRU) DELIMITER \
    TRANSFORM(CON_DIVSCALE) DELIMITER \
    TRANSFORM(CON_DISPLAYRANDVAR) DELIMITER \
    TRANSFORM(CON_DISPLAYRANDVARVAR) DELIMITER \
    TRANSFORM(CON_DRAGPOINT) DELIMITER \
    TRANSFORM(CON_DRAWLINE256) DELIMITER \
    TRANSFORM(CON_DRAWLINERGB) DELIMITER \
    TRANSFORM(CON_ECHO) DELIMITER \
    TRANSFORM(CON_ENDOFGAME) DELIMITER \
    TRANSFORM(CON_ENDOFLEVEL) DELIMITER \
    TRANSFORM(CON_EQSPAWN) DELIMITER \
    TRANSFORM(CON_ESHOOT) DELIMITER \
    TRANSFORM(CON_ESPAWN) DELIMITER \
    TRANSFORM(CON_EXIT) DELIMITER \
    TRANSFORM(CON_EZSHOOT) DELIMITER \
    TRANSFORM(CON_FALL) DELIMITER \
    TRANSFORM(CON_FINDNEARACTOR) DELIMITER \
    TRANSFORM(CON_FINDNEARACTOR3D) DELIMITER \
    TRANSFORM(CON_FINDNEARACTORZ) DELIMITER \
    TRANSFORM(CON_FINDNEARSPRITE) DELIMITER \
    TRANSFORM(CON_FINDNEARSPRITE3D) DELIMITER \
    TRANSFORM(CON_FINDNEARSPRITEZ) DELIMITER \
    TRANSFORM(CON_FINDOTHERPLAYER) DELIMITER \
    TRANSFORM(CON_FINDPLAYER) DELIMITER \
    TRANSFORM(CON_FLASH) DELIMITER \
    TRANSFORM(CON_FOR) DELIMITER \
    TRANSFORM(CON_GAMETEXT) DELIMITER \
    TRANSFORM(CON_GAMETEXTZ) DELIMITER \
    TRANSFORM(CON_GETACTORANGLE) DELIMITER \
    TRANSFORM(CON_GETANGLETOTARGET) DELIMITER \
    TRANSFORM(CON_GETARRAYSEQUENCE) DELIMITER \
    TRANSFORM(CON_GETARRAYSIZE) DELIMITER \
    TRANSFORM(CON_GETCEILZOFSLOPE) DELIMITER \
    TRANSFORM(CON_GETCLOSESTCOL) DELIMITER \
    TRANSFORM(CON_GETCURRADDRESS) DELIMITER \
    TRANSFORM(CON_GETFLORZOFSLOPE) DELIMITER \
    TRANSFORM(CON_GETGAMEFUNCBIND) DELIMITER \
    TRANSFORM(CON_GETINCANGLE) DELIMITER \
    TRANSFORM(CON_GETINPUT) DELIMITER \
    TRANSFORM(CON_GETKEYNAME) DELIMITER \
    TRANSFORM(CON_GETLASTPAL) DELIMITER \
    TRANSFORM(CON_GETMUSICPOSITION) DELIMITER \
    TRANSFORM(CON_GETNGCFLAGS) DELIMITER \
    TRANSFORM(CON_GETPLAYERANGLE) DELIMITER \
    TRANSFORM(CON_GETPNAME) DELIMITER \
    TRANSFORM(CON_GETTEXTURECEILING) DELIMITER \
    TRANSFORM(CON_GETTEXTUREFLOOR) DELIMITER \
    TRANSFORM(CON_GETTHISPROJECTILE) DELIMITER \
    TRANSFORM(CON_GETTICKS) DELIMITER \
    TRANSFORM(CON_GETTILEDATA) DELIMITER \
    TRANSFORM(CON_GETTIMEDATE) DELIMITER \
    TRANSFORM(CON_GETZRANGE) DELIMITER \
    TRANSFORM(CON_GLOBALSOUND) DELIMITER \
    TRANSFORM(CON_GMAXAMMO) DELIMITER \
    TRANSFORM(CON_GUNIQHUDID) DELIMITER \
    TRANSFORM(CON_GUTS) DELIMITER \
    TRANSFORM(CON_HEADSPRITESECT) DELIMITER \
    TRANSFORM(CON_HEADSPRITESTAT) DELIMITER \
    TRANSFORM(CON_HITRADIUS) DELIMITER \
    TRANSFORM(CON_HITSCAN) DELIMITER \
    TRANSFORM(CON_IFACTION) DELIMITER \
    TRANSFORM(CON_IFACTIONCOUNT) DELIMITER \
    TRANSFORM(CON_IFACTOR) DELIMITER \
    TRANSFORM(CON_IFACTORNOTSTAYPUT) DELIMITER \
    TRANSFORM(CON_IFACTORSOUND) DELIMITER \
    TRANSFORM(CON_IFAI) DELIMITER \
    TRANSFORM(CON_IFANGDIFFL) DELIMITER \
    TRANSFORM(CON_IFAWAYFROMWALL) DELIMITER \
    TRANSFORM(CON_IFBULLETNEAR) DELIMITER \
    TRANSFORM(CON_IFCANSEE) DELIMITER \
    TRANSFORM(CON_IFCANSEETARGET) DELIMITER \
    TRANSFORM(CON_IFCANSHOOTTARGET) DELIMITER \
    TRANSFORM(CON_IFCEILINGDISTL) DELIMITER \
    TRANSFORM(CON_IFCLIENT) DELIMITER \
    TRANSFORM(CON_IFCOUNT) DELIMITER \
    TRANSFORM(CON_IFCUTSCENE) DELIMITER \
    TRANSFORM(CON_IFDEAD) DELIMITER \
    TRANSFORM(CON_IFFLOORDISTL) DELIMITER \
    TRANSFORM(CON_IFGAPZL) DELIMITER \
    TRANSFORM(CON_IFGOTWEAPONCE) DELIMITER \
    TRANSFORM(CON_IFHITSPACE) DELIMITER \
    TRANSFORM(CON_IFHITWEAPON) DELIMITER \
    TRANSFORM(CON_IFINOUTERSPACE) DELIMITER \
    TRANSFORM(CON_IFINSPACE) DELIMITER \
    TRANSFORM(CON_IFINWATER) DELIMITER \
    TRANSFORM(CON_IFMOVE) DELIMITER \
    TRANSFORM(CON_IFMULTIPLAYER) DELIMITER \
    TRANSFORM(CON_IFNOSOUNDS) DELIMITER \
    TRANSFORM(CON_IFNOTMOVING) DELIMITER \
    TRANSFORM(CON_IFONWATER) DELIMITER \
    TRANSFORM(CON_IFOUTSIDE) DELIMITER \
    TRANSFORM(CON_IFP) DELIMITER \
    TRANSFORM(CON_IFPDISTG) DELIMITER \
    TRANSFORM(CON_IFPDISTL) DELIMITER \
    TRANSFORM(CON_IFPHEALTHL) DELIMITER \
    TRANSFORM(CON_IFPINVENTORY) DELIMITER \
    TRANSFORM(CON_IFPLAYBACKON) DELIMITER \
    TRANSFORM(CON_IFPLAYERSL) DELIMITER \
    TRANSFORM(CON_IFRESPAWN) DELIMITER \
    TRANSFORM(CON_IFRND) DELIMITER \
    TRANSFORM(CON_IFSERVER) DELIMITER \
    TRANSFORM(CON_IFSOUND) DELIMITER \
    TRANSFORM(CON_IFSPAWNEDBY) DELIMITER \
    TRANSFORM(CON_IFSPRITEPAL) DELIMITER \
    TRANSFORM(CON_IFSQUISHED) DELIMITER \
    TRANSFORM(CON_IFSTRENGTH) DELIMITER \
    TRANSFORM(CON_IFWASWEAPON) DELIMITER \
    TRANSFORM(CON_INITTIMER) DELIMITER \
    TRANSFORM(CON_INSERTSPRITEQ) DELIMITER \
    TRANSFORM(CON_INV) DELIMITER \
    TRANSFORM(CON_JUMP) DELIMITER \
    TRANSFORM(CON_KILLIT) DELIMITER \
    TRANSFORM(CON_KLABS) DELIMITER \
    TRANSFORM(CON_LDIST) DELIMITER \
    TRANSFORM(CON_LINEINTERSECT) DELIMITER \
    TRANSFORM(CON_LOADMAPSTATE) DELIMITER \
    TRANSFORM(CON_LOCKPLAYER) DELIMITER \
    TRANSFORM(CON_LOTSOFGLASS) DELIMITER \
    TRANSFORM(CON_MAIL) DELIMITER \
    TRANSFORM(CON_MIKESND) DELIMITER \
    TRANSFORM(CON_MINITEXT) DELIMITER \
    TRANSFORM(CON_MONEY) DELIMITER \
    TRANSFORM(CON_MOVE) DELIMITER \
    TRANSFORM(CON_MOVESECTOR) DELIMITER \
    TRANSFORM(CON_MOVESPRITE) DELIMITER \
    TRANSFORM(CON_MULSCALE) DELIMITER \
    TRANSFORM(CON_MYOS) DELIMITER \
    TRANSFORM(CON_MYOSPAL) DELIMITER \
    TRANSFORM(CON_MYOSPALX) DELIMITER \
    TRANSFORM(CON_MYOSX) DELIMITER \
    TRANSFORM(CON_NEARTAG) DELIMITER \
    TRANSFORM(CON_NEXTSECTORNEIGHBORZ) DELIMITER \
    TRANSFORM(CON_NEXTSPRITESECT) DELIMITER \
    TRANSFORM(CON_NEXTSPRITESTAT) DELIMITER \
    TRANSFORM(CON_NULLOP) DELIMITER \
    TRANSFORM(CON_OPERATE) DELIMITER \
    TRANSFORM(CON_OPERATEACTIVATORS) DELIMITER \
    TRANSFORM(CON_OPERATEMASTERSWITCHES) DELIMITER \
    TRANSFORM(CON_OPERATERESPAWNS) DELIMITER \
    TRANSFORM(CON_OPERATESECTORS) DELIMITER \
    TRANSFORM(CON_PALFROM) DELIMITER \
    TRANSFORM(CON_PAPER) DELIMITER \
    TRANSFORM(CON_PKICK) DELIMITER \
    TRANSFORM(CON_PRELOADTRACKSLOTFORSWAP) DELIMITER \
    TRANSFORM(CON_PREVSPRITESECT) DELIMITER \
    TRANSFORM(CON_PREVSPRITESTAT) DELIMITER \
    TRANSFORM(CON_PSTOMP) DELIMITER \
    TRANSFORM(CON_QGETSYSSTR) DELIMITER \
    TRANSFORM(CON_QSPAWN) DELIMITER \
    TRANSFORM(CON_QSPRINTF) DELIMITER \
    TRANSFORM(CON_QSTRCAT) DELIMITER \
    TRANSFORM(CON_QSTRCMP) DELIMITER \
    TRANSFORM(CON_QSTRCPY) DELIMITER \
    TRANSFORM(CON_QSTRDIM) DELIMITER \
    TRANSFORM(CON_QSTRLEN) DELIMITER \
    TRANSFORM(CON_QSTRNCAT) DELIMITER \
    TRANSFORM(CON_QSUBSTR) DELIMITER \
    TRANSFORM(CON_QUAKE) DELIMITER \
    TRANSFORM(CON_QUOTE) DELIMITER \
    TRANSFORM(CON_RAYINTERSECT) DELIMITER \
    TRANSFORM(CON_READARRAYFROMFILE) DELIMITER \
    TRANSFORM(CON_READGAMEVAR) DELIMITER \
    TRANSFORM(CON_REDEFINEQUOTE) DELIMITER \
    TRANSFORM(CON_RESETACTIONCOUNT) DELIMITER \
    TRANSFORM(CON_RESETCOUNT) DELIMITER \
    TRANSFORM(CON_RESETPLAYER) DELIMITER \
    TRANSFORM(CON_RESETPLAYERFLAGS) DELIMITER \
    TRANSFORM(CON_RESIZEARRAY) DELIMITER \
    TRANSFORM(CON_RESPAWNHITAG) DELIMITER \
    TRANSFORM(CON_RETURN) DELIMITER \
    TRANSFORM(CON_ROTATEPOINT) DELIMITER \
    TRANSFORM(CON_ROTATESPRITE) DELIMITER \
    TRANSFORM(CON_ROTATESPRITE16) DELIMITER \
    TRANSFORM(CON_ROTATESPRITEA) DELIMITER \
    TRANSFORM(CON_SAVE) DELIMITER \
    TRANSFORM(CON_SAVEGAMEVAR) DELIMITER \
    TRANSFORM(CON_SAVEMAPSTATE) DELIMITER \
    TRANSFORM(CON_SAVENN) DELIMITER \
    TRANSFORM(CON_SCALEVAR) DELIMITER \
    TRANSFORM(CON_SCREENPAL) DELIMITER \
    TRANSFORM(CON_SCREENSOUND) DELIMITER \
    TRANSFORM(CON_SCREENTEXT) DELIMITER \
    TRANSFORM(CON_SECTCLEARINTERPOLATION) DELIMITER \
    TRANSFORM(CON_SECTGETHITAG) DELIMITER \
    TRANSFORM(CON_SECTGETLOTAG) DELIMITER \
    TRANSFORM(CON_SECTOROFWALL) DELIMITER \
    TRANSFORM(CON_SECTSETINTERPOLATION) DELIMITER \
    TRANSFORM(CON_SETACTORANGLE) DELIMITER \
    TRANSFORM(CON_SETACTORSOUNDPITCH) DELIMITER \
    TRANSFORM(CON_SETASPECT) DELIMITER \
    TRANSFORM(CON_SETGAMEPALETTE) DELIMITER \
    TRANSFORM(CON_SETINPUT) DELIMITER \
    TRANSFORM(CON_SETMUSICPOSITION) DELIMITER \
    TRANSFORM(CON_SETNGCFLAGS) DELIMITER \
    TRANSFORM(CON_SETPLAYERANGLE) DELIMITER \
    TRANSFORM(CON_SETSPRITE) DELIMITER \
    TRANSFORM(CON_SETTILEDATA) DELIMITER \
    TRANSFORM(CON_SHOOT) DELIMITER \
    TRANSFORM(CON_SHOWVIEW) DELIMITER \
    TRANSFORM(CON_SHOWVIEWQ16) DELIMITER \
    TRANSFORM(CON_SHOWVIEWQ16UNBIASED) DELIMITER \
    TRANSFORM(CON_SHOWVIEWUNBIASED) DELIMITER \
    TRANSFORM(CON_SIN) DELIMITER \
    TRANSFORM(CON_SIZEAT) DELIMITER \
    TRANSFORM(CON_SIZETO) DELIMITER \
    TRANSFORM(CON_SLEEPTIME) DELIMITER \
    TRANSFORM(CON_SMAXAMMO) DELIMITER \
    TRANSFORM(CON_SOUND) DELIMITER \
    TRANSFORM(CON_SOUNDONCE) DELIMITER \
    TRANSFORM(CON_SPAWN) DELIMITER \
    TRANSFORM(CON_SPAWNCEILINGGLASS) DELIMITER \
    TRANSFORM(CON_SPAWNWALLGLASS) DELIMITER \
    TRANSFORM(CON_SPAWNWALLSTAINEDGLASS) DELIMITER \
    TRANSFORM(CON_SPGETHITAG) DELIMITER \
    TRANSFORM(CON_SPGETLOTAG) DELIMITER \
    TRANSFORM(CON_SPRITEFLAGS) DELIMITER \
    TRANSFORM(CON_SPRITEPAL) DELIMITER \
    TRANSFORM(CON_SQRT) DELIMITER \
    TRANSFORM(CON_SSP) DELIMITER \
    TRANSFORM(CON_STARTCUTSCENE) DELIMITER \
    TRANSFORM(CON_STARTLEVEL) DELIMITER \
    TRANSFORM(CON_STARTSCREEN) DELIMITER \
    TRANSFORM(CON_STARTTRACK) DELIMITER \
    TRANSFORM(CON_STARTTRACKSLOT) DELIMITER \
    TRANSFORM(CON_STOPACTORSOUND) DELIMITER \
    TRANSFORM(CON_STOPALLMUSIC) DELIMITER \
    TRANSFORM(CON_STOPALLSOUNDS) DELIMITER \
    TRANSFORM(CON_STOPSOUND) DELIMITER \
    TRANSFORM(CON_STRENGTH) DELIMITER \
    TRANSFORM(CON_SWAPARRAYS) DELIMITER \
    TRANSFORM(CON_SWAPTRACKSLOT) DELIMITER \
    TRANSFORM(CON_SWITCH) DELIMITER \
    TRANSFORM(CON_TERMINATE) DELIMITER \
    TRANSFORM(CON_TIME) DELIMITER \
    TRANSFORM(CON_TIP) DELIMITER \
    TRANSFORM(CON_TOSSWEAPON) DELIMITER \
    TRANSFORM(CON_UPDATESECTOR) DELIMITER \
    TRANSFORM(CON_UPDATESECTORZ) DELIMITER \
    TRANSFORM(CON_UPDATESECTORNEIGHBOR) DELIMITER \
    TRANSFORM(CON_UPDATESECTORNEIGHBORZ) DELIMITER \
    TRANSFORM(CON_USERQUOTE) DELIMITER \
    TRANSFORM(CON_WACKPLAYER) DELIMITER \
    TRANSFORM(CON_WRITEARRAYTOFILE) DELIMITER \
    TRANSFORM(CON_YIELD) DELIMITER \
    TRANSFORM(CON_YIELDJUMP) DELIMITER \
    TRANSFORM(CON_ZSHOOT) DELIMITER \
    \
    TRANSFORM(CON_OPCODE_END)

    // these are the keywords that don't have instructions written into the bytecode
#define TRANSFORM_SCRIPT_ONLY_KEYWORDS_LIST(TRANSFORM, DELIMITER) \
    TRANSFORM(CON_ACTIVATE) DELIMITER \
    TRANSFORM(CON_ACTOR) DELIMITER \
    TRANSFORM(CON_APPENDEVENT) DELIMITER \
    TRANSFORM(CON_APPENDSTATE) DELIMITER \
    TRANSFORM(CON_BETANAME) DELIMITER \
    TRANSFORM(CON_CASE) DELIMITER \
    TRANSFORM(CON_CHEATKEYS) DELIMITER \
    TRANSFORM(CON_CONTINUE) DELIMITER \
    TRANSFORM(CON_DAMAGEEVENTTILE) DELIMITER \
    TRANSFORM(CON_DAMAGEEVENTTILERANGE) DELIMITER \
    TRANSFORM(CON_DEFAULT) DELIMITER \
    TRANSFORM(CON_DEFINE) DELIMITER \
    TRANSFORM(CON_DEFINECHEAT) DELIMITER \
    TRANSFORM(CON_DEFINECHEATDESCRIPTION) DELIMITER \
    TRANSFORM(CON_DEFINEGAMEFUNCNAME) DELIMITER \
    TRANSFORM(CON_DEFINEGAMETYPE) DELIMITER \
    TRANSFORM(CON_DEFINELEVELNAME) DELIMITER \
    TRANSFORM(CON_DEFINEPROJECTILE) DELIMITER \
    TRANSFORM(CON_DEFINEQUOTE) DELIMITER \
    TRANSFORM(CON_DEFINESKILLNAME) DELIMITER \
    TRANSFORM(CON_DEFINESOUND) DELIMITER \
    TRANSFORM(CON_DEFINEVOLUMEFLAGS) DELIMITER \
    TRANSFORM(CON_DEFINEVOLUMENAME) DELIMITER \
    TRANSFORM(CON_DEFSTATE) DELIMITER \
    TRANSFORM(CON_DYNAMICREMAP) DELIMITER \
    TRANSFORM(CON_DYNAMICSOUNDREMAP) DELIMITER \
    TRANSFORM(CON_ENHANCED) DELIMITER \
    TRANSFORM(CON_EVENTLOADACTOR) DELIMITER \
    TRANSFORM(CON_GAMEARRAY) DELIMITER \
    TRANSFORM(CON_GAMESTARTUP) DELIMITER \
    TRANSFORM(CON_GAMEVAR) DELIMITER \
    TRANSFORM(CON_INCLUDE) DELIMITER \
    TRANSFORM(CON_INCLUDEDEFAULT) DELIMITER \
    TRANSFORM(CON_MUSIC) DELIMITER \
    TRANSFORM(CON_ONEVENT) DELIMITER \
    TRANSFORM(CON_PRECACHE) DELIMITER \
    TRANSFORM(CON_PREPENDSTATE) DELIMITER \
    TRANSFORM(CON_SCRIPTSIZE) DELIMITER \
    TRANSFORM(CON_SETCFGNAME) DELIMITER \
    TRANSFORM(CON_SETDEFNAME) DELIMITER \
    TRANSFORM(CON_SETGAMENAME) DELIMITER \
    TRANSFORM(CON_SHADETO) DELIMITER \
    TRANSFORM(CON_SPRITENOPAL) DELIMITER \
    TRANSFORM(CON_SPRITENOSHADE) DELIMITER \
    TRANSFORM(CON_SPRITENVG) DELIMITER \
    TRANSFORM(CON_SPRITESHADOW) DELIMITER \
    TRANSFORM(CON_UNDEFINECHEAT) DELIMITER \
    TRANSFORM(CON_UNDEFINEGAMEFUNC) DELIMITER \
    TRANSFORM(CON_UNDEFINELEVEL) DELIMITER \
    TRANSFORM(CON_UNDEFINESKILL) DELIMITER \
    TRANSFORM(CON_UNDEFINEVOLUME) DELIMITER \
    TRANSFORM(CON_USERACTOR) DELIMITER \
    \
    TRANSFORM(CON_END)

#define ENUM_TRANSFORM(ENUM_CONST) ENUM_CONST
#define COMMA ,
enum ScriptKeywords_t
{
    TRANSFORM_SCRIPT_KEYWORDS_LIST(ENUM_TRANSFORM, COMMA),
    TRANSFORM_SCRIPT_ONLY_KEYWORDS_LIST(ENUM_TRANSFORM, COMMA)
};
#undef ENUM_TRANSFORM
#undef COMMA

#ifdef __cplusplus
}
#endif

#endif // gamedef_h_
