//-------------------------------------------------------------------------
/*
Copyright (C) 2016 EDuke32 developers and contributors

This file is part of EDuke32.

EDuke32 is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License version 2
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
//-------------------------------------------------------------------------

#ifndef gamedef_h_
#define gamedef_h_

#include "actors.h"
#include "build.h"  // hashtable_t
#include "cheats.h"
#include "common.h"  // tokenlist
#include "player.h"  // projectile_t

#ifdef __cplusplus
extern "C" {
#endif

enum
{
    LABEL_ACTION = 0x01,
    LABEL_ACTOR  = 0x02,
    LABEL_AI     = 0x04,
    LABEL_DEFINE = 0x08,
    LABEL_EVENT  = 0x10,
    LABEL_MOVE   = 0x20,
    LABEL_STATE  = 0x40,

    LABEL_ANY    = -1,
};

#define LABEL_CHAR sizeof(uint8_t)
#define LABEL_SHORT sizeof(uint16_t)
#define LABEL_INT sizeof(uint32_t)
#define LABEL_UNSIGNED 8
#define LABEL_HASPARM2 16
#define LABEL_ISSTRING 32
#define LABEL_READFUNC 64
#define LABEL_WRITEFUNC 128

#define VM_INSTMASK 0xfff

#define C_CUSTOMERROR(Text, ...)                                                               \
    do                                                                                         \
    {                                                                                          \
        C_ReportError(-1);                                                                     \
        initprintf("%s:%d: error: " Text "\n", g_scriptFileName, g_lineNumber, ##__VA_ARGS__); \
        g_errorCnt++;                                                                          \
    } while (0)

#define C_CUSTOMWARNING(Text, ...)                                                               \
    do                                                                                           \
    {                                                                                            \
        C_ReportError(-1);                                                                       \
        initprintf("%s:%d: warning: " Text "\n", g_scriptFileName, g_lineNumber, ##__VA_ARGS__); \
        g_warningCnt++;                                                                          \
    } while (0)

#if !defined LUNATIC
extern intptr_t const * insptr;
extern void VM_ScriptInfo(intptr_t const *ptr, int range);
#endif

extern hashtable_t h_gamefuncs;

#if !defined LUNATIC
extern hashtable_t h_gamevars;
extern hashtable_t h_arrays;
extern hashtable_t h_labels;

extern int32_t g_aimAngleVarID;   // var ID of "AUTOAIMANGLE"
extern int32_t g_angRangeVarID;   // var ID of "ANGRANGE"
extern int32_t g_hitagVarID;      // var ID of "HITAG"
extern int32_t g_lotagVarID;      // var ID of "LOTAG"
extern int32_t g_returnVarID;     // var ID of "RETURN"
extern int32_t g_textureVarID;    // var ID of "TEXTURE"
extern int32_t g_thisActorVarID;  // var ID of "THISACTOR"
extern int32_t g_weaponVarID;     // var ID of "WEAPON"
extern int32_t g_worksLikeVarID;  // var ID of "WORKSLIKE"
extern int32_t g_zRangeVarID;     // var ID of "ZRANGE"

// KEEPINSYNC gamevars.cpp: "special vars for struct access"
enum QuickStructureAccess_t
{
    STRUCT_SPRITE,
    STRUCT_SPRITE_INTERNAL__,
    STRUCT_ACTOR_INTERNAL__,
    STRUCT_SPRITEEXT_INTERNAL__,
    STRUCT_SECTOR,
    STRUCT_WALL,
    STRUCT_PLAYER,
    STRUCT_ACTORVAR,
    STRUCT_PLAYERVAR,
    STRUCT_TSPR,
    STRUCT_PROJECTILE,
    STRUCT_THISPROJECTILE,
    STRUCT_USERDEF,
    STRUCT_INPUT,
    STRUCT_TILEDATA,
    STRUCT_PALDATA,
    NUMQUICKSTRUCTS,
};

extern int32_t g_structVarIDs;

#include "events_defs.h"
extern intptr_t apScriptEvents[MAXEVENTS];
#endif

extern char g_scriptFileName[BMAX_PATH];

extern const uint32_t CheatFunctionFlags[];
extern const uint8_t  CheatFunctionIDs[];

extern int32_t g_errorCnt;
extern int32_t g_lineNumber;
extern int32_t g_numXStrings;
extern int32_t g_scriptVersion;
extern int32_t g_totalLines;
extern int32_t g_warningCnt;
extern uint32_t g_scriptcrc;
extern int32_t otherp;

extern const char *EventNames[MAXEVENTS];

#if !defined LUNATIC
extern intptr_t *g_scriptPtr;

 typedef struct
 {
     const char *name;

     int32_t  lId;
     uint32_t flags;
     int16_t  maxParm2;
     int16_t  offset;
 } memberlabel_t;

extern const memberlabel_t ActorLabels[];
extern const memberlabel_t InputLabels[];
extern const memberlabel_t PalDataLabels[];
extern const memberlabel_t PlayerLabels[];
extern const memberlabel_t ProjectileLabels[];
extern const memberlabel_t SectorLabels[];
extern const memberlabel_t TileDataLabels[];
extern const memberlabel_t TsprLabels[];
extern const memberlabel_t UserdefsLabels[];
extern const memberlabel_t WallLabels[];

extern hashtable_t h_actor;
extern hashtable_t h_input;
extern hashtable_t h_paldata;
extern hashtable_t h_player;
extern hashtable_t h_projectile;
extern hashtable_t h_sector;
extern hashtable_t h_tiledata;
extern hashtable_t h_tsprite;
extern hashtable_t h_userdef;
extern hashtable_t h_wall;
#endif

typedef projectile_t defaultprojectile_t;

extern defaultprojectile_t DefaultProjectile;
int32_t C_AllocQuote(int32_t qnum);
void C_AllocProjectile(int32_t j);
void C_FreeProjectile(int32_t j);
void C_InitQuotes(void);
void C_InitProjectiles(void);

typedef struct {
    int spriteNum;
    int playerNum;
    int playerDist;
    int flags;

    union {
        spritetype * pSprite;
        uspritetype *pUSprite;
    };

    int32_t *     pData;
    DukePlayer_t *pPlayer;
    actor_t *     pActor;
} vmstate_t;

extern vmstate_t vm;

void G_DoGameStartup(const int32_t *params);
void C_DefineMusic(int volumeNum, int levelNum, const char *fileName);

void C_DefineVolumeFlags(int32_t vol, int32_t flags);
void C_UndefineVolume(int32_t vol);
void C_UndefineSkill(int32_t skill);
void C_UndefineLevel(int32_t vol, int32_t lev);
#if defined LUNATIC
void C_DefineSound(int32_t sndidx, const char *fn, int32_t args[5]);
void C_DefineQuote(int32_t qnum, const char *qstr);
void C_DefineVolumeName(int32_t vol, const char *name);
void C_DefineSkillName(int32_t skill, const char *name);
void C_DefineLevelName(int32_t vol, int32_t lev, const char *fn,
                       int32_t partime, int32_t designertime,
                       const char *levelname);
void C_DefineGameFuncName(int32_t idx, const char *name);
void C_DefineGameType(int32_t idx, int32_t flags, const char *name);
int32_t C_SetDefName(const char *name);
void C_DefineProjectile(int32_t j, int32_t what, int32_t val);
void C_SetCfgName(const char *cfgname);
#else
void C_ReportError(int error);
void C_Compile(const char *filenam);

extern int32_t g_errorLineNum;
extern int32_t g_tw;

typedef struct {
    const char* token;
    int32_t val;
} tokenmap_t;

extern const tokenmap_t iter_tokens[];

extern char const * VM_GetKeywordForID(int32_t id);

// KEEPINSYNC lunatic/con_lang.lua
enum SystemString_t {
    STR_MAPNAME,
    STR_MAPFILENAME,
    STR_PLAYERNAME,
    STR_VERSION,
    STR_GAMETYPE,
    STR_VOLUMENAME,
    STR_YOURTIME,
    STR_PARTIME,
    STR_DESIGNERTIME,
    STR_BESTTIME,
    STR_USERMAPFILENAME,
};

enum ScriptError_t
{
    ERROR_ARRAYREADONLY,
    ERROR_EVENTONLY,
    ERROR_EXCEEDSMAXTILES,
    ERROR_EXPECTEDKEYWORD,
    ERROR_FOUNDWITHIN,
    ERROR_GAMEARRAYBNC,
    ERROR_GAMEARRAYBNO,
    ERROR_INVALIDARRAYWRITE,
    ERROR_ISAKEYWORD,
    ERROR_NOENDSWITCH,
    ERROR_NOTAGAMEARRAY,
    ERROR_NOTAGAMEDEF,
    ERROR_NOTAGAMEVAR,
    ERROR_NOTAMEMBER,
    ERROR_NOTTOPLEVEL,
    ERROR_PARAMUNDEFINED,
    ERROR_SYNTAXERROR,
    ERROR_VARREADONLY,
    ERROR_VARTYPEMISMATCH,
    WARNING_ARRAYMASKSKEYWORD,
    WARNING_BADGAMEVAR,
    WARNING_DUPLICATECASE,
    WARNING_DUPLICATEDEFINITION,
    WARNING_EVENTSYNC,
    WARNING_LABELSONLY,
    WARNING_NAMEMATCHESVAR,
    WARNING_VARMASKSKEYWORD,
};

enum PlayerLabel_t
{
    PLAYER_ZOOM,
    PLAYER_LOOGIEX,
    PLAYER_LOOGIEY,
    PLAYER_NUMLOOGS,
    PLAYER_LOOGCNT,
    PLAYER_POSX,
    PLAYER_POSY,
    PLAYER_POSZ,
    PLAYER_HORIZ,
    PLAYER_HORIZOFF,
    PLAYER_OHORIZ,
    PLAYER_OHORIZOFF,
    PLAYER_Q16HORIZ,
    PLAYER_Q16HORIZOFF,
    PLAYER_OQ16HORIZ,
    PLAYER_OQ16HORIZOFF,
    PLAYER_INVDISPTIME,
    PLAYER_BOBPOSX,
    PLAYER_BOBPOSY,
    PLAYER_OPOSX,
    PLAYER_OPOSY,
    PLAYER_OPOSZ,
    PLAYER_PYOFF,
    PLAYER_OPYOFF,
    PLAYER_POSXV,
    PLAYER_POSYV,
    PLAYER_POSZV,
    PLAYER_LAST_PISSED_TIME,
    PLAYER_TRUEFZ,
    PLAYER_TRUECZ,
    PLAYER_PLAYER_PAR,
    PLAYER_VISIBILITY,
    PLAYER_BOBCOUNTER,
    PLAYER_WEAPON_SWAY,
    PLAYER_PALS_TIME,
    PLAYER_CRACK_TIME,
    PLAYER_AIM_MODE,
    PLAYER_ANG,
    PLAYER_OANG,
    PLAYER_Q16ANG,
    PLAYER_OQ16ANG,
    PLAYER_ANGVEL,
    PLAYER_Q16ANGVEL,
    PLAYER_CURSECTNUM,
    PLAYER_LOOK_ANG,
    PLAYER_LAST_EXTRA,
    PLAYER_SUBWEAPON,
    PLAYER_AMMO_AMOUNT,
    PLAYER_WACKEDBYACTOR,
    PLAYER_FRAG,
    PLAYER_FRAGGEDSELF,
    PLAYER_CURR_WEAPON,
    PLAYER_LAST_WEAPON,
    PLAYER_TIPINCS,
    PLAYER_WANTWEAPONFIRE,
    PLAYER_HOLODUKE_AMOUNT,
    PLAYER_NEWOWNER,
    PLAYER_HURT_DELAY,
    PLAYER_HBOMB_HOLD_DELAY,
    PLAYER_JUMPING_COUNTER,
    PLAYER_AIRLEFT,
    PLAYER_KNEE_INCS,
    PLAYER_ACCESS_INCS,
    PLAYER_FTA,
    PLAYER_FTQ,
    PLAYER_ACCESS_WALLNUM,
    PLAYER_ACCESS_SPRITENUM,
    PLAYER_KICKBACK_PIC,
    PLAYER_GOT_ACCESS,
    PLAYER_WEAPON_ANG,
    PLAYER_FIRSTAID_AMOUNT,
    PLAYER_SOMETHINGONPLAYER,
    PLAYER_ON_CRANE,
    PLAYER_I,
    PLAYER_PARALLAX_SECTNUM,
    PLAYER_OVER_SHOULDER_ON,
    PLAYER_RANDOM_CLUB_FRAME,
    PLAYER_FIST_INCS,
    PLAYER_ONE_EIGHTY_COUNT,
    PLAYER_CHEAT_PHASE,
    PLAYER_DUMMYPLAYERSPRITE,
    PLAYER_EXTRA_EXTRA8,
    PLAYER_QUICK_KICK,
    PLAYER_HEAT_AMOUNT,
    PLAYER_ACTORSQU,
    PLAYER_TIMEBEFOREEXIT,
    PLAYER_CUSTOMEXITSOUND,
    PLAYER_WEAPRECS,
    PLAYER_WEAPRECCNT,
    PLAYER_INTERFACE_TOGGLE,
    PLAYER_ROTSCRNANG,
    PLAYER_DEAD_FLAG,
    PLAYER_SHOW_EMPTY_WEAPON,
    PLAYER_SCUBA_AMOUNT,
    PLAYER_JETPACK_AMOUNT,
    PLAYER_STEROIDS_AMOUNT,
    PLAYER_SHIELD_AMOUNT,
    PLAYER_HOLODUKE_ON,
    PLAYER_PYCOUNT,
    PLAYER_WEAPON_POS,
    PLAYER_FRAG_PS,
    PLAYER_TRANSPORTER_HOLD,
    PLAYER_CLIPDIST,
    PLAYER_LAST_FULL_WEAPON,
    PLAYER_FOOTPRINTSHADE,
    PLAYER_BOOT_AMOUNT,
    PLAYER_SCREAM_VOICE,
    PLAYER_GM,
    PLAYER_ON_WARPING_SECTOR,
    PLAYER_FOOTPRINTCOUNT,
    PLAYER_HBOMB_ON,
    PLAYER_JUMPING_TOGGLE,
    PLAYER_RAPID_FIRE_HOLD,
    PLAYER_ON_GROUND,
    PLAYER_NAME,
    PLAYER_INVEN_ICON,
    PLAYER_BUTTONPALETTE,
    PLAYER_JETPACK_ON,
    PLAYER_SPRITEBRIDGE,
    PLAYER_SCUBA_ON,
    PLAYER_FOOTPRINTPAL,
    PLAYER_HEAT_ON,
    PLAYER_HOLSTER_WEAPON,
    PLAYER_FALLING_COUNTER,
    PLAYER_GOTWEAPON,
    PLAYER_PALETTE,
    PLAYER_TOGGLE_KEY_FLAG,
    PLAYER_KNUCKLE_INCS,
    PLAYER_WALKING_SND_TOGGLE,
    PLAYER_PALOOKUP,
    PLAYER_HARD_LANDING,
    PLAYER_MAX_SECRET_ROOMS,
    PLAYER_SECRET_ROOMS,
    PLAYER_PALS,
    PLAYER_MAX_ACTORS_KILLED,
    PLAYER_ACTORS_KILLED,
    PLAYER_RETURN_TO_CENTER,
    PLAYER_RUNSPEED,
    PLAYER_SBS,
    PLAYER_RELOADING,
    PLAYER_AUTO_AIM,
    PLAYER_MOVEMENT_LOCK,
    PLAYER_SOUND_PITCH,
    PLAYER_WEAPONSWITCH,
    PLAYER_TEAM,
    PLAYER_MAX_PLAYER_HEALTH,
    PLAYER_MAX_SHIELD_AMOUNT,
    PLAYER_MAX_AMMO_AMOUNT,
    PLAYER_LAST_QUICK_KICK,
    PLAYER_AUTOSTEP,
    PLAYER_AUTOSTEP_SBW,
    PLAYER_HUDPAL,
    PLAYER_INDEX,
    PLAYER_CONNECTED,
    PLAYER_FRAGS,
    PLAYER_DEATHS,
    PLAYER_LAST_USED_WEAPON,
    PLAYER_END
};

enum UserdefsLabel_t
{
    USERDEFS_GOD,
    USERDEFS_WARP_ON,
    USERDEFS_CASHMAN,
    USERDEFS_EOG,
    USERDEFS_SHOWALLMAP,
    USERDEFS_SHOW_HELP,
    USERDEFS_SCROLLMODE,
    USERDEFS_CLIPPING,
    USERDEFS_USER_NAME,
    USERDEFS_RIDECULE,
    USERDEFS_SAVEGAME,
    USERDEFS_PWLOCKOUT,
    USERDEFS_RTSNAME,
    USERDEFS_OVERHEAD_ON,
    USERDEFS_LAST_OVERHEAD,
    USERDEFS_SHOWWEAPONS,
    USERDEFS_PAUSE_ON,
    USERDEFS_FROM_BONUS,
    USERDEFS_CAMERASPRITE,
    USERDEFS_LAST_CAMSPRITE,
    USERDEFS_LAST_LEVEL,
    USERDEFS_SECRETLEVEL,
    USERDEFS_CONST_VISIBILITY,
    USERDEFS_UW_FRAMERATE,
    USERDEFS_CAMERA_TIME,
    USERDEFS_FOLFVEL,
    USERDEFS_FOLAVEL,
    USERDEFS_FOLX,
    USERDEFS_FOLY,
    USERDEFS_FOLA,
    USERDEFS_RECCNT,
    USERDEFS_ENTERED_NAME,
    USERDEFS_SCREEN_TILTING,
    USERDEFS_SHADOWS,
    USERDEFS_FTA_ON,
    USERDEFS_EXECUTIONS,
    USERDEFS_AUTO_RUN,
    USERDEFS_COORDS,
    USERDEFS_TICKRATE,
    USERDEFS_M_COOP,
    USERDEFS_COOP,
    USERDEFS_SCREEN_SIZE,
    USERDEFS_LOCKOUT,
    USERDEFS_CROSSHAIR,
    USERDEFS_PLAYERAI,
    USERDEFS_RESPAWN_MONSTERS,
    USERDEFS_RESPAWN_ITEMS,
    USERDEFS_RESPAWN_INVENTORY,
    USERDEFS_RECSTAT,
    USERDEFS_MONSTERS_OFF,
    USERDEFS_BRIGHTNESS,
    USERDEFS_M_RESPAWN_ITEMS,
    USERDEFS_M_RESPAWN_MONSTERS,
    USERDEFS_M_RESPAWN_INVENTORY,
    USERDEFS_M_RECSTAT,
    USERDEFS_M_MONSTERS_OFF,
    USERDEFS_DETAIL,
    USERDEFS_M_FFIRE,
    USERDEFS_FFIRE,
    USERDEFS_M_PLAYER_SKILL,
    USERDEFS_M_LEVEL_NUMBER,
    USERDEFS_M_VOLUME_NUMBER,
    USERDEFS_MULTIMODE,
    USERDEFS_PLAYER_SKILL,
    USERDEFS_LEVEL_NUMBER,
    USERDEFS_VOLUME_NUMBER,
    USERDEFS_M_MARKER,
    USERDEFS_MARKER,
    USERDEFS_MOUSEFLIP,
    USERDEFS_STATUSBARSCALE,
    USERDEFS_DRAWWEAPON,
    USERDEFS_MOUSEAIMING,
    USERDEFS_WEAPONSWITCH,
    USERDEFS_DEMOCAMS,
    USERDEFS_COLOR,
    USERDEFS_MSGDISPTIME,
    USERDEFS_STATUSBARMODE,
    USERDEFS_M_NOEXITS,
    USERDEFS_NOEXITS,
    USERDEFS_AUTOVOTE,
    USERDEFS_AUTOMSG,
    USERDEFS_IDPLAYERS,
    USERDEFS_TEAM,
    USERDEFS_VIEWBOB,
    USERDEFS_WEAPONSWAY,
    USERDEFS_ANGLEINTERPOLATION,
    USERDEFS_OBITUARIES,
    USERDEFS_LEVELSTATS,
    USERDEFS_CROSSHAIRSCALE,
    USERDEFS_ALTHUD,
    USERDEFS_DISPLAY_BONUS_SCREEN,
    USERDEFS_SHOW_LEVEL_TEXT,
    USERDEFS_WEAPONSCALE,
    USERDEFS_TEXTSCALE,
    USERDEFS_RUNKEY_MODE,
    USERDEFS_M_ORIGIN_X,
    USERDEFS_M_ORIGIN_Y,
    USERDEFS_PLAYERBEST,
    USERDEFS_MUSICTOGGLE,
    USERDEFS_USEVOXELS,
    USERDEFS_USEHIGHTILE,
    USERDEFS_USEMODELS,
    USERDEFS_GAMETYPEFLAGS,
    USERDEFS_M_GAMETYPEFLAGS,
    USERDEFS_GLOBALFLAGS,
    USERDEFS_GLOBALGAMEFLAGS,
    USERDEFS_VM_PLAYER,
    USERDEFS_VM_SPRITE,
    USERDEFS_VM_DISTANCE,
    USERDEFS_SOUNDTOGGLE,
    USERDEFS_GAMETEXT_TRACKING,
    USERDEFS_MGAMETEXT_TRACKING,
    USERDEFS_MENUTEXT_TRACKING,
    USERDEFS_MAXSPRITESONSCREEN,
    USERDEFS_SCREENAREA_X1,
    USERDEFS_SCREENAREA_Y1,
    USERDEFS_SCREENAREA_X2,
    USERDEFS_SCREENAREA_Y2,
    USERDEFS_SCREENFADE,
    USERDEFS_MENUBACKGROUND,
    USERDEFS_STATUSBARFLAGS,
    USERDEFS_STATUSBARRANGE,
    USERDEFS_STATUSBARCUSTOM,
    USERDEFS_HUDONTOP,
    USERDEFS_MENU_SLIDEBARZ,
    USERDEFS_MENU_SLIDEBARMARGIN,
    USERDEFS_MENU_SLIDECURSORZ,
    USERDEFS_GLOBAL_R,
    USERDEFS_GLOBAL_G,
    USERDEFS_GLOBAL_B,
    USERDEFS_DEFAULT_VOLUME,
    USERDEFS_DEFAULT_SKILL,
    USERDEFS_MENU_SHADEDESELECTED,
    USERDEFS_MENU_SHADEDISABLED,
    USERDEFS_MENUTEXT_ZOOM,
    USERDEFS_MENUTEXT_XSPACE,
    USERDEFS_MENUTEXT_PAL,
    USERDEFS_MENUTEXT_PALSELECTED,
    USERDEFS_MENUTEXT_PALDESELECTED,
    USERDEFS_MENUTEXT_PALDISABLED,
    USERDEFS_MENUTEXT_PALSELECTED_RIGHT,
    USERDEFS_MENUTEXT_PALDESELECTED_RIGHT,
    USERDEFS_MENUTEXT_PALDISABLED_RIGHT,
    USERDEFS_GAMETEXT_ZOOM,
    USERDEFS_GAMETEXT_XSPACE,
    USERDEFS_GAMETEXT_PAL,
    USERDEFS_GAMETEXT_PALSELECTED,
    USERDEFS_GAMETEXT_PALDESELECTED,
    USERDEFS_GAMETEXT_PALDISABLED,
    USERDEFS_GAMETEXT_PALSELECTED_RIGHT,
    USERDEFS_GAMETEXT_PALDESELECTED_RIGHT,
    USERDEFS_GAMETEXT_PALDISABLED_RIGHT,
    USERDEFS_MINITEXT_ZOOM,
    USERDEFS_MINITEXT_XSPACE,
    USERDEFS_MINITEXT_TRACKING,
    USERDEFS_MINITEXT_PAL,
    USERDEFS_MINITEXT_PALSELECTED,
    USERDEFS_MINITEXT_PALDESELECTED,
    USERDEFS_MINITEXT_PALDISABLED,
    USERDEFS_MINITEXT_PALSELECTED_RIGHT,
    USERDEFS_MINITEXT_PALDESELECTED_RIGHT,
    USERDEFS_MINITEXT_PALDISABLED_RIGHT,
    USERDEFS_MENUTITLE_PAL,
    USERDEFS_SLIDEBAR_PALSELECTED,
    USERDEFS_SLIDEBAR_PALDISABLED,
    USERDEFS_USER_MAP,
    USERDEFS_M_USER_MAP,
    USERDEFS_MUSIC_EPISODE,
    USERDEFS_MUSIC_LEVEL,
    USERDEFS_SHADOW_PAL,
    USERDEFS_MENU_SCROLLBARTILENUM,
    USERDEFS_MENU_SCROLLBARZ,
    USERDEFS_MENU_SCROLLCURSORZ,
    USERDEFS_RETURN,
    USERDEFS_USERBYTEVERSION,
    USERDEFS_AUTOSAVE,
    USERDEFS_DRAW_Y,
    USERDEFS_DRAW_YXASPECT,
    USERDEFS_FOV,
    USERDEFS_END
};

enum SectorLabel_t
{
    SECTOR_WALLPTR,
    SECTOR_WALLNUM,
    SECTOR_CEILINGZ,
    SECTOR_CEILINGZGOAL,
    SECTOR_CEILINGZVEL,
    SECTOR_FLOORZ,
    SECTOR_FLOORZGOAL,
    SECTOR_FLOORZVEL,
    SECTOR_CEILINGSTAT,
    SECTOR_FLOORSTAT,
    SECTOR_CEILINGPICNUM,
    SECTOR_CEILINGSLOPE,
    SECTOR_CEILINGSHADE,
    SECTOR_CEILINGPAL,
    SECTOR_CEILINGXPANNING,
    SECTOR_CEILINGYPANNING,
    SECTOR_FLOORPICNUM,
    SECTOR_FLOORSLOPE,
    SECTOR_FLOORSHADE,
    SECTOR_FLOORPAL,
    SECTOR_FLOORXPANNING,
    SECTOR_FLOORYPANNING,
    SECTOR_VISIBILITY,
    SECTOR_FOGPAL,
    SECTOR_LOTAG,
    SECTOR_HITAG,
    SECTOR_EXTRA,
    SECTOR_CEILINGBUNCH,
    SECTOR_FLOORBUNCH,
    SECTOR_ULOTAG,
    SECTOR_UHITAG,
    SECTOR_END
};

enum WallLabel_t
{
    WALL_X,
    WALL_Y,
    WALL_POINT2,
    WALL_NEXTWALL,
    WALL_NEXTSECTOR,
    WALL_CSTAT,
    WALL_PICNUM,
    WALL_OVERPICNUM,
    WALL_SHADE,
    WALL_PAL,
    WALL_XREPEAT,
    WALL_YREPEAT,
    WALL_XPANNING,
    WALL_YPANNING,
    WALL_LOTAG,
    WALL_HITAG,
    WALL_EXTRA,
    WALL_ULOTAG,
    WALL_UHITAG,
    WALL_BLEND,
    WALL_END
};

enum ActorLabel_t
{
    ACTOR_X,
    ACTOR_Y,
    ACTOR_Z,
    ACTOR_CSTAT,
    ACTOR_PICNUM,
    ACTOR_SHADE,
    ACTOR_PAL,
    ACTOR_CLIPDIST,
    ACTOR_DETAIL,
    ACTOR_XREPEAT,
    ACTOR_YREPEAT,
    ACTOR_XOFFSET,
    ACTOR_YOFFSET,
    ACTOR_SECTNUM,
    ACTOR_STATNUM,
    ACTOR_ANG,
    ACTOR_OWNER,
    ACTOR_XVEL,
    ACTOR_YVEL,
    ACTOR_ZVEL,
    ACTOR_LOTAG,
    ACTOR_HITAG,
    ACTOR_EXTRA,
    ACTOR_ULOTAG,
    ACTOR_UHITAG,
    ACTOR_STRUCT_BEGIN,
    ACTOR_HTCGG = ACTOR_STRUCT_BEGIN,
    ACTOR_HTPICNUM,
    ACTOR_HTANG,
    ACTOR_HTEXTRA,
    ACTOR_HTOWNER,
    ACTOR_HTMOVFLAG,
    ACTOR_HTUMOVFLAG,
    ACTOR_HTTEMPANG,
    ACTOR_HTSTAYPUT,
    ACTOR_HTDISPICNUM,
    ACTOR_HTTIMETOSLEEP,
    ACTOR_HTFLOORZ,
    ACTOR_HTCEILINGZ,
    ACTOR_HTLASTVX,
    ACTOR_HTLASTVY,
    ACTOR_HTBPOSX,
    ACTOR_HTBPOSY,
    ACTOR_HTBPOSZ,
    ACTOR_HTG_T,
    ACTOR_HTFLAGS,
    ACTOR_SPRITEEXT_BEGIN,
    ACTOR_ANGOFF = ACTOR_SPRITEEXT_BEGIN,
    ACTOR_PITCH,
    ACTOR_ROLL,
    ACTOR_MDXOFF,
    ACTOR_MDYOFF,
    ACTOR_MDZOFF,
    ACTOR_MDFLAGS,
    ACTOR_XPANNING,
    ACTOR_YPANNING,
    ACTOR_ALPHA,
    ACTOR_ISVALID,
    ACTOR_END
};

enum InputLabel_t
{
    INPUT_AVEL,
    INPUT_Q16AVEL,
    INPUT_HORZ,
    INPUT_Q16HORZ,
    INPUT_FVEL,
    INPUT_SVEL,
    INPUT_BITS,
    INPUT_EXTBITS,
    INPUT_END
};

enum TileDataLabel_t
{
    TILEDATA_XSIZE,
    TILEDATA_YSIZE,
    TILEDATA_ANIMFRAMES,
    TILEDATA_XOFFSET,
    TILEDATA_YOFFSET,
    TILEDATA_ANIMSPEED,
    TILEDATA_ANIMTYPE,
    TILEDATA_GAMEFLAGS,
    TILEDATA_END
};

enum PalDataLabel_t
{
    PALDATA_NOFLOORPAL,
    PALDATA_DUMMY, // so the hash table is size 1. remove when another member is added.
    PALDATA_END
};

#endif
// KEEPINSYNC lunatic/con_lang.lua
enum ProjectileLabel_t
{
    PROJ_WORKSLIKE,  // 0
    PROJ_SPAWNS,
    PROJ_SXREPEAT,
    PROJ_SYREPEAT,
    PROJ_SOUND,
    PROJ_ISOUND,  // 5
    PROJ_VEL,
    PROJ_EXTRA,
    PROJ_DECAL,
    PROJ_TRAIL,
    PROJ_TXREPEAT,  // 10
    PROJ_TYREPEAT,
    PROJ_TOFFSET,
    PROJ_TNUM,
    PROJ_DROP,
    PROJ_CSTAT,  // 15
    PROJ_CLIPDIST,
    PROJ_SHADE,
    PROJ_XREPEAT,
    PROJ_YREPEAT,
    PROJ_PAL,  // 20
    PROJ_EXTRA_RAND,
    PROJ_HITRADIUS,
    PROJ_MOVECNT,
    PROJ_OFFSET,
    PROJ_BOUNCES,  // 25
    PROJ_BSOUND,
    PROJ_RANGE,
    PROJ_FLASH_COLOR,
    PROJ_USERDATA,
    PROJ_END
};
#if !defined LUNATIC

enum IterationTypes_t
{
    ITER_ALLSPRITES,
    ITER_ALLSECTORS,
    ITER_ALLWALLS,
    ITER_ACTIVELIGHTS,
    ITER_DRAWNSPRITES,
    // ---
    ITER_SPRITESOFSECTOR,
    ITER_SPRITESOFSTATUS,
    ITER_WALLSOFSECTOR,
    ITER_LOOPOFWALL,
    ITER_RANGE,
    ITER_ALLSPRITESBYSTAT,
    ITER_ALLSPRITESBYSECT,
    ITER_END
};

// most keywords have opcodes but some opcodes don't have keywords
enum ScriptKeywords_t
{
    CON_IFVARA_GLOBAL,
    CON_IFVARAE_GLOBAL,
    CON_IFVARAND_GLOBAL,
    CON_IFVARB_GLOBAL,
    CON_IFVARBE_GLOBAL,
    CON_IFVARBOTH_GLOBAL,
    CON_IFVARE_GLOBAL,
    CON_IFVAREITHER_GLOBAL,
    CON_IFVARG_GLOBAL,
    CON_IFVARGE_GLOBAL,
    CON_IFVARL_GLOBAL,
    CON_IFVARLE_GLOBAL,
    CON_IFVARN_GLOBAL,
    CON_IFVAROR_GLOBAL,
    CON_IFVARXOR_GLOBAL,

    CON_ADDVAR_GLOBAL,
    CON_ANDVAR_GLOBAL,
    CON_DIVVAR_GLOBAL,
    CON_MODVAR_GLOBAL,
    CON_MULVAR_GLOBAL,
    CON_ORVAR_GLOBAL,
    CON_RANDVAR_GLOBAL,
    CON_SETVAR_GLOBAL,
    CON_SHIFTVARL_GLOBAL,
    CON_SHIFTVARR_GLOBAL,
    CON_SUBVAR_GLOBAL,
    CON_WHILEVARL_GLOBAL,
    CON_WHILEVARN_GLOBAL,
    CON_XORVAR_GLOBAL,

    CON_IFVARA_PLAYER,
    CON_IFVARAE_PLAYER,
    CON_IFVARAND_PLAYER,
    CON_IFVARB_PLAYER,
    CON_IFVARBE_PLAYER,
    CON_IFVARBOTH_PLAYER,
    CON_IFVARE_PLAYER,
    CON_IFVAREITHER_PLAYER,
    CON_IFVARG_PLAYER,
    CON_IFVARGE_PLAYER,
    CON_IFVARL_PLAYER,
    CON_IFVARLE_PLAYER,
    CON_IFVARN_PLAYER,
    CON_IFVAROR_PLAYER,
    CON_IFVARXOR_PLAYER,

    CON_ADDVAR_PLAYER,
    CON_ANDVAR_PLAYER,
    CON_DIVVAR_PLAYER,
    CON_MODVAR_PLAYER,
    CON_MULVAR_PLAYER,
    CON_ORVAR_PLAYER,
    CON_RANDVAR_PLAYER,
    CON_SETVAR_PLAYER,
    CON_SHIFTVARL_PLAYER,
    CON_SHIFTVARR_PLAYER,
    CON_SUBVAR_PLAYER,
    CON_WHILEVARL_PLAYER,
    CON_WHILEVARN_PLAYER,
    CON_XORVAR_PLAYER,

    CON_IFVARA_ACTOR,
    CON_IFVARAE_ACTOR,
    CON_IFVARAND_ACTOR,
    CON_IFVARB_ACTOR,
    CON_IFVARBE_ACTOR,
    CON_IFVARBOTH_ACTOR,
    CON_IFVARE_ACTOR,
    CON_IFVAREITHER_ACTOR,
    CON_IFVARG_ACTOR,
    CON_IFVARGE_ACTOR,
    CON_IFVARL_ACTOR,
    CON_IFVARLE_ACTOR,
    CON_IFVARN_ACTOR,
    CON_IFVAROR_ACTOR,
    CON_IFVARXOR_ACTOR,

    CON_ADDVAR_ACTOR,
    CON_ANDVAR_ACTOR,
    CON_DIVVAR_ACTOR,
    CON_MODVAR_ACTOR,
    CON_MULVAR_ACTOR,
    CON_ORVAR_ACTOR,
    CON_RANDVAR_ACTOR,
    CON_SETVAR_ACTOR,
    CON_SHIFTVARL_ACTOR,
    CON_SHIFTVARR_ACTOR,
    CON_SUBVAR_ACTOR,
    CON_WHILEVARL_ACTOR,
    CON_WHILEVARN_ACTOR,
    CON_XORVAR_ACTOR,

    CON_IFVARVARA,
    CON_IFVARVARAE,
    CON_IFVARVARAND,
    CON_IFVARVARB,
    CON_IFVARVARBE,
    CON_IFVARVARBOTH,
    CON_IFVARVARE,
    CON_IFVARVAREITHER,
    CON_IFVARVARG,
    CON_IFVARVARGE,
    CON_IFVARVARL,
    CON_IFVARVARLE,
    CON_IFVARVARN,
    CON_IFVARVAROR,
    CON_IFVARVARXOR,

    CON_ADDVARVAR,
    CON_ANDVARVAR,
    CON_DIVVARVAR,
    CON_MODVARVAR,
    CON_MULVARVAR,
    CON_ORVARVAR,
    CON_RANDVARVAR,
    CON_SETVARVAR,
    CON_SHIFTVARVARL,
    CON_SHIFTVARVARR,
    CON_SUBVARVAR,
    CON_WHILEVARVARL,
    CON_WHILEVARVARN,
    CON_XORVARVAR,

    CON_IFVARA,
    CON_IFVARAE,
    CON_IFVARAND,
    CON_IFVARB,
    CON_IFVARBE,
    CON_IFVARBOTH,
    CON_IFVARE,
    CON_IFVAREITHER,
    CON_IFVARG,
    CON_IFVARGE,
    CON_IFVARL,
    CON_IFVARLE,
    CON_IFVARN,
    CON_IFVAROR,
    CON_IFVARXOR,

    CON_ADDVAR,
    CON_ANDVAR,
    CON_DIVVAR,
    CON_MODVAR,
    CON_MULVAR,
    CON_ORVAR,
    CON_RANDVAR,
    CON_SETVAR,
    CON_SHIFTVARL,
    CON_SHIFTVARR,
    CON_SUBVAR,
    CON_WHILEVARL,
    CON_WHILEVARN,
    CON_XORVAR,

    CON_ELSE,
    CON_ENDA,
    CON_ENDEVENT,
    CON_ENDS,
    CON_ENDSWITCH,
    CON_LEFTBRACE,
    CON_RIGHTBRACE,
    CON_STATE,

    CON_SETACTOR,
    CON_SETACTORSTRUCT,
    CON_SETACTORVAR,
    CON_SETARRAY,
    CON_SETPLAYER,
    CON_SETPLAYERVAR,
    CON_SETPROJECTILE,
    CON_SETSECTOR,
    CON_SETSPRITEEXT,
    CON_SETSPRITESTRUCT,
    CON_SETTHISPROJECTILE,
    CON_SETTSPR,
    CON_SETUSERDEF,
    CON_SETWALL,

    CON_GETACTOR,
    CON_GETACTORSTRUCT,
    CON_GETACTORVAR,
    CON_GETANGLE,
    CON_GETPLAYER,
    CON_GETPLAYERVAR,
    CON_GETPROJECTILE,
    CON_GETSECTOR,
    CON_GETSPRITEEXT,
    CON_GETSPRITESTRUCT,
    CON_GETTSPR,
    CON_GETUSERDEF,
    CON_GETWALL,

    CON_ACTION,
    CON_ACTIVATE,
    CON_ACTIVATEBYSECTOR,
    CON_ACTIVATECHEAT,
    CON_ACTORSOUND,
    CON_ADDAMMO,
    CON_ADDINVENTORY,
    CON_ADDKILLS,
    CON_ADDLOGVAR,
    CON_ADDPHEALTH,
    CON_ADDSTRENGTH,
    CON_ADDWEAPON,
    CON_AI,
    CON_ANGOFF,
    CON_BREAK,
    CON_CACTOR,
    CON_CALCHYPOTENUSE,
    CON_CANSEE,
    CON_CANSEESPR,
    CON_CHANGESPRITESECT,
    CON_CHANGESPRITESTAT,
    CON_CHECKACTIVATORMOTION,
    CON_CHECKAVAILINVEN,
    CON_CHECKAVAILWEAPON,
    CON_CLAMP,
    CON_CLEARMAPSTATE,
    CON_CLIPDIST,
    CON_CLIPMOVE,
    CON_CLIPMOVENOSLIDE,
    CON_CMENU,
    CON_COPY,
    CON_COS,
    CON_COUNT,
    CON_CSTAT,
    CON_CSTATOR,
    CON_DEBRIS,
    CON_DEBUG,
    CON_DIGITALNUMBER,
    CON_DIGITALNUMBERZ,
    CON_DISPLAYRAND,
    CON_DIST,
    CON_DIVR,
    CON_DIVRU,
    CON_DIVSCALE,
    CON_DISPLAYRANDVAR,
    CON_DISPLAYRANDVARVAR,
    CON_DRAGPOINT,
    CON_DRAWLINE256,
    CON_DRAWLINERGB,
    CON_ECHO,
    CON_ENDOFGAME,
    CON_ENDOFLEVEL,
    CON_EQSPAWN,
    CON_ESHOOT,
    CON_ESPAWN,
    CON_EVENTLOADACTOR,
    CON_EZSHOOT,
    CON_FALL,
    CON_FINDNEARACTOR,
    CON_FINDNEARACTOR3D,
    CON_FINDNEARACTORZ,
    CON_FINDNEARSPRITE,
    CON_FINDNEARSPRITE3D,
    CON_FINDNEARSPRITEZ,
    CON_FINDOTHERPLAYER,
    CON_FINDPLAYER,
    CON_FLASH,
    CON_FOR,
    CON_GAMETEXT,
    CON_GAMETEXTZ,
    CON_GETACTORANGLE,
    CON_GETANGLETOTARGET,
    CON_GETARRAYSIZE,
    CON_GETCEILZOFSLOPE,
    CON_GETCLOSESTCOL,
    CON_GETCURRADDRESS,
    CON_GETFLORZOFSLOPE,
    CON_GETINCANGLE,
    CON_GETINPUT,
    CON_GETKEYNAME,
    CON_GETLASTPAL,
    CON_GETMUSICPOSITION,
    CON_GETPLAYERANGLE,
    CON_GETPNAME,
    CON_GETTEXTURECEILING,
    CON_GETTEXTUREFLOOR,
    CON_GETTHISPROJECTILE,
    CON_GETTICKS,
    CON_GETTILEDATA,
    CON_GETTIMEDATE,
    CON_GETZRANGE,
    CON_GLOBALSOUND,
    CON_GMAXAMMO,
    CON_GUNIQHUDID,
    CON_GUTS,
    CON_HEADSPRITESECT,
    CON_HEADSPRITESTAT,
    CON_HITRADIUS,
    CON_HITSCAN,
    CON_IFACTION,
    CON_IFACTIONCOUNT,
    CON_IFACTOR,
    CON_IFACTORNOTSTAYPUT,
    CON_IFACTORSOUND,
    CON_IFAI,
    CON_IFANGDIFFL,
    CON_IFAWAYFROMWALL,
    CON_IFBULLETNEAR,
    CON_IFCANSEE,
    CON_IFCANSEETARGET,
    CON_IFCANSHOOTTARGET,
    CON_IFCEILINGDISTL,
    CON_IFCLIENT,
    CON_IFCOUNT,
    CON_IFCUTSCENE,
    CON_IFDEAD,
    CON_IFFLOORDISTL,
    CON_IFGAPZL,
    CON_IFGOTWEAPONCE,
    CON_IFHITSPACE,
    CON_IFHITWEAPON,
    CON_IFINOUTERSPACE,
    CON_IFINSPACE,
    CON_IFINWATER,
    CON_IFMOVE,
    CON_IFMULTIPLAYER,
    CON_IFNOSOUNDS,
    CON_IFNOTMOVING,
    CON_IFONWATER,
    CON_IFOUTSIDE,
    CON_IFP,
    CON_IFPDISTG,
    CON_IFPDISTL,
    CON_IFPHEALTHL,
    CON_IFPINVENTORY,
    CON_IFPLAYBACKON,
    CON_IFPLAYERSL,
    CON_IFRESPAWN,
    CON_IFRND,
    CON_IFSERVER,
    CON_IFSOUND,
    CON_IFSPAWNEDBY,
    CON_IFSPRITEPAL,
    CON_IFSQUISHED,
    CON_IFSTRENGTH,
    CON_IFWASWEAPON,
    CON_INITTIMER,
    CON_INSERTSPRITEQ,
    CON_INV,
    CON_JUMP,
    CON_KILLIT,
    CON_KLABS,
    CON_LDIST,
    CON_LINEINTERSECT,
    CON_LOADMAPSTATE,
    CON_LOCKPLAYER,
    CON_LOTSOFGLASS,
    CON_MAIL,
    CON_MIKESND,
    CON_MINITEXT,
    CON_MONEY,
    CON_MOVE,
    CON_MOVESECTOR,
    CON_MOVESPRITE,
    CON_MULSCALE,
    CON_MUSIC,
    CON_MYOS,
    CON_MYOSPAL,
    CON_MYOSPALX,
    CON_MYOSX,
    CON_NEARTAG,
    CON_NEXTSECTORNEIGHBORZ,
    CON_NEXTSPRITESECT,
    CON_NEXTSPRITESTAT,
    CON_NULLOP,
    CON_OPERATE,
    CON_OPERATEACTIVATORS,
    CON_OPERATEMASTERSWITCHES,
    CON_OPERATERESPAWNS,
    CON_OPERATESECTORS,
    CON_PALFROM,
    CON_PAPER,
    CON_PKICK,
    CON_PRECACHE,
    CON_PRELOADTRACKSLOTFORSWAP,
    CON_PREVSPRITESECT,
    CON_PREVSPRITESTAT,
    CON_PSTOMP,
    CON_QGETSYSSTR,
    CON_QSPAWN,
    CON_QSPRINTF,
    CON_QSTRCAT,
    CON_QSTRCMP,
    CON_QSTRCPY,
    CON_QSTRDIM,
    CON_QSTRLEN,
    CON_QSTRNCAT,
    CON_QSUBSTR,
    CON_QUAKE,
    CON_QUOTE,
    CON_RAYINTERSECT,
    CON_READARRAYFROMFILE,
    CON_READGAMEVAR,
    CON_REDEFINEQUOTE,
    CON_RESETACTIONCOUNT,
    CON_RESETCOUNT,
    CON_RESETPLAYER,
    CON_RESETPLAYERFLAGS,
    CON_RESIZEARRAY,
    CON_RESPAWNHITAG,
    CON_RETURN,
    CON_ROTATEPOINT,
    CON_ROTATESPRITE,
    CON_ROTATESPRITE16,
    CON_ROTATESPRITEA,
    CON_SAVE,
    CON_SAVEGAMEVAR,
    CON_SAVEMAPSTATE,
    CON_SAVENN,
    CON_SCALEVAR,
    CON_SCREENPAL,
    CON_SCREENSOUND,
    CON_SCREENTEXT,
    CON_SECTCLEARINTERPOLATION,
    CON_SECTGETHITAG,
    CON_SECTGETLOTAG,
    CON_SECTOROFWALL,
    CON_SECTSETINTERPOLATION,
    CON_SETACTORANGLE,
    CON_SETACTORSOUNDPITCH,
    CON_SETASPECT,
    CON_SETGAMEPALETTE,
    CON_SETINPUT,
    CON_SETMUSICPOSITION,
    CON_SETPLAYERANGLE,
    CON_SETSPRITE,
    CON_SETTILEDATA,
    CON_SHADETO,
    CON_SHOOT,
    CON_SHOWVIEW,
    CON_SHOWVIEWQ16,
    CON_SHOWVIEWQ16UNBIASED,
    CON_SHOWVIEWUNBIASED,
    CON_SIN,
    CON_SIZEAT,
    CON_SIZETO,
    CON_SLEEPTIME,
    CON_SMAXAMMO,
    CON_SOUND,
    CON_SOUNDONCE,
    CON_SPAWN,
    CON_SPAWNCEILINGGLASS,
    CON_SPAWNWALLGLASS,
    CON_SPAWNWALLSTAINEDGLASS,
    CON_SPGETHITAG,
    CON_SPGETLOTAG,
    CON_SPRITEFLAGS,
    CON_SPRITEPAL,
    CON_SQRT,
    CON_SSP,
    CON_STARTCUTSCENE,
    CON_STARTLEVEL,
    CON_STARTSCREEN,
    CON_STARTTRACK,
    CON_STARTTRACKSLOT,
    CON_STOPACTORSOUND,
    CON_STOPALLMUSIC,
    CON_STOPALLSOUNDS,
    CON_STOPSOUND,
    CON_STRENGTH,
    CON_SWAPARRAYS,
    CON_SWAPTRACKSLOT,
    CON_SWITCH,
    CON_TIME,
    CON_TIP,
    CON_TOSSWEAPON,
    CON_UPDATESECTOR,
    CON_UPDATESECTORZ,
    CON_USERQUOTE,
    CON_WACKPLAYER,
    CON_WRITEARRAYTOFILE,
    CON_ZSHOOT,

    CON_OPCODE_END,

    // these are the keywords that don't have instructions written into the bytecode
    CON_ACTOR,
    CON_APPENDEVENT,
    CON_BETANAME,
    CON_CASE,
    CON_CHEATKEYS,
    CON_DAMAGEEVENTTILE,
    CON_DAMAGEEVENTTILERANGE,
    CON_DEFAULT,
    CON_DEFINE,
    CON_DEFINECHEAT,
    CON_DEFINEGAMEFUNCNAME,
    CON_DEFINEGAMETYPE,
    CON_DEFINELEVELNAME,
    CON_DEFINEPROJECTILE,
    CON_DEFINEQUOTE,
    CON_DEFINESKILLNAME,
    CON_DEFINESOUND,
    CON_DEFINEVOLUMEFLAGS,
    CON_DEFINEVOLUMENAME,
    CON_DEFSTATE,
    CON_DYNAMICREMAP,
    CON_DYNAMICSOUNDREMAP,
    CON_ENHANCED,
    CON_GAMEARRAY,
    CON_GAMESTARTUP,
    CON_GAMEVAR,
    CON_INCLUDE,
    CON_INCLUDEDEFAULT,
    CON_ONEVENT,
    CON_SCRIPTSIZE,
    CON_SETCFGNAME,
    CON_SETDEFNAME,
    CON_SETGAMENAME,
    CON_SPRITENOPAL,
    CON_SPRITENOSHADE,
    CON_SPRITENVG,
    CON_SPRITESHADOW,
    CON_UNDEFINECHEAT,
    CON_UNDEFINEGAMEFUNC,
    CON_UNDEFINELEVEL,
    CON_UNDEFINESKILL,
    CON_UNDEFINEVOLUME,
    CON_USERACTOR,

    CON_END
};

// KEEPINSYNC with the keyword list in lunatic/con_lang.lua

#endif

#ifdef __cplusplus
}
#endif

#endif // gamedef_h_
