//-------------------------------------------------------------------------
/*
Copyright (C) 2005 - EDuke32 team

This file is part of EDuke32

EDuke32 is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License version 2
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
//-------------------------------------------------------------------------

// Maybe this should be called "hacks.c" instead of "namesdyn.c"...

#include "build.h"
#include "duke3d.h"
#include "compat.h"

unsigned short SECTOREFFECTOR = 1;
unsigned short ACTIVATOR = 2;
unsigned short TOUCHPLATE = 3;
unsigned short ACTIVATORLOCKED = 4;
unsigned short MUSICANDSFX = 5;
unsigned short LOCATORS = 6;
unsigned short CYCLER = 7;
unsigned short MASTERSWITCH = 8;
unsigned short RESPAWN = 9;
unsigned short GPSPEED = 10;
unsigned short FOF = 13;
unsigned short ARROW = 20;
unsigned short FIRSTGUNSPRITE = 21;
unsigned short CHAINGUNSPRITE = 22;
unsigned short RPGSPRITE = 23;
unsigned short FREEZESPRITE = 24;
unsigned short SHRINKERSPRITE = 25;
unsigned short HEAVYHBOMB = 26;
unsigned short TRIPBOMBSPRITE = 27;
unsigned short SHOTGUNSPRITE = 28;
unsigned short DEVISTATORSPRITE = 29;
unsigned short HEALTHBOX = 30;
unsigned short AMMOBOX = 31;
unsigned short GROWSPRITEICON = 32;
unsigned short INVENTORYBOX = 33;
unsigned short FREEZEAMMO = 37;
unsigned short AMMO = 40;
unsigned short BATTERYAMMO = 41;
unsigned short DEVISTATORAMMO = 42;
unsigned short RPGAMMO = 44;
unsigned short GROWAMMO = 45;
unsigned short CRYSTALAMMO = 46;
unsigned short HBOMBAMMO = 47;
unsigned short AMMOLOTS = 48;
unsigned short SHOTGUNAMMO = 49;
unsigned short COLA = 51;
unsigned short SIXPAK = 52;
unsigned short FIRSTAID = 53;
unsigned short SHIELD = 54;
unsigned short STEROIDS = 55;
unsigned short AIRTANK = 56;
unsigned short JETPACK = 57;
unsigned short HEATSENSOR = 59;
unsigned short ACCESSCARD = 60;
unsigned short BOOTS = 61;
unsigned short MIRRORBROKE = 70;
unsigned short CLOUDYOCEAN = 78;
unsigned short CLOUDYSKIES = 79;
unsigned short MOONSKY1 = 80;
unsigned short MOONSKY2 = 81;
unsigned short MOONSKY3 = 82;
unsigned short MOONSKY4 = 83;
unsigned short BIGORBIT1 = 84;
unsigned short BIGORBIT2 = 85;
unsigned short BIGORBIT3 = 86;
unsigned short BIGORBIT4 = 87;
unsigned short BIGORBIT5 = 88;
unsigned short LA = 89;
unsigned short REDSKY1 = 98;
unsigned short REDSKY2 = 99;
unsigned short ATOMICHEALTH = 100;
unsigned short TECHLIGHT2 = 120;
unsigned short TECHLIGHTBUST2 = 121;
unsigned short TECHLIGHT4 = 122;
unsigned short TECHLIGHTBUST4 = 123;
unsigned short WALLLIGHT4 = 124;
unsigned short WALLLIGHTBUST4 = 125;
unsigned short ACCESSSWITCH = 130;
unsigned short SLOTDOOR = 132;
unsigned short LIGHTSWITCH = 134;
unsigned short SPACEDOORSWITCH = 136;
unsigned short SPACELIGHTSWITCH = 138;
unsigned short FRANKENSTINESWITCH = 140;
unsigned short NUKEBUTTON = 142;
unsigned short MULTISWITCH = 146;
unsigned short DOORTILE5 = 150;
unsigned short DOORTILE6 = 151;
unsigned short DOORTILE1 = 152;
unsigned short DOORTILE2 = 153;
unsigned short DOORTILE3 = 154;
unsigned short DOORTILE4 = 155;
unsigned short DOORTILE7 = 156;
unsigned short DOORTILE8 = 157;
unsigned short DOORTILE9 = 158;
unsigned short DOORTILE10 = 159;
unsigned short DOORSHOCK = 160;
unsigned short DIPSWITCH = 162;
unsigned short DIPSWITCH2 = 164;
unsigned short TECHSWITCH = 166;
unsigned short DIPSWITCH3 = 168;
unsigned short ACCESSSWITCH2 = 170;
unsigned short REFLECTWATERTILE = 180;
unsigned short FLOORSLIME = 200;
unsigned short BIGFORCE = 230;
unsigned short EPISODE = 247;
unsigned short MASKWALL9 = 255;
unsigned short W_LIGHT = 260;
unsigned short SCREENBREAK1 = 263;
unsigned short SCREENBREAK2 = 264;
unsigned short SCREENBREAK3 = 265;
unsigned short SCREENBREAK4 = 266;
unsigned short SCREENBREAK5 = 267;
unsigned short SCREENBREAK6 = 268;
unsigned short SCREENBREAK7 = 269;
unsigned short SCREENBREAK8 = 270;
unsigned short SCREENBREAK9 = 271;
unsigned short SCREENBREAK10 = 272;
unsigned short SCREENBREAK11 = 273;
unsigned short SCREENBREAK12 = 274;
unsigned short SCREENBREAK13 = 275;
unsigned short MASKWALL1 = 285;
unsigned short W_TECHWALL1 = 293;
unsigned short W_TECHWALL2 = 297;
unsigned short W_TECHWALL15 = 299;
unsigned short W_TECHWALL3 = 301;
unsigned short W_TECHWALL4 = 305;
unsigned short W_TECHWALL10 = 306;
unsigned short W_TECHWALL16 = 307;
unsigned short WATERTILE2 = 336;
unsigned short BPANNEL1 = 341;
unsigned short PANNEL1 = 342;
unsigned short PANNEL2 = 343;
unsigned short WATERTILE = 344;
unsigned short STATIC = 351;
unsigned short W_SCREENBREAK = 357;
unsigned short W_HITTECHWALL3 = 360;
unsigned short W_HITTECHWALL4 = 361;
unsigned short W_HITTECHWALL2 = 362;
unsigned short W_HITTECHWALL1 = 363;
unsigned short MASKWALL10 = 387;
unsigned short MASKWALL11 = 391;
unsigned short DOORTILE22 = 395;
unsigned short FANSPRITE = 407;
unsigned short FANSPRITEBROKE = 411;
unsigned short FANSHADOW = 412;
unsigned short FANSHADOWBROKE = 416;
unsigned short DOORTILE18 = 447;
unsigned short DOORTILE19 = 448;
unsigned short DOORTILE20 = 449;
unsigned short SATELLITE = 489;
unsigned short VIEWSCREEN2 = 499;
unsigned short VIEWSCREENBROKE = 501;
unsigned short VIEWSCREEN = 502;
unsigned short GLASS = 503;
unsigned short GLASS2 = 504;
unsigned short STAINGLASS1 = 510;
unsigned short MASKWALL5 = 514;
unsigned short SATELITE = 516;
unsigned short FUELPOD = 517;
unsigned short SLIMEPIPE = 538;
unsigned short CRACK1 = 546;
unsigned short CRACK2 = 547;
unsigned short CRACK3 = 548;
unsigned short CRACK4 = 549;
unsigned short FOOTPRINTS = 550;
unsigned short DOMELITE = 551;
unsigned short CAMERAPOLE = 554;
unsigned short CHAIR1 = 556;
unsigned short CHAIR2 = 557;
unsigned short BROKENCHAIR = 559;
unsigned short MIRROR = 560;
unsigned short WATERFOUNTAIN = 563;
unsigned short WATERFOUNTAINBROKE = 567;
unsigned short FEMMAG1 = 568;
unsigned short TOILET = 569;
unsigned short STALL = 571;
unsigned short STALLBROKE = 573;
unsigned short FEMMAG2 = 577;
unsigned short REACTOR2 = 578;
unsigned short REACTOR2BURNT = 579;
unsigned short REACTOR2SPARK = 580;
unsigned short GRATE1 = 595;
unsigned short BGRATE1 = 596;
unsigned short SOLARPANNEL = 602;
unsigned short NAKED1 = 603;
unsigned short ANTENNA = 607;
unsigned short MASKWALL12 = 609;
unsigned short TOILETBROKE = 615;
unsigned short PIPE2 = 616;
unsigned short PIPE1B = 617;
unsigned short PIPE3 = 618;
unsigned short PIPE1 = 619;
unsigned short CAMERA1 = 621;
unsigned short BRICK = 626;
unsigned short SPLINTERWOOD = 630;
unsigned short PIPE2B = 633;
unsigned short BOLT1 = 634;
unsigned short W_NUMBERS = 640;
unsigned short WATERDRIP = 660;
unsigned short WATERBUBBLE = 661;
unsigned short WATERBUBBLEMAKER = 662;
unsigned short W_FORCEFIELD = 663;
unsigned short VACUUM = 669;
unsigned short FOOTPRINTS2 = 672;
unsigned short FOOTPRINTS3 = 673;
unsigned short FOOTPRINTS4 = 674;
unsigned short EGG = 675;
unsigned short SCALE = 678;
unsigned short CHAIR3 = 680;
unsigned short CAMERALIGHT = 685;
unsigned short MOVIECAMERA = 686;
unsigned short IVUNIT = 689;
unsigned short POT1 = 694;
unsigned short POT2 = 695;
unsigned short POT3 = 697;
unsigned short PIPE3B = 700;
unsigned short WALLLIGHT3 = 701;
unsigned short WALLLIGHTBUST3 = 702;
unsigned short WALLLIGHT1 = 703;
unsigned short WALLLIGHTBUST1 = 704;
unsigned short WALLLIGHT2 = 705;
unsigned short WALLLIGHTBUST2 = 706;
unsigned short LIGHTSWITCH2 = 712;
unsigned short WAITTOBESEATED = 716;
unsigned short DOORTILE14 = 717;
unsigned short STATUE = 753;
unsigned short MIKE = 762;
unsigned short VASE = 765;
unsigned short SUSHIPLATE1 = 768;
unsigned short SUSHIPLATE2 = 769;
unsigned short SUSHIPLATE3 = 774;
unsigned short SUSHIPLATE4 = 779;
unsigned short DOORTILE16 = 781;
unsigned short SUSHIPLATE5 = 792;
unsigned short OJ = 806;
unsigned short MASKWALL13 = 830;
unsigned short HURTRAIL = 859;
unsigned short POWERSWITCH1 = 860;
unsigned short LOCKSWITCH1 = 862;
unsigned short POWERSWITCH2 = 864;
unsigned short ATM = 867;
unsigned short STATUEFLASH = 869;
unsigned short ATMBROKE = 888;
unsigned short BIGHOLE2 = 893;
unsigned short STRIPEBALL = 901;
unsigned short QUEBALL = 902;
unsigned short POCKET = 903;
unsigned short WOODENHORSE = 904;
unsigned short TREE1 = 908;
unsigned short TREE2 = 910;
unsigned short CACTUS = 911;
unsigned short MASKWALL2 = 913;
unsigned short MASKWALL3 = 914;
unsigned short MASKWALL4 = 915;
unsigned short FIREEXT = 916;
unsigned short TOILETWATER = 921;
unsigned short NEON1 = 925;
unsigned short NEON2 = 926;
unsigned short CACTUSBROKE = 939;
unsigned short BOUNCEMINE = 940;
unsigned short BROKEFIREHYDRENT = 950;
unsigned short BOX = 951;
unsigned short BULLETHOLE = 952;
unsigned short BOTTLE1 = 954;
unsigned short BOTTLE2 = 955;
unsigned short BOTTLE3 = 956;
unsigned short BOTTLE4 = 957;
unsigned short FEMPIC5 = 963;
unsigned short FEMPIC6 = 964;
unsigned short FEMPIC7 = 965;
unsigned short HYDROPLANT = 969;
unsigned short OCEANSPRITE1 = 971;
unsigned short OCEANSPRITE2 = 972;
unsigned short OCEANSPRITE3 = 973;
unsigned short OCEANSPRITE4 = 974;
unsigned short OCEANSPRITE5 = 975;
unsigned short GENERICPOLE = 977;
unsigned short CONE = 978;
unsigned short HANGLIGHT = 979;
unsigned short HYDRENT = 981;
unsigned short MASKWALL14 = 988;
unsigned short TIRE = 990;
unsigned short PIPE5 = 994;
unsigned short PIPE6 = 995;
unsigned short PIPE4 = 996;
unsigned short PIPE4B = 997;
unsigned short BROKEHYDROPLANT = 1003;
unsigned short PIPE5B = 1005;
unsigned short NEON3 = 1007;
unsigned short NEON4 = 1008;
unsigned short NEON5 = 1009;
unsigned short BOTTLE5 = 1012;
unsigned short BOTTLE6 = 1013;
unsigned short BOTTLE8 = 1014;
unsigned short SPOTLITE = 1020;
unsigned short HANGOOZ = 1022;
unsigned short MASKWALL15 = 1024;
unsigned short BOTTLE7 = 1025;
unsigned short HORSEONSIDE = 1026;
unsigned short GLASSPIECES = 1031;
unsigned short HORSELITE = 1034;
unsigned short DONUTS = 1045;
unsigned short NEON6 = 1046;
unsigned short MASKWALL6 = 1059;
unsigned short CLOCK = 1060;
unsigned short RUBBERCAN = 1062;
unsigned short BROKENCLOCK = 1067;
unsigned short PLUG = 1069;
unsigned short OOZFILTER = 1079;
unsigned short FLOORPLASMA = 1082;
unsigned short REACTOR = 1088;
unsigned short REACTORSPARK = 1092;
unsigned short REACTORBURNT = 1096;
unsigned short DOORTILE15 = 1102;
unsigned short HANDSWITCH = 1111;
unsigned short CIRCLEPANNEL = 1113;
unsigned short CIRCLEPANNELBROKE = 1114;
unsigned short PULLSWITCH = 1122;
unsigned short MASKWALL8 = 1124;
unsigned short BIGHOLE = 1141;
unsigned short ALIENSWITCH = 1142;
unsigned short DOORTILE21 = 1144;
unsigned short HANDPRINTSWITCH = 1155;
unsigned short BOTTLE10 = 1157;
unsigned short BOTTLE11 = 1158;
unsigned short BOTTLE12 = 1159;
unsigned short BOTTLE13 = 1160;
unsigned short BOTTLE14 = 1161;
unsigned short BOTTLE15 = 1162;
unsigned short BOTTLE16 = 1163;
unsigned short BOTTLE17 = 1164;
unsigned short BOTTLE18 = 1165;
unsigned short BOTTLE19 = 1166;
unsigned short DOORTILE17 = 1169;
unsigned short MASKWALL7 = 1174;
unsigned short JAILBARBREAK = 1175;
unsigned short DOORTILE11 = 1178;
unsigned short DOORTILE12 = 1179;
unsigned short VENDMACHINE = 1212;
unsigned short VENDMACHINEBROKE = 1214;
unsigned short COLAMACHINE = 1215;
unsigned short COLAMACHINEBROKE = 1217;
unsigned short CRANEPOLE = 1221;
unsigned short CRANE = 1222;
unsigned short BARBROKE = 1225;
unsigned short BLOODPOOL = 1226;
unsigned short NUKEBARREL = 1227;
unsigned short NUKEBARRELDENTED = 1228;
unsigned short NUKEBARRELLEAKED = 1229;
unsigned short CANWITHSOMETHING = 1232;
unsigned short MONEY = 1233;
unsigned short BANNER = 1236;
unsigned short EXPLODINGBARREL = 1238;
unsigned short EXPLODINGBARREL2 = 1239;
unsigned short FIREBARREL = 1240;
unsigned short SEENINE = 1247;
unsigned short SEENINEDEAD = 1248;
unsigned short STEAM = 1250;
unsigned short CEILINGSTEAM = 1255;
unsigned short PIPE6B = 1260;
unsigned short TRANSPORTERBEAM = 1261;
unsigned short RAT = 1267;
unsigned short TRASH = 1272;
unsigned short FEMPIC1 = 1280;
unsigned short FEMPIC2 = 1289;
unsigned short BLANKSCREEN = 1293;
unsigned short PODFEM1 = 1294;
unsigned short FEMPIC3 = 1298;
unsigned short FEMPIC4 = 1306;
unsigned short FEM1 = 1312;
unsigned short FEM2 = 1317;
unsigned short FEM3 = 1321;
unsigned short FEM5 = 1323;
unsigned short BLOODYPOLE = 1324;
unsigned short FEM4 = 1325;
unsigned short FEM6 = 1334;
unsigned short FEM6PAD = 1335;
unsigned short FEM8 = 1336;
unsigned short HELECOPT = 1346;
unsigned short FETUSJIB = 1347;
unsigned short HOLODUKE = 1348;
unsigned short SPACEMARINE = 1353;
unsigned short INDY = 1355;
unsigned short FETUS = 1358;
unsigned short FETUSBROKE = 1359;
unsigned short MONK = 1352;
unsigned short LUKE = 1354;
unsigned short COOLEXPLOSION1 = 1360;
unsigned short WATERSPLASH2 = 1380;
unsigned short FIREVASE = 1390;
unsigned short SCRATCH = 1393;
unsigned short FEM7 = 1395;
unsigned short APLAYERTOP = 1400;
unsigned short APLAYER = 1405;
unsigned short PLAYERONWATER = 1420;
unsigned short DUKELYINGDEAD = 1518;
unsigned short DUKETORSO = 1520;
unsigned short DUKEGUN = 1528;
unsigned short DUKELEG = 1536;
unsigned short SHARK = 1550;
unsigned short BLOOD = 1620;
unsigned short FIRELASER = 1625;
unsigned short TRANSPORTERSTAR = 1630;
unsigned short SPIT = 1636;
unsigned short LOOGIE = 1637;
unsigned short FIST = 1640;
unsigned short FREEZEBLAST = 1641;
unsigned short DEVISTATORBLAST = 1642;
unsigned short SHRINKSPARK = 1646;
unsigned short TONGUE = 1647;
unsigned short MORTER = 1650;
unsigned short SHRINKEREXPLOSION = 1656;
unsigned short RADIUSEXPLOSION = 1670;
unsigned short FORCERIPPLE = 1671;
unsigned short LIZTROOP = 1680;
unsigned short LIZTROOPRUNNING = 1681;
unsigned short LIZTROOPSTAYPUT = 1682;
unsigned short LIZTOP = 1705;
unsigned short LIZTROOPSHOOT = 1715;
unsigned short LIZTROOPJETPACK = 1725;
unsigned short LIZTROOPDSPRITE = 1734;
unsigned short LIZTROOPONTOILET = 1741;
unsigned short LIZTROOPJUSTSIT = 1742;
unsigned short LIZTROOPDUCKING = 1744;
unsigned short HEADJIB1 = 1768;
unsigned short ARMJIB1 = 1772;
unsigned short LEGJIB1 = 1776;
unsigned short CANNONBALL = 1817;
unsigned short OCTABRAIN = 1820;
unsigned short OCTABRAINSTAYPUT = 1821;
unsigned short OCTATOP = 1845;
unsigned short OCTADEADSPRITE = 1855;
unsigned short INNERJAW = 1860;
unsigned short DRONE = 1880;
unsigned short EXPLOSION2 = 1890;
unsigned short COMMANDER = 1920;
unsigned short COMMANDERSTAYPUT = 1921;
unsigned short RECON = 1960;
unsigned short TANK = 1975;
unsigned short PIGCOP = 2000;
unsigned short PIGCOPSTAYPUT = 2001;
unsigned short PIGCOPDIVE = 2045;
unsigned short PIGCOPDEADSPRITE = 2060;
unsigned short PIGTOP = 2061;
unsigned short LIZMAN = 2120;
unsigned short LIZMANSTAYPUT = 2121;
unsigned short LIZMANSPITTING = 2150;
unsigned short LIZMANFEEDING = 2160;
unsigned short LIZMANJUMP = 2165;
unsigned short LIZMANDEADSPRITE = 2185;
unsigned short FECES = 2200;
unsigned short LIZMANHEAD1 = 2201;
unsigned short LIZMANARM1 = 2205;
unsigned short LIZMANLEG1 = 2209;
unsigned short EXPLOSION2BOT = 2219;
unsigned short USERWEAPON = 2235;
unsigned short HEADERBAR = 2242;
unsigned short JIBS1 = 2245;
unsigned short JIBS2 = 2250;
unsigned short JIBS3 = 2255;
unsigned short JIBS4 = 2260;
unsigned short JIBS5 = 2265;
unsigned short BURNING = 2270;
unsigned short FIRE = 2271;
unsigned short JIBS6 = 2286;
unsigned short BLOODSPLAT1 = 2296;
unsigned short BLOODSPLAT3 = 2297;
unsigned short BLOODSPLAT2 = 2298;
unsigned short BLOODSPLAT4 = 2299;
unsigned short OOZ = 2300;
unsigned short OOZ2 = 2309;
unsigned short WALLBLOOD1 = 2301;
unsigned short WALLBLOOD2 = 2302;
unsigned short WALLBLOOD3 = 2303;
unsigned short WALLBLOOD4 = 2304;
unsigned short WALLBLOOD5 = 2305;
unsigned short WALLBLOOD6 = 2306;
unsigned short WALLBLOOD7 = 2307;
unsigned short WALLBLOOD8 = 2308;
unsigned short BURNING2 = 2310;
unsigned short FIRE2 = 2311;
unsigned short CRACKKNUCKLES = 2324;
unsigned short SMALLSMOKE = 2329;
unsigned short SMALLSMOKEMAKER = 2330;
unsigned short FLOORFLAME = 2333;
unsigned short ROTATEGUN = 2360;
unsigned short GREENSLIME = 2370;
unsigned short WATERDRIPSPLASH = 2380;
unsigned short SCRAP6 = 2390;
unsigned short SCRAP1 = 2400;
unsigned short SCRAP2 = 2404;
unsigned short SCRAP3 = 2408;
unsigned short SCRAP4 = 2412;
unsigned short SCRAP5 = 2416;
unsigned short ORGANTIC = 2420;
unsigned short BETAVERSION = 2440;
unsigned short PLAYERISHERE = 2442;
unsigned short PLAYERWASHERE = 2443;
unsigned short SELECTDIR = 2444;
unsigned short F1HELP = 2445;
unsigned short NOTCHON = 2446;
unsigned short NOTCHOFF = 2447;
unsigned short GROWSPARK = 2448;
unsigned short DUKEICON = 2452;
unsigned short BADGUYICON = 2453;
unsigned short FOODICON = 2454;
unsigned short GETICON = 2455;
unsigned short MENUSCREEN = 2456;
unsigned short MENUBAR = 2457;
unsigned short KILLSICON = 2458;
unsigned short FIRSTAID_ICON = 2460;
unsigned short HEAT_ICON = 2461;
unsigned short BOTTOMSTATUSBAR = 2462;
unsigned short BOOT_ICON = 2463;
unsigned short FRAGBAR = 2465;
unsigned short JETPACK_ICON = 2467;
unsigned short AIRTANK_ICON = 2468;
unsigned short STEROIDS_ICON = 2469;
unsigned short HOLODUKE_ICON = 2470;
unsigned short ACCESS_ICON = 2471;
unsigned short DIGITALNUM = 2472;
unsigned short DUKECAR = 2491;
unsigned short CAMCORNER = 2482;
unsigned short CAMLIGHT = 2484;
unsigned short LOGO = 2485;
unsigned short TITLE = 2486;
unsigned short NUKEWARNINGICON = 2487;
unsigned short MOUSECURSOR = 2488;
unsigned short SLIDEBAR = 2489;
unsigned short DREALMS = 2492;
unsigned short BETASCREEN = 2493;
unsigned short WINDOWBORDER1 = 2494;
unsigned short TEXTBOX = 2495;
unsigned short WINDOWBORDER2 = 2496;
unsigned short DUKENUKEM = 2497;
unsigned short THREEDEE = 2498;
unsigned short INGAMEDUKETHREEDEE = 2499;
unsigned short TENSCREEN = 2500;
unsigned short PLUTOPAKSPRITE = 2501;
unsigned short DEVISTATOR = 2510;
unsigned short KNEE = 2521;
unsigned short CROSSHAIR = 2523;
unsigned short FIRSTGUN = 2524;
unsigned short FIRSTGUNRELOAD = 2528;
unsigned short FALLINGCLIP = 2530;
unsigned short CLIPINHAND = 2531;
unsigned short HAND = 2532;
unsigned short SHELL = 2533;
unsigned short SHOTGUNSHELL = 2535;
unsigned short CHAINGUN = 2536;
unsigned short RPGGUN = 2544;
unsigned short RPGMUZZLEFLASH = 2545;
unsigned short FREEZE = 2548;
unsigned short CATLITE = 2552;
unsigned short SHRINKER = 2556;
unsigned short HANDHOLDINGLASER = 2563;
unsigned short TRIPBOMB = 2566;
unsigned short LASERLINE = 2567;
unsigned short HANDHOLDINGACCESS = 2568;
unsigned short HANDREMOTE = 2570;
unsigned short HANDTHROW = 2573;
unsigned short TIP = 2576;
unsigned short GLAIR = 2578;
unsigned short SCUBAMASK = 2581;
unsigned short SPACEMASK = 2584;
unsigned short FORCESPHERE = 2590;
unsigned short SHOTSPARK1 = 2595;
unsigned short RPG = 2605;
unsigned short LASERSITE = 2612;
unsigned short SHOTGUN = 2613;
unsigned short BOSS1 = 2630;
unsigned short BOSS1STAYPUT = 2631;
unsigned short BOSS1SHOOT = 2660;
unsigned short BOSS1LOB = 2670;
unsigned short BOSSTOP = 2696;
unsigned short BOSS2 = 2710;
unsigned short BOSS3 = 2760;
unsigned short SPINNINGNUKEICON = 2813;
unsigned short BIGFNTCURSOR = 2820;
unsigned short SMALLFNTCURSOR = 2821;
unsigned short STARTALPHANUM = 2822;
unsigned short ENDALPHANUM = 2915;
unsigned short BIGALPHANUM = 2940;
unsigned short BIGPERIOD = 3002;
unsigned short BIGCOMMA = 3003;
unsigned short BIGX = 3004;
unsigned short BIGQ = 3005;
unsigned short BIGSEMI = 3006;
unsigned short BIGCOLIN = 3007;
unsigned short THREEBYFIVE = 3010;
unsigned short BIGAPPOS = 3022;
unsigned short BLANK = 3026;
unsigned short MINIFONT = 3072;
unsigned short BUTTON1 = 3164;
unsigned short GLASS3 = 3187;
unsigned short RESPAWNMARKERRED = 3190;
unsigned short RESPAWNMARKERYELLOW = 3200;
unsigned short RESPAWNMARKERGREEN = 3210;
unsigned short BONUSSCREEN = 3240;
unsigned short VIEWBORDER = 3250;
unsigned short VICTORY1 = 3260;
unsigned short ORDERING = 3270;
unsigned short TEXTSTORY = 3280;
unsigned short LOADSCREEN = 3281;
unsigned short BORNTOBEWILDSCREEN = 3370;
unsigned short BLIMP = 3400;
unsigned short FEM9 = 3450;
unsigned short FOOTPRINT = 3701;
unsigned short FRAMEEFFECT1_13 = 3999;
unsigned short POOP = 4094;
unsigned short FRAMEEFFECT1 = 4095;
unsigned short PANNEL3 = 4099;
unsigned short SCREENBREAK14 = 4120;
unsigned short SCREENBREAK15 = 4123;
unsigned short SCREENBREAK19 = 4125;
unsigned short SCREENBREAK16 = 4127;
unsigned short SCREENBREAK17 = 4128;
unsigned short SCREENBREAK18 = 4129;
unsigned short W_TECHWALL11 = 4130;
unsigned short W_TECHWALL12 = 4131;
unsigned short W_TECHWALL13 = 4132;
unsigned short W_TECHWALL14 = 4133;
unsigned short W_TECHWALL5 = 4134;
unsigned short W_TECHWALL6 = 4136;
unsigned short W_TECHWALL7 = 4138;
unsigned short W_TECHWALL8 = 4140;
unsigned short W_TECHWALL9 = 4142;
unsigned short BPANNEL3 = 4100;
unsigned short W_HITTECHWALL16 = 4144;
unsigned short W_HITTECHWALL10 = 4145;
unsigned short W_HITTECHWALL15 = 4147;
unsigned short W_MILKSHELF = 4181;
unsigned short W_MILKSHELFBROKE = 4203;
unsigned short PURPLELAVA = 4240;
unsigned short LAVABUBBLE = 4340;
unsigned short DUKECUTOUT = 4352;
unsigned short TARGET = 4359;
unsigned short GUNPOWDERBARREL = 4360;
unsigned short DUCK = 4361;
unsigned short HATRACK = 4367;
unsigned short DESKLAMP = 4370;
unsigned short COFFEEMACHINE = 4372;
unsigned short CUPS = 4373;
unsigned short GAVALS = 4374;
unsigned short GAVALS2 = 4375;
unsigned short POLICELIGHTPOLE = 4377;
unsigned short FLOORBASKET = 4388;
unsigned short PUKE = 4389;
unsigned short DOORTILE23 = 4391;
unsigned short TOPSECRET = 4396;
unsigned short SPEAKER = 4397;
unsigned short TEDDYBEAR = 4400;
unsigned short ROBOTDOG = 4402;
unsigned short ROBOTPIRATE = 4404;
unsigned short ROBOTMOUSE = 4407;
unsigned short MAIL = 4410;
unsigned short MAILBAG = 4413;
unsigned short HOTMEAT = 4427;
unsigned short COFFEEMUG = 4438;
unsigned short DONUTS2 = 4440;
unsigned short TRIPODCAMERA = 4444;
unsigned short METER = 4453;
unsigned short DESKPHONE = 4454;
unsigned short GUMBALLMACHINE = 4458;
unsigned short GUMBALLMACHINEBROKE = 4459;
unsigned short PAPER = 4460;
unsigned short MACE = 4464;
unsigned short GENERICPOLE2 = 4465;
unsigned short XXXSTACY = 4470;
unsigned short WETFLOOR = 4495;
unsigned short BROOM = 4496;
unsigned short MOP = 4497;
unsigned short LETTER = 4502;
unsigned short PIRATE1A = 4510;
unsigned short PIRATE4A = 4511;
unsigned short PIRATE2A = 4512;
unsigned short PIRATE5A = 4513;
unsigned short PIRATE3A = 4514;
unsigned short PIRATE6A = 4515;
unsigned short PIRATEHALF = 4516;
unsigned short CHESTOFGOLD = 4520;
unsigned short SIDEBOLT1 = 4525;
unsigned short FOODOBJECT1 = 4530;
unsigned short FOODOBJECT2 = 4531;
unsigned short FOODOBJECT3 = 4532;
unsigned short FOODOBJECT4 = 4533;
unsigned short FOODOBJECT5 = 4534;
unsigned short FOODOBJECT6 = 4535;
unsigned short FOODOBJECT7 = 4536;
unsigned short FOODOBJECT8 = 4537;
unsigned short FOODOBJECT9 = 4538;
unsigned short FOODOBJECT10 = 4539;
unsigned short FOODOBJECT11 = 4540;
unsigned short FOODOBJECT12 = 4541;
unsigned short FOODOBJECT13 = 4542;
unsigned short FOODOBJECT14 = 4543;
unsigned short FOODOBJECT15 = 4544;
unsigned short FOODOBJECT16 = 4545;
unsigned short FOODOBJECT17 = 4546;
unsigned short FOODOBJECT18 = 4547;
unsigned short FOODOBJECT19 = 4548;
unsigned short FOODOBJECT20 = 4549;
unsigned short HEADLAMP = 4550;
unsigned short TAMPON = 4557;
unsigned short SKINNEDCHICKEN = 4554;
unsigned short FEATHEREDCHICKEN = 4555;
unsigned short ROBOTDOG2 = 4560;
unsigned short JOLLYMEAL = 4569;
unsigned short DUKEBURGER = 4570;
unsigned short SHOPPINGCART = 4576;
unsigned short CANWITHSOMETHING2 = 4580;
unsigned short CANWITHSOMETHING3 = 4581;
unsigned short CANWITHSOMETHING4 = 4582;
unsigned short SNAKEP = 4590;
unsigned short DOLPHIN1 = 4591;
unsigned short DOLPHIN2 = 4592;
unsigned short NEWBEAST = 4610;
unsigned short NEWBEASTSTAYPUT = 4611;
unsigned short NEWBEASTJUMP = 4690;
unsigned short NEWBEASTHANG = 4670;
unsigned short NEWBEASTHANGDEAD = 4671;
unsigned short BOSS4 = 4740;
unsigned short BOSS4STAYPUT = 4741;
unsigned short FEM10 = 4864;
unsigned short TOUGHGAL = 4866;
unsigned short MAN = 4871;
unsigned short MAN2 = 4872;
unsigned short WOMAN = 4874;
unsigned short PLEASEWAIT = 4887;
unsigned short NATURALLIGHTNING = 4890;
unsigned short WEATHERWARN = 4893;
unsigned short DUKETAG = 4900;
unsigned short SIGN1 = 4909;
unsigned short SIGN2 = 4912;
unsigned short JURYGUY = 4943;
unsigned short RESERVEDSLOT1 = 6132;
unsigned short RESERVEDSLOT2 = 6133;
unsigned short RESERVEDSLOT3 = 6134;
unsigned short RESERVEDSLOT4 = 6135;
unsigned short RESERVEDSLOT5 = 6136;
unsigned short RESERVEDSLOT6 = 6137;
unsigned short RESERVEDSLOT7 = 6138;
unsigned short RESERVEDSLOT8 = 6139;
unsigned short RESERVEDSLOT9 = 6140;
unsigned short RESERVEDSLOT10 = 6141;
unsigned short RESERVEDSLOT11 = 6142;
unsigned short RESERVEDSLOT12 = 6143;

unsigned short dynamictostatic[MAXTILES];

void processnames(char *szLabel, long lValue)
{
    switch (szLabel[0]) {
    case 'A':
        if (!Bstrcmp(szLabel,"ACTIVATOR")) ACTIVATOR = lValue;
        else if (!Bstrcmp(szLabel,"ACTIVATORLOCKED")) ACTIVATORLOCKED = lValue;
        else if (!Bstrcmp(szLabel,"ARROW")) ARROW = lValue;
        else if (!Bstrcmp(szLabel,"AMMOBOX")) AMMOBOX = lValue;
        else if (!Bstrcmp(szLabel,"AMMO")) AMMO = lValue;
        else if (!Bstrcmp(szLabel,"AMMOLOTS")) AMMOLOTS = lValue;
        else if (!Bstrcmp(szLabel,"AIRTANK")) AIRTANK = lValue;
        else if (!Bstrcmp(szLabel,"ACCESSCARD")) ACCESSCARD = lValue;
        else if (!Bstrcmp(szLabel,"ATOMICHEALTH")) ATOMICHEALTH = lValue;
        else if (!Bstrcmp(szLabel,"ACCESSSWITCH")) ACCESSSWITCH = lValue;
        else if (!Bstrcmp(szLabel,"ACCESSSWITCH2")) ACCESSSWITCH2 = lValue;
        else if (!Bstrcmp(szLabel,"ANTENNA")) ANTENNA = lValue;
        else if (!Bstrcmp(szLabel,"ATM")) ATM = lValue;
        else if (!Bstrcmp(szLabel,"ATMBROKE")) ATMBROKE = lValue;
        else if (!Bstrcmp(szLabel,"ALIENSWITCH")) ALIENSWITCH = lValue;
        else if (!Bstrcmp(szLabel,"APLAYERTOP")) APLAYERTOP = lValue;
        else if (!Bstrcmp(szLabel,"APLAYER")) APLAYER = lValue;
        else if (!Bstrcmp(szLabel,"ARMJIB1")) ARMJIB1 = lValue;
        else if (!Bstrcmp(szLabel,"AIRTANK_ICON")) AIRTANK_ICON = lValue;
        else if (!Bstrcmp(szLabel,"ACCESS_ICON")) ACCESS_ICON = lValue;
        break;
    case 'B':
        if (!Bstrcmp(szLabel,"BATTERYAMMO")) BATTERYAMMO = lValue;
        else if (!Bstrcmp(szLabel,"BOOTS")) BOOTS = lValue;
        else if (!Bstrcmp(szLabel,"BIGORBIT1")) BIGORBIT1 = lValue;
        else if (!Bstrcmp(szLabel,"BIGORBIT2")) BIGORBIT2 = lValue;
        else if (!Bstrcmp(szLabel,"BIGORBIT3")) BIGORBIT3 = lValue;
        else if (!Bstrcmp(szLabel,"BIGORBIT4")) BIGORBIT4 = lValue;
        else if (!Bstrcmp(szLabel,"BIGORBIT5")) BIGORBIT5 = lValue;
        else if (!Bstrcmp(szLabel,"BIGFORCE")) BIGFORCE = lValue;
        else if (!Bstrcmp(szLabel,"BPANNEL1")) BPANNEL1 = lValue;
        else if (!Bstrcmp(szLabel,"BROKENCHAIR")) BROKENCHAIR = lValue;
        else if (!Bstrcmp(szLabel,"BGRATE1")) BGRATE1 = lValue;
        else if (!Bstrcmp(szLabel,"BRICK")) BRICK = lValue;
        else if (!Bstrcmp(szLabel,"BOLT1")) BOLT1 = lValue;
        else if (!Bstrcmp(szLabel,"BIGHOLE2")) BIGHOLE2 = lValue;
        else if (!Bstrcmp(szLabel,"BOUNCEMINE")) BOUNCEMINE = lValue;
        else if (!Bstrcmp(szLabel,"BROKEFIREHYDRENT")) BROKEFIREHYDRENT = lValue;
        else if (!Bstrcmp(szLabel,"BOX")) BOX = lValue;
        else if (!Bstrcmp(szLabel,"BULLETHOLE")) BULLETHOLE = lValue;
        else if (!Bstrcmp(szLabel,"BOTTLE1")) BOTTLE1 = lValue;
        else if (!Bstrcmp(szLabel,"BOTTLE2")) BOTTLE2 = lValue;
        else if (!Bstrcmp(szLabel,"BOTTLE3")) BOTTLE3 = lValue;
        else if (!Bstrcmp(szLabel,"BOTTLE4")) BOTTLE4 = lValue;
        else if (!Bstrcmp(szLabel,"BROKEHYDROPLANT")) BROKEHYDROPLANT = lValue;
        else if (!Bstrcmp(szLabel,"BOTTLE5")) BOTTLE5 = lValue;
        else if (!Bstrcmp(szLabel,"BOTTLE6")) BOTTLE6 = lValue;
        else if (!Bstrcmp(szLabel,"BOTTLE8")) BOTTLE8 = lValue;
        else if (!Bstrcmp(szLabel,"BOTTLE7")) BOTTLE7 = lValue;
        else if (!Bstrcmp(szLabel,"BROKENCLOCK")) BROKENCLOCK = lValue;
        else if (!Bstrcmp(szLabel,"BIGHOLE")) BIGHOLE = lValue;
        else if (!Bstrcmp(szLabel,"BOTTLE10")) BOTTLE10 = lValue;
        else if (!Bstrcmp(szLabel,"BOTTLE11")) BOTTLE11 = lValue;
        else if (!Bstrcmp(szLabel,"BOTTLE12")) BOTTLE12 = lValue;
        else if (!Bstrcmp(szLabel,"BOTTLE13")) BOTTLE13 = lValue;
        else if (!Bstrcmp(szLabel,"BOTTLE14")) BOTTLE14 = lValue;
        else if (!Bstrcmp(szLabel,"BOTTLE15")) BOTTLE15 = lValue;
        else if (!Bstrcmp(szLabel,"BOTTLE16")) BOTTLE16 = lValue;
        else if (!Bstrcmp(szLabel,"BOTTLE17")) BOTTLE17 = lValue;
        else if (!Bstrcmp(szLabel,"BOTTLE18")) BOTTLE18 = lValue;
        else if (!Bstrcmp(szLabel,"BOTTLE19")) BOTTLE19 = lValue;
        else if (!Bstrcmp(szLabel,"BARBROKE")) BARBROKE = lValue;
        else if (!Bstrcmp(szLabel,"BLOODPOOL")) BLOODPOOL = lValue;
        else if (!Bstrcmp(szLabel,"BANNER")) BANNER = lValue;
        else if (!Bstrcmp(szLabel,"BLANKSCREEN")) BLANKSCREEN = lValue;
        else if (!Bstrcmp(szLabel,"BLOODYPOLE")) BLOODYPOLE = lValue;
        else if (!Bstrcmp(szLabel,"BLOOD")) BLOOD = lValue;
        else if (!Bstrcmp(szLabel,"BURNING")) BURNING = lValue;
        else if (!Bstrcmp(szLabel,"BLOODSPLAT1")) BLOODSPLAT1 = lValue;
        else if (!Bstrcmp(szLabel,"BLOODSPLAT3")) BLOODSPLAT3 = lValue;
        else if (!Bstrcmp(szLabel,"BLOODSPLAT2")) BLOODSPLAT2 = lValue;
        else if (!Bstrcmp(szLabel,"BLOODSPLAT4")) BLOODSPLAT4 = lValue;
        else if (!Bstrcmp(szLabel,"BURNING2")) BURNING2 = lValue;
        else if (!Bstrcmp(szLabel,"BETAVERSION")) BETAVERSION = lValue;
        else if (!Bstrcmp(szLabel,"BADGUYICON")) BADGUYICON = lValue;
        else if (!Bstrcmp(szLabel,"BOTTOMSTATUSBAR")) BOTTOMSTATUSBAR = lValue;
        else if (!Bstrcmp(szLabel,"BOOT_ICON")) BOOT_ICON = lValue;
        else if (!Bstrcmp(szLabel,"BETASCREEN")) BETASCREEN = lValue;
        else if (!Bstrcmp(szLabel,"BOSS1")) BOSS1 = lValue;
        else if (!Bstrcmp(szLabel,"BOSS1STAYPUT")) BOSS1STAYPUT = lValue;
        else if (!Bstrcmp(szLabel,"BOSS1SHOOT")) BOSS1SHOOT = lValue;
        else if (!Bstrcmp(szLabel,"BOSS1LOB")) BOSS1LOB = lValue;
        else if (!Bstrcmp(szLabel,"BOSSTOP")) BOSSTOP = lValue;
        else if (!Bstrcmp(szLabel,"BOSS2")) BOSS2 = lValue;
        else if (!Bstrcmp(szLabel,"BOSS3")) BOSS3 = lValue;
        else if (!Bstrcmp(szLabel,"BIGFNTCURSOR")) BIGFNTCURSOR = lValue;
        else if (!Bstrcmp(szLabel,"BIGALPHANUM")) BIGALPHANUM = lValue;
        else if (!Bstrcmp(szLabel,"BIGPERIOD")) BIGPERIOD = lValue;
        else if (!Bstrcmp(szLabel,"BIGCOMMA")) BIGCOMMA = lValue;
        else if (!Bstrcmp(szLabel,"BIGX")) BIGX = lValue;
        else if (!Bstrcmp(szLabel,"BIGQ")) BIGQ = lValue;
        else if (!Bstrcmp(szLabel,"BIGSEMI")) BIGSEMI = lValue;
        else if (!Bstrcmp(szLabel,"BIGCOLIN")) BIGCOLIN = lValue;
        else if (!Bstrcmp(szLabel,"BIGAPPOS")) BIGAPPOS = lValue;
        else if (!Bstrcmp(szLabel,"BLANK")) BLANK = lValue;
        else if (!Bstrcmp(szLabel,"BUTTON1")) BUTTON1 = lValue;
        else if (!Bstrcmp(szLabel,"BONUSSCREEN")) BONUSSCREEN = lValue;
        else if (!Bstrcmp(szLabel,"BORNTOBEWILDSCREEN")) BORNTOBEWILDSCREEN = lValue;
        else if (!Bstrcmp(szLabel,"BLIMP")) BLIMP = lValue;
        else if (!Bstrcmp(szLabel,"BPANNEL3")) BPANNEL3 = lValue;
        else if (!Bstrcmp(szLabel,"BROOM")) BROOM = lValue;
        else if (!Bstrcmp(szLabel,"BOSS4")) BOSS4 = lValue;
        else if (!Bstrcmp(szLabel,"BOSS4STAYPUT")) BOSS4STAYPUT = lValue;
        break;
    case 'C':
        if (!Bstrcmp(szLabel,"CYCLER")) CYCLER = lValue;
        else if (!Bstrcmp(szLabel,"CHAINGUNSPRITE")) CHAINGUNSPRITE = lValue;
        else if (!Bstrcmp(szLabel,"CRYSTALAMMO")) CRYSTALAMMO = lValue;
        else if (!Bstrcmp(szLabel,"COLA")) COLA = lValue;
        else if (!Bstrcmp(szLabel,"CLOUDYOCEAN")) CLOUDYOCEAN = lValue;
        else if (!Bstrcmp(szLabel,"CLOUDYSKIES")) CLOUDYSKIES = lValue;
        else if (!Bstrcmp(szLabel,"CRACK1")) CRACK1 = lValue;
        else if (!Bstrcmp(szLabel,"CRACK2")) CRACK2 = lValue;
        else if (!Bstrcmp(szLabel,"CRACK3")) CRACK3 = lValue;
        else if (!Bstrcmp(szLabel,"CRACK4")) CRACK4 = lValue;
        else if (!Bstrcmp(szLabel,"CAMERAPOLE")) CAMERAPOLE = lValue;
        else if (!Bstrcmp(szLabel,"CHAIR1")) CHAIR1 = lValue;
        else if (!Bstrcmp(szLabel,"CHAIR2")) CHAIR2 = lValue;
        else if (!Bstrcmp(szLabel,"CAMERA1")) CAMERA1 = lValue;
        else if (!Bstrcmp(szLabel,"CHAIR3")) CHAIR3 = lValue;
        else if (!Bstrcmp(szLabel,"CAMERALIGHT")) CAMERALIGHT = lValue;
        else if (!Bstrcmp(szLabel,"CACTUS")) CACTUS = lValue;
        else if (!Bstrcmp(szLabel,"CACTUSBROKE")) CACTUSBROKE = lValue;
        else if (!Bstrcmp(szLabel,"CONE")) CONE = lValue;
        else if (!Bstrcmp(szLabel,"CLOCK")) CLOCK = lValue;
        else if (!Bstrcmp(szLabel,"CIRCLEPANNEL")) CIRCLEPANNEL = lValue;
        else if (!Bstrcmp(szLabel,"CIRCLEPANNELBROKE")) CIRCLEPANNELBROKE = lValue;
        else if (!Bstrcmp(szLabel,"COLAMACHINE")) COLAMACHINE = lValue;
        else if (!Bstrcmp(szLabel,"COLAMACHINEBROKE")) COLAMACHINEBROKE = lValue;
        else if (!Bstrcmp(szLabel,"CRANEPOLE")) CRANEPOLE = lValue;
        else if (!Bstrcmp(szLabel,"CRANE")) CRANE = lValue;
        else if (!Bstrcmp(szLabel,"CANWITHSOMETHING")) CANWITHSOMETHING = lValue;
        else if (!Bstrcmp(szLabel,"CEILINGSTEAM")) CEILINGSTEAM = lValue;
        else if (!Bstrcmp(szLabel,"COOLEXPLOSION1")) COOLEXPLOSION1 = lValue;
        else if (!Bstrcmp(szLabel,"CANNONBALL")) CANNONBALL = lValue;
        else if (!Bstrcmp(szLabel,"COMMANDER")) COMMANDER = lValue;
        else if (!Bstrcmp(szLabel,"COMMANDERSTAYPUT")) COMMANDERSTAYPUT = lValue;
        else if (!Bstrcmp(szLabel,"CRACKKNUCKLES")) CRACKKNUCKLES = lValue;
        else if (!Bstrcmp(szLabel,"CAMCORNER")) CAMCORNER = lValue;
        else if (!Bstrcmp(szLabel,"CAMLIGHT")) CAMLIGHT = lValue;
        else if (!Bstrcmp(szLabel,"CROSSHAIR")) CROSSHAIR = lValue;
        else if (!Bstrcmp(szLabel,"CLIPINHAND")) CLIPINHAND = lValue;
        else if (!Bstrcmp(szLabel,"CHAINGUN")) CHAINGUN = lValue;
        else if (!Bstrcmp(szLabel,"CATLITE")) CATLITE = lValue;
        else if (!Bstrcmp(szLabel,"COFFEEMACHINE")) COFFEEMACHINE = lValue;
        else if (!Bstrcmp(szLabel,"CUPS")) CUPS = lValue;
        else if (!Bstrcmp(szLabel,"COFFEEMUG")) COFFEEMUG = lValue;
        else if (!Bstrcmp(szLabel,"CHESTOFGOLD")) CHESTOFGOLD = lValue;
        else if (!Bstrcmp(szLabel,"CANWITHSOMETHING2")) CANWITHSOMETHING2 = lValue;
        else if (!Bstrcmp(szLabel,"CANWITHSOMETHING3")) CANWITHSOMETHING3 = lValue;
        else if (!Bstrcmp(szLabel,"CANWITHSOMETHING4")) CANWITHSOMETHING4 = lValue;
        break;
    case 'D':
        if (!Bstrcmp(szLabel,"DEVISTATORSPRITE")) DEVISTATORSPRITE = lValue;
        else if (!Bstrcmp(szLabel,"DEVISTATORAMMO")) DEVISTATORAMMO = lValue;
        else if (!Bstrcmp(szLabel,"DOORTILE5")) DOORTILE5 = lValue;
        else if (!Bstrcmp(szLabel,"DOORTILE6")) DOORTILE6 = lValue;
        else if (!Bstrcmp(szLabel,"DOORTILE1")) DOORTILE1 = lValue;
        else if (!Bstrcmp(szLabel,"DOORTILE2")) DOORTILE2 = lValue;
        else if (!Bstrcmp(szLabel,"DOORTILE3")) DOORTILE3 = lValue;
        else if (!Bstrcmp(szLabel,"DOORTILE4")) DOORTILE4 = lValue;
        else if (!Bstrcmp(szLabel,"DOORTILE7")) DOORTILE7 = lValue;
        else if (!Bstrcmp(szLabel,"DOORTILE8")) DOORTILE8 = lValue;
        else if (!Bstrcmp(szLabel,"DOORTILE9")) DOORTILE9 = lValue;
        else if (!Bstrcmp(szLabel,"DOORTILE10")) DOORTILE10 = lValue;
        else if (!Bstrcmp(szLabel,"DOORSHOCK")) DOORSHOCK = lValue;
        else if (!Bstrcmp(szLabel,"DIPSWITCH")) DIPSWITCH = lValue;
        else if (!Bstrcmp(szLabel,"DIPSWITCH2")) DIPSWITCH2 = lValue;
        else if (!Bstrcmp(szLabel,"DIPSWITCH3")) DIPSWITCH3 = lValue;
        else if (!Bstrcmp(szLabel,"DOORTILE22")) DOORTILE22 = lValue;
        else if (!Bstrcmp(szLabel,"DOORTILE18")) DOORTILE18 = lValue;
        else if (!Bstrcmp(szLabel,"DOORTILE19")) DOORTILE19 = lValue;
        else if (!Bstrcmp(szLabel,"DOORTILE20")) DOORTILE20 = lValue;
        else if (!Bstrcmp(szLabel,"DOMELITE")) DOMELITE = lValue;
        else if (!Bstrcmp(szLabel,"DOORTILE14")) DOORTILE14 = lValue;
        else if (!Bstrcmp(szLabel,"DOORTILE16")) DOORTILE16 = lValue;
        else if (!Bstrcmp(szLabel,"DONUTS")) DONUTS = lValue;
        else if (!Bstrcmp(szLabel,"DOORTILE15")) DOORTILE15 = lValue;
        else if (!Bstrcmp(szLabel,"DOORTILE21")) DOORTILE21 = lValue;
        else if (!Bstrcmp(szLabel,"DOORTILE17")) DOORTILE17 = lValue;
        else if (!Bstrcmp(szLabel,"DOORTILE11")) DOORTILE11 = lValue;
        else if (!Bstrcmp(szLabel,"DOORTILE12")) DOORTILE12 = lValue;
        else if (!Bstrcmp(szLabel,"DUKELYINGDEAD")) DUKELYINGDEAD = lValue;
        else if (!Bstrcmp(szLabel,"DUKETORSO")) DUKETORSO = lValue;
        else if (!Bstrcmp(szLabel,"DUKEGUN")) DUKEGUN = lValue;
        else if (!Bstrcmp(szLabel,"DUKELEG")) DUKELEG = lValue;
        else if (!Bstrcmp(szLabel,"DEVISTATORBLAST")) DEVISTATORBLAST = lValue;
        else if (!Bstrcmp(szLabel,"DRONE")) DRONE = lValue;
        else if (!Bstrcmp(szLabel,"DUKEICON")) DUKEICON = lValue;
        else if (!Bstrcmp(szLabel,"DIGITALNUM")) DIGITALNUM = lValue;
        else if (!Bstrcmp(szLabel,"DUKECAR")) DUKECAR = lValue;
        else if (!Bstrcmp(szLabel,"DREALMS")) DREALMS = lValue;
        else if (!Bstrcmp(szLabel,"DUKENUKEM")) DUKENUKEM = lValue;
        else if (!Bstrcmp(szLabel,"DEVISTATOR")) DEVISTATOR = lValue;
        else if (!Bstrcmp(szLabel,"DUKECUTOUT")) DUKECUTOUT = lValue;
        else if (!Bstrcmp(szLabel,"DUCK")) DUCK = lValue;
        else if (!Bstrcmp(szLabel,"DESKLAMP")) DESKLAMP = lValue;
        else if (!Bstrcmp(szLabel,"DOORTILE23")) DOORTILE23 = lValue;
        else if (!Bstrcmp(szLabel,"DONUTS2")) DONUTS2 = lValue;
        else if (!Bstrcmp(szLabel,"DESKPHONE")) DESKPHONE = lValue;
        else if (!Bstrcmp(szLabel,"DUKEBURGER")) DUKEBURGER = lValue;
        else if (!Bstrcmp(szLabel,"DOLPHIN1")) DOLPHIN1 = lValue;
        else if (!Bstrcmp(szLabel,"DOLPHIN2")) DOLPHIN2 = lValue;
        else if (!Bstrcmp(szLabel,"DUKETAG")) DUKETAG = lValue;
        break;
    case 'E':
        if (!Bstrcmp(szLabel,"EPISODE")) EPISODE = lValue;
        else if (!Bstrcmp(szLabel,"EGG")) EGG = lValue;
        else if (!Bstrcmp(szLabel,"EXPLODINGBARREL")) EXPLODINGBARREL = lValue;
        else if (!Bstrcmp(szLabel,"EXPLODINGBARREL2")) EXPLODINGBARREL2 = lValue;
        else if (!Bstrcmp(szLabel,"EXPLOSION2")) EXPLOSION2 = lValue;
        else if (!Bstrcmp(szLabel,"EXPLOSION2BOT")) EXPLOSION2BOT = lValue;
        else if (!Bstrcmp(szLabel,"ENDALPHANUM")) ENDALPHANUM = lValue;
        break;
    case 'F':
        if (!Bstrcmp(szLabel,"FOF")) FOF = lValue;
        else if (!Bstrcmp(szLabel,"FIRSTGUNSPRITE")) FIRSTGUNSPRITE = lValue;
        else if (!Bstrcmp(szLabel,"FREEZESPRITE")) FREEZESPRITE = lValue;
        else if (!Bstrcmp(szLabel,"FREEZEAMMO")) FREEZEAMMO = lValue;
        else if (!Bstrcmp(szLabel,"FIRSTAID")) FIRSTAID = lValue;
        else if (!Bstrcmp(szLabel,"FRANKENSTINESWITCH")) FRANKENSTINESWITCH = lValue;
        else if (!Bstrcmp(szLabel,"FLOORSLIME")) FLOORSLIME = lValue;
        else if (!Bstrcmp(szLabel,"FANSPRITE")) FANSPRITE = lValue;
        else if (!Bstrcmp(szLabel,"FANSPRITEBROKE")) FANSPRITEBROKE = lValue;
        else if (!Bstrcmp(szLabel,"FANSHADOW")) FANSHADOW = lValue;
        else if (!Bstrcmp(szLabel,"FANSHADOWBROKE")) FANSHADOWBROKE = lValue;
        else if (!Bstrcmp(szLabel,"FUELPOD")) FUELPOD = lValue;
        else if (!Bstrcmp(szLabel,"FOOTPRINTS")) FOOTPRINTS = lValue;
        else if (!Bstrcmp(szLabel,"FEMMAG1")) FEMMAG1 = lValue;
        else if (!Bstrcmp(szLabel,"FEMMAG2")) FEMMAG2 = lValue;
        else if (!Bstrcmp(szLabel,"FOOTPRINTS2")) FOOTPRINTS2 = lValue;
        else if (!Bstrcmp(szLabel,"FOOTPRINTS3")) FOOTPRINTS3 = lValue;
        else if (!Bstrcmp(szLabel,"FOOTPRINTS4")) FOOTPRINTS4 = lValue;
        else if (!Bstrcmp(szLabel,"FIREEXT")) FIREEXT = lValue;
        else if (!Bstrcmp(szLabel,"FEMPIC5")) FEMPIC5 = lValue;
        else if (!Bstrcmp(szLabel,"FEMPIC6")) FEMPIC6 = lValue;
        else if (!Bstrcmp(szLabel,"FEMPIC7")) FEMPIC7 = lValue;
        else if (!Bstrcmp(szLabel,"FLOORPLASMA")) FLOORPLASMA = lValue;
        else if (!Bstrcmp(szLabel,"FIREBARREL")) FIREBARREL = lValue;
        else if (!Bstrcmp(szLabel,"FEMPIC1")) FEMPIC1 = lValue;
        else if (!Bstrcmp(szLabel,"FEMPIC2")) FEMPIC2 = lValue;
        else if (!Bstrcmp(szLabel,"FEMPIC3")) FEMPIC3 = lValue;
        else if (!Bstrcmp(szLabel,"FEMPIC4")) FEMPIC4 = lValue;
        else if (!Bstrcmp(szLabel,"FEM1")) FEM1 = lValue;
        else if (!Bstrcmp(szLabel,"FEM2")) FEM2 = lValue;
        else if (!Bstrcmp(szLabel,"FEM3")) FEM3 = lValue;
        else if (!Bstrcmp(szLabel,"FEM5")) FEM5 = lValue;
        else if (!Bstrcmp(szLabel,"FEM4")) FEM4 = lValue;
        else if (!Bstrcmp(szLabel,"FEM6")) FEM6 = lValue;
        else if (!Bstrcmp(szLabel,"FEM6PAD")) FEM6PAD = lValue;
        else if (!Bstrcmp(szLabel,"FEM8")) FEM8 = lValue;
        else if (!Bstrcmp(szLabel,"FETUSJIB")) FETUSJIB = lValue;
        else if (!Bstrcmp(szLabel,"FETUS")) FETUS = lValue;
        else if (!Bstrcmp(szLabel,"FETUSBROKE")) FETUSBROKE = lValue;
        else if (!Bstrcmp(szLabel,"FIREVASE")) FIREVASE = lValue;
        else if (!Bstrcmp(szLabel,"FEM7")) FEM7 = lValue;
        else if (!Bstrcmp(szLabel,"FIRELASER")) FIRELASER = lValue;
        else if (!Bstrcmp(szLabel,"FIST")) FIST = lValue;
        else if (!Bstrcmp(szLabel,"FREEZEBLAST")) FREEZEBLAST = lValue;
        else if (!Bstrcmp(szLabel,"FORCERIPPLE")) FORCERIPPLE = lValue;
        else if (!Bstrcmp(szLabel,"FECES")) FECES = lValue;
        else if (!Bstrcmp(szLabel,"FIRE")) FIRE = lValue;
        else if (!Bstrcmp(szLabel,"FIRE2")) FIRE2 = lValue;
        else if (!Bstrcmp(szLabel,"FLOORFLAME")) FLOORFLAME = lValue;
        else if (!Bstrcmp(szLabel,"F1HELP")) F1HELP = lValue;
        else if (!Bstrcmp(szLabel,"FOODICON")) FOODICON = lValue;
        else if (!Bstrcmp(szLabel,"FIRSTAID_ICON")) FIRSTAID_ICON = lValue;
        else if (!Bstrcmp(szLabel,"FRAGBAR")) FRAGBAR = lValue;
        else if (!Bstrcmp(szLabel,"FIRSTGUN")) FIRSTGUN = lValue;
        else if (!Bstrcmp(szLabel,"FIRSTGUNRELOAD")) FIRSTGUNRELOAD = lValue;
        else if (!Bstrcmp(szLabel,"FALLINGCLIP")) FALLINGCLIP = lValue;
        else if (!Bstrcmp(szLabel,"FREEZE")) FREEZE = lValue;
        else if (!Bstrcmp(szLabel,"FORCESPHERE")) FORCESPHERE = lValue;
        else if (!Bstrcmp(szLabel,"FEM9")) FEM9 = lValue;
        else if (!Bstrcmp(szLabel,"FOOTPRINT")) FOOTPRINT = lValue;
        else if (!Bstrcmp(szLabel,"FRAMEEFFECT1")) FRAMEEFFECT1 = lValue;
        else if (!Bstrcmp(szLabel,"FRAMEEFFECT1_13")) FRAMEEFFECT1_13 = lValue;
        else if (!Bstrcmp(szLabel,"FLOORBASKET")) FLOORBASKET = lValue;
        else if (!Bstrcmp(szLabel,"FOODOBJECT1")) FOODOBJECT1 = lValue;
        else if (!Bstrcmp(szLabel,"FOODOBJECT2")) FOODOBJECT2 = lValue;
        else if (!Bstrcmp(szLabel,"FOODOBJECT3")) FOODOBJECT3 = lValue;
        else if (!Bstrcmp(szLabel,"FOODOBJECT4")) FOODOBJECT4 = lValue;
        else if (!Bstrcmp(szLabel,"FOODOBJECT5")) FOODOBJECT5 = lValue;
        else if (!Bstrcmp(szLabel,"FOODOBJECT6")) FOODOBJECT6 = lValue;
        else if (!Bstrcmp(szLabel,"FOODOBJECT7")) FOODOBJECT7 = lValue;
        else if (!Bstrcmp(szLabel,"FOODOBJECT8")) FOODOBJECT8 = lValue;
        else if (!Bstrcmp(szLabel,"FOODOBJECT9")) FOODOBJECT9 = lValue;
        else if (!Bstrcmp(szLabel,"FOODOBJECT10")) FOODOBJECT10 = lValue;
        else if (!Bstrcmp(szLabel,"FOODOBJECT11")) FOODOBJECT11 = lValue;
        else if (!Bstrcmp(szLabel,"FOODOBJECT12")) FOODOBJECT12 = lValue;
        else if (!Bstrcmp(szLabel,"FOODOBJECT13")) FOODOBJECT13 = lValue;
        else if (!Bstrcmp(szLabel,"FOODOBJECT14")) FOODOBJECT14 = lValue;
        else if (!Bstrcmp(szLabel,"FOODOBJECT15")) FOODOBJECT15 = lValue;
        else if (!Bstrcmp(szLabel,"FOODOBJECT16")) FOODOBJECT16 = lValue;
        else if (!Bstrcmp(szLabel,"FOODOBJECT17")) FOODOBJECT17 = lValue;
        else if (!Bstrcmp(szLabel,"FOODOBJECT18")) FOODOBJECT18 = lValue;
        else if (!Bstrcmp(szLabel,"FOODOBJECT19")) FOODOBJECT19 = lValue;
        else if (!Bstrcmp(szLabel,"FOODOBJECT20")) FOODOBJECT20 = lValue;
        else if (!Bstrcmp(szLabel,"FEATHEREDCHICKEN")) FEATHEREDCHICKEN = lValue;
        else if (!Bstrcmp(szLabel,"FEM10")) FEM10 = lValue;
        break;
    case 'G':
        if (!Bstrcmp(szLabel,"GPSPEED")) GPSPEED = lValue;
        else if (!Bstrcmp(szLabel,"GROWSPRITEICON")) GROWSPRITEICON = lValue;
        else if (!Bstrcmp(szLabel,"GROWAMMO")) GROWAMMO = lValue;
        else if (!Bstrcmp(szLabel,"GLASS")) GLASS = lValue;
        else if (!Bstrcmp(szLabel,"GLASS2")) GLASS2 = lValue;
        else if (!Bstrcmp(szLabel,"GRATE1")) GRATE1 = lValue;
        else if (!Bstrcmp(szLabel,"GENERICPOLE")) GENERICPOLE = lValue;
        else if (!Bstrcmp(szLabel,"GLASSPIECES")) GLASSPIECES = lValue;
        else if (!Bstrcmp(szLabel,"GREENSLIME")) GREENSLIME = lValue;
        else if (!Bstrcmp(szLabel,"GROWSPARK")) GROWSPARK = lValue;
        else if (!Bstrcmp(szLabel,"GETICON")) GETICON = lValue;
        else if (!Bstrcmp(szLabel,"GLAIR")) GLAIR = lValue;
        else if (!Bstrcmp(szLabel,"GLASS3")) GLASS3 = lValue;
        else if (!Bstrcmp(szLabel,"GUNPOWDERBARREL")) GUNPOWDERBARREL = lValue;
        else if (!Bstrcmp(szLabel,"GAVALS")) GAVALS = lValue;
        else if (!Bstrcmp(szLabel,"GAVALS2")) GAVALS2 = lValue;
        else if (!Bstrcmp(szLabel,"GUMBALLMACHINE")) GUMBALLMACHINE = lValue;
        else if (!Bstrcmp(szLabel,"GUMBALLMACHINEBROKE")) GUMBALLMACHINEBROKE = lValue;
        else if (!Bstrcmp(szLabel,"GENERICPOLE2")) GENERICPOLE2 = lValue;
        break;
    case 'H':
        if (!Bstrcmp(szLabel,"HEAVYHBOMB")) HEAVYHBOMB = lValue;
        else if (!Bstrcmp(szLabel,"HEALTHBOX")) HEALTHBOX = lValue;
        else if (!Bstrcmp(szLabel,"HBOMBAMMO")) HBOMBAMMO = lValue;
        else if (!Bstrcmp(szLabel,"HEATSENSOR")) HEATSENSOR = lValue;
        else if (!Bstrcmp(szLabel,"HURTRAIL")) HURTRAIL = lValue;
        else if (!Bstrcmp(szLabel,"HYDROPLANT")) HYDROPLANT = lValue;
        else if (!Bstrcmp(szLabel,"HANGLIGHT")) HANGLIGHT = lValue;
        else if (!Bstrcmp(szLabel,"HYDRENT")) HYDRENT = lValue;
        else if (!Bstrcmp(szLabel,"HANGOOZ")) HANGOOZ = lValue;
        else if (!Bstrcmp(szLabel,"HORSEONSIDE")) HORSEONSIDE = lValue;
        else if (!Bstrcmp(szLabel,"HORSELITE")) HORSELITE = lValue;
        else if (!Bstrcmp(szLabel,"HANDSWITCH")) HANDSWITCH = lValue;
        else if (!Bstrcmp(szLabel,"HANDPRINTSWITCH")) HANDPRINTSWITCH = lValue;
        else if (!Bstrcmp(szLabel,"HELECOPT")) HELECOPT = lValue;
        else if (!Bstrcmp(szLabel,"HOLODUKE")) HOLODUKE = lValue;
        else if (!Bstrcmp(szLabel,"HEADJIB1")) HEADJIB1 = lValue;
        else if (!Bstrcmp(szLabel,"HEADERBAR")) HEADERBAR = lValue;
        else if (!Bstrcmp(szLabel,"HEAT_ICON")) HEAT_ICON = lValue;
        else if (!Bstrcmp(szLabel,"HOLODUKE_ICON")) HOLODUKE_ICON = lValue;
        else if (!Bstrcmp(szLabel,"HAND")) HAND = lValue;
        else if (!Bstrcmp(szLabel,"HANDHOLDINGLASER")) HANDHOLDINGLASER = lValue;
        else if (!Bstrcmp(szLabel,"HANDHOLDINGACCESS")) HANDHOLDINGACCESS = lValue;
        else if (!Bstrcmp(szLabel,"HANDREMOTE")) HANDREMOTE = lValue;
        else if (!Bstrcmp(szLabel,"HANDTHROW")) HANDTHROW = lValue;
        else if (!Bstrcmp(szLabel,"HATRACK")) HATRACK = lValue;
        else if (!Bstrcmp(szLabel,"HOTMEAT")) HOTMEAT = lValue;
        else if (!Bstrcmp(szLabel,"HEADLAMP")) HEADLAMP = lValue;
        break;
    case 'I':
        if (!Bstrcmp(szLabel,"INVENTORYBOX")) INVENTORYBOX = lValue;
        else if (!Bstrcmp(szLabel,"IVUNIT")) IVUNIT = lValue;
        else if (!Bstrcmp(szLabel,"INDY")) INDY = lValue;
        else if (!Bstrcmp(szLabel,"INNERJAW")) INNERJAW = lValue;
        else if (!Bstrcmp(szLabel,"INGAMEDUKETHREEDEE")) INGAMEDUKETHREEDEE = lValue;
        break;
    case 'J':
        if (!Bstrcmp(szLabel,"JETPACK")) JETPACK = lValue;
        else if (!Bstrcmp(szLabel,"JAILBARBREAK")) JAILBARBREAK = lValue;
        else if (!Bstrcmp(szLabel,"JIBS1")) JIBS1 = lValue;
        else if (!Bstrcmp(szLabel,"JIBS2")) JIBS2 = lValue;
        else if (!Bstrcmp(szLabel,"JIBS3")) JIBS3 = lValue;
        else if (!Bstrcmp(szLabel,"JIBS4")) JIBS4 = lValue;
        else if (!Bstrcmp(szLabel,"JIBS5")) JIBS5 = lValue;
        else if (!Bstrcmp(szLabel,"JIBS6")) JIBS6 = lValue;
        else if (!Bstrcmp(szLabel,"JETPACK_ICON")) JETPACK_ICON = lValue;
        else if (!Bstrcmp(szLabel,"JOLLYMEAL")) JOLLYMEAL = lValue;
        else if (!Bstrcmp(szLabel,"JURYGUY")) JURYGUY = lValue;
        break;
    case 'K':
        if (!Bstrcmp(szLabel,"KILLSICON")) KILLSICON = lValue;
        else if (!Bstrcmp(szLabel,"KNEE")) KNEE = lValue;
        break;
    case 'L':
        if (!Bstrcmp(szLabel,"LOCATORS")) LOCATORS = lValue;
        else if (!Bstrcmp(szLabel,"LA")) LA = lValue;
        else if (!Bstrcmp(szLabel,"LIGHTSWITCH")) LIGHTSWITCH = lValue;
        else if (!Bstrcmp(szLabel,"LIGHTSWITCH2")) LIGHTSWITCH2 = lValue;
        else if (!Bstrcmp(szLabel,"LOCKSWITCH1")) LOCKSWITCH1 = lValue;
        else if (!Bstrcmp(szLabel,"LUKE")) LUKE = lValue;
        else if (!Bstrcmp(szLabel,"LOOGIE")) LOOGIE = lValue;
        else if (!Bstrcmp(szLabel,"LIZTROOP")) LIZTROOP = lValue;
        else if (!Bstrcmp(szLabel,"LIZTROOPRUNNING")) LIZTROOPRUNNING = lValue;
        else if (!Bstrcmp(szLabel,"LIZTROOPSTAYPUT")) LIZTROOPSTAYPUT = lValue;
        else if (!Bstrcmp(szLabel,"LIZTOP")) LIZTOP = lValue;
        else if (!Bstrcmp(szLabel,"LIZTROOPSHOOT")) LIZTROOPSHOOT = lValue;
        else if (!Bstrcmp(szLabel,"LIZTROOPJETPACK")) LIZTROOPJETPACK = lValue;
        else if (!Bstrcmp(szLabel,"LIZTROOPDSPRITE")) LIZTROOPDSPRITE = lValue;
        else if (!Bstrcmp(szLabel,"LIZTROOPONTOILET")) LIZTROOPONTOILET = lValue;
        else if (!Bstrcmp(szLabel,"LIZTROOPJUSTSIT")) LIZTROOPJUSTSIT = lValue;
        else if (!Bstrcmp(szLabel,"LIZTROOPDUCKING")) LIZTROOPDUCKING = lValue;
        else if (!Bstrcmp(szLabel,"LEGJIB1")) LEGJIB1 = lValue;
        else if (!Bstrcmp(szLabel,"LIZMAN")) LIZMAN = lValue;
        else if (!Bstrcmp(szLabel,"LIZMANSTAYPUT")) LIZMANSTAYPUT = lValue;
        else if (!Bstrcmp(szLabel,"LIZMANSPITTING")) LIZMANSPITTING = lValue;
        else if (!Bstrcmp(szLabel,"LIZMANFEEDING")) LIZMANFEEDING = lValue;
        else if (!Bstrcmp(szLabel,"LIZMANJUMP")) LIZMANJUMP = lValue;
        else if (!Bstrcmp(szLabel,"LIZMANDEADSPRITE")) LIZMANDEADSPRITE = lValue;
        else if (!Bstrcmp(szLabel,"LIZMANHEAD1")) LIZMANHEAD1 = lValue;
        else if (!Bstrcmp(szLabel,"LIZMANARM1")) LIZMANARM1 = lValue;
        else if (!Bstrcmp(szLabel,"LIZMANLEG1")) LIZMANLEG1 = lValue;
        else if (!Bstrcmp(szLabel,"LOGO")) LOGO = lValue;
        else if (!Bstrcmp(szLabel,"LASERLINE")) LASERLINE = lValue;
        else if (!Bstrcmp(szLabel,"LASERSITE")) LASERSITE = lValue;
        else if (!Bstrcmp(szLabel,"LOADSCREEN")) LOADSCREEN = lValue;
        else if (!Bstrcmp(szLabel,"LAVABUBBLE")) LAVABUBBLE = lValue;
        else if (!Bstrcmp(szLabel,"LETTER")) LETTER = lValue;
        break;
    case 'M':
        if (!Bstrcmp(szLabel,"MUSICANDSFX")) MUSICANDSFX = lValue;
        else if (!Bstrcmp(szLabel,"MASTERSWITCH")) MASTERSWITCH = lValue;
        else if (!Bstrcmp(szLabel,"MIRRORBROKE")) MIRRORBROKE = lValue;
        else if (!Bstrcmp(szLabel,"MOONSKY1")) MOONSKY1 = lValue;
        else if (!Bstrcmp(szLabel,"MOONSKY2")) MOONSKY2 = lValue;
        else if (!Bstrcmp(szLabel,"MOONSKY3")) MOONSKY3 = lValue;
        else if (!Bstrcmp(szLabel,"MOONSKY4")) MOONSKY4 = lValue;
        else if (!Bstrcmp(szLabel,"MULTISWITCH")) MULTISWITCH = lValue;
        else if (!Bstrcmp(szLabel,"MASKWALL9")) MASKWALL9 = lValue;
        else if (!Bstrcmp(szLabel,"MASKWALL1")) MASKWALL1 = lValue;
        else if (!Bstrcmp(szLabel,"MASKWALL10")) MASKWALL10 = lValue;
        else if (!Bstrcmp(szLabel,"MASKWALL11")) MASKWALL11 = lValue;
        else if (!Bstrcmp(szLabel,"MASKWALL5")) MASKWALL5 = lValue;
        else if (!Bstrcmp(szLabel,"MIRROR")) MIRROR = lValue;
        else if (!Bstrcmp(szLabel,"MASKWALL12")) MASKWALL12 = lValue;
        else if (!Bstrcmp(szLabel,"MOVIECAMERA")) MOVIECAMERA = lValue;
        else if (!Bstrcmp(szLabel,"MIKE")) MIKE = lValue;
        else if (!Bstrcmp(szLabel,"MASKWALL13")) MASKWALL13 = lValue;
        else if (!Bstrcmp(szLabel,"MASKWALL2")) MASKWALL2 = lValue;
        else if (!Bstrcmp(szLabel,"MASKWALL3")) MASKWALL3 = lValue;
        else if (!Bstrcmp(szLabel,"MASKWALL4")) MASKWALL4 = lValue;
        else if (!Bstrcmp(szLabel,"MASKWALL14")) MASKWALL14 = lValue;
        else if (!Bstrcmp(szLabel,"MASKWALL15")) MASKWALL15 = lValue;
        else if (!Bstrcmp(szLabel,"MASKWALL6")) MASKWALL6 = lValue;
        else if (!Bstrcmp(szLabel,"MASKWALL8")) MASKWALL8 = lValue;
        else if (!Bstrcmp(szLabel,"MASKWALL7")) MASKWALL7 = lValue;
        else if (!Bstrcmp(szLabel,"MONEY")) MONEY = lValue;
        else if (!Bstrcmp(szLabel,"MONK")) MONK = lValue;
        else if (!Bstrcmp(szLabel,"MORTER")) MORTER = lValue;
        else if (!Bstrcmp(szLabel,"MENUSCREEN")) MENUSCREEN = lValue;
        else if (!Bstrcmp(szLabel,"MENUBAR")) MENUBAR = lValue;
        else if (!Bstrcmp(szLabel,"MOUSECURSOR")) MOUSECURSOR = lValue;
        else if (!Bstrcmp(szLabel,"MINIFONT")) MINIFONT = lValue;
        else if (!Bstrcmp(szLabel,"MAIL")) MAIL = lValue;
        else if (!Bstrcmp(szLabel,"MAILBAG")) MAILBAG = lValue;
        else if (!Bstrcmp(szLabel,"METER")) METER = lValue;
        else if (!Bstrcmp(szLabel,"MACE")) MACE = lValue;
        else if (!Bstrcmp(szLabel,"MOP")) MOP = lValue;
        else if (!Bstrcmp(szLabel,"MAN")) MAN = lValue;
        else if (!Bstrcmp(szLabel,"MAN2")) MAN2 = lValue;
        break;
    case 'N':
        if (!Bstrcmp(szLabel,"NUKEBUTTON")) NUKEBUTTON = lValue;
        else if (!Bstrcmp(szLabel,"NAKED1")) NAKED1 = lValue;
        else if (!Bstrcmp(szLabel,"NEON1")) NEON1 = lValue;
        else if (!Bstrcmp(szLabel,"NEON2")) NEON2 = lValue;
        else if (!Bstrcmp(szLabel,"NEON3")) NEON3 = lValue;
        else if (!Bstrcmp(szLabel,"NEON4")) NEON4 = lValue;
        else if (!Bstrcmp(szLabel,"NEON5")) NEON5 = lValue;
        else if (!Bstrcmp(szLabel,"NEON6")) NEON6 = lValue;
        else if (!Bstrcmp(szLabel,"NUKEBARREL")) NUKEBARREL = lValue;
        else if (!Bstrcmp(szLabel,"NUKEBARRELDENTED")) NUKEBARRELDENTED = lValue;
        else if (!Bstrcmp(szLabel,"NUKEBARRELLEAKED")) NUKEBARRELLEAKED = lValue;
        else if (!Bstrcmp(szLabel,"NOTCHON")) NOTCHON = lValue;
        else if (!Bstrcmp(szLabel,"NOTCHOFF")) NOTCHOFF = lValue;
        else if (!Bstrcmp(szLabel,"NUKEWARNINGICON")) NUKEWARNINGICON = lValue;
        else if (!Bstrcmp(szLabel,"NEWBEAST")) NEWBEAST = lValue;
        else if (!Bstrcmp(szLabel,"NEWBEASTSTAYPUT")) NEWBEASTSTAYPUT = lValue;
        else if (!Bstrcmp(szLabel,"NEWBEASTJUMP")) NEWBEASTJUMP = lValue;
        else if (!Bstrcmp(szLabel,"NEWBEASTHANG")) NEWBEASTHANG = lValue;
        else if (!Bstrcmp(szLabel,"NEWBEASTHANGDEAD")) NEWBEASTHANGDEAD = lValue;
        else if (!Bstrcmp(szLabel,"NATURALLIGHTNING")) NATURALLIGHTNING = lValue;
        break;
    case 'O':
        if (!Bstrcmp(szLabel,"OJ")) OJ = lValue;
        else if (!Bstrcmp(szLabel,"OCEANSPRITE1")) OCEANSPRITE1 = lValue;
        else if (!Bstrcmp(szLabel,"OCEANSPRITE2")) OCEANSPRITE2 = lValue;
        else if (!Bstrcmp(szLabel,"OCEANSPRITE3")) OCEANSPRITE3 = lValue;
        else if (!Bstrcmp(szLabel,"OCEANSPRITE4")) OCEANSPRITE4 = lValue;
        else if (!Bstrcmp(szLabel,"OCEANSPRITE5")) OCEANSPRITE5 = lValue;
        else if (!Bstrcmp(szLabel,"OOZFILTER")) OOZFILTER = lValue;
        else if (!Bstrcmp(szLabel,"OCTABRAIN")) OCTABRAIN = lValue;
        else if (!Bstrcmp(szLabel,"OCTABRAINSTAYPUT")) OCTABRAINSTAYPUT = lValue;
        else if (!Bstrcmp(szLabel,"OCTATOP")) OCTATOP = lValue;
        else if (!Bstrcmp(szLabel,"OCTADEADSPRITE")) OCTADEADSPRITE = lValue;
        else if (!Bstrcmp(szLabel,"OOZ")) OOZ = lValue;
        else if (!Bstrcmp(szLabel,"OOZ2")) OOZ2 = lValue;
        else if (!Bstrcmp(szLabel,"ORGANTIC")) ORGANTIC = lValue;
        else if (!Bstrcmp(szLabel,"ORDERING")) ORDERING = lValue;
        break;
    case 'P':
        if (!Bstrcmp(szLabel,"PANNEL1")) PANNEL1 = lValue;
        else if (!Bstrcmp(szLabel,"PANNEL2")) PANNEL2 = lValue;
        else if (!Bstrcmp(szLabel,"PIPE2")) PIPE2 = lValue;
        else if (!Bstrcmp(szLabel,"PIPE1B")) PIPE1B = lValue;
        else if (!Bstrcmp(szLabel,"PIPE3")) PIPE3 = lValue;
        else if (!Bstrcmp(szLabel,"PIPE1")) PIPE1 = lValue;
        else if (!Bstrcmp(szLabel,"PIPE2B")) PIPE2B = lValue;
        else if (!Bstrcmp(szLabel,"POT1")) POT1 = lValue;
        else if (!Bstrcmp(szLabel,"POT2")) POT2 = lValue;
        else if (!Bstrcmp(szLabel,"POT3")) POT3 = lValue;
        else if (!Bstrcmp(szLabel,"PIPE3B")) PIPE3B = lValue;
        else if (!Bstrcmp(szLabel,"POWERSWITCH1")) POWERSWITCH1 = lValue;
        else if (!Bstrcmp(szLabel,"POWERSWITCH2")) POWERSWITCH2 = lValue;
        else if (!Bstrcmp(szLabel,"POCKET")) POCKET = lValue;
        else if (!Bstrcmp(szLabel,"PIPE5")) PIPE5 = lValue;
        else if (!Bstrcmp(szLabel,"PIPE6")) PIPE6 = lValue;
        else if (!Bstrcmp(szLabel,"PIPE4")) PIPE4 = lValue;
        else if (!Bstrcmp(szLabel,"PIPE4B")) PIPE4B = lValue;
        else if (!Bstrcmp(szLabel,"PIPE5B")) PIPE5B = lValue;
        else if (!Bstrcmp(szLabel,"PLUG")) PLUG = lValue;
        else if (!Bstrcmp(szLabel,"PULLSWITCH")) PULLSWITCH = lValue;
        else if (!Bstrcmp(szLabel,"PIPE6B")) PIPE6B = lValue;
        else if (!Bstrcmp(szLabel,"PODFEM1")) PODFEM1 = lValue;
        else if (!Bstrcmp(szLabel,"PLAYERONWATER")) PLAYERONWATER = lValue;
        else if (!Bstrcmp(szLabel,"PIGCOP")) PIGCOP = lValue;
        else if (!Bstrcmp(szLabel,"PIGCOPSTAYPUT")) PIGCOPSTAYPUT = lValue;
        else if (!Bstrcmp(szLabel,"PIGCOPDIVE")) PIGCOPDIVE = lValue;
        else if (!Bstrcmp(szLabel,"PIGCOPDEADSPRITE")) PIGCOPDEADSPRITE = lValue;
        else if (!Bstrcmp(szLabel,"PIGTOP")) PIGTOP = lValue;
        else if (!Bstrcmp(szLabel,"PLAYERISHERE")) PLAYERISHERE = lValue;
        else if (!Bstrcmp(szLabel,"PLAYERWASHERE")) PLAYERWASHERE = lValue;
        else if (!Bstrcmp(szLabel,"PLUTOPAKSPRITE")) PLUTOPAKSPRITE = lValue;
        else if (!Bstrcmp(szLabel,"POOP")) POOP = lValue;
        else if (!Bstrcmp(szLabel,"PANNEL3")) PANNEL3 = lValue;
        else if (!Bstrcmp(szLabel,"PURPLELAVA")) PURPLELAVA = lValue;
        else if (!Bstrcmp(szLabel,"POLICELIGHTPOLE")) POLICELIGHTPOLE = lValue;
        else if (!Bstrcmp(szLabel,"PUKE")) PUKE = lValue;
        else if (!Bstrcmp(szLabel,"PAPER")) PAPER = lValue;
        else if (!Bstrcmp(szLabel,"PIRATE1A")) PIRATE1A = lValue;
        else if (!Bstrcmp(szLabel,"PIRATE4A")) PIRATE4A = lValue;
        else if (!Bstrcmp(szLabel,"PIRATE2A")) PIRATE2A = lValue;
        else if (!Bstrcmp(szLabel,"PIRATE5A")) PIRATE5A = lValue;
        else if (!Bstrcmp(szLabel,"PIRATE3A")) PIRATE3A = lValue;
        else if (!Bstrcmp(szLabel,"PIRATE6A")) PIRATE6A = lValue;
        else if (!Bstrcmp(szLabel,"PIRATEHALF")) PIRATEHALF = lValue;
        else if (!Bstrcmp(szLabel,"PLEASEWAIT")) PLEASEWAIT = lValue;
        break;
    case 'Q':
        if (!Bstrcmp(szLabel,"QUEBALL")) QUEBALL = lValue;
        break;
    case 'R':
        if (!Bstrcmp(szLabel,"RESPAWN")) RESPAWN = lValue;
        else if (!Bstrcmp(szLabel,"RPGSPRITE")) RPGSPRITE = lValue;
        else if (!Bstrcmp(szLabel,"RPGAMMO")) RPGAMMO = lValue;
        else if (!Bstrcmp(szLabel,"REDSKY1")) REDSKY1 = lValue;
        else if (!Bstrcmp(szLabel,"REDSKY2")) REDSKY2 = lValue;
        else if (!Bstrcmp(szLabel,"REFLECTWATERTILE")) REFLECTWATERTILE = lValue;
        else if (!Bstrcmp(szLabel,"REACTOR2")) REACTOR2 = lValue;
        else if (!Bstrcmp(szLabel,"REACTOR2BURNT")) REACTOR2BURNT = lValue;
        else if (!Bstrcmp(szLabel,"REACTOR2SPARK")) REACTOR2SPARK = lValue;
        else if (!Bstrcmp(szLabel,"RUBBERCAN")) RUBBERCAN = lValue;
        else if (!Bstrcmp(szLabel,"REACTOR")) REACTOR = lValue;
        else if (!Bstrcmp(szLabel,"REACTORSPARK")) REACTORSPARK = lValue;
        else if (!Bstrcmp(szLabel,"REACTORBURNT")) REACTORBURNT = lValue;
        else if (!Bstrcmp(szLabel,"RAT")) RAT = lValue;
        else if (!Bstrcmp(szLabel,"RADIUSEXPLOSION")) RADIUSEXPLOSION = lValue;
        else if (!Bstrcmp(szLabel,"RECON")) RECON = lValue;
        else if (!Bstrcmp(szLabel,"ROTATEGUN")) ROTATEGUN = lValue;
        else if (!Bstrcmp(szLabel,"RPGGUN")) RPGGUN = lValue;
        else if (!Bstrcmp(szLabel,"RPGMUZZLEFLASH")) RPGMUZZLEFLASH = lValue;
        else if (!Bstrcmp(szLabel,"RPG")) RPG = lValue;
        else if (!Bstrcmp(szLabel,"RESPAWNMARKERRED")) RESPAWNMARKERRED = lValue;
        else if (!Bstrcmp(szLabel,"RESPAWNMARKERYELLOW")) RESPAWNMARKERYELLOW = lValue;
        else if (!Bstrcmp(szLabel,"RESPAWNMARKERGREEN")) RESPAWNMARKERGREEN = lValue;
        else if (!Bstrcmp(szLabel,"ROBOTDOG")) ROBOTDOG = lValue;
        else if (!Bstrcmp(szLabel,"ROBOTPIRATE")) ROBOTPIRATE = lValue;
        else if (!Bstrcmp(szLabel,"ROBOTMOUSE")) ROBOTMOUSE = lValue;
        else if (!Bstrcmp(szLabel,"ROBOTDOG2")) ROBOTDOG2 = lValue;
        else if (!Bstrcmp(szLabel,"RESERVEDSLOT1")) RESERVEDSLOT1 = lValue;
        else if (!Bstrcmp(szLabel,"RESERVEDSLOT2")) RESERVEDSLOT2 = lValue;
        else if (!Bstrcmp(szLabel,"RESERVEDSLOT3")) RESERVEDSLOT3 = lValue;
        else if (!Bstrcmp(szLabel,"RESERVEDSLOT4")) RESERVEDSLOT4 = lValue;
        else if (!Bstrcmp(szLabel,"RESERVEDSLOT5")) RESERVEDSLOT5 = lValue;
        else if (!Bstrcmp(szLabel,"RESERVEDSLOT6")) RESERVEDSLOT6 = lValue;
        else if (!Bstrcmp(szLabel,"RESERVEDSLOT7")) RESERVEDSLOT7 = lValue;
        else if (!Bstrcmp(szLabel,"RESERVEDSLOT8")) RESERVEDSLOT8 = lValue;
        else if (!Bstrcmp(szLabel,"RESERVEDSLOT9")) RESERVEDSLOT9 = lValue;
        else if (!Bstrcmp(szLabel,"RESERVEDSLOT10")) RESERVEDSLOT10 = lValue;
        else if (!Bstrcmp(szLabel,"RESERVEDSLOT11")) RESERVEDSLOT11 = lValue;
        else if (!Bstrcmp(szLabel,"RESERVEDSLOT12")) RESERVEDSLOT12 = lValue;
        break;
    case 'S':
        if (!Bstrcmp(szLabel,"SECTOREFFECTOR")) SECTOREFFECTOR = lValue;
        else if (!Bstrcmp(szLabel,"SHRINKERSPRITE")) SHRINKERSPRITE = lValue;
        else if (!Bstrcmp(szLabel,"SHOTGUNSPRITE")) SHOTGUNSPRITE = lValue;
        else if (!Bstrcmp(szLabel,"SHOTGUNAMMO")) SHOTGUNAMMO = lValue;
        else if (!Bstrcmp(szLabel,"SIXPAK")) SIXPAK = lValue;
        else if (!Bstrcmp(szLabel,"SHIELD")) SHIELD = lValue;
        else if (!Bstrcmp(szLabel,"STEROIDS")) STEROIDS = lValue;
        else if (!Bstrcmp(szLabel,"SLOTDOOR")) SLOTDOOR = lValue;
        else if (!Bstrcmp(szLabel,"SPACEDOORSWITCH")) SPACEDOORSWITCH = lValue;
        else if (!Bstrcmp(szLabel,"SPACELIGHTSWITCH")) SPACELIGHTSWITCH = lValue;
        else if (!Bstrcmp(szLabel,"SCREENBREAK1")) SCREENBREAK1 = lValue;
        else if (!Bstrcmp(szLabel,"SCREENBREAK2")) SCREENBREAK2 = lValue;
        else if (!Bstrcmp(szLabel,"SCREENBREAK3")) SCREENBREAK3 = lValue;
        else if (!Bstrcmp(szLabel,"SCREENBREAK4")) SCREENBREAK4 = lValue;
        else if (!Bstrcmp(szLabel,"SCREENBREAK5")) SCREENBREAK5 = lValue;
        else if (!Bstrcmp(szLabel,"SCREENBREAK6")) SCREENBREAK6 = lValue;
        else if (!Bstrcmp(szLabel,"SCREENBREAK7")) SCREENBREAK7 = lValue;
        else if (!Bstrcmp(szLabel,"SCREENBREAK8")) SCREENBREAK8 = lValue;
        else if (!Bstrcmp(szLabel,"SCREENBREAK9")) SCREENBREAK9 = lValue;
        else if (!Bstrcmp(szLabel,"SCREENBREAK10")) SCREENBREAK10 = lValue;
        else if (!Bstrcmp(szLabel,"SCREENBREAK11")) SCREENBREAK11 = lValue;
        else if (!Bstrcmp(szLabel,"SCREENBREAK12")) SCREENBREAK12 = lValue;
        else if (!Bstrcmp(szLabel,"SCREENBREAK13")) SCREENBREAK13 = lValue;
        else if (!Bstrcmp(szLabel,"STATIC")) STATIC = lValue;
        else if (!Bstrcmp(szLabel,"SATELLITE")) SATELLITE = lValue;
        else if (!Bstrcmp(szLabel,"STAINGLASS1")) STAINGLASS1 = lValue;
        else if (!Bstrcmp(szLabel,"SATELITE")) SATELITE = lValue;
        else if (!Bstrcmp(szLabel,"SLIMEPIPE")) SLIMEPIPE = lValue;
        else if (!Bstrcmp(szLabel,"STALL")) STALL = lValue;
        else if (!Bstrcmp(szLabel,"STALLBROKE")) STALLBROKE = lValue;
        else if (!Bstrcmp(szLabel,"SOLARPANNEL")) SOLARPANNEL = lValue;
        else if (!Bstrcmp(szLabel,"SPLINTERWOOD")) SPLINTERWOOD = lValue;
        else if (!Bstrcmp(szLabel,"SCALE")) SCALE = lValue;
        else if (!Bstrcmp(szLabel,"STATUE")) STATUE = lValue;
        else if (!Bstrcmp(szLabel,"SUSHIPLATE1")) SUSHIPLATE1 = lValue;
        else if (!Bstrcmp(szLabel,"SUSHIPLATE2")) SUSHIPLATE2 = lValue;
        else if (!Bstrcmp(szLabel,"SUSHIPLATE3")) SUSHIPLATE3 = lValue;
        else if (!Bstrcmp(szLabel,"SUSHIPLATE4")) SUSHIPLATE4 = lValue;
        else if (!Bstrcmp(szLabel,"SUSHIPLATE5")) SUSHIPLATE5 = lValue;
        else if (!Bstrcmp(szLabel,"STATUEFLASH")) STATUEFLASH = lValue;
        else if (!Bstrcmp(szLabel,"STRIPEBALL")) STRIPEBALL = lValue;
        else if (!Bstrcmp(szLabel,"SPOTLITE")) SPOTLITE = lValue;
        else if (!Bstrcmp(szLabel,"SEENINE")) SEENINE = lValue;
        else if (!Bstrcmp(szLabel,"SEENINEDEAD")) SEENINEDEAD = lValue;
        else if (!Bstrcmp(szLabel,"STEAM")) STEAM = lValue;
        else if (!Bstrcmp(szLabel,"SPACEMARINE")) SPACEMARINE = lValue;
        else if (!Bstrcmp(szLabel,"SCRATCH")) SCRATCH = lValue;
        else if (!Bstrcmp(szLabel,"SHARK")) SHARK = lValue;
        else if (!Bstrcmp(szLabel,"SPIT")) SPIT = lValue;
        else if (!Bstrcmp(szLabel,"SHRINKSPARK")) SHRINKSPARK = lValue;
        else if (!Bstrcmp(szLabel,"SHRINKEREXPLOSION")) SHRINKEREXPLOSION = lValue;
        else if (!Bstrcmp(szLabel,"SMALLSMOKE")) SMALLSMOKE = lValue;
        else if (!Bstrcmp(szLabel,"SMALLSMOKEMAKER")) SMALLSMOKEMAKER = lValue;
        else if (!Bstrcmp(szLabel,"SCRAP6")) SCRAP6 = lValue;
        else if (!Bstrcmp(szLabel,"SCRAP1")) SCRAP1 = lValue;
        else if (!Bstrcmp(szLabel,"SCRAP2")) SCRAP2 = lValue;
        else if (!Bstrcmp(szLabel,"SCRAP3")) SCRAP3 = lValue;
        else if (!Bstrcmp(szLabel,"SCRAP4")) SCRAP4 = lValue;
        else if (!Bstrcmp(szLabel,"SCRAP5")) SCRAP5 = lValue;
        else if (!Bstrcmp(szLabel,"SELECTDIR")) SELECTDIR = lValue;
        else if (!Bstrcmp(szLabel,"STEROIDS_ICON")) STEROIDS_ICON = lValue;
        else if (!Bstrcmp(szLabel,"SLIDEBAR")) SLIDEBAR = lValue;
        else if (!Bstrcmp(szLabel,"SHELL")) SHELL = lValue;
        else if (!Bstrcmp(szLabel,"SHOTGUNSHELL")) SHOTGUNSHELL = lValue;
        else if (!Bstrcmp(szLabel,"SHRINKER")) SHRINKER = lValue;
        else if (!Bstrcmp(szLabel,"SCUBAMASK")) SCUBAMASK = lValue;
        else if (!Bstrcmp(szLabel,"SPACEMASK")) SPACEMASK = lValue;
        else if (!Bstrcmp(szLabel,"SHOTSPARK1")) SHOTSPARK1 = lValue;
        else if (!Bstrcmp(szLabel,"SHOTGUN")) SHOTGUN = lValue;
        else if (!Bstrcmp(szLabel,"SPINNINGNUKEICON")) SPINNINGNUKEICON = lValue;
        else if (!Bstrcmp(szLabel,"SMALLFNTCURSOR")) SMALLFNTCURSOR = lValue;
        else if (!Bstrcmp(szLabel,"STARTALPHANUM")) STARTALPHANUM = lValue;
        else if (!Bstrcmp(szLabel,"SCREENBREAK14")) SCREENBREAK14 = lValue;
        else if (!Bstrcmp(szLabel,"SCREENBREAK15")) SCREENBREAK15 = lValue;
        else if (!Bstrcmp(szLabel,"SCREENBREAK19")) SCREENBREAK19 = lValue;
        else if (!Bstrcmp(szLabel,"SCREENBREAK16")) SCREENBREAK16 = lValue;
        else if (!Bstrcmp(szLabel,"SCREENBREAK17")) SCREENBREAK17 = lValue;
        else if (!Bstrcmp(szLabel,"SCREENBREAK18")) SCREENBREAK18 = lValue;
        else if (!Bstrcmp(szLabel,"SPEAKER")) SPEAKER = lValue;
        else if (!Bstrcmp(szLabel,"SIDEBOLT1")) SIDEBOLT1 = lValue;
        else if (!Bstrcmp(szLabel,"SKINNEDCHICKEN")) SKINNEDCHICKEN = lValue;
        else if (!Bstrcmp(szLabel,"SHOPPINGCART")) SHOPPINGCART = lValue;
        else if (!Bstrcmp(szLabel,"SNAKEP")) SNAKEP = lValue;
        else if (!Bstrcmp(szLabel,"SIGN1")) SIGN1 = lValue;
        else if (!Bstrcmp(szLabel,"SIGN2")) SIGN2 = lValue;
        break;
    case 'T':
        if (!Bstrcmp(szLabel,"TOUCHPLATE")) TOUCHPLATE = lValue;
        else if (!Bstrcmp(szLabel,"TRIPBOMBSPRITE")) TRIPBOMBSPRITE = lValue;
        else if (!Bstrcmp(szLabel,"TECHLIGHT2")) TECHLIGHT2 = lValue;
        else if (!Bstrcmp(szLabel,"TECHLIGHTBUST2")) TECHLIGHTBUST2 = lValue;
        else if (!Bstrcmp(szLabel,"TECHLIGHT4")) TECHLIGHT4 = lValue;
        else if (!Bstrcmp(szLabel,"TECHLIGHTBUST4")) TECHLIGHTBUST4 = lValue;
        else if (!Bstrcmp(szLabel,"TECHSWITCH")) TECHSWITCH = lValue;
        else if (!Bstrcmp(szLabel,"TOILET")) TOILET = lValue;
        else if (!Bstrcmp(szLabel,"TOILETBROKE")) TOILETBROKE = lValue;
        else if (!Bstrcmp(szLabel,"TREE1")) TREE1 = lValue;
        else if (!Bstrcmp(szLabel,"TREE2")) TREE2 = lValue;
        else if (!Bstrcmp(szLabel,"TOILETWATER")) TOILETWATER = lValue;
        else if (!Bstrcmp(szLabel,"TIRE")) TIRE = lValue;
        else if (!Bstrcmp(szLabel,"TRANSPORTERBEAM")) TRANSPORTERBEAM = lValue;
        else if (!Bstrcmp(szLabel,"TRASH")) TRASH = lValue;
        else if (!Bstrcmp(szLabel,"TRANSPORTERSTAR")) TRANSPORTERSTAR = lValue;
        else if (!Bstrcmp(szLabel,"TONGUE")) TONGUE = lValue;
        else if (!Bstrcmp(szLabel,"TANK")) TANK = lValue;
        else if (!Bstrcmp(szLabel,"TITLE")) TITLE = lValue;
        else if (!Bstrcmp(szLabel,"TEXTBOX")) TEXTBOX = lValue;
        else if (!Bstrcmp(szLabel,"THREEDEE")) THREEDEE = lValue;
        else if (!Bstrcmp(szLabel,"TENSCREEN")) TENSCREEN = lValue;
        else if (!Bstrcmp(szLabel,"TRIPBOMB")) TRIPBOMB = lValue;
        else if (!Bstrcmp(szLabel,"TIP")) TIP = lValue;
        else if (!Bstrcmp(szLabel,"THREEBYFIVE")) THREEBYFIVE = lValue;
        else if (!Bstrcmp(szLabel,"TEXTSTORY")) TEXTSTORY = lValue;
        else if (!Bstrcmp(szLabel,"TARGET")) TARGET = lValue;
        else if (!Bstrcmp(szLabel,"TOPSECRET")) TOPSECRET = lValue;
        else if (!Bstrcmp(szLabel,"TEDDYBEAR")) TEDDYBEAR = lValue;
        else if (!Bstrcmp(szLabel,"TRIPODCAMERA")) TRIPODCAMERA = lValue;
        else if (!Bstrcmp(szLabel,"TAMPON")) TAMPON = lValue;
        else if (!Bstrcmp(szLabel,"TOUGHGAL")) TOUGHGAL = lValue;
        break;
    case 'U':
        if (!Bstrcmp(szLabel,"USERWEAPON")) USERWEAPON = lValue;
        break;
    case 'V':
        if (!Bstrcmp(szLabel,"VIEWSCREEN2")) VIEWSCREEN2 = lValue;
        else if (!Bstrcmp(szLabel,"VIEWSCREENBROKE")) VIEWSCREENBROKE = lValue;
        else if (!Bstrcmp(szLabel,"VIEWSCREEN")) VIEWSCREEN = lValue;
        else if (!Bstrcmp(szLabel,"VACUUM")) VACUUM = lValue;
        else if (!Bstrcmp(szLabel,"VASE")) VASE = lValue;
        else if (!Bstrcmp(szLabel,"VENDMACHINE")) VENDMACHINE = lValue;
        else if (!Bstrcmp(szLabel,"VENDMACHINEBROKE")) VENDMACHINEBROKE = lValue;
        else if (!Bstrcmp(szLabel,"VIEWBORDER")) VIEWBORDER = lValue;
        else if (!Bstrcmp(szLabel,"VICTORY1")) VICTORY1 = lValue;
        break;
    case 'W':
        if (!Bstrcmp(szLabel,"WALLLIGHT4")) WALLLIGHT4 = lValue;
        else if (!Bstrcmp(szLabel,"WALLLIGHTBUST4")) WALLLIGHTBUST4 = lValue;
        else if (!Bstrcmp(szLabel,"W_LIGHT")) W_LIGHT = lValue;
        else if (!Bstrcmp(szLabel,"W_TECHWALL1")) W_TECHWALL1 = lValue;
        else if (!Bstrcmp(szLabel,"W_TECHWALL2")) W_TECHWALL2 = lValue;
        else if (!Bstrcmp(szLabel,"W_TECHWALL15")) W_TECHWALL15 = lValue;
        else if (!Bstrcmp(szLabel,"W_TECHWALL3")) W_TECHWALL3 = lValue;
        else if (!Bstrcmp(szLabel,"W_TECHWALL4")) W_TECHWALL4 = lValue;
        else if (!Bstrcmp(szLabel,"W_TECHWALL10")) W_TECHWALL10 = lValue;
        else if (!Bstrcmp(szLabel,"W_TECHWALL16")) W_TECHWALL16 = lValue;
        else if (!Bstrcmp(szLabel,"WATERTILE2")) WATERTILE2 = lValue;
        else if (!Bstrcmp(szLabel,"WATERTILE")) WATERTILE = lValue;
        else if (!Bstrcmp(szLabel,"W_SCREENBREAK")) W_SCREENBREAK = lValue;
        else if (!Bstrcmp(szLabel,"W_HITTECHWALL3")) W_HITTECHWALL3 = lValue;
        else if (!Bstrcmp(szLabel,"W_HITTECHWALL4")) W_HITTECHWALL4 = lValue;
        else if (!Bstrcmp(szLabel,"W_HITTECHWALL2")) W_HITTECHWALL2 = lValue;
        else if (!Bstrcmp(szLabel,"W_HITTECHWALL1")) W_HITTECHWALL1 = lValue;
        else if (!Bstrcmp(szLabel,"WATERFOUNTAIN")) WATERFOUNTAIN = lValue;
        else if (!Bstrcmp(szLabel,"WATERFOUNTAINBROKE")) WATERFOUNTAINBROKE = lValue;
        else if (!Bstrcmp(szLabel,"W_NUMBERS")) W_NUMBERS = lValue;
        else if (!Bstrcmp(szLabel,"WATERDRIP")) WATERDRIP = lValue;
        else if (!Bstrcmp(szLabel,"WATERBUBBLE")) WATERBUBBLE = lValue;
        else if (!Bstrcmp(szLabel,"WATERBUBBLEMAKER")) WATERBUBBLEMAKER = lValue;
        else if (!Bstrcmp(szLabel,"W_FORCEFIELD")) W_FORCEFIELD = lValue;
        else if (!Bstrcmp(szLabel,"WALLLIGHT3")) WALLLIGHT3 = lValue;
        else if (!Bstrcmp(szLabel,"WALLLIGHTBUST3")) WALLLIGHTBUST3 = lValue;
        else if (!Bstrcmp(szLabel,"WALLLIGHT1")) WALLLIGHT1 = lValue;
        else if (!Bstrcmp(szLabel,"WALLLIGHTBUST1")) WALLLIGHTBUST1 = lValue;
        else if (!Bstrcmp(szLabel,"WALLLIGHT2")) WALLLIGHT2 = lValue;
        else if (!Bstrcmp(szLabel,"WALLLIGHTBUST2")) WALLLIGHTBUST2 = lValue;
        else if (!Bstrcmp(szLabel,"WAITTOBESEATED")) WAITTOBESEATED = lValue;
        else if (!Bstrcmp(szLabel,"WOODENHORSE")) WOODENHORSE = lValue;
        else if (!Bstrcmp(szLabel,"WATERSPLASH2")) WATERSPLASH2 = lValue;
        else if (!Bstrcmp(szLabel,"WALLBLOOD1")) WALLBLOOD1 = lValue;
        else if (!Bstrcmp(szLabel,"WALLBLOOD2")) WALLBLOOD2 = lValue;
        else if (!Bstrcmp(szLabel,"WALLBLOOD3")) WALLBLOOD3 = lValue;
        else if (!Bstrcmp(szLabel,"WALLBLOOD4")) WALLBLOOD4 = lValue;
        else if (!Bstrcmp(szLabel,"WALLBLOOD5")) WALLBLOOD5 = lValue;
        else if (!Bstrcmp(szLabel,"WALLBLOOD6")) WALLBLOOD6 = lValue;
        else if (!Bstrcmp(szLabel,"WALLBLOOD7")) WALLBLOOD7 = lValue;
        else if (!Bstrcmp(szLabel,"WALLBLOOD8")) WALLBLOOD8 = lValue;
        else if (!Bstrcmp(szLabel,"WATERDRIPSPLASH")) WATERDRIPSPLASH = lValue;
        else if (!Bstrcmp(szLabel,"WINDOWBORDER1")) WINDOWBORDER1 = lValue;
        else if (!Bstrcmp(szLabel,"WINDOWBORDER2")) WINDOWBORDER2 = lValue;
        else if (!Bstrcmp(szLabel,"W_TECHWALL11")) W_TECHWALL11 = lValue;
        else if (!Bstrcmp(szLabel,"W_TECHWALL12")) W_TECHWALL12 = lValue;
        else if (!Bstrcmp(szLabel,"W_TECHWALL13")) W_TECHWALL13 = lValue;
        else if (!Bstrcmp(szLabel,"W_TECHWALL14")) W_TECHWALL14 = lValue;
        else if (!Bstrcmp(szLabel,"W_TECHWALL5")) W_TECHWALL5 = lValue;
        else if (!Bstrcmp(szLabel,"W_TECHWALL6")) W_TECHWALL6 = lValue;
        else if (!Bstrcmp(szLabel,"W_TECHWALL7")) W_TECHWALL7 = lValue;
        else if (!Bstrcmp(szLabel,"W_TECHWALL8")) W_TECHWALL8 = lValue;
        else if (!Bstrcmp(szLabel,"W_TECHWALL9")) W_TECHWALL9 = lValue;
        else if (!Bstrcmp(szLabel,"W_HITTECHWALL16")) W_HITTECHWALL16 = lValue;
        else if (!Bstrcmp(szLabel,"W_HITTECHWALL10")) W_HITTECHWALL10 = lValue;
        else if (!Bstrcmp(szLabel,"W_HITTECHWALL15")) W_HITTECHWALL15 = lValue;
        else if (!Bstrcmp(szLabel,"W_MILKSHELF")) W_MILKSHELF = lValue;
        else if (!Bstrcmp(szLabel,"W_MILKSHELFBROKE")) W_MILKSHELFBROKE = lValue;
        else if (!Bstrcmp(szLabel,"WETFLOOR")) WETFLOOR = lValue;
        else if (!Bstrcmp(szLabel,"WOMAN")) WOMAN = lValue;
        else if (!Bstrcmp(szLabel,"WEATHERWARN")) WEATHERWARN = lValue;
        break;
    case 'X':
        if (!Bstrcmp(szLabel,"XXXSTACY")) XXXSTACY = lValue;
        break;
    }
}

void setupdynamictostatic(void)
{
    clearbufbyte(dynamictostatic,MAXTILES,0);
    dynamictostatic[SECTOREFFECTOR] = SECTOREFFECTOR__STATIC;
    dynamictostatic[ACTIVATOR] = ACTIVATOR__STATIC;
    dynamictostatic[TOUCHPLATE] = TOUCHPLATE__STATIC;
    dynamictostatic[ACTIVATORLOCKED] = ACTIVATORLOCKED__STATIC;
    dynamictostatic[MUSICANDSFX] = MUSICANDSFX__STATIC;
    dynamictostatic[LOCATORS] = LOCATORS__STATIC;
    dynamictostatic[CYCLER] = CYCLER__STATIC;
    dynamictostatic[MASTERSWITCH] = MASTERSWITCH__STATIC;
    dynamictostatic[RESPAWN] = RESPAWN__STATIC;
    dynamictostatic[GPSPEED] = GPSPEED__STATIC;
    dynamictostatic[FOF] = FOF__STATIC;
    dynamictostatic[ARROW] = ARROW__STATIC;
    dynamictostatic[FIRSTGUNSPRITE] = FIRSTGUNSPRITE__STATIC;
    dynamictostatic[CHAINGUNSPRITE] = CHAINGUNSPRITE__STATIC;
    dynamictostatic[RPGSPRITE] = RPGSPRITE__STATIC;
    dynamictostatic[FREEZESPRITE] = FREEZESPRITE__STATIC;
    dynamictostatic[SHRINKERSPRITE] = SHRINKERSPRITE__STATIC;
    dynamictostatic[HEAVYHBOMB] = HEAVYHBOMB__STATIC;
    dynamictostatic[TRIPBOMBSPRITE] = TRIPBOMBSPRITE__STATIC;
    dynamictostatic[SHOTGUNSPRITE] = SHOTGUNSPRITE__STATIC;
    dynamictostatic[DEVISTATORSPRITE] = DEVISTATORSPRITE__STATIC;
    dynamictostatic[HEALTHBOX] = HEALTHBOX__STATIC;
    dynamictostatic[AMMOBOX] = AMMOBOX__STATIC;
    dynamictostatic[GROWSPRITEICON] = GROWSPRITEICON__STATIC;
    dynamictostatic[INVENTORYBOX] = INVENTORYBOX__STATIC;
    dynamictostatic[FREEZEAMMO] = FREEZEAMMO__STATIC;
    dynamictostatic[AMMO] = AMMO__STATIC;
    dynamictostatic[BATTERYAMMO] = BATTERYAMMO__STATIC;
    dynamictostatic[DEVISTATORAMMO] = DEVISTATORAMMO__STATIC;
    dynamictostatic[RPGAMMO] = RPGAMMO__STATIC;
    dynamictostatic[GROWAMMO] = GROWAMMO__STATIC;
    dynamictostatic[CRYSTALAMMO] = CRYSTALAMMO__STATIC;
    dynamictostatic[HBOMBAMMO] = HBOMBAMMO__STATIC;
    dynamictostatic[AMMOLOTS] = AMMOLOTS__STATIC;
    dynamictostatic[SHOTGUNAMMO] = SHOTGUNAMMO__STATIC;
    dynamictostatic[COLA] = COLA__STATIC;
    dynamictostatic[SIXPAK] = SIXPAK__STATIC;
    dynamictostatic[FIRSTAID] = FIRSTAID__STATIC;
    dynamictostatic[SHIELD] = SHIELD__STATIC;
    dynamictostatic[STEROIDS] = STEROIDS__STATIC;
    dynamictostatic[AIRTANK] = AIRTANK__STATIC;
    dynamictostatic[JETPACK] = JETPACK__STATIC;
    dynamictostatic[HEATSENSOR] = HEATSENSOR__STATIC;
    dynamictostatic[ACCESSCARD] = ACCESSCARD__STATIC;
    dynamictostatic[BOOTS] = BOOTS__STATIC;
    dynamictostatic[MIRRORBROKE] = MIRRORBROKE__STATIC;
    dynamictostatic[CLOUDYOCEAN] = CLOUDYOCEAN__STATIC;
    dynamictostatic[CLOUDYSKIES] = CLOUDYSKIES__STATIC;
    dynamictostatic[MOONSKY1] = MOONSKY1__STATIC;
    dynamictostatic[MOONSKY2] = MOONSKY2__STATIC;
    dynamictostatic[MOONSKY3] = MOONSKY3__STATIC;
    dynamictostatic[MOONSKY4] = MOONSKY4__STATIC;
    dynamictostatic[BIGORBIT1] = BIGORBIT1__STATIC;
    dynamictostatic[BIGORBIT2] = BIGORBIT2__STATIC;
    dynamictostatic[BIGORBIT3] = BIGORBIT3__STATIC;
    dynamictostatic[BIGORBIT4] = BIGORBIT4__STATIC;
    dynamictostatic[BIGORBIT5] = BIGORBIT5__STATIC;
    dynamictostatic[LA] = LA__STATIC;
    dynamictostatic[REDSKY1] = REDSKY1__STATIC;
    dynamictostatic[REDSKY2] = REDSKY2__STATIC;
    dynamictostatic[ATOMICHEALTH] = ATOMICHEALTH__STATIC;
    dynamictostatic[TECHLIGHT2] = TECHLIGHT2__STATIC;
    dynamictostatic[TECHLIGHTBUST2] = TECHLIGHTBUST2__STATIC;
    dynamictostatic[TECHLIGHT4] = TECHLIGHT4__STATIC;
    dynamictostatic[TECHLIGHTBUST4] = TECHLIGHTBUST4__STATIC;
    dynamictostatic[WALLLIGHT4] = WALLLIGHT4__STATIC;
    dynamictostatic[WALLLIGHTBUST4] = WALLLIGHTBUST4__STATIC;
    dynamictostatic[ACCESSSWITCH] = ACCESSSWITCH__STATIC;
    dynamictostatic[SLOTDOOR] = SLOTDOOR__STATIC;
    dynamictostatic[LIGHTSWITCH] = LIGHTSWITCH__STATIC;
    dynamictostatic[SPACEDOORSWITCH] = SPACEDOORSWITCH__STATIC;
    dynamictostatic[SPACELIGHTSWITCH] = SPACELIGHTSWITCH__STATIC;
    dynamictostatic[FRANKENSTINESWITCH] = FRANKENSTINESWITCH__STATIC;
    dynamictostatic[NUKEBUTTON] = NUKEBUTTON__STATIC;
    dynamictostatic[MULTISWITCH] = MULTISWITCH__STATIC;
    dynamictostatic[DOORTILE5] = DOORTILE5__STATIC;
    dynamictostatic[DOORTILE6] = DOORTILE6__STATIC;
    dynamictostatic[DOORTILE1] = DOORTILE1__STATIC;
    dynamictostatic[DOORTILE2] = DOORTILE2__STATIC;
    dynamictostatic[DOORTILE3] = DOORTILE3__STATIC;
    dynamictostatic[DOORTILE4] = DOORTILE4__STATIC;
    dynamictostatic[DOORTILE7] = DOORTILE7__STATIC;
    dynamictostatic[DOORTILE8] = DOORTILE8__STATIC;
    dynamictostatic[DOORTILE9] = DOORTILE9__STATIC;
    dynamictostatic[DOORTILE10] = DOORTILE10__STATIC;
    dynamictostatic[DOORSHOCK] = DOORSHOCK__STATIC;
    dynamictostatic[DIPSWITCH] = DIPSWITCH__STATIC;
    dynamictostatic[DIPSWITCH2] = DIPSWITCH2__STATIC;
    dynamictostatic[TECHSWITCH] = TECHSWITCH__STATIC;
    dynamictostatic[DIPSWITCH3] = DIPSWITCH3__STATIC;
    dynamictostatic[ACCESSSWITCH2] = ACCESSSWITCH2__STATIC;
    dynamictostatic[REFLECTWATERTILE] = REFLECTWATERTILE__STATIC;
    dynamictostatic[FLOORSLIME] = FLOORSLIME__STATIC;
    dynamictostatic[BIGFORCE] = BIGFORCE__STATIC;
    dynamictostatic[EPISODE] = EPISODE__STATIC;
    dynamictostatic[MASKWALL9] = MASKWALL9__STATIC;
    dynamictostatic[W_LIGHT] = W_LIGHT__STATIC;
    dynamictostatic[SCREENBREAK1] = SCREENBREAK1__STATIC;
    dynamictostatic[SCREENBREAK2] = SCREENBREAK2__STATIC;
    dynamictostatic[SCREENBREAK3] = SCREENBREAK3__STATIC;
    dynamictostatic[SCREENBREAK4] = SCREENBREAK4__STATIC;
    dynamictostatic[SCREENBREAK5] = SCREENBREAK5__STATIC;
    dynamictostatic[SCREENBREAK6] = SCREENBREAK6__STATIC;
    dynamictostatic[SCREENBREAK7] = SCREENBREAK7__STATIC;
    dynamictostatic[SCREENBREAK8] = SCREENBREAK8__STATIC;
    dynamictostatic[SCREENBREAK9] = SCREENBREAK9__STATIC;
    dynamictostatic[SCREENBREAK10] = SCREENBREAK10__STATIC;
    dynamictostatic[SCREENBREAK11] = SCREENBREAK11__STATIC;
    dynamictostatic[SCREENBREAK12] = SCREENBREAK12__STATIC;
    dynamictostatic[SCREENBREAK13] = SCREENBREAK13__STATIC;
    dynamictostatic[MASKWALL1] = MASKWALL1__STATIC;
    dynamictostatic[W_TECHWALL1] = W_TECHWALL1__STATIC;
    dynamictostatic[W_TECHWALL2] = W_TECHWALL2__STATIC;
    dynamictostatic[W_TECHWALL15] = W_TECHWALL15__STATIC;
    dynamictostatic[W_TECHWALL3] = W_TECHWALL3__STATIC;
    dynamictostatic[W_TECHWALL4] = W_TECHWALL4__STATIC;
    dynamictostatic[W_TECHWALL10] = W_TECHWALL10__STATIC;
    dynamictostatic[W_TECHWALL16] = W_TECHWALL16__STATIC;
    dynamictostatic[WATERTILE2] = WATERTILE2__STATIC;
    dynamictostatic[BPANNEL1] = BPANNEL1__STATIC;
    dynamictostatic[PANNEL1] = PANNEL1__STATIC;
    dynamictostatic[PANNEL2] = PANNEL2__STATIC;
    dynamictostatic[WATERTILE] = WATERTILE__STATIC;
    dynamictostatic[STATIC] = STATIC__STATIC;
    dynamictostatic[W_SCREENBREAK] = W_SCREENBREAK__STATIC;
    dynamictostatic[W_HITTECHWALL3] = W_HITTECHWALL3__STATIC;
    dynamictostatic[W_HITTECHWALL4] = W_HITTECHWALL4__STATIC;
    dynamictostatic[W_HITTECHWALL2] = W_HITTECHWALL2__STATIC;
    dynamictostatic[W_HITTECHWALL1] = W_HITTECHWALL1__STATIC;
    dynamictostatic[MASKWALL10] = MASKWALL10__STATIC;
    dynamictostatic[MASKWALL11] = MASKWALL11__STATIC;
    dynamictostatic[DOORTILE22] = DOORTILE22__STATIC;
    dynamictostatic[FANSPRITE] = FANSPRITE__STATIC;
    dynamictostatic[FANSPRITEBROKE] = FANSPRITEBROKE__STATIC;
    dynamictostatic[FANSHADOW] = FANSHADOW__STATIC;
    dynamictostatic[FANSHADOWBROKE] = FANSHADOWBROKE__STATIC;
    dynamictostatic[DOORTILE18] = DOORTILE18__STATIC;
    dynamictostatic[DOORTILE19] = DOORTILE19__STATIC;
    dynamictostatic[DOORTILE20] = DOORTILE20__STATIC;
    dynamictostatic[SATELLITE] = SATELLITE__STATIC;
    dynamictostatic[VIEWSCREEN2] = VIEWSCREEN2__STATIC;
    dynamictostatic[VIEWSCREENBROKE] = VIEWSCREENBROKE__STATIC;
    dynamictostatic[VIEWSCREEN] = VIEWSCREEN__STATIC;
    dynamictostatic[GLASS] = GLASS__STATIC;
    dynamictostatic[GLASS2] = GLASS2__STATIC;
    dynamictostatic[STAINGLASS1] = STAINGLASS1__STATIC;
    dynamictostatic[MASKWALL5] = MASKWALL5__STATIC;
    dynamictostatic[SATELITE] = SATELITE__STATIC;
    dynamictostatic[FUELPOD] = FUELPOD__STATIC;
    dynamictostatic[SLIMEPIPE] = SLIMEPIPE__STATIC;
    dynamictostatic[CRACK1] = CRACK1__STATIC;
    dynamictostatic[CRACK2] = CRACK2__STATIC;
    dynamictostatic[CRACK3] = CRACK3__STATIC;
    dynamictostatic[CRACK4] = CRACK4__STATIC;
    dynamictostatic[FOOTPRINTS] = FOOTPRINTS__STATIC;
    dynamictostatic[DOMELITE] = DOMELITE__STATIC;
    dynamictostatic[CAMERAPOLE] = CAMERAPOLE__STATIC;
    dynamictostatic[CHAIR1] = CHAIR1__STATIC;
    dynamictostatic[CHAIR2] = CHAIR2__STATIC;
    dynamictostatic[BROKENCHAIR] = BROKENCHAIR__STATIC;
    dynamictostatic[MIRROR] = MIRROR__STATIC;
    dynamictostatic[WATERFOUNTAIN] = WATERFOUNTAIN__STATIC;
    dynamictostatic[WATERFOUNTAINBROKE] = WATERFOUNTAINBROKE__STATIC;
    dynamictostatic[FEMMAG1] = FEMMAG1__STATIC;
    dynamictostatic[TOILET] = TOILET__STATIC;
    dynamictostatic[STALL] = STALL__STATIC;
    dynamictostatic[STALLBROKE] = STALLBROKE__STATIC;
    dynamictostatic[FEMMAG2] = FEMMAG2__STATIC;
    dynamictostatic[REACTOR2] = REACTOR2__STATIC;
    dynamictostatic[REACTOR2BURNT] = REACTOR2BURNT__STATIC;
    dynamictostatic[REACTOR2SPARK] = REACTOR2SPARK__STATIC;
    dynamictostatic[GRATE1] = GRATE1__STATIC;
    dynamictostatic[BGRATE1] = BGRATE1__STATIC;
    dynamictostatic[SOLARPANNEL] = SOLARPANNEL__STATIC;
    dynamictostatic[NAKED1] = NAKED1__STATIC;
    dynamictostatic[ANTENNA] = ANTENNA__STATIC;
    dynamictostatic[MASKWALL12] = MASKWALL12__STATIC;
    dynamictostatic[TOILETBROKE] = TOILETBROKE__STATIC;
    dynamictostatic[PIPE2] = PIPE2__STATIC;
    dynamictostatic[PIPE1B] = PIPE1B__STATIC;
    dynamictostatic[PIPE3] = PIPE3__STATIC;
    dynamictostatic[PIPE1] = PIPE1__STATIC;
    dynamictostatic[CAMERA1] = CAMERA1__STATIC;
    dynamictostatic[BRICK] = BRICK__STATIC;
    dynamictostatic[SPLINTERWOOD] = SPLINTERWOOD__STATIC;
    dynamictostatic[PIPE2B] = PIPE2B__STATIC;
    dynamictostatic[BOLT1] = BOLT1__STATIC;
    dynamictostatic[W_NUMBERS] = W_NUMBERS__STATIC;
    dynamictostatic[WATERDRIP] = WATERDRIP__STATIC;
    dynamictostatic[WATERBUBBLE] = WATERBUBBLE__STATIC;
    dynamictostatic[WATERBUBBLEMAKER] = WATERBUBBLEMAKER__STATIC;
    dynamictostatic[W_FORCEFIELD] = W_FORCEFIELD__STATIC;
    dynamictostatic[VACUUM] = VACUUM__STATIC;
    dynamictostatic[FOOTPRINTS2] = FOOTPRINTS2__STATIC;
    dynamictostatic[FOOTPRINTS3] = FOOTPRINTS3__STATIC;
    dynamictostatic[FOOTPRINTS4] = FOOTPRINTS4__STATIC;
    dynamictostatic[EGG] = EGG__STATIC;
    dynamictostatic[SCALE] = SCALE__STATIC;
    dynamictostatic[CHAIR3] = CHAIR3__STATIC;
    dynamictostatic[CAMERALIGHT] = CAMERALIGHT__STATIC;
    dynamictostatic[MOVIECAMERA] = MOVIECAMERA__STATIC;
    dynamictostatic[IVUNIT] = IVUNIT__STATIC;
    dynamictostatic[POT1] = POT1__STATIC;
    dynamictostatic[POT2] = POT2__STATIC;
    dynamictostatic[POT3] = POT3__STATIC;
    dynamictostatic[PIPE3B] = PIPE3B__STATIC;
    dynamictostatic[WALLLIGHT3] = WALLLIGHT3__STATIC;
    dynamictostatic[WALLLIGHTBUST3] = WALLLIGHTBUST3__STATIC;
    dynamictostatic[WALLLIGHT1] = WALLLIGHT1__STATIC;
    dynamictostatic[WALLLIGHTBUST1] = WALLLIGHTBUST1__STATIC;
    dynamictostatic[WALLLIGHT2] = WALLLIGHT2__STATIC;
    dynamictostatic[WALLLIGHTBUST2] = WALLLIGHTBUST2__STATIC;
    dynamictostatic[LIGHTSWITCH2] = LIGHTSWITCH2__STATIC;
    dynamictostatic[WAITTOBESEATED] = WAITTOBESEATED__STATIC;
    dynamictostatic[DOORTILE14] = DOORTILE14__STATIC;
    dynamictostatic[STATUE] = STATUE__STATIC;
    dynamictostatic[MIKE] = MIKE__STATIC;
    dynamictostatic[VASE] = VASE__STATIC;
    dynamictostatic[SUSHIPLATE1] = SUSHIPLATE1__STATIC;
    dynamictostatic[SUSHIPLATE2] = SUSHIPLATE2__STATIC;
    dynamictostatic[SUSHIPLATE3] = SUSHIPLATE3__STATIC;
    dynamictostatic[SUSHIPLATE4] = SUSHIPLATE4__STATIC;
    dynamictostatic[DOORTILE16] = DOORTILE16__STATIC;
    dynamictostatic[SUSHIPLATE5] = SUSHIPLATE5__STATIC;
    dynamictostatic[OJ] = OJ__STATIC;
    dynamictostatic[MASKWALL13] = MASKWALL13__STATIC;
    dynamictostatic[HURTRAIL] = HURTRAIL__STATIC;
    dynamictostatic[POWERSWITCH1] = POWERSWITCH1__STATIC;
    dynamictostatic[LOCKSWITCH1] = LOCKSWITCH1__STATIC;
    dynamictostatic[POWERSWITCH2] = POWERSWITCH2__STATIC;
    dynamictostatic[ATM] = ATM__STATIC;
    dynamictostatic[STATUEFLASH] = STATUEFLASH__STATIC;
    dynamictostatic[ATMBROKE] = ATMBROKE__STATIC;
    dynamictostatic[BIGHOLE2] = BIGHOLE2__STATIC;
    dynamictostatic[STRIPEBALL] = STRIPEBALL__STATIC;
    dynamictostatic[QUEBALL] = QUEBALL__STATIC;
    dynamictostatic[POCKET] = POCKET__STATIC;
    dynamictostatic[WOODENHORSE] = WOODENHORSE__STATIC;
    dynamictostatic[TREE1] = TREE1__STATIC;
    dynamictostatic[TREE2] = TREE2__STATIC;
    dynamictostatic[CACTUS] = CACTUS__STATIC;
    dynamictostatic[MASKWALL2] = MASKWALL2__STATIC;
    dynamictostatic[MASKWALL3] = MASKWALL3__STATIC;
    dynamictostatic[MASKWALL4] = MASKWALL4__STATIC;
    dynamictostatic[FIREEXT] = FIREEXT__STATIC;
    dynamictostatic[TOILETWATER] = TOILETWATER__STATIC;
    dynamictostatic[NEON1] = NEON1__STATIC;
    dynamictostatic[NEON2] = NEON2__STATIC;
    dynamictostatic[CACTUSBROKE] = CACTUSBROKE__STATIC;
    dynamictostatic[BOUNCEMINE] = BOUNCEMINE__STATIC;
    dynamictostatic[BROKEFIREHYDRENT] = BROKEFIREHYDRENT__STATIC;
    dynamictostatic[BOX] = BOX__STATIC;
    dynamictostatic[BULLETHOLE] = BULLETHOLE__STATIC;
    dynamictostatic[BOTTLE1] = BOTTLE1__STATIC;
    dynamictostatic[BOTTLE2] = BOTTLE2__STATIC;
    dynamictostatic[BOTTLE3] = BOTTLE3__STATIC;
    dynamictostatic[BOTTLE4] = BOTTLE4__STATIC;
    dynamictostatic[FEMPIC5] = FEMPIC5__STATIC;
    dynamictostatic[FEMPIC6] = FEMPIC6__STATIC;
    dynamictostatic[FEMPIC7] = FEMPIC7__STATIC;
    dynamictostatic[HYDROPLANT] = HYDROPLANT__STATIC;
    dynamictostatic[OCEANSPRITE1] = OCEANSPRITE1__STATIC;
    dynamictostatic[OCEANSPRITE2] = OCEANSPRITE2__STATIC;
    dynamictostatic[OCEANSPRITE3] = OCEANSPRITE3__STATIC;
    dynamictostatic[OCEANSPRITE4] = OCEANSPRITE4__STATIC;
    dynamictostatic[OCEANSPRITE5] = OCEANSPRITE5__STATIC;
    dynamictostatic[GENERICPOLE] = GENERICPOLE__STATIC;
    dynamictostatic[CONE] = CONE__STATIC;
    dynamictostatic[HANGLIGHT] = HANGLIGHT__STATIC;
    dynamictostatic[HYDRENT] = HYDRENT__STATIC;
    dynamictostatic[MASKWALL14] = MASKWALL14__STATIC;
    dynamictostatic[TIRE] = TIRE__STATIC;
    dynamictostatic[PIPE5] = PIPE5__STATIC;
    dynamictostatic[PIPE6] = PIPE6__STATIC;
    dynamictostatic[PIPE4] = PIPE4__STATIC;
    dynamictostatic[PIPE4B] = PIPE4B__STATIC;
    dynamictostatic[BROKEHYDROPLANT] = BROKEHYDROPLANT__STATIC;
    dynamictostatic[PIPE5B] = PIPE5B__STATIC;
    dynamictostatic[NEON3] = NEON3__STATIC;
    dynamictostatic[NEON4] = NEON4__STATIC;
    dynamictostatic[NEON5] = NEON5__STATIC;
    dynamictostatic[BOTTLE5] = BOTTLE5__STATIC;
    dynamictostatic[BOTTLE6] = BOTTLE6__STATIC;
    dynamictostatic[BOTTLE8] = BOTTLE8__STATIC;
    dynamictostatic[SPOTLITE] = SPOTLITE__STATIC;
    dynamictostatic[HANGOOZ] = HANGOOZ__STATIC;
    dynamictostatic[MASKWALL15] = MASKWALL15__STATIC;
    dynamictostatic[BOTTLE7] = BOTTLE7__STATIC;
    dynamictostatic[HORSEONSIDE] = HORSEONSIDE__STATIC;
    dynamictostatic[GLASSPIECES] = GLASSPIECES__STATIC;
    dynamictostatic[HORSELITE] = HORSELITE__STATIC;
    dynamictostatic[DONUTS] = DONUTS__STATIC;
    dynamictostatic[NEON6] = NEON6__STATIC;
    dynamictostatic[MASKWALL6] = MASKWALL6__STATIC;
    dynamictostatic[CLOCK] = CLOCK__STATIC;
    dynamictostatic[RUBBERCAN] = RUBBERCAN__STATIC;
    dynamictostatic[BROKENCLOCK] = BROKENCLOCK__STATIC;
    dynamictostatic[PLUG] = PLUG__STATIC;
    dynamictostatic[OOZFILTER] = OOZFILTER__STATIC;
    dynamictostatic[FLOORPLASMA] = FLOORPLASMA__STATIC;
    dynamictostatic[REACTOR] = REACTOR__STATIC;
    dynamictostatic[REACTORSPARK] = REACTORSPARK__STATIC;
    dynamictostatic[REACTORBURNT] = REACTORBURNT__STATIC;
    dynamictostatic[DOORTILE15] = DOORTILE15__STATIC;
    dynamictostatic[HANDSWITCH] = HANDSWITCH__STATIC;
    dynamictostatic[CIRCLEPANNEL] = CIRCLEPANNEL__STATIC;
    dynamictostatic[CIRCLEPANNELBROKE] = CIRCLEPANNELBROKE__STATIC;
    dynamictostatic[PULLSWITCH] = PULLSWITCH__STATIC;
    dynamictostatic[MASKWALL8] = MASKWALL8__STATIC;
    dynamictostatic[BIGHOLE] = BIGHOLE__STATIC;
    dynamictostatic[ALIENSWITCH] = ALIENSWITCH__STATIC;
    dynamictostatic[DOORTILE21] = DOORTILE21__STATIC;
    dynamictostatic[HANDPRINTSWITCH] = HANDPRINTSWITCH__STATIC;
    dynamictostatic[BOTTLE10] = BOTTLE10__STATIC;
    dynamictostatic[BOTTLE11] = BOTTLE11__STATIC;
    dynamictostatic[BOTTLE12] = BOTTLE12__STATIC;
    dynamictostatic[BOTTLE13] = BOTTLE13__STATIC;
    dynamictostatic[BOTTLE14] = BOTTLE14__STATIC;
    dynamictostatic[BOTTLE15] = BOTTLE15__STATIC;
    dynamictostatic[BOTTLE16] = BOTTLE16__STATIC;
    dynamictostatic[BOTTLE17] = BOTTLE17__STATIC;
    dynamictostatic[BOTTLE18] = BOTTLE18__STATIC;
    dynamictostatic[BOTTLE19] = BOTTLE19__STATIC;
    dynamictostatic[DOORTILE17] = DOORTILE17__STATIC;
    dynamictostatic[MASKWALL7] = MASKWALL7__STATIC;
    dynamictostatic[JAILBARBREAK] = JAILBARBREAK__STATIC;
    dynamictostatic[DOORTILE11] = DOORTILE11__STATIC;
    dynamictostatic[DOORTILE12] = DOORTILE12__STATIC;
    dynamictostatic[VENDMACHINE] = VENDMACHINE__STATIC;
    dynamictostatic[VENDMACHINEBROKE] = VENDMACHINEBROKE__STATIC;
    dynamictostatic[COLAMACHINE] = COLAMACHINE__STATIC;
    dynamictostatic[COLAMACHINEBROKE] = COLAMACHINEBROKE__STATIC;
    dynamictostatic[CRANEPOLE] = CRANEPOLE__STATIC;
    dynamictostatic[CRANE] = CRANE__STATIC;
    dynamictostatic[BARBROKE] = BARBROKE__STATIC;
    dynamictostatic[BLOODPOOL] = BLOODPOOL__STATIC;
    dynamictostatic[NUKEBARREL] = NUKEBARREL__STATIC;
    dynamictostatic[NUKEBARRELDENTED] = NUKEBARRELDENTED__STATIC;
    dynamictostatic[NUKEBARRELLEAKED] = NUKEBARRELLEAKED__STATIC;
    dynamictostatic[CANWITHSOMETHING] = CANWITHSOMETHING__STATIC;
    dynamictostatic[MONEY] = MONEY__STATIC;
    dynamictostatic[BANNER] = BANNER__STATIC;
    dynamictostatic[EXPLODINGBARREL] = EXPLODINGBARREL__STATIC;
    dynamictostatic[EXPLODINGBARREL2] = EXPLODINGBARREL2__STATIC;
    dynamictostatic[FIREBARREL] = FIREBARREL__STATIC;
    dynamictostatic[SEENINE] = SEENINE__STATIC;
    dynamictostatic[SEENINEDEAD] = SEENINEDEAD__STATIC;
    dynamictostatic[STEAM] = STEAM__STATIC;
    dynamictostatic[CEILINGSTEAM] = CEILINGSTEAM__STATIC;
    dynamictostatic[PIPE6B] = PIPE6B__STATIC;
    dynamictostatic[TRANSPORTERBEAM] = TRANSPORTERBEAM__STATIC;
    dynamictostatic[RAT] = RAT__STATIC;
    dynamictostatic[TRASH] = TRASH__STATIC;
    dynamictostatic[FEMPIC1] = FEMPIC1__STATIC;
    dynamictostatic[FEMPIC2] = FEMPIC2__STATIC;
    dynamictostatic[BLANKSCREEN] = BLANKSCREEN__STATIC;
    dynamictostatic[PODFEM1] = PODFEM1__STATIC;
    dynamictostatic[FEMPIC3] = FEMPIC3__STATIC;
    dynamictostatic[FEMPIC4] = FEMPIC4__STATIC;
    dynamictostatic[FEM1] = FEM1__STATIC;
    dynamictostatic[FEM2] = FEM2__STATIC;
    dynamictostatic[FEM3] = FEM3__STATIC;
    dynamictostatic[FEM5] = FEM5__STATIC;
    dynamictostatic[BLOODYPOLE] = BLOODYPOLE__STATIC;
    dynamictostatic[FEM4] = FEM4__STATIC;
    dynamictostatic[FEM6] = FEM6__STATIC;
    dynamictostatic[FEM6PAD] = FEM6PAD__STATIC;
    dynamictostatic[FEM8] = FEM8__STATIC;
    dynamictostatic[HELECOPT] = HELECOPT__STATIC;
    dynamictostatic[FETUSJIB] = FETUSJIB__STATIC;
    dynamictostatic[HOLODUKE] = HOLODUKE__STATIC;
    dynamictostatic[SPACEMARINE] = SPACEMARINE__STATIC;
    dynamictostatic[INDY] = INDY__STATIC;
    dynamictostatic[FETUS] = FETUS__STATIC;
    dynamictostatic[FETUSBROKE] = FETUSBROKE__STATIC;
    dynamictostatic[MONK] = MONK__STATIC;
    dynamictostatic[LUKE] = LUKE__STATIC;
    dynamictostatic[COOLEXPLOSION1] = COOLEXPLOSION1__STATIC;
    dynamictostatic[WATERSPLASH2] = WATERSPLASH2__STATIC;
    dynamictostatic[FIREVASE] = FIREVASE__STATIC;
    dynamictostatic[SCRATCH] = SCRATCH__STATIC;
    dynamictostatic[FEM7] = FEM7__STATIC;
    dynamictostatic[APLAYERTOP] = APLAYERTOP__STATIC;
    dynamictostatic[APLAYER] = APLAYER__STATIC;
    dynamictostatic[PLAYERONWATER] = PLAYERONWATER__STATIC;
    dynamictostatic[DUKELYINGDEAD] = DUKELYINGDEAD__STATIC;
    dynamictostatic[DUKETORSO] = DUKETORSO__STATIC;
    dynamictostatic[DUKEGUN] = DUKEGUN__STATIC;
    dynamictostatic[DUKELEG] = DUKELEG__STATIC;
    dynamictostatic[SHARK] = SHARK__STATIC;
    dynamictostatic[BLOOD] = BLOOD__STATIC;
    dynamictostatic[FIRELASER] = FIRELASER__STATIC;
    dynamictostatic[TRANSPORTERSTAR] = TRANSPORTERSTAR__STATIC;
    dynamictostatic[SPIT] = SPIT__STATIC;
    dynamictostatic[LOOGIE] = LOOGIE__STATIC;
    dynamictostatic[FIST] = FIST__STATIC;
    dynamictostatic[FREEZEBLAST] = FREEZEBLAST__STATIC;
    dynamictostatic[DEVISTATORBLAST] = DEVISTATORBLAST__STATIC;
    dynamictostatic[SHRINKSPARK] = SHRINKSPARK__STATIC;
    dynamictostatic[TONGUE] = TONGUE__STATIC;
    dynamictostatic[MORTER] = MORTER__STATIC;
    dynamictostatic[SHRINKEREXPLOSION] = SHRINKEREXPLOSION__STATIC;
    dynamictostatic[RADIUSEXPLOSION] = RADIUSEXPLOSION__STATIC;
    dynamictostatic[FORCERIPPLE] = FORCERIPPLE__STATIC;
    dynamictostatic[LIZTROOP] = LIZTROOP__STATIC;
    dynamictostatic[LIZTROOPRUNNING] = LIZTROOPRUNNING__STATIC;
    dynamictostatic[LIZTROOPSTAYPUT] = LIZTROOPSTAYPUT__STATIC;
    dynamictostatic[LIZTOP] = LIZTOP__STATIC;
    dynamictostatic[LIZTROOPSHOOT] = LIZTROOPSHOOT__STATIC;
    dynamictostatic[LIZTROOPJETPACK] = LIZTROOPJETPACK__STATIC;
    dynamictostatic[LIZTROOPDSPRITE] = LIZTROOPDSPRITE__STATIC;
    dynamictostatic[LIZTROOPONTOILET] = LIZTROOPONTOILET__STATIC;
    dynamictostatic[LIZTROOPJUSTSIT] = LIZTROOPJUSTSIT__STATIC;
    dynamictostatic[LIZTROOPDUCKING] = LIZTROOPDUCKING__STATIC;
    dynamictostatic[HEADJIB1] = HEADJIB1__STATIC;
    dynamictostatic[ARMJIB1] = ARMJIB1__STATIC;
    dynamictostatic[LEGJIB1] = LEGJIB1__STATIC;
    dynamictostatic[CANNONBALL] = CANNONBALL__STATIC;
    dynamictostatic[OCTABRAIN] = OCTABRAIN__STATIC;
    dynamictostatic[OCTABRAINSTAYPUT] = OCTABRAINSTAYPUT__STATIC;
    dynamictostatic[OCTATOP] = OCTATOP__STATIC;
    dynamictostatic[OCTADEADSPRITE] = OCTADEADSPRITE__STATIC;
    dynamictostatic[INNERJAW] = INNERJAW__STATIC;
    dynamictostatic[DRONE] = DRONE__STATIC;
    dynamictostatic[EXPLOSION2] = EXPLOSION2__STATIC;
    dynamictostatic[COMMANDER] = COMMANDER__STATIC;
    dynamictostatic[COMMANDERSTAYPUT] = COMMANDERSTAYPUT__STATIC;
    dynamictostatic[RECON] = RECON__STATIC;
    dynamictostatic[TANK] = TANK__STATIC;
    dynamictostatic[PIGCOP] = PIGCOP__STATIC;
    dynamictostatic[PIGCOPSTAYPUT] = PIGCOPSTAYPUT__STATIC;
    dynamictostatic[PIGCOPDIVE] = PIGCOPDIVE__STATIC;
    dynamictostatic[PIGCOPDEADSPRITE] = PIGCOPDEADSPRITE__STATIC;
    dynamictostatic[PIGTOP] = PIGTOP__STATIC;
    dynamictostatic[LIZMAN] = LIZMAN__STATIC;
    dynamictostatic[LIZMANSTAYPUT] = LIZMANSTAYPUT__STATIC;
    dynamictostatic[LIZMANSPITTING] = LIZMANSPITTING__STATIC;
    dynamictostatic[LIZMANFEEDING] = LIZMANFEEDING__STATIC;
    dynamictostatic[LIZMANJUMP] = LIZMANJUMP__STATIC;
    dynamictostatic[LIZMANDEADSPRITE] = LIZMANDEADSPRITE__STATIC;
    dynamictostatic[FECES] = FECES__STATIC;
    dynamictostatic[LIZMANHEAD1] = LIZMANHEAD1__STATIC;
    dynamictostatic[LIZMANARM1] = LIZMANARM1__STATIC;
    dynamictostatic[LIZMANLEG1] = LIZMANLEG1__STATIC;
    dynamictostatic[EXPLOSION2BOT] = EXPLOSION2BOT__STATIC;
    dynamictostatic[USERWEAPON] = USERWEAPON__STATIC;
    dynamictostatic[HEADERBAR] = HEADERBAR__STATIC;
    dynamictostatic[JIBS1] = JIBS1__STATIC;
    dynamictostatic[JIBS2] = JIBS2__STATIC;
    dynamictostatic[JIBS3] = JIBS3__STATIC;
    dynamictostatic[JIBS4] = JIBS4__STATIC;
    dynamictostatic[JIBS5] = JIBS5__STATIC;
    dynamictostatic[BURNING] = BURNING__STATIC;
    dynamictostatic[FIRE] = FIRE__STATIC;
    dynamictostatic[JIBS6] = JIBS6__STATIC;
    dynamictostatic[BLOODSPLAT1] = BLOODSPLAT1__STATIC;
    dynamictostatic[BLOODSPLAT3] = BLOODSPLAT3__STATIC;
    dynamictostatic[BLOODSPLAT2] = BLOODSPLAT2__STATIC;
    dynamictostatic[BLOODSPLAT4] = BLOODSPLAT4__STATIC;
    dynamictostatic[OOZ] = OOZ__STATIC;
    dynamictostatic[OOZ2] = OOZ2__STATIC;
    dynamictostatic[WALLBLOOD1] = WALLBLOOD1__STATIC;
    dynamictostatic[WALLBLOOD2] = WALLBLOOD2__STATIC;
    dynamictostatic[WALLBLOOD3] = WALLBLOOD3__STATIC;
    dynamictostatic[WALLBLOOD4] = WALLBLOOD4__STATIC;
    dynamictostatic[WALLBLOOD5] = WALLBLOOD5__STATIC;
    dynamictostatic[WALLBLOOD6] = WALLBLOOD6__STATIC;
    dynamictostatic[WALLBLOOD7] = WALLBLOOD7__STATIC;
    dynamictostatic[WALLBLOOD8] = WALLBLOOD8__STATIC;
    dynamictostatic[BURNING2] = BURNING2__STATIC;
    dynamictostatic[FIRE2] = FIRE2__STATIC;
    dynamictostatic[CRACKKNUCKLES] = CRACKKNUCKLES__STATIC;
    dynamictostatic[SMALLSMOKE] = SMALLSMOKE__STATIC;
    dynamictostatic[SMALLSMOKEMAKER] = SMALLSMOKEMAKER__STATIC;
    dynamictostatic[FLOORFLAME] = FLOORFLAME__STATIC;
    dynamictostatic[ROTATEGUN] = ROTATEGUN__STATIC;
    dynamictostatic[GREENSLIME] = GREENSLIME__STATIC;
    dynamictostatic[WATERDRIPSPLASH] = WATERDRIPSPLASH__STATIC;
    dynamictostatic[SCRAP6] = SCRAP6__STATIC;
    dynamictostatic[SCRAP1] = SCRAP1__STATIC;
    dynamictostatic[SCRAP2] = SCRAP2__STATIC;
    dynamictostatic[SCRAP3] = SCRAP3__STATIC;
    dynamictostatic[SCRAP4] = SCRAP4__STATIC;
    dynamictostatic[SCRAP5] = SCRAP5__STATIC;
    dynamictostatic[ORGANTIC] = ORGANTIC__STATIC;
    dynamictostatic[BETAVERSION] = BETAVERSION__STATIC;
    dynamictostatic[PLAYERISHERE] = PLAYERISHERE__STATIC;
    dynamictostatic[PLAYERWASHERE] = PLAYERWASHERE__STATIC;
    dynamictostatic[SELECTDIR] = SELECTDIR__STATIC;
    dynamictostatic[F1HELP] = F1HELP__STATIC;
    dynamictostatic[NOTCHON] = NOTCHON__STATIC;
    dynamictostatic[NOTCHOFF] = NOTCHOFF__STATIC;
    dynamictostatic[GROWSPARK] = GROWSPARK__STATIC;
    dynamictostatic[DUKEICON] = DUKEICON__STATIC;
    dynamictostatic[BADGUYICON] = BADGUYICON__STATIC;
    dynamictostatic[FOODICON] = FOODICON__STATIC;
    dynamictostatic[GETICON] = GETICON__STATIC;
    dynamictostatic[MENUSCREEN] = MENUSCREEN__STATIC;
    dynamictostatic[MENUBAR] = MENUBAR__STATIC;
    dynamictostatic[KILLSICON] = KILLSICON__STATIC;
    dynamictostatic[FIRSTAID_ICON] = FIRSTAID_ICON__STATIC;
    dynamictostatic[HEAT_ICON] = HEAT_ICON__STATIC;
    dynamictostatic[BOTTOMSTATUSBAR] = BOTTOMSTATUSBAR__STATIC;
    dynamictostatic[BOOT_ICON] = BOOT_ICON__STATIC;
    dynamictostatic[FRAGBAR] = FRAGBAR__STATIC;
    dynamictostatic[JETPACK_ICON] = JETPACK_ICON__STATIC;
    dynamictostatic[AIRTANK_ICON] = AIRTANK_ICON__STATIC;
    dynamictostatic[STEROIDS_ICON] = STEROIDS_ICON__STATIC;
    dynamictostatic[HOLODUKE_ICON] = HOLODUKE_ICON__STATIC;
    dynamictostatic[ACCESS_ICON] = ACCESS_ICON__STATIC;
    dynamictostatic[DIGITALNUM] = DIGITALNUM__STATIC;
    dynamictostatic[DUKECAR] = DUKECAR__STATIC;
    dynamictostatic[CAMCORNER] = CAMCORNER__STATIC;
    dynamictostatic[CAMLIGHT] = CAMLIGHT__STATIC;
    dynamictostatic[LOGO] = LOGO__STATIC;
    dynamictostatic[TITLE] = TITLE__STATIC;
    dynamictostatic[NUKEWARNINGICON] = NUKEWARNINGICON__STATIC;
    dynamictostatic[MOUSECURSOR] = MOUSECURSOR__STATIC;
    dynamictostatic[SLIDEBAR] = SLIDEBAR__STATIC;
    dynamictostatic[DREALMS] = DREALMS__STATIC;
    dynamictostatic[BETASCREEN] = BETASCREEN__STATIC;
    dynamictostatic[WINDOWBORDER1] = WINDOWBORDER1__STATIC;
    dynamictostatic[TEXTBOX] = TEXTBOX__STATIC;
    dynamictostatic[WINDOWBORDER2] = WINDOWBORDER2__STATIC;
    dynamictostatic[DUKENUKEM] = DUKENUKEM__STATIC;
    dynamictostatic[THREEDEE] = THREEDEE__STATIC;
    dynamictostatic[INGAMEDUKETHREEDEE] = INGAMEDUKETHREEDEE__STATIC;
    dynamictostatic[TENSCREEN] = TENSCREEN__STATIC;
    dynamictostatic[PLUTOPAKSPRITE] = PLUTOPAKSPRITE__STATIC;
    dynamictostatic[DEVISTATOR] = DEVISTATOR__STATIC;
    dynamictostatic[KNEE] = KNEE__STATIC;
    dynamictostatic[CROSSHAIR] = CROSSHAIR__STATIC;
    dynamictostatic[FIRSTGUN] = FIRSTGUN__STATIC;
    dynamictostatic[FIRSTGUNRELOAD] = FIRSTGUNRELOAD__STATIC;
    dynamictostatic[FALLINGCLIP] = FALLINGCLIP__STATIC;
    dynamictostatic[CLIPINHAND] = CLIPINHAND__STATIC;
    dynamictostatic[HAND] = HAND__STATIC;
    dynamictostatic[SHELL] = SHELL__STATIC;
    dynamictostatic[SHOTGUNSHELL] = SHOTGUNSHELL__STATIC;
    dynamictostatic[CHAINGUN] = CHAINGUN__STATIC;
    dynamictostatic[RPGGUN] = RPGGUN__STATIC;
    dynamictostatic[RPGMUZZLEFLASH] = RPGMUZZLEFLASH__STATIC;
    dynamictostatic[FREEZE] = FREEZE__STATIC;
    dynamictostatic[CATLITE] = CATLITE__STATIC;
    dynamictostatic[SHRINKER] = SHRINKER__STATIC;
    dynamictostatic[HANDHOLDINGLASER] = HANDHOLDINGLASER__STATIC;
    dynamictostatic[TRIPBOMB] = TRIPBOMB__STATIC;
    dynamictostatic[LASERLINE] = LASERLINE__STATIC;
    dynamictostatic[HANDHOLDINGACCESS] = HANDHOLDINGACCESS__STATIC;
    dynamictostatic[HANDREMOTE] = HANDREMOTE__STATIC;
    dynamictostatic[HANDTHROW] = HANDTHROW__STATIC;
    dynamictostatic[TIP] = TIP__STATIC;
    dynamictostatic[GLAIR] = GLAIR__STATIC;
    dynamictostatic[SCUBAMASK] = SCUBAMASK__STATIC;
    dynamictostatic[SPACEMASK] = SPACEMASK__STATIC;
    dynamictostatic[FORCESPHERE] = FORCESPHERE__STATIC;
    dynamictostatic[SHOTSPARK1] = SHOTSPARK1__STATIC;
    dynamictostatic[RPG] = RPG__STATIC;
    dynamictostatic[LASERSITE] = LASERSITE__STATIC;
    dynamictostatic[SHOTGUN] = SHOTGUN__STATIC;
    dynamictostatic[BOSS1] = BOSS1__STATIC;
    dynamictostatic[BOSS1STAYPUT] = BOSS1STAYPUT__STATIC;
    dynamictostatic[BOSS1SHOOT] = BOSS1SHOOT__STATIC;
    dynamictostatic[BOSS1LOB] = BOSS1LOB__STATIC;
    dynamictostatic[BOSSTOP] = BOSSTOP__STATIC;
    dynamictostatic[BOSS2] = BOSS2__STATIC;
    dynamictostatic[BOSS3] = BOSS3__STATIC;
    dynamictostatic[SPINNINGNUKEICON] = SPINNINGNUKEICON__STATIC;
    dynamictostatic[BIGFNTCURSOR] = BIGFNTCURSOR__STATIC;
    dynamictostatic[SMALLFNTCURSOR] = SMALLFNTCURSOR__STATIC;
    dynamictostatic[STARTALPHANUM] = STARTALPHANUM__STATIC;
    dynamictostatic[ENDALPHANUM] = ENDALPHANUM__STATIC;
    dynamictostatic[BIGALPHANUM] = BIGALPHANUM__STATIC;
    dynamictostatic[BIGPERIOD] = BIGPERIOD__STATIC;
    dynamictostatic[BIGCOMMA] = BIGCOMMA__STATIC;
    dynamictostatic[BIGX] = BIGX__STATIC;
    dynamictostatic[BIGQ] = BIGQ__STATIC;
    dynamictostatic[BIGSEMI] = BIGSEMI__STATIC;
    dynamictostatic[BIGCOLIN] = BIGCOLIN__STATIC;
    dynamictostatic[THREEBYFIVE] = THREEBYFIVE__STATIC;
    dynamictostatic[BIGAPPOS] = BIGAPPOS__STATIC;
    dynamictostatic[BLANK] = BLANK__STATIC;
    dynamictostatic[MINIFONT] = MINIFONT__STATIC;
    dynamictostatic[BUTTON1] = BUTTON1__STATIC;
    dynamictostatic[GLASS3] = GLASS3__STATIC;
    dynamictostatic[RESPAWNMARKERRED] = RESPAWNMARKERRED__STATIC;
    dynamictostatic[RESPAWNMARKERYELLOW] = RESPAWNMARKERYELLOW__STATIC;
    dynamictostatic[RESPAWNMARKERGREEN] = RESPAWNMARKERGREEN__STATIC;
    dynamictostatic[BONUSSCREEN] = BONUSSCREEN__STATIC;
    dynamictostatic[VIEWBORDER] = VIEWBORDER__STATIC;
    dynamictostatic[VICTORY1] = VICTORY1__STATIC;
    dynamictostatic[ORDERING] = ORDERING__STATIC;
    dynamictostatic[TEXTSTORY] = TEXTSTORY__STATIC;
    dynamictostatic[LOADSCREEN] = LOADSCREEN__STATIC;
    dynamictostatic[BORNTOBEWILDSCREEN] = BORNTOBEWILDSCREEN__STATIC;
    dynamictostatic[BLIMP] = BLIMP__STATIC;
    dynamictostatic[FEM9] = FEM9__STATIC;
    dynamictostatic[FOOTPRINT] = FOOTPRINT__STATIC;
    dynamictostatic[POOP] = POOP__STATIC;
    dynamictostatic[FRAMEEFFECT1] = FRAMEEFFECT1__STATIC;
    dynamictostatic[FRAMEEFFECT1_13] = FRAMEEFFECT1_13__STATIC;
    dynamictostatic[PANNEL3] = PANNEL3__STATIC;
    dynamictostatic[SCREENBREAK14] = SCREENBREAK14__STATIC;
    dynamictostatic[SCREENBREAK15] = SCREENBREAK15__STATIC;
    dynamictostatic[SCREENBREAK19] = SCREENBREAK19__STATIC;
    dynamictostatic[SCREENBREAK16] = SCREENBREAK16__STATIC;
    dynamictostatic[SCREENBREAK17] = SCREENBREAK17__STATIC;
    dynamictostatic[SCREENBREAK18] = SCREENBREAK18__STATIC;
    dynamictostatic[W_TECHWALL11] = W_TECHWALL11__STATIC;
    dynamictostatic[W_TECHWALL12] = W_TECHWALL12__STATIC;
    dynamictostatic[W_TECHWALL13] = W_TECHWALL13__STATIC;
    dynamictostatic[W_TECHWALL14] = W_TECHWALL14__STATIC;
    dynamictostatic[W_TECHWALL5] = W_TECHWALL5__STATIC;
    dynamictostatic[W_TECHWALL6] = W_TECHWALL6__STATIC;
    dynamictostatic[W_TECHWALL7] = W_TECHWALL7__STATIC;
    dynamictostatic[W_TECHWALL8] = W_TECHWALL8__STATIC;
    dynamictostatic[W_TECHWALL9] = W_TECHWALL9__STATIC;
    dynamictostatic[BPANNEL3] = BPANNEL3__STATIC;
    dynamictostatic[W_HITTECHWALL16] = W_HITTECHWALL16__STATIC;
    dynamictostatic[W_HITTECHWALL10] = W_HITTECHWALL10__STATIC;
    dynamictostatic[W_HITTECHWALL15] = W_HITTECHWALL15__STATIC;
    dynamictostatic[W_MILKSHELF] = W_MILKSHELF__STATIC;
    dynamictostatic[W_MILKSHELFBROKE] = W_MILKSHELFBROKE__STATIC;
    dynamictostatic[PURPLELAVA] = PURPLELAVA__STATIC;
    dynamictostatic[LAVABUBBLE] = LAVABUBBLE__STATIC;
    dynamictostatic[DUKECUTOUT] = DUKECUTOUT__STATIC;
    dynamictostatic[TARGET] = TARGET__STATIC;
    dynamictostatic[GUNPOWDERBARREL] = GUNPOWDERBARREL__STATIC;
    dynamictostatic[DUCK] = DUCK__STATIC;
    dynamictostatic[HATRACK] = HATRACK__STATIC;
    dynamictostatic[DESKLAMP] = DESKLAMP__STATIC;
    dynamictostatic[COFFEEMACHINE] = COFFEEMACHINE__STATIC;
    dynamictostatic[CUPS] = CUPS__STATIC;
    dynamictostatic[GAVALS] = GAVALS__STATIC;
    dynamictostatic[GAVALS2] = GAVALS2__STATIC;
    dynamictostatic[POLICELIGHTPOLE] = POLICELIGHTPOLE__STATIC;
    dynamictostatic[FLOORBASKET] = FLOORBASKET__STATIC;
    dynamictostatic[PUKE] = PUKE__STATIC;
    dynamictostatic[DOORTILE23] = DOORTILE23__STATIC;
    dynamictostatic[TOPSECRET] = TOPSECRET__STATIC;
    dynamictostatic[SPEAKER] = SPEAKER__STATIC;
    dynamictostatic[TEDDYBEAR] = TEDDYBEAR__STATIC;
    dynamictostatic[ROBOTDOG] = ROBOTDOG__STATIC;
    dynamictostatic[ROBOTPIRATE] = ROBOTPIRATE__STATIC;
    dynamictostatic[ROBOTMOUSE] = ROBOTMOUSE__STATIC;
    dynamictostatic[MAIL] = MAIL__STATIC;
    dynamictostatic[MAILBAG] = MAILBAG__STATIC;
    dynamictostatic[HOTMEAT] = HOTMEAT__STATIC;
    dynamictostatic[COFFEEMUG] = COFFEEMUG__STATIC;
    dynamictostatic[DONUTS2] = DONUTS2__STATIC;
    dynamictostatic[TRIPODCAMERA] = TRIPODCAMERA__STATIC;
    dynamictostatic[METER] = METER__STATIC;
    dynamictostatic[DESKPHONE] = DESKPHONE__STATIC;
    dynamictostatic[GUMBALLMACHINE] = GUMBALLMACHINE__STATIC;
    dynamictostatic[GUMBALLMACHINEBROKE] = GUMBALLMACHINEBROKE__STATIC;
    dynamictostatic[PAPER] = PAPER__STATIC;
    dynamictostatic[MACE] = MACE__STATIC;
    dynamictostatic[GENERICPOLE2] = GENERICPOLE2__STATIC;
    dynamictostatic[XXXSTACY] = XXXSTACY__STATIC;
    dynamictostatic[WETFLOOR] = WETFLOOR__STATIC;
    dynamictostatic[BROOM] = BROOM__STATIC;
    dynamictostatic[MOP] = MOP__STATIC;
    dynamictostatic[LETTER] = LETTER__STATIC;
    dynamictostatic[PIRATE1A] = PIRATE1A__STATIC;
    dynamictostatic[PIRATE4A] = PIRATE4A__STATIC;
    dynamictostatic[PIRATE2A] = PIRATE2A__STATIC;
    dynamictostatic[PIRATE5A] = PIRATE5A__STATIC;
    dynamictostatic[PIRATE3A] = PIRATE3A__STATIC;
    dynamictostatic[PIRATE6A] = PIRATE6A__STATIC;
    dynamictostatic[PIRATEHALF] = PIRATEHALF__STATIC;
    dynamictostatic[CHESTOFGOLD] = CHESTOFGOLD__STATIC;
    dynamictostatic[SIDEBOLT1] = SIDEBOLT1__STATIC;
    dynamictostatic[FOODOBJECT1] = FOODOBJECT1__STATIC;
    dynamictostatic[FOODOBJECT2] = FOODOBJECT2__STATIC;
    dynamictostatic[FOODOBJECT3] = FOODOBJECT3__STATIC;
    dynamictostatic[FOODOBJECT4] = FOODOBJECT4__STATIC;
    dynamictostatic[FOODOBJECT5] = FOODOBJECT5__STATIC;
    dynamictostatic[FOODOBJECT6] = FOODOBJECT6__STATIC;
    dynamictostatic[FOODOBJECT7] = FOODOBJECT7__STATIC;
    dynamictostatic[FOODOBJECT8] = FOODOBJECT8__STATIC;
    dynamictostatic[FOODOBJECT9] = FOODOBJECT9__STATIC;
    dynamictostatic[FOODOBJECT10] = FOODOBJECT10__STATIC;
    dynamictostatic[FOODOBJECT11] = FOODOBJECT11__STATIC;
    dynamictostatic[FOODOBJECT12] = FOODOBJECT12__STATIC;
    dynamictostatic[FOODOBJECT13] = FOODOBJECT13__STATIC;
    dynamictostatic[FOODOBJECT14] = FOODOBJECT14__STATIC;
    dynamictostatic[FOODOBJECT15] = FOODOBJECT15__STATIC;
    dynamictostatic[FOODOBJECT16] = FOODOBJECT16__STATIC;
    dynamictostatic[FOODOBJECT17] = FOODOBJECT17__STATIC;
    dynamictostatic[FOODOBJECT18] = FOODOBJECT18__STATIC;
    dynamictostatic[FOODOBJECT19] = FOODOBJECT19__STATIC;
    dynamictostatic[FOODOBJECT20] = FOODOBJECT20__STATIC;
    dynamictostatic[HEADLAMP] = HEADLAMP__STATIC;
    dynamictostatic[TAMPON] = TAMPON__STATIC;
    dynamictostatic[SKINNEDCHICKEN] = SKINNEDCHICKEN__STATIC;
    dynamictostatic[FEATHEREDCHICKEN] = FEATHEREDCHICKEN__STATIC;
    dynamictostatic[ROBOTDOG2] = ROBOTDOG2__STATIC;
    dynamictostatic[JOLLYMEAL] = JOLLYMEAL__STATIC;
    dynamictostatic[DUKEBURGER] = DUKEBURGER__STATIC;
    dynamictostatic[SHOPPINGCART] = SHOPPINGCART__STATIC;
    dynamictostatic[CANWITHSOMETHING2] = CANWITHSOMETHING2__STATIC;
    dynamictostatic[CANWITHSOMETHING3] = CANWITHSOMETHING3__STATIC;
    dynamictostatic[CANWITHSOMETHING4] = CANWITHSOMETHING4__STATIC;
    dynamictostatic[SNAKEP] = SNAKEP__STATIC;
    dynamictostatic[DOLPHIN1] = DOLPHIN1__STATIC;
    dynamictostatic[DOLPHIN2] = DOLPHIN2__STATIC;
    dynamictostatic[NEWBEAST] = NEWBEAST__STATIC;
    dynamictostatic[NEWBEASTSTAYPUT] = NEWBEASTSTAYPUT__STATIC;
    dynamictostatic[NEWBEASTJUMP] = NEWBEASTJUMP__STATIC;
    dynamictostatic[NEWBEASTHANG] = NEWBEASTHANG__STATIC;
    dynamictostatic[NEWBEASTHANGDEAD] = NEWBEASTHANGDEAD__STATIC;
    dynamictostatic[BOSS4] = BOSS4__STATIC;
    dynamictostatic[BOSS4STAYPUT] = BOSS4STAYPUT__STATIC;
    dynamictostatic[FEM10] = FEM10__STATIC;
    dynamictostatic[TOUGHGAL] = TOUGHGAL__STATIC;
    dynamictostatic[MAN] = MAN__STATIC;
    dynamictostatic[MAN2] = MAN2__STATIC;
    dynamictostatic[WOMAN] = WOMAN__STATIC;
    dynamictostatic[PLEASEWAIT] = PLEASEWAIT__STATIC;
    dynamictostatic[NATURALLIGHTNING] = NATURALLIGHTNING__STATIC;
    dynamictostatic[WEATHERWARN] = WEATHERWARN__STATIC;
    dynamictostatic[DUKETAG] = DUKETAG__STATIC;
    dynamictostatic[SIGN1] = SIGN1__STATIC;
    dynamictostatic[SIGN2] = SIGN2__STATIC;
    dynamictostatic[JURYGUY] = JURYGUY__STATIC;
    dynamictostatic[RESERVEDSLOT1] = RESERVEDSLOT1__STATIC;
    dynamictostatic[RESERVEDSLOT2] = RESERVEDSLOT2__STATIC;
    dynamictostatic[RESERVEDSLOT3] = RESERVEDSLOT3__STATIC;
    dynamictostatic[RESERVEDSLOT4] = RESERVEDSLOT4__STATIC;
    dynamictostatic[RESERVEDSLOT5] = RESERVEDSLOT5__STATIC;
    dynamictostatic[RESERVEDSLOT6] = RESERVEDSLOT6__STATIC;
    dynamictostatic[RESERVEDSLOT7] = RESERVEDSLOT7__STATIC;
    dynamictostatic[RESERVEDSLOT8] = RESERVEDSLOT8__STATIC;
    dynamictostatic[RESERVEDSLOT9] = RESERVEDSLOT9__STATIC;
    dynamictostatic[RESERVEDSLOT10] = RESERVEDSLOT10__STATIC;
    dynamictostatic[RESERVEDSLOT11] = RESERVEDSLOT11__STATIC;
    dynamictostatic[RESERVEDSLOT12] = RESERVEDSLOT12__STATIC;

    weaponsandammosprites[0] = RPGSPRITE;
    weaponsandammosprites[1] = CHAINGUNSPRITE;
    weaponsandammosprites[2] = DEVISTATORAMMO;
    weaponsandammosprites[3] = RPGAMMO;
    weaponsandammosprites[4] = RPGAMMO;
    weaponsandammosprites[5] = JETPACK;
    weaponsandammosprites[6] = SHIELD;
    weaponsandammosprites[7] = FIRSTAID;
    weaponsandammosprites[8] = STEROIDS;
    weaponsandammosprites[9] = RPGAMMO;
    weaponsandammosprites[10] = RPGAMMO;
    weaponsandammosprites[11] = RPGSPRITE;
    weaponsandammosprites[12] = RPGAMMO;
    weaponsandammosprites[13] = FREEZESPRITE;
    weaponsandammosprites[14] = FREEZEAMMO;

    weapon_sprites[0] = KNEE;
    weapon_sprites[1] = FIRSTGUNSPRITE;
    weapon_sprites[2] = SHOTGUNSPRITE;
    weapon_sprites[3] = CHAINGUNSPRITE;
    weapon_sprites[4] = RPGSPRITE;
    weapon_sprites[5] = HEAVYHBOMB;
    weapon_sprites[6] = SHRINKERSPRITE;
    weapon_sprites[7] = DEVISTATORSPRITE;
    weapon_sprites[8] = TRIPBOMBSPRITE;
    weapon_sprites[9] = FREEZESPRITE;
    weapon_sprites[10] = HEAVYHBOMB;
    weapon_sprites[11] = SHRINKERSPRITE;
}

/*
void readnames() {
    char buffer[1024], *p, *name, *number, *endptr;
    int num, syms=0, line=0, a;
    BFILE *fp;

    fp = fopenfrompath("NAMES.H","r");
    if (!fp) {
        if ((fp = fopenfrompath("names.h","r")) == NULL) {
            initprintf("Failed to open NAMES.H\n");
            return;
        }
    }

    //clearbufbyte(names, sizeof(names), 0);
    //memset(names,0,sizeof(names));

    initprintf("Loading NAMES.H\n");

    while (Bfgets(buffer, 1024, fp)) {
        a = Bstrlen(buffer);
        if (a >= 1) {
            if (a > 1)
                if (buffer[a-2] == '\r') buffer[a-2] = 0;
            if (buffer[a-1] == '\n') buffer[a-1] = 0;
        }

        p = buffer;
        line++;
        while (*p == 32) p++;
        if (*p == 0) continue;   // blank line

        if (*p == '#') {
            p++;
            while (*p == 32) p++;
            if (*p == 0) continue;   // null directive

            else if (!Bstrncmp(p, "define ", 7)) {
                // #define_...
                p += 7;
                while (*p == 32) p++;
                if (*p == 0) {
                    initprintf("Error: Malformed #define at line %d\n", line-1);
                    continue;
                }

                name = p;
                while (*p != 32 && *p != 0) p++;
                if (*p == 32) {
                    *(p++) = 0;
                    while (*p == 32) p++;
                    if (*p == 0) {   // #define_NAME with no number
                        initprintf("Error: No number given for name \"%s\" (line %d)\n", name, line-1);
                        continue;
                    }

                    number = p;
                    while (*p != 0) p++;
                    if (*p != 0) *p = 0;

                    // add to list
                    num = Bstrtol(number, &endptr, 10);
                    if (*endptr != 0) {
                        p = endptr;
                        goto badline;
                    }
                    //initprintf("Grokked \"%s\" -> \"%d\"\n", name, num);
                    if (num < 0 || num >= MAXTILES) {
                        initprintf("Error: Constant %d for name \"%s\" out of range (line %d)\n", num, name, line-1);
                        continue;
                    }
                    processnames(name,num);
                    syms++;

                    continue;

                } else {       // #define_NAME with no number
                    initprintf("Error: No number given for name \"%s\" (line %d)\n", name, line-1);
                    continue;
                }
            } else goto badline;
        } else if (*p == '/') {
            if (*(p+1) == '/') continue;       // comment
        }
badline:
        initprintf("Error: Invalid statement found at character %d on line %d\n", (p-buffer), line-1);
    }
    initprintf("Read %d lines, loaded %d names.\n", line, syms);
    Bfclose(fp);
}
*/
