/*
 * Duke Nukem 3D Setup Utility
 * by Jonathon Fowler
 *
 * This all very evil.
 *
 * http://jonof.edgenetwk.com/buildport/duke3d/
 */
//-------------------------------------------------------------------------
/*
Duke Nukem Copyright (C) 1996, 2003 3D Realms Entertainment

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Duke Nukem is a trademark of 3D Realms Entertainment.
*/
//-------------------------------------------------------------------------

#include "dialogs.h"
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <mmsystem.h>
#include <commctrl.h>

#include <string.h>
#include <math.h>
#include <stdio.h>

#include "types.h"
#include "file_lib.h"
#include "scriplib.h"

#define __SETUP__
#include "_functio.h"

#define numgamefunctions (sizeof(gamefunctions)/sizeof(char*))
#define numkeydefaults   ((sizeof(keydefaults)/sizeof(char*))/3)
#define consolefunc      (numgamefunctions-1)

#define VERSTRING "Setup v1.01 by JonoF"
#define FILENAME "duke3d.cfg"

HINSTANCE hInst;


const int voicelist[] = { 1, 2, 4, 8, 12, 16, 24, 32 };
#define voicelistcount (sizeof(voicelist)/sizeof(int))
const int frequlist[] = { 8000, 11025, 16000, 22050, 32000, 44100, 48000 };
#define frequlistcount (sizeof(frequlist)/sizeof(int))
const int resolutionlist[][2] = {
	{320,200}, {320,240}, {400,300}, {512,384}, {640,400}, {640,480},
	{800,600}, {1024,768}, {1152,864}, {1280,960}, {1280,1024} };
#define resolutionlistcount (sizeof(resolutionlist)/(sizeof(int)*2))
const int colourdepthlist[] = {
	8, 16, 32
};
#define colourdepthlistcount (sizeof(colourdepthlist)/sizeof(int))

char *keyslist[] = {
	"Escape", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", "=", "BakSpc",
	"Tab", "Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "[", "]", "Enter",
	"LCtrl", "A", "S", "D", "F", "G", "H", "J", "K", "L", ";", "'", "`",
	"LShift", "\\", "Z", "X", "C", "V", "B", "N", "M", ",", ".", "/", "RShift",
	"Kpad*", "LAlt", "Space", "CapLck", "F1", "F2", "F3", "F4", "F5", "F6", "F7",
	"F8", "F9", "F10", "NumLck", "ScrLck", "Kpad7", "Kpad8", "Kpad9", "Kpad-",
	"Kpad4", "Kpad5", "Kpad6", "Kpad+", "Kpad1", "Kpad2", "Kpad3", "Kpad0", "Kpad.",
	"F11", "F12", "KpdEnt", "RCtrl", "Kpad/", "RAlt", "PrtScn", "Pause", "Home",
	"Up", "PgUp", "Left", "Right", "End", "Down", "PgDn", "Insert", "Delete"
};
#define keyslistcount (sizeof(keyslist)/sizeof(char*))

#define nummousebuttons 6
const char *mousebuttons[] = { "Left", "Right", "Middle", "Thumb", "WheelDn", "WheelUp" };

#define numanalogueaxes 3
const char *analogueaxes[] = { "analog_turning", "analog_strafing", "analog_moving" };

#define numrenderers 3
const char *renderers[] = { "Classic", "Software Polymost", "OpenGL Polymost" };
const char rendererids[] = { 0,2,3 };

#define numinputdevices 3
const char *inputdevices[] = { "Keyboard only", "Keyboard and Mouse", "Keyboard and Joystick" };

int keytabstops[2] = { 4*24, 4*32 };
int mousetabstops[1] = { 4*10 };


char *keyconfiguration[numgamefunctions][2];
char *mouseconfiguration[nummousebuttons][2];
int mousexscale=65536, mouseyscale=65536, mouseaimmode=0;
int mouseanalogaxes[2];		// turning, moving
char *mousedigitalaxes[4];
int musicdevice=0;
int sounddevice=0;
int soundvoices=8;
int soundbits=8;
int soundfreq=22050;
int soundchans=2;
int inputdevs=1;
int videofs=1;
int videowidth=640;
int videoheight=480;
int videobpp=8;

char changes=0,rungame=0;

struct {
	int function;
	int secondary;
} keyinf;
struct {
	int device;   // 0=mouse	(bit 31 == axis)
	int button;
	int clicked;
} buttoninf;


int32 confighandle=-1;

int TranslateFunc(char *f)
{
	int i;
	for (i=0;i<numgamefunctions;i++)
		if (!strcasecmp(gamefunctions[i],f)) return i;
	return -1;
}

char * TranslateKey(char *k)
{
	int i;
	for (i=0;i<keyslistcount;i++)
		if (!strcasecmp(keyslist[i],k)) return keyslist[i];
	return "";
}

int TranslateAnalogAxis(char *a)
{
	int i;
	for (i=0;i<numanalogueaxes;i++)
		if (!strcasecmp(analogueaxes[i],a)) return i;
	return -1;
}

void LoadSettings(void)
{
	int numentries,i,func;
	char key1[60],key2[60];
	
	if (!SafeFileExists(FILENAME)) return;
	confighandle = SCRIPT_Load(FILENAME);
	if (confighandle < 0) return;

	videofs = 1; SCRIPT_GetNumber(confighandle,"Screen Setup","ScreenMode",&videofs);
	if (videofs > 1) videofs = 1;
	else if (videofs < 0) videofs = 0;

	videowidth = 640; SCRIPT_GetNumber(confighandle,"Screen Setup","ScreenWidth",&videowidth);

	videoheight = 480; SCRIPT_GetNumber(confighandle,"Screen Setup","ScreenHeight",&videoheight);

	videobpp = 8; SCRIPT_GetNumber(confighandle,"Screen Setup","ScreenBPP",&videobpp);

	sounddevice = 0; SCRIPT_GetNumber(confighandle,"Sound Setup","FXDevice",&sounddevice);
	if (sounddevice < 0) sounddevice = -1;

	soundvoices = 8; SCRIPT_GetNumber(confighandle,"Sound Setup","NumVoices",&soundvoices);

	soundbits = 8; SCRIPT_GetNumber(confighandle,"Sound Setup","NumBits",&soundbits);
	if (soundbits != 8 && soundbits != 16) soundbits = 8;
	
	soundchans = 2; SCRIPT_GetNumber(confighandle,"Sound Setup","NumChannels",&soundchans);
	if (soundchans > 2) soundchans = 2; else if (soundchans < 1) soundchans = 1;
	
	soundfreq = 22050; SCRIPT_GetNumber(confighandle,"Sound Setup","MixRate",&soundfreq);

	musicdevice = 0; SCRIPT_GetNumber(confighandle,"Sound Setup","MusicDevice",&musicdevice);
	if (musicdevice < 0) musicdevice = -1;

	numentries = SCRIPT_NumberEntries(confighandle,"KeyDefinitions");
	for (i=0;i<numentries;i++) {
		func = TranslateFunc(SCRIPT_Entry(confighandle,"KeyDefinitions",i));
		if (func<0) continue;

		key1[0] = key2[0] = 0;
		if (func == consolefunc) {
			SCRIPT_GetString(confighandle,"KeyDefinitions",SCRIPT_Entry(confighandle,"KeyDefinitions",i),key1);
			keyconfiguration[func][0] = TranslateKey(key1);
		} else {
			SCRIPT_GetDoubleString(confighandle,"KeyDefinitions",SCRIPT_Entry(confighandle,"KeyDefinitions",i),key1,key2);
			keyconfiguration[func][0] = TranslateKey(key1);
			keyconfiguration[func][1] = TranslateKey(key2);
		}
	}

	inputdevs = 1; SCRIPT_GetNumber(confighandle,"Controls","ControllerType",&inputdevs);
	if (inputdevs < 0) inputdevs = 0;

	for (i=0;i<nummousebuttons;i++) {
		sprintf(key1,"MouseButton%d",i);
		key2[0] = 0xff;
		SCRIPT_GetString(confighandle,"Controls",key1,key2);
		if (key2[0] != 0xff) {
			func = TranslateFunc(key2);
			if (func < 0) mouseconfiguration[i][0] = "";
			else mouseconfiguration[i][0] = gamefunctions[func];
		}
		
		if (i>=(nummousebuttons-2)) continue;

		sprintf(key1,"MouseButtonClicked%d",i);
		key2[0] = 0xff;
		SCRIPT_GetString(confighandle,"Controls",key1,key2);
		if (key2[0] != 0xff) {
			func = TranslateFunc(key2);
			if (func < 0) mouseconfiguration[i][1] = "";
			else mouseconfiguration[i][1] = gamefunctions[func];
		}
	}

	key1[0] = 0xff;
	SCRIPT_GetString(confighandle,"Controls","MouseAnalogAxes0",key1);
	if (key1[0] != 0xff)
		mouseanalogaxes[0] = TranslateAnalogAxis(key1);
	key1[0] = 0xff;
	SCRIPT_GetString(confighandle,"Controls","MouseAnalogAxes1",key1);
	if (key1[0] != 0xff)
		mouseanalogaxes[1] = TranslateAnalogAxis(key1);
	
	mousexscale = 65536; SCRIPT_GetNumber(confighandle,"Controls","MouseAnalogScale0",&mousexscale);
	if (mousexscale < -262144) mousexscale = -262144;
	else if (mousexscale > 262144) mousexscale = 262144;
	mouseyscale = 65536; SCRIPT_GetNumber(confighandle,"Controls","MouseAnalogScale1",&mouseyscale);
	if (mouseyscale < -262144) mouseyscale = -262144;
	else if (mouseyscale > 262144) mouseyscale = 262144;
	
	for (i=0;i<4;i++) {
		sprintf(key1,"MouseDigitalAxes%d_%d", i/2, i%2);
		key2[0] = 0xff;
		SCRIPT_GetString(confighandle,"Controls",key1,key2);
		if (key2[0] != 0xff) {
			func = TranslateFunc(key2);
			if (func<0) mousedigitalaxes[i] = "";
			else mousedigitalaxes[i] = gamefunctions[func];
		}
	}

	mouseaimmode = 0; SCRIPT_GetNumber(confighandle,"Controls","MouseAiming",&mouseaimmode);
	if (mouseaimmode <= 0) mouseaimmode = 0; else mouseaimmode = 1;
}


void SaveSettings(void)
{
	int i;
	char txt[60];

	if (confighandle < 0) {
		confighandle = SCRIPT_Init(FILENAME);
		if (confighandle < 0) return;

		SCRIPT_PutSection(confighandle,"Screen Setup");
		SCRIPT_PutNumber(confighandle,"Screen Setup","Shadows",1,0,0);
		SCRIPT_PutNumber(confighandle,"Screen Setup","Detail",1,0,0);
		SCRIPT_PutNumber(confighandle,"Screen Setup","Tilt",1,0,0);
		SCRIPT_PutNumber(confighandle,"Screen Setup","Messages",1,0,0);
		SCRIPT_PutSection(confighandle,"Sound Setup");
		SCRIPT_PutNumber(confighandle,"Sound Setup","FXVolume",200,0,0);
		SCRIPT_PutNumber(confighandle,"Sound Setup","MusicVolume",200,0,0);
		SCRIPT_PutNumber(confighandle,"Sound Setup","SoundToggle",1,0,0);
		SCRIPT_PutNumber(confighandle,"Sound Setup","VoiceToggle",1,0,0);
		SCRIPT_PutNumber(confighandle,"Sound Setup","AmbienceToggle",1,0,0);
		SCRIPT_PutNumber(confighandle,"Sound Setup","MusicToggle",1,0,0);
		SCRIPT_PutSection(confighandle,"Controls");
		SCRIPT_PutNumber(confighandle,"Controls","MouseSensitivity",45056,0,0);
	}
	
	SCRIPT_PutSection(confighandle,"Screen Setup");
	SCRIPT_PutNumber(confighandle,"Screen Setup","ScreenMode",videofs,0,0);
	SCRIPT_PutNumber(confighandle,"Screen Setup","ScreenWidth",videowidth,0,0);
	SCRIPT_PutNumber(confighandle,"Screen Setup","ScreenHeight",videoheight,0,0);
	SCRIPT_PutNumber(confighandle,"Screen Setup","ScreenBPP",videobpp,0,0);

	SCRIPT_PutSection(confighandle,"Sound Setup");
	SCRIPT_PutNumber(confighandle,"Sound Setup","FXDevice",sounddevice,0,0);
	SCRIPT_PutNumber(confighandle,"Sound Setup","NumVoices",soundvoices,0,0);
	SCRIPT_PutNumber(confighandle,"Sound Setup","NumBits",soundbits,0,0);
	SCRIPT_PutNumber(confighandle,"Sound Setup","NumChannels",soundchans,0,0);
	SCRIPT_PutNumber(confighandle,"Sound Setup","MixRate",soundfreq,0,0);
	SCRIPT_PutNumber(confighandle,"Sound Setup","MusicDevice",musicdevice,0,0);

	SCRIPT_PutSection(confighandle,"Controls");
	SCRIPT_PutNumber(confighandle,"Controls","ControllerType",inputdevs,0,0);
	SCRIPT_PutNumber(confighandle,"Controls","MouseAiming",mouseaimmode,0,0);
	for (i=0;i<nummousebuttons;i++) {
		sprintf(txt,"MouseButton%d",i);
		SCRIPT_PutString(confighandle,"Controls",txt,mouseconfiguration[i][0]);
		if (i>=(nummousebuttons-2)) continue;
		sprintf(txt,"MouseButtonClicked%d",i);
		SCRIPT_PutString(confighandle,"Controls",txt,mouseconfiguration[i][1]);
	}
	if (mouseanalogaxes[0]<0)
		SCRIPT_PutString(confighandle,"Controls","MouseAnalogAxes0","");
	else
		SCRIPT_PutString(confighandle,"Controls","MouseAnalogAxes0",analogueaxes[mouseanalogaxes[0]]);
	if (mouseanalogaxes[1]<0)
		SCRIPT_PutString(confighandle,"Controls","MouseAnalogAxes1","");
	else
		SCRIPT_PutString(confighandle,"Controls","MouseAnalogAxes1",analogueaxes[mouseanalogaxes[1]]);
	SCRIPT_PutNumber(confighandle,"Controls","MouseAnalogScale0",mousexscale,0,0);
	SCRIPT_PutNumber(confighandle,"Controls","MouseAnalogScale1",mouseyscale,0,0);
	for (i=0;i<4;i++) {
		sprintf(txt,"MouseDigitalAxes%d_%d", i/2, i%2);
		SCRIPT_PutString(confighandle,"Controls",txt,mousedigitalaxes[i]);
	}

	SCRIPT_PutSection(confighandle,"KeyDefinitions");
	for (i=0;i<numgamefunctions;i++) {
		if (i == consolefunc) {
			SCRIPT_PutString(confighandle,"KeyDefinitions",gamefunctions[i],keyconfiguration[i][0]);
		} else {
			SCRIPT_PutDoubleString(confighandle,"KeyDefinitions",
				gamefunctions[i],keyconfiguration[i][0],keyconfiguration[i][1]);
		}
	}

	SCRIPT_Save(confighandle, FILENAME);
}


void PopulateSoundDialog(HWND hwnd)
{
	UINT nummididevs;
	MIDIOUTCAPS mididev;
	
	UINT i,j,k,l,m,n,o,p;
	char txt[256];
	
	// populate the midi device list
	nummididevs = midiOutGetNumDevs();
	ComboBox_ResetContent(GetDlgItem(hwnd,ID_MUSICDEVICE));
	for (i=0;i<nummididevs;i++) {
		midiOutGetDevCaps(i, &mididev, sizeof(MIDIOUTCAPS));
		ComboBox_AddString(GetDlgItem(hwnd,ID_MUSICDEVICE), mididev.szPname);
	}

	if (musicdevice < 0) {
		CheckDlgButton(hwnd, ID_MUSICENABLED, FALSE);
		EnableWindow(GetDlgItem(hwnd,ID_MUSICDEVICE), FALSE);
		ComboBox_SetCurSel(GetDlgItem(hwnd,ID_MUSICDEVICE),0);
	} else {
		if (musicdevice>=nummididevs) musicdevice=nummididevs-1;
		CheckDlgButton(hwnd, ID_MUSICENABLED, TRUE);
		EnableWindow(GetDlgItem(hwnd,ID_MUSICDEVICE), TRUE);
		ComboBox_SetCurSel(GetDlgItem(hwnd,ID_MUSICDEVICE),musicdevice);
	}
	
	if (sounddevice < 0) {
		CheckDlgButton(hwnd, ID_SOUNDENABLED, FALSE);
	} else {
		CheckDlgButton(hwnd, ID_SOUNDENABLED, TRUE);
	}

	// populate the sound voices list
	j=0;
	ComboBox_ResetContent(GetDlgItem(hwnd,ID_SOUNDVOICES));
	for (i=0;i<voicelistcount;i++) {
		sprintf(txt, "%d", voicelist[i]);
		ComboBox_AddString(GetDlgItem(hwnd,ID_SOUNDVOICES), txt);
		if (soundvoices >= voicelist[i]) j=i;
	}
	ComboBox_SetCurSel(GetDlgItem(hwnd,ID_SOUNDVOICES),j);

	if (soundbits == 8) {
		CheckDlgButton(hwnd, ID_SOUND8BIT, TRUE);
		CheckDlgButton(hwnd, ID_SOUND16BIT, FALSE);
	} else {
		CheckDlgButton(hwnd, ID_SOUND16BIT, TRUE);
		CheckDlgButton(hwnd, ID_SOUND8BIT, FALSE);
	}

	// populate the sound frequency list
	j=0;
	ComboBox_ResetContent(GetDlgItem(hwnd,ID_SOUNDFREQ));
	for (i=0;i<frequlistcount;i++) {
		sprintf(txt, "%d Hz", frequlist[i]);
		ComboBox_AddString(GetDlgItem(hwnd,ID_SOUNDFREQ), txt);
		if (soundfreq >= frequlist[i]) j=i;
	}
	ComboBox_SetCurSel(GetDlgItem(hwnd,ID_SOUNDFREQ),j);

	// populate the resolutions list
	j=p=0;
	ComboBox_ResetContent(GetDlgItem(hwnd,ID_VIDEORES));
	for (o=0;o<colourdepthlistcount;o++) {
		k = videowidth - resolutionlist[j][0]; if (k<0) k=-k;
		l = videoheight - resolutionlist[j][1]; if (l<0) l=-l;
		for (i=0;i<resolutionlistcount;i++) {
			sprintf(txt, "%dx%d %dbpp", resolutionlist[i][0], resolutionlist[i][1], colourdepthlist[o]);
			ComboBox_AddString(GetDlgItem(hwnd,ID_VIDEORES), txt);
			m = videowidth - resolutionlist[i][0]; if (m<0) m=-m;
			n = videoheight - resolutionlist[i][1]; if (n<0) n=-n;
			if ((m<=k) && (n<=l) && (colourdepthlist[o]<=videobpp)) {
				p=o;
				j=i;
				k=m;
				l=n;
			}
		}
	}
	ComboBox_SetCurSel(GetDlgItem(hwnd,ID_VIDEORES),j+p*resolutionlistcount);

	if (videofs) {
		CheckDlgButton(hwnd, ID_VIDEOFULLSC, TRUE);
	}
}

void PopulateInputDialog(HWND hwnd)
{
	UINT i,j;
	char txt[256];

	// populate the key actions list
	ListBox_ResetContent(GetDlgItem(hwnd,ID_KEYLIST));
	for (i=0;i<numkeydefaults;i++) {
		sprintf(txt, "%s\t%s\t%s", gamefunctions[i], keyconfiguration[i][0], keyconfiguration[i][1]);
		ListBox_AddString(GetDlgItem(hwnd,ID_KEYLIST), txt);
	}	
	
	// populate the mouse actions list
	ListBox_ResetContent(GetDlgItem(hwnd,ID_MOUSELIST));
	for (i=0;i<nummousebuttons;i++) {
		sprintf(txt, "%s\t%s", mousebuttons[i], mouseconfiguration[i][0]);
		ListBox_AddString(GetDlgItem(hwnd,ID_MOUSELIST), txt);
		if (i<(nummousebuttons-2)) {
			sprintf(txt, "*%s\t%s", mousebuttons[i], mouseconfiguration[i][1]);
			ListBox_AddString(GetDlgItem(hwnd,ID_MOUSELIST), txt);
		}
	}
	
	j=0;
	ComboBox_ResetContent(GetDlgItem(hwnd,ID_INPUTDEV));
	for (i=0;i<numinputdevices;i++) {
		ComboBox_AddString(GetDlgItem(hwnd,ID_INPUTDEV), inputdevices[i]);
		if (i == inputdevs) j=i;
	}
	ComboBox_SetCurSel(GetDlgItem(hwnd,ID_INPUTDEV),j);
}

void PopulateAdvancedMouseDialog(HWND hwnd)
{
	char txt[256];
	int a,b;
	UINT i;
	
	a=(int)ceil(mousexscale/6553.6);
	b=(int)ceil(mouseyscale/6553.6);
	
	SendMessage(GetDlgItem(hwnd,ID_XSCALETRACK),TBM_SETPOS,TRUE,a);
	SendMessage(GetDlgItem(hwnd,ID_YSCALETRACK),TBM_SETPOS,TRUE,b);
	if (a<0) sprintf(txt,"-%d.%d",(-a)/10,(-a)%10);
	else sprintf(txt," %d.%d",a/10,a%10);
	SetDlgItemText(hwnd,ID_XSCALEVAL,txt);
	if (b<0) sprintf(txt,"-%d.%d",(-b)/10,(-b)%10);
	else sprintf(txt," %d.%d",b/10,b%10);
	SetDlgItemText(hwnd,ID_YSCALEVAL,txt);

	if (!mouseaimmode) {
		CheckDlgButton(hwnd, ID_AIMTOGGLE, TRUE);
	} else {
		CheckDlgButton(hwnd, ID_AIMMOMENTARY, TRUE);
	}

	ComboBox_ResetContent(GetDlgItem(hwnd,ID_ANALOGX));
	ComboBox_ResetContent(GetDlgItem(hwnd,ID_ANALOGY));
	ComboBox_AddString(GetDlgItem(hwnd,ID_ANALOGX),"");
	ComboBox_AddString(GetDlgItem(hwnd,ID_ANALOGY),"");
	for (i=0;i<numanalogueaxes;i++) {
		ComboBox_AddString(GetDlgItem(hwnd,ID_ANALOGX),analogueaxes[i]);
		ComboBox_AddString(GetDlgItem(hwnd,ID_ANALOGY),analogueaxes[i]);
	}

	ComboBox_SetCurSel(GetDlgItem(hwnd,ID_ANALOGX),mouseanalogaxes[0]+1);
	ComboBox_SetCurSel(GetDlgItem(hwnd,ID_ANALOGY),mouseanalogaxes[1]+1);

	if (!mousedigitalaxes[0][0]) SetWindowText(GetDlgItem(hwnd,ID_DIGITALLEFT),"");
	else SetWindowText(GetDlgItem(hwnd,ID_DIGITALLEFT),mousedigitalaxes[0]);
	if (!mousedigitalaxes[1][0]) SetWindowText(GetDlgItem(hwnd,ID_DIGITALRIGHT),"");
	else SetWindowText(GetDlgItem(hwnd,ID_DIGITALRIGHT),mousedigitalaxes[1]);
	if (!mousedigitalaxes[2][0]) SetWindowText(GetDlgItem(hwnd,ID_DIGITALUP),"");
	else SetWindowText(GetDlgItem(hwnd,ID_DIGITALUP),mousedigitalaxes[2]);
	if (!mousedigitalaxes[3][0]) SetWindowText(GetDlgItem(hwnd,ID_DIGITALDOWN),"");
	else SetWindowText(GetDlgItem(hwnd,ID_DIGITALDOWN),mousedigitalaxes[3]);
}


INT_PTR CALLBACK KeyBoxFn(HWND hwnd, UINT umsg, WPARAM wparam, LPARAM lparam)
{
	int i;
	UINT cursel;
	char keyname[32];
	
	switch (umsg) {
		case WM_INITDIALOG:
			sprintf(keyname, "Select %s Key", keyinf.secondary?"Secondary":"Primary");
			SetWindowText(hwnd, keyname);
			
			SetDlgItemText(hwnd, ID_FUNCTIONNAME, gamefunctions[keyinf.function]);
			ListBox_ResetContent(GetDlgItem(hwnd,ID_KEYS));
			for (i=0;i<keyslistcount;i++) {
				ListBox_AddString(GetDlgItem(hwnd,ID_KEYS),keyslist[i]);
			}
			if (keyconfiguration[keyinf.function][keyinf.secondary][0] == 0) {
				CheckDlgButton(hwnd, ID_KEYNONE, TRUE);
				EnableWindow(GetDlgItem(hwnd,ID_KEYS),FALSE);
			} else {
				CheckDlgButton(hwnd, ID_KEYNONE, FALSE);
				EnableWindow(GetDlgItem(hwnd,ID_KEYS),TRUE);
				if (ListBox_SelectString(GetDlgItem(hwnd,ID_KEYS),-1,
				   keyconfiguration[keyinf.function][keyinf.secondary]) == LB_ERR) {
					if (keydefaults[3*keyinf.function+1+keyinf.secondary][0] == 0)
						ListBox_SetCurSel(GetDlgItem(hwnd,ID_KEYS),0);
					else
						ListBox_SelectString(GetDlgItem(hwnd,ID_KEYS),-1,
						   keydefaults[3*keyinf.function+1+keyinf.secondary]);
				}
			}
			return TRUE;

		case WM_COMMAND:
			switch (wparam) {
				case ID_KEYNONE:
					if (IsDlgButtonChecked(hwnd,ID_KEYNONE)) {
						EnableWindow(GetDlgItem(hwnd,ID_KEYS),FALSE);
					} else {
						EnableWindow(GetDlgItem(hwnd,ID_KEYS),TRUE);
						if (ListBox_SelectString(GetDlgItem(hwnd,ID_KEYS),-1,
						   keyconfiguration[keyinf.function][keyinf.secondary]) == LB_ERR) {
							if (keydefaults[3*keyinf.function+1+keyinf.secondary][0] == 0)
								ListBox_SetCurSel(GetDlgItem(hwnd,ID_KEYS),0);
							else
								ListBox_SelectString(GetDlgItem(hwnd,ID_KEYS),-1,
								   keydefaults[3*keyinf.function+1+keyinf.secondary]);
						}
					}
					return TRUE;
				
				case IDOK:
					if (IsDlgButtonChecked(hwnd,ID_KEYNONE)) {
						keyconfiguration[keyinf.function][keyinf.secondary] = "";
					} else {
						cursel = ListBox_GetCurSel(GetDlgItem(hwnd,ID_KEYS));
						if (cursel == LB_ERR) {
							MessageBox(hwnd,"You must select a key, or tick the \"None\" box to specify a key to assign.", "Bad Selection", MB_OK|MB_ICONINFORMATION);
							return TRUE;
						}
						ListBox_GetText(GetDlgItem(hwnd,ID_KEYS),cursel,keyname);
						for (i=0;i<keyslistcount;i++) {
							if (!strcasecmp(keyname,keyslist[i])) {
								keyconfiguration[keyinf.function][keyinf.secondary] = keyslist[i];
								break;
							}
						}
					}
					changes=1;
					EndDialog(hwnd, 0);
					return TRUE;
				
				case IDCANCEL:
					EndDialog(hwnd, 1);
					return TRUE;
			}
			break;
	}
	
	return FALSE;
}


INT_PTR CALLBACK FuncBoxFn(HWND hwnd, UINT umsg, WPARAM wparam, LPARAM lparam)
{
	int i;
	UINT cursel;
	char keyname[32];
	char *device;
	char *button;
	char **defaults;

	if (buttoninf.device&0x80000000l) {
		switch (buttoninf.device&0x7fffffffl) {
			case 0: device = "Mouse Digital"; defaults = mousedigitaldefaults; break;
			default: device = "Unknown"; break;
		}
		switch (buttoninf.button) {
			case 0: button = "Left"; break;
			case 1: button = "Right"; break;
			case 2: button = "Up"; break;
			case 3: button = "Down"; break;
			default: button = "Unknown"; break;
		}
	} else {
		switch (buttoninf.device) {
			case 0: device = "Mouse";
				button = mousebuttons[buttoninf.button];
				defaults = buttoninf.clicked?mouseclickeddefaults:mousedefaults;
				break;
			default: device = "Unknown"; button = "Unknown"; break;
		}
	}
	
	switch (umsg) {
		case WM_INITDIALOG:
			sprintf(keyname, "%s %s%s", device, button, buttoninf.clicked?" (Doubleclicked)":"");
			SetDlgItemText(hwnd, ID_FUNCTIONNAME, keyname);
			ListBox_ResetContent(GetDlgItem(hwnd,ID_KEYS));
			for (i=0;i<numgamefunctions;i++)
				ListBox_AddString(GetDlgItem(hwnd,ID_KEYS),gamefunctions[i]);
			// mouse button
			if (buttoninf.device == 0) {
				if (mouseconfiguration[buttoninf.button][buttoninf.clicked][0] == 0) {
					CheckDlgButton(hwnd, ID_KEYNONE, TRUE);
					EnableWindow(GetDlgItem(hwnd,ID_KEYS),FALSE);
				} else {
					CheckDlgButton(hwnd, ID_KEYNONE, FALSE);
					EnableWindow(GetDlgItem(hwnd,ID_KEYS),TRUE);
					if (ListBox_SelectString(GetDlgItem(hwnd,ID_KEYS),-1,
					   mouseconfiguration[buttoninf.button][buttoninf.clicked]) == LB_ERR) {
						if (defaults[buttoninf.button][0] == 0)
							ListBox_SetCurSel(GetDlgItem(hwnd,ID_KEYS),0);
						else
							ListBox_SelectString(GetDlgItem(hwnd,ID_KEYS),-1,
							   defaults[buttoninf.button]);
					}
				}
			// mouse digital axis
			} else if (buttoninf.device == 0+0x80000000l) {
				if (mousedigitalaxes[buttoninf.button][0] == 0) {
					CheckDlgButton(hwnd, ID_KEYNONE, TRUE);
					EnableWindow(GetDlgItem(hwnd,ID_KEYS),FALSE);
				} else {
					CheckDlgButton(hwnd, ID_KEYNONE, FALSE);
					EnableWindow(GetDlgItem(hwnd,ID_KEYS),TRUE);
					if (ListBox_SelectString(GetDlgItem(hwnd,ID_KEYS),-1,
					   mousedigitalaxes[buttoninf.button]) == LB_ERR) {
						if (defaults[buttoninf.button][0] == 0)
							ListBox_SetCurSel(GetDlgItem(hwnd,ID_KEYS),0);
						else
							ListBox_SelectString(GetDlgItem(hwnd,ID_KEYS),-1,
							   defaults[buttoninf.button]);
					}
				}
			}
			return TRUE;

		case WM_COMMAND:
			switch (wparam) {
				case ID_KEYNONE:
					if (IsDlgButtonChecked(hwnd,ID_KEYNONE)) {
						EnableWindow(GetDlgItem(hwnd,ID_KEYS),FALSE);
					} else {
						EnableWindow(GetDlgItem(hwnd,ID_KEYS),TRUE);
						// mouse button
						if (buttoninf.device == 0) {
							if (ListBox_SelectString(GetDlgItem(hwnd,ID_KEYS),-1,
							   mouseconfiguration[buttoninf.button][buttoninf.clicked]) == LB_ERR) {
								if (defaults[buttoninf.button][0] == 0)
									ListBox_SetCurSel(GetDlgItem(hwnd,ID_KEYS),0);
								else
									ListBox_SelectString(GetDlgItem(hwnd,ID_KEYS),-1,
									   defaults[buttoninf.button]);
							}
						// mouse digital axis
						} else if (buttoninf.device == 0+0x80000000l) {
							if (ListBox_SelectString(GetDlgItem(hwnd,ID_KEYS),-1,
							   mousedigitalaxes[buttoninf.button]) == LB_ERR) {
								if (defaults[buttoninf.button][0] == 0)
									ListBox_SetCurSel(GetDlgItem(hwnd,ID_KEYS),0);
								else
									ListBox_SelectString(GetDlgItem(hwnd,ID_KEYS),-1,
									   defaults[buttoninf.button]);
							}
						}
					}
					return TRUE;
				
				case IDOK:
					if (IsDlgButtonChecked(hwnd,ID_KEYNONE)) {
						// mouse button
						if (buttoninf.device == 0)
							mouseconfiguration[buttoninf.button][buttoninf.clicked] = "";
						
						// mouse digital axis
						else if (buttoninf.device == 0+0x80000000l)
							mousedigitalaxes[buttoninf.button] = "";
					} else {
						cursel = ListBox_GetCurSel(GetDlgItem(hwnd,ID_KEYS));
						if (cursel == LB_ERR) {
							MessageBox(hwnd,"You must select a key, or tick the \"None\" box to specify a key to assign.", "Bad Selection", MB_OK|MB_ICONINFORMATION);
							return TRUE;
						}
						// mouse button
						if (buttoninf.device == 0)
							mouseconfiguration[buttoninf.button][buttoninf.clicked] = gamefunctions[cursel];
						// mouse digital axis
						else if (buttoninf.device == 0+0x80000000l)
							mousedigitalaxes[buttoninf.button] = gamefunctions[cursel];
						
					}
					changes=1;
					EndDialog(hwnd, 0);
					return TRUE;
				
				case IDCANCEL:
					EndDialog(hwnd, 1);
					return TRUE;
			}
			break;
	}
	
	return FALSE;
}


INT_PTR CALLBACK SoundBoxFn(HWND hwnd, UINT umsg, WPARAM wparam, LPARAM lparam)
{
	UINT cursel;
	
	switch (umsg) {
		case WM_INITDIALOG:
			PopulateSoundDialog(hwnd);
			return TRUE;

		case WM_COMMAND:
			switch (LOWORD(wparam)) {
				case ID_MUSICENABLED:
					if (IsDlgButtonChecked(hwnd,ID_MUSICENABLED)) {
						EnableWindow(GetDlgItem(hwnd,ID_MUSICDEVICE),TRUE);
						musicdevice = ComboBox_GetCurSel(GetDlgItem(hwnd,ID_MUSICDEVICE));
					} else {
						EnableWindow(GetDlgItem(hwnd,ID_MUSICDEVICE),FALSE);
						musicdevice = -1;
					}
					changes=1;
					return TRUE;

				case ID_MUSICDEVICE:
					musicdevice = ComboBox_GetCurSel(GetDlgItem(hwnd,ID_MUSICDEVICE));
					changes=1;
					return TRUE;

				case ID_SOUNDENABLED:
					if (IsDlgButtonChecked(hwnd,ID_SOUNDENABLED)) sounddevice = 0;
					else sounddevice = -1;
					changes=1;
					return TRUE;

				case ID_SOUNDVOICES:
					soundvoices = ComboBox_GetCurSel(GetDlgItem(hwnd,ID_SOUNDVOICES));
					soundvoices = voicelist[soundvoices];
					changes=1;
					return TRUE;

				case ID_SOUND8BIT:
					soundbits = 8;
					changes=1;
					return TRUE;

				case ID_SOUND16BIT:
					soundbits = 16;
					changes=1;
					return TRUE;

				case ID_SOUNDFREQ:
					soundfreq = ComboBox_GetCurSel(GetDlgItem(hwnd,ID_SOUNDFREQ));
					soundfreq = frequlist[soundfreq];
					changes=1;
					return TRUE;

				case ID_VIDEORES:
					cursel = ComboBox_GetCurSel(GetDlgItem(hwnd,ID_VIDEORES));
					videobpp = colourdepthlist[ cursel / resolutionlistcount ];
					cursel %= resolutionlistcount;
					videowidth = resolutionlist[cursel][0];
					videoheight = resolutionlist[cursel][1];
					changes=1;
					return TRUE;
					
				case ID_VIDEOFULLSC:
					if (IsDlgButtonChecked(hwnd,ID_VIDEOFULLSC)) videofs = 1;
					else videofs = 0;
					changes=1;
					return TRUE;

				case IDOK:
				case IDCANCEL:
					EndDialog(hwnd,0);
					return TRUE;
			}
			break;

		default:
			break;
	}

	return FALSE;
}


INT_PTR CALLBACK AdvancedMouseBoxFn(HWND hwnd, UINT umsg, WPARAM wparam, LPARAM lparam)
{
	char txt[256];
	int i;
	UINT cursel;
	
	switch (umsg) {
		case WM_INITDIALOG:
			SendMessage(GetDlgItem(hwnd,ID_XSCALETRACK),TBM_SETRANGE,TRUE,MAKELONG(-40,40));
			SendMessage(GetDlgItem(hwnd,ID_YSCALETRACK),TBM_SETRANGE,TRUE,MAKELONG(-40,40));
			SendMessage(GetDlgItem(hwnd,ID_XSCALETRACK),TBM_SETTHUMBLENGTH,16,0);
			SendMessage(GetDlgItem(hwnd,ID_YSCALETRACK),TBM_SETTHUMBLENGTH,16,0);
			SendMessage(GetDlgItem(hwnd,ID_XSCALETRACK),TBM_SETTICFREQ,5,0);
			SendMessage(GetDlgItem(hwnd,ID_YSCALETRACK),TBM_SETTICFREQ,5,0);
			SendMessage(GetDlgItem(hwnd,ID_XSCALETRACK),TBM_SETPAGESIZE,0,10);
			SendMessage(GetDlgItem(hwnd,ID_YSCALETRACK),TBM_SETPAGESIZE,0,10);
			PopulateAdvancedMouseDialog(hwnd);
			return TRUE;
			
		case WM_HSCROLL:
			if ((HWND)lparam == GetDlgItem(hwnd,ID_XSCALETRACK)) {
				i = SendMessage(GetDlgItem(hwnd,ID_XSCALETRACK),TBM_GETPOS,0,0);
				if (i<0) sprintf(txt,"-%d.%d",(-i)/10,(-i)%10);
				else sprintf(txt," %d.%d",i/10,i%10);
				SetDlgItemText(hwnd,ID_XSCALEVAL,txt);
				mousexscale = i*65536/10;
				changes=1;
				return TRUE;
			} else if ((HWND)lparam == GetDlgItem(hwnd,ID_YSCALETRACK)) {
				i = SendMessage(GetDlgItem(hwnd,ID_YSCALETRACK),TBM_GETPOS,0,0);
				if (i<0) sprintf(txt,"-%d.%d",(-i)/10,(-i)%10);
				else sprintf(txt," %d.%d",i/10,i%10);
				SetDlgItemText(hwnd,ID_YSCALEVAL,txt);
				mouseyscale = i*65536/10;
				changes=1;
				return TRUE;
			}
			break;

		case WM_COMMAND:
			switch (LOWORD(wparam)) {
				case ID_AIMTOGGLE:
					mouseaimmode = 0;
					changes=1;
					return TRUE;

				case ID_AIMMOMENTARY:
					mouseaimmode = 1;
					changes=1;
					return TRUE;

				case ID_ANALOGX:
					cursel = ComboBox_GetCurSel(GetDlgItem(hwnd,ID_ANALOGX));
					mouseanalogaxes[0] = ((int)cursel)-1;
					changes=1;
					return TRUE;

				case ID_ANALOGY:
					cursel = ComboBox_GetCurSel(GetDlgItem(hwnd,ID_ANALOGY));
					mouseanalogaxes[1] = ((int)cursel)-1;
					changes=1;
					return TRUE;
					
				case ID_DIGITALLEFT:
				case ID_DIGITALRIGHT:
				case ID_DIGITALUP:
				case ID_DIGITALDOWN:
					buttoninf.device = 0+0x80000000l;
					switch (LOWORD(wparam)) {
						case ID_DIGITALLEFT: buttoninf.button = 0; break;
						case ID_DIGITALRIGHT: buttoninf.button = 1; break;
						case ID_DIGITALUP: buttoninf.button = 2; break;
						case ID_DIGITALDOWN: buttoninf.button = 3; break;
					}
					buttoninf.clicked = 0;
					if (!DialogBoxParam(hInst,MAKEINTRESOURCE(SELECTFUNC),hwnd,FuncBoxFn,0)) {
						PopulateAdvancedMouseDialog(hwnd);
					}
					return TRUE;
					
				case IDOK:
				case IDCANCEL:
					EndDialog(hwnd,0);
					return TRUE;
			}
			break;

		default:
			break;
	}

	return FALSE;
}


INT_PTR CALLBACK InputBoxFn(HWND hwnd, UINT umsg, WPARAM wparam, LPARAM lparam)
{
	UINT cursel;
	
	switch (umsg) {
		case WM_INITDIALOG:
			ListBox_SetTabStops(GetDlgItem(hwnd,ID_KEYLIST),2,keytabstops);
			ListBox_SetTabStops(GetDlgItem(hwnd,ID_MOUSELIST),1,mousetabstops);
			PopulateInputDialog(hwnd);
			return TRUE;

		case WM_COMMAND:
			switch (LOWORD(wparam)) {
				case ID_INPUTDEV:
					inputdevs = ComboBox_GetCurSel(GetDlgItem(hwnd,ID_INPUTDEV));
					changes=1;
					return TRUE;

				case ID_KEYSETPRIM:
					keyinf.function = ListBox_GetCurSel(GetDlgItem(hwnd,ID_KEYLIST));
					keyinf.secondary = 0;
					if (keyinf.function == LB_ERR) return TRUE;
					if (!DialogBoxParam(hInst,MAKEINTRESOURCE(SELECTKEY),hwnd,KeyBoxFn,0)) {
						PopulateInputDialog(hwnd);
						ListBox_SetCurSel(GetDlgItem(hwnd,ID_KEYLIST),keyinf.function);
					}
					changes=1;
					return TRUE;
					
				case ID_KEYSETSEC:
					keyinf.function = ListBox_GetCurSel(GetDlgItem(hwnd,ID_KEYLIST));
					if (keyinf.function == consolefunc) {
						MessageBox(hwnd,"The console may be activated by one key only.",
								"Set Secondary Key",MB_OK|MB_ICONINFORMATION);
						return TRUE;
					}
					
					keyinf.secondary = 1;
					if (keyinf.function == LB_ERR) return TRUE;
					if (!DialogBoxParam(hInst,MAKEINTRESOURCE(SELECTKEY),hwnd,KeyBoxFn,0)) {
						PopulateInputDialog(hwnd);
						ListBox_SetCurSel(GetDlgItem(hwnd,ID_KEYLIST),keyinf.function);
					}
					changes=1;
					return TRUE;

				case ID_MOUSEADVANCED:
					DialogBoxParam(hInst,MAKEINTRESOURCE(ADVANCEDMOUSE),hwnd,AdvancedMouseBoxFn,0);
					return TRUE;

				case ID_MOUSESET:
					cursel = ListBox_GetCurSel(GetDlgItem(hwnd,ID_MOUSELIST));
					if (cursel == LB_ERR) return TRUE;
					buttoninf.device = 0;
					if (cursel < (nummousebuttons-2)*2) {
						buttoninf.button = cursel / 2;
						buttoninf.clicked = cursel & 1;
					} else {
						buttoninf.button = cursel - (nummousebuttons-2);
						buttoninf.clicked = 0;
					}
					if (!DialogBoxParam(hInst,MAKEINTRESOURCE(SELECTFUNC),hwnd,FuncBoxFn,0)) {
						PopulateInputDialog(hwnd);
						ListBox_SetCurSel(GetDlgItem(hwnd,ID_MOUSELIST),cursel);
					}
					changes=1;
					return TRUE;
				
				case IDOK:
				case IDCANCEL:
					EndDialog(hwnd,0);
					return TRUE;
			}
			break;

		default:
			break;
	}

	return FALSE;
}


INT_PTR CALLBACK MainBoxFn(HWND hwnd, UINT umsg, WPARAM wparam, LPARAM lparam)
{
	switch (umsg) {
		case WM_INITDIALOG:
			SetClassLong(hwnd, GCL_HICON, (LONG)LoadIcon(hInst, MAKEINTRESOURCE(1000)));
			return TRUE;

		case WM_COMMAND:
			switch (LOWORD(wparam)) {
				case ID_SETSOUNDVID:
					DialogBoxParam(hInst,MAKEINTRESOURCE(MUSICSOUNDVIDEO),hwnd,SoundBoxFn,0);
					return TRUE;
					
				case ID_SETINPUT:
					DialogBoxParam(hInst,MAKEINTRESOURCE(INPUTDEVS),hwnd,InputBoxFn,0);
					return TRUE;
				
				case IDOK:
					SaveSettings();
					MessageBox(hwnd,"Configuration saved.","Save Configuration Changes",MB_OK|MB_ICONINFORMATION);
					changes=0;
					return TRUE;
					
				case IDCANCEL:
					if (changes) {
						if (MessageBox(hwnd,"Your configuration has been changed. Save now?", "Save Configuration Changes",MB_YESNO|MB_ICONQUESTION) == IDYES)
							SaveSettings();
					}
					EndDialog(hwnd,0);
					return TRUE;

				case IDABORT:
					SaveSettings();
					rungame=1;
					EndDialog(hwnd,0);
					return TRUE;
			}
			break;

		default:
			break;
	}

	return FALSE;
}


int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInst, LPSTR lpCmdLine, int nCmdShow)
{
	int i;

	InitCommonControls();

	hInst = hInstance;

	for (i=0;i<numgamefunctions;i++) {
		keyconfiguration[i][0] = keydefaults[3*i+1];
		keyconfiguration[i][1] = keydefaults[3*i+2];
	}
	for (i=0;i<nummousebuttons;i++) {
		mouseconfiguration[i][0] = mousedefaults[i];
		mouseconfiguration[i][1] = mouseclickeddefaults[i];
	}
	for (i=0;i<2;i++) {
		mouseanalogaxes[i] = TranslateAnalogAxis(mouseanalogdefaults[i]);
	}
	for (i=0;i<4;i++) {
		mousedigitalaxes[i] = mousedigitaldefaults[i];
	}

	LoadSettings();
			
	DialogBox(hInst,MAKEINTRESOURCE(CONFIG),NULL,MainBoxFn);

	if (confighandle>=0) SCRIPT_Free(confighandle);

	if (rungame) {
		STARTUPINFO si;
		PROCESS_INFORMATION pi;
		ZeroMemory(&si,sizeof(si));
		ZeroMemory(&pi,sizeof(pi));
		si.cb = sizeof(si);
		if (!CreateProcess("duke3d.exe",NULL,NULL,NULL,0,0,NULL,NULL,&si,&pi)) {
			MessageBox(0,"Failed starting DUKE3D.EXE.", "Failure starting game", MB_OK|MB_ICONSTOP);
			return 1;
		}
	}

	return 0;
}

