; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "JFDuke3D"
!define PRODUCT_VERSION "20050531"
!define PRODUCT_PUBLISHER "JonoF"
!define PRODUCT_WEB_SITE "http://jonof.edgenetwork.org/index.php?p=jfduke3d"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\${PRODUCT_NAME}"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define PRODUCT_STARTMENU_REGVAL "NSIS:StartMenuDir"

SetCompressor lzma

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\box-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\box-uninstall.ico"
!define MUI_WELCOMEFINISHPAGE_BITMAP "${NSISDIR}\Contrib\Graphics\Wizard\arrow.bmp"
!define MUI_UNWELCOMEFINISHPAGE_BITMAP "${NSISDIR}\Contrib\Graphics\Wizard\arrow.bmp"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "..\GNU.TXT"
; Components page
!insertmacro MUI_PAGE_COMPONENTS
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Start menu page
var ICONS_GROUP
!define MUI_STARTMENUPAGE_NODISABLE
!define MUI_STARTMENUPAGE_DEFAULTFOLDER "JFDuke3D"
!define MUI_STARTMENUPAGE_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "${PRODUCT_STARTMENU_REGVAL}"
!insertmacro MUI_PAGE_STARTMENU Application $ICONS_GROUP
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_RUN "$INSTDIR\datainst.exe"
!define MUI_FINISHPAGE_RUN_TEXT "Run GRP file installer"
;!define MUI_FINISHPAGE_RUN_PARAMETERS ""
!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\releasenotes.html"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; Reserve files
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "jfduke3d-${PRODUCT_VERSION}-setup.exe"
InstallDir "$PROGRAMFILES\JFDuke3D"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Section "!Game" SEC_GAME
  SetOutPath "$INSTDIR"
  SetOverwrite ifnewer
  File "..\duke3d.exe"
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\JFDuke3D.lnk" "$INSTDIR\duke3d.exe"
  File "..\GNU.TXT"
  File "..\readme.txt"
  File "..\releasenotes.html"
  File "..\setup.exe"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Setup.lnk" "$INSTDIR\setup.exe"
  File "E:\ports\datainst\datainst.exe"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Game Data Installer.lnk" "$INSTDIR\datainst.exe"
SectionEnd

Section "Editor" SEC_EDITOR
  SetOutPath "$INSTDIR"
  SetOverwrite ifnewer
  File "..\build.cfg"
  File "..\build.exe"
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Build Editor.lnk" "$INSTDIR\build.exe"
SectionEnd

Section /o "Samples" SEC_SAMPLES
  SetOutPath "$INSTDIR"
  SetOverwrite ifnewer
  File "..\duke3d.def.sample"
  SetOutPath "$INSTDIR\models"
  File "..\models\pigcop.md2"
  File "..\models\pigcop.jpg"
  SetOutPath "$INSTDIR"
SectionEnd

Section -AdditionalIcons
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\JFDuke3D Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk" "$INSTDIR\uninst.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\duke3d.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\duke3d.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "${PRODUCT_STARTMENU_REGVAL}" "$ICONS_GROUP"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

; Section descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC_GAME} "The main JFDuke3D game components (required to play the game)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC_EDITOR} "The Build Editor for JFDuke3D (optional)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC_SAMPLES} "An example 3D model and sample enhancements definition file (optional)"
!insertmacro MUI_FUNCTION_DESCRIPTION_END


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "JFDuke3D was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove JFDuke3D and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  ReadRegStr $ICONS_GROUP ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "${PRODUCT_STARTMENU_REGVAL}"
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"
  Delete "$INSTDIR\models\pigcop.md2"
  Delete "$INSTDIR\models\pigcop.jpg"
  Delete "$INSTDIR\duke3d.def.sample"
  Delete "$INSTDIR\build.exe"
  Delete "$INSTDIR\build.cfg"
  Delete "$INSTDIR\setup.exe"
  Delete "$INSTDIR\releasenotes.html"
  Delete "$INSTDIR\readme.txt"
  Delete "$INSTDIR\GNU.TXT"
  Delete "$INSTDIR\duke3d.exe"
  Delete "$INSTDIR\datainst.exe"
  
  Delete "$INSTDIR\duke3d.grp"
  Delete "$INSTDIR\duke3d.cfg"

  Delete "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\JFDuke3D Website.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Build Editor.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Setup.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\JFDuke3D.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Game Data Installer.lnk"

  RMDir "$SMPROGRAMS\$ICONS_GROUP"
  RMDir "$INSTDIR\models"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd
