#include "osdcmds.h"
#include "osd.h"
#include "duke3d.h"
#include "crc32.h"

int osdcmd_quit(const osdfuncparm_t *parm)
{
	if (numplayers > 1) {
		if(!(ps[myconnectindex].gm&MODE_GAME))
			sendlogoff();
	}
	gameexit(" ");

	return OSDCMD_OK;
}

int osdcmd_echo(const osdfuncparm_t *parm)
{
	const char *c;

	for (c = parm->raw; *c && *c != ' '; c++) ;
	for (; *c && *c == ' '; c++) ;
	OSD_Printf("%s\n", c);
	
	return OSDCMD_OK;
}

int osdcmd_changelevel(const osdfuncparm_t *parm)
{
	int volume=0,level,i;
	char *p;

#ifndef VOLUMEONE
	volume = strtol(parm->parms[0], &p, 10) - 1;
	if (p[0]) return OSDCMD_SHOWHELP;
	level = strtol(parm->parms[1], &p, 10) - 1;
	if (p[0]) return OSDCMD_SHOWHELP;
#else
	level = strtol(parm->parms[0], &p, 10) - 1;
	if (p[0]) return OSDCMD_SHOWHELP;
#endif

	if (volume < 0) return OSDCMD_SHOWHELP;
	if (level < 0) return OSDCMD_SHOWHELP;

#ifndef VOLUMEONE
#ifdef PLUTOPAK
	if (volume > 3) {
		OSD_Printf("Error: invalid volume number (range 1-4)\n");
		return OSDCMD_OK;
	}
#else
	if (volume > 2) {
		OSD_Printf("Error: invalid volume number (range 1-3)\n");
		return OSDCMD_OK;
	}
#endif
#endif

	if (volume == 0) {
		if (level > 5) {
			OSD_Printf("Error: invalid volume 1 level number (range 1-6)\n");
			return OSDCMD_OK;
		}
	} else {
		if (level > 10) {
			OSD_Printf("Error: invalid volume 2+ level number (range 1-11)\n");
			return OSDCMD_SHOWHELP;
		}
	}

	ud.m_volume_number = ud.volume_number = volume;
	ud.m_level_number = ud.level_number = level;

       	newgame(ud.m_volume_number,ud.m_level_number,ud.m_player_skill);
        enterlevel(MODE_GAME);

	return OSDCMD_OK;
}

int osdcmd_map(const osdfuncparm_t *parm)
{
	int i;
	char filename[256];

	strcpy(filename,parm->parms[0]);
	if( strchr(filename,'.') == 0)
        	strcat(filename,".map");

	if ((i = kopen4load(filename,0)) < 0) {
		OSD_Printf("Error: Map file \"%s\" does not exist.\n", filename);
		return OSDCMD_OK;
	}
	kclose(i);

	strcpy(boardfilename, filename);

	ud.m_volume_number = 0;
	ud.m_level_number = 7;

	if (ps[myconnectindex].gm & MODE_GAME) {
	        if(numplayers > 1 && myconnectindex == connecthead) {
			tempbuf[0] = 5;
			tempbuf[1] = ud.m_level_number;
			tempbuf[2] = ud.m_volume_number;
			tempbuf[3] = ud.m_player_skill;
			tempbuf[4] = ud.m_monsters_off;
			tempbuf[5] = ud.m_respawn_monsters;
			tempbuf[6] = ud.m_respawn_items;
			tempbuf[7] = ud.m_respawn_inventory;
			tempbuf[8] = ud.m_coop;
			tempbuf[9] = ud.m_marker;
			tempbuf[10] = ud.m_ffire;

	                for(i=connecthead;i>=0;i=connectpoint2[i])
        	        	sendpacket(i,tempbuf,11);
		} else ps[myconnectindex].gm |= MODE_RESTART;
	} else {
        	newgame(ud.m_volume_number,ud.m_level_number,ud.m_player_skill);
	        enterlevel(MODE_GAME);
	}
       
	return OSDCMD_OK;
}

int osdcmd_fileinfo(const osdfuncparm_t *parm)
{
	unsigned long crc, length;
	int i,j;
	char buf[256];

	if ((i = kopen4load(parm->parms[0],0)) < 0) {
		OSD_Printf("Error: File \"%s\" does not exist.\n", parm->parms[0]);
		return OSDCMD_OK;
	}

	length = kfilelength(i);

	crc32init(&crc);
	do {
		j = kread(i,buf,256);
		crc32block(&crc,buf,j);
	} while (j == 256);
	crc32finish(&crc);
	
	kclose(i);

	OSD_Printf("File: %s\n"
	           "  File size: %d\n"
		   "  CRC-32:    %08X\n",
		   parm->parms[0], length, crc);

	return OSDCMD_OK;
}

int osdcmd_validateshowfps(void *a)
{
	int *i = (int *)a;

	if (*i>0) *i = 1;
	else *i = 0;

	return 1;
}

int registerosdcommands(void)
{
	OSD_RegisterFunction("echo",0,"echo [text]: echoes text to the console", osdcmd_echo);

#ifdef VOLUMEONE
	OSD_RegisterFunction("changelevel",1,"changelevel <level>: warps to the given level", osdcmd_changelevel);
#else
	OSD_RegisterFunction("changelevel",2,"changelevel <volume> <level>: warps to the given level", osdcmd_changelevel);
	OSD_RegisterFunction("map",1,"map <mapfile>: loads the given user map", osdcmd_map);
#endif
	OSD_RegisterFunction("fileinfo",1,"fileinfo <file>: gets a file's information", osdcmd_fileinfo);
	OSD_RegisterFunction("quit",0,"quit: exits the game immediately", osdcmd_quit);
	
	OSD_RegisterVariable("myname",OSDVAR_STRING,myname,32,NULL);
	OSD_RegisterVariable("showfps",OSDVAR_INTEGER,&ud.tickrate,1,osdcmd_validateshowfps);

	return 0;
}

