/*
 * mathutil.c
 * Mathematical utility functions to emulate MACT
 *
 * by Jonathon Fowler
 *
 * Since we weren't given the source for MACT386.LIB so I've had to do some
 * creative interpolation here.
 *
 */
//-------------------------------------------------------------------------
/*
Duke Nukem Copyright (C) 1996, 2003 3D Realms Entertainment

This file is part of Duke Nukem 3D version 1.5 - Atomic Edition

Duke Nukem 3D is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
//-------------------------------------------------------------------------

#include "types.h"


#ifdef NO_GCC_BUILTINS
#include <math.h>
#define sqr(x) ((x)*(x))
#endif


int32 FindDistance2D(int32 dx, int32 dy)
{
//	return (int32)floor(sqrt((double)(sqr(dx)+sqr(dy))));
	return ksqrt(sqr(dx)+sqr(dy));
}

int32 FindDistance3D(int32 dx, int32 dy, int32 dz)
{
//	return (int32)floor(sqrt((double)(sqr(dx)+sqr(dy)+sqr(dz))));
	return ksqrt(sqr(dx)+sqr(dy)+sqr(dz));
}

