// Function-wrapped versions of Watcom pragmas
// for the Build Engine
// by Jonathon Fowler (jonof@edgenetwk.com)
//
// These are here for no real reason apart from the novelty of
// having them since I converted from these to macro-inline
// versions. I can't bring myself to erase these yet.
// 		--Jonathon

/*#pragma aux sqr =\
	"imul eax, eax",\
	parm nomemory [eax]\
	modify exact [eax]\
	value [eax] */
long sqr(long a)
{
	ASM (
		"imull %0, %0"		// imul eax, eax
		: "+q" (a) : : "cc"
	);
	return a;
}

/*#pragma aux scale =\
	"imul edx",\
	"idiv ecx",\
	parm nomemory [eax][edx][ecx]\
	modify exact [eax edx]\ */
long scale(long a, long d, long c)
{
	ASM (
		"imull %%edx\n\t"
		"idivl %%ecx"
		: "+a" (a)		// output eax
		: "d" (d), "c" (c)	// input eax edx ecx
		: "cc"
	);
	return a;
}

/*#pragma aux mulscale =\
	"imul edx",\
	"shrd eax, edx, cl",\
	parm nomemory [eax][edx][ecx]\
	modify exact [eax edx]\ */
long mulscale(long a, long d, long c)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl %%cl, %%edx, %%eax"	// shrd eax, edx, cl
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "c" (c)	// input eax edx ecx
		: "cc"
	);
	return a;
}

/*#pragma aux mulscale1 =\
	"imul edx",\
	"shrd eax, edx, 1",\
	parm nomemory [eax][edx]\
	modify exact [eax edx]\ */
long mulscale1(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $1, %%edx, %%eax"	// shrd eax, edx, 1
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale2(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $2, %%edx, %%eax"	// shrd eax, edx, 2
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale3(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $3, %%edx, %%eax"		// shrd eax, edx, 3
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale4(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $4, %%edx, %%eax"		// shrd eax, edx, 4
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale5(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $5, %%edx, %%eax"		// shrd eax, edx, 5
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale6(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $6, %%edx, %%eax"		// shrd eax, edx, 6
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale7(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $7, %%edx, %%eax"		// shrd eax, edx, 7
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale8(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $8, %%edx, %%eax"		// shrd eax, edx, 8
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale9(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $9, %%edx, %%eax"		// shrd eax, edx, 9
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale10(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $10, %%edx, %%eax"	// shrd eax, edx, 10
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale11(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $11, %%edx, %%eax"	// shrd eax, edx, 11
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale12(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $12, %%edx, %%eax"	// shrd eax, edx, 12
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale13(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $13, %%edx, %%eax"	// shrd eax, edx, 13
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale14(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $14, %%edx, %%eax"	// shrd eax, edx, 14
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale15(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $15, %%edx, %%eax"	// shrd eax, edx, 15
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale16(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $16, %%edx, %%eax"	// shrd eax, edx, 16
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale17(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $17, %%edx, %%eax"	// shrd eax, edx, 17
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale18(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $18, %%edx, %%eax"	// shrd eax, edx, 18
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale19(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $19, %%edx, %%eax"	// shrd eax, edx, 19
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale20(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $20, %%edx, %%eax"	// shrd eax, edx, 20
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale21(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $21, %%edx, %%eax"	// shrd eax, edx, 21
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale22(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $22, %%edx, %%eax"	// shrd eax, edx, 22
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale23(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $23, %%edx, %%eax"	// shrd eax, edx, 23
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale24(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $24, %%edx, %%eax"	// shrd eax, edx, 24
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale25(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $25, %%edx, %%eax"	// shrd eax, edx, 25
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale26(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $26, %%edx, %%eax"	// shrd eax, edx, 26
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale27(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $27, %%edx, %%eax"	// shrd eax, edx, 27
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale28(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $28, %%edx, %%eax"	// shrd eax, edx, 28
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale29(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $29, %%edx, %%eax"	// shrd eax, edx, 29
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale30(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $30, %%edx, %%eax"	// shrd eax, edx, 30
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale31(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		"shrdl $31, %%edx, %%eax"	// shrd eax, edx, 31
		: "=a" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}

long mulscale32(long a, long d)
{
	ASM (
		"imull %%edx\n\t"
		: "=d" (a)			// output eax
		: "a" (a), "d" (d)		// input eax edx
		: "cc"
	);
	return a;
}


/*#pragma aux dmulscale =\
	"imul edx",\
	"mov ebx, eax",\
	"mov eax, esi",\
	"mov esi, edx",\
	"imul edi",\
	"add eax, ebx",\
	"adc edx, esi",\
	"shrd eax, edx, cl",\
	parm nomemory [eax][edx][esi][edi][ecx]\
	modify exact [eax ebx edx esi]\ */
long dmulscale(long a, long d, long S, long D, long c)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl %%cl, %%edx, %%eax"	// shrd eax, edx, cl
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D), "c" (c)
		: "ebx", "cc"
	);
	return a;
}

/*#pragma aux dmulscale1 =\
	"imul edx",\
	"mov ebx, eax",\
	"mov eax, esi",\
	"mov esi, edx",\
	"imul edi",\
	"add eax, ebx",\
	"adc edx, esi",\
	"shrd eax, edx, 1",\
	parm nomemory [eax][edx][esi][edi]\
	modify exact [eax ebx edx esi]\ */
long dmulscale1(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $1, %%edx, %%eax"	// shrd eax, edx, 1
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale2(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $2, %%edx, %%eax"	// shrd eax, edx, 2
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale3(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $3, %%edx, %%eax"	// shrd eax, edx, 3
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale4(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $4, %%edx, %%eax"	// shrd eax, edx, 4
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale5(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $5, %%edx, %%eax"	// shrd eax, edx, 5
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale6(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $6, %%edx, %%eax"		// shrd eax, edx, 6
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale7(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $7, %%edx, %%eax"		// shrd eax, edx, 7
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale8(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $8, %%edx, %%eax"		// shrd eax, edx, 8
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale9(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $9, %%edx, %%eax"		// shrd eax, edx, 9
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale10(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $10, %%edx, %%eax"	// shrd eax, edx, 10
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale11(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $11, %%edx, %%eax"	// shrd eax, edx, 11
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale12(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $12, %%edx, %%eax"	// shrd eax, edx, 12
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale13(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $13, %%edx, %%eax"	// shrd eax, edx, 13
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale14(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $14, %%edx, %%eax"	// shrd eax, edx, 14
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale15(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $15, %%edx, %%eax"	// shrd eax, edx, 15
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale16(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $16, %%edx, %%eax"	// shrd eax, edx, 16
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale17(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $17, %%edx, %%eax"	// shrd eax, edx, 17
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale18(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $18, %%edx, %%eax"	// shrd eax, edx, 18
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale19(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $19, %%edx, %%eax"	// shrd eax, edx, 19
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale20(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $20, %%edx, %%eax"	// shrd eax, edx, 20
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale21(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $21, %%edx, %%eax"	// shrd eax, edx, 21
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale22(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $22, %%edx, %%eax"	// shrd eax, edx, 22
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale23(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $23, %%edx, %%eax"	// shrd eax, edx, 23
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale24(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $24, %%edx, %%eax"	// shrd eax, edx, 24
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale25(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $25, %%edx, %%eax"	// shrd eax, edx, 25
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale26(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $26, %%edx, %%eax"	// shrd eax, edx, 26
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale27(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $27, %%edx, %%eax"	// shrd eax, edx, 27
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale28(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $28, %%edx, %%eax"	// shrd eax, edx, 28
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale29(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $29, %%edx, %%eax"	// shrd eax, edx, 29
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale30(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $30, %%edx, %%eax"	// shrd eax, edx, 30
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale31(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		"shrdl $31, %%edx, %%eax"	// shrd eax, edx, 31
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return a;
}

long dmulscale32(long a, long d, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"movl %%eax, %%ebx\n\t"		// mov ebx, eax
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"movl %%edx, %%esi\n\t"		// mov esi, edx
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// mov eax, ebx
		"adcl %%esi, %%edx\n\t"		// adc edx, esi
		: "=d" (d)			// output edx
		: "a" (a), "d" (d), "S" (S), "D" (D)
		: "ebx", "cc"
	);
	return d;
}


/*#pragma aux tmulscale1 =\
	"imul edx",\
	"xchg eax, ebx",\
	"xchg edx, ecx",\
	"imul edx",\
	"add ebx, eax",\
	"adc ecx, edx",\
	"mov eax, esi",\
	"imul edi",\
	"add eax, ebx",\
	"adc edx, ecx",\
	"shrd eax, edx, 1",\
	parm nomemory [eax][edx][ebx][ecx][esi][edi]\
	modify exact [eax ebx ecx edx]\ */
long tmulscale1(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $1, %%edx, %%eax"	// shrd eax, edx, 1
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale2(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $2, %%edx, %%eax"	// shrd eax, edx, 2
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale3(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $3, %%edx, %%eax"	// shrd eax, edx, 3
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale4(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $4, %%edx, %%eax"	// shrd eax, edx, 4
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale5(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $5, %%edx, %%eax"	// shrd eax, edx, 5
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale6(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $6, %%edx, %%eax"	// shrd eax, edx, 6
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale7(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $7, %%edx, %%eax"	// shrd eax, edx, 7
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale8(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $8, %%edx, %%eax"	// shrd eax, edx, 8
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale9(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $9, %%edx, %%eax"	// shrd eax, edx, 9
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale10(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $10, %%edx, %%eax"	// shrd eax, edx, 10
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale11(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $11, %%edx, %%eax"	// shrd eax, edx, 11
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale12(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $12, %%edx, %%eax"	// shrd eax, edx, 12
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale13(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $13, %%edx, %%eax"	// shrd eax, edx, 13
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale14(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $14, %%edx, %%eax"	// shrd eax, edx, 14
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale15(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $15, %%edx, %%eax"	// shrd eax, edx, 15
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale16(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $16, %%edx, %%eax"	// shrd eax, edx, 16
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale17(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $17, %%edx, %%eax"	// shrd eax, edx, 17
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale18(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $18, %%edx, %%eax"	// shrd eax, edx, 18
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale19(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $19, %%edx, %%eax"	// shrd eax, edx, 19
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale20(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $20, %%edx, %%eax"	// shrd eax, edx, 20
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale21(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $21, %%edx, %%eax"	// shrd eax, edx, 21
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale22(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $22, %%edx, %%eax"	// shrd eax, edx, 22
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale23(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $23, %%edx, %%eax"	// shrd eax, edx, 23
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale24(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $24, %%edx, %%eax"	// shrd eax, edx, 24
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale25(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $25, %%edx, %%eax"	// shrd eax, edx, 25
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale26(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $26, %%edx, %%eax"	// shrd eax, edx, 26
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale27(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $27, %%edx, %%eax"	// shrd eax, edx, 27
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale28(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $28, %%edx, %%eax"	// shrd eax, edx, 28
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale29(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $29, %%edx, %%eax"	// shrd eax, edx, 29
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale30(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $30, %%edx, %%eax"	// shrd eax, edx, 30
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale31(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		"shrdl $31, %%edx, %%eax"	// shrd eax, edx, 31
		: "=a" (a)			// output eax
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return a;
}

long tmulscale32(long a, long d, long b, long c, long S, long D)
{
	ASM (
		"imull %%edx\n\t"
		"xchgl %%ebx, %%eax\n\t"	// xchg eax, ebx
		"xchgl %%ecx, %%edx\n\t"	// xchg edx, ecx
		"imull %%edx\n\t"
		"addl %%eax, %%ebx\n\t"		// add ebx, eax
		"adcl %%edx, %%ecx\n\t"		// adc ecx, edx
		"movl %%esi, %%eax\n\t"		// mov eax, esi
		"imull %%edi\n\t"
		"addl %%ebx, %%eax\n\t"		// add eax, ebx
		"adcl %%ecx, %%edx\n\t"		// adc edx, ecx
		: "=d" (d)			// output edx
		: "a" (a), "d" (d), "b" (b), "c" (c), "S" (S), "D" (D)
		: "cc"
	);
	return d;
}


/*#pragma aux divscale =\
	"mov edx, eax",\
	"shl eax, cl",\
	"neg cl",\
	"sar edx, cl",\
	"idiv ebx",\
	parm nomemory [eax][ebx][ecx]\
	modify exact [eax ecx edx]\ */
long divscale(long a, long b, long c)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"shll %%cl, %%eax\n\t"		// shl eax, cl
		"negb %%cl\n\t"
		"sarl %%cl, %%edx\n\t"		// sar edx, cl
		"idivl %%ebx"
		: "=a" (a)			// output eax
		: "a" (a), "b" (b), "c" (c)	// input eax ebx ecx
		: "edx", "cc"
	);
	return a;
}


/*#pragma aux divscale1 =\
	"add eax, eax",\
	"sbb edx, edx",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale1(long a, long b)
{
	ASM (
		"addl %%eax, %%eax\n\t"
		"sbbl %%edx, %%edx\n\t"
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale2 =\
	"mov edx, eax",\
	"sar edx, 30",\
	"lea eax, [eax*4]",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale2(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $30, %%edx\n\t"		// sar edx, 30
		"leal (,%%eax,4), %%eax\n\t"	// lea eax, [eax*4]
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale3 =\
	"mov edx, eax",\
	"sar edx, 29",\
	"lea eax, [eax*8]",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale3(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $29, %%edx\n\t"		// sar edx, 29
		"leal (,%%eax,8), %%eax\n\t"	// lea eax, [eax*8]
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale4 =\
	"mov edx, eax",\
	"sar edx, 28",\
	"shl eax, 4",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale4(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $28, %%edx\n\t"		// sar edx, 28
		"shll $4, %%eax\n\t"		// shl eax, 4
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale5 =\
	"mov edx, eax",\
	"sar edx, 27",\
	"shl eax, 5",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale5(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $27, %%edx\n\t"		// sar edx, 27
		"shll $5, %%eax\n\t"		// shl eax, 5
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale6 =\
	"mov edx, eax",\
	"sar edx, 26",\
	"shl eax, 6",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale6(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $26, %%edx\n\t"		// sar edx, 26
		"shll $6, %%eax\n\t"		// shl eax, 6
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale7 =\
	"mov edx, eax",\
	"sar edx, 25",\
	"shl eax, 7",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale7(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $25, %%edx\n\t"		// sar edx, 25
		"shll $7, %%eax\n\t"		// shl eax, 7
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale8 =\
	"mov edx, eax",\
	"sar edx, 24",\
	"shl eax, 8",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale8(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $24, %%edx\n\t"		// sar edx, 24
		"shll $8, %%eax\n\t"		// shl eax, 8
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale9 =\
	"mov edx, eax",\
	"sar edx, 23",\
	"shl eax, 9",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale9(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $23, %%edx\n\t"		// sar edx, 23
		"shll $9, %%eax\n\t"		// shl eax, 9
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale10 =\
	"mov edx, eax",\
	"sar edx, 22",\
	"shl eax, 10",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale10(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $22, %%edx\n\t"		// sar edx, 22
		"shll $10, %%eax\n\t"		// shl eax, 10
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale11 =\
	"mov edx, eax",\
	"sar edx, 21",\
	"shl eax, 11",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale11(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $21, %%edx\n\t"		// sar edx, 21
		"shll $11, %%eax\n\t"		// shl eax, 11
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale12 =\
	"mov edx, eax",\
	"sar edx, 20",\
	"shl eax, 12",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale12(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $20, %%edx\n\t"		// sar edx, 20
		"shll $12, %%eax\n\t"		// shl eax, 12
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale13 =\
	"mov edx, eax",\
	"sar edx, 19",\
	"shl eax, 13",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale13(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $19, %%edx\n\t"		// sar edx, 19
		"shll $13, %%eax\n\t"		// shl eax, 13
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale14 =\
	"mov edx, eax",\
	"sar edx, 18",\
	"shl eax, 14",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale14(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $18, %%edx\n\t"		// sar edx, 18
		"shll $14, %%eax\n\t"		// shl eax, 14
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale15 =\
	"mov edx, eax",\
	"sar edx, 17",\
	"shl eax, 15",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale15(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $17, %%edx\n\t"		// sar edx, 17
		"shll $15, %%eax\n\t"		// shl eax, 15
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale16 =\
	"mov edx, eax",\
	"sar edx, 16",\
	"shl eax, 16",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale16(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $16, %%edx\n\t"		// sar edx, 16
		"shll $16, %%eax\n\t"		// shl eax, 16
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale17 =\
	"mov edx, eax",\
	"sar edx, 15",\
	"shl eax, 17",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale17(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $15, %%edx\n\t"		// sar edx, 15
		"shll $17, %%eax\n\t"		// shl eax, 17
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale18 =\
	"mov edx, eax",\
	"sar edx, 14",\
	"shl eax, 18",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale18(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $14, %%edx\n\t"		// sar edx, 14
		"shll $18, %%eax\n\t"		// shl eax, 18
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale19 =\
	"mov edx, eax",\
	"sar edx, 13",\
	"shl eax, 19",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale19(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $13, %%edx\n\t"		// sar edx, 13
		"shll $19, %%eax\n\t"		// shl eax, 19
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale20 =\
	"mov edx, eax",\
	"sar edx, 12",\
	"shl eax, 20",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale20(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $12, %%edx\n\t"		// sar edx, 12
		"shll $20, %%eax\n\t"		// shl eax, 20
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale21 =\
	"mov edx, eax",\
	"sar edx, 11",\
	"shl eax, 21",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale21(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $11, %%edx\n\t"		// sar edx, 11
		"shll $21, %%eax\n\t"		// shl eax, 21
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale22 =\
	"mov edx, eax",\
	"sar edx, 10",\
	"shl eax, 22",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale22(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $10, %%edx\n\t"		// sar edx, 10
		"shll $22, %%eax\n\t"		// shl eax, 22
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale23 =\
	"mov edx, eax",\
	"sar edx, 9",\
	"shl eax, 23",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale23(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $9, %%edx\n\t"		// sar edx, 9
		"shll $23, %%eax\n\t"		// shl eax, 23
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale24 =\
	"mov edx, eax",\
	"sar edx, 8",\
	"shl eax, 24",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale24(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $8, %%edx\n\t"		// sar edx, 8
		"shll $24, %%eax\n\t"		// shl eax, 24
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale25 =\
	"mov edx, eax",\
	"sar edx, 7",\
	"shl eax, 25",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale25(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $7, %%edx\n\t"		// sar edx, 7
		"shll $25, %%eax\n\t"		// shl eax, 25
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale26 =\
	"mov edx, eax",\
	"sar edx, 6",\
	"shl eax, 26",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale26(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $6, %%edx\n\t"		// sar edx, 6
		"shll $26, %%eax\n\t"		// shl eax, 26
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}


/*#pragma aux divscale27 =\
	"mov edx, eax",\
	"sar edx, 5",\
	"shl eax, 27",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale27(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $5, %%edx\n\t"		// sar edx, 5
		"shll $27, %%eax\n\t"		// shl eax, 27
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale28 =\
	"mov edx, eax",\
	"sar edx, 4",\
	"shl eax, 28",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale28(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $4, %%edx\n\t"		// sar edx, 4
		"shll $28, %%eax\n\t"		// shl eax, 28
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale29 =\
	"mov edx, eax",\
	"sar edx, 3",\
	"shl eax, 29",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale29(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $3, %%edx\n\t"		// sar edx, 3
		"shll $29, %%eax\n\t"		// shl eax, 29
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale30 =\
	"mov edx, eax",\
	"sar edx, 2",\
	"shl eax, 30",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale30(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $2, %%edx\n\t"		// sar edx, 2
		"shll $30, %%eax\n\t"		// shl eax, 30
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale31 =\
	"mov edx, eax",\
	"sar edx, 1",\
	"shl eax, 31",\
	"idiv ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\ */
long divscale31(long a, long b)
{
	ASM (
		"movl %%eax, %%edx\n\t"		// mov edx, eax
		"sarl $1, %%edx\n\t"		// sar edx, 1
		"shll $31, %%eax\n\t"		// shl eax, 31
		"idivl %%ebx"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "cc"
	);
	return a;
}

/*#pragma aux divscale32 =\
	"xor eax, eax",\
	"idiv ebx",\
	parm nomemory [edx][ebx]\
	modify exact [eax edx]\ */
long divscale32(long d, long b)
{
	ASM (
		"xorl %%eax, %%eax\n\t"		// xor eax, eax
		"idivl %%ebx"
		: "=a" (d)
		: "d" (d), "b" (b)
		: "cc"
	);
	return d;
}


/*#pragma aux readpixel =\
	"mov al, byte ptr [edi]",\
	parm nomemory [edi]\
	modify exact [eax]\ */
long readpixel(void *D)
{
	long a;
	ASM (
		"movb (%%edi), %%al"
		: "=a" (a)
		: "D" (D)
		: "cc"
	);
	return a;
}

/*#pragma aux drawpixel =\
	"mov byte ptr [edi], al",\
	parm [edi][eax]\
	modify exact \ */
void drawpixel(void *D, long a)
{
	ASM (
		"movb %%al, (%%edi)"
		: : "D" (D), "a" (a)
		: "memory", "cc"
	);
}

/*#pragma aux drawpixels =\
	"mov word ptr [edi], ax",\
	parm [edi][eax]\
	modify exact \ */
void drawpixels(void *D, long a)
{
	ASM (
		"movw %%ax, (%%edi)"
		: : "D" (D), "a" (a)
		: "memory", "cc"
	);
}

/*#pragma aux drawpixelses =\
	"mov dword ptr [edi], eax",\
	parm [edi][eax]\
	modify exact \ */
void drawpixelses(void *D, long a)
{
	ASM (
		"movl %%eax, (%%edi)"
		: : "D" (D), "a" (a)
		: "memory", "cc"
	);
}

/*#pragma aux clearbuf =\
	"rep stosd",\
	parm [edi][ecx][eax]\
	modify exact [edi ecx]\ */
void clearbuf(void* D, long c, long a)
{
	ASM (
		"rep\n\t"
		"stosl"
		: : "D" (D), "c" (c), "a" (a)
		: "memory", "cc"
	);
}


/*#pragma aux copybuf =\
	"rep movsd",\
	parm [esi][edi][ecx]\
	modify exact [ecx esi edi]\ */
void copybuf(void *S, void *D, long c)
{
	ASM (
		"rep\n\t"
		"movsl"
		: : "S" (S), "D" (D), "c" (c)
		: "memory", "cc"
	);
}


/*#pragma aux mul3 =\
	"lea eax, [eax+eax*2]",\
	parm nomemory [eax]\ */
long mul3(long a)
{
	ASM (
		"lea (%1,%1,2), %0"
		: "=r" (a)
		: "0" (a)
		: "cc"
	);
	return a;
}

/*#pragma aux mul5 =\
	"lea eax, [eax+eax*4]",\
	parm nomemory [eax]\ */
long mul5(long a)
{
	ASM (
		"lea (%1,%1,4), %0"
		: "=r" (a)
		: "0" (a)
		: "cc"
	);
	return a;
}

/*#pragma aux mul9 =\
	"lea eax, [eax+eax*8]",\
	parm nomemory [eax]\ */
long mul9(long a)
{
	ASM (
		"lea (%1,%1,8), %0"
		: "=r" (a)
		: "0" (a)
		: "cc"
	);
	return a;
}

	//returns eax/ebx, dmval = eax%edx;
/*#pragma aux divmod =\
	"xor edx, edx",\
	"div ebx",\
	"mov dmval, edx",\
	parm [eax][ebx]\
	modify exact [eax edx]\
	value [eax] */
long divmod(long a, long b)
{
	ASM (
		"xorl %%edx, %%edx\n\t"
		"divl %%ebx\n\t"
		"movl %%edx, "_DMVAL
		: "=a" (a)
		: "a" (a), "b" (b)
		: "edx", "memory", "cc"
	);
	return a;
}

	//returns eax%ebx, dmval = eax/edx;
/*#pragma aux moddiv =\
	"xor edx, edx",\
	"div ebx",\
	"mov dmval, eax",\
	parm [eax][ebx]\
	modify exact [eax edx]\
	value [edx] */
long moddiv(long a, long b)
{
	ASM (
		"xorl %%edx, %%edx\n\t"
		"divl %%ebx\n\t"
		"movl %%eax, "_DMVAL
		: "=d" (a)
		: "a" (a), "b" (b)
		: "memory", "cc"
	);
	return a;
}


/*#pragma aux klabs =\
	"test eax, eax",\
	"jns skipnegate",\
	"neg eax",\
	"skipnegate:",\
	parm nomemory [eax]\ */
long klabs(long a)
{
	ASM (
		"testl %%eax, %%eax\n\t"
		"jns 0f\n\t"
		"negl %%eax\n\t"
		"0:"
		: "=a" (a)
		: "a" (a)
		: "cc"
	);
	return a;
}


/*#pragma aux ksgn =\
	"add ebx, ebx",\
	"sbb eax, eax",\
	"cmp eax, ebx",\
	"adc al, 0",\
	parm nomemory [ebx]\
	modify exact [eax ebx]\ */
long ksgn(long b)
{
	ASM (
		"addl %%ebx, %%ebx\n\t"
		"sbbl %%eax, %%eax\n\t"
		"cmpl %%ebx, %%eax\n\t"
		"adcb $0, %%al"
		: "=a" (b)
		: "b" (b)
		: "cc"
	);
	return b;
}

	//eax = (unsigned min)umin(eax,ebx)
/*#pragma aux umin =\
	"sub eax, ebx",\
	"sbb ecx, ecx",\
	"and eax, ecx",\
	"add eax, ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax ecx]\ */
long umin(long a, long b)
{
	ASM (
		"subl %%ebx, %%eax\n\t"
		"sbbl %%ecx, %%ecx\n\t"
		"andl %%ecx, %%eax\n\t"
		"addl %%ebx, %%eax"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "ecx", "cc"
	);
	return a;
}

	//eax = (unsigned max)umax(eax,ebx)
/*#pragma aux umax =\
	"sub eax, ebx",\
	"sbb ecx, ecx",\
	"xor ecx, 0xffffffff",\
	"and eax, ecx",\
	"add eax, ebx",\
	parm nomemory [eax][ebx]\
	modify exact [eax ecx]\ */
long umax(long a, long b)
{
	ASM (
		"subl %%ebx, %%eax\n\t"
		"sbbl %%ecx, %%ecx\n\t"
		"xorl $0xffffffff, %%ecx\n\t"
		"andl %%ecx, %%eax\n\t"
		"addl %%ebx, %%eax"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "ecx", "cc"
	);
	return a;
}

/*#pragma aux kmin =\
	"cmp eax, ebx",\
	"jl skipit",\
	"mov eax, ebx",\
	"skipit:",\
	parm nomemory [eax][ebx]\
	modify exact [eax]\ */
long kmin(long a, long b)
{
	ASM (
		"cmpl %%ebx, %%eax\n\t"
		"jl 0f\n\t"
		"movl %%ebx, %%eax\n\t"
		"0:"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "cc"
	);
	return a;
}

/*#pragma aux kmax =\
	"cmp eax, ebx",\
	"jg skipit",\
	"mov eax, ebx",\
	"skipit:",\
	parm nomemory [eax][ebx]\
	modify exact [eax]\ */
long kmax(long a, long b)
{
	ASM (
		"cmpl %%ebx, %%eax\n\t"
		"jg 0f\n\t"
		"movl %%ebx, %%eax\n\t"
		"0:"
		: "=a" (a)
		: "a" (a), "b" (b)
		: "cc"
	);
	return a;
}

/*#pragma aux swapchar =\
	"mov cl, [eax]",\
	"mov ch, [ebx]",\
	"mov [ebx], cl",\
	"mov [eax], ch",\
	parm [eax][ebx]\
	modify exact [ecx]\ */
void swapchar(void *a, void *b)
{
	ASM (
		"movb (%%eax), %%cl\n\t"
		"movb (%%ebx), %%ch\n\t"
		"movb %%cl, (%%ebx)\n\t"
		"movb %%ch, (%%eax)"
		: : "a" (a), "b" (b)
		: "ecx", "memory", "cc"
	);
}

/*#pragma aux swapshort =\
	"mov cx, [eax]",\
	"mov dx, [ebx]",\
	"mov [ebx], cx",\
	"mov [eax], dx",\
	parm [eax][ebx]\
	modify exact [ecx edx]\ */
void swapshort(void *a, void *b)
{
	ASM (
		"movw (%%eax), %%cx\n\t"
		"movw (%%ebx), %%dx\n\t"
		"movw %%cx, (%%ebx)\n\t"
		"movw %%dx, (%%eax)"
		: : "a" (a), "b" (b)
		: "ecx", "edx", "memory", "cc"
	);
}

/*#pragma aux swaplong =\
	"mov ecx, [eax]",\
	"mov edx, [ebx]",\
	"mov [ebx], ecx",\
	"mov [eax], edx",\
	parm [eax][ebx]\
	modify exact [ecx edx]\ */
void swaplong(void *a, void *b)
{
	ASM (
		"movl (%%eax), %%ecx\n\t"
		"movl (%%ebx), %%edx\n\t"
		"movl %%ecx, (%%ebx)\n\t"
		"movl %%edx, (%%eax)"
		: : "a" (a), "b" (b)
		: "ecx", "edx", "memory", "cc"
	);
}


/*#pragma aux swapbuf4 =\
	"begswap:",\
	"mov esi, [eax]",\
	"mov edi, [ebx]",\
	"mov [ebx], esi",\
	"mov [eax], edi",\
	"add eax, 4",\
	"add ebx, 4",\
	"dec ecx",\
	"jnz short begswap",\
	parm [eax][ebx][ecx]\
	modify exact [eax ebx ecx esi edi]\ */
void swapbuf4(void *a, void *b, long c)
{
	ASM (
		"0:\n\t"		// begswap:
		"movl (%%eax), %%esi\n\t"
		"movl (%%ebx), %%edi\n\t"
		"movl %%esi, (%%ebx)\n\t"
		"movl %%edi, (%%eax)\n\t"
		"addl $4, %%eax\n\t"
		"addl $4, %%ebx\n\t"
		"decl %%ecx\n\t"
		"jnz 0b\n\t"		// jnz begswap
		: : "a" (a), "b" (b), "c" (c)
		: "esi", "edi", "memory", "cc"
	);
}


/*#pragma aux swap64bit =\
	"mov ecx, [eax]",\
	"mov edx, [ebx]",\
	"mov [ebx], ecx",\
	"mov ecx, [eax+4]",\
	"mov [eax], edx",\
	"mov edx, [ebx+4]",\
	"mov [ebx+4], ecx",\
	"mov [eax+4], edx",\
	parm [eax][ebx]\
	modify exact [ecx edx]\ */
void swap64bit(void *a, void *b)
{
	ASM (
		"movl (%%eax), %%ecx\n\t"
		"movl (%%ebx), %%edx\n\t"
		"movl %%ecx, (%%ebx)\n\t"
		"movl 4(%%eax), %%ecx\n\t"
		"movl %%edx, (%%eax)\n\t"
		"movl 4(%%ebx), %%edx\n\t"
		"movl %%ecx, 4(%%ebx)\n\t"
		"movl %%edx, 4(%%eax)"
		: : "a" (a), "b" (b)
		: "ecx", "edx", "memory", "cc"
	);
}

	//swapchar2(ptr1,ptr2,xsiz); is the same as:
	//swapchar(ptr1,ptr2); swapchar(ptr1+1,ptr2+xsiz);
/*#pragma aux swapchar2 =\
	"add esi, ebx",\
	"mov cx, [eax]",\
	"mov dl, [ebx]",\
	"mov [ebx], cl",\
	"mov dh, [esi]",\
	"mov [esi], ch",\
	"mov [eax], dx",\
	parm [eax][ebx][esi]\
	modify exact [ecx edx esi]\ */
void swapchar2(void *a, void *b, long S)
{
	ASM (
		"addl %%ebx, %%esi\n\t"
		"movw (%%eax), %%cx\n\t"
		"movb (%%ebx), %%dl\n\t"
		"movb %%cl, (%%ebx)\n\t"
		"movb (%%esi), %%dh\n\t"
		"movb %%ch, (%%esi)\n\t"
		"movw %%dx, (%%eax)"
		: : "a" (a), "b" (b), "S" (S)
		: "ecx", "edx", "memory", "cc"
	);
}


void qinterpolatedown16(long a, long c, long d, long S)
{
	ASM (
		"movl %%ecx, %%ebx\n\t"
		"shrl $1, %%ecx\n\t"
		"jz 1f\n\t"		// jz skipbegcalc
		"0:\n\t"		// begqcalc:
		"leal (%%edx,%%esi,), %%edi\n\t"
		"sarl $16, %%edx\n\t"
		"movl %%edx, (%%eax)\n\t"
		"leal (%%edi,%%esi,), %%edx\n\t"
		"sarl $16, %%edi\n\t"
		"movl %%edi, 4(%%eax)\n\t"
		"addl $8, %%eax\n\t"
		"decl %%ecx\n\t"
		"jnz 0b\n\t"		// jnz begqcalc
		"testl $1, %%ebx\n\t"
		"jz 2f\n\t"		// jz skipbegqcalc2
		"1:\n\t"		// skipbegcalc:
		"sarl $16, %%edx\n\t"
		"movl %%edx, (%%eax)\n\t"
		"2:"			// skipbegcalc2:
		: : "a" (a), "c" (c), "d" (d), "S" (S)
		: "ebx", "edi", "memory", "cc"
	);
}

void qinterpolatedown16short(long a, long c, long d, long S)
{
	ASM (
		"testl %%ecx, %%ecx\n\t"
		"jz 3f\n\t"
		"testb $2, %%al\n\t"
		"jz 0f\n\t"			// jz skipalignit
		"movl %%edx, %%ebx\n\t"
		"sarl $16, %%ebx\n\t"
		"movw %%bx, (%%eax)\n\t"
		"addl %%esi, %%edx\n\t"
		"addl $2, %%eax\n\t"
		"decl %%ecx\n\t"
		"jz 3f\n\t"
		"0:\n\t"			// skipalignit:
		"subl $2, %%ecx\n\t"
		"jc 2f\n\t"			// jc finishit
		"1:\n\t"			// begqcalc:
		"movl %%edx, %%ebx\n\t"
		"addl %%esi, %%edx\n\t"
		"sarl $16, %%ebx\n\t"
		"movl %%edx, %%edi\n\t"
		"andl $0xffff0000, %%edi\n\t"
		"addl %%esi, %%edx\n\t"
		"addl %%edi, %%ebx\n\t"
		"movl %%ebx, (%%eax)\n\t"
		"addl $4, %%eax\n\t"
		"subl $2, %%ecx\n\t"
		"jnc 1b\n\t"			// jnc begqcalc
		"testb $1, %%cl\n\t"
		"jz 3f\n\t"			// jz endit
		"2:\n\t"			// finishit:
		"movl %%edx, %%ebx\n\t"
		"sarl $16, %%ebx\n\t"
		"movw %%bx, (%%eax)\n\t"
		"3:"				// endit:
		: : "a" (a), "c" (c), "d" (d), "S" (S)
		: "ebx", "edi", "memory", "cc"
	);
}

