#include "mmulti.h"
#include <stdio.h>
#include <stdarg.h>

#undef main

int mode = 0;

void OSD_Printf(const char *fmt, ...)
{
	va_list va;
	char buf[1000];

	va_start(va,fmt);
	vsnprintf(buf,1000,fmt,va);
	va_end(va);

	puts(buf);
}

long totalclock=0;

int main(int argc, char **argv)
{
	short len, other;
	char buf[2048];
	
	puts("testmulti started");

	ipport = 10002;
	if (argc>=2) {
		if (!strcmp(argv[1], "listen")) {
			ipport = 10001;
			mode = 1;
		}
	}

	initmultiplayers(1,0,0);
	multiaddplayer("localhost:10001");	// listener
	multiaddplayer("localhost:10002");	// sender

	if (mode == 0) {
		puts("sender mode");
	
		puts("Sending \"Test\"");
		totalclock = 0;
		sendpacket(0,"Test",4);

		puts("Getting...");
		len = getpacket(&other,buf);
	
		puts("Sending \"This\"");
		totalclock = 1;
		sendpacket(0,"This",4);

		puts("Getting...");
		len = getpacket(&other,buf);
		
		puts("Sending \"Well\"");
		totalclock = 2;
		sendpacket(0,"Well",4);

		puts("Getting...");
		len = getpacket(&other,buf);
		
	} else {
		puts("listener mode");

		while (1) {
			len = getpacket(&other,buf);
			if (len>0) {
				buf[len] = 0;
				printf("Got %d bytes from %d: %s\n", len, other, buf);
			}
		}
	}
	
	multidumpstats();
	uninitmultiplayers();

	return 0;
}

