// Base services interface declaration
// for the Build Engine
// by Jonathon Fowler (jonof@edgenetwk.com)

#ifndef __baselayer_h__
#define __baselayer_h__

// video
extern long xres, yres, fullscreen, bytesperline, imageSize, frameplace;
extern char offscreenrendering;

extern char inputdevices;

// keys
#define KEYFIFOSIZ 64
extern char keystatus[256], keyfifo[KEYFIFOSIZ], keyfifoplc, keyfifoend;

// mouse
extern short mousex, mousey, mouseb;

extern char quitevent, appactive;


int initsystem(void);
void uninitsystem(void);

int handleevents(void);

typedef void (*KeyPressCallback)(long,long);
typedef void (*MousePressCallback)(long,long);
int initinput(void);
void uninitinput(void);
void setkeypresscallback(void (*callback)(long,long));
void setmousepresscallback(void (*callback)(long,long));

int initmouse(void);
void uninitmouse(void);
void grabmouse(char a);
void readmousexy(short *x, short *y);
void readmousebstatus(short *b);

int inittimer(int);
void uninittimer(void);
void sampletimer(void);
unsigned long getticks(void);
void (*installusertimercallback(void (*callback)(void)))(void);

int checkvideomode(long *x, long *y, int fs);
int setvideomode(int x, int y, int fs);
void getvalidmodes(void);

void begindrawing(void);
void enddrawing(void);
void showframe(int);

int setpalette(int start, int num, char *dapal);
int getpalette(int start, int num, char *dapal);


#endif // __baselayer_h__

