// Assembly-language function wrappers for a.asm functions
// for the Build Engine
// by Jonathon Fowler (jonof@edgenetwk.com)


#ifndef __a_h__
#define __a_h__

#if defined(USE_WATCOM_ASSEMBLY)

extern long mmxoverlay();
#pragma aux mmxoverlay modify [eax ebx ecx edx];
extern long sethlinesizes(long,long,long);
#pragma aux sethlinesizes parm [eax][ebx][ecx];
extern long setpalookupaddress(char *);
#pragma aux setpalookupaddress parm [eax];
extern long setuphlineasm4(long,long);
#pragma aux setuphlineasm4 parm [eax][ebx];
extern long hlineasm4(long,long,long,long,long,long);
#pragma aux hlineasm4 parm [eax][ebx][ecx][edx][esi][edi];
extern long setuprhlineasm4(long,long,long,long,long,long);
#pragma aux setuprhlineasm4 parm [eax][ebx][ecx][edx][esi][edi];
extern long rhlineasm4(long,long,long,long,long,long);
#pragma aux rhlineasm4 parm [eax][ebx][ecx][edx][esi][edi];
extern long setuprmhlineasm4(long,long,long,long,long,long);
#pragma aux setuprmhlineasm4 parm [eax][ebx][ecx][edx][esi][edi];
extern long rmhlineasm4(long,long,long,long,long,long);
#pragma aux rmhlineasm4 parm [eax][ebx][ecx][edx][esi][edi];
extern long setupqrhlineasm4(long,long,long,long,long,long);
#pragma aux setupqrhlineasm4 parm [eax][ebx][ecx][edx][esi][edi];
extern long qrhlineasm4(long,long,long,long,long,long);
#pragma aux qrhlineasm4 parm [eax][ebx][ecx][edx][esi][edi];
extern long setvlinebpl(long);
#pragma aux setvlinebpl parm [eax];
extern long fixtransluscence(long);
#pragma aux fixtransluscence parm [eax];
extern long prevlineasm1(long,long,long,long,long,long);
#pragma aux prevlineasm1 parm [eax][ebx][ecx][edx][esi][edi];
extern long vlineasm1(long,long,long,long,long,long);
#pragma aux vlineasm1 parm [eax][ebx][ecx][edx][esi][edi];
extern long setuptvlineasm(long);
#pragma aux setuptvlineasm parm [eax];
extern long tvlineasm1(long,long,long,long,long,long);
#pragma aux tvlineasm1 parm [eax][ebx][ecx][edx][esi][edi];
extern long setuptvlineasm2(long,long,long);
#pragma aux setuptvlineasm2 parm [eax][ebx][ecx];
extern long tvlineasm2(long,long,long,long,long,long);
#pragma aux tvlineasm2 parm [eax][ebx][ecx][edx][esi][edi];
extern long mvlineasm1(long,long,long,long,long,long);
#pragma aux mvlineasm1 parm [eax][ebx][ecx][edx][esi][edi];
extern long setupvlineasm(long);
#pragma aux setupvlineasm parm [eax];
extern long vlineasm4(long,long);
#pragma aux vlineasm4 parm [ecx][edi] modify [eax ebx ecx edx esi edi];
extern long setupmvlineasm(long);
#pragma aux setupmvlineasm parm [eax];
extern long mvlineasm4(long,long);
#pragma aux mvlineasm4 parm [ecx][edi] modify [eax ebx ecx edx esi edi];
extern void setupspritevline(long,long,long,long,long,long);
#pragma aux setupspritevline parm [eax][ebx][ecx][edx][esi][edi];
extern void spritevline(long,long,long,long,long,long);
#pragma aux spritevline parm [eax][ebx][ecx][edx][esi][edi];
extern void msetupspritevline(long,long,long,long,long,long);
#pragma aux msetupspritevline parm [eax][ebx][ecx][edx][esi][edi];
extern void mspritevline(long,long,long,long,long,long);
#pragma aux mspritevline parm [eax][ebx][ecx][edx][esi][edi];
extern void tsetupspritevline(long,long,long,long,long,long);
#pragma aux tsetupspritevline parm [eax][ebx][ecx][edx][esi][edi];
extern void tspritevline(long,long,long,long,long,long);
#pragma aux tspritevline parm [eax][ebx][ecx][edx][esi][edi];
extern long mhline(long,long,long,long,long,long);
#pragma aux mhline parm [eax][ebx][ecx][edx][esi][edi];
extern long mhlineskipmodify(long,long,long,long,long,long);
#pragma aux mhlineskipmodify parm [eax][ebx][ecx][edx][esi][edi];
extern long msethlineshift(long,long);
#pragma aux msethlineshift parm [eax][ebx];
extern long thline(long,long,long,long,long,long);
#pragma aux thline parm [eax][ebx][ecx][edx][esi][edi];
extern long thlineskipmodify(long,long,long,long,long,long);
#pragma aux thlineskipmodify parm [eax][ebx][ecx][edx][esi][edi];
extern long tsethlineshift(long,long);
#pragma aux tsethlineshift parm [eax][ebx];
extern long setupslopevlin(long,long,long);
#pragma aux setupslopevlin parm [eax][ebx][ecx] modify [edx];
extern long slopevlin(long,long,long,long,long,long);
#pragma aux slopevlin parm [eax][ebx][ecx][edx][esi][edi];
extern long settransnormal();
#pragma aux settransnormal parm;
extern long settransreverse();
#pragma aux settransreverse parm;
extern long setupdrawslab(long,long);
#pragma aux setupdrawslab parm [eax][ebx];
extern long drawslab(long,long,long,long,long,long);
#pragma aux drawslab parm [eax][ebx][ecx][edx][esi][edi];

#elif defined(USE_GCC_ASSEMBLY)	// USE_WATCOM_ASSEMBLY

#define ASM __asm__ __volatile__

#ifdef UNDERSCORES
#  define PF "_a_"
#else
#  define PF "a_"
#endif

#ifdef ENGINE
#  define EXTERN
#else
#  define EXTERN extern
#endif

#define TMPL(n) static inline long n
#define TMPLV(n) static inline void n
#define BEGIN	{ long r;
#define END	return r; }
#define BEGINV	{
#define ENDV	}
#define CALL "call "PF
#define RAX "=a" (r)

#define PAX "a" (a)
#define PBX "b" (b)
#define PCX "c" (c)
#define PDX "d" (d)
#define PSI "S" (S)
#define PDI "D" (D)

#define AX "eax"
#define BX "ebx"
#define CX "ecx"
#define DX "edx"
#define SI "esi"
#define DI "edi"
#define MEM "memory"
#define CC "cc"


TMPLV(mmxoverlay)(void)
BEGINV
	ASM (CALL "mmxoverlay": : : AX,BX,CX,DX,MEM,CC );
ENDV

TMPLV(sethlinesizes)(long a, long b, long c)
BEGINV
	ASM (CALL "sethlinesizes": : PAX,PBX,PCX : DX,MEM,CC );
ENDV

TMPLV(setpalookupaddress)(void *a)
BEGINV
	ASM (CALL "setpalookupaddress": : PAX : MEM,CC );
ENDV

TMPLV(setuphlineasm4)(long a, long b)
BEGINV
	ASM (CALL "setuphlineasm4": : PAX,PBX : MEM,CC );
ENDV

TMPLV(hlineasm4)(long a, long b, long c, long d, long S, long D)
BEGINV
	ASM (CALL "hlineasm4": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
ENDV

TMPLV(setuprhlineasm4)(long a, long b, long c, long d, long S, long D)
BEGINV
	ASM (CALL "setuprhlineasm4": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
ENDV

TMPLV(rhlineasm4)(long a, long b, long c, long d, long S, long D)
BEGINV
	ASM (CALL "rhlineasm4": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
ENDV

TMPLV(setuprmhlineasm4)(long a, long b, long c, long d, long S, long D)
BEGINV
	ASM (CALL "setuprmhlineasm4": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
ENDV

TMPLV(rmhlineasm4)(long a, long b, long c, long d, long S, long D)
BEGINV
	ASM (CALL "rmhlineasm4": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
ENDV

TMPLV(setupqrhlineasm4)(long a, long b, long c, long d, long S, long D)
BEGINV
	ASM (CALL "setupqrhlineasm4": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
ENDV

TMPLV(qrhlineasm4)(long a, long b, long c, long d, long S, long D)
BEGINV
	ASM (CALL "qrhlineasm4": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
ENDV

TMPLV(setvlinebpl)(long a)
BEGINV
	ASM (CALL "setvlinebpl": : PAX : MEM,CC );
ENDV

TMPLV(fixtransluscence)(long a)
BEGINV
	ASM (CALL "fixtransluscence": : PAX : MEM,CC );
ENDV

TMPL(prevlineasm1)(long a, long b, long c, long d, long S, long D)
BEGIN
	ASM (CALL "prevlineasm1": RAX : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
END

TMPLV(vlineasm1)(long a, long b, long c, long d, long S, long D)
BEGINV
	ASM (CALL "vlineasm1": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
ENDV

TMPLV(setuptvlineasm)(long a)
BEGINV
	ASM (CALL "setuptvlineasm": : PAX : MEM,CC );
ENDV

TMPL(tvlineasm1)(long a, long b, long c, long d, long S, long D)
BEGIN
	ASM (CALL "tvlineasm1": RAX : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
END

TMPLV(setuptvlineasm2)(long a, long b, long c)
BEGINV
	ASM (CALL "setuptvlineasm2": : PAX,PBX,PCX : MEM,CC );
ENDV

TMPLV(tvlineasm2)(long a, long b, long c, long d, long S, long D)
BEGINV
	ASM (CALL "tvlineasm2": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
ENDV

TMPL(mvlineasm1)(long a, long b, long c, long d, long S, long D)
BEGIN
	ASM (CALL "mvlineasm1": RAX : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
END

TMPLV(setupvlineasm)(long a)
BEGINV
	ASM (CALL "setupvlineasm": : PAX : MEM,CC );
ENDV

TMPLV(vlineasm4)(long c, long D)
BEGINV
	ASM (CALL "vlineasm4": : PCX,PDI : AX,BX,DX,SI,MEM,CC );
ENDV

TMPLV(setupmvlineasm)(long a)
BEGINV
	ASM (CALL "setupmvlineasm": : PAX : MEM,CC );
ENDV

TMPLV(mvlineasm4)(long c, long D)
BEGINV
	ASM (CALL "mvlineasm4": : PCX,PDI : AX,BX,DX,SI,MEM,CC );
ENDV

TMPLV(setupspritevline)(long a, long b, long c, long d, long S, long D)
BEGINV
	ASM (CALL "setupspritevline": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
ENDV

TMPLV(spritevline)(long a, long b, long c, long d, long S, long D)
BEGINV
	ASM (CALL "spritevline": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
ENDV

TMPLV(msetupspritevline)(long a, long b, long c, long d, long S, long D)
BEGINV
	ASM (CALL "msetupspritevline": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
ENDV

TMPLV(mspritevline)(long a, long b, long c, long d, long S, long D)
BEGINV
	ASM (CALL "mspritevline": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
ENDV

TMPLV(tsetupspritevline)(long a, long b, long c, long d, long S, long D)
BEGINV
	ASM (CALL "tsetupspritevline": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
ENDV

TMPLV(tspritevline)(long a, long b, long c, long d, long S, long D)
BEGINV
	ASM (CALL "tspritevline": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
ENDV

TMPL(mhline)(long a, long b, long c, long d, long S, long D)
BEGIN
	ASM (CALL "mhline": RAX : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
END

TMPL(mhlineskipmodify)(long a, long b, long c, long d, long S, long D)
BEGIN
	ASM (CALL "mhlineskipmodify": RAX : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
END

TMPL(msethlineshift)(long a, long b)
BEGIN
	ASM (CALL "msethlineshift": RAX : PAX,PBX : MEM,CC );
END

TMPL(thline)(long a, long b, long c, long d, long S, long D)
BEGIN
	ASM (CALL "thline": RAX : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
END

TMPL(thlineskipmodify)(long a, long b, long c, long d, long S, long D)
BEGIN
	ASM (CALL "thlineskipmodify": RAX : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
END

TMPL(tsethlineshift)(long a, long b)
BEGIN
	ASM (CALL "tsethlineshift": RAX : PAX,PBX : MEM,CC );
END

TMPL(setupslopevlin)(long a, long b, long c)
BEGIN
	ASM (CALL "setupslopevlin": RAX : PAX,PBX,PCX : DX,MEM,CC );
END

TMPL(slopevlin)(long a, long b, long c, long d, long S, long D)
BEGIN
	ASM (CALL "slopevlin": RAX : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
END

TMPLV(settransnormal)(void)
BEGINV
	ASM (CALL "settransnormal": : : MEM,CC );
ENDV

TMPLV(settransreverse)(void)
BEGINV
	ASM (CALL "settransreverse": : : MEM,CC );
ENDV

TMPLV(setupdrawslab)(long a, long b)
BEGINV
	ASM (CALL "setupdrawslab": : PAX,PBX : MEM,CC );
ENDV

TMPLV(drawslab)(long a, long b, long c, long d, long S, long D)
BEGINV
	ASM (CALL "drawslab": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
ENDV

TMPLV(stretchhline)(long a, long b, long c, long d, long S, long D)
BEGINV
	ASM (CALL "stretchhline": : PAX,PBX,PCX,PDX,PSI,PDI : MEM,CC );
ENDV


#undef TMPL
#undef TMPLV
#undef BEGIN
#undef END
#undef BEGINV
#undef ENDV
#undef CALL
#undef RAX

#undef PAX
#undef PBX
#undef PCX
#undef PDX
#undef PSI
#undef PDI

#undef AX
#undef BX
#undef CX
#undef DX
#undef SI
#undef DI
#undef MEM

#undef PF
#undef ASM


#elif defined(USE_MSC_ASSEMBLY)	// USE_GCC_ASSEMBLY


#else				// USE_MSC_ASSEMBLY

#define ENGINE_USING_A_C

#endif	// else

#endif // __a_h__
