#ifdef WIN32
#include <winsock.h>
#endif

#include "osd.h"

#define MAXPLAYERS 16

#define GAMEPORT  0x4949


short myconnectindex = 0, numplayers = 0;
short connecthead, connectpoint2[MAXPLAYERS];
long myconnectnum, otherconnectnum, mypriority;
long connectnum[MAXPLAYERS];
struct sockaddr compaddr[MAXPLAYERS], mycompaddr;
int  sokt = -1;
char syncstate = 0;
char multioption = 0;


int initnetwork(void);
void stopnetwork(void);

/*

  The networking code only needs to forward packets to their intended recipients.
  How it does it is of no concern to the engine from what I can tell.

	Packet format for DUKE3D (specifically for network mode 1, n(n-1) mode):

	Example bunch of packets:
	A  B  C   D  E  F     G      H      I   J  K  L  M   N...       O
	---------------------------------------------------------------------
	d9 00 d9  11 01 00  -  -   -  -   -  -   -  -  -  -  4f       16 31
	da 00 da  11 01 00  -  -   -  -   -  -   -  -  -  -  b2       b7 9d
	db 00 db  11 01 00  -  -   -  -   -  -   -  -  -  -  b1       24 62
	dc 00 dc  11 01 00  -  -   -  -   -  -   -  -  -  -  ca       1d 58
	dd 00 dd  11 01 00  -  -   -  -   -  -   -  -  -  -  a9       94 14
	de 00 de  11 01 05  00 00  -  -   03 00  -  -  -  -  c5       50 b9
	df 00 df  11 01 0f  a1 ff  fe 09  00 00  26 -  -  -  e2       88 6f
	e0 00 e0  11 01 04  -  -   -  -   fd ff  -  -  -  -  77       51 d7
	e1 00 e1  11 01 03  1f 00  ff 09  -  -   -  -  -  -  ac       14 b7
	e2 00 e2  11 01 0b  9c 00  fb 09  -  -   24 -  -  -  f8       6c 22

	GAME sends fields D-N
	MMULTI adds fields A-C and O for error correction.

	A: Packet count sending modulo 256
	B: Error state.  Usually 0.  To request a resend, bit 0 is set.  In order
	      to catch up on networks, sending many packets is bad, so 2 packets
	      are sent in 1 IPX packet.  To send 2 packets in 1 packet, bit 1 is set.
	      In special cases, this value may be different.
	C: Packet count receiving modulo 256

	D: Message header byte.  These are all the possible values currently.  You
	      are probably only interested in case 17.  Note that fields E-N apply
	      to case 17 only.
	     0: send movement info from master to slave (network mode 0 only)
	     1: send movement info from slave to master (network mode 0 only)
	     4: user-typed messages
	     5: Re-start level with given parameters
	     6: Send player name
	     7: Play Remote Ridicule sound
	     8: Re-start level with given parameters for a user map
	    17: send movement info to everybody else (network mode 1 only)
	   250: Wait for Everybody (Don't start until everybody's done loading)
	   253: Signon [AAAABBBBBBBBBB] A=myconnectnum, B=mynetworkaddress
	   254: Signon acknowledgement
	   255: Player quit to DOS

	E: Timing byte used to calculate lag time.  This prevents the 2 computer's
	      timers from drifting apart.

	F: Bits field byte.  Fields G-M are sent only when certain bits
	      in this byte are set.

	G: X momentum update (2 bytes).  Sent only if ((F&1) != 0)

	H: Y momentum update (2 bytes).  Sent only if ((F&2) != 0)

	I: Angle momentum update (2 bytes).  Sent only if ((F&4) != 0)

	J: The states of 8 different keys (1 byte).  Sent only if ((F&8) != 0)
	K: The states of 8 different keys (1 byte).  Sent only if ((F&16) != 0)
	L: The states of 8 different keys (1 byte).  Sent only if ((F&32) != 0)
	M: The states of 8 different keys (1 byte).  Sent only if ((F&64) != 0)

	N: Sync checking byte.  Useful for debugging programming errors.  Can be a
	   variable number of bytes.  Actual number of sync checking bytes is
	   calculated by length of the whole packet minus the rest of the bytes sent.

	O: CRC-16

 */


//
// initmultiplayers
//   damultioption - 0 = singleplayer, !0 = network game
//   dacomrateoption - unused
//   dapriority - unused
//
void initmultiplayers(char damultioption, char dacomrateoption, char dapriority)
{
	int i;

	connecthead = 0;
	for(i=MAXPLAYERS-1;i>=0;i--)
		connectpoint2[i] = -1, connectnum[i] = 0x7fffffff;

	multioption = damultioption;

	if ((i = initnetwork()) != 0) {

	}
	numplayers=1;

	printOSD("initmultiplayers() called\n");
}


void uninitmultiplayers(void)
{
	if (numplayers > 0) {
		stopnetwork();
	}

	printOSD("uninitmultiplayers() called\n");
}


int netinitconnection (long newconnectnum, char *newcompaddr)
{
	long i, j, k, newindex, templong;
	char tempchar;

		//Check to see if connection number already initialized
	for(i=0;i<MAXPLAYERS;i++)
		if (connectnum[i] == newconnectnum) return(-1);

		//Find blank place to put new connection number
	newindex = 0;
	while (connectnum[newindex] != 0x7fffffff)
	{
		newindex++;
		if (newindex >= MAXPLAYERS) return(-1);  //Out of space! (more than 16 players)
	}

		//Insert connection number on connection number list
	numplayers++;
	connectnum[newindex] = newconnectnum;

		//Getinternetworkaddress
	//memcpy((void *)&compaddr[newindex][0],(void *)newcompaddr,10);
	//compaddr[newindex][10] = (socket&255);
	//compaddr[newindex][11] = (socket>>8);

		//Sort connection numbers
	for(i=1;i<MAXPLAYERS;i++)
		for(j=0;j<i;j++)
			if (connectnum[i] < connectnum[j])
			{
				templong = connectnum[i], connectnum[i] = connectnum[j], connectnum[j] = templong;
				for(k=0;k<12;k++) tempchar = compaddr[i][k], compaddr[i][k] = compaddr[j][k], compaddr[j][k] = tempchar;
			}

		//Rebuild linked list, MAKING SURE that the linked list goes through
		//   the players in the same order on all computers!
	connecthead = 0;
	for(i=0;i<numplayers-1;i++) connectpoint2[i] = i+1;
	connectpoint2[numplayers-1] = -1;

	for(i=0;i<numplayers;i++)
		if (connectnum[i] == myconnectnum) myconnectindex = i;

	return(1);
}

netuninitconnection(short goneindex)
{
	long i, j, k;

	connectnum[goneindex] = 0x7fffffff; numplayers--;

	j = 0;
	for(i=0;i<MAXPLAYERS;i++)
		if (connectnum[i] != 0x7fffffff)
		{
			if (j == 0) connecthead = i; else connectpoint2[k] = i;
			k = i; j++;
		}
	connectpoint2[k] = -1;
}


//
// sendpacket
//   other - who to send the packet to
//   bufptr - pointer to message to send
//   messleng - length of message
//
void sendpacket(long other, char *bufptr, long messleng)
{
	printOSD("sendpacket() called\n");
}


//
// getpacket (short *other, char *bufptr)
//   returns the number of bytes of the packet received, 0 if no packet
//   other - who the packet was received from
//   bufptr - pointer to message that was received
//
short getpacket (short *other, char *bufptr)
{
	printOSD("getpacket() called\n");
	return 0;
}


void processreservedmessage(short tempbufleng, char *datempbuf, struct sockaddr *sadr)
{
	long i, j, k, daotherconnectnum, templong;

	switch(datempbuf[0])
	{
		//[253] (login, if myconnectnum's lowest, then respond with packet type 254)
		case 253:
			daotherconnectnum = ((long)datempbuf[1])+((long)(datempbuf[2]<<8))+((long)(datempbuf[3]<<16))+((long)(datempbuf[4]<<24));
			if (daotherconnectnum != myconnectnum)
			{
				/* if the IP address we've been given is 0xffffffffl then we need to replace it with
				   the address we were given in sadr and then forward the packet to everyone we know
				   is already connected */
				if (datempbuf[5] == 255 && datempbuf[6] == 255 && datempbuf[7] == 255 && datempbuf[8] == 255) {
					*((long*)&datempbuf[5]) = (long)((struct sockaddr_in *)sadr)->sin_addr.s_addr;
				}

				netinitconnection(daotherconnectnum,&datempbuf[5]);

				if ((myconnectindex == connecthead) || ((connectnum[connecthead] == daotherconnectnum) && (myconnectindex == connectpoint2[connecthead])))
				{
					datempbuf[0] = 254;
					j = 1;
					for(i=0;i<MAXPLAYERS;i++)
						if ((connectnum[i] != 0x7fffffff) && (connectnum[i] != daotherconnectnum))
						{
							datempbuf[j++] = (connectnum[i]&255);
							datempbuf[j++] = ((connectnum[i]>>8)&255);
							datempbuf[j++] = ((connectnum[i]>>16)&255);
							datempbuf[j++] = ((connectnum[i]>>24)&255);

							for(k=0;k<10;k++)
								datempbuf[j++] = compaddr[i][k];
						}

						//While this doesn't have to be a broadcast, sending
						//this info again makes good error correction
					sendpacket(-1,datempbuf,j);

					for(i=0;i<MAXPLAYERS;i++)
						if (connectnum[i] == daotherconnectnum)
						{
							sendpacket((short)i,datempbuf,j);
							break;
						}
				}
			}
			break;
		case 254:  //[254][connectnum][connectnum]...(Packet type 253 response)
			j = 1;
			while (j < tempbufleng)
			{
				templong = ((long)datempbuf[j])+((long)(datempbuf[j+1]<<8))+((long)(datempbuf[j+2]<<16))+((long)(datempbuf[j+3]<<24));
				netinitconnection(templong,&datempbuf[j+4]);
				j += 14;
			}
			break;
		case 255:
			if (multioption >= 5)
				netuninitconnection(datempbuf[1]);
			break;
	}
}


void sendlogon(void)
{
	long i;
	char tempbuf[16];

	printOSD("sendlogon() called\n");

	if (multioption <= 0)
		return;

	tempbuf[0] = 253;
	tempbuf[1] = (myconnectnum&255);
	tempbuf[2] = ((myconnectnum>>8)&255);
	tempbuf[3] = ((myconnectnum>>16)&255);
	tempbuf[4] = ((myconnectnum>>24)&255);

	/* now, normally we'd want to send our IP address here.
	   while we can still do it, it won't work with NAT environments
	   since the address we'd end up sending will be the internal
	   address of our host, so we're going to have to make the master
	   whom we're connecting to work it out for us and fill in the
	   blanks when it sends the packet on to the other connections
	   already waiting in the game. To signify this I will send
	   0xFFFFFFFFl.

	   Other players will receive this packet with the IP address filled
	   and so will we, so we can get our own address that way.
	 */
	for(i=0;i<10;i++)
		tempbuf[i+5] = (i<4)?255:0;

	sendpacket(-1,tempbuf,15);
}


void sendlogoff(void)
{
	char tempbuf[16];
	long i;

	printOSD("sendlogoff() called\n");

	if ((numplayers <= 1) || (multioption <= 0)) return;

	tempbuf[0] = 255;
	tempbuf[1] = myconnectindex;
	for(i=connecthead;i>=0;i=connectpoint2[i])
		if (i != myconnectindex)
			sendpacket(i,tempbuf,2);
}


int getoutputcirclesize(void)
{
	return 0;
}


void setsocket(short newsocket)
{
}


void flushpackets(void)
{
	printOSD("flushpackets()\n");
}



//
// initnetwork
//   Returns 0 on success
//           1 on ...
//
int initnetwork(void)
{
	// clear out the connections
	memset(compaddr, 0, sizeof(compaddr));
	memset(&mycompaddr, 0, sizeof(mycompaddr));

	mycompaddr.sa_family = AF_INET;
	(mycompaddr).sa_

	return 0;
}


//
// stopnetwork
//
void stopnetwork(void)
{
}
