// UDP multiplayer interface to mmulti.c
// for the Build Engine
// by Jonathon Fowler

#include "mmulti.h"

#ifdef WINDOWS
#  define WIN32_LEAN_AND_MEAN
#  include <windows.h>
#  include <winsock2.h>
#else
#endif

#define DEFSOCKET 34859		// default COMMIT IPX socket incidentally...


typedef struct {
	struct sockaddr_in address;
	int next;
} head;

static head heads[MAXPLAYERS];
static int firsthead=0;

static char netstarted = 0;

static struct in_addr server;
static int    port;


// The most evil and nasty game mustering protocol for the Build engine
// by Jonathon Fowler (3 April 2003 1am in case you're wondering)
//
// This is the best I could come up with under the circumstances. I've
// never had to design anything of this sort, nor have I researched anything
// so let's hope this will suffice.
//
// Packets look like this:
// 
// 0xFFFFFFFF                      <-- just an "escape" marker
//                                     Duke3D uses 0xff as the signoff packet
//                                     so if someone shoots one of these packets
//                                     at a client it'll have to see if it was followed
//                                     by another three plus the sig below to see
//                                     if it was someone trying to join a game rather
//                                     than just quitting. Sound fair? I thought so.
// 'K' 'S' 'J' 'F'                 <-- Ken Silverman, Jonathon Fowler (naturally)
// 'K' 'E' 'N' 'B' 'U' 'I' 'L' 'D' <-- replaced by an 8-byte identifier for the game
// 0x00010000                      <-- game version
// 0x0000 0x0000                   <-- packet type and data payload length
// ...                             <-- data payload
//
// Packet Types:
//   0 - Probe for game, supplying the port being listened on
//       Host replies with information about game status.
//          char[32]     <-- server description
//          char         <-- max players
//          char         <-- current players
//          char         <-- game type (0 = coop, 1 = deathmatch)
//          char         <-- game state (0 = joining, 1 = in progress)
//          ulong        <-- map file size
//          ushort       <-- crc16 of map data
//          char[]       <-- map filename
//   1 - Join game
//          char[32]     <-- handle
//          ushort       <-- port being listened on
//   2 - Player joined
//          Sent by the host to all other currently joined heads
//          including the person who joined
//          char[32]     <-- handle
//          char         <-- connect point #
//          ushort       <-- port joiner listens on
//          ulong        <-- ipv4 address of joiner
//          char         <-- max players
//          char         <-- current players
//          char         <-- game type (0 = coop, 1 = deathmatch)
//          char         <-- game state (0 = joining, 1 = in progress)
//          ulong        <-- map file size
//          ushort       <-- crc16 of map data
//          char[]       <-- map filename
//   3 - Player left, supplying ip and port
//          Sent by the host to all other currently joined heads
//          char         <-- connect point #
//          ushort       <-- port leaver listened on
//          ulong        <-- ipv4 address of leaver
//   4 - Player spoke, supplying text (for a pre-game lobby chat maybe?)
//          char[]       <-- chat text
//   256 - Game started



static void SendNetworkPacket(void)
{
	//*****************************
	// Put Send code here:
	//    gcom.other contains destination address
	//    gcom.buffer holds data to send
	//    gcom.numbytes holds amount of data to send
	//*****************************
}

static void GetNetworkPacket(void)
{
	//*****************************
	// Put Get code here:
	//    gcom.other should be set to -1 if no packet is ready,
	//                  otherwise it should be set to the address of
	//                  the packet sender
	//    gcom.buffer   copy your data to this buffer
	//    gcom.numbytes fill in how much of it is there
	//*****************************
}


// basically the COMMIT isr rewired
void callcommit(void)
{
	short i;

	switch (gcom.command) {
		case CMD_SEND:
			SendNetworkPacket();
			break;

		case CMD_SENDTOALL:
			for (i=0; i<numplayers; i++) {
				gcom.other = i;
				SendNetworkPacket();
			}
			break;
			
		case CMD_SENDTOALLOTHERS:
			for (i=0; i<numplayers; i++) {
				if (i != myconnectindex) {
					gcom.other = i;
					SendNetworkPacket();
				}
			}
			break;

		case CMD_GET:
			GetNetworkPacket();
			break;
			
		case CMD_SCORE:
			//***********************************
			//SCORE specific stuff here
			//***********************************
			break;
	}
}


// initialize networking and prepare for waiting
int setupmultiplayergame(void)
{
#ifdef WINDOWS
	WSADATA wsa;

	if (!netstarted) {
		if (WSAStartup( MAKEWORD(2,0), &wsa )) return 1;
		if (LOBYTE(wsa.wVersion) != 2 || HIBYTE(wsa.wVersion) != 0) return 1;
	}
#endif

	numplayers = 1;
	myconnectindex = 0;

	netstarted = 1;

	return 0;
}


// used to poll game join status
int fillmultiplayergame(void)
{
	if (!netstarted) return 1;

	return 0;
}


// joins into a game which is filling
int joinmultiplayergame(const char *daserver, unsigned short daport)
{
	struct hostent *he;

	if (!netstarted) return 1;

	he = gethostbyname(daserver);
	if (!he) return 1;

	memcpy(&server, &he->h_addr_list[0], he->h_length);
	port = daport;

	return 0;
}


// shut down networking
void endmultiplayergame(void)
{
#ifdef WINDOWS
	if (netstarted) {
		WSACleanup();
	}
#endif

	netstarted = 0;
}

