// Microsoft Windows WAV loader
// Build DirectSound system
// by Jonathon Fowler (jonof@edgenetwk.com)


#include <string.h>
#include <stdio.h>
#include "cache1d.h"
#include "compat.h"
#include "buildsound.h"


//
// ReadWAVInfo() -- read header information and calculate buffer size
//    required to load sound into memory
//
//   Returns 0 on success. snd->soundlength is the required buffer length.
//   Returns -1 if not a WAV file.
//   Returns -3 if data format is unsupported.
//
int ReadWAVInfo(int fh, SoundInfo *snd)
{
	long id;
	long len;
	long tmp;
	short tmp2;
	int expect = 0;	// 0 = fmt, 1 = data, 2 = end


	memset(snd, 0, sizeof(SoundInfo));

	klseek(fh, 0, SEEK_SET);

	kread(fh, &id, 4);
	if (id != ('R' | ('I' << 8) | ('F' << 16) | ('F' << 24)))
		return -1;

	kread(fh, &len, 4);
	kread(fh, &id, 4);
	if (id != ('W' | ('A' << 8) | ('V' << 16) | ('E' << 24)))
		return -1;

	while (kread(fh, &id, 4) == 4) {
		kread(fh, &len, 4);

		if (expect == 0 && id == ('f' | ('m' << 8) | ('t' << 16) | (' ' << 24))) {
			expect = 1;

			kread(fh, &tmp2, 2);	// wFormatTag
			if (tmp2 != 1) return -3;

			kread(fh, &tmp2, 2);	// wChannels
			if (tmp2 != 1 && tmp2 != 2) return -3;

			snd->channels = tmp2;

			kread(fh, &tmp, 4);	// dwSamplesPerSec
			snd->samplerate = tmp;

			kread(fh, &tmp, 4);	// dwAvgBytesPerSec
			kread(fh, &tmp2, 2);	// wBlockAlign

			kread(fh, &tmp2, 2);	// wBitsPerSample
			if (tmp2 != 8 && tmp2 != 16) return -3;

			snd->bitspersample = tmp2;
		} else if (expect == 1 && id == ('d' | ('a' << 8) | ('t' << 16) | ('a' << 24))) {
			expect = 2;

			snd->soundlength = len;

			return 0;
		} else {
			// unknown chunk or wrong ordering
			klseek(fh, len, SEEK_CUR);
		}
	}

	return 0;
}


//
// ReadWAVData -- read the WAV sound data into the preallocated buffer
//   of length indicated by bufferlen
//
int ReadWAVData(int fh, char *data, int bufferlen)
{
	long id;
	long len;

	klseek(fh, 12, SEEK_SET);

	while (kread(fh, &id, 4) == 4) {
		kread(fh, &len, 4);

		if (id == ('d' | ('a' << 8) | ('t' << 16) | ('a' << 24))) {
			kread(fh, data, min(len, bufferlen));

			return 0;
		} else {
			// unknown chunk or wrong ordering
			klseek(fh, len, SEEK_CUR);
		}
	}

	return 0;
}
